/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.dbs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.DBAttrMapper;
import com.netscape.certsrv.dbs.EDBException;
import com.netscape.certsrv.dbs.FilterConverter;
import com.netscape.certsrv.dbs.IDBObj;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.dbs.DBRegistry;
import com.netscape.cmscore.dbs.LdapFilterConverter;
import com.netscape.cmscore.dbs.NameAndObject;
import com.netscape.cmscore.request.DBDynAttrMapper;
import java.lang.invoke.CallSite;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPRegistry
extends DBRegistry {
    public static final Logger logger = LoggerFactory.getLogger(LDAPRegistry.class);
    private ConfigStore mConfig = null;
    private Hashtable<String, String[]> mOCclassNames = new Hashtable();
    private Hashtable<String, NameAndObject> mOCldapNames = new Hashtable();
    private Hashtable<String, DBAttrMapper> mAttrufNames = new Hashtable();
    private FilterConverter mConverter;
    private Vector<DBDynAttrMapper> mDynAttrMappers = new Vector();

    @Override
    public String getId() {
        return "dbsregistry";
    }

    @Override
    public void setId(String id) throws EBaseException {
        throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_OPERATION", new String[0]));
    }

    @Override
    public void init(ConfigStore config) throws EBaseException {
        this.mConfig = config;
        this.mConverter = new LdapFilterConverter(this.mAttrufNames);
    }

    @Override
    public ConfigStore getConfigStore() {
        return this.mConfig;
    }

    @Override
    public void startup() throws EBaseException {
    }

    @Override
    public void shutdown() {
        this.mOCclassNames.clear();
        this.mOCldapNames.clear();
        this.mAttrufNames.clear();
    }

    @Override
    public void registerObjectClass(String className, String[] ldapNames) throws EDBException {
        try {
            Class<?> c = Class.forName(className);
            this.mOCclassNames.put(className, ldapNames);
            this.mOCldapNames.put(this.sortAndConcate(ldapNames).toLowerCase(), new NameAndObject(className, c));
        }
        catch (ClassNotFoundException e) {
            logger.error("LDAPRegistry: " + CMS.getUserMessage("CMS_DBS_INVALID_CLASS_NAME", className), (Throwable)e);
            throw new EDBException(CMS.getUserMessage("CMS_DBS_INVALID_CLASS_NAME", className), (Throwable)e);
        }
    }

    @Override
    public boolean isObjectClassRegistered(String className) {
        return this.mOCclassNames.containsKey(className);
    }

    @Override
    public void registerAttribute(String ufName, DBAttrMapper mapper) throws EDBException {
        this.mAttrufNames.put(ufName.toLowerCase(), mapper);
    }

    @Override
    public boolean isAttributeRegistered(String ufName) {
        return this.mAttrufNames.containsKey(ufName.toLowerCase());
    }

    @Override
    public void registerDynamicMapper(DBDynAttrMapper mapper) {
        this.mDynAttrMappers.add(mapper);
    }

    @Override
    public String getFilter(String filter) throws EBaseException {
        return this.getFilter(filter, this.mConverter);
    }

    @Override
    public String getFilter(String filter, FilterConverter c) throws EBaseException {
        String f = filter;
        if ((f = f.trim()).startsWith("(") && f.endsWith(")")) {
            return "(" + this.getFilterComp(f.substring(1, f.length() - 1), c) + ")";
        }
        return this.getFilterComp(filter, c);
    }

    private String getFilterComp(String f, FilterConverter c) throws EBaseException {
        if ((f = f.trim()).startsWith("&")) {
            return "&" + this.getFilterList(f.substring(1, f.length()), c);
        }
        if (f.startsWith("|")) {
            return "|" + this.getFilterList(f.substring(1, f.length()), c);
        }
        if (f.startsWith("!")) {
            return "!" + this.getFilter(f.substring(1, f.length()), c);
        }
        return this.getFilterItem(f, c);
    }

    private String getFilterList(String f, FilterConverter c) throws EBaseException {
        f = f.trim();
        int level = 0;
        int start = 0;
        int end = 0;
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < f.length(); ++i) {
            if (f.charAt(i) == '(') {
                if (level == 0) {
                    start = i;
                }
                ++level;
            }
            if (f.charAt(i) != ')' || --level != 0) continue;
            end = i;
            String filter = this.getFilter(f.substring(start, end + 1), c);
            v.addElement(filter);
        }
        return this.inStringFormat(v);
    }

    private String inStringFormat(Vector<String> v) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < v.size(); ++i) {
            result.append(v.elementAt(i));
        }
        return result.toString();
    }

    private String getFilterItem(String f, FilterConverter c) throws EBaseException {
        int idx = (f = f.trim()).indexOf(61);
        if (idx == -1) {
            throw new EDBException(CMS.getUserMessage("CMS_DBS_INVALID_FILTER_ITEM", "="));
        }
        String type = f.substring(0, idx).trim();
        String value = f.substring(idx + 1).trim();
        if ((type = type.trim()).endsWith("~")) {
            String name = type.substring(0, type.length() - 1).trim();
            return c.convert(name, "~=", value);
        }
        if (type.endsWith("!")) {
            String name = type.substring(0, type.length() - 1).trim();
            return c.convert(name, "!=", value);
        }
        if (type.endsWith(">")) {
            String name = type.substring(0, type.length() - 1).trim();
            return c.convert(name, ">=", value);
        }
        if (type.endsWith("<")) {
            String name = type.substring(0, type.length() - 1).trim();
            return c.convert(name, "<=", value);
        }
        if (value.startsWith("*") && value.length() == 1) {
            return c.convert(type, "=", "*");
        }
        if (value.indexOf(42) == -1) {
            if (type.equalsIgnoreCase("objectclass")) {
                String[] ldapNames = this.mOCclassNames.get(value);
                if (ldapNames == null) {
                    throw new EDBException(CMS.getUserMessage("CMS_DBS_INVALID_FILTER_ITEM", f));
                }
                StringBuffer filter = new StringBuffer();
                for (int g = 0; g < ldapNames.length; ++g) {
                    filter.append("(objectclass=" + ldapNames[g] + ")");
                }
                return "&" + filter.toString();
            }
            return c.convert(type, "=", value);
        }
        return c.convert(type, "=", value);
    }

    @Override
    public void mapObject(IDBObj parent, String name, Object obj, LDAPAttributeSet attrs) throws EBaseException {
        DBAttrMapper mapper = this.mAttrufNames.get(name.toLowerCase());
        if (mapper == null) {
            return;
        }
        mapper.mapObjectToLDAPAttributeSet(parent, name, obj, attrs);
    }

    @Override
    public String[] getLDAPAttributes(String[] attrs) throws EBaseException {
        if (attrs == null) {
            return null;
        }
        LinkedHashSet<CallSite> v = new LinkedHashSet<CallSite>();
        logger.debug("LDAPRegistry: mapping attributes:");
        for (int i = 0; i < attrs.length; ++i) {
            String attr = attrs[i];
            logger.debug("LDAPRegistry: - " + attr);
            String prefix = "";
            if (attr.startsWith("-")) {
                attr = attr.substring(1);
                prefix = "-";
            }
            if (attr.equalsIgnoreCase("objectclass")) {
                v.add((CallSite)((Object)(prefix + attr)));
                continue;
            }
            if (this.isAttributeRegistered(attr)) {
                logger.debug("LDAPRegistry:   attribute is registered");
                DBAttrMapper mapper = this.mAttrufNames.get(attr.toLowerCase());
                if (mapper == null) {
                    throw new EDBException(CMS.getUserMessage("CMS_DBS_INVALID_ATTRS", new String[0]));
                }
                Enumeration<String> e = mapper.getSupportedLDAPAttributeNames();
                while (e.hasMoreElements()) {
                    String s = e.nextElement();
                    v.add((CallSite)((Object)(prefix + s)));
                }
                continue;
            }
            logger.debug("LDAPRegistry:   checking dynamic mapper");
            DBDynAttrMapper matchingDynAttrMapper = null;
            for (DBDynAttrMapper dynAttrMapper : this.mDynAttrMappers) {
                if (!dynAttrMapper.supportsLDAPAttributeName(attr)) continue;
                logger.debug("LDAPRegistry:   found dynamic mapper: " + dynAttrMapper);
                matchingDynAttrMapper = dynAttrMapper;
                break;
            }
            if (matchingDynAttrMapper != null) {
                v.add((CallSite)((Object)(prefix + attr)));
                continue;
            }
            logger.error("LDAPRegistry: " + CMS.getLogMessage("CMSCORE_DBS_ATTR_NOT_REGISTER", attr));
            throw new EDBException(CMS.getLogMessage("CMSCORE_DBS_ATTR_NOT_REGISTER", attr));
        }
        if (v.size() == 0) {
            return null;
        }
        String[] ldapAttrs = new String[v.size()];
        v.toArray(ldapAttrs);
        return ldapAttrs;
    }

    @Override
    public LDAPAttributeSet createLDAPAttributeSet(IDBObj obj) throws EBaseException {
        String[] ocNames;
        Enumeration<String> e = obj.getSerializableAttrNames();
        LDAPAttributeSet attrs = new LDAPAttributeSet();
        String className = obj.getClass().getName();
        for (String ocName : ocNames = this.mOCclassNames.get(className)) {
            logger.debug("LDAPRegistry: Adding object class " + ocName);
        }
        attrs.add(new LDAPAttribute("objectclass", ocNames));
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            Object value = obj.get(name);
            if (value == null) {
                logger.debug("LDAPRegistry: Skipping empty attribute " + name);
                continue;
            }
            logger.debug("LDAPRegistry: Mapping attribute " + name);
            this.mapObject(obj, name, value, attrs);
        }
        return attrs;
    }

    @Override
    public IDBObj createObject(LDAPAttributeSet attrs) throws EDBException {
        LDAPAttribute attr = attrs.getAttribute("objectclass");
        if (attr == null) {
            throw new EDBException(CMS.getLogMessage("CMS_DBS_MISSING_OBJECT_CLASS", new Object[0]));
        }
        attrs.remove("objectclass");
        String[] s = attr.getStringValueArray();
        String sorted = this.sortAndConcate(s).toLowerCase();
        NameAndObject no = this.mOCldapNames.get(sorted);
        if (no == null) {
            throw new EDBException(CMS.getUserMessage("CMS_DBS_INVALID_CLASS_NAME", sorted));
        }
        Class c = (Class)no.getObject();
        try {
            IDBObj obj = (IDBObj)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Enumeration<String> ee = obj.getSerializableAttrNames();
            while (ee.hasMoreElements()) {
                String oname = ee.nextElement();
                DBAttrMapper mapper = this.mAttrufNames.get(oname.toLowerCase());
                if (mapper == null) {
                    throw new EDBException(CMS.getUserMessage("CMS_DBS_NO_MAPPER_FOUND", oname));
                }
                mapper.mapLDAPAttributeSetToObject(attrs, oname, obj);
            }
            return obj;
        }
        catch (Exception e) {
            logger.error("LDAPRegistry: " + CMS.getUserMessage("CMS_DBS_INVALID_ATTRS", new String[0]) + ": " + e.getMessage(), (Throwable)e);
            throw new EDBException(CMS.getUserMessage("CMS_DBS_INVALID_ATTRS", new String[0]) + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private String sortAndConcate(String[] s) {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < s.length; ++i) {
            for (int j = 0; j < v.size(); ++j) {
                String t = v.elementAt(j);
                if (s[i].compareTo(t) >= 0) continue;
                v.insertElementAt(s[i], j);
                break;
            }
            if (i == v.size() - 1) continue;
            v.addElement(s[i]);
        }
        return this.inStringFormat(v);
    }
}

