/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.crmf;

import com.netscape.cmscore.crmf.PKIArchiveOptionsContainer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.pkix.crmf.CertReqMsg;
import org.mozilla.jss.pkix.crmf.CertRequest;
import org.mozilla.jss.pkix.crmf.PKIArchiveOptions;
import org.mozilla.jss.pkix.primitive.AVA;

public class CRMFParser {
    private static final OBJECT_IDENTIFIER PKIARCHIVEOPTIONS_OID = new OBJECT_IDENTIFIER(new long[]{1L, 3L, 6L, 1L, 5L, 5L, 7L, 5L, 1L, 4L});

    public static PKIArchiveOptionsContainer[] getPKIArchiveOptions(String crmfBlob) throws IOException {
        Vector<PKIArchiveOptionsContainer> options = new Vector<PKIArchiveOptionsContainer>();
        byte[] crmfBerBlob = null;
        crmfBerBlob = Utils.base64decode((String)crmfBlob);
        if (crmfBerBlob == null) {
            throw new IOException("no CRMF data found");
        }
        ByteArrayInputStream crmfBerBlobIn = new ByteArrayInputStream(crmfBerBlob);
        SEQUENCE crmfmsgs = null;
        try {
            crmfmsgs = (SEQUENCE)new SEQUENCE.OF_Template((ASN1Template)new CertReqMsg.Template()).decode((InputStream)crmfBerBlobIn);
        }
        catch (IOException e) {
            throw new IOException("[crmf msgs]" + e.toString());
        }
        catch (InvalidBERException e) {
            throw new IOException("[crmf msgs]" + e.toString());
        }
        for (int z = 0; z < crmfmsgs.size(); ++z) {
            CertReqMsg certReqMsg = (CertReqMsg)crmfmsgs.elementAt(z);
            CertRequest certReq = certReqMsg.getCertReq();
            AVA archAva = null;
            try {
                for (int i = 0; i < certReq.numControls(); ++i) {
                    AVA ava = certReq.controlAt(i);
                    OBJECT_IDENTIFIER oid = ava.getOID();
                    if (!oid.equals((Object)PKIARCHIVEOPTIONS_OID)) continue;
                    archAva = ava;
                    break;
                }
            }
            catch (Exception e) {
                throw new IOException("no PKIArchiveOptions found " + e.toString());
            }
            if (archAva == null) continue;
            ANY archVal = archAva.getValue();
            ByteArrayInputStream bis = new ByteArrayInputStream(ASN1Util.encode((ASN1Value)archVal));
            PKIArchiveOptions archOpts = null;
            try {
                archOpts = (PKIArchiveOptions)new PKIArchiveOptions.Template().decode((InputStream)bis);
            }
            catch (IOException e) {
                throw new IOException("[PKIArchiveOptions]" + e.toString());
            }
            catch (InvalidBERException e) {
                throw new IOException("[PKIArchiveOptions]" + e.toString());
            }
            options.addElement(new PKIArchiveOptionsContainer(archOpts, z));
        }
        if (options.size() == 0) {
            throw new IOException("no PKIArchiveOptions found");
        }
        Object[] p = new PKIArchiveOptionsContainer[options.size()];
        options.copyInto(p);
        return p;
    }
}

