/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.connector;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.connector.HttpConnection;
import com.netscape.cmscore.connector.RemoteAuthority;
import com.netscape.cmsutil.http.JssSSLSocketFactory;
import com.netscape.cmsutil.net.ISocketFactory;
import org.mozilla.jss.ssl.SSLSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnFactory {
    public static Logger logger = LoggerFactory.getLogger(HttpConnFactory.class);
    protected CMSEngine engine;
    protected int mMinConns = 1;
    protected int mMaxConns = 30;
    private int mNumConns = 0;
    private int mTotal = 0;
    private HttpConnection[] mConns;
    private RemoteAuthority mDest;
    private String mNickname = "";
    private String mClientCiphers = null;
    private int mTimeout = 0;

    public HttpConnFactory() {
    }

    public HttpConnFactory(int minConns, int maxConns, RemoteAuthority dest, String nickname, String clientCiphers, int timeout) {
        logger.debug("In HttpConnFactory constructor mTimeout " + timeout);
        this.mMinConns = minConns;
        this.mMaxConns = maxConns;
        this.mClientCiphers = clientCiphers;
        if (this.mClientCiphers != null) {
            logger.debug("In HttpConnFactory constructor mClientCiphers: " + this.mClientCiphers);
        } else {
            logger.debug("In HttpConnFactory constructor mClientCiphers not specified, will take default ");
        }
        this.mDest = dest;
        this.mNickname = nickname;
        this.mTimeout = timeout;
    }

    public CMSEngine getCMSEngine() {
        return this.engine;
    }

    public void setCMSEngine(CMSEngine engine) {
        this.engine = engine;
    }

    public void init() throws EBaseException {
        logger.debug("HttpConnFactory: min conns: " + this.mMinConns);
        if (this.mMinConns <= 0) {
            throw new EBaseException("HttpConnFactory: Invalid minimum connection: " + this.mMinConns);
        }
        logger.debug("HttpConnFactory: max conns: " + this.mMaxConns);
        if (this.mMaxConns <= 0) {
            throw new EBaseException("HttpConnFactory: Invalid maximum connection: " + this.mMaxConns);
        }
        if (this.mMinConns > this.mMaxConns) {
            throw new EBaseException("HttpConnFactory: Invalid minimum and maximum connections");
        }
        logger.debug("before creating httpconn array");
        this.mConns = new HttpConnection[this.mMaxConns];
        logger.debug("before makeConnection");
        logger.debug("initializing HttpConnFactory with mininum " + this.mMinConns + " and maximum " + this.mMaxConns + " connections to ");
        logger.debug("leaving HttpConnFactory init.");
    }

    private HttpConnection createConnection() throws EBaseException {
        HttpConnection retConn = null;
        logger.debug("In HttpConnFactory.createConnection.");
        try {
            JssSSLSocketFactory tFactory;
            JssSSLSocketFactory factory = tFactory = new JssSSLSocketFactory(this.mNickname, this.mClientCiphers);
            factory.addSocketListener((SSLSocketListener)this.engine.getClientSocketListener());
            retConn = this.mTimeout == 0 ? new HttpConnection(this.mDest, (ISocketFactory)tFactory) : new HttpConnection(this.mDest, (ISocketFactory)tFactory, this.mTimeout);
            retConn.setCMSEngine(this.engine);
            retConn.init();
        }
        catch (Exception e) {
            String message = "Unable to create HTTP connection: " + e.getMessage();
            logger.error(message, (Throwable)e);
            throw new EBaseException(message, (Throwable)e);
        }
        return retConn;
    }

    private void makeMinimum() throws EBaseException {
        logger.debug("In HttpConnFactory.makeMinimum.");
        if (this.mNumConns < this.mMinConns && this.mTotal <= this.mMaxConns) {
            int increment = Math.min(this.mMinConns - this.mNumConns, this.mMaxConns - this.mTotal);
            if (increment == 0) {
                return;
            }
            logger.debug("increasing minimum connections by " + increment);
            for (int i = increment - 1; i >= 0; --i) {
                this.mConns[i] = this.createConnection();
            }
            this.mTotal += increment;
            this.mNumConns += increment;
            logger.debug("new total available http connections " + this.mTotal);
            logger.debug("new number of http connections " + this.mNumConns);
        }
    }

    public HttpConnection getConn() throws EBaseException {
        return this.getConn(true);
    }

    public synchronized HttpConnection getConn(boolean waitForConn) throws EBaseException {
        boolean waited = false;
        logger.debug("In HttpConnFactory.getConn");
        if (this.mNumConns == 0) {
            this.makeMinimum();
        }
        if (this.mNumConns == 0) {
            if (!waitForConn) {
                return null;
            }
            try {
                logger.warn("HttpConnFactory: Ran out of HTTP connections");
                waited = true;
                logger.debug("HttpConn:about to wait for a new http connection");
                while (this.mNumConns == 0) {
                    this.wait();
                }
                logger.debug("HttpConn:done waiting for new http connection");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        --this.mNumConns;
        HttpConnection conn = this.mConns[this.mNumConns];
        this.mConns[this.mNumConns] = null;
        if (waited) {
            logger.warn("HttpConn:had to wait for an available connection from pool");
            logger.warn("Http connections are available again in http connection pool");
        }
        logger.debug("HttpgetConn: mNumConns now " + this.mNumConns);
        return conn;
    }

    public synchronized void returnConn(HttpConnection conn) {
        logger.debug("In HttpConnFactory.returnConn");
        if (conn == null) {
            return;
        }
        HttpConnection boundconn = conn;
        for (int i = 0; i < this.mNumConns; ++i) {
            if (this.mConns[i] != conn) continue;
            logger.debug("returnConn: previously returned connection. " + conn);
        }
        this.mConns[this.mNumConns++] = boundconn;
        logger.debug("HttpreturnConn: mNumConns now " + this.mNumConns);
        this.notify();
    }
}

