/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.base;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.InitializationValues;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.util.Password;
import org.mozilla.jss.util.PasswordCallback;
import org.mozilla.jss.util.PasswordCallbackInfo;

public class JDialogPasswordCallback
implements PasswordCallback {
    public Password getPasswordFirstAttempt(PasswordCallbackInfo info) throws PasswordCallback.GiveUpException {
        return this.getPW(info, false);
    }

    public Password getPasswordAgain(PasswordCallbackInfo info) throws PasswordCallback.GiveUpException {
        return this.getPW(info, true);
    }

    private void resetGBC(GridBagConstraints gbc) {
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.anchor = 10;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
    }

    public String getPrompt(PasswordCallbackInfo info) {
        return "Enter the password for \"" + info.getName() + "\": ";
    }

    private Password getPW(PasswordCallbackInfo info, boolean retry) throws PasswordCallback.GiveUpException {
        final PWHolder pwHolder = new PWHolder();
        final JFrame f = new JFrame("Password Dialog");
        final JPasswordField pwField = new JPasswordField(15);
        JPanel contentPane = new JPanel(new GridBagLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        GridBagConstraints c = new GridBagConstraints();
        if (retry) {
            JLabel warning = new JLabel("Password incorrect.");
            warning.setForeground(Color.red);
            this.resetGBC(c);
            c.anchor = 18;
            c.gridwidth = 0;
            contentPane.add((Component)warning, c);
        }
        String prompt = this.getPrompt(info);
        JLabel label = new JLabel(prompt);
        label.setForeground(Color.black);
        this.resetGBC(c);
        c.anchor = 18;
        c.gridwidth = 0;
        contentPane.add((Component)label, c);
        ActionListener getPasswordListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                pwHolder.password = new Password(pwField.getPassword());
                pwHolder.cancelled = false;
                f.dispose();
            }
        };
        pwField.setFont(new Font("Monospaced", 0, pwField.getFont().getSize()));
        pwField.setEchoChar('*');
        pwField.addActionListener(getPasswordListener);
        this.resetGBC(c);
        c.anchor = 10;
        c.fill = 0;
        c.insets = new Insets(16, 0, 0, 0);
        c.gridwidth = 0;
        contentPane.add((Component)pwField, c);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        JButton ok = new JButton(" OK ");
        ok.addActionListener(getPasswordListener);
        this.resetGBC(c);
        c.fill = 0;
        c.anchor = 10;
        c.gridheight = 0;
        c.insets = new Insets(10, 0, 0, 4);
        buttonPanel.add((Component)ok, c);
        JButton cancel = new JButton("Cancel");
        ActionListener buttonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                pwHolder.cancelled = true;
                f.dispose();
            }
        };
        cancel.addActionListener(buttonListener);
        this.resetGBC(c);
        c.fill = 0;
        c.anchor = 10;
        c.insets = new Insets(10, 4, 0, 0);
        c.gridheight = 0;
        c.gridwidth = 0;
        buttonPanel.add((Component)cancel, c);
        this.resetGBC(c);
        c.fill = 0;
        c.anchor = 10;
        c.gridwidth = 0;
        c.gridheight = 0;
        c.insets = new Insets(0, 0, 0, 0);
        contentPane.add((Component)buttonPanel, c);
        JDialog d = new JDialog(f, "Fedora Certificate System", true);
        WindowAdapter windowListener = new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                pwField.requestFocus();
            }
        };
        d.addWindowListener(windowListener);
        d.setContentPane(contentPane);
        d.pack();
        Dimension screenSize = d.getToolkit().getScreenSize();
        Dimension paneSize = d.getSize();
        d.setLocation((screenSize.width - paneSize.width) / 2, (screenSize.height - paneSize.height) / 2);
        d.getRootPane().setDefaultButton(ok);
        d.setVisible(true);
        if (pwHolder.cancelled) {
            throw new PasswordCallback.GiveUpException();
        }
        return pwHolder.password;
    }

    public static void main(String[] args) {
        try {
            InitializationValues iv = new InitializationValues(args[0]);
            CryptoManager.initialize((InitializationValues)iv);
            CryptoManager manager = CryptoManager.getInstance();
            CryptoToken tok = manager.getInternalKeyStorageToken();
            tok.login((PasswordCallback)new JDialogPasswordCallback());
            System.out.println("Logged in!!!");
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private static class PWHolder {
        public Password password = null;
        public boolean cancelled = true;

        private PWHolder() {
        }
    }
}

