/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.authorization.EAuthzException;
import com.netscape.certsrv.base.BadRequestDataException;
import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.ca.AuthorityID;
import com.netscape.certsrv.ca.CANotFoundException;
import com.netscape.certsrv.cert.CertReviewResponse;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.CertRequestProcessedEvent;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.profile.ERejectException;
import com.netscape.certsrv.profile.PolicyDefault;
import com.netscape.certsrv.profile.ProfileAttribute;
import com.netscape.certsrv.profile.ProfileOutput;
import com.netscape.certsrv.profile.ProfilePolicySet;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cms.profile.common.Profile;
import com.netscape.cms.profile.common.ProfileConfig;
import com.netscape.cms.profile.common.ProfilePolicy;
import com.netscape.cms.profile.constraint.PolicyConstraint;
import com.netscape.cms.servlet.cert.CertProcessor;
import com.netscape.cms.servlet.cert.CertReviewResponseFactory;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.profile.ProfileOutputFactory;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.request.Request;
import java.math.BigInteger;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestProcessor
extends CertProcessor {
    public static Logger logger = LoggerFactory.getLogger(RequestProcessor.class);

    public RequestProcessor(String id, Locale locale) {
        super(id, locale);
    }

    public CertReviewResponse processRequest(CMSRequest cmsReq, String op) throws EBaseException {
        HttpServletRequest request = cmsReq.getHttpReq();
        Request ireq = cmsReq.getRequest();
        String profileId = ireq.getExtDataInString("profileId");
        CAEngine engine = CAEngine.getInstance();
        Profile profile = this.ps.getProfile(profileId);
        CertReviewResponse data = CertReviewResponseFactory.create(cmsReq, profile, engine.getEnableNonces(), this.locale);
        AuthToken authToken = null;
        if (this.authMgr != null) {
            logger.debug("RequestProcessor: getting auth token from " + this.authMgr);
            authToken = this.authenticate(request);
        }
        this.processRequest(request, authToken, data, ireq, op);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(HttpServletRequest request, AuthToken authToken, CertReviewResponse data, Request req, String op) throws EBaseException {
        try {
            String profileId;
            AuthzToken authzToken;
            this.startTiming("approval");
            if (logger.isDebugEnabled()) {
                HashMap params = data.toParams();
                this.printParameterValues(params);
                logger.debug("processRequest op is " + op);
            }
            if ((authzToken = this.authorize(this.aclMethod, authToken, this.authzResourceName, "approve")) == null) {
                throw new EAuthzException(CMS.getUserMessage((Locale)this.locale, (String)"CMS_AUTHORIZATION_ERROR", (String[])new String[0]));
            }
            CAEngine engine = CAEngine.getInstance();
            if (engine.getEnableNonces()) {
                BigInteger id = data.getRequestId().toBigInteger();
                String requestNonce = data.getNonce();
                if (requestNonce == null) {
                    logger.error("RequestProcessor: Missing nonce");
                    throw new BadRequestException("Missing nonce.");
                }
                Long nonce = Long.valueOf(requestNonce.trim());
                this.validateNonce(request, "cert-request", id, nonce);
            }
            logger.debug("RequestProcessor: processRequest: start serving");
            RequestId requestId = data.getRequestId();
            if (requestId == null || requestId.equals((Object)"")) {
                logger.error(CMS.getUserMessage((Locale)this.locale, (String)"CMS_REQUEST_ID_NOT_FOUND", (String[])new String[0]));
                throw new BadRequestDataException(CMS.getUserMessage((Locale)this.locale, (String)"CMS_REQUEST_ID_NOT_FOUND", (String[])new String[0]));
            }
            logger.debug("RequestProcessor: requestId=" + requestId);
            if (!req.getRequestStatus().equals((Object)RequestStatus.PENDING)) {
                logger.error(CMS.getUserMessage((Locale)this.locale, (String)"CMS_REQUEST_NOT_PENDING", (String[])new String[]{requestId.toString()}));
                throw new BadRequestDataException(CMS.getUserMessage((Locale)this.locale, (String)"CMS_REQUEST_NOT_PENDING", (String[])new String[]{requestId.toString()}));
            }
            if (authToken != null && req != null) {
                this.saveAuthToken(authToken, req);
            }
            if ((profileId = req.getExtDataInString("profileId")) == null || profileId.equals("")) {
                logger.error("RequestProcessor: Profile Id not found in request");
                throw new EBaseException(CMS.getUserMessage((Locale)this.locale, (String)"CMS_PROFILE_ID_NOT_FOUND", (String[])new String[0]));
            }
            logger.debug("RequestProcessor: profileId=" + profileId);
            Profile profile = this.ps.getProfile(profileId);
            if (profile == null) {
                logger.error(CMS.getUserMessage((Locale)this.locale, (String)"CMS_PROFILE_NOT_FOUND", (String[])new String[]{profileId}));
                throw new BadRequestDataException(CMS.getUserMessage((Locale)this.locale, (String)"CMS_PROFILE_NOT_FOUND", (String[])new String[]{profileId}));
            }
            if (!this.ps.isProfileEnable(profileId)) {
                logger.error("RequestProcessor: Profile " + profileId + " not enabled");
                throw new BadRequestDataException("Profile " + profileId + " not enabled");
            }
            if (op.equals("assign")) {
                String owner = req.getRequestOwner();
                if (owner != null && owner.length() > 0 && !this.grantPermission(req, authToken)) {
                    logger.error("RequestProcessor: Permission not granted to assign request.");
                    throw new EAuthzException(CMS.getUserMessage((Locale)this.locale, (String)"CMS_PROFILE_DENY_OPERATION", (String[])new String[0]));
                }
                String id = this.auditSubjectID();
                req.setRequestOwner(id);
            } else if (this.grantPermission(req, authToken)) {
                if (op.equals("approve")) {
                    this.checkProfileVersion(profile, req);
                    this.updateValues(data, req, profile, this.locale);
                    this.updateNotes(data, req);
                    this.approveRequest(req, data, profile, this.locale);
                } else if (op.equals("reject")) {
                    this.updateNotes(data, req);
                    this.rejectRequest(req);
                } else if (op.equals("cancel")) {
                    this.updateNotes(data, req);
                    this.cancelRequest(req);
                } else if (op.equals("update")) {
                    this.checkProfileVersion(profile, req);
                    this.updateValues(data, req, profile, this.locale);
                    this.updateNotes(data, req);
                } else if (op.equals("validate")) {
                    this.updateValues(data, req, profile, this.locale);
                } else if (op.equals("unassign")) {
                    req.setRequestOwner(null);
                }
            } else {
                logger.error("RequestProcessor: Permission not granted to approve/reject/cancel/update/validate/unassign request.");
                throw new EAuthzException(CMS.getUserMessage((Locale)this.locale, (String)"CMS_PROFILE_DENY_OPERATION", (String[])new String[0]));
            }
            if (!op.equals("validate")) {
                if (op.equals("approve")) {
                    this.queue.markAsServiced(req);
                } else {
                    this.requestRepository.updateRequest(req);
                }
            }
            this.endTiming("approval");
        }
        finally {
            this.endAllEvents();
        }
    }

    private boolean grantPermission(Request req, AuthToken token) {
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        boolean enable = false;
        try {
            enable = cs.getBoolean("request.assignee.enable", false);
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        if (!enable) {
            return true;
        }
        String owner = req.getRequestOwner();
        if (owner == null || owner.length() == 0) {
            return true;
        }
        String uid = token.getInString("userid");
        return uid.equals(owner);
    }

    private void checkProfileVersion(Profile profile, Request req) throws EProfileException {
        ProfileConfig profileConfig = profile.getConfigStore();
        if (profileConfig != null) {
            String lastModified = null;
            try {
                lastModified = profileConfig.getString("lastModified", "");
            }
            catch (EBaseException eBaseException) {
                // empty catch block
            }
            if (!lastModified.equals("")) {
                Date profileModifiedAt = new Date(Long.parseLong(lastModified));
                logger.debug("CertRequestExecutor: Profile Last Modified=" + profileModifiedAt);
                Date reqCreatedAt = req.getCreationTime();
                logger.debug("CertRequestExecutor: Request Created At=" + reqCreatedAt);
                if (profileModifiedAt.after(reqCreatedAt)) {
                    logger.error("Profile Newer Than Request");
                    throw new ERejectException("Profile Newer Than Request");
                }
            }
        }
    }

    private void cancelRequest(Request req) throws EProfileException {
        Auditor auditor = this.engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        String auditRequesterID = this.auditRequesterID(req);
        req.setRequestStatus(RequestStatus.CANCELED);
        auditor.log((LogEvent)CertRequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (String)"cancelReason", (Request)req));
    }

    private void rejectRequest(Request req) throws EProfileException {
        Auditor auditor = this.engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        String auditRequesterID = this.auditRequesterID(req);
        req.setRequestStatus(RequestStatus.REJECTED);
        auditor.log((LogEvent)CertRequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (String)"rejectReason", (Request)req));
    }

    private void ensureCAEnabled(String aidString) throws EBaseException {
        AuthorityID aid = null;
        try {
            aid = new AuthorityID(aidString);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestDataException("Invalid AuthorityID in request data");
        }
        CAEngine engine = CAEngine.getInstance();
        CertificateAuthority ca = engine.getCA();
        if (ca == null) {
            throw new CANotFoundException("Could not get host authority");
        }
        ca = engine.getCA(aid);
        if (ca == null) {
            throw new CANotFoundException("Unknown CA: " + aidString);
        }
        ca.ensureReady();
    }

    private void approveRequest(Request req, CertReviewResponse data, Profile profile, Locale locale) throws EBaseException {
        Auditor auditor = this.engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        String auditRequesterID = this.auditRequesterID(req);
        String aidString = req.getExtDataInString("req_authority_id");
        if (aidString != null) {
            this.ensureCAEnabled(aidString);
        }
        try {
            profile.execute(req);
            req.setRequestStatus(RequestStatus.COMPLETE);
            Enumeration<String> outputIds = profile.getProfileOutputIds();
            while (outputIds.hasMoreElements()) {
                com.netscape.cms.profile.common.ProfileOutput output = profile.getProfileOutput(outputIds.nextElement());
                ProfileOutput addOutput = ProfileOutputFactory.create(output, req, locale);
                data.addOutput(addOutput);
            }
            X509CertImpl theCert = req.getExtDataInCert("req_issued_cert");
            auditor.log((LogEvent)CertRequestProcessedEvent.createSuccessEvent((String)auditSubjectID, (String)auditRequesterID, (String)"certificate", (X509CertImpl)theCert));
        }
        catch (EProfileException eAudit1) {
            auditor.log((LogEvent)CertRequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (String)"certificate", (String)"<null>"));
            logger.error("CertRequestExecutor: about to throw EProfileException because of bad profile execute.");
            throw eAudit1;
        }
    }

    private void updateValues(CertReviewResponse data, Request req, Profile profile, Locale locale) throws ERejectException, EPropertyException {
        ProfilePolicy policy;
        HashMap<String, String> policyData = new HashMap<String, String>();
        for (ProfilePolicySet policySet : data.getPolicySets()) {
            for (com.netscape.certsrv.profile.ProfilePolicy policy2 : policySet.getPolicies()) {
                PolicyDefault def = policy2.getDef();
                List attrs = def.getAttributes();
                for (ProfileAttribute attr : attrs) {
                    policyData.put(attr.getName(), attr.getValue());
                }
            }
        }
        String profileSetId = req.getExtDataInString("profileSetId");
        Enumeration<ProfilePolicy> policies = profile.getProfilePolicies(profileSetId);
        while (policies.hasMoreElements()) {
            policy = policies.nextElement();
            this.setValue(locale, policy, req, policyData);
        }
        policies = profile.getProfilePolicies(profileSetId);
        while (policies.hasMoreElements()) {
            policy = policies.nextElement();
            this.validate(policy, req);
        }
    }

    private void updateNotes(CertReviewResponse data, Request req) {
        String notes = data.getRequestNotes();
        if (notes != null) {
            req.setExtData("requestNotes", notes);
        }
    }

    private void validate(ProfilePolicy policy, Request req) throws ERejectException {
        PolicyConstraint con = policy.getConstraint();
        con.validate(req);
    }

    private void setValue(Locale locale, ProfilePolicy policy, Request req, HashMap<String, String> data) throws EPropertyException {
        com.netscape.cms.profile.def.PolicyDefault def = policy.getDefault();
        Enumeration<String> defNames = def.getValueNames();
        while (defNames.hasMoreElements()) {
            String defName = defNames.nextElement();
            String defValue = data.get(defName);
            def.setValue(defName, locale, req, defValue);
        }
    }
}

