/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.ca.CRLIssuingPoint;
import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.CertStatusChangeRequestEvent;
import com.netscape.certsrv.logging.event.CertStatusChangeRequestProcessedEvent;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cms.servlet.common.CAServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.ldap.CAPublisherProcessor;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.request.CertRequestRepository;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestQueue;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.CRLExtensions;
import org.mozilla.jss.netscape.security.x509.CRLReasonExtension;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.InvalidityDateExtension;
import org.mozilla.jss.netscape.security.x509.RevocationReason;
import org.mozilla.jss.netscape.security.x509.RevokedCertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="caDoRevoke1", urlPatterns={"/ee/subsystem/ca/doRevoke"}, initParams={@WebInitParam(name="GetClientCert", value="true"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="ca"), @WebInitParam(name="interface", value="ee"), @WebInitParam(name="templatePath", value="/ee/ca/revocationResult.template"), @WebInitParam(name="ID", value="caDoRevoke1"), @WebInitParam(name="AuthMgr", value="certUserDBAuthMgr"), @WebInitParam(name="resourceID", value="certServer.ca.certificates")})
public class DoRevokeTPS
extends CAServlet {
    public static Logger logger = LoggerFactory.getLogger(DoRevokeTPS.class);
    private static final long serialVersionUID = -2980600514636454836L;
    private static final String TPL_FILE = "revocationResult.template";
    private CertificateRepository mCertDB;
    private String mFormPath = null;
    private RequestQueue mQueue;
    private CAPublisherProcessor mPublisherProcessor;
    private String errorString = "error=";
    private String o_status = "status=0";
    private int mTimeLimits = 30;
    private static final String REVOKE = "revoke";
    private static final String ON_HOLD = "on-hold";
    private static final int ON_HOLD_REASON = 6;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        CAEngine engine = CAEngine.getInstance();
        this.mFormPath = "/ca/revocationResult.template";
        this.mCertDB = engine.getCertificateRepository();
        this.mPublisherProcessor = engine.getPublisherProcessor();
        this.mQueue = engine.getRequestQueue();
        this.mTemplates.remove(CMSRequest.SUCCESS);
        if (this.mOutputTemplatePath != null) {
            this.mFormPath = this.mOutputTemplatePath;
        }
        this.mRenderResult = false;
        try {
            this.mTimeLimits = Integer.parseInt(sc.getInitParameter("timeLimits"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        AuthToken authToken = this.authenticate(cmsReq);
        logger.debug("DoRevokeTPS after authenticate");
        String revokeAll = null;
        int totalRecordCount = -1;
        EBaseException error = null;
        int reason = -1;
        boolean authorized = true;
        Date invalidityDate = null;
        Locale[] locale = new Locale[1];
        logger.debug("DoRevokeTPS before getTemplate");
        try {
            CMSTemplate cMSTemplate = this.getTemplate(this.mFormPath, req, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE", (Object[])new Object[]{this.mFormPath, e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getLogMessage((String)"CMSGW_ERROR_DISPLAY_TEMPLATE", (Object[])new Object[0]), (Exception)e);
        }
        catch (Exception e) {
            logger.error("DoRevokeTPS getTemplate failed: " + e.getMessage(), (Throwable)e);
            throw new EBaseException(CMS.getLogMessage((String)"CMSGW_ERROR_DISPLAY_TEMPLATE", (Object[])new Object[0]), (Throwable)e);
        }
        logger.debug("DoRevokeTPS after getTemplate");
        ArgBlock header = new ArgBlock();
        ArgBlock ctx = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, ctx);
        try {
            long l;
            if (req.getParameter("revocationReason") != null) {
                reason = Integer.parseInt(req.getParameter("revocationReason"));
            }
            if (req.getParameter("totalRecordCount") != null) {
                totalRecordCount = Integer.parseInt(req.getParameter("totalRecordCount"));
            }
            if (req.getParameter("invalidityDate") != null && (l = Long.parseLong(req.getParameter("invalidityDate"))) > 0L) {
                invalidityDate = new Date(l);
            }
            revokeAll = req.getParameter("revokeAll");
            String comments = req.getParameter("revRequesterComments");
            String initiative = null;
            String authMgr = "noAuthManager";
            AuthzToken authzToken = null;
            try {
                authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, REVOKE);
            }
            catch (EAuthzAccessDenied e) {
                logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            catch (Exception e) {
                logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            if (authzToken == null) {
                cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
                return;
            }
            if (this.mAuthMgr != null && this.mAuthMgr.equals("certUserDBAuthMgr")) {
                if (authToken != null) {
                    authMgr = authToken.getInString("authMgrInstName");
                    String agentID = authToken.getInString("userid");
                    initiative = "fromAgent agentID: " + agentID + " authenticated by " + authMgr;
                }
            } else {
                logger.warn("DoRevokeTPS: Missing authentication manager");
                this.o_status = "status=1";
                this.errorString = "errorString=Missing authentication manager.";
            }
            if (authorized) {
                this.o_status = "status=0";
                this.errorString = "error=";
                this.process(argSet, header, reason, invalidityDate, initiative, req, resp, revokeAll, totalRecordCount, comments, locale[0]);
            }
        }
        catch (NumberFormatException e) {
            logger.error(CMS.getLogMessage((String)"BASE_INVALID_NUMBER_FORMAT", (Object[])new Object[0]), (Throwable)e);
            error = new EBaseException(CMS.getLogMessage((String)"BASE_INVALID_NUMBER_FORMAT", (Object[])new Object[0]), (Throwable)e);
        }
        catch (EBaseException e) {
            error = e;
        }
        try {
            if (!authorized) {
                this.o_status = "status=3";
                this.errorString = "error=unauthorized";
            } else if (error != null) {
                this.o_status = "status=3";
                this.errorString = "error=" + error.toString();
            }
            String pp = this.o_status + "&" + this.errorString;
            byte[] b = pp.getBytes();
            resp.setContentType("application/x-www-form-urlencoded");
            resp.setContentLength(b.length);
            ServletOutputStream os = resp.getOutputStream();
            os.write(b);
            os.flush();
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_OUT_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getLogMessage((String)"CMSGW_ERROR_DISPLAY_TEMPLATE", (Object[])new Object[0]), (Exception)e);
        }
    }

    private void process(CMSTemplateParams argSet, ArgBlock header, int reason, Date invalidityDate, String initiative, HttpServletRequest req, HttpServletResponse resp, String revokeAll, int totalRecordCount, String comments, Locale locale) throws EBaseException {
        X509CertImpl[] oldCerts;
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        String auditSerialNumber = this.auditSerialNumber(null);
        String auditRequestType = this.auditRequestType(reason);
        RequestStatus auditApprovalStatus = null;
        String auditReasonNum = String.valueOf(reason);
        String method = "DoRevokeTPS.process:";
        String msg = "";
        logger.debug(method + "begins");
        if (revokeAll != null) {
            logger.debug("DoRevokeTPS.process revokeAll" + revokeAll);
            String serial = "";
            String[] tokens = revokeAll.split("=");
            if (tokens.length == 2) {
                serial = tokens[1];
                if (serial.endsWith(")")) {
                    serial = serial.substring(0, serial.length() - 1);
                }
                auditSerialNumber = serial;
            }
        }
        long startTime = new Date().getTime();
        Request revReq = null;
        int count = 0;
        try {
            Vector<X509CertImpl> oldCertsV = new Vector<X509CertImpl>();
            Vector<RevokedCertImpl> revCertImplsV = new Vector<RevokedCertImpl>();
            logger.debug(method + "reason code = " + reason);
            RevocationReason revReason = RevocationReason.valueOf((int)reason);
            CRLReasonExtension crlReasonExtn = new CRLReasonExtension(revReason);
            InvalidityDateExtension invalidityDateExtn = null;
            if (invalidityDate != null) {
                invalidityDateExtn = new InvalidityDateExtension(invalidityDate);
            }
            CRLExtensions entryExtn = new CRLExtensions();
            if (crlReasonExtn != null) {
                entryExtn.set(crlReasonExtn.getName(), (Extension)crlReasonExtn);
            }
            if (invalidityDateExtn != null) {
                entryExtn.set(invalidityDateExtn.getName(), (Extension)invalidityDateExtn);
            }
            Enumeration<CertRecord> e = this.mCertDB.searchCertificates(revokeAll, totalRecordCount, this.mTimeLimits);
            boolean alreadyRevokedCertFound = false;
            boolean badCertsRequested = false;
            while (e != null && e.hasMoreElements()) {
                CertRecord rec = e.nextElement();
                if (rec == null) {
                    badCertsRequested = true;
                    continue;
                }
                X509CertImpl xcert = rec.getCertificate();
                ArgBlock rarg = new ArgBlock();
                if (xcert != null && this.isSystemCertificate(xcert.getSerialNumber())) {
                    logger.warn("DoRevokeTPS: skipped revocation request for system certificate " + xcert.getSerialNumber());
                    badCertsRequested = true;
                    continue;
                }
                if (xcert != null) {
                    RevocationReason recRevReason = null;
                    if (rec.getStatus().equals("REVOKED")) {
                        try {
                            recRevReason = rec.getRevReason();
                        }
                        catch (Exception ex) {
                            logger.error(method + ex.getMessage(), e);
                            throw new EBaseException(ex);
                        }
                        if (recRevReason == null) {
                            msg = "existing revoked cert missing revocation reason";
                            logger.error(method + msg);
                            throw new EBaseException(msg);
                        }
                    }
                    rarg.addStringValue("serialNumber", xcert.getSerialNumber().toString(16));
                    boolean updateRevocation = true;
                    if (rec.getStatus().equals("REVOKED") && revReason == RevocationReason.KEY_COMPROMISE) {
                        updateRevocation = false;
                        if (recRevReason == RevocationReason.SUPERSEDED || rec.isCertOnHold()) {
                            updateRevocation = true;
                            logger.debug(method + "Certificate 0x" + xcert.getSerialNumber().toString(16) + " has been revoked, but reason is changed");
                        } else {
                            alreadyRevokedCertFound = true;
                            logger.debug("Certificate 0x" + xcert.getSerialNumber().toString(16) + " has been revoked.");
                        }
                    }
                    if (!updateRevocation) continue;
                    oldCertsV.addElement(xcert);
                    RevokedCertImpl revCertImpl = new RevokedCertImpl(xcert.getSerialNumber(), new Date(), entryExtn);
                    revCertImplsV.addElement(revCertImpl);
                    logger.debug(method + "Certificate 0x" + xcert.getSerialNumber().toString(16) + " is going to be revoked.");
                    ++count;
                    continue;
                }
                badCertsRequested = true;
            }
            if (count == 0) {
                if (alreadyRevokedCertFound && !badCertsRequested) {
                    logger.debug(method + "Only have previously revoked certs in the list.");
                    auditor.log((LogEvent)new CertStatusChangeRequestEvent(auditSubjectID, "Success", revReq, auditSerialNumber, auditRequestType));
                    return;
                }
                this.errorString = "error=No certificates are revoked.";
                this.o_status = "status=2";
                logger.error(CMS.getLogMessage((String)"CMSGW_REV_CERTS_ZERO", (Object[])new Object[0]));
                auditor.log((LogEvent)new CertStatusChangeRequestEvent(auditSubjectID, "Failure", revReq, auditSerialNumber, auditRequestType));
                throw new ECMSGWException(CMS.getLogMessage((String)"CMSGW_ERROR_MARKING_CERT_REVOKED", (Object[])new Object[0]));
            }
            oldCerts = new X509CertImpl[count];
            RevokedCertImpl[] revCertImpls = new RevokedCertImpl[count];
            for (int i = 0; i < count; ++i) {
                oldCerts[i] = (X509CertImpl)oldCertsV.elementAt(i);
                revCertImpls[i] = (RevokedCertImpl)revCertImplsV.elementAt(i);
            }
            CertRequestRepository requestRepository = engine.getCertRequestRepository();
            revReq = requestRepository.createRequest("revocation");
            auditor.log((LogEvent)new CertStatusChangeRequestEvent(auditSubjectID, "Success", revReq, auditSerialNumber, auditRequestType));
            revReq.setExtData("CERT_INFO", revCertImpls);
            revReq.setExtData("requestType", "revocation");
            if (initiative.equals("fromUser")) {
                revReq.setExtData("requestorType", "EE");
            } else {
                revReq.setExtData("requestorType", "Agent");
            }
            revReq.setExtData("OLD_CERTS", oldCerts);
            if (comments != null) {
                revReq.setExtData("csrRequestorComments", comments);
            }
            revReq.setExtData("revocationReason", Integer.valueOf(reason));
        }
        catch (EBaseException e) {
            logger.error("DoRevokeTPS: " + e.getMessage(), (Throwable)e);
            auditor.log((LogEvent)new CertStatusChangeRequestEvent(auditSubjectID, "Failure", revReq, auditSerialNumber, auditRequestType));
            throw e;
        }
        catch (Exception e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERROR_MARKING_CERT_REVOKED_1", (Object[])new Object[]{e.toString()}), (Throwable)e);
            auditor.log((LogEvent)new CertStatusChangeRequestEvent(auditSubjectID, "Failure", revReq, auditSerialNumber, auditRequestType));
            throw new ECMSGWException(CMS.getLogMessage((String)"CMSGW_ERROR_MARKING_CERT_REVOKED", (Object[])new Object[0]), e);
        }
        try {
            block57: {
                RequestStatus stat;
                block55: {
                    block56: {
                        this.mQueue.processRequest(revReq);
                        auditApprovalStatus = revReq.getRequestStatus();
                        stat = revReq.getRequestStatus();
                        String type = revReq.getRequestType();
                        if (stat != RequestStatus.COMPLETE && (!type.equals("cert4crl") || stat != RequestStatus.SVC_PENDING)) break block55;
                        Integer result = revReq.getExtDataInInteger("Result");
                        if (result.equals(Request.RES_ERROR)) {
                            String[] svcErrors = revReq.getExtDataInStringArray("serviceErrors");
                            if (svcErrors != null && svcErrors.length > 0) {
                                for (int i = 0; i < svcErrors.length; ++i) {
                                    String err = svcErrors[i];
                                    if (err == null) continue;
                                    for (int j = 0; j < count; ++j) {
                                        X509CertImpl cert = oldCerts[j];
                                        if (oldCerts[j] == null) continue;
                                        logger.info("Revocation request reqID {} {} is {}. DN requested: {} serial number: 0x{} revocation reason: {}", new Object[]{revReq.getRequestId(), initiative, "completed with error: " + err, cert.getSubjectName(), cert.getSerialNumber().toString(16), RevocationReason.valueOf((int)reason)});
                                    }
                                }
                            }
                            if (auditApprovalStatus == RequestStatus.COMPLETE || auditApprovalStatus == RequestStatus.REJECTED || auditApprovalStatus == RequestStatus.CANCELED) {
                                auditor.log((LogEvent)new CertStatusChangeRequestProcessedEvent(auditSubjectID, "Failure", revReq, auditSerialNumber, auditRequestType, auditReasonNum, auditApprovalStatus));
                            }
                            return;
                        }
                        long endTime = new Date().getTime();
                        for (int j = 0; j < count; ++j) {
                            if (oldCerts[j] == null) continue;
                            X509CertImpl cert = oldCerts[j];
                            logger.info("Revocation request reqID {} {} is {}. DN requested: {} serial number: 0x{} revocation reason: {}", new Object[]{revReq.getRequestId(), initiative, "completed", cert.getSubjectName(), cert.getSerialNumber().toString(16), RevocationReason.valueOf((int)reason) + " time: " + (endTime - startTime)});
                        }
                        header.addStringValue("revoked", "yes");
                        Integer updateCRLResult = revReq.getExtDataInInteger("crlUpdateStatus");
                        if (updateCRLResult != null) {
                            Object publishCRLResult;
                            if (!updateCRLResult.equals(Request.RES_SUCCESS)) {
                                this.o_status = "status=3";
                                if (revReq.getExtDataInString("crlUpdateError") != null) {
                                    this.errorString = "error=Update CRL Error.";
                                }
                            }
                            if ((publishCRLResult = revReq.getExtDataInInteger("crlPublishStatus")) != null && !((Integer)publishCRLResult).equals(Request.RES_SUCCESS)) {
                                String publError = revReq.getExtDataInString("crlPublishError");
                                this.o_status = "status=3";
                                if (publError != null) {
                                    this.errorString = "error=" + publError;
                                }
                            }
                        }
                        for (CRLIssuingPoint crl : engine.getCRLIssuingPoints()) {
                            String publishStatusStr;
                            Integer publishResult;
                            String updateStatusStr;
                            Integer updateResult;
                            String crlId = crl.getId();
                            if (crlId.equals("MasterCRL") || (updateResult = revReq.getExtDataInInteger(updateStatusStr = crl.getCrlUpdateStatusStr())) == null) continue;
                            if (!updateResult.equals(Request.RES_SUCCESS)) {
                                String updateErrorStr = crl.getCrlUpdateErrorStr();
                                logger.debug("DoRevoke: " + CMS.getLogMessage((String)"ADMIN_SRVLT_ADDING_HEADER_NO", (Object[])new Object[]{updateStatusStr}));
                                String error = revReq.getExtDataInString(updateErrorStr);
                                this.o_status = "status=3";
                                if (error != null) {
                                    this.errorString = "error=" + error;
                                }
                            }
                            if ((publishResult = revReq.getExtDataInInteger(publishStatusStr = crl.getCrlPublishStatusStr())) == null || publishResult.equals(Request.RES_SUCCESS)) continue;
                            String publishErrorStr = crl.getCrlPublishErrorStr();
                            String error = revReq.getExtDataInString(publishErrorStr);
                            this.o_status = "status=3";
                            if (error == null) continue;
                            this.errorString = "error=Publish CRL Status Error.";
                        }
                        if (this.mPublisherProcessor == null || !this.mPublisherProcessor.ldapEnabled()) break block56;
                        header.addStringValue("dirEnabled", "yes");
                        String publError = revReq.getExtDataInString("crlPublishError");
                        if (publError != null) {
                            this.errorString = "error=" + publError;
                            this.o_status = "status=3";
                        }
                        break block57;
                    }
                    if (this.mPublisherProcessor != null || !this.mPublisherProcessor.ldapEnabled()) break block57;
                    this.errorString = "error=LDAP publishing not enabled.";
                    this.o_status = "status=3";
                    break block57;
                }
                if (stat == RequestStatus.PENDING || stat == RequestStatus.REJECTED) {
                    this.o_status = "status=2";
                    this.errorString = "error=" + stat.toString();
                } else {
                    this.o_status = "status=2";
                    this.errorString = "error=Undefined request status";
                }
                Vector errors = revReq.getExtDataInStringVector("errors");
                if (errors != null) {
                    StringBuffer errInfo = new StringBuffer();
                    for (int i = 0; i < errors.size(); ++i) {
                        errInfo.append((String)errors.elementAt(i));
                        errInfo.append("\n");
                    }
                    this.o_status = "status=2";
                    this.errorString = "error=" + errInfo.toString();
                } else if (stat == RequestStatus.PENDING) {
                    this.o_status = "status=2";
                    this.errorString = "error=Request pending";
                } else {
                    this.o_status = "status=2";
                    this.errorString = "error=Undefined request status";
                }
                for (int j = 0; j < count; ++j) {
                    if (oldCerts[j] == null) continue;
                    X509CertImpl cert = oldCerts[j];
                    logger.info("Revocation request reqID {} {} is {}. DN requested: {} serial number: 0x{} revocation reason: {}", new Object[]{revReq.getRequestId(), initiative, stat, cert.getSubjectName(), cert.getSerialNumber().toString(16), RevocationReason.valueOf((int)reason)});
                }
            }
            if (auditApprovalStatus == RequestStatus.COMPLETE || auditApprovalStatus == RequestStatus.REJECTED || auditApprovalStatus == RequestStatus.CANCELED) {
                auditor.log((LogEvent)new CertStatusChangeRequestProcessedEvent(auditSubjectID, "Success", revReq, auditSerialNumber, auditRequestType, auditReasonNum, auditApprovalStatus));
            }
        }
        catch (EBaseException e) {
            logger.error("DoRevokeTPS: " + e.getMessage(), (Throwable)e);
            if (auditApprovalStatus == RequestStatus.COMPLETE || auditApprovalStatus == RequestStatus.REJECTED || auditApprovalStatus == RequestStatus.CANCELED) {
                auditor.log((LogEvent)new CertStatusChangeRequestProcessedEvent(auditSubjectID, "Failure", revReq, auditSerialNumber, auditRequestType, auditReasonNum, auditApprovalStatus));
            }
            throw e;
        }
        catch (Exception e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERROR_MARKING_CERT_REVOKED_1", (Object[])new Object[]{e.toString()}), (Throwable)e);
            if (auditApprovalStatus == RequestStatus.COMPLETE || auditApprovalStatus == RequestStatus.REJECTED || auditApprovalStatus == RequestStatus.CANCELED) {
                auditor.log((LogEvent)new CertStatusChangeRequestProcessedEvent(auditSubjectID, "Failure", revReq, auditSerialNumber, auditRequestType, auditReasonNum, auditApprovalStatus));
            }
            throw new ECMSGWException(CMS.getLogMessage((String)"CMSGW_ERROR_MARKING_CERT_REVOKED", (Object[])new Object[0]), e);
        }
    }

    private String auditSerialNumber(String eeSerialNumber) {
        Object serialNumber = null;
        if (eeSerialNumber != null) {
            serialNumber = eeSerialNumber.trim();
            serialNumber = "0x" + new BigInteger((String)serialNumber).toString(16);
        } else {
            serialNumber = "<null>";
        }
        return serialNumber;
    }

    private String auditRequestType(int reason) {
        String requestType = null;
        requestType = reason == 6 ? ON_HOLD : REVOKE;
        return requestType;
    }
}

