/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.util.Locale;
import java.util.Vector;
import org.mozilla.jss.netscape.security.provider.DSAPublicKey;
import org.mozilla.jss.netscape.security.provider.RSAPublicKey;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertificateX509Key;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserKeyDefault
extends EnrollDefault {
    public static Logger logger = LoggerFactory.getLogger(UserKeyDefault.class);
    public static final String VAL_KEY = "KEY";
    public static final String VAL_LEN = "LEN";
    public static final String VAL_TYPE = "TYPE";

    public UserKeyDefault() {
        this.addValueName(VAL_TYPE);
        this.addValueName(VAL_LEN);
        this.addValueName(VAL_KEY);
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals(VAL_KEY)) {
            return new Descriptor("string", "readonly", null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_KEY", (String[])new String[0]));
        }
        if (name.equals(VAL_LEN)) {
            return new Descriptor("string", "readonly", null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_KEY_LEN", (String[])new String[0]));
        }
        if (name.equals(VAL_TYPE)) {
            return new Descriptor("string", "readonly", null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_KEY_TYPE", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        if (name.equals(VAL_KEY)) {
            CertificateX509Key ck = null;
            try {
                ck = (CertificateX509Key)info.get("key");
            }
            catch (Exception exception) {
                // empty catch block
            }
            X509Key k = null;
            try {
                k = (X509Key)ck.get("value");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (k == null) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_KEY_NOT_FOUND", (String[])new String[0]));
            }
            return this.toHexString(k.getKey());
        }
        if (name.equals(VAL_LEN)) {
            CertificateX509Key ck = null;
            try {
                ck = (CertificateX509Key)info.get("key");
            }
            catch (Exception k) {
                // empty catch block
            }
            X509Key k = null;
            try {
                k = (X509Key)ck.get("value");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (k == null) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_KEY_NOT_FOUND", (String[])new String[0]));
            }
            try {
                if (k.getAlgorithm().equals("RSA")) {
                    return Integer.toString(this.getRSAKeyLen(k));
                }
                if (k.getAlgorithm().equals("EC")) {
                    Vector vect = CryptoUtil.getECKeyCurve((X509Key)k);
                    return vect == null ? null : vect.toString();
                }
                return Integer.toString(this.getDSAKeyLen(k));
            }
            catch (Exception e) {
                logger.error("UserKeyDefault: getValue " + e.getMessage(), (Throwable)e);
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        if (name.equals(VAL_TYPE)) {
            CertificateX509Key ck = null;
            try {
                ck = (CertificateX509Key)info.get("key");
            }
            catch (Exception k) {
                // empty catch block
            }
            X509Key k = null;
            try {
                k = (X509Key)ck.get("value");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (k == null) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_KEY_NOT_FOUND", (String[])new String[0]));
            }
            return k.getAlgorithm() + " - " + k.getAlgorithmId().getOID().toString();
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_USER_KEY", (String[])new String[0]);
    }

    public int getRSAKeyLen(X509Key key) throws Exception {
        X509Key newkey = null;
        try {
            newkey = new X509Key(AlgorithmId.get((String)"RSA"), key.getKey());
        }
        catch (Exception e) {
            logger.error("UserKeyDefault: getRSAKey " + e.getMessage(), (Throwable)e);
            throw e;
        }
        RSAPublicKey rsaKey = new RSAPublicKey(newkey.getEncoded());
        return rsaKey.getKeySize();
    }

    public int getDSAKeyLen(X509Key key) throws Exception {
        DSAPublicKey dsaKey = new DSAPublicKey(key.getEncoded());
        DSAParams keyParams = dsaKey.getParams();
        BigInteger p = keyParams.getP();
        int len = p.bitLength();
        return len;
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        CertificateX509Key certKey = null;
        try {
            byte[] certKeyData = request.getExtDataInByteArray("req_key");
            if (certKeyData != null) {
                certKey = new CertificateX509Key((InputStream)new ByteArrayInputStream(certKeyData));
            }
            info.set("key", certKey);
        }
        catch (Exception e) {
            logger.warn("UserKeyDefault: populate " + e.getMessage(), (Throwable)e);
        }
    }
}

