/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollExtDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.CPSuri;
import org.mozilla.jss.netscape.security.x509.CertificatePoliciesExtension;
import org.mozilla.jss.netscape.security.x509.CertificatePolicyId;
import org.mozilla.jss.netscape.security.x509.CertificatePolicyInfo;
import org.mozilla.jss.netscape.security.x509.DisplayText;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.NoticeReference;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.PolicyQualifierInfo;
import org.mozilla.jss.netscape.security.x509.PolicyQualifiers;
import org.mozilla.jss.netscape.security.x509.Qualifier;
import org.mozilla.jss.netscape.security.x509.UserNotice;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificatePoliciesExtDefault
extends EnrollExtDefault {
    public static Logger logger = LoggerFactory.getLogger(CertificatePoliciesExtDefault.class);
    public static final String CONFIG_CRITICAL = "Critical";
    public static final String CONFIG_PREFIX = "PoliciesExt.certPolicy";
    public static final String CONFIG_PREFIX1 = "PolicyQualifiers";
    public static final String CONFIG_POLICY_ENABLE = "enable";
    public static final String CONFIG_POLICY_NUM = "PoliciesExt.num";
    public static final String CONFIG_POLICY_ID = "policyId";
    public static final String CONFIG_POLICY_QUALIFIERS_NUM = "PolicyQualifiers.num";
    public static final String CONFIG_CPSURI_ENABLE = "CPSURI.enable";
    public static final String CONFIG_USERNOTICE_ENABLE = "usernotice.enable";
    public static final String CONFIG_CPSURI_VALUE = "CPSURI.value";
    public static final String CONFIG_USERNOTICE_ORG = "usernotice.noticeReference.organization";
    public static final String CONFIG_USERNOTICE_NUMBERS = "usernotice.noticeReference.noticeNumbers";
    public static final String CONFIG_USERNOTICE_TEXT = "usernotice.explicitText.value";
    public static final String VAL_CRITICAL = "Critical";
    public static final String VAL_POLICY_QUALIFIERS = "policyQualifiers";
    private static final String SEPARATOR = ".";
    private static final int DEF_NUM_POLICIES = 5;
    private static final int DEF_NUM_QUALIFIERS = 1;
    private static final String POLICY_ID_ENABLE = "Enable";
    private static final String POLICY_ID = "Policy Id";
    private static final String POLICY_QUALIFIER_CPSURI_ENABLE = "CPSuri Enable";
    private static final String POLICY_QUALIFIER_USERNOTICE_ENABLE = "UserNotice Enable";
    private static final String USERNOTICE_REF_ORG = "UserNoticeReference Organization";
    private static final String USERNOTICE_REF_NUMBERS = "UserNoticeReference Numbers";
    private static final String USERNOTICE_EXPLICIT_TEXT = "UserNoticeReference Explicit Text";
    private static final String CPSURI = "CPS uri";

    protected int getNumPolicies() {
        int num = 5;
        String numPolicies = this.getConfig(CONFIG_POLICY_NUM);
        if (numPolicies != null) {
            try {
                num = Integer.parseInt(numPolicies);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return num;
    }

    protected int getNumQualifiers() {
        int num = 1;
        String numQualifiers = this.getConfig(CONFIG_POLICY_QUALIFIERS_NUM);
        if (numQualifiers != null) {
            try {
                num = Integer.parseInt(numQualifiers);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return num;
    }

    @Override
    public void init(CAEngineConfig engineConfig, ConfigStore config) throws EProfileException {
        super.init(engineConfig, config);
        this.refreshConfigAndValueNames();
    }

    @Override
    public void setConfig(String name, String value) throws EPropertyException {
        int num = 0;
        if (name.equals(CONFIG_POLICY_NUM)) {
            try {
                num = Integer.parseInt(value);
                if (num < 1) {
                    throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{CONFIG_POLICY_NUM}));
                }
            }
            catch (Exception e) {
                throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{CONFIG_POLICY_NUM}));
            }
        }
        super.setConfig(name, value);
    }

    @Override
    public Enumeration<String> getConfigNames() {
        this.refreshConfigAndValueNames();
        return super.getConfigNames();
    }

    @Override
    protected void refreshConfigAndValueNames() {
        super.refreshConfigAndValueNames();
        this.addValueName("Critical");
        this.addValueName(VAL_POLICY_QUALIFIERS);
        this.addConfigName("Critical");
        int num = this.getNumPolicies();
        int numQualifiers = this.getNumQualifiers();
        this.addConfigName(CONFIG_POLICY_NUM);
        for (int i = 0; i < num; ++i) {
            this.addConfigName(CONFIG_PREFIX + i + ".policyId");
            this.addConfigName(CONFIG_PREFIX + i + ".enable");
            for (int j = 0; j < numQualifiers; ++j) {
                this.addConfigName(CONFIG_PREFIX + i + ".PolicyQualifiers" + j + ".CPSURI.enable");
                this.addConfigName(CONFIG_PREFIX + i + ".PolicyQualifiers" + j + ".usernotice.enable");
                this.addConfigName(CONFIG_PREFIX + i + ".PolicyQualifiers" + j + ".CPSURI.value");
                this.addConfigName(CONFIG_PREFIX + i + ".PolicyQualifiers" + j + ".usernotice.noticeReference.organization");
                this.addConfigName(CONFIG_PREFIX + i + ".PolicyQualifiers" + j + ".usernotice.noticeReference.noticeNumbers");
                this.addConfigName(CONFIG_PREFIX + i + ".PolicyQualifiers" + j + ".usernotice.explicitText.value");
            }
        }
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals("Critical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.indexOf(CONFIG_POLICY_ID) >= 0) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_POLICY_ID", (String[])new String[0]));
        }
        if (name.indexOf(CONFIG_CPSURI_ENABLE) >= 0) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_POLICY_QUALIFIER_CPSURI_ENABLE", (String[])new String[0]));
        }
        if (name.indexOf(CONFIG_USERNOTICE_ENABLE) >= 0) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_POLICY_QUALIFIER_USERNOTICE_ENABLE", (String[])new String[0]));
        }
        if (name.indexOf(CONFIG_POLICY_ENABLE) >= 0) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CERTIFICATE_POLICY_ENABLE", (String[])new String[0]));
        }
        if (name.indexOf(CONFIG_POLICY_QUALIFIERS_NUM) >= 0) {
            return new Descriptor("integer", null, "1", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_POLICY_QUALIFIER_NUM", (String[])new String[0]));
        }
        if (name.indexOf(CONFIG_USERNOTICE_ORG) >= 0) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_POLICY_USERNOTICE_REF_ORG", (String[])new String[0]));
        }
        if (name.indexOf(CONFIG_USERNOTICE_NUMBERS) >= 0) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_POLICY_USERNOTICE_REF_NUMBERS", (String[])new String[0]));
        }
        if (name.indexOf(CONFIG_USERNOTICE_TEXT) >= 0) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_POLICY_USERNOTICE_EXPLICIT_TEXT", (String[])new String[0]));
        }
        if (name.indexOf(CONFIG_CPSURI_VALUE) >= 0) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_POLICY_CPSURI", (String[])new String[0]));
        }
        if (name.indexOf(CONFIG_POLICY_NUM) >= 0) {
            return new Descriptor("integer", null, "5", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NUM_POLICIES", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals("Critical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals(VAL_POLICY_QUALIFIERS)) {
            return new Descriptor("string_list", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_POLICY_QUALIFIERS", (String[])new String[0]));
        }
        return null;
    }

    private Hashtable<String, String> buildRecords(String value) throws EPropertyException {
        StringTokenizer st = new StringTokenizer(value, "\r\n");
        Hashtable<String, String> table = new Hashtable<String, String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int index = token.indexOf(":");
            if (index <= 0) {
                throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{token}));
            }
            String name = token.substring(0, index);
            String val = "";
            if (token.length() - 1 > index) {
                val = token.substring(index + 1);
            }
            table.put(name, val);
        }
        return table;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
        try {
            CertificatePoliciesExtension ext = null;
            if (name == null) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            if (name.equals("Critical")) {
                ext = (CertificatePoliciesExtension)this.getExtension(PKIXExtensions.CertificatePolicies_Id.toString(), info);
                boolean val = Boolean.valueOf(value);
                ext.setCritical(val);
            } else if (name.equals(VAL_POLICY_QUALIFIERS)) {
                ext = (CertificatePoliciesExtension)this.getExtension(PKIXExtensions.CertificatePolicies_Id.toString(), info);
                Hashtable<String, String> h = this.buildRecords(value);
                String numStr = h.get(CONFIG_POLICY_NUM);
                int size = Integer.parseInt(numStr);
                Vector<CertificatePolicyInfo> certificatePolicies = new Vector<CertificatePolicyInfo>();
                for (int i = 0; i < size; ++i) {
                    String enable = h.get(CONFIG_PREFIX + i + ".enable");
                    CertificatePolicyInfo cinfo = null;
                    if (enable == null || !enable.equals("true")) continue;
                    String policyId = h.get(CONFIG_PREFIX + i + ".policyId");
                    if (policyId == null || policyId.length() == 0) {
                        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CERTIFICATE_POLICIES_EMPTY_POLICYID", (String[])new String[0]));
                    }
                    CertificatePolicyId cpolicyId = this.getPolicyId(policyId);
                    String qualifersNum = h.get(CONFIG_PREFIX + i + ".PolicyQualifiers.num");
                    PolicyQualifiers policyQualifiers = new PolicyQualifiers();
                    int num = 0;
                    if (qualifersNum != null && qualifersNum.length() > 0) {
                        num = Integer.parseInt(qualifersNum);
                    }
                    for (int j = 0; j < num; ++j) {
                        String cpsuriEnable = h.get(CONFIG_PREFIX + i + ".PolicyQualifiers" + j + ".CPSURI.enable");
                        String usernoticeEnable = h.get(CONFIG_PREFIX + i + ".PolicyQualifiers" + j + ".usernotice.enable");
                        if (cpsuriEnable != null && cpsuriEnable.equals("true")) {
                            String cpsuri = h.get(CONFIG_PREFIX + i + ".PolicyQualifiers" + j + ".CPSURI.value");
                            PolicyQualifierInfo qualifierInfo = this.createCPSuri(cpsuri);
                            if (qualifierInfo == null) continue;
                            policyQualifiers.add(qualifierInfo);
                            continue;
                        }
                        if (usernoticeEnable == null || !enable.equals("true")) continue;
                        String orgName = h.get(CONFIG_PREFIX + i + ".PolicyQualifiers" + j + ".usernotice.noticeReference.organization");
                        String noticenumbers = h.get(CONFIG_PREFIX + i + ".PolicyQualifiers" + j + ".usernotice.noticeReference.noticeNumbers");
                        String explicitText = h.get(CONFIG_PREFIX + i + ".PolicyQualifiers" + j + ".usernotice.explicitText.value");
                        PolicyQualifierInfo qualifierInfo = this.createUserNotice(orgName, explicitText, noticenumbers);
                        if (qualifierInfo == null) continue;
                        policyQualifiers.add(qualifierInfo);
                    }
                    cinfo = policyQualifiers.size() <= 0 ? new CertificatePolicyInfo(cpolicyId) : new CertificatePolicyInfo(cpolicyId, policyQualifiers);
                    if (cinfo == null) continue;
                    certificatePolicies.addElement(cinfo);
                }
                ext.set("infos", certificatePolicies);
            } else {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            this.replaceExtension(PKIXExtensions.CertificatePolicies_Id.toString(), (Extension)ext, info);
        }
        catch (EProfileException e) {
            logger.error("CertificatePoliciesExtDefault: setValue " + e.getMessage(), (Throwable)e);
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        catch (IOException e) {
            logger.error("CertificatePoliciesExtDefault: setValue " + e.getMessage(), (Throwable)e);
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        CertificatePoliciesExtension ext = null;
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        if (name.equals("Critical")) {
            ext = (CertificatePoliciesExtension)this.getExtension(PKIXExtensions.CertificatePolicies_Id.toString(), info);
            if (ext == null) {
                return null;
            }
            return ext.isCritical() ? "true" : "false";
        }
        if (name.equals(VAL_POLICY_QUALIFIERS)) {
            Vector infos;
            ext = (CertificatePoliciesExtension)this.getExtension(PKIXExtensions.CertificatePolicies_Id.toString(), info);
            if (ext == null) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            int num_policies = this.getNumPolicies();
            sb.append(CONFIG_POLICY_NUM);
            sb.append(":");
            sb.append(num_policies);
            sb.append("\n");
            try {
                infos = (Vector)ext.get("infos");
            }
            catch (IOException ee) {
                infos = null;
            }
            for (int i = 0; i < num_policies; ++i) {
                int qSize = 0;
                String policyId = "";
                String policyEnable = "false";
                PolicyQualifiers qualifiers = null;
                if (infos.size() > 0) {
                    CertificatePolicyInfo cinfo = (CertificatePolicyInfo)infos.elementAt(0);
                    CertificatePolicyId id1 = cinfo.getPolicyIdentifier();
                    policyId = id1.getIdentifier().toString();
                    policyEnable = "true";
                    qualifiers = cinfo.getPolicyQualifiers();
                    if (qualifiers != null) {
                        qSize = qualifiers.size();
                    }
                    infos.removeElementAt(0);
                }
                sb.append(CONFIG_PREFIX + i + ".enable");
                sb.append(":");
                sb.append(policyEnable);
                sb.append("\n");
                sb.append(CONFIG_PREFIX + i + ".policyId");
                sb.append(":");
                sb.append(policyId);
                sb.append("\n");
                if (qSize == 0) {
                    sb.append(CONFIG_PREFIX + i + ".PolicyQualifiers.num");
                    sb.append(":");
                    sb.append(1);
                    sb.append("\n");
                } else {
                    sb.append(CONFIG_PREFIX + i + ".PolicyQualifiers.num");
                    sb.append(":");
                    sb.append(qSize);
                    sb.append("\n");
                }
                if (qSize == 0) {
                    sb.append(CONFIG_PREFIX + i + ".PolicyQualifiers0.CPSURI.enable");
                    sb.append(":");
                    sb.append("false");
                    sb.append("\n");
                    sb.append(CONFIG_PREFIX + i + ".PolicyQualifiers0.CPSURI.value");
                    sb.append(":");
                    sb.append("");
                    sb.append("\n");
                    sb.append(CONFIG_PREFIX + i + ".PolicyQualifiers0.usernotice.enable");
                    sb.append(":");
                    sb.append("false");
                    sb.append("\n");
                    sb.append(CONFIG_PREFIX + i + ".PolicyQualifiers0.usernotice.noticeReference.organization");
                    sb.append(":");
                    sb.append("");
                    sb.append("\n");
                    sb.append(CONFIG_PREFIX + i + ".PolicyQualifiers0.usernotice.noticeReference.noticeNumbers");
                    sb.append(":");
                    sb.append("");
                    sb.append("\n");
                    sb.append(CONFIG_PREFIX + i + ".PolicyQualifiers0.usernotice.explicitText.value");
                    sb.append(":");
                    sb.append("");
                    sb.append("\n");
                }
                for (int j = 0; j < qSize; ++j) {
                    PolicyQualifierInfo qinfo = qualifiers.getInfoAt(j);
                    ObjectIdentifier oid = qinfo.getId();
                    Qualifier qualifier = qinfo.getQualifier();
                    String cpsuriEnable = "false";
                    String usernoticeEnable = "false";
                    String cpsuri = "";
                    String orgName = "";
                    StringBuffer noticeNum = new StringBuffer();
                    String explicitText = "";
                    if (oid.toString().equals(PolicyQualifierInfo.QT_CPS.toString())) {
                        cpsuriEnable = "true";
                        content = (CPSuri)qualifier;
                        cpsuri = content.getURI();
                    } else if (oid.toString().equals(PolicyQualifierInfo.QT_UNOTICE.toString())) {
                        DisplayText displayText;
                        usernoticeEnable = "true";
                        content = (UserNotice)qualifier;
                        NoticeReference ref = content.getNoticeReference();
                        if (ref != null) {
                            orgName = ref.getOrganization().getText();
                            int[] nums = ref.getNumbers();
                            for (int k = 0; k < nums.length; ++k) {
                                if (k != 0) {
                                    noticeNum.append(",");
                                    noticeNum.append(nums[k]);
                                    continue;
                                }
                                noticeNum.append(nums[k]);
                            }
                        }
                        if ((displayText = content.getDisplayText()) != null) {
                            explicitText = displayText.getText();
                        }
                    }
                    sb.append(CONFIG_PREFIX + i + ".PolicyQualifiers" + j + ".CPSURI.enable");
                    sb.append(":");
                    sb.append(cpsuriEnable);
                    sb.append("\n");
                    sb.append(CONFIG_PREFIX + i + ".PolicyQualifiers" + j + ".CPSURI.value");
                    sb.append(":");
                    sb.append(cpsuri);
                    sb.append("\n");
                    sb.append(CONFIG_PREFIX + i + ".PolicyQualifiers" + j + ".usernotice.enable");
                    sb.append(":");
                    sb.append(usernoticeEnable);
                    sb.append("\n");
                    sb.append(CONFIG_PREFIX + i + ".PolicyQualifiers" + j + ".usernotice.noticeReference.organization");
                    sb.append(":");
                    sb.append(orgName);
                    sb.append("\n");
                    sb.append(CONFIG_PREFIX + i + ".PolicyQualifiers" + j + ".usernotice.noticeReference.noticeNumbers");
                    sb.append(":");
                    sb.append(noticeNum.toString());
                    sb.append("\n");
                    sb.append(CONFIG_PREFIX + i + ".PolicyQualifiers" + j + ".usernotice.explicitText.value");
                    sb.append(":");
                    sb.append(explicitText);
                    sb.append("\n");
                }
            }
            return sb.toString();
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getText(Locale locale) {
        StringBuffer sb = new StringBuffer();
        int num = this.getNumPolicies();
        int num1 = this.getNumQualifiers();
        try {
            ConfigStore basesubstore = this.getConfigStore().getSubStore("params", ConfigStore.class);
            sb.append("{");
            sb.append("PoliciesExt.num:");
            sb.append(num);
            sb.append(",");
            for (int i = 0; i < num; ++i) {
                sb.append("{");
                ConfigStore substore = basesubstore.getSubStore(CONFIG_PREFIX + i, ConfigStore.class);
                String enable = substore.getString(CONFIG_POLICY_ENABLE, "");
                sb.append("Enable:");
                sb.append(enable);
                sb.append(",");
                String policyId = substore.getString(CONFIG_POLICY_ID, "");
                sb.append("Policy Id:");
                sb.append(policyId);
                sb.append(",");
                String qualifiersNum = substore.getString(CONFIG_POLICY_QUALIFIERS_NUM, "");
                sb.append("PolicyQualifiers.num:");
                sb.append(qualifiersNum);
                sb.append(",");
                for (int j = 0; j < num1; ++j) {
                    ConfigStore substore1 = substore.getSubStore(CONFIG_PREFIX1 + j, ConfigStore.class);
                    sb.append("{");
                    String cpsuriEnable = substore1.getString(CONFIG_CPSURI_ENABLE, "");
                    sb.append("CPSuri Enable:");
                    sb.append(cpsuriEnable);
                    sb.append(",");
                    String usernoticeEnable = substore1.getString(CONFIG_USERNOTICE_ENABLE, "");
                    sb.append("UserNotice Enable:");
                    sb.append(usernoticeEnable);
                    sb.append(",");
                    String orgName = substore1.getString(CONFIG_USERNOTICE_ORG, "");
                    sb.append("UserNoticeReference Organization:");
                    sb.append(orgName);
                    sb.append(",");
                    String refNums = substore1.getString(CONFIG_USERNOTICE_NUMBERS, "");
                    sb.append("UserNoticeReference Numbers:");
                    sb.append(refNums);
                    sb.append(",");
                    String explicitText = substore1.getString(CONFIG_USERNOTICE_TEXT, "");
                    sb.append("UserNoticeReference Explicit Text:");
                    sb.append(explicitText);
                    sb.append(",");
                    String cpsuri = substore1.getString(CONFIG_CPSURI_VALUE, "");
                    sb.append("CPS uri:");
                    sb.append(cpsuri);
                    sb.append("}");
                }
                sb.append("}");
            }
            sb.append("}");
            return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_CERTIFICATE_POLICIES_EXT", (String[])new String[]{this.getConfig("Critical"), sb.toString()});
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        CertificatePoliciesExtension ext = this.createExtension();
        if (ext == null) {
            return;
        }
        this.addExtension(PKIXExtensions.CertificatePolicies_Id.toString(), (Extension)ext, info);
    }

    public CertificatePoliciesExtension createExtension() throws EProfileException {
        try {
            boolean critical = this.getConfigBoolean("Critical");
            Vector<CertificatePolicyInfo> certificatePolicies = new Vector<CertificatePolicyInfo>();
            int num = this.getNumPolicies();
            logger.info("CertificatePoliciesExtension: policies: " + num);
            ConfigStore config = this.getConfigStore();
            for (int i = 0; i < num; ++i) {
                ConfigStore basesubstore = config.getSubStore("params", ConfigStore.class);
                ConfigStore substore = basesubstore.getSubStore(CONFIG_PREFIX + i, ConfigStore.class);
                String enable = substore.getString(CONFIG_POLICY_ENABLE);
                logger.info("CertificatePoliciesExtension: policy #" + i);
                logger.info("CertificatePoliciesExtension: - enable: " + enable);
                if (enable == null || !enable.equals("true")) continue;
                String policyId = substore.getString(CONFIG_POLICY_ID);
                logger.info("CertificatePoliciesExtension: - policy ID: " + policyId);
                CertificatePolicyId cpolicyId = this.getPolicyId(policyId);
                int qualifierNum = Integer.parseInt(substore.getString(CONFIG_POLICY_QUALIFIERS_NUM, "0"));
                logger.info("CertificatePoliciesExtension: - qualifiers: " + qualifierNum);
                PolicyQualifiers policyQualifiers = new PolicyQualifiers();
                for (int j = 0; j < qualifierNum; ++j) {
                    ConfigStore substore1 = substore.getSubStore(CONFIG_PREFIX1 + j, ConfigStore.class);
                    String cpsuriEnable = substore1.getString(CONFIG_CPSURI_ENABLE, "false");
                    logger.info("CertificatePoliciesExtension:   - CPS URI enable: " + cpsuriEnable);
                    if (cpsuriEnable.equals("true")) {
                        String cpsuri = substore1.getString(CONFIG_CPSURI_VALUE, "");
                        logger.info("CertificatePoliciesExtension:     CPS URI: " + cpsuri);
                        PolicyQualifierInfo qualifierInfo = this.createCPSuri(cpsuri);
                        if (qualifierInfo == null) continue;
                        policyQualifiers.add(qualifierInfo);
                        continue;
                    }
                    String usernoticeEnable = substore1.getString(CONFIG_USERNOTICE_ENABLE, "false");
                    logger.info("CertificatePoliciesExtension:   - user notice enable: " + cpsuriEnable);
                    if (!usernoticeEnable.equals("true")) continue;
                    String orgName = substore1.getString(CONFIG_USERNOTICE_ORG);
                    logger.info("CertificatePoliciesExtension:     organization: " + orgName);
                    String noticenumbers = substore1.getString(CONFIG_USERNOTICE_NUMBERS);
                    String explicitText = substore1.getString(CONFIG_USERNOTICE_TEXT);
                    PolicyQualifierInfo qualifierInfo = this.createUserNotice(orgName, explicitText, noticenumbers);
                    if (qualifierInfo == null) continue;
                    policyQualifiers.add(qualifierInfo);
                }
                CertificatePolicyInfo info = policyQualifiers.size() <= 0 ? new CertificatePolicyInfo(cpolicyId) : new CertificatePolicyInfo(cpolicyId, policyQualifiers);
                certificatePolicies.addElement(info);
            }
            return new CertificatePoliciesExtension(critical, certificatePolicies);
        }
        catch (EPropertyException e) {
            throw new EProfileException(e.toString());
        }
        catch (EProfileException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Unable to create CertificatePoliciesExtension: " + e.getMessage(), (Throwable)e);
            throw new EProfileException("Unable to create CertificatePoliciesExtension: " + e.getMessage(), (Throwable)e);
        }
    }

    private CertificatePolicyId getPolicyId(String policyId) throws EPropertyException {
        if (policyId == null || policyId.length() == 0) {
            throw new EPropertyException(CMS.getUserMessage((String)"CMS_PROFILE_CERTIFICATE_POLICIES_EMPTY_POLICYID", (String[])new String[0]));
        }
        CertificatePolicyId cpolicyId = null;
        try {
            cpolicyId = new CertificatePolicyId(ObjectIdentifier.getObjectIdentifier((String)policyId));
            return cpolicyId;
        }
        catch (Exception e) {
            throw new EPropertyException(CMS.getUserMessage((String)"CMS_PROFILE_CERTIFICATE_POLICIES_POLICYID_ERROR", (String[])new String[]{policyId}));
        }
    }

    private PolicyQualifierInfo createCPSuri(String uri) throws EPropertyException {
        if (uri == null || uri.length() == 0) {
            throw new EPropertyException(CMS.getUserMessage((String)"CMS_PROFILE_CERTIFICATE_POLICIES_EMPTY_CPSURI", (String[])new String[0]));
        }
        CPSuri cpsURI = new CPSuri(uri);
        PolicyQualifierInfo policyQualifierInfo2 = new PolicyQualifierInfo(PolicyQualifierInfo.QT_CPS, (Qualifier)cpsURI);
        return policyQualifierInfo2;
    }

    private PolicyQualifierInfo createUserNotice(String organization, String noticeNums, String noticeText) throws EPropertyException {
        if (!(organization != null && organization.length() != 0 || noticeNums != null && noticeNums.length() != 0 || noticeText != null && noticeText.length() != 0)) {
            return null;
        }
        DisplayText explicitText = null;
        if (noticeText != null && noticeText.length() > 0) {
            explicitText = new DisplayText(26, noticeText);
        }
        int[] nums = null;
        if (noticeNums != null && noticeNums.length() > 0) {
            Vector<String> numsVector = new Vector<String>();
            StringTokenizer tokens = new StringTokenizer(noticeNums, ";");
            while (tokens.hasMoreTokens()) {
                String num = tokens.nextToken().trim();
                numsVector.addElement(num);
            }
            nums = new int[numsVector.size()];
            try {
                for (int i = 0; i < numsVector.size(); ++i) {
                    Integer ii = Integer.valueOf((String)numsVector.elementAt(i));
                    nums[i] = ii;
                }
            }
            catch (Exception e) {
                throw new EPropertyException("Wrong notice numbers");
            }
        }
        DisplayText orgName = null;
        if (organization != null && organization.length() > 0) {
            orgName = new DisplayText(26, organization);
        }
        NoticeReference noticeReference = null;
        if (orgName != null) {
            noticeReference = new NoticeReference(orgName, nums);
        }
        UserNotice userNotice = null;
        if (explicitText != null || noticeReference != null) {
            userNotice = new UserNotice(noticeReference, explicitText);
            PolicyQualifierInfo policyQualifierInfo1 = new PolicyQualifierInfo(PolicyQualifierInfo.QT_UNOTICE, (Qualifier)userNotice);
            return policyQualifierInfo1;
        }
        return null;
    }
}

