/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.jobs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.base.MetaInfo;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.certsrv.request.RequestId;
import com.netscape.cms.jobs.Job;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.jobs.JobConfig;
import com.netscape.cmscore.jobs.JobsScheduler;
import com.netscape.cmscore.ldap.CAPublisherProcessor;
import com.netscape.cmscore.notification.EmailFormProcessor;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestQueue;
import com.netscape.cmscore.request.RequestRepository;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishCertsJob
extends Job
implements IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(PublishCertsJob.class);
    RequestRepository requestRepository;
    RequestQueue mReqQ;
    CertificateRepository mRepository;
    CAPublisherProcessor mPublisherProcessor;
    private boolean mSummary = false;
    protected static String[] mConfigParams = new String[]{"enabled", "cron", "summary.enabled", "summary.emailSubject", "summary.emailTemplate", "summary.itemTemplate", "summary.senderEmail", "summary.recipientEmail"};

    public String[] getExtendedPluginInfo() {
        String[] s = new String[]{"HELP_TEXT; A job that checks for valid certificates in the database, that have not been published and publish them to the publishing directory", "cron;string;Format: minute hour dayOfMonth month dayOfWeek. Use '*' for 'every'. For dayOfWeek, 0 is Sunday", "summary.senderEmail;string;Specify the address to be used as the email's 'sender'. Bounces go to this address.", "summary.recipientEmail;string;Who should receive summaries", "enabled;boolean;Enable this plugin", "summary.enabled;boolean;Enable the summary. You must enabled this for the job to work.", "summary.emailSubject;string;Subject of summary email", "summary.emailTemplate;string;Fully qualified pathname of template file of email to be sent", "summary.itemTemplate;string;Fully qualified pathname of file containing template for each item", "HELP_TOKEN;configuration-jobrules-unpublishexpiredjobs"};
        return s;
    }

    public void init(JobsScheduler scheduler, String id, String implName, JobConfig config) throws EBaseException {
        super.init(scheduler, id, implName, config);
        CAEngine caEngine = (CAEngine)this.engine;
        this.requestRepository = caEngine.getRequestRepository();
        this.mReqQ = caEngine.getRequestQueue();
        this.mRepository = caEngine.getCertificateRepository();
        this.mPublisherProcessor = caEngine.getPublisherProcessor();
        ConfigStore sc = this.mConfig.getSubStore("summary", ConfigStore.class);
        boolean enabled = sc.getBoolean("enabled", false);
        logger.info("PublishCertsJob: - enabled: " + enabled);
        if (enabled) {
            this.mSummary = true;
            this.mSummaryMailSubject = sc.getString("emailSubject");
            logger.info("PublishCertsJob: - subject: " + this.mSummaryMailSubject);
            this.mMailForm = sc.getString("emailTemplate");
            logger.info("PublishCertsJob: - mail template: " + this.mMailForm);
            this.mItemForm = sc.getString("itemTemplate");
            logger.info("PublishCertsJob: - item template: " + this.mItemForm);
            this.mSummarySenderEmail = sc.getString("senderEmail");
            logger.info("PublishCertsJob: - sender email: " + this.mSummarySenderEmail);
            this.mSummaryReceiverEmail = sc.getString("recipientEmail");
            logger.info("PublishCertsJob: - receiver email: " + this.mSummaryReceiverEmail);
        } else {
            this.mSummary = false;
        }
    }

    public void run() {
        CertRecord rec;
        logger.info("PublishCertsJob: Running job " + this.mId);
        Date date = new Date();
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        String nowString = dateFormat.format(date);
        String filter = "(!(certMetainfo=inLdapPublishDir:true))";
        Enumeration<Object> unpublishedCerts = null;
        try {
            unpublishedCerts = this.mRepository.findCertRecs(filter);
        }
        catch (EBaseException e) {
            logger.warn("PublishCertsJob: " + CMS.getLogMessage((String)"OPERATION_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        int count = 0;
        int negCount = 0;
        String contentForm = null;
        String itemForm = null;
        Object itemListContent = null;
        if (this.mSummary) {
            contentForm = this.getTemplateContent(this.mMailForm);
            itemForm = this.getTemplateContent(this.mItemForm);
        }
        while (unpublishedCerts != null && unpublishedCerts.hasMoreElements() && (rec = (CertRecord)unpublishedCerts.nextElement()) != null) {
            block35: {
                CertId certID = new CertId(rec.getSerialNumber());
                logger.info("PublishCertsJob: Publishing cert " + certID.toHexString());
                X509CertImpl cert = rec.getCertificate();
                Date notAfter = cert.getNotAfter();
                if (cert.getBasicConstraintsIsCA()) {
                    logger.info("PublishCertsJob: Cert " + certID.toHexString() + " is a CA cert");
                    continue;
                }
                if (notAfter.before(date)) {
                    logger.info("PublishCertsJob: Cert " + certID.toHexString() + " has expired");
                    continue;
                }
                if (this.mSummary) {
                    this.buildItemParams(cert);
                }
                MetaInfo minfo = null;
                try {
                    minfo = (MetaInfo)rec.get("certMetaInfo");
                }
                catch (EBaseException e) {
                    ++negCount;
                    if (this.mSummary) {
                        this.buildItemParams("Status", "failed");
                    }
                    logger.warn("PublishCertsJob: " + CMS.getLogMessage((String)"JOBS_META_INFO_ERROR", (Object[])new Object[]{cert.getSerialNumber().toString(16) + e.getMessage()}), (Throwable)e);
                }
                String ridString = null;
                try {
                    if (minfo != null) {
                        ridString = (String)minfo.get("requestId");
                    }
                }
                catch (EBaseException e) {
                    ++negCount;
                    if (this.mSummary) {
                        this.buildItemParams("Status", "failed");
                    }
                    logger.warn("PublishCertsJob: " + CMS.getLogMessage((String)"JOBS_META_REQUEST_ERROR", (Object[])new Object[]{cert.getSerialNumber().toString(16) + e.getMessage()}), (Throwable)e);
                }
                catch (NullPointerException e) {
                    ++negCount;
                    if (this.mSummary) {
                        this.buildItemParams("Status", "failed");
                    }
                    logger.warn("PublishCertsJob: " + CMS.getLogMessage((String)"JOBS_META_REQUEST_ERROR", (Object[])new Object[]{cert.getSerialNumber().toString(16) + e.getMessage()}), (Throwable)e);
                }
                boolean publishingEnabled = this.mPublisherProcessor != null && this.mPublisherProcessor.isCertPublishingEnabled();
                logger.info("PublishCertsJob: Publishing enabled: " + publishingEnabled);
                if (ridString != null) {
                    RequestId rid = new RequestId(ridString);
                    logger.info("PublishCertsJob: Request: " + rid.toHexString());
                    Request req = null;
                    try {
                        req = this.requestRepository.readRequest(rid);
                        if (req != null && this.mSummary) {
                            this.buildItemParams(req);
                        }
                    }
                    catch (EBaseException e) {
                        ++negCount;
                        if (this.mSummary) {
                            this.buildItemParams("Status", "failed");
                        }
                        logger.warn("PublishCertsJob: " + CMS.getLogMessage((String)"JOBS_FIND_REQUEST_ERROR", (Object[])new Object[]{cert.getSerialNumber().toString(16) + e.getMessage()}), (Throwable)e);
                    }
                    try {
                        if (publishingEnabled) {
                            logger.info("PublishCertsJob: Publishing cert " + certID.toHexString() + " with request " + rid.toHexString());
                            this.mPublisherProcessor.publishCert((X509Certificate)cert, req);
                            if (this.mSummary) {
                                this.buildItemParams("Status", "succeeded");
                            }
                            ++count;
                            break block35;
                        }
                        ++negCount;
                    }
                    catch (Exception e) {
                        ++negCount;
                        if (this.mSummary) {
                            this.buildItemParams("Status", "failed");
                        }
                        logger.warn("PublishCertsJob: " + CMS.getLogMessage((String)"JOBS_PUBLISH_ERROR", (Object[])new Object[]{cert.getSerialNumber().toString(16) + e.getMessage()}), (Throwable)e);
                    }
                } else {
                    try {
                        if (publishingEnabled) {
                            logger.info("PublishCertsJob: Publishing cert " + certID.toHexString() + " without request");
                            this.mPublisherProcessor.publishCert((X509Certificate)cert, null);
                            if (this.mSummary) {
                                this.buildItemParams("Status", "succeeded");
                            }
                            ++count;
                        } else {
                            ++negCount;
                        }
                    }
                    catch (Exception e) {
                        ++negCount;
                        if (this.mSummary) {
                            this.buildItemParams("Status", "failed");
                        }
                        logger.warn("PublishCertsJob: " + CMS.getLogMessage((String)"JOBS_PUBLISH_ERROR", (Object[])new Object[]{cert.getSerialNumber().toString(16) + e.getMessage()}), (Throwable)e);
                    }
                }
            }
            if (!this.mSummary) continue;
            EmailFormProcessor emailItemFormProcessor = new EmailFormProcessor();
            String c = emailItemFormProcessor.getEmailContent(itemForm, this.mItemParams);
            if (itemListContent == null) {
                itemListContent = c;
                continue;
            }
            itemListContent = (String)itemListContent + c;
        }
        if (this.mSummary) {
            this.buildContentParams("InstanceID", this.mId);
            this.buildContentParams("SummaryItemList", (String)itemListContent);
            this.buildContentParams("SummaryTotalNum", String.valueOf(count + negCount));
            this.buildContentParams("SummaryTotalSuccess", String.valueOf(count));
            this.buildContentParams("SummaryTotalFailure", String.valueOf(negCount));
            this.buildContentParams("ExecutionTime", nowString);
            EmailFormProcessor emailFormProcessor = new EmailFormProcessor();
            String mailContent = emailFormProcessor.getEmailContent(contentForm, this.mContentParams);
            this.mailSummary(mailContent);
        }
    }

    public String[] getConfigParams() {
        return mConfigParams;
    }
}

