/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.server;

import java.net.URI;
import java.util.Date;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.dogtagpki.acme.ACMEAccount;
import org.dogtagpki.acme.ACMEHeader;
import org.dogtagpki.acme.ACMENonce;
import org.dogtagpki.acme.ACMEOrder;
import org.dogtagpki.acme.JWS;
import org.dogtagpki.acme.issuer.ACMEIssuer;
import org.dogtagpki.acme.server.ACMEEngine;
import org.dogtagpki.acme.server.ACMEManagedService;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;
import org.mozilla.jss.netscape.security.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="order/{id}/finalize")
@ACMEManagedService
public class ACMEFinalizeOrderService {
    public static Logger logger = LoggerFactory.getLogger(ACMEFinalizeOrderService.class);
    @Context
    UriInfo uriInfo;

    @POST
    @Produces(value={"application/json"})
    public Response handlePOST(@PathParam(value="id") String orderID, JWS jws) throws Exception {
        logger.info("Finalizing order " + orderID);
        String protectedHeader = new String(jws.getProtectedHeaderAsBytes(), "UTF-8");
        logger.info("Header: " + protectedHeader);
        ACMEHeader header = ACMEHeader.fromJSON((String)protectedHeader);
        ACMEEngine engine = ACMEEngine.getInstance();
        engine.validateNonce(header.getNonce());
        URI kid = header.getKid();
        String kidPath = kid.getPath();
        String accountID = kidPath.substring(kidPath.lastIndexOf(47) + 1);
        logger.info("Account ID: " + accountID);
        ACMEAccount account = engine.getAccount(accountID);
        engine.validateJWS(jws, header.getAlg(), account.getJWK());
        String payload = new String(jws.getPayloadAsBytes(), "UTF-8");
        logger.info("Payload: " + payload);
        ACMEOrder order = engine.getOrder(account, orderID);
        if (!order.getStatus().equals("ready")) {
            throw new Exception("Order not ready: " + orderID);
        }
        order.setStatus("processing");
        Date processingOrderExpirationTime = engine.getPolicy().getProcessingOrderExpirationTime(new Date());
        order.setExpirationTime(processingOrderExpirationTime);
        engine.updateOrder(account, order);
        ACMEOrder request = ACMEOrder.fromJSON((String)payload);
        String csr = request.getCSR();
        logger.info("CSR: " + csr);
        byte[] csrBytes = Utils.base64decode((String)csr);
        PKCS10 pkcs10 = new PKCS10(csrBytes);
        engine.validateCSR(account, order, pkcs10);
        ACMEIssuer issuer = engine.getIssuer();
        String certID = issuer.issueCertificate(pkcs10);
        logger.info("Certificate issued: " + certID);
        order.setCertID(certID);
        order.setStatus("valid");
        Date validOrderExpirationTime = engine.getPolicy().getValidOrderExpirationTime(new Date());
        order.setExpirationTime(validOrderExpirationTime);
        engine.updateOrder(account, order);
        URI finalizeURL = this.uriInfo.getBaseUriBuilder().path("order").path(orderID).path("finalize").build(new Object[0]);
        order.setFinalize(finalizeURL);
        URI certURL = this.uriInfo.getBaseUriBuilder().path("cert").path(certID).build(new Object[0]);
        order.setCertificate(certURL);
        Response.ResponseBuilder builder = Response.ok();
        ACMENonce nonce = engine.createNonce();
        builder.header("Replay-Nonce", (Object)nonce.getID());
        URI orderURL = this.uriInfo.getBaseUriBuilder().path("order").path(orderID).build(new Object[0]);
        builder.location(orderURL);
        URI indexURL = this.uriInfo.getBaseUriBuilder().path("directory").build(new Object[0]);
        builder.link(indexURL, "index");
        builder.entity((Object)order);
        return builder.build();
    }
}

