/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.tps.profile;

import com.netscape.certsrv.tps.profile.ProfileMappingClient;
import com.netscape.certsrv.tps.profile.ProfileMappingData;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.tps.profile.ProfileMappingCLI;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileMappingShowCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(ProfileMappingShowCLI.class);
    public ProfileMappingCLI profileMappingCLI;

    public ProfileMappingShowCLI(ProfileMappingCLI profileMappingCLI) {
        super("show", "Show profileMapping", (CLI)profileMappingCLI);
        this.profileMappingCLI = profileMappingCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <Profile Mapping ID> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "output", true, "Output file to store profile mapping properties.");
        option.setArgName("file");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 1) {
            throw new Exception("No Profile Mapping ID specified.");
        }
        String profileMappingID = cmdArgs[0];
        String output = cmd.getOptionValue("output");
        ProfileMappingClient profileMappingClient = this.profileMappingCLI.getProfileMappingClient();
        ProfileMappingData profileMappingData = profileMappingClient.getProfileMapping(profileMappingID);
        if (output == null) {
            MainCLI.printMessage("ProfileMapping \"" + profileMappingID + "\"");
            ProfileMappingCLI.printProfileMappingData(profileMappingData, true);
        } else {
            try (PrintWriter out = new PrintWriter(new FileWriter(output));){
                out.println(profileMappingData);
            }
            MainCLI.printMessage("Stored profile mapping \"" + profileMappingID + "\" into " + output);
        }
    }
}

