/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.tps.profile;

import com.netscape.certsrv.tps.profile.ProfileMappingClient;
import com.netscape.certsrv.tps.profile.ProfileMappingData;
import com.netscape.certsrv.util.JSONSerializer;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.tps.profile.ProfileMappingCLI;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileMappingModifyCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(ProfileMappingModifyCLI.class);
    public ProfileMappingCLI profileMappingCLI;

    public ProfileMappingModifyCLI(ProfileMappingCLI profileMappingCLI) {
        super("mod", "Modify profile mapping", (CLI)profileMappingCLI);
        this.profileMappingCLI = profileMappingCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <Profile Mapping ID> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "action", true, "Action: update (default), approve, reject, enable, disable.");
        option.setArgName("action");
        this.options.addOption(option);
        option = new Option(null, "input", true, "Input file containing profile mapping properties.");
        option.setArgName("file");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        ProfileMappingData profileMappingData;
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 1) {
            throw new Exception("No Profile Mapping ID specified.");
        }
        String profileMappingID = cmdArgs[0];
        String action = cmd.getOptionValue("action", "update");
        String input = cmd.getOptionValue("input");
        ProfileMappingClient profileMappingClient = this.profileMappingCLI.getProfileMappingClient();
        if (action.equals("update")) {
            if (input == null) {
                throw new Exception("Missing input file");
            }
            try (BufferedReader in = new BufferedReader(new FileReader(input));
                 StringWriter sw = new StringWriter();
                 PrintWriter out = new PrintWriter((Writer)sw, true);){
                String line;
                while ((line = in.readLine()) != null) {
                    out.println(line);
                }
                profileMappingData = (ProfileMappingData)JSONSerializer.fromJSON((String)sw.toString(), ProfileMappingData.class);
            }
            profileMappingData = profileMappingClient.updateProfileMapping(profileMappingID, profileMappingData);
        } else {
            profileMappingData = profileMappingClient.changeProfileMappingStatus(profileMappingID, action);
        }
        MainCLI.printMessage("Modified profile mapping \"" + profileMappingID + "\"");
        ProfileMappingCLI.printProfileMappingData(profileMappingData, true);
    }
}

