/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.profile;

import com.netscape.certsrv.profile.ProfileClient;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.profile.ProfileCLI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileEditCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(ProfileEditCLI.class);
    public ProfileCLI profileCLI;

    public ProfileEditCLI(ProfileCLI profileCLI) {
        super("edit", "Edit profiles (config-store format)", (CLI)profileCLI);
        this.profileCLI = profileCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <Profile ID> [OPTIONS...]", this.options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length < 1) {
            throw new Exception("No Profile ID specified.");
        }
        String profileId = cmdArgs[0];
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        ProfileClient profileClient = this.profileCLI.getProfileClient();
        byte[] orig = profileClient.retrieveProfileRaw(profileId);
        ProfileCLI.checkConfiguration(orig, false, true);
        Path tempFile = Files.createTempFile("pki", ".cfg", new FileAttribute[0]);
        try {
            Files.write(tempFile, orig, new OpenOption[0]);
            String editor = System.getenv("EDITOR");
            String[] command = editor == null || editor.trim().isEmpty() ? new String[]{"/usr/bin/env", "vi", tempFile.toString()} : new String[]{editor.trim(), tempFile.toString()};
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.inheritIO();
            int exitCode = pb.start().waitFor();
            if (exitCode != 0) {
                throw new Exception("Exited abnormally.");
            }
            byte[] cur = ProfileCLI.readRawProfileFromFile(tempFile);
            if (!Arrays.equals(cur, orig)) {
                profileClient.modifyProfileRaw(profileId, cur);
            }
            System.out.write(cur);
        }
        finally {
            Files.delete(tempFile);
        }
    }
}

