/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.group;

import com.netscape.certsrv.group.GroupClient;
import com.netscape.certsrv.group.GroupMemberCollection;
import com.netscape.certsrv.group.GroupMemberData;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.group.GroupMemberCLI;
import java.util.Collection;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupMemberFindCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(GroupMemberFindCLI.class);
    public GroupMemberCLI groupMemberCLI;

    public GroupMemberFindCLI(GroupMemberCLI groupMemberCLI) {
        super("find", "Find group members", (CLI)groupMemberCLI);
        this.groupMemberCLI = groupMemberCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <Group ID> [FILTER] [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "start", true, "Page start");
        option.setArgName("start");
        this.options.addOption(option);
        option = new Option(null, "size", true, "Page size");
        option.setArgName("size");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length < 1 || cmdArgs.length > 2) {
            throw new Exception("Incorrect number of arguments specified.");
        }
        String groupID = cmdArgs[0];
        String filter = cmdArgs.length < 2 ? null : cmdArgs[1];
        String s = cmd.getOptionValue("start");
        Integer start = s == null ? null : Integer.valueOf(s);
        s = cmd.getOptionValue("size");
        Integer size = s == null ? null : Integer.valueOf(s);
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        GroupClient groupClient = this.groupMemberCLI.getGroupClient();
        GroupMemberCollection response = groupClient.findGroupMembers(groupID, filter, start, size);
        MainCLI.printMessage(response.getTotal() + " entries matched");
        if (response.getTotal() == 0) {
            return;
        }
        Collection entries = response.getEntries();
        boolean first = true;
        for (GroupMemberData groupMemberData : entries) {
            if (first) {
                first = false;
            } else {
                System.out.println();
            }
            GroupMemberCLI.printGroupMember(groupMemberData);
        }
        MainCLI.printMessage("Number of entries returned " + entries.size());
    }
}

