/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.est;

import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.base.ForbiddenException;
import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.base.ResourceNotFoundException;
import com.netscape.certsrv.base.UnauthorizedException;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.dogtagpki.est.ESTBackend;
import org.dogtagpki.est.ESTEngine;
import org.dogtagpki.est.ESTRequestAuthorizationData;
import org.dogtagpki.est.ESTRequestAuthorizer;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;
import org.mozilla.jss.netscape.security.x509.CertificateChain;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.SubjectAlternativeNameExtension;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="")
public class ESTFrontend {
    public static Logger logger = LoggerFactory.getLogger(ESTFrontend.class);
    @Context
    protected HttpServletRequest servletRequest;

    private ESTBackend getBackend() {
        return ESTEngine.getInstance().getBackend();
    }

    private ESTRequestAuthorizer getRequestAuthorizer() {
        return ESTEngine.getInstance().getRequestAuthorizer();
    }

    @GET
    @Path(value="cacerts")
    @Produces(value={"application/pkcs7-mime"})
    public Response cacerts() {
        return this.cacerts(Optional.empty());
    }

    @GET
    @Path(value="{label}/cacerts")
    @Produces(value={"application/pkcs7-mime"})
    public Response cacerts(@PathParam(value="label") String label) {
        return this.cacerts(Optional.of(label));
    }

    private Response cacerts(Optional<String> label) throws PKIException {
        CertificateChain chain = this.getBackend().cacerts(label);
        if (chain == null) {
            throw new ResourceNotFoundException("Certificate chain for CA not available");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            chain.encode((OutputStream)out);
        }
        catch (IOException e) {
            throw new PKIException("Error encoding certificate chain", (Throwable)e);
        }
        return Response.ok((Object)Base64.encodeBase64((byte[])out.toByteArray(), (boolean)true)).build();
    }

    @POST
    @Path(value="simpleenroll")
    @Consumes(value={"application/pkcs10"})
    @Produces(value={"application/pkcs7-mime; smime-type=certs-only"})
    public Response simpleenroll(byte[] data) throws PKIException {
        logger.debug("ESTFrontend.simpleenroll: processing request (no label)");
        return this.enroll(Optional.empty(), data);
    }

    @POST
    @Path(value="{label}/simpleenroll")
    @Consumes(value={"application/pkcs10"})
    @Produces(value={"application/pkcs7-mime; smime-type=certs-only"})
    public Response simpleenroll(@PathParam(value="label") String label, byte[] data) {
        logger.debug("ESTFrontend.simpleenroll: processing request (label: " + label + ")");
        return this.enroll(Optional.of(label), data);
    }

    @POST
    @Path(value="simplereenroll")
    @Consumes(value={"application/pkcs10"})
    @Produces(value={"application/pkcs7-mime; smime-type=certs-only"})
    public Response simplereenroll(byte[] data) {
        logger.debug("ESTFrontend.simplereenroll: processing request (no label)");
        return this.reenroll(Optional.empty(), data);
    }

    @POST
    @Path(value="{label}/simplereenroll")
    @Consumes(value={"application/pkcs10"})
    @Produces(value={"application/pkcs7-mime; smime-type=certs-only"})
    public Response simplereenroll(@PathParam(value="label") String label, byte[] data) {
        logger.debug("ESTFrontend.simplereenroll: processing request (label: " + label + ")");
        return this.reenroll(Optional.of(label), data);
    }

    private Response enroll(Optional<String> label, byte[] data) throws PKIException {
        PKCS10 csr = ESTFrontend.parseCSR(data);
        Object authzResult = this.getRequestAuthorizer().authorizeSimpleenroll(this.makeAuthzData(label), csr);
        X509CertImpl cert = this.getBackend().simpleenroll(label, csr, authzResult);
        return ESTFrontend.certResponse((X509Certificate)cert);
    }

    private Response reenroll(Optional<String> label, byte[] data) throws PKIException {
        PKCS10 csr = ESTFrontend.parseCSR(data);
        ESTRequestAuthorizationData authzData = this.makeAuthzData(label);
        X509Certificate toBeRenewed = null;
        if (authzData.clientCertChain != null && authzData.clientCertChain.length > 0) {
            toBeRenewed = authzData.clientCertChain[0];
        }
        if (toBeRenewed == null) {
            throw new ForbiddenException("Unable to locate certificate to be renewed.");
        }
        ESTFrontend.ensureCSRMatchesToBeRenewedCert(csr, toBeRenewed);
        Object authzResult = this.getRequestAuthorizer().authorizeSimplereenroll(authzData, csr, toBeRenewed);
        X509CertImpl cert = this.getBackend().simplereenroll(label, csr, authzResult);
        return ESTFrontend.certResponse((X509Certificate)cert);
    }

    private ESTRequestAuthorizationData makeAuthzData(Optional<String> label) {
        ESTRequestAuthorizationData data = new ESTRequestAuthorizationData();
        data.label = label;
        Principal principal = this.servletRequest.getUserPrincipal();
        if (principal == null) {
            throw new UnauthorizedException("Not authenticated");
        }
        logger.info("ESTFrontend: authenticated client: " + principal);
        data.principal = principal;
        data.clientCertChain = (X509Certificate[])this.servletRequest.getAttribute("javax.servlet.request.X509Certificate");
        data.remoteAddr = this.servletRequest.getRemoteAddr();
        return data;
    }

    private static PKCS10 parseCSR(byte[] data) throws PKIException {
        try {
            return new PKCS10(Base64.decodeBase64((byte[])data));
        }
        catch (IOException | IllegalArgumentException | NoSuchAlgorithmException | SignatureException e) {
            throw new BadRequestException("Invalid CSR: " + e, (Throwable)e);
        }
        catch (Exception e) {
            throw new PKIException("Internal server error decoding CSR: " + e, (Throwable)e);
        }
    }

    public static void ensureCSRMatchesToBeRenewedCert(PKCS10 csr, X509Certificate cert_) throws ForbiddenException {
        X509CertImpl cert;
        if (cert_ instanceof X509CertImpl) {
            cert = (X509CertImpl)cert_;
        } else {
            try {
                cert = new X509CertImpl(cert_.getEncoded());
            }
            catch (CertificateException e) {
                throw new ForbiddenException("Failed to decode certificate to be renewed.");
            }
        }
        if (!csr.getSubjectName().equals((Object)cert.getSubjectName())) {
            throw new ForbiddenException("CSR subject does not match certificate to be renewed.");
        }
        SubjectAlternativeNameExtension csrSAN = null;
        try {
            csrSAN = (SubjectAlternativeNameExtension)CryptoUtil.getExtensionFromPKCS10((PKCS10)csr, (String)"SubjectAlternativeName");
        }
        catch (IOException | CertificateException e) {
            throw new BadRequestException("Failed to decode SAN extension in CSR");
        }
        SubjectAlternativeNameExtension certSAN = (SubjectAlternativeNameExtension)cert.getExtension(PKIXExtensions.SubjectAlternativeName_Id.toString());
        if (csrSAN != null && certSAN != null) {
            if (!Arrays.equals(csrSAN.getExtensionValue(), certSAN.getExtensionValue())) {
                throw new ForbiddenException("SAN extensions of certificate to be renewed and CSR are not identical.");
            }
        } else {
            if (csrSAN == null && certSAN != null) {
                throw new ForbiddenException("Certificate to be renewed has SubjectAlternativeName extension, but CSR does not.");
            }
            if (csrSAN != null && certSAN == null) {
                throw new ForbiddenException("Certificate to be renewed does not have SubjectAlternativeName extension, but CSR does.");
            }
        }
    }

    private static Response certResponse(X509Certificate cert) throws PKIException {
        CertificateChain chain = new CertificateChain(cert);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            chain.encode((OutputStream)out);
        }
        catch (IOException e) {
            logger.error("Error encoding certificate chain: " + e, (Throwable)e);
            throw new PKIException("Error encoding certificate chain: " + e, (Throwable)e);
        }
        return Response.ok((Object)Base64.encodeBase64((byte[])out.toByteArray(), (boolean)true)).build();
    }
}

