/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// RepositoriesPythonAPIService RepositoriesPythonAPI service
type RepositoriesPythonAPIService service

type RepositoriesPythonAPIRepositoriesPythonPythonCreateRequest struct {
	ctx context.Context
	ApiService *RepositoriesPythonAPIService
	pythonPythonRepository *PythonPythonRepository
}

func (r RepositoriesPythonAPIRepositoriesPythonPythonCreateRequest) PythonPythonRepository(pythonPythonRepository PythonPythonRepository) RepositoriesPythonAPIRepositoriesPythonPythonCreateRequest {
	r.pythonPythonRepository = &pythonPythonRepository
	return r
}

func (r RepositoriesPythonAPIRepositoriesPythonPythonCreateRequest) Execute() (*PythonPythonRepositoryResponse, *http.Response, error) {
	return r.ApiService.RepositoriesPythonPythonCreateExecute(r)
}

/*
RepositoriesPythonPythonCreate Create a python repository

PythonRepository represents a single Python repository, to which content can be
synced, added, or removed.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return RepositoriesPythonAPIRepositoriesPythonPythonCreateRequest
*/
func (a *RepositoriesPythonAPIService) RepositoriesPythonPythonCreate(ctx context.Context) RepositoriesPythonAPIRepositoriesPythonPythonCreateRequest {
	return RepositoriesPythonAPIRepositoriesPythonPythonCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PythonPythonRepositoryResponse
func (a *RepositoriesPythonAPIService) RepositoriesPythonPythonCreateExecute(r RepositoriesPythonAPIRepositoriesPythonPythonCreateRequest) (*PythonPythonRepositoryResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PythonPythonRepositoryResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesPythonAPIService.RepositoriesPythonPythonCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/repositories/python/python/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.pythonPythonRepository == nil {
		return localVarReturnValue, nil, reportError("pythonPythonRepository is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.pythonPythonRepository
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesPythonAPIRepositoriesPythonPythonDeleteRequest struct {
	ctx context.Context
	ApiService *RepositoriesPythonAPIService
	pythonPythonRepositoryHref string
}

func (r RepositoriesPythonAPIRepositoriesPythonPythonDeleteRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesPythonPythonDeleteExecute(r)
}

/*
RepositoriesPythonPythonDelete Delete a python repository

Trigger an asynchronous delete task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param pythonPythonRepositoryHref
 @return RepositoriesPythonAPIRepositoriesPythonPythonDeleteRequest
*/
func (a *RepositoriesPythonAPIService) RepositoriesPythonPythonDelete(ctx context.Context, pythonPythonRepositoryHref string) RepositoriesPythonAPIRepositoriesPythonPythonDeleteRequest {
	return RepositoriesPythonAPIRepositoriesPythonPythonDeleteRequest{
		ApiService: a,
		ctx: ctx,
		pythonPythonRepositoryHref: pythonPythonRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesPythonAPIService) RepositoriesPythonPythonDeleteExecute(r RepositoriesPythonAPIRepositoriesPythonPythonDeleteRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesPythonAPIService.RepositoriesPythonPythonDelete")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{python_python_repository_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"python_python_repository_href"+"}", parameterValueToString(r.pythonPythonRepositoryHref, "pythonPythonRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesPythonAPIRepositoriesPythonPythonListRequest struct {
	ctx context.Context
	ApiService *RepositoriesPythonAPIService
	latestWithContent *string
	limit *int32
	name *string
	nameContains *string
	nameIcontains *string
	nameIn *[]string
	nameStartswith *string
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	pulpLabelSelect *string
	remote *string
	retainRepoVersions *int32
	retainRepoVersionsGt *int32
	retainRepoVersionsGte *int32
	retainRepoVersionsIsnull *bool
	retainRepoVersionsLt *int32
	retainRepoVersionsLte *int32
	retainRepoVersionsNe *int32
	retainRepoVersionsRange *[]int32
	withContent *string
	fields *[]string
	excludeFields *[]string
}

// Content Unit referenced by HREF
func (r RepositoriesPythonAPIRepositoriesPythonPythonListRequest) LatestWithContent(latestWithContent string) RepositoriesPythonAPIRepositoriesPythonPythonListRequest {
	r.latestWithContent = &latestWithContent
	return r
}

// Number of results to return per page.
func (r RepositoriesPythonAPIRepositoriesPythonPythonListRequest) Limit(limit int32) RepositoriesPythonAPIRepositoriesPythonPythonListRequest {
	r.limit = &limit
	return r
}

// Filter results where name matches value
func (r RepositoriesPythonAPIRepositoriesPythonPythonListRequest) Name(name string) RepositoriesPythonAPIRepositoriesPythonPythonListRequest {
	r.name = &name
	return r
}

// Filter results where name contains value
func (r RepositoriesPythonAPIRepositoriesPythonPythonListRequest) NameContains(nameContains string) RepositoriesPythonAPIRepositoriesPythonPythonListRequest {
	r.nameContains = &nameContains
	return r
}

// Filter results where name contains value
func (r RepositoriesPythonAPIRepositoriesPythonPythonListRequest) NameIcontains(nameIcontains string) RepositoriesPythonAPIRepositoriesPythonPythonListRequest {
	r.nameIcontains = &nameIcontains
	return r
}

// Filter results where name is in a comma-separated list of values
func (r RepositoriesPythonAPIRepositoriesPythonPythonListRequest) NameIn(nameIn []string) RepositoriesPythonAPIRepositoriesPythonPythonListRequest {
	r.nameIn = &nameIn
	return r
}

// Filter results where name starts with value
func (r RepositoriesPythonAPIRepositoriesPythonPythonListRequest) NameStartswith(nameStartswith string) RepositoriesPythonAPIRepositoriesPythonPythonListRequest {
	r.nameStartswith = &nameStartswith
	return r
}

// The initial index from which to return the results.
func (r RepositoriesPythonAPIRepositoriesPythonPythonListRequest) Offset(offset int32) RepositoriesPythonAPIRepositoriesPythonPythonListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;name&#x60; - Name * &#x60;-name&#x60; - Name (descending) * &#x60;pulp_labels&#x60; - Pulp labels * &#x60;-pulp_labels&#x60; - Pulp labels (descending) * &#x60;description&#x60; - Description * &#x60;-description&#x60; - Description (descending) * &#x60;next_version&#x60; - Next version * &#x60;-next_version&#x60; - Next version (descending) * &#x60;retain_repo_versions&#x60; - Retain repo versions * &#x60;-retain_repo_versions&#x60; - Retain repo versions (descending) * &#x60;user_hidden&#x60; - User hidden * &#x60;-user_hidden&#x60; - User hidden (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r RepositoriesPythonAPIRepositoriesPythonPythonListRequest) Ordering(ordering []string) RepositoriesPythonAPIRepositoriesPythonPythonListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r RepositoriesPythonAPIRepositoriesPythonPythonListRequest) PulpHrefIn(pulpHrefIn []string) RepositoriesPythonAPIRepositoriesPythonPythonListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r RepositoriesPythonAPIRepositoriesPythonPythonListRequest) PulpIdIn(pulpIdIn []string) RepositoriesPythonAPIRepositoriesPythonPythonListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Filter labels by search string
func (r RepositoriesPythonAPIRepositoriesPythonPythonListRequest) PulpLabelSelect(pulpLabelSelect string) RepositoriesPythonAPIRepositoriesPythonPythonListRequest {
	r.pulpLabelSelect = &pulpLabelSelect
	return r
}

// Foreign Key referenced by HREF
func (r RepositoriesPythonAPIRepositoriesPythonPythonListRequest) Remote(remote string) RepositoriesPythonAPIRepositoriesPythonPythonListRequest {
	r.remote = &remote
	return r
}

// Filter results where retain_repo_versions matches value
func (r RepositoriesPythonAPIRepositoriesPythonPythonListRequest) RetainRepoVersions(retainRepoVersions int32) RepositoriesPythonAPIRepositoriesPythonPythonListRequest {
	r.retainRepoVersions = &retainRepoVersions
	return r
}

// Filter results where retain_repo_versions is greater than value
func (r RepositoriesPythonAPIRepositoriesPythonPythonListRequest) RetainRepoVersionsGt(retainRepoVersionsGt int32) RepositoriesPythonAPIRepositoriesPythonPythonListRequest {
	r.retainRepoVersionsGt = &retainRepoVersionsGt
	return r
}

// Filter results where retain_repo_versions is greater than or equal to value
func (r RepositoriesPythonAPIRepositoriesPythonPythonListRequest) RetainRepoVersionsGte(retainRepoVersionsGte int32) RepositoriesPythonAPIRepositoriesPythonPythonListRequest {
	r.retainRepoVersionsGte = &retainRepoVersionsGte
	return r
}

// Filter results where retain_repo_versions has a null value
func (r RepositoriesPythonAPIRepositoriesPythonPythonListRequest) RetainRepoVersionsIsnull(retainRepoVersionsIsnull bool) RepositoriesPythonAPIRepositoriesPythonPythonListRequest {
	r.retainRepoVersionsIsnull = &retainRepoVersionsIsnull
	return r
}

// Filter results where retain_repo_versions is less than value
func (r RepositoriesPythonAPIRepositoriesPythonPythonListRequest) RetainRepoVersionsLt(retainRepoVersionsLt int32) RepositoriesPythonAPIRepositoriesPythonPythonListRequest {
	r.retainRepoVersionsLt = &retainRepoVersionsLt
	return r
}

// Filter results where retain_repo_versions is less than or equal to value
func (r RepositoriesPythonAPIRepositoriesPythonPythonListRequest) RetainRepoVersionsLte(retainRepoVersionsLte int32) RepositoriesPythonAPIRepositoriesPythonPythonListRequest {
	r.retainRepoVersionsLte = &retainRepoVersionsLte
	return r
}

// Filter results where retain_repo_versions not equal to value
func (r RepositoriesPythonAPIRepositoriesPythonPythonListRequest) RetainRepoVersionsNe(retainRepoVersionsNe int32) RepositoriesPythonAPIRepositoriesPythonPythonListRequest {
	r.retainRepoVersionsNe = &retainRepoVersionsNe
	return r
}

// Filter results where retain_repo_versions is between two comma separated values
func (r RepositoriesPythonAPIRepositoriesPythonPythonListRequest) RetainRepoVersionsRange(retainRepoVersionsRange []int32) RepositoriesPythonAPIRepositoriesPythonPythonListRequest {
	r.retainRepoVersionsRange = &retainRepoVersionsRange
	return r
}

// Content Unit referenced by HREF
func (r RepositoriesPythonAPIRepositoriesPythonPythonListRequest) WithContent(withContent string) RepositoriesPythonAPIRepositoriesPythonPythonListRequest {
	r.withContent = &withContent
	return r
}

// A list of fields to include in the response.
func (r RepositoriesPythonAPIRepositoriesPythonPythonListRequest) Fields(fields []string) RepositoriesPythonAPIRepositoriesPythonPythonListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RepositoriesPythonAPIRepositoriesPythonPythonListRequest) ExcludeFields(excludeFields []string) RepositoriesPythonAPIRepositoriesPythonPythonListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RepositoriesPythonAPIRepositoriesPythonPythonListRequest) Execute() (*PaginatedpythonPythonRepositoryResponseList, *http.Response, error) {
	return r.ApiService.RepositoriesPythonPythonListExecute(r)
}

/*
RepositoriesPythonPythonList List python repositorys

PythonRepository represents a single Python repository, to which content can be
synced, added, or removed.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return RepositoriesPythonAPIRepositoriesPythonPythonListRequest
*/
func (a *RepositoriesPythonAPIService) RepositoriesPythonPythonList(ctx context.Context) RepositoriesPythonAPIRepositoriesPythonPythonListRequest {
	return RepositoriesPythonAPIRepositoriesPythonPythonListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedpythonPythonRepositoryResponseList
func (a *RepositoriesPythonAPIService) RepositoriesPythonPythonListExecute(r RepositoriesPythonAPIRepositoriesPythonPythonListRequest) (*PaginatedpythonPythonRepositoryResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedpythonPythonRepositoryResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesPythonAPIService.RepositoriesPythonPythonList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/repositories/python/python/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.latestWithContent != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "latest_with_content", r.latestWithContent, "")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.name != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name, "")
	}
	if r.nameContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__contains", r.nameContains, "")
	}
	if r.nameIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__icontains", r.nameIcontains, "")
	}
	if r.nameIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__in", r.nameIn, "csv")
	}
	if r.nameStartswith != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__startswith", r.nameStartswith, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.pulpLabelSelect != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_label_select", r.pulpLabelSelect, "")
	}
	if r.remote != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "remote", r.remote, "")
	}
	if r.retainRepoVersions != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions", r.retainRepoVersions, "")
	}
	if r.retainRepoVersionsGt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__gt", r.retainRepoVersionsGt, "")
	}
	if r.retainRepoVersionsGte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__gte", r.retainRepoVersionsGte, "")
	}
	if r.retainRepoVersionsIsnull != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__isnull", r.retainRepoVersionsIsnull, "")
	}
	if r.retainRepoVersionsLt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__lt", r.retainRepoVersionsLt, "")
	}
	if r.retainRepoVersionsLte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__lte", r.retainRepoVersionsLte, "")
	}
	if r.retainRepoVersionsNe != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__ne", r.retainRepoVersionsNe, "")
	}
	if r.retainRepoVersionsRange != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__range", r.retainRepoVersionsRange, "csv")
	}
	if r.withContent != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "with_content", r.withContent, "")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesPythonAPIRepositoriesPythonPythonModifyRequest struct {
	ctx context.Context
	ApiService *RepositoriesPythonAPIService
	pythonPythonRepositoryHref string
	repositoryAddRemoveContent *RepositoryAddRemoveContent
}

func (r RepositoriesPythonAPIRepositoriesPythonPythonModifyRequest) RepositoryAddRemoveContent(repositoryAddRemoveContent RepositoryAddRemoveContent) RepositoriesPythonAPIRepositoriesPythonPythonModifyRequest {
	r.repositoryAddRemoveContent = &repositoryAddRemoveContent
	return r
}

func (r RepositoriesPythonAPIRepositoriesPythonPythonModifyRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesPythonPythonModifyExecute(r)
}

/*
RepositoriesPythonPythonModify Modify Repository Content

Trigger an asynchronous task to create a new repository version.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param pythonPythonRepositoryHref
 @return RepositoriesPythonAPIRepositoriesPythonPythonModifyRequest
*/
func (a *RepositoriesPythonAPIService) RepositoriesPythonPythonModify(ctx context.Context, pythonPythonRepositoryHref string) RepositoriesPythonAPIRepositoriesPythonPythonModifyRequest {
	return RepositoriesPythonAPIRepositoriesPythonPythonModifyRequest{
		ApiService: a,
		ctx: ctx,
		pythonPythonRepositoryHref: pythonPythonRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesPythonAPIService) RepositoriesPythonPythonModifyExecute(r RepositoriesPythonAPIRepositoriesPythonPythonModifyRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesPythonAPIService.RepositoriesPythonPythonModify")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{python_python_repository_href}modify/"
	localVarPath = strings.Replace(localVarPath, "{"+"python_python_repository_href"+"}", parameterValueToString(r.pythonPythonRepositoryHref, "pythonPythonRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.repositoryAddRemoveContent == nil {
		return localVarReturnValue, nil, reportError("repositoryAddRemoveContent is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.repositoryAddRemoveContent
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesPythonAPIRepositoriesPythonPythonPartialUpdateRequest struct {
	ctx context.Context
	ApiService *RepositoriesPythonAPIService
	pythonPythonRepositoryHref string
	patchedpythonPythonRepository *PatchedpythonPythonRepository
}

func (r RepositoriesPythonAPIRepositoriesPythonPythonPartialUpdateRequest) PatchedpythonPythonRepository(patchedpythonPythonRepository PatchedpythonPythonRepository) RepositoriesPythonAPIRepositoriesPythonPythonPartialUpdateRequest {
	r.patchedpythonPythonRepository = &patchedpythonPythonRepository
	return r
}

func (r RepositoriesPythonAPIRepositoriesPythonPythonPartialUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesPythonPythonPartialUpdateExecute(r)
}

/*
RepositoriesPythonPythonPartialUpdate Update a python repository

Trigger an asynchronous partial update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param pythonPythonRepositoryHref
 @return RepositoriesPythonAPIRepositoriesPythonPythonPartialUpdateRequest
*/
func (a *RepositoriesPythonAPIService) RepositoriesPythonPythonPartialUpdate(ctx context.Context, pythonPythonRepositoryHref string) RepositoriesPythonAPIRepositoriesPythonPythonPartialUpdateRequest {
	return RepositoriesPythonAPIRepositoriesPythonPythonPartialUpdateRequest{
		ApiService: a,
		ctx: ctx,
		pythonPythonRepositoryHref: pythonPythonRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesPythonAPIService) RepositoriesPythonPythonPartialUpdateExecute(r RepositoriesPythonAPIRepositoriesPythonPythonPartialUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesPythonAPIService.RepositoriesPythonPythonPartialUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{python_python_repository_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"python_python_repository_href"+"}", parameterValueToString(r.pythonPythonRepositoryHref, "pythonPythonRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.patchedpythonPythonRepository == nil {
		return localVarReturnValue, nil, reportError("patchedpythonPythonRepository is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.patchedpythonPythonRepository
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesPythonAPIRepositoriesPythonPythonReadRequest struct {
	ctx context.Context
	ApiService *RepositoriesPythonAPIService
	pythonPythonRepositoryHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r RepositoriesPythonAPIRepositoriesPythonPythonReadRequest) Fields(fields []string) RepositoriesPythonAPIRepositoriesPythonPythonReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RepositoriesPythonAPIRepositoriesPythonPythonReadRequest) ExcludeFields(excludeFields []string) RepositoriesPythonAPIRepositoriesPythonPythonReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RepositoriesPythonAPIRepositoriesPythonPythonReadRequest) Execute() (*PythonPythonRepositoryResponse, *http.Response, error) {
	return r.ApiService.RepositoriesPythonPythonReadExecute(r)
}

/*
RepositoriesPythonPythonRead Inspect a python repository

PythonRepository represents a single Python repository, to which content can be
synced, added, or removed.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param pythonPythonRepositoryHref
 @return RepositoriesPythonAPIRepositoriesPythonPythonReadRequest
*/
func (a *RepositoriesPythonAPIService) RepositoriesPythonPythonRead(ctx context.Context, pythonPythonRepositoryHref string) RepositoriesPythonAPIRepositoriesPythonPythonReadRequest {
	return RepositoriesPythonAPIRepositoriesPythonPythonReadRequest{
		ApiService: a,
		ctx: ctx,
		pythonPythonRepositoryHref: pythonPythonRepositoryHref,
	}
}

// Execute executes the request
//  @return PythonPythonRepositoryResponse
func (a *RepositoriesPythonAPIService) RepositoriesPythonPythonReadExecute(r RepositoriesPythonAPIRepositoriesPythonPythonReadRequest) (*PythonPythonRepositoryResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PythonPythonRepositoryResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesPythonAPIService.RepositoriesPythonPythonRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{python_python_repository_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"python_python_repository_href"+"}", parameterValueToString(r.pythonPythonRepositoryHref, "pythonPythonRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesPythonAPIRepositoriesPythonPythonSyncRequest struct {
	ctx context.Context
	ApiService *RepositoriesPythonAPIService
	pythonPythonRepositoryHref string
	repositorySyncURL *RepositorySyncURL
}

func (r RepositoriesPythonAPIRepositoriesPythonPythonSyncRequest) RepositorySyncURL(repositorySyncURL RepositorySyncURL) RepositoriesPythonAPIRepositoriesPythonPythonSyncRequest {
	r.repositorySyncURL = &repositorySyncURL
	return r
}

func (r RepositoriesPythonAPIRepositoriesPythonPythonSyncRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesPythonPythonSyncExecute(r)
}

/*
RepositoriesPythonPythonSync Sync from remote


Trigger an asynchronous task to sync python content. The sync task will retrieve Python
content from the specified `Remote` and update the specified `Respository`, creating a
new  `RepositoryVersion`.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param pythonPythonRepositoryHref
 @return RepositoriesPythonAPIRepositoriesPythonPythonSyncRequest
*/
func (a *RepositoriesPythonAPIService) RepositoriesPythonPythonSync(ctx context.Context, pythonPythonRepositoryHref string) RepositoriesPythonAPIRepositoriesPythonPythonSyncRequest {
	return RepositoriesPythonAPIRepositoriesPythonPythonSyncRequest{
		ApiService: a,
		ctx: ctx,
		pythonPythonRepositoryHref: pythonPythonRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesPythonAPIService) RepositoriesPythonPythonSyncExecute(r RepositoriesPythonAPIRepositoriesPythonPythonSyncRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesPythonAPIService.RepositoriesPythonPythonSync")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{python_python_repository_href}sync/"
	localVarPath = strings.Replace(localVarPath, "{"+"python_python_repository_href"+"}", parameterValueToString(r.pythonPythonRepositoryHref, "pythonPythonRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.repositorySyncURL == nil {
		return localVarReturnValue, nil, reportError("repositorySyncURL is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.repositorySyncURL
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesPythonAPIRepositoriesPythonPythonUpdateRequest struct {
	ctx context.Context
	ApiService *RepositoriesPythonAPIService
	pythonPythonRepositoryHref string
	pythonPythonRepository *PythonPythonRepository
}

func (r RepositoriesPythonAPIRepositoriesPythonPythonUpdateRequest) PythonPythonRepository(pythonPythonRepository PythonPythonRepository) RepositoriesPythonAPIRepositoriesPythonPythonUpdateRequest {
	r.pythonPythonRepository = &pythonPythonRepository
	return r
}

func (r RepositoriesPythonAPIRepositoriesPythonPythonUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesPythonPythonUpdateExecute(r)
}

/*
RepositoriesPythonPythonUpdate Update a python repository

Trigger an asynchronous update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param pythonPythonRepositoryHref
 @return RepositoriesPythonAPIRepositoriesPythonPythonUpdateRequest
*/
func (a *RepositoriesPythonAPIService) RepositoriesPythonPythonUpdate(ctx context.Context, pythonPythonRepositoryHref string) RepositoriesPythonAPIRepositoriesPythonPythonUpdateRequest {
	return RepositoriesPythonAPIRepositoriesPythonPythonUpdateRequest{
		ApiService: a,
		ctx: ctx,
		pythonPythonRepositoryHref: pythonPythonRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesPythonAPIService) RepositoriesPythonPythonUpdateExecute(r RepositoriesPythonAPIRepositoriesPythonPythonUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPut
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesPythonAPIService.RepositoriesPythonPythonUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{python_python_repository_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"python_python_repository_href"+"}", parameterValueToString(r.pythonPythonRepositoryHref, "pythonPythonRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.pythonPythonRepository == nil {
		return localVarReturnValue, nil, reportError("pythonPythonRepository is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.pythonPythonRepository
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
