/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"os"
)

// checks if the AnsibleCollectionVersion type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &AnsibleCollectionVersion{}

// AnsibleCollectionVersion A serializer for CollectionVersion Content.
type AnsibleCollectionVersion struct {
	// An uncommitted upload that may be turned into the artifact of the content unit.
	Upload *string `json:"upload,omitempty"`
	// Artifact file representing the physical content
	Artifact *string `json:"artifact,omitempty"`
	// A URI of a repository the new content unit should be associated with.
	Repository *string `json:"repository,omitempty"`
	// An uploaded file that may be turned into the artifact of the content unit.
	File **os.File `json:"file,omitempty"`
	// The name of the collection.
	ExpectedName *string `json:"expected_name,omitempty"`
	// The namespace of the collection.
	ExpectedNamespace *string `json:"expected_namespace,omitempty"`
	// The version of the collection.
	ExpectedVersion *string `json:"expected_version,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _AnsibleCollectionVersion AnsibleCollectionVersion

// NewAnsibleCollectionVersion instantiates a new AnsibleCollectionVersion object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewAnsibleCollectionVersion() *AnsibleCollectionVersion {
	this := AnsibleCollectionVersion{}
	return &this
}

// NewAnsibleCollectionVersionWithDefaults instantiates a new AnsibleCollectionVersion object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewAnsibleCollectionVersionWithDefaults() *AnsibleCollectionVersion {
	this := AnsibleCollectionVersion{}
	return &this
}

// GetUpload returns the Upload field value if set, zero value otherwise.
func (o *AnsibleCollectionVersion) GetUpload() string {
	if o == nil || IsNil(o.Upload) {
		var ret string
		return ret
	}
	return *o.Upload
}

// GetUploadOk returns a tuple with the Upload field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AnsibleCollectionVersion) GetUploadOk() (*string, bool) {
	if o == nil || IsNil(o.Upload) {
		return nil, false
	}
	return o.Upload, true
}

// HasUpload returns a boolean if a field has been set.
func (o *AnsibleCollectionVersion) HasUpload() bool {
	if o != nil && !IsNil(o.Upload) {
		return true
	}

	return false
}

// SetUpload gets a reference to the given string and assigns it to the Upload field.
func (o *AnsibleCollectionVersion) SetUpload(v string) {
	o.Upload = &v
}

// GetArtifact returns the Artifact field value if set, zero value otherwise.
func (o *AnsibleCollectionVersion) GetArtifact() string {
	if o == nil || IsNil(o.Artifact) {
		var ret string
		return ret
	}
	return *o.Artifact
}

// GetArtifactOk returns a tuple with the Artifact field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AnsibleCollectionVersion) GetArtifactOk() (*string, bool) {
	if o == nil || IsNil(o.Artifact) {
		return nil, false
	}
	return o.Artifact, true
}

// HasArtifact returns a boolean if a field has been set.
func (o *AnsibleCollectionVersion) HasArtifact() bool {
	if o != nil && !IsNil(o.Artifact) {
		return true
	}

	return false
}

// SetArtifact gets a reference to the given string and assigns it to the Artifact field.
func (o *AnsibleCollectionVersion) SetArtifact(v string) {
	o.Artifact = &v
}

// GetRepository returns the Repository field value if set, zero value otherwise.
func (o *AnsibleCollectionVersion) GetRepository() string {
	if o == nil || IsNil(o.Repository) {
		var ret string
		return ret
	}
	return *o.Repository
}

// GetRepositoryOk returns a tuple with the Repository field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AnsibleCollectionVersion) GetRepositoryOk() (*string, bool) {
	if o == nil || IsNil(o.Repository) {
		return nil, false
	}
	return o.Repository, true
}

// HasRepository returns a boolean if a field has been set.
func (o *AnsibleCollectionVersion) HasRepository() bool {
	if o != nil && !IsNil(o.Repository) {
		return true
	}

	return false
}

// SetRepository gets a reference to the given string and assigns it to the Repository field.
func (o *AnsibleCollectionVersion) SetRepository(v string) {
	o.Repository = &v
}

// GetFile returns the File field value if set, zero value otherwise.
func (o *AnsibleCollectionVersion) GetFile() *os.File {
	if o == nil || IsNil(o.File) {
		var ret *os.File
		return ret
	}
	return *o.File
}

// GetFileOk returns a tuple with the File field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AnsibleCollectionVersion) GetFileOk() (**os.File, bool) {
	if o == nil || IsNil(o.File) {
		return nil, false
	}
	return o.File, true
}

// HasFile returns a boolean if a field has been set.
func (o *AnsibleCollectionVersion) HasFile() bool {
	if o != nil && !IsNil(o.File) {
		return true
	}

	return false
}

// SetFile gets a reference to the given *os.File and assigns it to the File field.
func (o *AnsibleCollectionVersion) SetFile(v *os.File) {
	o.File = &v
}

// GetExpectedName returns the ExpectedName field value if set, zero value otherwise.
func (o *AnsibleCollectionVersion) GetExpectedName() string {
	if o == nil || IsNil(o.ExpectedName) {
		var ret string
		return ret
	}
	return *o.ExpectedName
}

// GetExpectedNameOk returns a tuple with the ExpectedName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AnsibleCollectionVersion) GetExpectedNameOk() (*string, bool) {
	if o == nil || IsNil(o.ExpectedName) {
		return nil, false
	}
	return o.ExpectedName, true
}

// HasExpectedName returns a boolean if a field has been set.
func (o *AnsibleCollectionVersion) HasExpectedName() bool {
	if o != nil && !IsNil(o.ExpectedName) {
		return true
	}

	return false
}

// SetExpectedName gets a reference to the given string and assigns it to the ExpectedName field.
func (o *AnsibleCollectionVersion) SetExpectedName(v string) {
	o.ExpectedName = &v
}

// GetExpectedNamespace returns the ExpectedNamespace field value if set, zero value otherwise.
func (o *AnsibleCollectionVersion) GetExpectedNamespace() string {
	if o == nil || IsNil(o.ExpectedNamespace) {
		var ret string
		return ret
	}
	return *o.ExpectedNamespace
}

// GetExpectedNamespaceOk returns a tuple with the ExpectedNamespace field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AnsibleCollectionVersion) GetExpectedNamespaceOk() (*string, bool) {
	if o == nil || IsNil(o.ExpectedNamespace) {
		return nil, false
	}
	return o.ExpectedNamespace, true
}

// HasExpectedNamespace returns a boolean if a field has been set.
func (o *AnsibleCollectionVersion) HasExpectedNamespace() bool {
	if o != nil && !IsNil(o.ExpectedNamespace) {
		return true
	}

	return false
}

// SetExpectedNamespace gets a reference to the given string and assigns it to the ExpectedNamespace field.
func (o *AnsibleCollectionVersion) SetExpectedNamespace(v string) {
	o.ExpectedNamespace = &v
}

// GetExpectedVersion returns the ExpectedVersion field value if set, zero value otherwise.
func (o *AnsibleCollectionVersion) GetExpectedVersion() string {
	if o == nil || IsNil(o.ExpectedVersion) {
		var ret string
		return ret
	}
	return *o.ExpectedVersion
}

// GetExpectedVersionOk returns a tuple with the ExpectedVersion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AnsibleCollectionVersion) GetExpectedVersionOk() (*string, bool) {
	if o == nil || IsNil(o.ExpectedVersion) {
		return nil, false
	}
	return o.ExpectedVersion, true
}

// HasExpectedVersion returns a boolean if a field has been set.
func (o *AnsibleCollectionVersion) HasExpectedVersion() bool {
	if o != nil && !IsNil(o.ExpectedVersion) {
		return true
	}

	return false
}

// SetExpectedVersion gets a reference to the given string and assigns it to the ExpectedVersion field.
func (o *AnsibleCollectionVersion) SetExpectedVersion(v string) {
	o.ExpectedVersion = &v
}

func (o AnsibleCollectionVersion) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o AnsibleCollectionVersion) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Upload) {
		toSerialize["upload"] = o.Upload
	}
	if !IsNil(o.Artifact) {
		toSerialize["artifact"] = o.Artifact
	}
	if !IsNil(o.Repository) {
		toSerialize["repository"] = o.Repository
	}
	if !IsNil(o.File) {
		toSerialize["file"] = o.File
	}
	if !IsNil(o.ExpectedName) {
		toSerialize["expected_name"] = o.ExpectedName
	}
	if !IsNil(o.ExpectedNamespace) {
		toSerialize["expected_namespace"] = o.ExpectedNamespace
	}
	if !IsNil(o.ExpectedVersion) {
		toSerialize["expected_version"] = o.ExpectedVersion
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *AnsibleCollectionVersion) UnmarshalJSON(bytes []byte) (err error) {
	varAnsibleCollectionVersion := _AnsibleCollectionVersion{}

	if err = json.Unmarshal(bytes, &varAnsibleCollectionVersion); err == nil {
		*o = AnsibleCollectionVersion(varAnsibleCollectionVersion)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "upload")
		delete(additionalProperties, "artifact")
		delete(additionalProperties, "repository")
		delete(additionalProperties, "file")
		delete(additionalProperties, "expected_name")
		delete(additionalProperties, "expected_namespace")
		delete(additionalProperties, "expected_version")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableAnsibleCollectionVersion struct {
	value *AnsibleCollectionVersion
	isSet bool
}

func (v NullableAnsibleCollectionVersion) Get() *AnsibleCollectionVersion {
	return v.value
}

func (v *NullableAnsibleCollectionVersion) Set(val *AnsibleCollectionVersion) {
	v.value = val
	v.isSet = true
}

func (v NullableAnsibleCollectionVersion) IsSet() bool {
	return v.isSet
}

func (v *NullableAnsibleCollectionVersion) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableAnsibleCollectionVersion(val *AnsibleCollectionVersion) *NullableAnsibleCollectionVersion {
	return &NullableAnsibleCollectionVersion{value: val, isSet: true}
}

func (v NullableAnsibleCollectionVersion) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableAnsibleCollectionVersion) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


