/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"time"
)

// checks if the DebInstallerFileIndexResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &DebInstallerFileIndexResponse{}

// DebInstallerFileIndexResponse A serializer for InstallerFileIndex.
type DebInstallerFileIndexResponse struct {
	PulpHref *string `json:"pulp_href,omitempty"`
	// Timestamp of creation.
	PulpCreated *time.Time `json:"pulp_created,omitempty"`
	// A dict mapping relative paths inside the Content to the correspondingArtifact URLs. E.g.: {'relative/path': '/artifacts/1/'
	Artifacts map[string]interface{} `json:"artifacts"`
	// Component of the component - architecture combination.
	Component string `json:"component"`
	// Architecture of the component - architecture combination.
	Architecture string `json:"architecture"`
	// Path of directory containing MD5SUMS and SHA256SUMS relative to url.
	RelativePath *string `json:"relative_path,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _DebInstallerFileIndexResponse DebInstallerFileIndexResponse

// NewDebInstallerFileIndexResponse instantiates a new DebInstallerFileIndexResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDebInstallerFileIndexResponse(artifacts map[string]interface{}, component string, architecture string) *DebInstallerFileIndexResponse {
	this := DebInstallerFileIndexResponse{}
	this.Artifacts = artifacts
	this.Component = component
	this.Architecture = architecture
	return &this
}

// NewDebInstallerFileIndexResponseWithDefaults instantiates a new DebInstallerFileIndexResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDebInstallerFileIndexResponseWithDefaults() *DebInstallerFileIndexResponse {
	this := DebInstallerFileIndexResponse{}
	return &this
}

// GetPulpHref returns the PulpHref field value if set, zero value otherwise.
func (o *DebInstallerFileIndexResponse) GetPulpHref() string {
	if o == nil || IsNil(o.PulpHref) {
		var ret string
		return ret
	}
	return *o.PulpHref
}

// GetPulpHrefOk returns a tuple with the PulpHref field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebInstallerFileIndexResponse) GetPulpHrefOk() (*string, bool) {
	if o == nil || IsNil(o.PulpHref) {
		return nil, false
	}
	return o.PulpHref, true
}

// HasPulpHref returns a boolean if a field has been set.
func (o *DebInstallerFileIndexResponse) HasPulpHref() bool {
	if o != nil && !IsNil(o.PulpHref) {
		return true
	}

	return false
}

// SetPulpHref gets a reference to the given string and assigns it to the PulpHref field.
func (o *DebInstallerFileIndexResponse) SetPulpHref(v string) {
	o.PulpHref = &v
}

// GetPulpCreated returns the PulpCreated field value if set, zero value otherwise.
func (o *DebInstallerFileIndexResponse) GetPulpCreated() time.Time {
	if o == nil || IsNil(o.PulpCreated) {
		var ret time.Time
		return ret
	}
	return *o.PulpCreated
}

// GetPulpCreatedOk returns a tuple with the PulpCreated field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebInstallerFileIndexResponse) GetPulpCreatedOk() (*time.Time, bool) {
	if o == nil || IsNil(o.PulpCreated) {
		return nil, false
	}
	return o.PulpCreated, true
}

// HasPulpCreated returns a boolean if a field has been set.
func (o *DebInstallerFileIndexResponse) HasPulpCreated() bool {
	if o != nil && !IsNil(o.PulpCreated) {
		return true
	}

	return false
}

// SetPulpCreated gets a reference to the given time.Time and assigns it to the PulpCreated field.
func (o *DebInstallerFileIndexResponse) SetPulpCreated(v time.Time) {
	o.PulpCreated = &v
}

// GetArtifacts returns the Artifacts field value
func (o *DebInstallerFileIndexResponse) GetArtifacts() map[string]interface{} {
	if o == nil {
		var ret map[string]interface{}
		return ret
	}

	return o.Artifacts
}

// GetArtifactsOk returns a tuple with the Artifacts field value
// and a boolean to check if the value has been set.
func (o *DebInstallerFileIndexResponse) GetArtifactsOk() (map[string]interface{}, bool) {
	if o == nil {
		return map[string]interface{}{}, false
	}
	return o.Artifacts, true
}

// SetArtifacts sets field value
func (o *DebInstallerFileIndexResponse) SetArtifacts(v map[string]interface{}) {
	o.Artifacts = v
}

// GetComponent returns the Component field value
func (o *DebInstallerFileIndexResponse) GetComponent() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Component
}

// GetComponentOk returns a tuple with the Component field value
// and a boolean to check if the value has been set.
func (o *DebInstallerFileIndexResponse) GetComponentOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Component, true
}

// SetComponent sets field value
func (o *DebInstallerFileIndexResponse) SetComponent(v string) {
	o.Component = v
}

// GetArchitecture returns the Architecture field value
func (o *DebInstallerFileIndexResponse) GetArchitecture() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Architecture
}

// GetArchitectureOk returns a tuple with the Architecture field value
// and a boolean to check if the value has been set.
func (o *DebInstallerFileIndexResponse) GetArchitectureOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Architecture, true
}

// SetArchitecture sets field value
func (o *DebInstallerFileIndexResponse) SetArchitecture(v string) {
	o.Architecture = v
}

// GetRelativePath returns the RelativePath field value if set, zero value otherwise.
func (o *DebInstallerFileIndexResponse) GetRelativePath() string {
	if o == nil || IsNil(o.RelativePath) {
		var ret string
		return ret
	}
	return *o.RelativePath
}

// GetRelativePathOk returns a tuple with the RelativePath field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebInstallerFileIndexResponse) GetRelativePathOk() (*string, bool) {
	if o == nil || IsNil(o.RelativePath) {
		return nil, false
	}
	return o.RelativePath, true
}

// HasRelativePath returns a boolean if a field has been set.
func (o *DebInstallerFileIndexResponse) HasRelativePath() bool {
	if o != nil && !IsNil(o.RelativePath) {
		return true
	}

	return false
}

// SetRelativePath gets a reference to the given string and assigns it to the RelativePath field.
func (o *DebInstallerFileIndexResponse) SetRelativePath(v string) {
	o.RelativePath = &v
}

func (o DebInstallerFileIndexResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o DebInstallerFileIndexResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.PulpHref) {
		toSerialize["pulp_href"] = o.PulpHref
	}
	if !IsNil(o.PulpCreated) {
		toSerialize["pulp_created"] = o.PulpCreated
	}
	toSerialize["artifacts"] = o.Artifacts
	toSerialize["component"] = o.Component
	toSerialize["architecture"] = o.Architecture
	if !IsNil(o.RelativePath) {
		toSerialize["relative_path"] = o.RelativePath
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *DebInstallerFileIndexResponse) UnmarshalJSON(bytes []byte) (err error) {
	varDebInstallerFileIndexResponse := _DebInstallerFileIndexResponse{}

	if err = json.Unmarshal(bytes, &varDebInstallerFileIndexResponse); err == nil {
		*o = DebInstallerFileIndexResponse(varDebInstallerFileIndexResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "pulp_href")
		delete(additionalProperties, "pulp_created")
		delete(additionalProperties, "artifacts")
		delete(additionalProperties, "component")
		delete(additionalProperties, "architecture")
		delete(additionalProperties, "relative_path")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableDebInstallerFileIndexResponse struct {
	value *DebInstallerFileIndexResponse
	isSet bool
}

func (v NullableDebInstallerFileIndexResponse) Get() *DebInstallerFileIndexResponse {
	return v.value
}

func (v *NullableDebInstallerFileIndexResponse) Set(val *DebInstallerFileIndexResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableDebInstallerFileIndexResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableDebInstallerFileIndexResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDebInstallerFileIndexResponse(val *DebInstallerFileIndexResponse) *NullableDebInstallerFileIndexResponse {
	return &NullableDebInstallerFileIndexResponse{value: val, isSet: true}
}

func (v NullableDebInstallerFileIndexResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDebInstallerFileIndexResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


