/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.provider;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.AlgIdDSA;
import org.mozilla.jss.netscape.security.x509.X509Key;

public final class DSAPublicKey
extends X509Key
implements java.security.interfaces.DSAPublicKey {
    private static final long serialVersionUID = -2994193307391104133L;
    private BigInteger y;

    public DSAPublicKey() {
    }

    public DSAPublicKey(BigInteger y, BigInteger p, BigInteger q, BigInteger g) throws InvalidKeyException {
        this.y = y;
        this.algid = new AlgIdDSA(p, q, g);
        try {
            this.key = new DerValue(2, y.toByteArray()).toByteArray();
            this.encode();
        }
        catch (IOException e) {
            throw new InvalidKeyException("could not DER encode y: " + e.getMessage());
        }
    }

    public DSAPublicKey(byte[] encoded) throws InvalidKeyException {
        this.decode(encoded);
    }

    @Override
    public DSAParams getParams() {
        try {
            if (this.algid instanceof DSAParams) {
                return (DSAParams)((Object)this.algid);
            }
            AlgorithmParameters algParams = this.algid.getParameters();
            if (algParams == null) {
                return null;
            }
            DSAParameterSpec paramSpec = algParams.getParameterSpec(DSAParameterSpec.class);
            return paramSpec;
        }
        catch (InvalidParameterSpecException e) {
            return null;
        }
    }

    @Override
    public BigInteger getY() {
        return this.y;
    }

    @Override
    public String toString() {
        return "Sun DSA Public Key\n    Parameters:" + this.algid + "\n  y:\n" + new BigInt(this.y).toString() + "\n";
    }

    @Override
    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream in = new DerInputStream(this.key);
            this.y = in.getInteger().toBigInteger();
        }
        catch (IOException e) {
            throw new InvalidKeyException("Invalid key: y value\n" + e.getMessage());
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.y == null ? 0 : this.y.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DSAPublicKey other = (DSAPublicKey)obj;
        return !(this.y == null ? other.y != null : !this.y.equals(other.y));
    }
}

