/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.mozilla.jss.provider.javax.crypto.JSSNativeTrustManager;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.ssl.javax.JSSServerSocket;

public class BenchmarkSSLSocket {
    public String type;
    public String nickname;
    public String password;
    public int port;
    public int size;
    public String headers = "HTTP/1.1 200 OK\r\nConnection: Closed\r\n";
    public String message;
    public int limit = 150;

    public BenchmarkSSLSocket(String type, String nickname, int port, int size) throws Exception {
        this.type = type;
        this.nickname = nickname;
        this.port = port;
        this.size = size;
        this.limit = this.limit;
        this.headers = this.headers + "Content-Length: " + size + "\r\n";
        StringBuilder sb = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            sb.append("a");
        }
        this.message = this.headers + "\r\n" + sb.toString();
    }

    public BenchmarkSSLSocket(String type, String nickname, String password, int port, int size) throws Exception {
        this(type, nickname, port, size);
        this.password = password;
    }

    public ServerSocket getServerSocket() throws Exception {
        System.err.println("Constructing socket...");
        switch (this.type) {
            case "JSS.legacy": {
                org.mozilla.jss.ssl.SSLServerSocket sock = new org.mozilla.jss.ssl.SSLServerSocket(this.port);
                sock.setSoTimeout(0);
                org.mozilla.jss.ssl.SSLServerSocket.configServerSessionIDCache((int)0, (int)43200, (int)43200, null);
                sock.setReuseAddress(true);
                sock.requestClientAuth(false);
                sock.requireClientAuth(17);
                sock.setUseClientMode(false);
                sock.setServerCertNickname(this.nickname);
                return sock;
            }
            case "JSS.SSLSocket": {
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("NssX509");
                SSLContext ctx = SSLContext.getInstance("TLS", "Mozilla-JSS");
                ctx.init(kmf.getKeyManagers(), new TrustManager[]{new JSSNativeTrustManager()}, null);
                SSLServerSocketFactory factory = ctx.getServerSocketFactory();
                JSSServerSocket sock = (JSSServerSocket)factory.createServerSocket(this.port);
                sock.setReuseAddress(true);
                sock.setWantClientAuth(false);
                sock.setNeedClientAuth(false);
                sock.setUseClientMode(false);
                sock.setCertFromAlias(this.nickname);
                return sock;
            }
            case "SunJSSE.SSLSocket": {
                FileInputStream fis = new FileInputStream(this.nickname);
                KeyStore store = KeyStore.getInstance("PKCS12");
                store.load(fis, "m1oZilla".toCharArray());
                KeyStore jks = KeyStore.getInstance("JKS");
                jks.load(null);
                KeyStore ks = store;
                Enumeration<String> t = ks.aliases();
                while (t.hasMoreElements()) {
                    String alias = t.nextElement();
                    if (!ks.isKeyEntry(alias)) continue;
                    Certificate[] a = ks.getCertificateChain(alias);
                    for (int i = 1; i < a.length; ++i) {
                        X509Certificate x509 = (X509Certificate)a[i];
                        jks.setCertificateEntry(x509.getSubjectX500Principal().toString(), x509);
                    }
                }
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                kmf.init(store, "m1oZilla".toCharArray());
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                tmf.init(jks);
                SSLContext ctx = SSLContext.getInstance("TLS", "SunJSSE");
                ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
                SSLServerSocketFactory factory = ctx.getServerSocketFactory();
                SSLServerSocket sock = (SSLServerSocket)factory.createServerSocket(this.port);
                sock.setReuseAddress(true);
                sock.setWantClientAuth(false);
                sock.setNeedClientAuth(false);
                sock.setUseClientMode(false);
                return sock;
            }
        }
        throw new RuntimeException("Unknown socket type: `" + this.type + "` -- expected one of `JSS.SSLSocket`, `JSS.legacy`, or `SunJSSE.SSLSocket`.");
    }

    public void run() throws Exception {
        ArrayList existing = new ArrayList(this.limit);
        ServerSocket server_socket = this.getServerSocket();
        try {
            System.err.println("Listening for connections...");
            while (true) {
                int length = existing.size();
                while (length > this.limit) {
                    int index = 0;
                    while (index < length) {
                        Thread.sleep(10L);
                        if (((Thread)existing.get(index)).isAlive()) {
                            ++index;
                            continue;
                        }
                        existing.remove(index);
                        --length;
                    }
                }
                Socket peer_socket = server_socket.accept();
                PeerTask task = new PeerTask(peer_socket, this.message);
                Thread thread = new Thread(task);
                thread.start();
            }
        }
        catch (Throwable throwable) {
            if (server_socket != null) {
                try {
                    server_socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    public static void main(String[] args) throws Exception {
        BenchmarkSSLSocket benchmark;
        if (args.length < 4 || args.length > 5) {
            System.err.println("Usage: BenchmarkSSLSocket <type> [...args...]");
            System.err.println("type: JSS.SSLSocket, JSS.legacy, or SunJSSE.SSLSocket\n");
            System.err.println("When type is JSS.SSLSocket or JSS.legacy:");
            System.err.println("Usage: BenchmarkSSLSocket <type> <alias> <port> <size>");
            System.err.println("alias: server certificate nickname");
            System.err.println("port: What server port to listen on");
            System.err.println("size: bytes of body to send in reply (plus header size)\n");
            System.err.println("When type is SunJSSE.SSLSocket:");
            System.err.println("Usage: BenchmarkSSLSocket SunJSSE.SSLSocket <p12path> [<p12pass>] <port> <size>");
            System.err.println("p12path: path to the p12 file containing the server cert");
            System.err.println("p12pass: password to access p12 file with; default: m1oZilla");
            System.err.println("port: What server port to listen on");
            System.err.println("size: bytes of body to send in reply (plus header size)\n");
            System.exit(1);
        }
        if (args.length == 4) {
            String type = args[0];
            String alias = args[1];
            int port = Integer.parseInt(args[2]);
            int size = Integer.parseInt(args[3]);
            benchmark = new BenchmarkSSLSocket(type, alias, "m1oZilla", port, size);
        } else {
            String type = args[0];
            String path = args[1];
            String password = args[2];
            int port = Integer.parseInt(args[3]);
            int size = Integer.parseInt(args[4]);
            benchmark = new BenchmarkSSLSocket(type, path, password, port, size);
        }
        benchmark.run();
    }

    class PeerTask
    implements Runnable {
        Socket peer;
        byte[] message;

        public PeerTask(Socket peer, String message) {
            this.peer = peer;
            this.message = message.getBytes();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    if (this.peer instanceof SSLSocket) {
                        sock = (SSLSocket)this.peer;
                        sock.setUseClientMode(false);
                        sock.forceHandshake();
                    } else if (this.peer instanceof javax.net.ssl.SSLSocket) {
                        sock = (javax.net.ssl.SSLSocket)this.peer;
                        ((javax.net.ssl.SSLSocket)sock).setUseClientMode(false);
                        ((javax.net.ssl.SSLSocket)sock).startHandshake();
                    }
                    InputStream is = this.peer.getInputStream();
                    byte[] in_data = new byte[is.available()];
                    is.read(in_data);
                    OutputStream os = this.peer.getOutputStream();
                    os.write(this.message);
                }
                finally {
                    this.peer.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }
}

