// RUN: llvm-mc -arch=amdgcn -mcpu=tonga -show-encoding %s | FileCheck %s

s_load_dword s5, s[2:3], s2
// CHECK: [0x41,0x01,0x00,0xc0,0x02,0x00,0x00,0x00]

s_load_dword s101, s[2:3], s2
// CHECK: [0x41,0x19,0x00,0xc0,0x02,0x00,0x00,0x00]

s_load_dword flat_scratch_lo, s[2:3], s2
// CHECK: [0x81,0x19,0x00,0xc0,0x02,0x00,0x00,0x00]

s_load_dword flat_scratch_hi, s[2:3], s2
// CHECK: [0xc1,0x19,0x00,0xc0,0x02,0x00,0x00,0x00]

s_load_dword vcc_lo, s[2:3], s2
// CHECK: [0x81,0x1a,0x00,0xc0,0x02,0x00,0x00,0x00]

s_load_dword vcc_hi, s[2:3], s2
// CHECK: [0xc1,0x1a,0x00,0xc0,0x02,0x00,0x00,0x00]

s_load_dword tba_lo, s[2:3], s2
// CHECK: [0x01,0x1b,0x00,0xc0,0x02,0x00,0x00,0x00]

s_load_dword tba_hi, s[2:3], s2
// CHECK: [0x41,0x1b,0x00,0xc0,0x02,0x00,0x00,0x00]

s_load_dword tma_lo, s[2:3], s2
// CHECK: [0x81,0x1b,0x00,0xc0,0x02,0x00,0x00,0x00]

s_load_dword tma_hi, s[2:3], s2
// CHECK: [0xc1,0x1b,0x00,0xc0,0x02,0x00,0x00,0x00]

s_load_dword ttmp11, s[2:3], s2
// CHECK: [0xc1,0x1e,0x00,0xc0,0x02,0x00,0x00,0x00]

s_load_dword s5, s[4:5], s2
// CHECK: [0x42,0x01,0x00,0xc0,0x02,0x00,0x00,0x00]

s_load_dword s5, s[100:101], s2
// CHECK: [0x72,0x01,0x00,0xc0,0x02,0x00,0x00,0x00]

s_load_dword s5, flat_scratch, s2
// CHECK: [0x73,0x01,0x00,0xc0,0x02,0x00,0x00,0x00]

s_load_dword s5, vcc, s2
// CHECK: [0x75,0x01,0x00,0xc0,0x02,0x00,0x00,0x00]

s_load_dword s5, tba, s2
// CHECK: [0x76,0x01,0x00,0xc0,0x02,0x00,0x00,0x00]

s_load_dword s5, tma, s2
// CHECK: [0x77,0x01,0x00,0xc0,0x02,0x00,0x00,0x00]

s_load_dword s5, ttmp[10:11], s2
// CHECK: [0x7d,0x01,0x00,0xc0,0x02,0x00,0x00,0x00]

s_load_dword s5, s[2:3], s101
// CHECK: [0x41,0x01,0x00,0xc0,0x65,0x00,0x00,0x00]

s_load_dword s5, s[2:3], flat_scratch_lo
// CHECK: [0x41,0x01,0x00,0xc0,0x66,0x00,0x00,0x00]

s_load_dword s5, s[2:3], flat_scratch_hi
// CHECK: [0x41,0x01,0x00,0xc0,0x67,0x00,0x00,0x00]

s_load_dword s5, s[2:3], vcc_lo
// CHECK: [0x41,0x01,0x00,0xc0,0x6a,0x00,0x00,0x00]

s_load_dword s5, s[2:3], vcc_hi
// CHECK: [0x41,0x01,0x00,0xc0,0x6b,0x00,0x00,0x00]

s_load_dword s5, s[2:3], tba_lo
// CHECK: [0x41,0x01,0x00,0xc0,0x6c,0x00,0x00,0x00]

s_load_dword s5, s[2:3], tba_hi
// CHECK: [0x41,0x01,0x00,0xc0,0x6d,0x00,0x00,0x00]

s_load_dword s5, s[2:3], tma_lo
// CHECK: [0x41,0x01,0x00,0xc0,0x6e,0x00,0x00,0x00]

s_load_dword s5, s[2:3], tma_hi
// CHECK: [0x41,0x01,0x00,0xc0,0x6f,0x00,0x00,0x00]

s_load_dword s5, s[2:3], ttmp11
// CHECK: [0x41,0x01,0x00,0xc0,0x7b,0x00,0x00,0x00]

s_load_dword s5, s[2:3], m0
// CHECK: [0x41,0x01,0x00,0xc0,0x7c,0x00,0x00,0x00]

s_load_dword s5, s[2:3], 0x7ffff
// CHECK: [0x41,0x01,0x02,0xc0,0xff,0xff,0x07,0x00]

s_load_dword s5, s[2:3], s2 glc
// CHECK: [0x41,0x01,0x01,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[2:3], s2
// CHECK: [0x81,0x02,0x04,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx2 s[12:13], s[2:3], s2
// CHECK: [0x01,0x03,0x04,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx2 s[100:101], s[2:3], s2
// CHECK: [0x01,0x19,0x04,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx2 flat_scratch, s[2:3], s2
// CHECK: [0x81,0x19,0x04,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx2 vcc, s[2:3], s2
// CHECK: [0x81,0x1a,0x04,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx2 tba, s[2:3], s2
// CHECK: [0x01,0x1b,0x04,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx2 tma, s[2:3], s2
// CHECK: [0x81,0x1b,0x04,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx2 ttmp[10:11], s[2:3], s2
// CHECK: [0x81,0x1e,0x04,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[4:5], s2
// CHECK: [0x82,0x02,0x04,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[100:101], s2
// CHECK: [0xb2,0x02,0x04,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], flat_scratch, s2
// CHECK: [0xb3,0x02,0x04,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], vcc, s2
// CHECK: [0xb5,0x02,0x04,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], tba, s2
// CHECK: [0xb6,0x02,0x04,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], tma, s2
// CHECK: [0xb7,0x02,0x04,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], ttmp[10:11], s2
// CHECK: [0xbd,0x02,0x04,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[2:3], s101
// CHECK: [0x81,0x02,0x04,0xc0,0x65,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[2:3], flat_scratch_lo
// CHECK: [0x81,0x02,0x04,0xc0,0x66,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[2:3], flat_scratch_hi
// CHECK: [0x81,0x02,0x04,0xc0,0x67,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[2:3], vcc_lo
// CHECK: [0x81,0x02,0x04,0xc0,0x6a,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[2:3], vcc_hi
// CHECK: [0x81,0x02,0x04,0xc0,0x6b,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[2:3], tba_lo
// CHECK: [0x81,0x02,0x04,0xc0,0x6c,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[2:3], tba_hi
// CHECK: [0x81,0x02,0x04,0xc0,0x6d,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[2:3], tma_lo
// CHECK: [0x81,0x02,0x04,0xc0,0x6e,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[2:3], tma_hi
// CHECK: [0x81,0x02,0x04,0xc0,0x6f,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[2:3], ttmp11
// CHECK: [0x81,0x02,0x04,0xc0,0x7b,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[2:3], m0
// CHECK: [0x81,0x02,0x04,0xc0,0x7c,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[2:3], 0x7ffff
// CHECK: [0x81,0x02,0x06,0xc0,0xff,0xff,0x07,0x00]

s_load_dwordx2 s[10:11], s[2:3], s2 glc
// CHECK: [0x81,0x02,0x05,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[2:3], s2
// CHECK: [0x01,0x05,0x08,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx4 s[24:27], s[2:3], s2
// CHECK: [0x01,0x06,0x08,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx4 s[96:99], s[2:3], s2
// CHECK: [0x01,0x18,0x08,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx4 ttmp[8:11], s[2:3], s2
// CHECK: [0x01,0x1e,0x08,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[4:5], s2
// CHECK: [0x02,0x05,0x08,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[100:101], s2
// CHECK: [0x32,0x05,0x08,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], flat_scratch, s2
// CHECK: [0x33,0x05,0x08,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], vcc, s2
// CHECK: [0x35,0x05,0x08,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], tba, s2
// CHECK: [0x36,0x05,0x08,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], tma, s2
// CHECK: [0x37,0x05,0x08,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], ttmp[10:11], s2
// CHECK: [0x3d,0x05,0x08,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[2:3], s101
// CHECK: [0x01,0x05,0x08,0xc0,0x65,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[2:3], flat_scratch_lo
// CHECK: [0x01,0x05,0x08,0xc0,0x66,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[2:3], flat_scratch_hi
// CHECK: [0x01,0x05,0x08,0xc0,0x67,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[2:3], vcc_lo
// CHECK: [0x01,0x05,0x08,0xc0,0x6a,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[2:3], vcc_hi
// CHECK: [0x01,0x05,0x08,0xc0,0x6b,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[2:3], tba_lo
// CHECK: [0x01,0x05,0x08,0xc0,0x6c,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[2:3], tba_hi
// CHECK: [0x01,0x05,0x08,0xc0,0x6d,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[2:3], tma_lo
// CHECK: [0x01,0x05,0x08,0xc0,0x6e,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[2:3], tma_hi
// CHECK: [0x01,0x05,0x08,0xc0,0x6f,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[2:3], ttmp11
// CHECK: [0x01,0x05,0x08,0xc0,0x7b,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[2:3], m0
// CHECK: [0x01,0x05,0x08,0xc0,0x7c,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[2:3], 0x7ffff
// CHECK: [0x01,0x05,0x0a,0xc0,0xff,0xff,0x07,0x00]

s_load_dwordx4 s[20:23], s[2:3], s2 glc
// CHECK: [0x01,0x05,0x09,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[2:3], s2
// CHECK: [0x01,0x05,0x0c,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx8 s[24:31], s[2:3], s2
// CHECK: [0x01,0x06,0x0c,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx8 s[92:99], s[2:3], s2
// CHECK: [0x01,0x17,0x0c,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx8 ttmp[4:11], s[2:3], s2
// CHECK: [0x01,0x1d,0x0c,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[4:5], s2
// CHECK: [0x02,0x05,0x0c,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[100:101], s2
// CHECK: [0x32,0x05,0x0c,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], flat_scratch, s2
// CHECK: [0x33,0x05,0x0c,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], vcc, s2
// CHECK: [0x35,0x05,0x0c,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], tba, s2
// CHECK: [0x36,0x05,0x0c,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], tma, s2
// CHECK: [0x37,0x05,0x0c,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], ttmp[10:11], s2
// CHECK: [0x3d,0x05,0x0c,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[2:3], s101
// CHECK: [0x01,0x05,0x0c,0xc0,0x65,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[2:3], flat_scratch_lo
// CHECK: [0x01,0x05,0x0c,0xc0,0x66,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[2:3], flat_scratch_hi
// CHECK: [0x01,0x05,0x0c,0xc0,0x67,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[2:3], vcc_lo
// CHECK: [0x01,0x05,0x0c,0xc0,0x6a,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[2:3], vcc_hi
// CHECK: [0x01,0x05,0x0c,0xc0,0x6b,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[2:3], tba_lo
// CHECK: [0x01,0x05,0x0c,0xc0,0x6c,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[2:3], tba_hi
// CHECK: [0x01,0x05,0x0c,0xc0,0x6d,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[2:3], tma_lo
// CHECK: [0x01,0x05,0x0c,0xc0,0x6e,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[2:3], tma_hi
// CHECK: [0x01,0x05,0x0c,0xc0,0x6f,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[2:3], ttmp11
// CHECK: [0x01,0x05,0x0c,0xc0,0x7b,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[2:3], m0
// CHECK: [0x01,0x05,0x0c,0xc0,0x7c,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[2:3], 0x7ffff
// CHECK: [0x01,0x05,0x0e,0xc0,0xff,0xff,0x07,0x00]

s_load_dwordx8 s[20:27], s[2:3], s2 glc
// CHECK: [0x01,0x05,0x0d,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[2:3], s2
// CHECK: [0x01,0x05,0x10,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx16 s[24:39], s[2:3], s2
// CHECK: [0x01,0x06,0x10,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx16 s[84:99], s[2:3], s2
// CHECK: [0x01,0x15,0x10,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[4:5], s2
// CHECK: [0x02,0x05,0x10,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[100:101], s2
// CHECK: [0x32,0x05,0x10,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], flat_scratch, s2
// CHECK: [0x33,0x05,0x10,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], vcc, s2
// CHECK: [0x35,0x05,0x10,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], tba, s2
// CHECK: [0x36,0x05,0x10,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], tma, s2
// CHECK: [0x37,0x05,0x10,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], ttmp[10:11], s2
// CHECK: [0x3d,0x05,0x10,0xc0,0x02,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[2:3], s101
// CHECK: [0x01,0x05,0x10,0xc0,0x65,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[2:3], flat_scratch_lo
// CHECK: [0x01,0x05,0x10,0xc0,0x66,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[2:3], flat_scratch_hi
// CHECK: [0x01,0x05,0x10,0xc0,0x67,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[2:3], vcc_lo
// CHECK: [0x01,0x05,0x10,0xc0,0x6a,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[2:3], vcc_hi
// CHECK: [0x01,0x05,0x10,0xc0,0x6b,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[2:3], tba_lo
// CHECK: [0x01,0x05,0x10,0xc0,0x6c,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[2:3], tba_hi
// CHECK: [0x01,0x05,0x10,0xc0,0x6d,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[2:3], tma_lo
// CHECK: [0x01,0x05,0x10,0xc0,0x6e,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[2:3], tma_hi
// CHECK: [0x01,0x05,0x10,0xc0,0x6f,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[2:3], ttmp11
// CHECK: [0x01,0x05,0x10,0xc0,0x7b,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[2:3], m0
// CHECK: [0x01,0x05,0x10,0xc0,0x7c,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[2:3], 0x7ffff
// CHECK: [0x01,0x05,0x12,0xc0,0xff,0xff,0x07,0x00]

s_load_dwordx16 s[20:35], s[2:3], s2 glc
// CHECK: [0x01,0x05,0x11,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dword s5, s[4:7], s2
// CHECK: [0x42,0x01,0x20,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dword s101, s[4:7], s2
// CHECK: [0x42,0x19,0x20,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dword flat_scratch_lo, s[4:7], s2
// CHECK: [0x82,0x19,0x20,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dword flat_scratch_hi, s[4:7], s2
// CHECK: [0xc2,0x19,0x20,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dword vcc_lo, s[4:7], s2
// CHECK: [0x82,0x1a,0x20,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dword vcc_hi, s[4:7], s2
// CHECK: [0xc2,0x1a,0x20,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dword tba_lo, s[4:7], s2
// CHECK: [0x02,0x1b,0x20,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dword tba_hi, s[4:7], s2
// CHECK: [0x42,0x1b,0x20,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dword tma_lo, s[4:7], s2
// CHECK: [0x82,0x1b,0x20,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dword tma_hi, s[4:7], s2
// CHECK: [0xc2,0x1b,0x20,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dword ttmp11, s[4:7], s2
// CHECK: [0xc2,0x1e,0x20,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dword s5, s[8:11], s2
// CHECK: [0x44,0x01,0x20,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dword s5, s[96:99], s2
// CHECK: [0x70,0x01,0x20,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dword s5, ttmp[8:11], s2
// CHECK: [0x7c,0x01,0x20,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dword s5, s[4:7], s101
// CHECK: [0x42,0x01,0x20,0xc0,0x65,0x00,0x00,0x00]

s_buffer_load_dword s5, s[4:7], flat_scratch_lo
// CHECK: [0x42,0x01,0x20,0xc0,0x66,0x00,0x00,0x00]

s_buffer_load_dword s5, s[4:7], flat_scratch_hi
// CHECK: [0x42,0x01,0x20,0xc0,0x67,0x00,0x00,0x00]

s_buffer_load_dword s5, s[4:7], vcc_lo
// CHECK: [0x42,0x01,0x20,0xc0,0x6a,0x00,0x00,0x00]

s_buffer_load_dword s5, s[4:7], vcc_hi
// CHECK: [0x42,0x01,0x20,0xc0,0x6b,0x00,0x00,0x00]

s_buffer_load_dword s5, s[4:7], tba_lo
// CHECK: [0x42,0x01,0x20,0xc0,0x6c,0x00,0x00,0x00]

s_buffer_load_dword s5, s[4:7], tba_hi
// CHECK: [0x42,0x01,0x20,0xc0,0x6d,0x00,0x00,0x00]

s_buffer_load_dword s5, s[4:7], tma_lo
// CHECK: [0x42,0x01,0x20,0xc0,0x6e,0x00,0x00,0x00]

s_buffer_load_dword s5, s[4:7], tma_hi
// CHECK: [0x42,0x01,0x20,0xc0,0x6f,0x00,0x00,0x00]

s_buffer_load_dword s5, s[4:7], ttmp11
// CHECK: [0x42,0x01,0x20,0xc0,0x7b,0x00,0x00,0x00]

s_buffer_load_dword s5, s[4:7], m0
// CHECK: [0x42,0x01,0x20,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_load_dword s5, s[4:7], 0x7ffff
// CHECK: [0x42,0x01,0x22,0xc0,0xff,0xff,0x07,0x00]

s_buffer_load_dword s5, s[4:7], s2 glc
// CHECK: [0x42,0x01,0x21,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[4:7], s2
// CHECK: [0x82,0x02,0x24,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[12:13], s[4:7], s2
// CHECK: [0x02,0x03,0x24,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[100:101], s[4:7], s2
// CHECK: [0x02,0x19,0x24,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx2 flat_scratch, s[4:7], s2
// CHECK: [0x82,0x19,0x24,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx2 vcc, s[4:7], s2
// CHECK: [0x82,0x1a,0x24,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx2 tba, s[4:7], s2
// CHECK: [0x02,0x1b,0x24,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx2 tma, s[4:7], s2
// CHECK: [0x82,0x1b,0x24,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx2 ttmp[10:11], s[4:7], s2
// CHECK: [0x82,0x1e,0x24,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[8:11], s2
// CHECK: [0x84,0x02,0x24,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[96:99], s2
// CHECK: [0xb0,0x02,0x24,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], ttmp[8:11], s2
// CHECK: [0xbc,0x02,0x24,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[4:7], s101
// CHECK: [0x82,0x02,0x24,0xc0,0x65,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[4:7], flat_scratch_lo
// CHECK: [0x82,0x02,0x24,0xc0,0x66,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[4:7], flat_scratch_hi
// CHECK: [0x82,0x02,0x24,0xc0,0x67,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[4:7], vcc_lo
// CHECK: [0x82,0x02,0x24,0xc0,0x6a,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[4:7], vcc_hi
// CHECK: [0x82,0x02,0x24,0xc0,0x6b,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[4:7], tba_lo
// CHECK: [0x82,0x02,0x24,0xc0,0x6c,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[4:7], tba_hi
// CHECK: [0x82,0x02,0x24,0xc0,0x6d,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[4:7], tma_lo
// CHECK: [0x82,0x02,0x24,0xc0,0x6e,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[4:7], tma_hi
// CHECK: [0x82,0x02,0x24,0xc0,0x6f,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[4:7], ttmp11
// CHECK: [0x82,0x02,0x24,0xc0,0x7b,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[4:7], m0
// CHECK: [0x82,0x02,0x24,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[4:7], 0x7ffff
// CHECK: [0x82,0x02,0x26,0xc0,0xff,0xff,0x07,0x00]

s_buffer_load_dwordx2 s[10:11], s[4:7], s2 glc
// CHECK: [0x82,0x02,0x25,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[4:7], s2
// CHECK: [0x02,0x05,0x28,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[24:27], s[4:7], s2
// CHECK: [0x02,0x06,0x28,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[96:99], s[4:7], s2
// CHECK: [0x02,0x18,0x28,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx4 ttmp[8:11], s[4:7], s2
// CHECK: [0x02,0x1e,0x28,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[8:11], s2
// CHECK: [0x04,0x05,0x28,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[96:99], s2
// CHECK: [0x30,0x05,0x28,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], ttmp[8:11], s2
// CHECK: [0x3c,0x05,0x28,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[4:7], s101
// CHECK: [0x02,0x05,0x28,0xc0,0x65,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[4:7], flat_scratch_lo
// CHECK: [0x02,0x05,0x28,0xc0,0x66,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[4:7], flat_scratch_hi
// CHECK: [0x02,0x05,0x28,0xc0,0x67,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[4:7], vcc_lo
// CHECK: [0x02,0x05,0x28,0xc0,0x6a,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[4:7], vcc_hi
// CHECK: [0x02,0x05,0x28,0xc0,0x6b,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[4:7], tba_lo
// CHECK: [0x02,0x05,0x28,0xc0,0x6c,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[4:7], tba_hi
// CHECK: [0x02,0x05,0x28,0xc0,0x6d,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[4:7], tma_lo
// CHECK: [0x02,0x05,0x28,0xc0,0x6e,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[4:7], tma_hi
// CHECK: [0x02,0x05,0x28,0xc0,0x6f,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[4:7], ttmp11
// CHECK: [0x02,0x05,0x28,0xc0,0x7b,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[4:7], m0
// CHECK: [0x02,0x05,0x28,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[4:7], 0x7ffff
// CHECK: [0x02,0x05,0x2a,0xc0,0xff,0xff,0x07,0x00]

s_buffer_load_dwordx4 s[20:23], s[4:7], s2 glc
// CHECK: [0x02,0x05,0x29,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[4:7], s2
// CHECK: [0x02,0x05,0x2c,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[24:31], s[4:7], s2
// CHECK: [0x02,0x06,0x2c,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[92:99], s[4:7], s2
// CHECK: [0x02,0x17,0x2c,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx8 ttmp[4:11], s[4:7], s2
// CHECK: [0x02,0x1d,0x2c,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[8:11], s2
// CHECK: [0x04,0x05,0x2c,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[96:99], s2
// CHECK: [0x30,0x05,0x2c,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], ttmp[8:11], s2
// CHECK: [0x3c,0x05,0x2c,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[4:7], s101
// CHECK: [0x02,0x05,0x2c,0xc0,0x65,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[4:7], flat_scratch_lo
// CHECK: [0x02,0x05,0x2c,0xc0,0x66,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[4:7], flat_scratch_hi
// CHECK: [0x02,0x05,0x2c,0xc0,0x67,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[4:7], vcc_lo
// CHECK: [0x02,0x05,0x2c,0xc0,0x6a,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[4:7], vcc_hi
// CHECK: [0x02,0x05,0x2c,0xc0,0x6b,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[4:7], tba_lo
// CHECK: [0x02,0x05,0x2c,0xc0,0x6c,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[4:7], tba_hi
// CHECK: [0x02,0x05,0x2c,0xc0,0x6d,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[4:7], tma_lo
// CHECK: [0x02,0x05,0x2c,0xc0,0x6e,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[4:7], tma_hi
// CHECK: [0x02,0x05,0x2c,0xc0,0x6f,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[4:7], ttmp11
// CHECK: [0x02,0x05,0x2c,0xc0,0x7b,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[4:7], m0
// CHECK: [0x02,0x05,0x2c,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[4:7], 0x7ffff
// CHECK: [0x02,0x05,0x2e,0xc0,0xff,0xff,0x07,0x00]

s_buffer_load_dwordx8 s[20:27], s[4:7], s2 glc
// CHECK: [0x02,0x05,0x2d,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[4:7], s2
// CHECK: [0x02,0x05,0x30,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[24:39], s[4:7], s2
// CHECK: [0x02,0x06,0x30,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[84:99], s[4:7], s2
// CHECK: [0x02,0x15,0x30,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[8:11], s2
// CHECK: [0x04,0x05,0x30,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[96:99], s2
// CHECK: [0x30,0x05,0x30,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], ttmp[8:11], s2
// CHECK: [0x3c,0x05,0x30,0xc0,0x02,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[4:7], s101
// CHECK: [0x02,0x05,0x30,0xc0,0x65,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[4:7], flat_scratch_lo
// CHECK: [0x02,0x05,0x30,0xc0,0x66,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[4:7], flat_scratch_hi
// CHECK: [0x02,0x05,0x30,0xc0,0x67,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[4:7], vcc_lo
// CHECK: [0x02,0x05,0x30,0xc0,0x6a,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[4:7], vcc_hi
// CHECK: [0x02,0x05,0x30,0xc0,0x6b,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[4:7], tba_lo
// CHECK: [0x02,0x05,0x30,0xc0,0x6c,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[4:7], tba_hi
// CHECK: [0x02,0x05,0x30,0xc0,0x6d,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[4:7], tma_lo
// CHECK: [0x02,0x05,0x30,0xc0,0x6e,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[4:7], tma_hi
// CHECK: [0x02,0x05,0x30,0xc0,0x6f,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[4:7], ttmp11
// CHECK: [0x02,0x05,0x30,0xc0,0x7b,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[4:7], m0
// CHECK: [0x02,0x05,0x30,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[4:7], 0x7ffff
// CHECK: [0x02,0x05,0x32,0xc0,0xff,0xff,0x07,0x00]

s_buffer_load_dwordx16 s[20:35], s[4:7], s2 glc
// CHECK: [0x02,0x05,0x31,0xc0,0x02,0x00,0x00,0x00]

s_store_dword s1, s[4:5], m0
// CHECK: [0x42,0x00,0x40,0xc0,0x7c,0x00,0x00,0x00]

s_store_dword s101, s[4:5], m0
// CHECK: [0x42,0x19,0x40,0xc0,0x7c,0x00,0x00,0x00]

s_store_dword flat_scratch_lo, s[4:5], m0
// CHECK: [0x82,0x19,0x40,0xc0,0x7c,0x00,0x00,0x00]

s_store_dword flat_scratch_hi, s[4:5], m0
// CHECK: [0xc2,0x19,0x40,0xc0,0x7c,0x00,0x00,0x00]

s_store_dword vcc_lo, s[4:5], m0
// CHECK: [0x82,0x1a,0x40,0xc0,0x7c,0x00,0x00,0x00]

s_store_dword vcc_hi, s[4:5], m0
// CHECK: [0xc2,0x1a,0x40,0xc0,0x7c,0x00,0x00,0x00]

s_store_dword tba_lo, s[4:5], m0
// CHECK: [0x02,0x1b,0x40,0xc0,0x7c,0x00,0x00,0x00]

s_store_dword tba_hi, s[4:5], m0
// CHECK: [0x42,0x1b,0x40,0xc0,0x7c,0x00,0x00,0x00]

s_store_dword tma_lo, s[4:5], m0
// CHECK: [0x82,0x1b,0x40,0xc0,0x7c,0x00,0x00,0x00]

s_store_dword tma_hi, s[4:5], m0
// CHECK: [0xc2,0x1b,0x40,0xc0,0x7c,0x00,0x00,0x00]

s_store_dword ttmp11, s[4:5], m0
// CHECK: [0xc2,0x1e,0x40,0xc0,0x7c,0x00,0x00,0x00]

s_store_dword s1, s[6:7], m0
// CHECK: [0x43,0x00,0x40,0xc0,0x7c,0x00,0x00,0x00]

s_store_dword s1, s[100:101], m0
// CHECK: [0x72,0x00,0x40,0xc0,0x7c,0x00,0x00,0x00]

s_store_dword s1, flat_scratch, m0
// CHECK: [0x73,0x00,0x40,0xc0,0x7c,0x00,0x00,0x00]

s_store_dword s1, vcc, m0
// CHECK: [0x75,0x00,0x40,0xc0,0x7c,0x00,0x00,0x00]

s_store_dword s1, tba, m0
// CHECK: [0x76,0x00,0x40,0xc0,0x7c,0x00,0x00,0x00]

s_store_dword s1, tma, m0
// CHECK: [0x77,0x00,0x40,0xc0,0x7c,0x00,0x00,0x00]

s_store_dword s1, ttmp[10:11], m0
// CHECK: [0x7d,0x00,0x40,0xc0,0x7c,0x00,0x00,0x00]

s_store_dword s1, s[4:5], 0x7ffff
// CHECK: [0x42,0x00,0x42,0xc0,0xff,0xff,0x07,0x00]

s_store_dword s1, s[4:5], m0 glc
// CHECK: [0x42,0x00,0x41,0xc0,0x7c,0x00,0x00,0x00]

s_store_dwordx2 s[2:3], s[4:5], m0
// CHECK: [0x82,0x00,0x44,0xc0,0x7c,0x00,0x00,0x00]

s_store_dwordx2 s[4:5], s[4:5], m0
// CHECK: [0x02,0x01,0x44,0xc0,0x7c,0x00,0x00,0x00]

s_store_dwordx2 s[100:101], s[4:5], m0
// CHECK: [0x02,0x19,0x44,0xc0,0x7c,0x00,0x00,0x00]

s_store_dwordx2 flat_scratch, s[4:5], m0
// CHECK: [0x82,0x19,0x44,0xc0,0x7c,0x00,0x00,0x00]

s_store_dwordx2 vcc, s[4:5], m0
// CHECK: [0x82,0x1a,0x44,0xc0,0x7c,0x00,0x00,0x00]

s_store_dwordx2 tba, s[4:5], m0
// CHECK: [0x02,0x1b,0x44,0xc0,0x7c,0x00,0x00,0x00]

s_store_dwordx2 tma, s[4:5], m0
// CHECK: [0x82,0x1b,0x44,0xc0,0x7c,0x00,0x00,0x00]

s_store_dwordx2 ttmp[10:11], s[4:5], m0
// CHECK: [0x82,0x1e,0x44,0xc0,0x7c,0x00,0x00,0x00]

s_store_dwordx2 s[2:3], s[6:7], m0
// CHECK: [0x83,0x00,0x44,0xc0,0x7c,0x00,0x00,0x00]

s_store_dwordx2 s[2:3], s[100:101], m0
// CHECK: [0xb2,0x00,0x44,0xc0,0x7c,0x00,0x00,0x00]

s_store_dwordx2 s[2:3], flat_scratch, m0
// CHECK: [0xb3,0x00,0x44,0xc0,0x7c,0x00,0x00,0x00]

s_store_dwordx2 s[2:3], vcc, m0
// CHECK: [0xb5,0x00,0x44,0xc0,0x7c,0x00,0x00,0x00]

s_store_dwordx2 s[2:3], tba, m0
// CHECK: [0xb6,0x00,0x44,0xc0,0x7c,0x00,0x00,0x00]

s_store_dwordx2 s[2:3], tma, m0
// CHECK: [0xb7,0x00,0x44,0xc0,0x7c,0x00,0x00,0x00]

s_store_dwordx2 s[2:3], ttmp[10:11], m0
// CHECK: [0xbd,0x00,0x44,0xc0,0x7c,0x00,0x00,0x00]

s_store_dwordx2 s[2:3], s[4:5], 0x7ffff
// CHECK: [0x82,0x00,0x46,0xc0,0xff,0xff,0x07,0x00]

s_store_dwordx2 s[2:3], s[4:5], m0 glc
// CHECK: [0x82,0x00,0x45,0xc0,0x7c,0x00,0x00,0x00]

s_store_dwordx4 s[4:7], s[4:5], m0
// CHECK: [0x02,0x01,0x48,0xc0,0x7c,0x00,0x00,0x00]

s_store_dwordx4 s[8:11], s[4:5], m0
// CHECK: [0x02,0x02,0x48,0xc0,0x7c,0x00,0x00,0x00]

s_store_dwordx4 s[96:99], s[4:5], m0
// CHECK: [0x02,0x18,0x48,0xc0,0x7c,0x00,0x00,0x00]

s_store_dwordx4 ttmp[8:11], s[4:5], m0
// CHECK: [0x02,0x1e,0x48,0xc0,0x7c,0x00,0x00,0x00]

s_store_dwordx4 s[4:7], s[6:7], m0
// CHECK: [0x03,0x01,0x48,0xc0,0x7c,0x00,0x00,0x00]

s_store_dwordx4 s[4:7], s[100:101], m0
// CHECK: [0x32,0x01,0x48,0xc0,0x7c,0x00,0x00,0x00]

s_store_dwordx4 s[4:7], flat_scratch, m0
// CHECK: [0x33,0x01,0x48,0xc0,0x7c,0x00,0x00,0x00]

s_store_dwordx4 s[4:7], vcc, m0
// CHECK: [0x35,0x01,0x48,0xc0,0x7c,0x00,0x00,0x00]

s_store_dwordx4 s[4:7], tba, m0
// CHECK: [0x36,0x01,0x48,0xc0,0x7c,0x00,0x00,0x00]

s_store_dwordx4 s[4:7], tma, m0
// CHECK: [0x37,0x01,0x48,0xc0,0x7c,0x00,0x00,0x00]

s_store_dwordx4 s[4:7], ttmp[10:11], m0
// CHECK: [0x3d,0x01,0x48,0xc0,0x7c,0x00,0x00,0x00]

s_store_dwordx4 s[4:7], s[4:5], 0x7ffff
// CHECK: [0x02,0x01,0x4a,0xc0,0xff,0xff,0x07,0x00]

s_store_dwordx4 s[4:7], s[4:5], m0 glc
// CHECK: [0x02,0x01,0x49,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dword s1, s[8:11], m0
// CHECK: [0x44,0x00,0x60,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dword s101, s[8:11], m0
// CHECK: [0x44,0x19,0x60,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dword flat_scratch_lo, s[8:11], m0
// CHECK: [0x84,0x19,0x60,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dword flat_scratch_hi, s[8:11], m0
// CHECK: [0xc4,0x19,0x60,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dword vcc_lo, s[8:11], m0
// CHECK: [0x84,0x1a,0x60,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dword vcc_hi, s[8:11], m0
// CHECK: [0xc4,0x1a,0x60,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dword tba_lo, s[8:11], m0
// CHECK: [0x04,0x1b,0x60,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dword tba_hi, s[8:11], m0
// CHECK: [0x44,0x1b,0x60,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dword tma_lo, s[8:11], m0
// CHECK: [0x84,0x1b,0x60,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dword tma_hi, s[8:11], m0
// CHECK: [0xc4,0x1b,0x60,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dword ttmp11, s[8:11], m0
// CHECK: [0xc4,0x1e,0x60,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dword s1, s[12:15], m0
// CHECK: [0x46,0x00,0x60,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dword s1, s[96:99], m0
// CHECK: [0x70,0x00,0x60,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dword s1, ttmp[8:11], m0
// CHECK: [0x7c,0x00,0x60,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dword s1, s[8:11], 0x7ffff
// CHECK: [0x44,0x00,0x62,0xc0,0xff,0xff,0x07,0x00]

s_buffer_store_dword s1, s[8:11], m0 glc
// CHECK: [0x44,0x00,0x61,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dwordx2 s[2:3], s[8:11], m0
// CHECK: [0x84,0x00,0x64,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dwordx2 s[4:5], s[8:11], m0
// CHECK: [0x04,0x01,0x64,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dwordx2 s[100:101], s[8:11], m0
// CHECK: [0x04,0x19,0x64,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dwordx2 flat_scratch, s[8:11], m0
// CHECK: [0x84,0x19,0x64,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dwordx2 vcc, s[8:11], m0
// CHECK: [0x84,0x1a,0x64,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dwordx2 tba, s[8:11], m0
// CHECK: [0x04,0x1b,0x64,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dwordx2 tma, s[8:11], m0
// CHECK: [0x84,0x1b,0x64,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dwordx2 ttmp[10:11], s[8:11], m0
// CHECK: [0x84,0x1e,0x64,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dwordx2 s[2:3], s[12:15], m0
// CHECK: [0x86,0x00,0x64,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dwordx2 s[2:3], s[96:99], m0
// CHECK: [0xb0,0x00,0x64,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dwordx2 s[2:3], ttmp[8:11], m0
// CHECK: [0xbc,0x00,0x64,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dwordx2 s[2:3], s[8:11], 0x7ffff
// CHECK: [0x84,0x00,0x66,0xc0,0xff,0xff,0x07,0x00]

s_buffer_store_dwordx2 s[2:3], s[8:11], m0 glc
// CHECK: [0x84,0x00,0x65,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dwordx4 s[4:7], s[8:11], m0
// CHECK: [0x04,0x01,0x68,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dwordx4 s[8:11], s[8:11], m0
// CHECK: [0x04,0x02,0x68,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dwordx4 s[96:99], s[8:11], m0
// CHECK: [0x04,0x18,0x68,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dwordx4 ttmp[8:11], s[8:11], m0
// CHECK: [0x04,0x1e,0x68,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dwordx4 s[4:7], s[12:15], m0
// CHECK: [0x06,0x01,0x68,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dwordx4 s[4:7], s[96:99], m0
// CHECK: [0x30,0x01,0x68,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dwordx4 s[4:7], ttmp[8:11], m0
// CHECK: [0x3c,0x01,0x68,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dwordx4 s[4:7], s[8:11], 0x7ffff
// CHECK: [0x04,0x01,0x6a,0xc0,0xff,0xff,0x07,0x00]

s_buffer_store_dwordx4 s[4:7], s[8:11], m0 glc
// CHECK: [0x04,0x01,0x69,0xc0,0x7c,0x00,0x00,0x00]

s_dcache_inv
// CHECK: [0x00,0x00,0x80,0xc0,0x00,0x00,0x00,0x00]

s_dcache_wb
// CHECK: [0x00,0x00,0x84,0xc0,0x00,0x00,0x00,0x00]

s_dcache_inv_vol
// CHECK: [0x00,0x00,0x88,0xc0,0x00,0x00,0x00,0x00]

s_dcache_wb_vol
// CHECK: [0x00,0x00,0x8c,0xc0,0x00,0x00,0x00,0x00]

s_memtime s[10:11]
// CHECK: [0x80,0x02,0x90,0xc0,0x00,0x00,0x00,0x00]

s_memtime s[12:13]
// CHECK: [0x00,0x03,0x90,0xc0,0x00,0x00,0x00,0x00]

s_memtime s[100:101]
// CHECK: [0x00,0x19,0x90,0xc0,0x00,0x00,0x00,0x00]

s_memtime flat_scratch
// CHECK: [0x80,0x19,0x90,0xc0,0x00,0x00,0x00,0x00]

s_memtime vcc
// CHECK: [0x80,0x1a,0x90,0xc0,0x00,0x00,0x00,0x00]

s_memtime tba
// CHECK: [0x00,0x1b,0x90,0xc0,0x00,0x00,0x00,0x00]

s_memtime tma
// CHECK: [0x80,0x1b,0x90,0xc0,0x00,0x00,0x00,0x00]

s_memtime ttmp[10:11]
// CHECK: [0x80,0x1e,0x90,0xc0,0x00,0x00,0x00,0x00]

s_memrealtime s[10:11]
// CHECK: [0x80,0x02,0x94,0xc0,0x00,0x00,0x00,0x00]

s_memrealtime s[12:13]
// CHECK: [0x00,0x03,0x94,0xc0,0x00,0x00,0x00,0x00]

s_memrealtime s[100:101]
// CHECK: [0x00,0x19,0x94,0xc0,0x00,0x00,0x00,0x00]

s_memrealtime flat_scratch
// CHECK: [0x80,0x19,0x94,0xc0,0x00,0x00,0x00,0x00]

s_memrealtime vcc
// CHECK: [0x80,0x1a,0x94,0xc0,0x00,0x00,0x00,0x00]

s_memrealtime tba
// CHECK: [0x00,0x1b,0x94,0xc0,0x00,0x00,0x00,0x00]

s_memrealtime tma
// CHECK: [0x80,0x1b,0x94,0xc0,0x00,0x00,0x00,0x00]

s_memrealtime ttmp[10:11]
// CHECK: [0x80,0x1e,0x94,0xc0,0x00,0x00,0x00,0x00]

s_atc_probe 0x0, s[4:5], s3
// CHECK: [0x02,0x00,0x98,0xc0,0x03,0x00,0x00,0x00]

s_atc_probe 0x1, s[4:5], s3
// CHECK: [0x42,0x00,0x98,0xc0,0x03,0x00,0x00,0x00]

s_atc_probe 0x7, s[4:5], s3
// CHECK: [0xc2,0x01,0x98,0xc0,0x03,0x00,0x00,0x00]

s_atc_probe 0x0, s[6:7], s3
// CHECK: [0x03,0x00,0x98,0xc0,0x03,0x00,0x00,0x00]

s_atc_probe 0x0, s[100:101], s3
// CHECK: [0x32,0x00,0x98,0xc0,0x03,0x00,0x00,0x00]

s_atc_probe 0x0, flat_scratch, s3
// CHECK: [0x33,0x00,0x98,0xc0,0x03,0x00,0x00,0x00]

s_atc_probe 0x0, vcc, s3
// CHECK: [0x35,0x00,0x98,0xc0,0x03,0x00,0x00,0x00]

s_atc_probe 0x0, tba, s3
// CHECK: [0x36,0x00,0x98,0xc0,0x03,0x00,0x00,0x00]

s_atc_probe 0x0, tma, s3
// CHECK: [0x37,0x00,0x98,0xc0,0x03,0x00,0x00,0x00]

s_atc_probe 0x0, ttmp[10:11], s3
// CHECK: [0x3d,0x00,0x98,0xc0,0x03,0x00,0x00,0x00]

s_atc_probe 0x0, s[4:5], s101
// CHECK: [0x02,0x00,0x98,0xc0,0x65,0x00,0x00,0x00]

s_atc_probe 0x0, s[4:5], flat_scratch_lo
// CHECK: [0x02,0x00,0x98,0xc0,0x66,0x00,0x00,0x00]

s_atc_probe 0x0, s[4:5], flat_scratch_hi
// CHECK: [0x02,0x00,0x98,0xc0,0x67,0x00,0x00,0x00]

s_atc_probe 0x0, s[4:5], vcc_lo
// CHECK: [0x02,0x00,0x98,0xc0,0x6a,0x00,0x00,0x00]

s_atc_probe 0x0, s[4:5], vcc_hi
// CHECK: [0x02,0x00,0x98,0xc0,0x6b,0x00,0x00,0x00]

s_atc_probe 0x0, s[4:5], tba_lo
// CHECK: [0x02,0x00,0x98,0xc0,0x6c,0x00,0x00,0x00]

s_atc_probe 0x0, s[4:5], tba_hi
// CHECK: [0x02,0x00,0x98,0xc0,0x6d,0x00,0x00,0x00]

s_atc_probe 0x0, s[4:5], tma_lo
// CHECK: [0x02,0x00,0x98,0xc0,0x6e,0x00,0x00,0x00]

s_atc_probe 0x0, s[4:5], tma_hi
// CHECK: [0x02,0x00,0x98,0xc0,0x6f,0x00,0x00,0x00]

s_atc_probe 0x0, s[4:5], ttmp11
// CHECK: [0x02,0x00,0x98,0xc0,0x7b,0x00,0x00,0x00]

s_atc_probe 0x0, s[4:5], m0
// CHECK: [0x02,0x00,0x98,0xc0,0x7c,0x00,0x00,0x00]

s_atc_probe 0x0, s[4:5], 0x7ffff
// CHECK: [0x02,0x00,0x9a,0xc0,0xff,0xff,0x07,0x00]

s_atc_probe_buffer 0x0, s[8:11], s3
// CHECK: [0x04,0x00,0x9c,0xc0,0x03,0x00,0x00,0x00]

s_atc_probe_buffer 0x1, s[8:11], s3
// CHECK: [0x44,0x00,0x9c,0xc0,0x03,0x00,0x00,0x00]

s_atc_probe_buffer 0x7, s[8:11], s3
// CHECK: [0xc4,0x01,0x9c,0xc0,0x03,0x00,0x00,0x00]

s_atc_probe_buffer 0x0, s[12:15], s3
// CHECK: [0x06,0x00,0x9c,0xc0,0x03,0x00,0x00,0x00]

s_atc_probe_buffer 0x0, s[96:99], s3
// CHECK: [0x30,0x00,0x9c,0xc0,0x03,0x00,0x00,0x00]

s_atc_probe_buffer 0x0, ttmp[8:11], s3
// CHECK: [0x3c,0x00,0x9c,0xc0,0x03,0x00,0x00,0x00]

s_atc_probe_buffer 0x0, s[8:11], s101
// CHECK: [0x04,0x00,0x9c,0xc0,0x65,0x00,0x00,0x00]

s_atc_probe_buffer 0x0, s[8:11], flat_scratch_lo
// CHECK: [0x04,0x00,0x9c,0xc0,0x66,0x00,0x00,0x00]

s_atc_probe_buffer 0x0, s[8:11], flat_scratch_hi
// CHECK: [0x04,0x00,0x9c,0xc0,0x67,0x00,0x00,0x00]

s_atc_probe_buffer 0x0, s[8:11], vcc_lo
// CHECK: [0x04,0x00,0x9c,0xc0,0x6a,0x00,0x00,0x00]

s_atc_probe_buffer 0x0, s[8:11], vcc_hi
// CHECK: [0x04,0x00,0x9c,0xc0,0x6b,0x00,0x00,0x00]

s_atc_probe_buffer 0x0, s[8:11], tba_lo
// CHECK: [0x04,0x00,0x9c,0xc0,0x6c,0x00,0x00,0x00]

s_atc_probe_buffer 0x0, s[8:11], tba_hi
// CHECK: [0x04,0x00,0x9c,0xc0,0x6d,0x00,0x00,0x00]

s_atc_probe_buffer 0x0, s[8:11], tma_lo
// CHECK: [0x04,0x00,0x9c,0xc0,0x6e,0x00,0x00,0x00]

s_atc_probe_buffer 0x0, s[8:11], tma_hi
// CHECK: [0x04,0x00,0x9c,0xc0,0x6f,0x00,0x00,0x00]

s_atc_probe_buffer 0x0, s[8:11], ttmp11
// CHECK: [0x04,0x00,0x9c,0xc0,0x7b,0x00,0x00,0x00]

s_atc_probe_buffer 0x0, s[8:11], m0
// CHECK: [0x04,0x00,0x9c,0xc0,0x7c,0x00,0x00,0x00]

s_atc_probe_buffer 0x0, s[8:11], 0x7ffff
// CHECK: [0x04,0x00,0x9e,0xc0,0xff,0xff,0x07,0x00]

s_load_dword s1, s[2:3] glc
// CHECK: s_load_dword s1, s[2:3], 0x0 glc ; encoding: [0x41,0x00,0x03,0xc0,0x00,0x00,0x00,0x00]
