/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the PatchedCollection type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &PatchedCollection{}

// PatchedCollection A serializer for a Collection.
type PatchedCollection struct {
	Deprecated *bool `json:"deprecated,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _PatchedCollection PatchedCollection

// NewPatchedCollection instantiates a new PatchedCollection object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewPatchedCollection() *PatchedCollection {
	this := PatchedCollection{}
	return &this
}

// NewPatchedCollectionWithDefaults instantiates a new PatchedCollection object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewPatchedCollectionWithDefaults() *PatchedCollection {
	this := PatchedCollection{}
	return &this
}

// GetDeprecated returns the Deprecated field value if set, zero value otherwise.
func (o *PatchedCollection) GetDeprecated() bool {
	if o == nil || IsNil(o.Deprecated) {
		var ret bool
		return ret
	}
	return *o.Deprecated
}

// GetDeprecatedOk returns a tuple with the Deprecated field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PatchedCollection) GetDeprecatedOk() (*bool, bool) {
	if o == nil || IsNil(o.Deprecated) {
		return nil, false
	}
	return o.Deprecated, true
}

// HasDeprecated returns a boolean if a field has been set.
func (o *PatchedCollection) HasDeprecated() bool {
	if o != nil && !IsNil(o.Deprecated) {
		return true
	}

	return false
}

// SetDeprecated gets a reference to the given bool and assigns it to the Deprecated field.
func (o *PatchedCollection) SetDeprecated(v bool) {
	o.Deprecated = &v
}

func (o PatchedCollection) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o PatchedCollection) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Deprecated) {
		toSerialize["deprecated"] = o.Deprecated
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *PatchedCollection) UnmarshalJSON(bytes []byte) (err error) {
	varPatchedCollection := _PatchedCollection{}

	if err = json.Unmarshal(bytes, &varPatchedCollection); err == nil {
		*o = PatchedCollection(varPatchedCollection)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "deprecated")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullablePatchedCollection struct {
	value *PatchedCollection
	isSet bool
}

func (v NullablePatchedCollection) Get() *PatchedCollection {
	return v.value
}

func (v *NullablePatchedCollection) Set(val *PatchedCollection) {
	v.value = val
	v.isSet = true
}

func (v NullablePatchedCollection) IsSet() bool {
	return v.isSet
}

func (v *NullablePatchedCollection) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullablePatchedCollection(val *PatchedCollection) *NullablePatchedCollection {
	return &NullablePatchedCollection{value: val, isSet: true}
}

func (v NullablePatchedCollection) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullablePatchedCollection) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


