/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cms.IssuerAndSerialNumber;

public class SignerIdentifier
implements ASN1Value {
    public static Type ISSUER_AND_SERIALNUMBER = Type.ISSUER_AND_SERIALNUMBER;
    public static Type SUBJECT_KEY_IDENTIFIER = Type.SUBJECT_KEY_IDENTIFIER;
    private Type type;
    private IssuerAndSerialNumber issuerAndSerialNumber = null;
    private OCTET_STRING subjectKeyIdentifier = null;
    private static Template templateInstance = new Template();

    public Type getType() {
        return this.type;
    }

    public IssuerAndSerialNumber getIssuerAndSerialNumber() {
        return this.issuerAndSerialNumber;
    }

    public OCTET_STRING getSubjectKeyIdentifier() {
        return this.subjectKeyIdentifier;
    }

    public SignerIdentifier(Type type, IssuerAndSerialNumber issuerAndSerialNumber, OCTET_STRING subjectKeyIdentifier) {
        this.type = type;
        this.issuerAndSerialNumber = issuerAndSerialNumber;
        this.subjectKeyIdentifier = subjectKeyIdentifier;
    }

    public static SignerIdentifier createIssuerAndSerialNumber(IssuerAndSerialNumber ias) {
        return new SignerIdentifier(ISSUER_AND_SERIALNUMBER, ias, null);
    }

    public static SignerIdentifier createSubjectKeyIdentifier(OCTET_STRING ski) {
        return new SignerIdentifier(SUBJECT_KEY_IDENTIFIER, null, ski);
    }

    @Override
    public Tag getTag() {
        if (this.type == SUBJECT_KEY_IDENTIFIER) {
            return Tag.get(0L);
        }
        assert (this.type == ISSUER_AND_SERIALNUMBER);
        return IssuerAndSerialNumber.TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        if (this.type == SUBJECT_KEY_IDENTIFIER) {
            this.subjectKeyIdentifier.encode(Tag.get(0L), ostream);
        } else {
            assert (this.type == ISSUER_AND_SERIALNUMBER);
            this.issuerAndSerialNumber.encode(ostream);
        }
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.encode(ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Type {
        static Type ISSUER_AND_SERIALNUMBER = new Type();
        static Type SUBJECT_KEY_IDENTIFIER = new Type();

        private Type() {
        }
    }

    public static class Template
    implements ASN1Template {
        private CHOICE.Template choicet = new CHOICE.Template();

        public Template() {
            this.choicet.addElement(Tag.get(0L), OCTET_STRING.getTemplate());
            this.choicet.addElement(IssuerAndSerialNumber.getTemplate());
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return this.choicet.tagMatch(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            CHOICE c = (CHOICE)this.choicet.decode(istream);
            if (c.getTag() == SEQUENCE.TAG) {
                return SignerIdentifier.createIssuerAndSerialNumber((IssuerAndSerialNumber)c.getValue());
            }
            assert (c.getTag().equals(Tag.get(0L)));
            OCTET_STRING ski = (OCTET_STRING)c.getValue();
            return SignerIdentifier.createSubjectKeyIdentifier(ski);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            return this.decode(istream);
        }
    }
}

