// Package v2 provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/deepmap/oapi-codegen version v1.8.2 DO NOT EDIT.
package v2

import (
	"bytes"
	"compress/gzip"
	"encoding/base64"
	"fmt"
	"net/http"
	"net/url"
	"path"
	"strings"

	"github.com/deepmap/oapi-codegen/pkg/runtime"
	"github.com/getkin/kin-openapi/openapi3"
	"github.com/labstack/echo/v4"
)

const (
	BearerScopes = "Bearer.Scopes"
)

// Defines values for ComposeStatusValue.
const (
	ComposeStatusValueFailure ComposeStatusValue = "failure"

	ComposeStatusValuePending ComposeStatusValue = "pending"

	ComposeStatusValueSuccess ComposeStatusValue = "success"
)

// Defines values for ImageStatusValue.
const (
	ImageStatusValueBuilding ImageStatusValue = "building"

	ImageStatusValueFailure ImageStatusValue = "failure"

	ImageStatusValuePending ImageStatusValue = "pending"

	ImageStatusValueRegistering ImageStatusValue = "registering"

	ImageStatusValueSuccess ImageStatusValue = "success"

	ImageStatusValueUploading ImageStatusValue = "uploading"
)

// Defines values for ImageTypes.
const (
	ImageTypesAws ImageTypes = "aws"

	ImageTypesAwsHaRhui ImageTypes = "aws-ha-rhui"

	ImageTypesAwsRhui ImageTypes = "aws-rhui"

	ImageTypesAwsSapRhui ImageTypes = "aws-sap-rhui"

	ImageTypesAzure ImageTypes = "azure"

	ImageTypesAzureEap7Rhui ImageTypes = "azure-eap7-rhui"

	ImageTypesAzureRhui ImageTypes = "azure-rhui"

	ImageTypesAzureSapRhui ImageTypes = "azure-sap-rhui"

	ImageTypesEdgeCommit ImageTypes = "edge-commit"

	ImageTypesEdgeContainer ImageTypes = "edge-container"

	ImageTypesEdgeInstaller ImageTypes = "edge-installer"

	ImageTypesGcp ImageTypes = "gcp"

	ImageTypesGcpRhui ImageTypes = "gcp-rhui"

	ImageTypesGuestImage ImageTypes = "guest-image"

	ImageTypesImageInstaller ImageTypes = "image-installer"

	ImageTypesIotCommit ImageTypes = "iot-commit"

	ImageTypesIotContainer ImageTypes = "iot-container"

	ImageTypesIotInstaller ImageTypes = "iot-installer"

	ImageTypesIotRawImage ImageTypes = "iot-raw-image"

	ImageTypesLiveInstaller ImageTypes = "live-installer"

	ImageTypesVsphere ImageTypes = "vsphere"

	ImageTypesVsphereOva ImageTypes = "vsphere-ova"
)

// Defines values for UploadStatusValue.
const (
	UploadStatusValueFailure UploadStatusValue = "failure"

	UploadStatusValuePending UploadStatusValue = "pending"

	UploadStatusValueRunning UploadStatusValue = "running"

	UploadStatusValueSuccess UploadStatusValue = "success"
)

// Defines values for UploadTypes.
const (
	UploadTypesAws UploadTypes = "aws"

	UploadTypesAwsS3 UploadTypes = "aws.s3"

	UploadTypesAzure UploadTypes = "azure"

	UploadTypesContainer UploadTypes = "container"

	UploadTypesGcp UploadTypes = "gcp"
)

// AWSEC2CloneCompose defines model for AWSEC2CloneCompose.
type AWSEC2CloneCompose struct {
	Region            string    `json:"region"`
	ShareWithAccounts *[]string `json:"share_with_accounts,omitempty"`
}

// AWSEC2UploadOptions defines model for AWSEC2UploadOptions.
type AWSEC2UploadOptions struct {
	Region            string   `json:"region"`
	ShareWithAccounts []string `json:"share_with_accounts"`
	SnapshotName      *string  `json:"snapshot_name,omitempty"`
}

// AWSEC2UploadStatus defines model for AWSEC2UploadStatus.
type AWSEC2UploadStatus struct {
	Ami    string `json:"ami"`
	Region string `json:"region"`
}

// AWSS3UploadOptions defines model for AWSS3UploadOptions.
type AWSS3UploadOptions struct {
	// If set to false (the default value), a long, obfuscated URL
	// is returned. Its expiration might be sooner than for other upload
	// targets.
	//
	// If set to true, a shorter URL is returned and
	// its expiration is the same as for the other upload targets.
	Public *bool  `json:"public,omitempty"`
	Region string `json:"region"`
}

// AWSS3UploadStatus defines model for AWSS3UploadStatus.
type AWSS3UploadStatus struct {
	Url string `json:"url"`
}

// AzureUploadOptions defines model for AzureUploadOptions.
type AzureUploadOptions struct {
	// Name of the uploaded image. It must be unique in the given resource group.
	// If name is omitted from the request, a random one based on a UUID is
	// generated.
	ImageName *string `json:"image_name,omitempty"`

	// Location of the provided resource_group, where the image should be uploaded and registered.
	// How to list all locations:
	// https://docs.microsoft.com/en-us/cli/azure/account?view=azure-cli-latest#az_account_list_locations'
	// If the location is not specified, it is deducted from the provided resource_group.
	Location *string `json:"location,omitempty"`

	// Name of the resource group where the image should be uploaded.
	ResourceGroup string `json:"resource_group"`

	// ID of subscription where the image should be uploaded.
	SubscriptionId string `json:"subscription_id"`

	// ID of the tenant where the image should be uploaded.
	// How to find it in the Azure Portal:
	// https://docs.microsoft.com/en-us/azure/active-directory/fundamentals/active-directory-how-to-find-tenant
	TenantId string `json:"tenant_id"`
}

// AzureUploadStatus defines model for AzureUploadStatus.
type AzureUploadStatus struct {
	ImageName string `json:"image_name"`
}

// CloneComposeBody defines model for CloneComposeBody.
type CloneComposeBody interface{}

// CloneComposeResponse defines model for CloneComposeResponse.
type CloneComposeResponse struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Id string `json:"id"`
}

// CloneStatus defines model for CloneStatus.
type CloneStatus struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded struct due to allOf(#/components/schemas/UploadStatus)
	UploadStatus `yaml:",inline"`
}

// ComposeId defines model for ComposeId.
type ComposeId struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Id string `json:"id"`
}

// ComposeLogs defines model for ComposeLogs.
type ComposeLogs struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	ImageBuilds []interface{} `json:"image_builds"`
	Koji        *KojiLogs     `json:"koji,omitempty"`
}

// ComposeManifests defines model for ComposeManifests.
type ComposeManifests struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Manifests []interface{} `json:"manifests"`
}

// ComposeMetadata defines model for ComposeMetadata.
type ComposeMetadata struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	// ID (hash) of the built commit
	OstreeCommit *string `json:"ostree_commit,omitempty"`

	// Package list including NEVRA
	Packages *[]PackageMetadata `json:"packages,omitempty"`
}

// ComposeRequest defines model for ComposeRequest.
type ComposeRequest struct {
	Customizations *Customizations `json:"customizations,omitempty"`
	Distribution   string          `json:"distribution"`
	ImageRequest   *ImageRequest   `json:"image_request,omitempty"`
	ImageRequests  *[]ImageRequest `json:"image_requests,omitempty"`
	Koji           *Koji           `json:"koji,omitempty"`
}

// ComposeStatus defines model for ComposeStatus.
type ComposeStatus struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	ImageStatus   ImageStatus        `json:"image_status"`
	ImageStatuses *[]ImageStatus     `json:"image_statuses,omitempty"`
	KojiStatus    *KojiStatus        `json:"koji_status,omitempty"`
	Status        ComposeStatusValue `json:"status"`
}

// ComposeStatusError defines model for ComposeStatusError.
type ComposeStatusError struct {
	Details *interface{} `json:"details,omitempty"`
	Id      int          `json:"id"`
	Reason  string       `json:"reason"`
}

// ComposeStatusValue defines model for ComposeStatusValue.
type ComposeStatusValue string

// Container defines model for Container.
type Container struct {
	// Name to use for the container from the image
	Name *string `json:"name,omitempty"`

	// Reference to the container to embed
	Source string `json:"source"`

	// Control TLS verifification
	TlsVerify *bool `json:"tls_verify,omitempty"`
}

// ContainerUploadOptions defines model for ContainerUploadOptions.
type ContainerUploadOptions struct {
	// Name for the created container image
	Name *string `json:"name,omitempty"`

	// Tag for the created container image
	Tag *string `json:"tag,omitempty"`
}

// ContainerUploadStatus defines model for ContainerUploadStatus.
type ContainerUploadStatus struct {
	// Digest of the manifest of the uploaded container on the registry
	Digest string `json:"digest"`

	// FQDN of the uploaded image
	Url string `json:"url"`
}

// CustomRepository defines model for CustomRepository.
type CustomRepository struct {
	Baseurl      *[]string `json:"baseurl,omitempty"`
	CheckGpg     *bool     `json:"check_gpg,omitempty"`
	CheckRepoGpg *bool     `json:"check_repo_gpg,omitempty"`
	Enabled      *bool     `json:"enabled,omitempty"`
	Filename     *string   `json:"filename,omitempty"`
	Gpgkey       *[]string `json:"gpgkey,omitempty"`
	Id           string    `json:"id"`
	Metalink     *string   `json:"metalink,omitempty"`
	Mirrorlist   *string   `json:"mirrorlist,omitempty"`
	Name         *string   `json:"name,omitempty"`
	Priority     *int      `json:"priority,omitempty"`
	SslVerify    *bool     `json:"ssl_verify,omitempty"`
}

// Customizations defines model for Customizations.
type Customizations struct {
	Containers *[]Container `json:"containers,omitempty"`

	// Extra repositories for packages specified in customizations. These
	// repositories will be used to depsolve and retrieve packages. Additionally,
	// these packages will be saved and imported to the `/etc/yum.repos.d/` directory
	// on the image
	CustomRepositories *[]CustomRepository `json:"custom_repositories,omitempty"`
	Directories        *[]Directory        `json:"directories,omitempty"`
	Files              *[]File             `json:"files,omitempty"`
	Filesystem         *[]Filesystem       `json:"filesystem,omitempty"`
	Openscap           *OpenSCAP           `json:"openscap,omitempty"`
	Packages           *[]string           `json:"packages,omitempty"`

	// Extra repositories for packages specified in customizations. These
	// repositories will only be used to depsolve and retrieve packages
	// for the OS itself (they will not be available for the build root or
	// any other part of the build process). The package_sets field for these
	// repositories is ignored.
	PayloadRepositories *[]Repository `json:"payload_repositories,omitempty"`
	Services            *struct {
		// List of services to disable by default
		Disabled *[]string `json:"disabled,omitempty"`

		// List of services to enable by default
		Enabled *[]string `json:"enabled,omitempty"`
	} `json:"services,omitempty"`
	Subscription *Subscription `json:"subscription,omitempty"`
	Users        *[]User       `json:"users,omitempty"`
}

// A custom directory to create in the final artifact.
type Directory struct {
	// Ensure that the parent directories exist
	EnsureParents *bool `json:"ensure_parents,omitempty"`

	// Group of the directory as a group name or a gid
	Group *interface{} `json:"group,omitempty"`

	// Permissions string for the directory in octal format
	Mode *string `json:"mode,omitempty"`

	// Path to the directory
	Path string `json:"path"`

	// Owner of the directory as a user name or a uid
	User *interface{} `json:"user,omitempty"`
}

// Error defines model for Error.
type Error struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Code        string       `json:"code"`
	Details     *interface{} `json:"details,omitempty"`
	OperationId string       `json:"operation_id"`
	Reason      string       `json:"reason"`
}

// ErrorList defines model for ErrorList.
type ErrorList struct {
	// Embedded struct due to allOf(#/components/schemas/List)
	List `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Items []Error `json:"items"`
}

// A custom file to create in the final artifact.
type File struct {
	// Contents of the file as plain text
	Data *string `json:"data,omitempty"`

	// Ensure that the parent directories exist
	EnsureParents *bool `json:"ensure_parents,omitempty"`

	// Group of the file as a gid or a group name
	Group *interface{} `json:"group,omitempty"`

	// Permissions string for the file in octal format
	Mode *string `json:"mode,omitempty"`

	// Path to the file
	Path string `json:"path"`

	// Owner of the file as a uid or a user name
	User *interface{} `json:"user,omitempty"`
}

// Filesystem defines model for Filesystem.
type Filesystem struct {
	// size of the filesystem in bytes
	MinSize    uint64 `json:"min_size"`
	Mountpoint string `json:"mountpoint"`
}

// GCPUploadOptions defines model for GCPUploadOptions.
type GCPUploadOptions struct {
	// Name of an existing STANDARD Storage class Bucket.
	Bucket *string `json:"bucket,omitempty"`

	// The name to use for the imported and shared Compute Engine image.
	// The image name must be unique within the GCP project, which is used
	// for the OS image upload and import. If not specified a random
	// 'composer-api-<uuid>' string is used as the image name.
	ImageName *string `json:"image_name,omitempty"`

	// The GCP region where the OS image will be imported to and shared from.
	// The value must be a valid GCP location. See https://cloud.google.com/storage/docs/locations.
	// If not specified, the multi-region location closest to the source
	// (source Storage Bucket location) is chosen automatically.
	Region string `json:"region"`

	// List of valid Google accounts to share the imported Compute Engine image with.
	// Each string must contain a specifier of the account type. Valid formats are:
	//   - 'user:{emailid}': An email address that represents a specific
	//     Google account. For example, 'alice@example.com'.
	//   - 'serviceAccount:{emailid}': An email address that represents a
	//     service account. For example, 'my-other-app@appspot.gserviceaccount.com'.
	//   - 'group:{emailid}': An email address that represents a Google group.
	//     For example, 'admins@example.com'.
	//   - 'domain:{domain}': The G Suite domain (primary) that represents all
	//     the users of that domain. For example, 'google.com' or 'example.com'.
	// If not specified, the imported Compute Engine image is not shared with any
	// account.
	ShareWithAccounts *[]string `json:"share_with_accounts,omitempty"`
}

// GCPUploadStatus defines model for GCPUploadStatus.
type GCPUploadStatus struct {
	ImageName string `json:"image_name"`
	ProjectId string `json:"project_id"`
}

// ImageRequest defines model for ImageRequest.
type ImageRequest struct {
	Architecture string       `json:"architecture"`
	ImageType    ImageTypes   `json:"image_type"`
	Ostree       *OSTree      `json:"ostree,omitempty"`
	Repositories []Repository `json:"repositories"`

	// Size of image, in bytes. When set to 0 the image size is a minimum
	// defined by the image type.
	Size *uint64 `json:"size,omitempty"`

	// This should really be oneOf but AWSS3UploadOptions is a subset of
	// AWSEC2UploadOptions. This means that all AWSEC2UploadOptions objects
	// are also valid AWSS3UploadOptionas objects which violates the oneOf
	// rules. Therefore, we have to use anyOf here but be aware that it isn't
	// possible to mix and match more schemas together.
	UploadOptions *UploadOptions `json:"upload_options,omitempty"`
}

// ImageStatus defines model for ImageStatus.
type ImageStatus struct {
	Error        *ComposeStatusError `json:"error,omitempty"`
	Status       ImageStatusValue    `json:"status"`
	UploadStatus *UploadStatus       `json:"upload_status,omitempty"`
}

// ImageStatusValue defines model for ImageStatusValue.
type ImageStatusValue string

// ImageTypes defines model for ImageTypes.
type ImageTypes string

// Koji defines model for Koji.
type Koji struct {
	Name    string `json:"name"`
	Release string `json:"release"`
	Server  string `json:"server"`
	TaskId  int    `json:"task_id"`
	Version string `json:"version"`
}

// KojiLogs defines model for KojiLogs.
type KojiLogs struct {
	Import interface{} `json:"import"`
	Init   interface{} `json:"init"`
}

// KojiStatus defines model for KojiStatus.
type KojiStatus struct {
	BuildId *int `json:"build_id,omitempty"`
}

// List defines model for List.
type List struct {
	Kind  string `json:"kind"`
	Page  int    `json:"page"`
	Size  int    `json:"size"`
	Total int    `json:"total"`
}

// LocalUploadOptions defines model for LocalUploadOptions.
type LocalUploadOptions struct {
	// This is used in combination with the OSBUILD_LOCALSAVE environmental
	// variable on the server to enable saving the compose locally. This
	// is for development use only, and is not available to users.
	LocalSave bool `json:"local_save"`
}

// OSTree defines model for OSTree.
type OSTree struct {
	// A URL which, if set, is used for fetching content. Implies that `url` is set as well,
	// which will be used for metadata only.
	Contenturl *string `json:"contenturl,omitempty"`

	// Can be either a commit (example: 02604b2da6e954bd34b8b82a835e5a77d2b60ffa), or a branch-like reference (example: rhel/8/x86_64/edge)
	Parent *string `json:"parent,omitempty"`
	Ref    *string `json:"ref,omitempty"`

	// Determines whether a valid subscription manager (candlepin) identity is required to
	// access this repository. Consumer certificates will be used as client certificates when
	// fetching metadata and content.
	Rhsm *bool   `json:"rhsm,omitempty"`
	Url  *string `json:"url,omitempty"`
}

// ObjectReference defines model for ObjectReference.
type ObjectReference struct {
	Href string `json:"href"`
	Id   string `json:"id"`
	Kind string `json:"kind"`
}

// OpenSCAP defines model for OpenSCAP.
type OpenSCAP struct {
	ProfileId string `json:"profile_id"`
}

// PackageMetadata defines model for PackageMetadata.
type PackageMetadata struct {
	Arch      string  `json:"arch"`
	Epoch     *string `json:"epoch,omitempty"`
	Name      string  `json:"name"`
	Release   string  `json:"release"`
	Sigmd5    string  `json:"sigmd5"`
	Signature *string `json:"signature,omitempty"`
	Type      string  `json:"type"`
	Version   string  `json:"version"`
}

// Repository configuration.
// At least one of the 'baseurl', 'mirrorlist', 'metalink' properties must
// be specified. If more of them are specified, the order of precedence is
// the same as listed above.
type Repository struct {
	Baseurl  *string `json:"baseurl,omitempty"`
	CheckGpg *bool   `json:"check_gpg,omitempty"`

	// Enables gpg verification of the repository metadata
	CheckRepoGpg *bool `json:"check_repo_gpg,omitempty"`

	// GPG key used to sign packages in this repository.
	Gpgkey     *string `json:"gpgkey,omitempty"`
	IgnoreSsl  *bool   `json:"ignore_ssl,omitempty"`
	Metalink   *string `json:"metalink,omitempty"`
	Mirrorlist *string `json:"mirrorlist,omitempty"`

	// Naming package sets for a repository assigns it to a specific part
	// (pipeline) of the build process.
	PackageSets *[]string `json:"package_sets,omitempty"`

	// Determines whether a valid subscription is required to access this repository.
	Rhsm *bool `json:"rhsm,omitempty"`
}

// Subscription defines model for Subscription.
type Subscription struct {
	ActivationKey string `json:"activation_key"`
	BaseUrl       string `json:"base_url"`
	Insights      bool   `json:"insights"`
	Organization  string `json:"organization"`

	// Optional flag to use rhc to register the system, which also always enables Insights.
	Rhc       *bool  `json:"rhc,omitempty"`
	ServerUrl string `json:"server_url"`
}

// This should really be oneOf but AWSS3UploadOptions is a subset of
// AWSEC2UploadOptions. This means that all AWSEC2UploadOptions objects
// are also valid AWSS3UploadOptionas objects which violates the oneOf
// rules. Therefore, we have to use anyOf here but be aware that it isn't
// possible to mix and match more schemas together.
type UploadOptions interface{}

// UploadStatus defines model for UploadStatus.
type UploadStatus struct {
	Options interface{}       `json:"options"`
	Status  UploadStatusValue `json:"status"`
	Type    UploadTypes       `json:"type"`
}

// UploadStatusValue defines model for UploadStatusValue.
type UploadStatusValue string

// UploadTypes defines model for UploadTypes.
type UploadTypes string

// User defines model for User.
type User struct {
	Groups *[]string `json:"groups,omitempty"`
	Key    *string   `json:"key,omitempty"`
	Name   string    `json:"name"`
}

// Page defines model for page.
type Page string

// Size defines model for size.
type Size string

// PostComposeJSONBody defines parameters for PostCompose.
type PostComposeJSONBody ComposeRequest

// PostCloneComposeJSONBody defines parameters for PostCloneCompose.
type PostCloneComposeJSONBody CloneComposeBody

// GetErrorListParams defines parameters for GetErrorList.
type GetErrorListParams struct {
	// Page index
	Page *Page `json:"page,omitempty"`

	// Number of items in each page
	Size *Size `json:"size,omitempty"`
}

// PostComposeJSONRequestBody defines body for PostCompose for application/json ContentType.
type PostComposeJSONRequestBody PostComposeJSONBody

// PostCloneComposeJSONRequestBody defines body for PostCloneCompose for application/json ContentType.
type PostCloneComposeJSONRequestBody PostCloneComposeJSONBody

// ServerInterface represents all server handlers.
type ServerInterface interface {
	// The status of a cloned compose
	// (GET /clones/{id})
	GetCloneStatus(ctx echo.Context, id string) error
	// Create compose
	// (POST /compose)
	PostCompose(ctx echo.Context) error
	// The status of a compose
	// (GET /composes/{id})
	GetComposeStatus(ctx echo.Context, id string) error
	// Clone an existing compose
	// (POST /composes/{id}/clone)
	PostCloneCompose(ctx echo.Context, id string) error
	// Get logs for a compose.
	// (GET /composes/{id}/logs)
	GetComposeLogs(ctx echo.Context, id string) error
	// Get the manifests for a compose.
	// (GET /composes/{id}/manifests)
	GetComposeManifests(ctx echo.Context, id string) error
	// Get the metadata for a compose.
	// (GET /composes/{id}/metadata)
	GetComposeMetadata(ctx echo.Context, id string) error
	// Get a list of all possible errors
	// (GET /errors)
	GetErrorList(ctx echo.Context, params GetErrorListParams) error
	// Get error description
	// (GET /errors/{id})
	GetError(ctx echo.Context, id string) error
	// Get the openapi spec in json format
	// (GET /openapi)
	GetOpenapi(ctx echo.Context) error
}

// ServerInterfaceWrapper converts echo contexts to parameters.
type ServerInterfaceWrapper struct {
	Handler ServerInterface
}

// GetCloneStatus converts echo context to params.
func (w *ServerInterfaceWrapper) GetCloneStatus(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetCloneStatus(ctx, id)
	return err
}

// PostCompose converts echo context to params.
func (w *ServerInterfaceWrapper) PostCompose(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.PostCompose(ctx)
	return err
}

// GetComposeStatus converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeStatus(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeStatus(ctx, id)
	return err
}

// PostCloneCompose converts echo context to params.
func (w *ServerInterfaceWrapper) PostCloneCompose(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.PostCloneCompose(ctx, id)
	return err
}

// GetComposeLogs converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeLogs(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeLogs(ctx, id)
	return err
}

// GetComposeManifests converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeManifests(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeManifests(ctx, id)
	return err
}

// GetComposeMetadata converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeMetadata(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeMetadata(ctx, id)
	return err
}

// GetErrorList converts echo context to params.
func (w *ServerInterfaceWrapper) GetErrorList(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Parameter object where we will unmarshal all parameters from the context
	var params GetErrorListParams
	// ------------- Optional query parameter "page" -------------

	err = runtime.BindQueryParameter("form", true, false, "page", ctx.QueryParams(), &params.Page)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter page: %s", err))
	}

	// ------------- Optional query parameter "size" -------------

	err = runtime.BindQueryParameter("form", true, false, "size", ctx.QueryParams(), &params.Size)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter size: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetErrorList(ctx, params)
	return err
}

// GetError converts echo context to params.
func (w *ServerInterfaceWrapper) GetError(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetError(ctx, id)
	return err
}

// GetOpenapi converts echo context to params.
func (w *ServerInterfaceWrapper) GetOpenapi(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetOpenapi(ctx)
	return err
}

// This is a simple interface which specifies echo.Route addition functions which
// are present on both echo.Echo and echo.Group, since we want to allow using
// either of them for path registration
type EchoRouter interface {
	CONNECT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	DELETE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	GET(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	HEAD(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	OPTIONS(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PATCH(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	POST(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PUT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	TRACE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
}

// RegisterHandlers adds each server route to the EchoRouter.
func RegisterHandlers(router EchoRouter, si ServerInterface) {
	RegisterHandlersWithBaseURL(router, si, "")
}

// Registers handlers, and prepends BaseURL to the paths, so that the paths
// can be served under a prefix.
func RegisterHandlersWithBaseURL(router EchoRouter, si ServerInterface, baseURL string) {

	wrapper := ServerInterfaceWrapper{
		Handler: si,
	}

	router.GET(baseURL+"/clones/:id", wrapper.GetCloneStatus)
	router.POST(baseURL+"/compose", wrapper.PostCompose)
	router.GET(baseURL+"/composes/:id", wrapper.GetComposeStatus)
	router.POST(baseURL+"/composes/:id/clone", wrapper.PostCloneCompose)
	router.GET(baseURL+"/composes/:id/logs", wrapper.GetComposeLogs)
	router.GET(baseURL+"/composes/:id/manifests", wrapper.GetComposeManifests)
	router.GET(baseURL+"/composes/:id/metadata", wrapper.GetComposeMetadata)
	router.GET(baseURL+"/errors", wrapper.GetErrorList)
	router.GET(baseURL+"/errors/:id", wrapper.GetError)
	router.GET(baseURL+"/openapi", wrapper.GetOpenapi)

}

// Base64 encoded, gzipped, json marshaled Swagger object
var swaggerSpec = []string{

	"H4sIAAAAAAAC/+x9eXPiONP4V1Hx/qpmp8J9BJKqreclhCQkkAtyLlt5hC1sgS05ksyRrfnuv5JkGxtM",
	"QnZm9zne2T92YltqtVrdrb4k/sgY1PUoQUTwzOEfGQ8y6CKBWPBkIfmvibjBsCcwJZnDzDW0EMDERItM",
	"NoMW0PUclGg+g46PMoeZUubbt2wGyz6vPmLLTDZDoCu/qJbZDDds5ELZRSw9+Z4LhomlunH8ljL2pe+O",
	"EAN0DLBALgeYAAQNGwQA49iEACJsisWt+Ki27+HzLfyoQDcf+u1WueVQglqSfFwNBE0TSzShc82oh5jA",
	"EpExdDjKZrzYqz8yDFlqPhsDZTPchgy9zLGwX6BhUD9YmGBmmcPfMqVypVrbrzcOiqVy5vdsRlEiFVbw",
	"AjIGl2ruDL36mCFTgglw+D1qRkcTZAjZT8/vznMoNK8U6fmfnmCEeAb5uTniIlfKZP/OaWcznECP21S8",
	"6NWO4+Quc+HXTazSCZaO60dk7AsofC0lCUJBFycxgi7OFY1GpVg/qNTrtdpBzayO0ij2SRKvTUaOm/2A",
	"B/qV72EBzx852NAiPIa+I6J2SZHujAFHAggK1Gfwi7ARCLoAJbxfswAChxIrC+ho7HMDCmSCu9vukGAO",
	"GBI+I8jMg47gAC08zKAEDVxs2QKMEOCUEsSAsCEBY8oAFTZiwFdzGxIBmYUEzw/JkKxwEcxHclhuUyYQ",
	"k6OB2GAAEnNIcHJAzIHEnUMXAcjVUPI5PhxYjbZaohGlDoLk+xd1t+Xcxoo+c9JVcXwI2SgV/pvP0Pew",
	"C3ahhSIJXdP6kqJ0rKip6YhMoDrIRQeuz9U6+wS/+nJrUg0tPEMEMMSpzwwELEZ9L6+WWA4iF4u6WEhO",
	"GjPqqi5yoogLue4MEpO6gBIERpAjE1ACILi76xwDzIfEQgQxyYZ6IRMKRSGWJrEONaAIljc5wW7wJZyk",
	"x+gMy0mG6L8o9LNgbiOGVBM1imRP3zHV5EO6QCK7WZgLxBR+Z3QuOdrBXADoOCBEgx8OiS2Exw8LBZMa",
	"PO9ig1FOxyJvULeASM7nBcPBBSjXthCoun/MMJr/ql7lDAfnHCgQF/8D30Jd+CIHeokG+aJILjEOX0nS",
	"EyoA95CBxxiZWYCFfGki0zcSC7KFDutEl+KBfMlO6Yoy3vd97kqyyw7kXkdlQH0DktsAzKkaMW2780cR",
	"Ci/Y3ESqcyxRijf7E8hUUc1sjMpGDo7K1Vy1WqrkDopGLbdfKleK+6hRPEDlNOwEIpCId/CSSOhGu2EV",
	"sOAYE1OttZZQpTPANWUCOrvwYsiHAs9QzsQMGYKyZWHsExO6iAjo8I2vOZvOc4Lm5NA5jfIakWpGHY1r",
	"o/1cyaiMc1UTFnNwv1zOFUfF/WK5cmDWzfqHmndFsc213eDAD/TnNv2c1JC7qJw1JGMA0lCI27NH1FzK",
	"UShBV+PM4W9/ZP4fQ+PMYeZ/CiuHoRCYxIUUe/jb72sQbxH3KAksZcfZAeqVwuwWjRFDxECZb9kNiphJ",
	"SpTKFSRtxBxqHIxypbJZycFqbT9XLe/v12rVarFYLGaymTFlLhSZw4zvq+X5gGpmCrWi2a0W689P6r32",
	"CZbQw2p6dsz/IkrqKXWpxX/opBS/j3zsmPp5zWMIUMhmFjmL5oKXmAjExtBAf3xL8yWmdKIM9vcwu6AT",
	"rOaSLoABQu+SogcJHiMufig93DjQ7yfG2uRW0N+fGRLQhAL+yIlRLhhCLwZ1XSxS96xfbMjtr+HWJVdA",
	"gKB5yv7nQWMKLQ17PfahvmhjChPD8U1MLHDZvr9tZmI+6XvzCWBEhEgj7Hb63Wob9ZPWteFzQV38BiPT",
	"/D0MW8nW37IZE0vqjHyx4Z0wGzm5RhoVNbezFb7vDdmRjcO5rXdOMuxnwPxZ8d3g7gQBYsvxI/R/mtbi",
	"EdwPpxtuDtlEV/RJoq2gpNFsR3wk6VaAduuTIOS9CtatEz8AlJzg+2pGg2szRtmmJWUiAbEj/5REM2Na",
	"UCo8CzHtNkCeGqPb3NWixhsI6PlIgSG+q6biGwbici5jiB2fSavNQ0RqETmhlVytGm4IVosSATFBKTN7",
	"x38WFPgcRVEJIwSy8ra2Oq7aet2EG7GxipgkgAoKkDtCZsLU1m4pW+aDV8q2V6MeCmileiIOf5khhsfL",
	"zdElGRh1wKDbB6oNHuPAwY4NqgI5G5GWdQbTE0y1isMpfU9w451lidaDIRXWWpFQEWbNWaFcWQ+ppILW",
	"5hADaH1yBO3Pp9pyH9Empgt3J42JrWB7SGJ+rN6HO3ZoXGxEgVaToSTw4DWPxQNsKyIFMa7kUCc3x5fp",
	"4aU12rz6cJnHtOAug1hHIViPw3eoth49y4ZTTuU2tfPeIo9yLN3XTQkfQY6CWUTKfYVh6EMbJskzZNpQ",
	"+8+SSoiIgtzFCnLHbhQahUVj/2W/WpAAKS9QXkgY9AynMtna3mDYyJi+WJ4V05OxcKb+zJBHt7dBBI4c",
	"ZKZ/HGMHhcKzgYzlWVO0TDNmtyOc0ParZi4S0MFkmk5NF8t9hOfHyKQMeozK5cpTZhXCfv+Qc/xVf89V",
	"ykO/WCzvQ2bYv2oq70BaPYg0LDeRiHCQn/MGIoJyNf4/GHIQ5OjXRk7awNCNjQzl//er+o3C7whydNXf",
	"AZetJPcYpgyLZfqWybkT09Yf6NxUbzCUgLil+hkzN9QGuxs/q800jb0VMoqBlTziNJ+gvRAMgngbpXJD",
	"J2IV5wSYgKQhngcDG3E0JInec+w4KoDGkSk3UhN5nDozFIR2BcNohiL4edCMCOQss0MiJMjV8CE0DmdB",
	"dBi7HmVCw5Y6758FJIzC0nfzCo28WfgniAJoQxIo1pVC3I2u65oshbzhIPgTxupxiFgaQKkudgd1gh20",
	"FcqSC+R+ClTQJQUg9RDhBvQ+gnLlIdJvNa/XfdBYFtSjXFgM8c9lQD24lNvav4SRKXGWu3PzkITmylUf",
	"YMGRM1YZwaUGRqjK9MAZxI7cNiLjRm3DgFEqAGVDAskyyLt5kIm4328Cj1FpWX9VOIcDv3AkOBhj5Jgh",
	"zI3pYA6wRSgLA+07ccb7EsARm2EDfd5o4tGmuZZJwtpICgEriuvWYLQM86px5Fc7zRgzNIdOunnpYtLR",
	"XUqb04jt4R+joxt/iA0ZC9mOfxKZNDs1HpH/aL368bbSYuSf2U3ueNpGkobTSo9tEK0ZCNdKCUuyafM9",
	"zJ2MMYEOgEzgMTSE5sckjyDCfYZePMjC4p738/Bt1R4IGwqde1MdQUxHA7TAcSM3ZqdtSa2p/FcofavZ",
	"QA5gkGFTuVjK5DNecxapqslYZSDWuWDTApHut0vNtJolxFzMuVRVQAOINMcKLUwANQR0QGAexbEp1mu1",
	"9FChsNPChMIOd9cIfgKe2nLdpYlZqpvCtXOfhHo1J7r2KYWaskeMmP6PIOaawaammmayRVGWHxUCM4I1",
	"3KBLInAje8BYAjUl8btbBEcNFzVfA5weZVJT7ga2+m7TVq1Twn2hWtlJv2hSfxSK16DSMVdGz3aVI22f",
	"P6NtwpD+ZohG4h8yrYIOOfAcKCGjRWr4/S/UXB+EhXZTZOEslM4KlFekzP4lOkxh9K762q9W/5z6kqDT",
	"NFfw/s+orhX9/JB+kfr6+7TWScLKX8uUYfKSXoAq38bnoSFI2o+WQhkrEfrlUrVebVT2q41kUs3HROxX",
	"lRlDfSI8ismay1+YQfZhLCnWObtCOG2mp63r7wlejnxjisT2uhlItHhJhuwPmpfHzdtj0BeUQQsBw4Gc",
	"gyMFIr9eKRU85IIRtuaQ0sOn0nonKZHtyL2VDoaq1TRBi7qeLxBoEwuTwJfND8kgKltRgNYKyeZY2IEC",
	"PG1dgyDukwVzGxu29AakS5N0WBSsoNRv5WrnQWecLHmKKsyG5IuhEwYsBz2cG/rFYsXwfWyqv9CXUNSD",
	"4aTciATWn6lAW5UXbpJSTlF/j9X0RHMKowjx2EGMvmNG3YCeqmQzIiWUz9hU0MMCsDzoIwSiUKVDfTNv",
	"UWoFCQGuWUfVARWiOrKgdC9ZN6ZCw74jcC7APKoxMxzKERehFtMB/iH5JSjvCtlTM2bU7asks2FTjgiA",
	"vqAuFNiAjrNcJzLyP1HEnO4SBXRR8wZhc4mvgpLk5DT2VeyZH5I2NOyQSRTVgyAYgBGlIs0bDAMk5nlw",
	"rzDQuwUHkKHDIQEgB75IbXz4B3IhdrD57cshaBKgngA0TYY413stQx5DXO3v0ViGBAHWppUHJ5SBgHpZ",
	"8AU62ED/G0sCfckHIwd+YlP3+yQOeugAxLax3WVOBQZy0PP+F3oe96jIW0GnsE8cJbW1f5YawfzDakWJ",
	"1xoJTBcTnkoDk7oQk8M/9L9yQCWeoO9jgYB+C37xGHYhW37dHNxx9IAqnSG9V736UAR91ymyEr0vcjP+",
	"soZTutS9z5phhadWDpJRASTLIQnpm5Sm35TRcLjBFZkoPhLyw66LlwkMucNNMmeymYDA8Zd/yTGKaN/9",
	"cRV9am+W8F/WK7YgNxAxIRG5EYPYzFWKlVqp8qEVEQOX/ahAMFFc8TkbAjLDxgIZwmdrc43yI1v2fv16",
	"hwKGwdJDquxAVwN9GGvtD2QrRY5kUPRHhPUi2zHwW4rrPks/sCPVJLOR/ZgHDzYi4SGEYryuVnbAUre4",
	"mGDXd4fERGNMkAlGy1g7pdqT8lUtH1QP9uvlg/1thqi2WF6ot1N5UNKY3DhZEl/qxCqukfr3kKW2iQcK",
	"4wo7l49E7vGny2eCwpOIFLsBSFZnpletrE3zUxUh2YwKWes/NWb677DAPygb2ZCdmETEhoJzOQyc85wN",
	"c8z2cfAU+5NDL3p808joWn8EvXriS/Ih1g+ZFspFxXXBU5hkC15gwgV0HPXCMjz9/xCAJRVMpAHVv4kO",
	"mIoVfP2wAi+f1xszOI/AzbgnrdvVXzk6g5lsxsGz+ChpRL0Iisf+ROHHSt+d6BxxS1q9uSPIt9jpKqub",
	"7FkulovFg2I9X0y1PRGbac97M389pROckryWr21/tEvaH/Lp+o5TLWdTUsAzxPhGjWDl46NLAfqroYIk",
	"9Ariiippe1NUc5uyyUpLJaj1Iqo+dCNeRjQr6ZbbwG9TU0pEd6FOWhogjCEmQU4xSQ9phkdsU3LvwZaz",
	"+UVQAZ20T2tUUINmo7O5+kis7pzdGlLMqrNLzvfEF6Tz5bxwOEMfh/oGNuaRK4wJMKg7wkS7fMrM1E7r",
	"0V2ne/zSvWo1u/3mfRsgMsOMEn1IZEhmkGGVgwpS25r5YrkpDmfSndIlbWp/US6idASBREEdPJR+v4lm",
	"yKGeBKxiEJQ4y6z2/LUJvMpU6igF23L0b20tYjRJo3lgvBz+kVL/gIhIrXJqqjOMKnaRBVgddMxGpJRz",
	"GSNh2HLaAZQ86Lieg1Hg3/zTZ84/ZQdpnEAO5shxskOigyGJkgUJzA2qmxVF8unFWDpOmxI1hkTCQlgl",
	"cGFQqA1+CYTrEBTL+8XqqGzCfXRQq47MSnXUGDXKsFGpoRqs183yaL84HsOvWR1dHDFIDDvn4CkCLKpZ",
	"XMFjNnJWBVFyg/q65u9vtkhX2+PN4ugdutnc/Zj1j5FAzMUEcTC3UUAaHURIHBNzIYEWYuAXAxLTQR4m",
	"XwE2ERFYLPURVs1mQFDlkGkHVn0ITdo8aFHCfRcxYEjmUnWV64UpkAPDwZLxk21sRIYk4qWID6RMhIy1",
	"5fDr1gOom/y/lkLaEAQ7WIpNpyJdr25RuGmlvoGaVCOkymZYxLGBlMfoGDsoPV216ZeFbdMGWT9DsHmu",
	"nBl26kyRR7d82Vr0FbNGNs0ObLlmbdsnAkOHb4tTnfIhZkF8cOZO+xRbzYSsJkKEozTEk5WV69XM4TfJ",
	"qGNs+ToLmB+SpgASplDngYNY2pegEvNLFnxZFeepp6Ao8AtYrYkKzQ3JCK0CKSoq7FIWQnQBZGg9zkKZ",
	"qcN3HkMGMpXikvtP/KC5HFcK5IjOUFpuLlYy+vdVin66MvSjHJ8qBgGWZwXF3skT0yvlFamcLVpmVTW6",
	"luK7PgVTtIzqlCT7rmqfVB4gqSQTG0RO/nfUPu1cguvTa3B9d9TttMBF+wkcda9aF+rzkAyJe9O5PDpt",
	"Gn2DHrWbx91x4+lsit7O96Hp9J7mdXh62nHOoSMa55PyonBUvtizO+OOvzgV3v2kjoake2sd39X3J3BQ",
	"8+6Pa+5J77ziTRFBtwVj4L6+3kwvlzfcfizTm8d5++2uPyq1LnutcevUmj42bspD8vY8ZR2jxU6KN+U5",
	"uxg50Dftuz18D0nzmLulxlP7lY9qzbtK3RR3rFe5eTIfrIPbvUd8Pb5v3A7JxdFkUKzM7o+uzF6fP1UO",
	"urBF9jte6WrmNTptWuig9v1T6dVtXV034UVxdH5W8cdWteWjKd8b9IdkfvMwQK3uwn/u7l/1HunV9cV8",
	"1rsZL0ZW6fG4MfOfixdiUjAuz8oL6BcXLm/6B2fnHprOrq5vF86QLF/FZPk8ZvQeo5OlN3+2ZjdzQUiv",
	"UbD6bb9wfj9gT8Va2W3fDeotY1SvTo2zk8HJuDd1yPS0MCTF8V21eQtrxepZZTEpTsUIVWYXxvUjvb7y",
	"L47u+Vl/VizenT41l9fIX+416sZd4alt9+rTSv/+YjIk+6jzbC1x76o4d0pPp8e3F4bvzKf8oLnnO1Or",
	"RAejKq+8uc+z62L9lA4WD9XyBF7UHvp7l/YzQkPS2C8+0nt7ZJQuvP7eZPxMJ5y1xXPjenT3vPc0O2nc",
	"esx8aLLJ2eh8Wj73bi+ai4G94DdNfmSfloak2PUX5QfYOypa5U7t2uiZ5wXjdUKLDcNgk6NHHy8eGK5h",
	"/6D36DVeB4Vx/+3S5WbHIo3C6/PFkODGje+M/Xrdf7UfCnNRHgmChXXLXyf2oudPnu6qz6OqPRUnDfvi",
	"rvD4WK+WX+1u7WLevG3eNI+GRByfnD4/3M4Mt21dHPdKF/1m49m9n44q53Z30Ct1H4+W8KFkG8Rphu+N",
	"s/MZdO8nZqs2GxLDNfbwzfnV0VHvqNVsVk9wu43O9l1mn5zV/Xt+0+31ysWnmvFsk8VT46TpKhlqnc4b",
	"J635tDMkR/PO6ckNPW81eevo6KnVnLdbZ1a7dVJtNlvW9GbVe+/yqVmoHz15lrPsN5+fzuzJ8sIeksLe",
	"eP/tenw/G52Vi+3XyrRTvzo5uiyS7uPe0V3J9Wf9vdeB3688dNlRxa2c+o7wLm7b5xdd4dbax0NSYqdv",
	"j006KC29g6dOo9s8Nnut1tVy0pxw+nDXqD/d+a29wohM2ADdlru3V63x8rpV3384aNTw1f2QuLX+3ojf",
	"HM/rrXKXOWazV+0d+3T5XOpjcQqfqxc33XuxN2jDUhXzp/5pa/JG69dPjfvK+dW0VhwS6/XBapQvCyO3",
	"3H7r1weNykP7eFRyZpNqx5ktrM7rBbJKpbfHp4XLnvrP5+et8extvOdc9vf9hXU2JJNF4by4dJ7LXTw6",
	"Zfunzeby6uDugTWf+/N+r9g2JoPGvN0ii2n/2F++ug/z+9nl0aPf7tw3rlDlaUh6+K40Pr9scLN+7PGT",
	"Ra2392iSHrnp752xyeD64rjiPjCnaZL2wDaf7huT56n3YB8veaVwcICuhsSeFlmXLIuTy/kU+uMCvmtc",
	"GfuPs9500r3tnVu1u4P7i+W5//Ag3uaPZNK7rD3cnhy9XlT5M3V7vSEZi9HgrLRXW45uHwrNyuxoBBe3",
	"D2VRv3u7nBhvaNp/bmPYvTzoFs6M81bntnRz0thvlI/NptM+OTCHZFq2bvBT/6YJ4Xnx/Lz5dja7nd6e",
	"d7vWRfnp5gmfXd4vy6JyvjwZcwbd2rzferga29eos+weDZ7Ph2TGvEvneoTGfHBQqw/G5aPLjm+9PbNW",
	"7X5x3L+YPlu3dun+dNbv3JDW8m16s9xv35Vfrz38UDuQOsq+7jw+swtqXFQuuv2DAn47vxncOmLSa/46",
	"JL9ejwf1IVG7S/vy+L2tJzXCrqpZXzh30jfpn6ci0o4Fq1Lh1HII6fAEjYCuJ1buZ8w2gVyaFRxgFd9f",
	"ZU1VmfKQ/OJhDzmYoK+pJcsbebPwMBj9ZD34j/U4k04l2OJTpgc9Njyb/lqt7ppbYwg807V5gRGXvMsL",
	"GQyJnPwUW04Pcj6nLLWsWdq0L6nG8aZtvAOLYMKxZa/dXbat1owyC5Kggn491FstVsrV9GDBDndq6UAc",
	"dMDYgVZYH8NsQ/4Zpg505EuVL4UlLdDhFEBnDpc8iIRx0AlmtMZ72+akQ2mbFI0zTF6yX4ywH9J1zfFL",
	"0C27zhMJHGILHFucNI96M4JJljtffbKWEct+2Gf9arWPumyUcH04xuZ9XB912XLS9aNuKfHfb7+nxm2D",
	"q4EYgo4+EqIK+8DIF2CTJDrXKdkGCUDHQ5JCaR2MBS6CJAhSQscBKQ2BXmc+JNLFVmyu9djGuDBqG8jE",
	"DFN1uFN74xLhIWG+g/SRF4bGlKEsmCNgw1lUiqZ4B6gqKjm7EQJwDsMSVXXZFfkihsSjnOMgNuzihYqR",
	"uVAYtg4LBBQGglpK+0oRjDh1WzYilsP9zOU9yUzm7gy8Y4/1UohPsO+OPdLPIqty2s/ncqNs8C7VB7pj",
	"UH6w7eaCIFgVrs7va+v4yaww8wnZlvqNo5OW+83zSpR0DVO8qwRqKsSgpPcTOR1VfcO3HFJWH0u7HC/e",
	"2OM5t3PILNdqpQPQbDabrcrlG2yVnOfjTuly0K7Jd51LdnrRZr0nvNfr3c39M3jbPHdvu7Tzdjsuvx6X",
	"zePaW/FosCjsL947/Loa1eeIfZzC3FI3ozZFw2dYLPuSYzSBjhBkmqoj9ddJuAGePwzCm2jV1qrbRVCl",
	"ZaLvo8VkTDet0H5Q/SZoYDqqXJROa+sKEZ5X2W4DBZdxBVfgNj1o2AiUVXZZbd+RoT+fz/NQfVbWddCX",
	"F7qdVvuy386V88W8LVxHrSAWimRX/SM1fFCewYAq8wTQw7FY7WGmHB6PlB8OM5V8MV/K6LJ0RaaC4VCC",
	"eOEPbH5TfJVWiHyKdN2/FjZVkgwCCQGUqQyeg0R4pl/fdwHDxJ6qWsU8uMwnZupSphJ4q8oadSRC2rtK",
	"NpGJzHz8sEjH1KjErwXLJi5U/i39Mr2gvkcjLyiwVCm0uqZYFa9HtxQHN42EHKdNsNWdxT/89q7f1c11",
	"6tY2tRjlYjGWZFQawfOcIBBbmARnbVYIvauuY1RS7JykTJwmkkWqP3DooEhoc9AO0UZBmPLFph669NcP",
	"3fTViYspUt4U1ojo0St//eh3BPrCpgy/aQ/OQ0zyBoh4W2NS/TswmRI6J2tLUPs7Vv+OoIWH1P2jqvAM",
	"UMPwmZS0uApXUhwq799+lzLCfdeFbBmU0ceVkFJeET8pOAVjdWG4R9MuPmnpk1cQEDQPu2aBR+XUsbKc",
	"DUp4cN5CHa2dIQZD5a70fXAAQd2MrgvgMQMmkl2CYvoNxXVNuQjvbtRKBnER3gL5YyQ+eX/Zt+T2KZXZ",
	"tw19U/rRo3fMtKUPPgIbcrl+TCDzX6Z02Orysp+a56fm2VHzBEojTdP8KOPpE/ZSSMMPDKXEDXo7mUoR",
	"4P9jxlKCUikclKTLT4Ppp9r6DzWYtuov7QjGraYU+yV+AfVO+iSmrP6NtMhfYHutX+39d1tfaReBp7CU",
	"OtKL5qtTZCOkClL1zYXpek2ghSioCwWS+KT8hM9u2qv6owZIk81viV1bkiVxfvodAXCC6vY/s4uPMcHc",
	"jm3i4N09HIvV1q2rmVXI3EUCAkw0D2NKABxRX4S/m+A74r1tXhXn/9zkP9zkg4vDU0VDskB0zF3/vknk",
	"IGICCFVpZGz4DmTBuV7wi7Cpb9lBvuO8f3X5Nf9fJ0in6gy3FSbcQy5PE6PEJejvylLUcgdxulW/C8RV",
	"fWh0V6lERvnggToj8R+ZyQN1cDtqbFAlWDy6d0MvX3jGDwoQD8cG947qagtIwntIcyG4fO0dUVxdLv9T",
	"Hj+UxxWxtghlYrk3BPO/U9aS4rGD0MXq1N+XuejYiBS5DTnTN0ygBTREYiOKfpbLRB4iJl9dBqxkLQr9",
	"q8Ox70lGiOdPwfhYMKLfL9giF+FSfkYufjqpP53UfzcndUM3pek7BTxuU2yomNWVcRvKJW1mqyYFdSJz",
	"W/1DrJ06svmXiv5qDmncrn8VhY5BQIyfYvavETPN6P95QgYjBoKOA6LiqJCbVmL2cUQbEl30QIzovJbG",
	"bHUD12gJ1NaZLqi7x49Q0Py7dv3K37yHb11K9QHE3/2U4p9S/BkpRpscJCU3KvLZvkNeBU2+k+/X6682",
	"JhqgonSB9MoliPDSzP9Au+Td6XyLarLTtFgvuEqMmr6h77+L7uFIloBBD+fVLfY2Dn6SE3pY/3RPTkUe",
	"EMuF9xgWZmVlrawVpgloYWK9NwAX0ELfOYwiIgmvOouG+QjO79/+fwAAAP//SQ/jhwp/AAA=",
}

// GetSwagger returns the content of the embedded swagger specification file
// or error if failed to decode
func decodeSpec() ([]byte, error) {
	zipped, err := base64.StdEncoding.DecodeString(strings.Join(swaggerSpec, ""))
	if err != nil {
		return nil, fmt.Errorf("error base64 decoding spec: %s", err)
	}
	zr, err := gzip.NewReader(bytes.NewReader(zipped))
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}
	var buf bytes.Buffer
	_, err = buf.ReadFrom(zr)
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}

	return buf.Bytes(), nil
}

var rawSpec = decodeSpecCached()

// a naive cached of a decoded swagger spec
func decodeSpecCached() func() ([]byte, error) {
	data, err := decodeSpec()
	return func() ([]byte, error) {
		return data, err
	}
}

// Constructs a synthetic filesystem for resolving external references when loading openapi specifications.
func PathToRawSpec(pathToFile string) map[string]func() ([]byte, error) {
	var res = make(map[string]func() ([]byte, error))
	if len(pathToFile) > 0 {
		res[pathToFile] = rawSpec
	}

	return res
}

// GetSwagger returns the Swagger specification corresponding to the generated code
// in this file. The external references of Swagger specification are resolved.
// The logic of resolving external references is tightly connected to "import-mapping" feature.
// Externally referenced files must be embedded in the corresponding golang packages.
// Urls can be supported but this task was out of the scope.
func GetSwagger() (swagger *openapi3.T, err error) {
	var resolvePath = PathToRawSpec("")

	loader := openapi3.NewLoader()
	loader.IsExternalRefsAllowed = true
	loader.ReadFromURIFunc = func(loader *openapi3.Loader, url *url.URL) ([]byte, error) {
		var pathToFile = url.String()
		pathToFile = path.Clean(pathToFile)
		getSpec, ok := resolvePath[pathToFile]
		if !ok {
			err1 := fmt.Errorf("path not found: %s", pathToFile)
			return nil, err1
		}
		return getSpec()
	}
	var specData []byte
	specData, err = rawSpec()
	if err != nil {
		return
	}
	swagger, err = loader.LoadFromData(specData)
	if err != nil {
		return
	}
	return
}
