/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// ContentPackageReleaseComponentsAPIService ContentPackageReleaseComponentsAPI service
type ContentPackageReleaseComponentsAPIService service

type ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsCreateRequest struct {
	ctx context.Context
	ApiService *ContentPackageReleaseComponentsAPIService
	debPackageReleaseComponent *DebPackageReleaseComponent
}

func (r ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsCreateRequest) DebPackageReleaseComponent(debPackageReleaseComponent DebPackageReleaseComponent) ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsCreateRequest {
	r.debPackageReleaseComponent = &debPackageReleaseComponent
	return r
}

func (r ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsCreateRequest) Execute() (*DebPackageReleaseComponentResponse, *http.Response, error) {
	return r.ApiService.ContentDebPackageReleaseComponentsCreateExecute(r)
}

/*
ContentDebPackageReleaseComponentsCreate Create a package release component

A PackageReleaseComponent associates a Package with a ReleaseComponent.

Associated artifacts: None; contains only metadata.

This simply stores the information which packages are part of which components.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsCreateRequest
*/
func (a *ContentPackageReleaseComponentsAPIService) ContentDebPackageReleaseComponentsCreate(ctx context.Context) ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsCreateRequest {
	return ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return DebPackageReleaseComponentResponse
func (a *ContentPackageReleaseComponentsAPIService) ContentDebPackageReleaseComponentsCreateExecute(r ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsCreateRequest) (*DebPackageReleaseComponentResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *DebPackageReleaseComponentResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentPackageReleaseComponentsAPIService.ContentDebPackageReleaseComponentsCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/content/deb/package_release_components/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.debPackageReleaseComponent == nil {
		return localVarReturnValue, nil, reportError("debPackageReleaseComponent is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.debPackageReleaseComponent
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsListRequest struct {
	ctx context.Context
	ApiService *ContentPackageReleaseComponentsAPIService
	limit *int32
	offset *int32
	ordering *[]string
	package_ *string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	releaseComponent *string
	repositoryVersion *string
	repositoryVersionAdded *string
	repositoryVersionRemoved *string
	fields *[]string
	excludeFields *[]string
}

// Number of results to return per page.
func (r ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsListRequest) Limit(limit int32) ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsListRequest {
	r.limit = &limit
	return r
}

// The initial index from which to return the results.
func (r ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsListRequest) Offset(offset int32) ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;upstream_id&#x60; - Upstream id * &#x60;-upstream_id&#x60; - Upstream id (descending) * &#x60;timestamp_of_interest&#x60; - Timestamp of interest * &#x60;-timestamp_of_interest&#x60; - Timestamp of interest (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsListRequest) Ordering(ordering []string) ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsListRequest {
	r.ordering = &ordering
	return r
}

// Filter results where package matches value
func (r ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsListRequest) Package_(package_ string) ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsListRequest {
	r.package_ = &package_
	return r
}

// Multiple values may be separated by commas.
func (r ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsListRequest) PulpHrefIn(pulpHrefIn []string) ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsListRequest) PulpIdIn(pulpIdIn []string) ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Filter results where release_component matches value
func (r ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsListRequest) ReleaseComponent(releaseComponent string) ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsListRequest {
	r.releaseComponent = &releaseComponent
	return r
}

// Repository Version referenced by HREF
func (r ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsListRequest) RepositoryVersion(repositoryVersion string) ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsListRequest {
	r.repositoryVersion = &repositoryVersion
	return r
}

// Repository Version referenced by HREF
func (r ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsListRequest) RepositoryVersionAdded(repositoryVersionAdded string) ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsListRequest {
	r.repositoryVersionAdded = &repositoryVersionAdded
	return r
}

// Repository Version referenced by HREF
func (r ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsListRequest) RepositoryVersionRemoved(repositoryVersionRemoved string) ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsListRequest {
	r.repositoryVersionRemoved = &repositoryVersionRemoved
	return r
}

// A list of fields to include in the response.
func (r ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsListRequest) Fields(fields []string) ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsListRequest) ExcludeFields(excludeFields []string) ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsListRequest) Execute() (*PaginateddebPackageReleaseComponentResponseList, *http.Response, error) {
	return r.ApiService.ContentDebPackageReleaseComponentsListExecute(r)
}

/*
ContentDebPackageReleaseComponentsList List package release components

A PackageReleaseComponent associates a Package with a ReleaseComponent.

Associated artifacts: None; contains only metadata.

This simply stores the information which packages are part of which components.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsListRequest
*/
func (a *ContentPackageReleaseComponentsAPIService) ContentDebPackageReleaseComponentsList(ctx context.Context) ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsListRequest {
	return ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginateddebPackageReleaseComponentResponseList
func (a *ContentPackageReleaseComponentsAPIService) ContentDebPackageReleaseComponentsListExecute(r ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsListRequest) (*PaginateddebPackageReleaseComponentResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginateddebPackageReleaseComponentResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentPackageReleaseComponentsAPIService.ContentDebPackageReleaseComponentsList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/content/deb/package_release_components/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.package_ != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "package", r.package_, "")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.releaseComponent != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "release_component", r.releaseComponent, "")
	}
	if r.repositoryVersion != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version", r.repositoryVersion, "")
	}
	if r.repositoryVersionAdded != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version_added", r.repositoryVersionAdded, "")
	}
	if r.repositoryVersionRemoved != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version_removed", r.repositoryVersionRemoved, "")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsReadRequest struct {
	ctx context.Context
	ApiService *ContentPackageReleaseComponentsAPIService
	debPackageReleaseComponentHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsReadRequest) Fields(fields []string) ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsReadRequest) ExcludeFields(excludeFields []string) ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsReadRequest) Execute() (*DebPackageReleaseComponentResponse, *http.Response, error) {
	return r.ApiService.ContentDebPackageReleaseComponentsReadExecute(r)
}

/*
ContentDebPackageReleaseComponentsRead Inspect a package release component

A PackageReleaseComponent associates a Package with a ReleaseComponent.

Associated artifacts: None; contains only metadata.

This simply stores the information which packages are part of which components.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param debPackageReleaseComponentHref
 @return ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsReadRequest
*/
func (a *ContentPackageReleaseComponentsAPIService) ContentDebPackageReleaseComponentsRead(ctx context.Context, debPackageReleaseComponentHref string) ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsReadRequest {
	return ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsReadRequest{
		ApiService: a,
		ctx: ctx,
		debPackageReleaseComponentHref: debPackageReleaseComponentHref,
	}
}

// Execute executes the request
//  @return DebPackageReleaseComponentResponse
func (a *ContentPackageReleaseComponentsAPIService) ContentDebPackageReleaseComponentsReadExecute(r ContentPackageReleaseComponentsAPIContentDebPackageReleaseComponentsReadRequest) (*DebPackageReleaseComponentResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *DebPackageReleaseComponentResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentPackageReleaseComponentsAPIService.ContentDebPackageReleaseComponentsRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{deb_package_release_component_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"deb_package_release_component_href"+"}", parameterValueToString(r.debPackageReleaseComponentHref, "debPackageReleaseComponentHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
