/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the UpstreamPulp type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &UpstreamPulp{}

// UpstreamPulp Serializer for a Server.
type UpstreamPulp struct {
	// A unique name for this Pulp server.
	Name string `json:"name"`
	// The transport, hostname, and an optional port of the Pulp server. e.g. https://example.com
	BaseUrl string `json:"base_url"`
	// The API root. Defaults to '/pulp/'.
	ApiRoot string `json:"api_root"`
	// The domain of the Pulp server if enabled.
	Domain NullableString `json:"domain,omitempty"`
	// A PEM encoded CA certificate used to validate the server certificate presented by the remote server.
	CaCert NullableString `json:"ca_cert,omitempty"`
	// A PEM encoded client certificate used for authentication.
	ClientCert NullableString `json:"client_cert,omitempty"`
	// A PEM encoded private key used for authentication.
	ClientKey NullableString `json:"client_key,omitempty"`
	// If True, TLS peer validation must be performed.
	TlsValidation *bool `json:"tls_validation,omitempty"`
	// The username to be used for authentication when syncing.
	Username NullableString `json:"username,omitempty"`
	// The password to be used for authentication when syncing. Extra leading and trailing whitespace characters are not trimmed.
	Password NullableString `json:"password,omitempty"`
	// One or more comma separated labels that will be used to filter distributions on the upstream Pulp. E.g. \"foo=bar,key=val\" or \"foo,key\"
	PulpLabelSelect NullableString `json:"pulp_label_select,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _UpstreamPulp UpstreamPulp

// NewUpstreamPulp instantiates a new UpstreamPulp object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewUpstreamPulp(name string, baseUrl string, apiRoot string) *UpstreamPulp {
	this := UpstreamPulp{}
	this.Name = name
	this.BaseUrl = baseUrl
	this.ApiRoot = apiRoot
	return &this
}

// NewUpstreamPulpWithDefaults instantiates a new UpstreamPulp object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewUpstreamPulpWithDefaults() *UpstreamPulp {
	this := UpstreamPulp{}
	return &this
}

// GetName returns the Name field value
func (o *UpstreamPulp) GetName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *UpstreamPulp) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *UpstreamPulp) SetName(v string) {
	o.Name = v
}

// GetBaseUrl returns the BaseUrl field value
func (o *UpstreamPulp) GetBaseUrl() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.BaseUrl
}

// GetBaseUrlOk returns a tuple with the BaseUrl field value
// and a boolean to check if the value has been set.
func (o *UpstreamPulp) GetBaseUrlOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.BaseUrl, true
}

// SetBaseUrl sets field value
func (o *UpstreamPulp) SetBaseUrl(v string) {
	o.BaseUrl = v
}

// GetApiRoot returns the ApiRoot field value
func (o *UpstreamPulp) GetApiRoot() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.ApiRoot
}

// GetApiRootOk returns a tuple with the ApiRoot field value
// and a boolean to check if the value has been set.
func (o *UpstreamPulp) GetApiRootOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.ApiRoot, true
}

// SetApiRoot sets field value
func (o *UpstreamPulp) SetApiRoot(v string) {
	o.ApiRoot = v
}

// GetDomain returns the Domain field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *UpstreamPulp) GetDomain() string {
	if o == nil || IsNil(o.Domain.Get()) {
		var ret string
		return ret
	}
	return *o.Domain.Get()
}

// GetDomainOk returns a tuple with the Domain field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *UpstreamPulp) GetDomainOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Domain.Get(), o.Domain.IsSet()
}

// HasDomain returns a boolean if a field has been set.
func (o *UpstreamPulp) HasDomain() bool {
	if o != nil && o.Domain.IsSet() {
		return true
	}

	return false
}

// SetDomain gets a reference to the given NullableString and assigns it to the Domain field.
func (o *UpstreamPulp) SetDomain(v string) {
	o.Domain.Set(&v)
}
// SetDomainNil sets the value for Domain to be an explicit nil
func (o *UpstreamPulp) SetDomainNil() {
	o.Domain.Set(nil)
}

// UnsetDomain ensures that no value is present for Domain, not even an explicit nil
func (o *UpstreamPulp) UnsetDomain() {
	o.Domain.Unset()
}

// GetCaCert returns the CaCert field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *UpstreamPulp) GetCaCert() string {
	if o == nil || IsNil(o.CaCert.Get()) {
		var ret string
		return ret
	}
	return *o.CaCert.Get()
}

// GetCaCertOk returns a tuple with the CaCert field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *UpstreamPulp) GetCaCertOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.CaCert.Get(), o.CaCert.IsSet()
}

// HasCaCert returns a boolean if a field has been set.
func (o *UpstreamPulp) HasCaCert() bool {
	if o != nil && o.CaCert.IsSet() {
		return true
	}

	return false
}

// SetCaCert gets a reference to the given NullableString and assigns it to the CaCert field.
func (o *UpstreamPulp) SetCaCert(v string) {
	o.CaCert.Set(&v)
}
// SetCaCertNil sets the value for CaCert to be an explicit nil
func (o *UpstreamPulp) SetCaCertNil() {
	o.CaCert.Set(nil)
}

// UnsetCaCert ensures that no value is present for CaCert, not even an explicit nil
func (o *UpstreamPulp) UnsetCaCert() {
	o.CaCert.Unset()
}

// GetClientCert returns the ClientCert field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *UpstreamPulp) GetClientCert() string {
	if o == nil || IsNil(o.ClientCert.Get()) {
		var ret string
		return ret
	}
	return *o.ClientCert.Get()
}

// GetClientCertOk returns a tuple with the ClientCert field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *UpstreamPulp) GetClientCertOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.ClientCert.Get(), o.ClientCert.IsSet()
}

// HasClientCert returns a boolean if a field has been set.
func (o *UpstreamPulp) HasClientCert() bool {
	if o != nil && o.ClientCert.IsSet() {
		return true
	}

	return false
}

// SetClientCert gets a reference to the given NullableString and assigns it to the ClientCert field.
func (o *UpstreamPulp) SetClientCert(v string) {
	o.ClientCert.Set(&v)
}
// SetClientCertNil sets the value for ClientCert to be an explicit nil
func (o *UpstreamPulp) SetClientCertNil() {
	o.ClientCert.Set(nil)
}

// UnsetClientCert ensures that no value is present for ClientCert, not even an explicit nil
func (o *UpstreamPulp) UnsetClientCert() {
	o.ClientCert.Unset()
}

// GetClientKey returns the ClientKey field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *UpstreamPulp) GetClientKey() string {
	if o == nil || IsNil(o.ClientKey.Get()) {
		var ret string
		return ret
	}
	return *o.ClientKey.Get()
}

// GetClientKeyOk returns a tuple with the ClientKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *UpstreamPulp) GetClientKeyOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.ClientKey.Get(), o.ClientKey.IsSet()
}

// HasClientKey returns a boolean if a field has been set.
func (o *UpstreamPulp) HasClientKey() bool {
	if o != nil && o.ClientKey.IsSet() {
		return true
	}

	return false
}

// SetClientKey gets a reference to the given NullableString and assigns it to the ClientKey field.
func (o *UpstreamPulp) SetClientKey(v string) {
	o.ClientKey.Set(&v)
}
// SetClientKeyNil sets the value for ClientKey to be an explicit nil
func (o *UpstreamPulp) SetClientKeyNil() {
	o.ClientKey.Set(nil)
}

// UnsetClientKey ensures that no value is present for ClientKey, not even an explicit nil
func (o *UpstreamPulp) UnsetClientKey() {
	o.ClientKey.Unset()
}

// GetTlsValidation returns the TlsValidation field value if set, zero value otherwise.
func (o *UpstreamPulp) GetTlsValidation() bool {
	if o == nil || IsNil(o.TlsValidation) {
		var ret bool
		return ret
	}
	return *o.TlsValidation
}

// GetTlsValidationOk returns a tuple with the TlsValidation field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpstreamPulp) GetTlsValidationOk() (*bool, bool) {
	if o == nil || IsNil(o.TlsValidation) {
		return nil, false
	}
	return o.TlsValidation, true
}

// HasTlsValidation returns a boolean if a field has been set.
func (o *UpstreamPulp) HasTlsValidation() bool {
	if o != nil && !IsNil(o.TlsValidation) {
		return true
	}

	return false
}

// SetTlsValidation gets a reference to the given bool and assigns it to the TlsValidation field.
func (o *UpstreamPulp) SetTlsValidation(v bool) {
	o.TlsValidation = &v
}

// GetUsername returns the Username field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *UpstreamPulp) GetUsername() string {
	if o == nil || IsNil(o.Username.Get()) {
		var ret string
		return ret
	}
	return *o.Username.Get()
}

// GetUsernameOk returns a tuple with the Username field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *UpstreamPulp) GetUsernameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Username.Get(), o.Username.IsSet()
}

// HasUsername returns a boolean if a field has been set.
func (o *UpstreamPulp) HasUsername() bool {
	if o != nil && o.Username.IsSet() {
		return true
	}

	return false
}

// SetUsername gets a reference to the given NullableString and assigns it to the Username field.
func (o *UpstreamPulp) SetUsername(v string) {
	o.Username.Set(&v)
}
// SetUsernameNil sets the value for Username to be an explicit nil
func (o *UpstreamPulp) SetUsernameNil() {
	o.Username.Set(nil)
}

// UnsetUsername ensures that no value is present for Username, not even an explicit nil
func (o *UpstreamPulp) UnsetUsername() {
	o.Username.Unset()
}

// GetPassword returns the Password field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *UpstreamPulp) GetPassword() string {
	if o == nil || IsNil(o.Password.Get()) {
		var ret string
		return ret
	}
	return *o.Password.Get()
}

// GetPasswordOk returns a tuple with the Password field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *UpstreamPulp) GetPasswordOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Password.Get(), o.Password.IsSet()
}

// HasPassword returns a boolean if a field has been set.
func (o *UpstreamPulp) HasPassword() bool {
	if o != nil && o.Password.IsSet() {
		return true
	}

	return false
}

// SetPassword gets a reference to the given NullableString and assigns it to the Password field.
func (o *UpstreamPulp) SetPassword(v string) {
	o.Password.Set(&v)
}
// SetPasswordNil sets the value for Password to be an explicit nil
func (o *UpstreamPulp) SetPasswordNil() {
	o.Password.Set(nil)
}

// UnsetPassword ensures that no value is present for Password, not even an explicit nil
func (o *UpstreamPulp) UnsetPassword() {
	o.Password.Unset()
}

// GetPulpLabelSelect returns the PulpLabelSelect field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *UpstreamPulp) GetPulpLabelSelect() string {
	if o == nil || IsNil(o.PulpLabelSelect.Get()) {
		var ret string
		return ret
	}
	return *o.PulpLabelSelect.Get()
}

// GetPulpLabelSelectOk returns a tuple with the PulpLabelSelect field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *UpstreamPulp) GetPulpLabelSelectOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.PulpLabelSelect.Get(), o.PulpLabelSelect.IsSet()
}

// HasPulpLabelSelect returns a boolean if a field has been set.
func (o *UpstreamPulp) HasPulpLabelSelect() bool {
	if o != nil && o.PulpLabelSelect.IsSet() {
		return true
	}

	return false
}

// SetPulpLabelSelect gets a reference to the given NullableString and assigns it to the PulpLabelSelect field.
func (o *UpstreamPulp) SetPulpLabelSelect(v string) {
	o.PulpLabelSelect.Set(&v)
}
// SetPulpLabelSelectNil sets the value for PulpLabelSelect to be an explicit nil
func (o *UpstreamPulp) SetPulpLabelSelectNil() {
	o.PulpLabelSelect.Set(nil)
}

// UnsetPulpLabelSelect ensures that no value is present for PulpLabelSelect, not even an explicit nil
func (o *UpstreamPulp) UnsetPulpLabelSelect() {
	o.PulpLabelSelect.Unset()
}

func (o UpstreamPulp) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o UpstreamPulp) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["name"] = o.Name
	toSerialize["base_url"] = o.BaseUrl
	toSerialize["api_root"] = o.ApiRoot
	if o.Domain.IsSet() {
		toSerialize["domain"] = o.Domain.Get()
	}
	if o.CaCert.IsSet() {
		toSerialize["ca_cert"] = o.CaCert.Get()
	}
	if o.ClientCert.IsSet() {
		toSerialize["client_cert"] = o.ClientCert.Get()
	}
	if o.ClientKey.IsSet() {
		toSerialize["client_key"] = o.ClientKey.Get()
	}
	if !IsNil(o.TlsValidation) {
		toSerialize["tls_validation"] = o.TlsValidation
	}
	if o.Username.IsSet() {
		toSerialize["username"] = o.Username.Get()
	}
	if o.Password.IsSet() {
		toSerialize["password"] = o.Password.Get()
	}
	if o.PulpLabelSelect.IsSet() {
		toSerialize["pulp_label_select"] = o.PulpLabelSelect.Get()
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *UpstreamPulp) UnmarshalJSON(bytes []byte) (err error) {
	varUpstreamPulp := _UpstreamPulp{}

	if err = json.Unmarshal(bytes, &varUpstreamPulp); err == nil {
		*o = UpstreamPulp(varUpstreamPulp)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "name")
		delete(additionalProperties, "base_url")
		delete(additionalProperties, "api_root")
		delete(additionalProperties, "domain")
		delete(additionalProperties, "ca_cert")
		delete(additionalProperties, "client_cert")
		delete(additionalProperties, "client_key")
		delete(additionalProperties, "tls_validation")
		delete(additionalProperties, "username")
		delete(additionalProperties, "password")
		delete(additionalProperties, "pulp_label_select")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableUpstreamPulp struct {
	value *UpstreamPulp
	isSet bool
}

func (v NullableUpstreamPulp) Get() *UpstreamPulp {
	return v.value
}

func (v *NullableUpstreamPulp) Set(val *UpstreamPulp) {
	v.value = val
	v.isSet = true
}

func (v NullableUpstreamPulp) IsSet() bool {
	return v.isSet
}

func (v *NullableUpstreamPulp) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableUpstreamPulp(val *UpstreamPulp) *NullableUpstreamPulp {
	return &NullableUpstreamPulp{value: val, isSet: true}
}

func (v NullableUpstreamPulp) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableUpstreamPulp) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


