/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"time"
	"reflect"
)


// TasksAPIService TasksAPI service
type TasksAPIService service

type TasksAPITasksAddRoleRequest struct {
	ctx context.Context
	ApiService *TasksAPIService
	taskHref string
	nestedRole *NestedRole
}

func (r TasksAPITasksAddRoleRequest) NestedRole(nestedRole NestedRole) TasksAPITasksAddRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r TasksAPITasksAddRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.TasksAddRoleExecute(r)
}

/*
TasksAddRole Method for TasksAddRole

Add a role for this object to users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param taskHref
 @return TasksAPITasksAddRoleRequest
*/
func (a *TasksAPIService) TasksAddRole(ctx context.Context, taskHref string) TasksAPITasksAddRoleRequest {
	return TasksAPITasksAddRoleRequest{
		ApiService: a,
		ctx: ctx,
		taskHref: taskHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *TasksAPIService) TasksAddRoleExecute(r TasksAPITasksAddRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "TasksAPIService.TasksAddRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{task_href}add_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"task_href"+"}", parameterValueToString(r.taskHref, "taskHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type TasksAPITasksCancelRequest struct {
	ctx context.Context
	ApiService *TasksAPIService
	taskHref string
	patchedTaskCancel *PatchedTaskCancel
}

func (r TasksAPITasksCancelRequest) PatchedTaskCancel(patchedTaskCancel PatchedTaskCancel) TasksAPITasksCancelRequest {
	r.patchedTaskCancel = &patchedTaskCancel
	return r
}

func (r TasksAPITasksCancelRequest) Execute() (*TaskResponse, *http.Response, error) {
	return r.ApiService.TasksCancelExecute(r)
}

/*
TasksCancel Cancel a task

This operation cancels a task.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param taskHref
 @return TasksAPITasksCancelRequest
*/
func (a *TasksAPIService) TasksCancel(ctx context.Context, taskHref string) TasksAPITasksCancelRequest {
	return TasksAPITasksCancelRequest{
		ApiService: a,
		ctx: ctx,
		taskHref: taskHref,
	}
}

// Execute executes the request
//  @return TaskResponse
func (a *TasksAPIService) TasksCancelExecute(r TasksAPITasksCancelRequest) (*TaskResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *TaskResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "TasksAPIService.TasksCancel")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{task_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"task_href"+"}", parameterValueToString(r.taskHref, "taskHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.patchedTaskCancel == nil {
		return localVarReturnValue, nil, reportError("patchedTaskCancel is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.patchedTaskCancel
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 409 {
			var v TaskResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
					newErr.error = formatErrorMessage(localVarHTTPResponse.Status, &v)
					newErr.model = v
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type TasksAPITasksDeleteRequest struct {
	ctx context.Context
	ApiService *TasksAPIService
	taskHref string
}

func (r TasksAPITasksDeleteRequest) Execute() (*http.Response, error) {
	return r.ApiService.TasksDeleteExecute(r)
}

/*
TasksDelete Delete a task

A customized named ModelViewSet that knows how to register itself with the Pulp API router.

This viewset is discoverable by its name.
"Normal" Django Models and Master/Detail models are supported by the ``register_with`` method.

Attributes:
    lookup_field (str): The name of the field by which an object should be looked up, in
        addition to any parent lookups if this ViewSet is nested. Defaults to 'pk'
    endpoint_name (str): The name of the final path segment that should identify the ViewSet's
        collection endpoint.
    nest_prefix (str): Optional prefix under which this ViewSet should be nested. This must
        correspond to the "parent_prefix" of a router with rest_framework_nested.NestedMixin.
        None indicates this ViewSet should not be nested.
    parent_lookup_kwargs (dict): Optional mapping of key names that would appear in self.kwargs
        to django model filter expressions that can be used with the corresponding value from
        self.kwargs, used only by a nested ViewSet to filter based on the parent object's
        identity.
    schema (DefaultSchema): The schema class to use by default in a viewset.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param taskHref
 @return TasksAPITasksDeleteRequest
*/
func (a *TasksAPIService) TasksDelete(ctx context.Context, taskHref string) TasksAPITasksDeleteRequest {
	return TasksAPITasksDeleteRequest{
		ApiService: a,
		ctx: ctx,
		taskHref: taskHref,
	}
}

// Execute executes the request
func (a *TasksAPIService) TasksDeleteExecute(r TasksAPITasksDeleteRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "TasksAPIService.TasksDelete")
	if err != nil {
		return nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{task_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"task_href"+"}", parameterValueToString(r.taskHref, "taskHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type TasksAPITasksListRequest struct {
	ctx context.Context
	ApiService *TasksAPIService
	childTasks *string
	createdResources *string
	exclusiveResources *string
	exclusiveResourcesIn *[]string
	finishedAt *time.Time
	finishedAtGt *time.Time
	finishedAtGte *time.Time
	finishedAtLt *time.Time
	finishedAtLte *time.Time
	finishedAtRange *[]time.Time
	limit *int32
	loggingCid *string
	loggingCidContains *string
	name *string
	nameContains *string
	nameIn *[]string
	offset *int32
	ordering *[]string
	parentTask *string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	reservedResources *string
	reservedResourcesIn *[]string
	reservedResourcesRecord *[]string
	sharedResources *string
	sharedResourcesIn *[]string
	startedAt *time.Time
	startedAtGt *time.Time
	startedAtGte *time.Time
	startedAtLt *time.Time
	startedAtLte *time.Time
	startedAtRange *[]time.Time
	state *string
	stateIn *[]string
	taskGroup *string
	worker *string
	workerIn *[]string
	fields *[]string
	excludeFields *[]string
}

// Filter results where child_tasks matches value
func (r TasksAPITasksListRequest) ChildTasks(childTasks string) TasksAPITasksListRequest {
	r.childTasks = &childTasks
	return r
}

func (r TasksAPITasksListRequest) CreatedResources(createdResources string) TasksAPITasksListRequest {
	r.createdResources = &createdResources
	return r
}

func (r TasksAPITasksListRequest) ExclusiveResources(exclusiveResources string) TasksAPITasksListRequest {
	r.exclusiveResources = &exclusiveResources
	return r
}

// Multiple values may be separated by commas.
func (r TasksAPITasksListRequest) ExclusiveResourcesIn(exclusiveResourcesIn []string) TasksAPITasksListRequest {
	r.exclusiveResourcesIn = &exclusiveResourcesIn
	return r
}

// Filter results where finished_at matches value
func (r TasksAPITasksListRequest) FinishedAt(finishedAt time.Time) TasksAPITasksListRequest {
	r.finishedAt = &finishedAt
	return r
}

// Filter results where finished_at is greater than value
func (r TasksAPITasksListRequest) FinishedAtGt(finishedAtGt time.Time) TasksAPITasksListRequest {
	r.finishedAtGt = &finishedAtGt
	return r
}

// Filter results where finished_at is greater than or equal to value
func (r TasksAPITasksListRequest) FinishedAtGte(finishedAtGte time.Time) TasksAPITasksListRequest {
	r.finishedAtGte = &finishedAtGte
	return r
}

// Filter results where finished_at is less than value
func (r TasksAPITasksListRequest) FinishedAtLt(finishedAtLt time.Time) TasksAPITasksListRequest {
	r.finishedAtLt = &finishedAtLt
	return r
}

// Filter results where finished_at is less than or equal to value
func (r TasksAPITasksListRequest) FinishedAtLte(finishedAtLte time.Time) TasksAPITasksListRequest {
	r.finishedAtLte = &finishedAtLte
	return r
}

// Filter results where finished_at is between two comma separated values
func (r TasksAPITasksListRequest) FinishedAtRange(finishedAtRange []time.Time) TasksAPITasksListRequest {
	r.finishedAtRange = &finishedAtRange
	return r
}

// Number of results to return per page.
func (r TasksAPITasksListRequest) Limit(limit int32) TasksAPITasksListRequest {
	r.limit = &limit
	return r
}

// Filter results where logging_cid matches value
func (r TasksAPITasksListRequest) LoggingCid(loggingCid string) TasksAPITasksListRequest {
	r.loggingCid = &loggingCid
	return r
}

// Filter results where logging_cid contains value
func (r TasksAPITasksListRequest) LoggingCidContains(loggingCidContains string) TasksAPITasksListRequest {
	r.loggingCidContains = &loggingCidContains
	return r
}

// Filter results where name matches value
func (r TasksAPITasksListRequest) Name(name string) TasksAPITasksListRequest {
	r.name = &name
	return r
}

// Filter results where name contains value
func (r TasksAPITasksListRequest) NameContains(nameContains string) TasksAPITasksListRequest {
	r.nameContains = &nameContains
	return r
}

// Filter results where name is in a comma-separated list of values
func (r TasksAPITasksListRequest) NameIn(nameIn []string) TasksAPITasksListRequest {
	r.nameIn = &nameIn
	return r
}

// The initial index from which to return the results.
func (r TasksAPITasksListRequest) Offset(offset int32) TasksAPITasksListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;state&#x60; - State * &#x60;-state&#x60; - State (descending) * &#x60;name&#x60; - Name * &#x60;-name&#x60; - Name (descending) * &#x60;logging_cid&#x60; - Logging cid * &#x60;-logging_cid&#x60; - Logging cid (descending) * &#x60;started_at&#x60; - Started at * &#x60;-started_at&#x60; - Started at (descending) * &#x60;finished_at&#x60; - Finished at * &#x60;-finished_at&#x60; - Finished at (descending) * &#x60;error&#x60; - Error * &#x60;-error&#x60; - Error (descending) * &#x60;args&#x60; - Args * &#x60;-args&#x60; - Args (descending) * &#x60;kwargs&#x60; - Kwargs * &#x60;-kwargs&#x60; - Kwargs (descending) * &#x60;reserved_resources_record&#x60; - Reserved resources record * &#x60;-reserved_resources_record&#x60; - Reserved resources record (descending) * &#x60;versions&#x60; - Versions * &#x60;-versions&#x60; - Versions (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r TasksAPITasksListRequest) Ordering(ordering []string) TasksAPITasksListRequest {
	r.ordering = &ordering
	return r
}

// Filter results where parent_task matches value
func (r TasksAPITasksListRequest) ParentTask(parentTask string) TasksAPITasksListRequest {
	r.parentTask = &parentTask
	return r
}

// Multiple values may be separated by commas.
func (r TasksAPITasksListRequest) PulpHrefIn(pulpHrefIn []string) TasksAPITasksListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r TasksAPITasksListRequest) PulpIdIn(pulpIdIn []string) TasksAPITasksListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

func (r TasksAPITasksListRequest) ReservedResources(reservedResources string) TasksAPITasksListRequest {
	r.reservedResources = &reservedResources
	return r
}

// Multiple values may be separated by commas.
func (r TasksAPITasksListRequest) ReservedResourcesIn(reservedResourcesIn []string) TasksAPITasksListRequest {
	r.reservedResourcesIn = &reservedResourcesIn
	return r
}

func (r TasksAPITasksListRequest) ReservedResourcesRecord(reservedResourcesRecord []string) TasksAPITasksListRequest {
	r.reservedResourcesRecord = &reservedResourcesRecord
	return r
}

func (r TasksAPITasksListRequest) SharedResources(sharedResources string) TasksAPITasksListRequest {
	r.sharedResources = &sharedResources
	return r
}

// Multiple values may be separated by commas.
func (r TasksAPITasksListRequest) SharedResourcesIn(sharedResourcesIn []string) TasksAPITasksListRequest {
	r.sharedResourcesIn = &sharedResourcesIn
	return r
}

// Filter results where started_at matches value
func (r TasksAPITasksListRequest) StartedAt(startedAt time.Time) TasksAPITasksListRequest {
	r.startedAt = &startedAt
	return r
}

// Filter results where started_at is greater than value
func (r TasksAPITasksListRequest) StartedAtGt(startedAtGt time.Time) TasksAPITasksListRequest {
	r.startedAtGt = &startedAtGt
	return r
}

// Filter results where started_at is greater than or equal to value
func (r TasksAPITasksListRequest) StartedAtGte(startedAtGte time.Time) TasksAPITasksListRequest {
	r.startedAtGte = &startedAtGte
	return r
}

// Filter results where started_at is less than value
func (r TasksAPITasksListRequest) StartedAtLt(startedAtLt time.Time) TasksAPITasksListRequest {
	r.startedAtLt = &startedAtLt
	return r
}

// Filter results where started_at is less than or equal to value
func (r TasksAPITasksListRequest) StartedAtLte(startedAtLte time.Time) TasksAPITasksListRequest {
	r.startedAtLte = &startedAtLte
	return r
}

// Filter results where started_at is between two comma separated values
func (r TasksAPITasksListRequest) StartedAtRange(startedAtRange []time.Time) TasksAPITasksListRequest {
	r.startedAtRange = &startedAtRange
	return r
}

// Filter results where state matches value  * &#x60;waiting&#x60; - Waiting * &#x60;skipped&#x60; - Skipped * &#x60;running&#x60; - Running * &#x60;completed&#x60; - Completed * &#x60;failed&#x60; - Failed * &#x60;canceled&#x60; - Canceled * &#x60;canceling&#x60; - Canceling
func (r TasksAPITasksListRequest) State(state string) TasksAPITasksListRequest {
	r.state = &state
	return r
}

// Filter results where state is in a comma-separated list of values
func (r TasksAPITasksListRequest) StateIn(stateIn []string) TasksAPITasksListRequest {
	r.stateIn = &stateIn
	return r
}

// Filter results where task_group matches value
func (r TasksAPITasksListRequest) TaskGroup(taskGroup string) TasksAPITasksListRequest {
	r.taskGroup = &taskGroup
	return r
}

// Filter results where worker matches value
func (r TasksAPITasksListRequest) Worker(worker string) TasksAPITasksListRequest {
	r.worker = &worker
	return r
}

// Filter results where worker is in a comma-separated list of values
func (r TasksAPITasksListRequest) WorkerIn(workerIn []string) TasksAPITasksListRequest {
	r.workerIn = &workerIn
	return r
}

// A list of fields to include in the response.
func (r TasksAPITasksListRequest) Fields(fields []string) TasksAPITasksListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r TasksAPITasksListRequest) ExcludeFields(excludeFields []string) TasksAPITasksListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r TasksAPITasksListRequest) Execute() (*PaginatedTaskResponseList, *http.Response, error) {
	return r.ApiService.TasksListExecute(r)
}

/*
TasksList List tasks

A customized named ModelViewSet that knows how to register itself with the Pulp API router.

This viewset is discoverable by its name.
"Normal" Django Models and Master/Detail models are supported by the ``register_with`` method.

Attributes:
    lookup_field (str): The name of the field by which an object should be looked up, in
        addition to any parent lookups if this ViewSet is nested. Defaults to 'pk'
    endpoint_name (str): The name of the final path segment that should identify the ViewSet's
        collection endpoint.
    nest_prefix (str): Optional prefix under which this ViewSet should be nested. This must
        correspond to the "parent_prefix" of a router with rest_framework_nested.NestedMixin.
        None indicates this ViewSet should not be nested.
    parent_lookup_kwargs (dict): Optional mapping of key names that would appear in self.kwargs
        to django model filter expressions that can be used with the corresponding value from
        self.kwargs, used only by a nested ViewSet to filter based on the parent object's
        identity.
    schema (DefaultSchema): The schema class to use by default in a viewset.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return TasksAPITasksListRequest
*/
func (a *TasksAPIService) TasksList(ctx context.Context) TasksAPITasksListRequest {
	return TasksAPITasksListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedTaskResponseList
func (a *TasksAPIService) TasksListExecute(r TasksAPITasksListRequest) (*PaginatedTaskResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedTaskResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "TasksAPIService.TasksList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/tasks/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.childTasks != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "child_tasks", r.childTasks, "")
	}
	if r.createdResources != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "created_resources", r.createdResources, "")
	}
	if r.exclusiveResources != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "exclusive_resources", r.exclusiveResources, "")
	}
	if r.exclusiveResourcesIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "exclusive_resources__in", r.exclusiveResourcesIn, "csv")
	}
	if r.finishedAt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "finished_at", r.finishedAt, "")
	}
	if r.finishedAtGt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "finished_at__gt", r.finishedAtGt, "")
	}
	if r.finishedAtGte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "finished_at__gte", r.finishedAtGte, "")
	}
	if r.finishedAtLt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "finished_at__lt", r.finishedAtLt, "")
	}
	if r.finishedAtLte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "finished_at__lte", r.finishedAtLte, "")
	}
	if r.finishedAtRange != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "finished_at__range", r.finishedAtRange, "csv")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.loggingCid != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "logging_cid", r.loggingCid, "")
	}
	if r.loggingCidContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "logging_cid__contains", r.loggingCidContains, "")
	}
	if r.name != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name, "")
	}
	if r.nameContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__contains", r.nameContains, "")
	}
	if r.nameIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__in", r.nameIn, "csv")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.parentTask != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "parent_task", r.parentTask, "")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.reservedResources != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "reserved_resources", r.reservedResources, "")
	}
	if r.reservedResourcesIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "reserved_resources__in", r.reservedResourcesIn, "csv")
	}
	if r.reservedResourcesRecord != nil {
		t := *r.reservedResourcesRecord
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "reserved_resources_record", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "reserved_resources_record", t, "multi")
		}
	}
	if r.sharedResources != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "shared_resources", r.sharedResources, "")
	}
	if r.sharedResourcesIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "shared_resources__in", r.sharedResourcesIn, "csv")
	}
	if r.startedAt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "started_at", r.startedAt, "")
	}
	if r.startedAtGt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "started_at__gt", r.startedAtGt, "")
	}
	if r.startedAtGte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "started_at__gte", r.startedAtGte, "")
	}
	if r.startedAtLt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "started_at__lt", r.startedAtLt, "")
	}
	if r.startedAtLte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "started_at__lte", r.startedAtLte, "")
	}
	if r.startedAtRange != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "started_at__range", r.startedAtRange, "csv")
	}
	if r.state != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "state", r.state, "")
	}
	if r.stateIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "state__in", r.stateIn, "csv")
	}
	if r.taskGroup != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "task_group", r.taskGroup, "")
	}
	if r.worker != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "worker", r.worker, "")
	}
	if r.workerIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "worker__in", r.workerIn, "csv")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type TasksAPITasksListRolesRequest struct {
	ctx context.Context
	ApiService *TasksAPIService
	taskHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r TasksAPITasksListRolesRequest) Fields(fields []string) TasksAPITasksListRolesRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r TasksAPITasksListRolesRequest) ExcludeFields(excludeFields []string) TasksAPITasksListRolesRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r TasksAPITasksListRolesRequest) Execute() (*ObjectRolesResponse, *http.Response, error) {
	return r.ApiService.TasksListRolesExecute(r)
}

/*
TasksListRoles Method for TasksListRoles

List roles assigned to this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param taskHref
 @return TasksAPITasksListRolesRequest
*/
func (a *TasksAPIService) TasksListRoles(ctx context.Context, taskHref string) TasksAPITasksListRolesRequest {
	return TasksAPITasksListRolesRequest{
		ApiService: a,
		ctx: ctx,
		taskHref: taskHref,
	}
}

// Execute executes the request
//  @return ObjectRolesResponse
func (a *TasksAPIService) TasksListRolesExecute(r TasksAPITasksListRolesRequest) (*ObjectRolesResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ObjectRolesResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "TasksAPIService.TasksListRoles")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{task_href}list_roles/"
	localVarPath = strings.Replace(localVarPath, "{"+"task_href"+"}", parameterValueToString(r.taskHref, "taskHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type TasksAPITasksMyPermissionsRequest struct {
	ctx context.Context
	ApiService *TasksAPIService
	taskHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r TasksAPITasksMyPermissionsRequest) Fields(fields []string) TasksAPITasksMyPermissionsRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r TasksAPITasksMyPermissionsRequest) ExcludeFields(excludeFields []string) TasksAPITasksMyPermissionsRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r TasksAPITasksMyPermissionsRequest) Execute() (*MyPermissionsResponse, *http.Response, error) {
	return r.ApiService.TasksMyPermissionsExecute(r)
}

/*
TasksMyPermissions Method for TasksMyPermissions

List permissions available to the current user on this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param taskHref
 @return TasksAPITasksMyPermissionsRequest
*/
func (a *TasksAPIService) TasksMyPermissions(ctx context.Context, taskHref string) TasksAPITasksMyPermissionsRequest {
	return TasksAPITasksMyPermissionsRequest{
		ApiService: a,
		ctx: ctx,
		taskHref: taskHref,
	}
}

// Execute executes the request
//  @return MyPermissionsResponse
func (a *TasksAPIService) TasksMyPermissionsExecute(r TasksAPITasksMyPermissionsRequest) (*MyPermissionsResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *MyPermissionsResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "TasksAPIService.TasksMyPermissions")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{task_href}my_permissions/"
	localVarPath = strings.Replace(localVarPath, "{"+"task_href"+"}", parameterValueToString(r.taskHref, "taskHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type TasksAPITasksPurgeRequest struct {
	ctx context.Context
	ApiService *TasksAPIService
	purge *Purge
}

func (r TasksAPITasksPurgeRequest) Purge(purge Purge) TasksAPITasksPurgeRequest {
	r.purge = &purge
	return r
}

func (r TasksAPITasksPurgeRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.TasksPurgeExecute(r)
}

/*
TasksPurge Purge Completed Tasks

Trigger an asynchronous task that deletes completed tasks that finished prior to a specified timestamp.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return TasksAPITasksPurgeRequest
*/
func (a *TasksAPIService) TasksPurge(ctx context.Context) TasksAPITasksPurgeRequest {
	return TasksAPITasksPurgeRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *TasksAPIService) TasksPurgeExecute(r TasksAPITasksPurgeRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "TasksAPIService.TasksPurge")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/tasks/purge/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.purge == nil {
		return localVarReturnValue, nil, reportError("purge is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.purge
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type TasksAPITasksReadRequest struct {
	ctx context.Context
	ApiService *TasksAPIService
	taskHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r TasksAPITasksReadRequest) Fields(fields []string) TasksAPITasksReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r TasksAPITasksReadRequest) ExcludeFields(excludeFields []string) TasksAPITasksReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r TasksAPITasksReadRequest) Execute() (*TaskResponse, *http.Response, error) {
	return r.ApiService.TasksReadExecute(r)
}

/*
TasksRead Inspect a task

A customized named ModelViewSet that knows how to register itself with the Pulp API router.

This viewset is discoverable by its name.
"Normal" Django Models and Master/Detail models are supported by the ``register_with`` method.

Attributes:
    lookup_field (str): The name of the field by which an object should be looked up, in
        addition to any parent lookups if this ViewSet is nested. Defaults to 'pk'
    endpoint_name (str): The name of the final path segment that should identify the ViewSet's
        collection endpoint.
    nest_prefix (str): Optional prefix under which this ViewSet should be nested. This must
        correspond to the "parent_prefix" of a router with rest_framework_nested.NestedMixin.
        None indicates this ViewSet should not be nested.
    parent_lookup_kwargs (dict): Optional mapping of key names that would appear in self.kwargs
        to django model filter expressions that can be used with the corresponding value from
        self.kwargs, used only by a nested ViewSet to filter based on the parent object's
        identity.
    schema (DefaultSchema): The schema class to use by default in a viewset.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param taskHref
 @return TasksAPITasksReadRequest
*/
func (a *TasksAPIService) TasksRead(ctx context.Context, taskHref string) TasksAPITasksReadRequest {
	return TasksAPITasksReadRequest{
		ApiService: a,
		ctx: ctx,
		taskHref: taskHref,
	}
}

// Execute executes the request
//  @return TaskResponse
func (a *TasksAPIService) TasksReadExecute(r TasksAPITasksReadRequest) (*TaskResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *TaskResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "TasksAPIService.TasksRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{task_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"task_href"+"}", parameterValueToString(r.taskHref, "taskHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type TasksAPITasksRemoveRoleRequest struct {
	ctx context.Context
	ApiService *TasksAPIService
	taskHref string
	nestedRole *NestedRole
}

func (r TasksAPITasksRemoveRoleRequest) NestedRole(nestedRole NestedRole) TasksAPITasksRemoveRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r TasksAPITasksRemoveRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.TasksRemoveRoleExecute(r)
}

/*
TasksRemoveRole Method for TasksRemoveRole

Remove a role for this object from users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param taskHref
 @return TasksAPITasksRemoveRoleRequest
*/
func (a *TasksAPIService) TasksRemoveRole(ctx context.Context, taskHref string) TasksAPITasksRemoveRoleRequest {
	return TasksAPITasksRemoveRoleRequest{
		ApiService: a,
		ctx: ctx,
		taskHref: taskHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *TasksAPIService) TasksRemoveRoleExecute(r TasksAPITasksRemoveRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "TasksAPIService.TasksRemoveRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{task_href}remove_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"task_href"+"}", parameterValueToString(r.taskHref, "taskHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
