/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.GeneralName;
import org.mozilla.jss.netscape.security.x509.GeneralNameInterface;
import org.mozilla.jss.netscape.security.x509.GeneralNamesException;

public class GeneralNames
extends Vector<GeneralNameInterface> {
    private static final long serialVersionUID = 3204492869396713312L;

    public GeneralNames(DerValue derVal) throws IOException, GeneralNamesException {
        if (derVal.tag != 48) {
            throw new IOException("Invalid encoding for GeneralNames.");
        }
        if (derVal.data.available() == 0) {
            throw new GeneralNamesException("No data available in passed DER encoded value.");
        }
        while (derVal.data.available() != 0) {
            DerValue encName = derVal.data.getDerValue();
            GeneralName name = new GeneralName(encName);
            this.addElement(name);
        }
    }

    public GeneralNames(GeneralNameInterface[] names) throws GeneralNamesException {
        if (names == null || names.length == 0) {
            throw new GeneralNamesException("Cannot create empty GeneralNames");
        }
        for (int i = 0; i < names.length; ++i) {
            this.addElement(names[i]);
        }
    }

    public GeneralNames() {
        super(1, 1);
    }

    public void encode(DerOutputStream out) throws IOException, GeneralNamesException {
        if (this.size() == 0) {
            return;
        }
        Enumeration names = this.elements();
        DerOutputStream temp = new DerOutputStream();
        while (names.hasMoreElements()) {
            Object obj = names.nextElement();
            if (!(obj instanceof GeneralNameInterface)) {
                throw new GeneralNamesException("Element in GeneralNames not of type GeneralName.");
            }
            GeneralNameInterface intf = (GeneralNameInterface)obj;
            if (obj instanceof GeneralName) {
                intf.encode(temp);
                continue;
            }
            DerOutputStream gname = new DerOutputStream();
            intf.encode(gname);
            int nameType = intf.getType();
            if (nameType == 0 || nameType == 3 || nameType == 5) {
                temp.writeImplicit(DerValue.createTag((byte)-128, true, (byte)nameType), gname);
                continue;
            }
            if (nameType == 4) {
                temp.write(DerValue.createTag((byte)-128, true, (byte)nameType), gname);
                continue;
            }
            temp.writeImplicit(DerValue.createTag((byte)-128, false, (byte)nameType), gname);
        }
        out.write((byte)48, temp);
    }
}

