/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs7;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkcs7.IssuerAndSerialNumber;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;

public class RecipientInfo
implements ASN1Value {
    public static final Tag TAG = SEQUENCE.TAG;
    private INTEGER version;
    private IssuerAndSerialNumber issuerAndSerialNumber;
    private AlgorithmIdentifier keyEncryptionAlgorithmID;
    private OCTET_STRING encryptedKey;
    private SEQUENCE sequence = new SEQUENCE();
    private static final Template templateInstance = new Template();

    @Override
    public Tag getTag() {
        return TAG;
    }

    public INTEGER getVersion() {
        return this.version;
    }

    public IssuerAndSerialNumber getissuerAndSerialNumber() {
        return this.issuerAndSerialNumber;
    }

    public AlgorithmIdentifier getKeyEncryptionAlgorithmID() {
        return this.keyEncryptionAlgorithmID;
    }

    public OCTET_STRING getEncryptedKey() {
        return this.encryptedKey;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public RecipientInfo(INTEGER version, IssuerAndSerialNumber issuerAndSerialNumber, AlgorithmIdentifier keyEncryptionAlgorithmID, OCTET_STRING encryptedKey) {
        assert (issuerAndSerialNumber != null);
        assert (keyEncryptionAlgorithmID != null);
        assert (encryptedKey != null);
        this.version = version;
        this.issuerAndSerialNumber = issuerAndSerialNumber;
        this.keyEncryptionAlgorithmID = keyEncryptionAlgorithmID;
        this.encryptedKey = encryptedKey;
        this.sequence.addElement(version);
        this.sequence.addElement(issuerAndSerialNumber);
        this.sequence.addElement(keyEncryptionAlgorithmID);
        this.sequence.addElement(encryptedKey);
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    @Override
    public void encode(Tag tag, OutputStream ostream) throws IOException {
        this.sequence.encode(tag, ostream);
    }

    public static class Template
    implements ASN1Template {
        public Tag getTag() {
            return TAG;
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return tag.equals(TAG);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(this.getTag(), istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE.Template seqt = new SEQUENCE.Template();
            seqt.addElement(new INTEGER.Template());
            seqt.addElement(new IssuerAndSerialNumber.Template());
            seqt.addElement(new AlgorithmIdentifier.Template());
            seqt.addElement(new OCTET_STRING.Template());
            SEQUENCE seq = (SEQUENCE)seqt.decode(implicitTag, istream);
            assert (seq.size() == 4);
            return new RecipientInfo((INTEGER)seq.elementAt(0), (IssuerAndSerialNumber)seq.elementAt(1), (AlgorithmIdentifier)seq.elementAt(2), (OCTET_STRING)seq.elementAt(3));
        }
    }
}

