/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.BitArray;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;

public class ReasonFlags {
    public static final String UNUSED = "unused";
    public static final String KEY_COMPROMISE = "key_compromise";
    public static final String CA_COMPROMISE = "ca_compromise";
    public static final String AFFLIATION_CHANGED = "affliation_changed";
    public static final String SUPERSEDED = "superseded";
    public static final String CESSATION_OF_OPERATION = "cessation_of_operation";
    public static final String CERTIFICATION_HOLD = "certification_hold";
    public static final String PRIVILEGE_WITHDRAWN = "privilege_withdrawn";
    public static final String AA_COMPROMISE = "aa_compromise";
    private boolean[] bitString;

    private boolean isSet(int position) {
        return this.bitString[position];
    }

    private void set(int position, boolean val) {
        if (position >= this.bitString.length) {
            boolean[] tmp = new boolean[position + 1];
            System.arraycopy(this.bitString, 0, tmp, 0, this.bitString.length);
            this.bitString = tmp;
        }
        this.bitString[position] = val;
    }

    public ReasonFlags(byte[] reasons) {
        this.bitString = new BitArray(reasons.length * 8, reasons).toBooleanArray();
    }

    public ReasonFlags(boolean[] reasons) {
        this.bitString = reasons;
    }

    public ReasonFlags(BitArray reasons) {
        this.bitString = reasons.toBooleanArray();
    }

    public ReasonFlags(DerInputStream in) throws IOException {
        DerValue derVal = in.getDerValue();
        this.bitString = derVal.getUnalignedBitString(true).toBooleanArray();
    }

    public ReasonFlags(DerValue derVal) throws IOException {
        this.bitString = derVal.getUnalignedBitString(true).toBooleanArray();
    }

    public void set(String name, Object obj) throws IOException {
        if (!(obj instanceof Boolean)) {
            throw new IOException("Attribute must be of type Boolean.");
        }
        boolean val = (Boolean)obj;
        if (name.equalsIgnoreCase(UNUSED)) {
            this.set(0, val);
        } else if (name.equalsIgnoreCase(KEY_COMPROMISE)) {
            this.set(1, val);
        } else if (name.equalsIgnoreCase(CA_COMPROMISE)) {
            this.set(2, val);
        } else if (name.equalsIgnoreCase(AFFLIATION_CHANGED)) {
            this.set(3, val);
        } else if (name.equalsIgnoreCase(SUPERSEDED)) {
            this.set(4, val);
        } else if (name.equalsIgnoreCase(CESSATION_OF_OPERATION)) {
            this.set(5, val);
        } else if (name.equalsIgnoreCase(CERTIFICATION_HOLD)) {
            this.set(6, val);
        } else if (name.equalsIgnoreCase(PRIVILEGE_WITHDRAWN)) {
            this.set(7, val);
        } else if (name.equalsIgnoreCase(AA_COMPROMISE)) {
            this.set(8, val);
        } else {
            throw new IOException("Name not recognized by ReasonFlags");
        }
    }

    public Object get(String name) throws IOException {
        if (name.equalsIgnoreCase(UNUSED)) {
            return this.isSet(0);
        }
        if (name.equalsIgnoreCase(KEY_COMPROMISE)) {
            return this.isSet(1);
        }
        if (name.equalsIgnoreCase(CA_COMPROMISE)) {
            return this.isSet(2);
        }
        if (name.equalsIgnoreCase(AFFLIATION_CHANGED)) {
            return this.isSet(3);
        }
        if (name.equalsIgnoreCase(SUPERSEDED)) {
            return this.isSet(4);
        }
        if (name.equalsIgnoreCase(CESSATION_OF_OPERATION)) {
            return this.isSet(5);
        }
        if (name.equalsIgnoreCase(CERTIFICATION_HOLD)) {
            return this.isSet(6);
        }
        if (name.equalsIgnoreCase(PRIVILEGE_WITHDRAWN)) {
            return this.isSet(7);
        }
        if (name.equalsIgnoreCase(AA_COMPROMISE)) {
            return this.isSet(8);
        }
        throw new IOException("Name not recognized by ReasonFlags");
    }

    public void delete(String name) throws IOException {
        if (name.equalsIgnoreCase(UNUSED)) {
            this.set(0, false);
        } else if (name.equalsIgnoreCase(KEY_COMPROMISE)) {
            this.set(1, false);
        } else if (name.equalsIgnoreCase(CA_COMPROMISE)) {
            this.set(2, false);
        } else if (name.equalsIgnoreCase(AFFLIATION_CHANGED)) {
            this.set(3, false);
        } else if (name.equalsIgnoreCase(SUPERSEDED)) {
            this.set(4, false);
        } else if (name.equalsIgnoreCase(CESSATION_OF_OPERATION)) {
            this.set(5, false);
        } else if (name.equalsIgnoreCase(CERTIFICATION_HOLD)) {
            this.set(6, false);
        } else if (name.equalsIgnoreCase(PRIVILEGE_WITHDRAWN)) {
            this.set(7, false);
        } else if (name.equalsIgnoreCase(AA_COMPROMISE)) {
            this.set(8, false);
        } else {
            throw new IOException("Name not recognized by ReasonFlags");
        }
    }

    public String toString() {
        String s = super.toString() + "Reason Flags [\n";
        try {
            if (this.isSet(0)) {
                s = s + "  Unused\n";
            }
            if (this.isSet(1)) {
                s = s + "  Key Compromise\n";
            }
            if (this.isSet(2)) {
                s = s + "  CA_Compromise\n";
            }
            if (this.isSet(3)) {
                s = s + "  Affiliation_Changed\n";
            }
            if (this.isSet(4)) {
                s = s + "  Superseded\n";
            }
            if (this.isSet(5)) {
                s = s + "  Cessation Of Operation\n";
            }
            if (this.isSet(6)) {
                s = s + "  Certificate Hold\n";
            }
            if (this.isSet(7)) {
                s = s + "  Privilege Withdrawn\n";
            }
            if (this.isSet(8)) {
                s = s + "  AA Compromise\n";
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        s = s + "]\n";
        return s;
    }

    public void encode(DerOutputStream out) throws IOException {
        out.putUnalignedBitString(new BitArray(this.bitString));
    }

    public Enumeration<String> getElements() {
        Vector<String> elements = new Vector<String>();
        elements.addElement(UNUSED);
        elements.addElement(KEY_COMPROMISE);
        elements.addElement(CA_COMPROMISE);
        elements.addElement(AFFLIATION_CHANGED);
        elements.addElement(SUPERSEDED);
        elements.addElement(CESSATION_OF_OPERATION);
        elements.addElement(CERTIFICATION_HOLD);
        elements.addElement(PRIVILEGE_WITHDRAWN);
        elements.addElement(AA_COMPROMISE);
        return elements.elements();
    }
}

