/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.util.CryptoHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadLocalSecureRandom;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.Destroyable;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AES256EncodedPasswordSecretKey
implements Serializable {
    private static final long serialVersionUID = -5993762526459847323L;
    @NotNull
    private final AtomicReference<SecretKey> secretKeyRef;
    @NotNull
    private final byte[] encryptionSettingsDefinitionID;
    @NotNull
    private final byte[] keyFactorySalt;

    private AES256EncodedPasswordSecretKey(@NotNull byte[] encryptionSettingsDefinitionID, @NotNull byte[] keyFactorySalt, @NotNull SecretKey secretKey) {
        this.encryptionSettingsDefinitionID = encryptionSettingsDefinitionID;
        this.keyFactorySalt = keyFactorySalt;
        this.secretKeyRef = new AtomicReference<SecretKey>(secretKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static AES256EncodedPasswordSecretKey generate(@NotNull String encryptionSettingsDefinitionID, @NotNull String encryptionSettingsDefinitionPassphrase) throws GeneralSecurityException, ParseException {
        char[] passphraseChars = encryptionSettingsDefinitionPassphrase.toCharArray();
        try {
            AES256EncodedPasswordSecretKey aES256EncodedPasswordSecretKey = AES256EncodedPasswordSecretKey.generate(StaticUtils.fromHex(encryptionSettingsDefinitionID), passphraseChars);
            return aES256EncodedPasswordSecretKey;
        }
        finally {
            Arrays.fill(passphraseChars, '\u0000');
        }
    }

    @NotNull
    public static AES256EncodedPasswordSecretKey generate(@NotNull byte[] encryptionSettingsDefinitionID, @NotNull char[] encryptionSettingsDefinitionPassphrase) throws GeneralSecurityException {
        byte[] keyFactorySalt = new byte[16];
        ThreadLocalSecureRandom.get().nextBytes(keyFactorySalt);
        return AES256EncodedPasswordSecretKey.generate(encryptionSettingsDefinitionID, encryptionSettingsDefinitionPassphrase, keyFactorySalt);
    }

    @NotNull
    public static AES256EncodedPasswordSecretKey generate(@NotNull byte[] encryptionSettingsDefinitionID, @NotNull char[] encryptionSettingsDefinitionPassphrase, @NotNull byte[] keyFactorySalt) throws GeneralSecurityException {
        Validator.ensureNotNullOrEmpty(encryptionSettingsDefinitionID, "AES256EncodedPasswordSecretKey.encryptionSettingsDefinitionID must not be null or empty.");
        Validator.ensureTrue(encryptionSettingsDefinitionID.length <= 255, "AES256EncodedPasswordSecretKey.encryptionSettingsDefinitionID must have a length that is between 1 and 255 bytes, inclusive.");
        Validator.ensureNotNullOrEmpty(encryptionSettingsDefinitionPassphrase, "AES256EncodedPasswordSecretKey.encryptionSettingsDefinitionPassphrase must not be null or empty.");
        Validator.ensureNotNull(keyFactorySalt, "AES256EncodedPasswordSecretKey.keyFactorySalt must not be null.");
        Validator.ensureTrue(keyFactorySalt.length == 16, "AES256EncodedPasswordSecretKey.keyFactorySalt must have a length of exactly 16 bytes.");
        PBEKeySpec pbeKeySpec = new PBEKeySpec(encryptionSettingsDefinitionPassphrase, keyFactorySalt, 32768, 256);
        SecretKeyFactory secretKeyFactory = CryptoHelper.getSecretKeyFactory("PBKDF2WithHmacSHA512");
        SecretKeySpec secretKey = new SecretKeySpec(secretKeyFactory.generateSecret(pbeKeySpec).getEncoded(), "AES");
        return new AES256EncodedPasswordSecretKey(encryptionSettingsDefinitionID, keyFactorySalt, secretKey);
    }

    @NotNull
    public byte[] getEncryptionSettingsDefinitionID() {
        return this.encryptionSettingsDefinitionID;
    }

    @NotNull
    public byte[] getKeyFactorySalt() {
        return this.keyFactorySalt;
    }

    @NotNull
    public SecretKey getSecretKey() {
        SecretKey secretKey = this.secretKeyRef.get();
        if (secretKey == null) {
            Validator.violation("An AES256EncodedPasswordSecretKey instance must not be used after it has been destroyed.");
        }
        return secretKey;
    }

    public void destroy() {
        SecretKey secretKey = this.secretKeyRef.getAndSet(null);
        if (secretKey != null && secretKey instanceof Destroyable) {
            try {
                Destroyable destroyableSecretKey = secretKey;
                destroyableSecretKey.destroy();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("AES256EncodedPasswordSecretKey(encryptionSettingsDefinitionIDHex='");
        StaticUtils.toHex(this.encryptionSettingsDefinitionID, buffer);
        buffer.append("', keyFactorySaltBytesHex='");
        StaticUtils.toHex(this.keyFactorySalt, buffer);
        buffer.append("')");
    }
}

