/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPDiffCompactDN;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPDiffProcessorResult;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.parallel.Processor;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
final class LDAPDiffProcessor
implements Processor<LDAPDiffCompactDN, LDAPDiffProcessorResult> {
    private static final boolean DO_NOT_IGNORE_RDN = false;
    private static final boolean USE_REVERSIBLE_MODE = true;
    private final boolean byteForByte;
    private final boolean missingOnly;
    @NotNull
    private final DN baseDN;
    @NotNull
    private final LDAPConnectionPool sourcePool;
    @NotNull
    private final LDAPConnectionPool targetPool;
    @Nullable
    private final Schema schema;
    @NotNull
    private final String[] attributes;

    LDAPDiffProcessor(@NotNull LDAPConnectionPool sourcePool, @NotNull LDAPConnectionPool targetPool, @NotNull DN baseDN, @Nullable Schema schema, boolean byteForByte, @NotNull String[] attributes, boolean missingOnly) {
        this.sourcePool = sourcePool;
        this.targetPool = targetPool;
        this.baseDN = baseDN;
        this.schema = schema;
        this.byteForByte = byteForByte;
        this.attributes = attributes;
        this.missingOnly = missingOnly;
    }

    @Override
    @NotNull
    public LDAPDiffProcessorResult process(@NotNull LDAPDiffCompactDN compactDN) throws LDAPException {
        SearchResultEntry targetEntry;
        SearchResultEntry sourceEntry;
        DN dn = compactDN.toDN(this.baseDN, this.schema);
        String dnString = dn.toString();
        try {
            sourceEntry = this.sourcePool.getEntry(dnString, this.attributes);
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            throw new LDAPException(e.getResultCode(), ToolMessages.ERR_LDAP_DIFF_PROCESSOR_ERROR_GETTING_ENTRY_FROM_SOURCE.get(dnString, StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            targetEntry = this.targetPool.getEntry(dnString, this.attributes);
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            throw new LDAPException(e.getResultCode(), ToolMessages.ERR_LDAP_DIFF_PROCESSOR_ERROR_GETTING_ENTRY_FROM_TARGET.get(dnString, StaticUtils.getExceptionMessage(e)), e);
        }
        if (sourceEntry == null) {
            if (targetEntry == null) {
                return LDAPDiffProcessorResult.createEntryMissingResult(dnString);
            }
            return LDAPDiffProcessorResult.createAddResult(targetEntry);
        }
        if (targetEntry == null) {
            return LDAPDiffProcessorResult.createDeleteResult(sourceEntry);
        }
        if (this.missingOnly) {
            return LDAPDiffProcessorResult.createNoChangesResult(sourceEntry.getDN());
        }
        List<Modification> mods = Entry.diff((Entry)sourceEntry, (Entry)targetEntry, false, true, this.byteForByte, new String[0]);
        if (mods.isEmpty()) {
            return LDAPDiffProcessorResult.createNoChangesResult(sourceEntry.getDN());
        }
        return LDAPDiffProcessorResult.createModifyResult(sourceEntry.getDN(), mods);
    }
}

