/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPModify;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolMessages;
import com.unboundid.ldif.LDIFModifyChangeRecord;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.util.Debug;
import com.unboundid.util.FixedRateBarrier;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.List;
import java.util.Set;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
final class LDAPModifySearchListener
implements SearchResultListener {
    private static final long serialVersionUID = -583082242208798146L;
    @NotNull
    private final Filter searchFilter;
    @Nullable
    private final FixedRateBarrier rateLimiter;
    @NotNull
    private final LDAPConnectionPool connectionPool;
    @NotNull
    private final LDAPModify ldapModify;
    @NotNull
    private final LDIFModifyChangeRecord sourceChangeRecord;
    @NotNull
    private final LDIFWriter rejectWriter;
    @NotNull
    private final List<Control> modifyControls;
    @NotNull
    private volatile ResultCode resultCode;
    @NotNull
    private final Set<DN> processedEntryDNs;

    LDAPModifySearchListener(@NotNull LDAPModify ldapModify, @NotNull LDIFModifyChangeRecord sourceChangeRecord, @NotNull Filter searchFilter, @NotNull List<Control> modifyControls, @NotNull LDAPConnectionPool connectionPool, @Nullable FixedRateBarrier rateLimiter, @NotNull LDIFWriter rejectWriter, @NotNull Set<DN> processedEntryDNs) {
        this.ldapModify = ldapModify;
        this.sourceChangeRecord = sourceChangeRecord;
        this.searchFilter = searchFilter;
        this.modifyControls = modifyControls;
        this.connectionPool = connectionPool;
        this.rateLimiter = rateLimiter;
        this.rejectWriter = rejectWriter;
        this.processedEntryDNs = processedEntryDNs;
        this.resultCode = ResultCode.SUCCESS;
    }

    @NotNull
    ResultCode getResultCode() {
        return this.resultCode;
    }

    @Override
    public void searchEntryReturned(@NotNull SearchResultEntry searchEntry) {
        DN parsedDN;
        block8: {
            parsedDN = null;
            try {
                parsedDN = searchEntry.getParsedDN();
                if (this.processedEntryDNs.contains(parsedDN)) {
                    return;
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            if (this.rateLimiter != null) {
                this.rateLimiter.await();
            }
            LDIFModifyChangeRecord changeRecordFromSearchEntry = new LDIFModifyChangeRecord(searchEntry.getDN(), this.sourceChangeRecord.getModifications(), this.sourceChangeRecord.getControls());
            try {
                ResultCode rc = this.ldapModify.doModify(changeRecordFromSearchEntry, this.modifyControls, this.connectionPool, null, this.rejectWriter);
                if (rc != ResultCode.SUCCESS && (this.resultCode == ResultCode.SUCCESS || this.resultCode == ResultCode.NO_OPERATION)) {
                    this.resultCode = rc;
                }
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                if (this.resultCode != ResultCode.SUCCESS && this.resultCode != ResultCode.NO_OPERATION) break block8;
                this.resultCode = le.getResultCode();
            }
        }
        if (parsedDN != null) {
            this.processedEntryDNs.add(parsedDN);
        }
    }

    @Override
    public void searchReferenceReturned(@NotNull SearchResultReference searchReference) {
        StringBuilder urls = new StringBuilder();
        for (String url : searchReference.getReferralURLs()) {
            if (urls.length() > 0) {
                urls.append(", ");
            }
            urls.append(url);
        }
        String comment = ToolMessages.ERR_LDAPMODIFY_SEARCH_LISTENER_REFERRAL.get(this.sourceChangeRecord.getDN(), String.valueOf(this.searchFilter), urls.toString());
        this.ldapModify.writeRejectedChange(this.rejectWriter, comment, this.sourceChangeRecord);
    }
}

