; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s --mattr=+complxnum -o - | FileCheck %s

target triple = "aarch64-arm-none-eabi"


; a[i] * b[i] * (11.0 + 3.0.i);
;
define <4 x double> @complex_mul_const(<4 x double> %a, <4 x double> %b) {
; CHECK-LABEL: complex_mul_const:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi v6.2d, #0000000000000000
; CHECK-NEXT:    movi v5.2d, #0000000000000000
; CHECK-NEXT:    adrp x8, .LCPI0_0
; CHECK-NEXT:    movi v4.2d, #0000000000000000
; CHECK-NEXT:    fcmla v6.2d, v1.2d, v3.2d, #0
; CHECK-NEXT:    fcmla v5.2d, v0.2d, v2.2d, #0
; CHECK-NEXT:    fcmla v6.2d, v1.2d, v3.2d, #90
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI0_0]
; CHECK-NEXT:    fcmla v5.2d, v0.2d, v2.2d, #90
; CHECK-NEXT:    movi v0.2d, #0000000000000000
; CHECK-NEXT:    fcmla v4.2d, v6.2d, v1.2d, #0
; CHECK-NEXT:    fcmla v0.2d, v5.2d, v1.2d, #0
; CHECK-NEXT:    fcmla v4.2d, v6.2d, v1.2d, #90
; CHECK-NEXT:    fcmla v0.2d, v5.2d, v1.2d, #90
; CHECK-NEXT:    mov v1.16b, v4.16b
; CHECK-NEXT:    ret
entry:
  %strided.vec = shufflevector <4 x double> %a, <4 x double> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec47 = shufflevector <4 x double> %a, <4 x double> poison, <2 x i32> <i32 1, i32 3>
  %strided.vec49 = shufflevector <4 x double> %b, <4 x double> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec50 = shufflevector <4 x double> %b, <4 x double> poison, <2 x i32> <i32 1, i32 3>
  %0 = fmul fast <2 x double> %strided.vec50, %strided.vec
  %1 = fmul fast <2 x double> %strided.vec49, %strided.vec47
  %2 = fadd fast <2 x double> %0, %1
  %3 = fmul fast <2 x double> %strided.vec49, %strided.vec
  %4 = fmul fast <2 x double> %strided.vec50, %strided.vec47
  %5 = fsub fast <2 x double> %3, %4
  %6 = fmul fast <2 x double> %5, <double 3.000000e+00, double 3.000000e+00>
  %7 = fmul fast <2 x double> %2, <double 1.100000e+01, double 1.100000e+01>
  %8 = fadd fast <2 x double> %6, %7
  %9 = fmul fast <2 x double> %5, <double 1.100000e+01, double 1.100000e+01>
  %10 = fmul fast <2 x double> %2, <double 3.000000e+00, double 3.000000e+00>
  %11 = fsub fast <2 x double> %9, %10
  %interleaved.vec = shufflevector <2 x double> %11, <2 x double> %8, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
  ret <4 x double> %interleaved.vec
}


; a[i] * b[i] * c;
;
define <4 x double> @complex_mul_non_const(<4 x double> %a, <4 x double> %b, [2 x double] %c) {
; CHECK-LABEL: complex_mul_non_const:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi v7.2d, #0000000000000000
; CHECK-NEXT:    movi v6.2d, #0000000000000000
; CHECK-NEXT:    // kill: def $d5 killed $d5 def $q5
; CHECK-NEXT:    // kill: def $d4 killed $d4 def $q4
; CHECK-NEXT:    mov v4.d[1], v5.d[0]
; CHECK-NEXT:    movi v5.2d, #0000000000000000
; CHECK-NEXT:    fcmla v7.2d, v1.2d, v3.2d, #0
; CHECK-NEXT:    fcmla v6.2d, v0.2d, v2.2d, #0
; CHECK-NEXT:    fcmla v7.2d, v1.2d, v3.2d, #90
; CHECK-NEXT:    fcmla v6.2d, v0.2d, v2.2d, #90
; CHECK-NEXT:    movi v0.2d, #0000000000000000
; CHECK-NEXT:    fcmla v5.2d, v7.2d, v4.2d, #0
; CHECK-NEXT:    fcmla v0.2d, v6.2d, v4.2d, #0
; CHECK-NEXT:    fcmla v5.2d, v7.2d, v4.2d, #90
; CHECK-NEXT:    fcmla v0.2d, v6.2d, v4.2d, #90
; CHECK-NEXT:    mov v1.16b, v5.16b
; CHECK-NEXT:    ret
entry:
  %c.coerce.fca.1.extract = extractvalue [2 x double] %c, 1
  %c.coerce.fca.0.extract = extractvalue [2 x double] %c, 0
  %broadcast.splatinsert = insertelement <2 x double> poison, double %c.coerce.fca.1.extract, i64 0
  %broadcast.splat = shufflevector <2 x double> %broadcast.splatinsert, <2 x double> poison, <2 x i32> zeroinitializer
  %broadcast.splatinsert51 = insertelement <2 x double> poison, double %c.coerce.fca.0.extract, i64 0
  %broadcast.splat52 = shufflevector <2 x double> %broadcast.splatinsert51, <2 x double> poison, <2 x i32> zeroinitializer
  %strided.vec = shufflevector <4 x double> %a, <4 x double> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec47 = shufflevector <4 x double> %a, <4 x double> poison, <2 x i32> <i32 1, i32 3>
  %strided.vec49 = shufflevector <4 x double> %b, <4 x double> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec50 = shufflevector <4 x double> %b, <4 x double> poison, <2 x i32> <i32 1, i32 3>
  %0 = fmul fast <2 x double> %strided.vec50, %strided.vec
  %1 = fmul fast <2 x double> %strided.vec49, %strided.vec47
  %2 = fadd fast <2 x double> %0, %1
  %3 = fmul fast <2 x double> %strided.vec49, %strided.vec
  %4 = fmul fast <2 x double> %strided.vec50, %strided.vec47
  %5 = fsub fast <2 x double> %3, %4
  %6 = fmul fast <2 x double> %5, %broadcast.splat
  %7 = fmul fast <2 x double> %2, %broadcast.splat52
  %8 = fadd fast <2 x double> %6, %7
  %9 = fmul fast <2 x double> %5, %broadcast.splat52
  %10 = fmul fast <2 x double> %2, %broadcast.splat
  %11 = fsub fast <2 x double> %9, %10
  %interleaved.vec = shufflevector <2 x double> %11, <2 x double> %8, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
  ret <4 x double> %interleaved.vec
}
