/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap;

import java.util.StringTokenizer;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InvalidSearchControlsException;
import javax.naming.directory.InvalidSearchFilterException;

class ProviderUtils {
    public static final String DEFAULT_FILTER = "(objectclass=*)";
    static final String hexDigits = "0123456789abcdef";

    ProviderUtils() {
    }

    static int jndiSearchScopeToLdap(int jndiScope) throws NamingException {
        int scope = -1;
        if (jndiScope == 2) {
            scope = 2;
        } else if (jndiScope == 1) {
            scope = 1;
        } else if (jndiScope == 0) {
            scope = 0;
        } else {
            throw new InvalidSearchControlsException("Illegal value for the search scope");
        }
        return scope;
    }

    static String attributesToFilter(Attributes attrs) throws NamingException {
        if (attrs == null || attrs.size() == 0) {
            return DEFAULT_FILTER;
        }
        Object filter = "";
        NamingEnumeration<? extends Attribute> attrEnum = attrs.getAll();
        while (attrEnum.hasMore()) {
            Attribute attrib = attrEnum.next();
            if (attrib.size() == 0) {
                filter = (String)filter + "(" + attrib.getID() + "=*)";
                continue;
            }
            Object attrValues = "";
            NamingEnumeration<?> valEnum = attrib.getAll();
            while (valEnum.hasMore()) {
                Object val = valEnum.next();
                if (val instanceof String) {
                    attrValues = (String)attrValues + "(" + attrib.getID() + "=" + ProviderUtils.escapeString((String)val) + ")";
                    continue;
                }
                if (val instanceof byte[]) {
                    attrValues = (String)attrValues + "(" + attrib.getID() + "=" + ProviderUtils.escapeBytes((byte[])val) + ")";
                    continue;
                }
                if (val == null) {
                    attrValues = (String)attrValues + "(" + attrib.getID() + "=*)";
                    continue;
                }
                throw new NamingException("Wrong Attribute value, expecting String or byte[]");
            }
            filter = (String)filter + (String)(attrib.size() > 1 ? "(|" + (String)attrValues + ")" : attrValues);
        }
        return attrs.size() > 1 ? "(&" + (String)filter + ")" : filter;
    }

    static String expandFilterExpr(String filterExpr, Object[] filterArgs) throws InvalidSearchFilterException {
        StringTokenizer tok = new StringTokenizer(filterExpr, "{}", true);
        if (tok.countTokens() == 1) {
            return filterExpr;
        }
        StringBuffer out = new StringBuffer();
        boolean expectVarIdx = false;
        boolean expectVarOff = false;
        Object arg = null;
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            if (expectVarIdx) {
                expectVarIdx = false;
                try {
                    int idx = Integer.parseInt(s);
                    arg = filterArgs[idx];
                    expectVarOff = true;
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    throw new InvalidSearchFilterException("Filter expression variable index out of bounds");
                }
                catch (Exception e) {
                    throw new InvalidSearchFilterException("Invalid filter expression");
                }
            }
            if (expectVarOff) {
                expectVarOff = false;
                if (!s.equals("}")) {
                    throw new InvalidSearchFilterException("Invalid filter expression");
                }
                if (arg instanceof String) {
                    out.append(ProviderUtils.escapeString((String)arg));
                } else if (arg instanceof byte[]) {
                    out.append(ProviderUtils.escapeBytes((byte[])arg));
                } else {
                    throw new InvalidSearchFilterException("Invalid filter argument type");
                }
                arg = null;
                continue;
            }
            if (s.equals("{")) {
                expectVarIdx = true;
                continue;
            }
            out.append(s);
        }
        if (expectVarIdx || expectVarOff) {
            throw new InvalidSearchFilterException("Invalid filter expression");
        }
        return out.toString();
    }

    static String escapeString(String str) {
        String charToEscape = "\\*()\u0000";
        StringTokenizer tok = new StringTokenizer(str, charToEscape, true);
        if (tok.countTokens() == 1) {
            return str;
        }
        StringBuffer out = new StringBuffer();
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            if (s.equals("*")) {
                out.append("\\2a");
                continue;
            }
            if (s.equals("(")) {
                out.append("\\28");
                continue;
            }
            if (s.equals(")")) {
                out.append("\\29");
                continue;
            }
            if (s.equals("\\")) {
                out.append("\\5c");
                continue;
            }
            if (s.equals("\u0000")) {
                out.append("\\00");
                continue;
            }
            out.append(s);
        }
        return out.toString();
    }

    static String escapeBytes(byte[] bytes) {
        StringBuffer out = new StringBuffer("");
        for (int i = 0; i < bytes.length; ++i) {
            int low = bytes[i] & 0xF;
            int high = (bytes[i] & 0xF0) >> 4;
            out.append("\\");
            out.append(hexDigits.charAt(high));
            out.append(hexDigits.charAt(low));
        }
        return out.toString();
    }

    private static void testAttributesToFilter() {
        try {
            System.out.println(ProviderUtils.attributesToFilter(null));
            BasicAttributes attrs = new BasicAttributes(true);
            System.out.println(attrs + " = " + ProviderUtils.attributesToFilter(attrs));
            attrs.put(new BasicAttribute("attr1", "val1"));
            attrs.put(new BasicAttribute("attr2", "(val2)\\*x"));
            attrs.put(new BasicAttribute("attr3"));
            BasicAttribute attr4 = new BasicAttribute("attr4", "val41");
            attr4.add("val42");
            attrs.put(attr4);
            attrs.put("attr5", new byte[]{35, 3, 0, -85, -1});
            System.out.println(attrs + " = " + ProviderUtils.attributesToFilter(attrs));
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    private static void testFilterExpr() {
        try {
            String filterExpr = "(&(attr0={0})(attr1={1}))";
            Object[] args = new Object[]{"val*0", new byte[]{-16, 58}};
            String filter = null;
            filter = ProviderUtils.expandFilterExpr(filterExpr, args);
            System.out.println(filterExpr + " -> " + filter);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public static void main(String[] args) {
        ProviderUtils.testFilterExpr();
    }
}

