/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.InternalSDKHelper;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SASLBindRequest;
import com.unboundid.ldap.sdk.ToCodeArgHelper;
import com.unboundid.ldap.sdk.ToCodeHelper;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDDSMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class UnboundIDYubiKeyOTPBindRequest
extends SASLBindRequest {
    @NotNull
    public static final String UNBOUNDID_YUBIKEY_OTP_MECHANISM_NAME = "UNBOUNDID-YUBIKEY-OTP";
    private static final byte TYPE_AUTHENTICATION_ID = -128;
    private static final byte TYPE_AUTHORIZATION_ID = -127;
    private static final byte TYPE_STATIC_PASSWORD = -126;
    private static final byte TYPE_YUBIKEY_OTP = -125;
    private static final long serialVersionUID = -6124016046606933247L;
    @Nullable
    private final ASN1OctetString staticPassword;
    private volatile int messageID = -1;
    @NotNull
    private final String authenticationID;
    @Nullable
    private final String authorizationID;
    @NotNull
    private final String yubiKeyOTP;

    public UnboundIDYubiKeyOTPBindRequest(@NotNull String authenticationID, @Nullable String authorizationID, @Nullable String staticPassword, @NotNull String yubiKeyOTP, Control ... controls) {
        this(authenticationID, authorizationID, UnboundIDYubiKeyOTPBindRequest.toASN1OctetString(staticPassword), yubiKeyOTP, controls);
    }

    public UnboundIDYubiKeyOTPBindRequest(@NotNull String authenticationID, @Nullable String authorizationID, @Nullable byte[] staticPassword, @NotNull String yubiKeyOTP, Control ... controls) {
        this(authenticationID, authorizationID, UnboundIDYubiKeyOTPBindRequest.toASN1OctetString(staticPassword), yubiKeyOTP, controls);
    }

    private UnboundIDYubiKeyOTPBindRequest(@NotNull String authenticationID, @Nullable String authorizationID, @Nullable ASN1OctetString staticPassword, @NotNull String yubiKeyOTP, Control ... controls) {
        super(controls);
        Validator.ensureNotNull(authenticationID);
        Validator.ensureNotNull(yubiKeyOTP);
        this.authenticationID = authenticationID;
        this.authorizationID = authorizationID;
        this.staticPassword = staticPassword;
        this.yubiKeyOTP = yubiKeyOTP;
    }

    @Nullable
    private static ASN1OctetString toASN1OctetString(@Nullable Object password) {
        if (password == null) {
            return null;
        }
        if (password instanceof byte[]) {
            return new ASN1OctetString(-126, (byte[])password);
        }
        return new ASN1OctetString(-126, String.valueOf(password));
    }

    @NotNull
    public static UnboundIDYubiKeyOTPBindRequest decodeCredentials(@NotNull ASN1OctetString saslCredentials, Control ... controls) throws LDAPException {
        try {
            ASN1OctetString staticPassword = null;
            String authenticationID = null;
            String authorizationID = null;
            String yubiKeyOTP = null;
            block9: for (ASN1Element e : ASN1Sequence.decodeAsSequence(saslCredentials.getValue()).elements()) {
                switch (e.getType()) {
                    case -128: {
                        authenticationID = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block9;
                    }
                    case -127: {
                        authorizationID = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block9;
                    }
                    case -126: {
                        staticPassword = ASN1OctetString.decodeAsOctetString(e);
                        continue block9;
                    }
                    case -125: {
                        yubiKeyOTP = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block9;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, UnboundIDDSMessages.ERR_YUBIKEY_OTP_DECODE_UNRECOGNIZED_CRED_ELEMENT.get(UNBOUNDID_YUBIKEY_OTP_MECHANISM_NAME, StaticUtils.toHex(e.getType())));
                    }
                }
            }
            if (authenticationID == null) {
                throw new LDAPException(ResultCode.DECODING_ERROR, UnboundIDDSMessages.ERR_YUBIKEY_OTP_DECODE_NO_AUTH_ID.get(UNBOUNDID_YUBIKEY_OTP_MECHANISM_NAME));
            }
            if (yubiKeyOTP == null) {
                throw new LDAPException(ResultCode.DECODING_ERROR, UnboundIDDSMessages.ERR_YUBIKEY_OTP_NO_OTP.get(UNBOUNDID_YUBIKEY_OTP_MECHANISM_NAME));
            }
            return new UnboundIDYubiKeyOTPBindRequest(authenticationID, authorizationID, staticPassword, yubiKeyOTP, controls);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, UnboundIDDSMessages.ERR_YUBIKEY_OTP_DECODE_ERROR.get(UNBOUNDID_YUBIKEY_OTP_MECHANISM_NAME, StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    public String getAuthenticationID() {
        return this.authenticationID;
    }

    @Nullable
    public String getAuthorizationID() {
        return this.authorizationID;
    }

    @Nullable
    public String getStaticPasswordString() {
        if (this.staticPassword == null) {
            return null;
        }
        return this.staticPassword.stringValue();
    }

    @Nullable
    public byte[] getStaticPasswordBytes() {
        if (this.staticPassword == null) {
            return null;
        }
        return this.staticPassword.getValue();
    }

    @NotNull
    public String getYubiKeyOTP() {
        return this.yubiKeyOTP;
    }

    @Override
    @NotNull
    protected BindResult process(@NotNull LDAPConnection connection, int depth) throws LDAPException {
        this.messageID = InternalSDKHelper.nextMessageID(connection);
        return this.sendBindRequest(connection, "", this.encodeCredentials(), this.getControls(), this.getResponseTimeoutMillis(connection));
    }

    @NotNull
    public ASN1OctetString encodeCredentials() {
        return UnboundIDYubiKeyOTPBindRequest.encodeCredentials(this.authenticationID, this.authorizationID, this.staticPassword, this.yubiKeyOTP);
    }

    @NotNull
    public static ASN1OctetString encodeCredentials(@NotNull String authenticationID, @Nullable String authorizationID, @Nullable ASN1OctetString staticPassword, @NotNull String yubiKeyOTP) {
        Validator.ensureNotNull(authenticationID);
        Validator.ensureNotNull(yubiKeyOTP);
        ArrayList<ASN1OctetString> elements = new ArrayList<ASN1OctetString>(4);
        elements.add(new ASN1OctetString(-128, authenticationID));
        if (authorizationID != null) {
            elements.add(new ASN1OctetString(-127, authorizationID));
        }
        if (staticPassword != null) {
            elements.add(new ASN1OctetString(-126, staticPassword.getValue()));
        }
        elements.add(new ASN1OctetString(-125, yubiKeyOTP));
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @Override
    @NotNull
    public UnboundIDYubiKeyOTPBindRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    @NotNull
    public UnboundIDYubiKeyOTPBindRequest duplicate(@Nullable Control[] controls) {
        UnboundIDYubiKeyOTPBindRequest bindRequest = new UnboundIDYubiKeyOTPBindRequest(this.authenticationID, this.authorizationID, this.staticPassword, this.yubiKeyOTP, controls);
        bindRequest.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return bindRequest;
    }

    @Override
    @NotNull
    public String getSASLMechanismName() {
        return UNBOUNDID_YUBIKEY_OTP_MECHANISM_NAME;
    }

    @Override
    public int getLastMessageID() {
        return this.messageID;
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("UnboundYubiKeyOTPBindRequest(authenticationID='");
        buffer.append(this.authenticationID);
        if (this.authorizationID != null) {
            buffer.append("', authorizationID='");
            buffer.append(this.authorizationID);
        }
        buffer.append("', staticPasswordProvided=");
        buffer.append(this.staticPassword != null);
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }

    @Override
    public void toCode(@NotNull List<String> lineList, @NotNull String requestID, int indentSpaces, boolean includeProcessing) {
        ArrayList<ToCodeArgHelper> constructorArgs = new ArrayList<ToCodeArgHelper>(5);
        constructorArgs.add(ToCodeArgHelper.createString(this.getAuthenticationID(), "Authentication ID"));
        constructorArgs.add(ToCodeArgHelper.createString(this.getAuthorizationID(), "Authorization ID"));
        constructorArgs.add(ToCodeArgHelper.createString("---redacted-static-password---", "Static Password"));
        constructorArgs.add(ToCodeArgHelper.createString(this.getStaticPasswordString() == null ? "null" : "---redacted-static-password---", "Static Password"));
        constructorArgs.add(ToCodeArgHelper.createString("---redacted-yubikey-otp---", "YubiKey OTP"));
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            constructorArgs.add(ToCodeArgHelper.createControlArray(controls, "Bind Controls"));
        }
        ToCodeHelper.generateMethodCall(lineList, indentSpaces, "UnboundIDYubiKeyOTPBindRequest", requestID + "Request", "new UnboundIDYubiKeyOTPBindRequest", constructorArgs);
        if (includeProcessing) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < indentSpaces; ++i) {
                buffer.append(' ');
            }
            String indent = buffer.toString();
            lineList.add("");
            lineList.add(indent + "try");
            lineList.add(indent + '{');
            lineList.add(indent + "  BindResult " + requestID + "Result = connection.bind(" + requestID + "Request);");
            lineList.add(indent + "  // The bind was processed successfully.");
            lineList.add(indent + '}');
            lineList.add(indent + "catch (LDAPException e)");
            lineList.add(indent + '{');
            lineList.add(indent + "  // The bind failed.  Maybe the following will " + "help explain why.");
            lineList.add(indent + "  // Note that the connection is now likely in " + "an unauthenticated state.");
            lineList.add(indent + "  ResultCode resultCode = e.getResultCode();");
            lineList.add(indent + "  String message = e.getMessage();");
            lineList.add(indent + "  String matchedDN = e.getMatchedDN();");
            lineList.add(indent + "  String[] referralURLs = e.getReferralURLs();");
            lineList.add(indent + "  Control[] responseControls = " + "e.getResponseControls();");
            lineList.add(indent + '}');
        }
    }
}

