/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.nss;

import java.util.ArrayList;
import org.mozilla.jss.nss.PR;
import org.mozilla.jss.nss.PRFDProxy;
import org.mozilla.jss.nss.SSLChannelInfo;
import org.mozilla.jss.nss.SSLFDProxy;
import org.mozilla.jss.nss.SSLPreliminaryChannelInfo;
import org.mozilla.jss.nss.SecurityStatusResult;
import org.mozilla.jss.pkcs11.PK11Cert;
import org.mozilla.jss.pkcs11.PK11PrivKey;
import org.mozilla.jss.ssl.SSLProtocolVariant;
import org.mozilla.jss.ssl.SSLVersionRange;

public class SSL {
    public static final int REQUEST_CERTIFICATE = SSL.getSSLRequestCertificate();
    public static final int REQUIRE_CERTIFICATE = SSL.getSSLRequireCertificate();
    public static final int SECSuccess = SSL.getSSLSECSuccess();
    public static final int SECFailure = SSL.getSSLSECFailure();
    public static final int SECWouldBlock = SSL.getSSLSECWouldBlock();
    public static final int ENABLE_POST_HANDSHAKE_AUTH = SSL.getSSLEnablePostHandshakeAuth();
    public static final int ENABLE_RENEGOTIATION = SSL.getSSLEnableRenegotiation();
    public static final int REQUIRE_SAFE_NEGOTIATION = SSL.getSSLRequireSafeNegotiation();
    public static final int RENEGOTIATE_NEVER = SSL.getSSLRenegotiateNever();
    public static final int RENEGOTIATE_UNRESTRICTED = SSL.getSSLRenegotiateUnrestricted();
    public static final int RENEGOTIATE_REQUIRES_XTN = SSL.getSSLRenegotiateRequiresXtn();
    public static final int RENEGOTIATE_TRANSITIONAL = SSL.getSSLRenegotiateTransitional();
    public static final int ENABLE_FALLBACK_SCSV = SSL.getSSLEnableFallbackSCSV();
    public static final int REQUIRE_NEVER = SSL.getSSLRequireNever();
    public static final int REQUIRE_ALWAYS = SSL.getSSLRequireAlways();
    public static final int REQUIRE_FIRST_HANDSHAKE = SSL.getSSLRequireFirstHandshake();
    public static final int REQUIRE_NO_ERROR = SSL.getSSLRequireNoError();

    public static SSLFDProxy ImportFD(PRFDProxy model, PRFDProxy fd) {
        if (fd == null) {
            throw new NullPointerException("Expected fd != null");
        }
        byte[] ptr = SSL.ImportFDNative(model, fd);
        if (ptr == null || ptr.length == 0) {
            int error = PR.GetError();
            throw new NullPointerException("SSL_ImportFD failed: " + PR.ErrorToName(error) + " (" + error + ")");
        }
        fd.clear();
        return new SSLFDProxy(ptr);
    }

    public static native byte[] ImportFDNative(PRFDProxy var0, PRFDProxy var1);

    public static native int OptionSet(SSLFDProxy var0, int var1, int var2);

    public static native int OptionGet(SSLFDProxy var0, int var1) throws Exception;

    public static native int SetURL(SSLFDProxy var0, String var1);

    public static native int CipherPrefSet(SSLFDProxy var0, int var1, boolean var2);

    public static native boolean CipherPrefGet(SSLFDProxy var0, int var1) throws Exception;

    public static native int CipherPrefSetDefault(int var0, boolean var1);

    public static native boolean CipherPrefGetDefault(int var0);

    public static int VersionRangeSet(SSLFDProxy fd, SSLVersionRange range) {
        return SSL.VersionRangeSetNative(fd, range.getMinEnum(), range.getMaxEnum());
    }

    private static native int VersionRangeSetNative(SSLFDProxy var0, int var1, int var2);

    public static native SSLVersionRange VersionRangeGet(SSLFDProxy var0) throws Exception;

    public static int VersionRangeSetDefault(SSLVersionRange range) {
        return SSL.VersionRangeSetDefault(SSLProtocolVariant.STREAM, range);
    }

    public static int VersionRangeSetDefault(SSLProtocolVariant variant, SSLVersionRange range) {
        return SSL.VersionRangeSetDefaultNative(variant.getEnum(), range.getMinEnum(), range.getMaxEnum());
    }

    private static native int VersionRangeSetDefaultNative(int var0, int var1, int var2);

    public static SSLVersionRange VersionRangeGetDefault() {
        return SSL.VersionRangeGetDefault(SSLProtocolVariant.STREAM);
    }

    public static SSLVersionRange VersionRangeGetDefault(SSLProtocolVariant variant) {
        return SSL.VersionRangeGetDefaultNative(variant.getEnum());
    }

    private static native SSLVersionRange VersionRangeGetDefaultNative(int var0);

    public static native SecurityStatusResult SecurityStatus(SSLFDProxy var0);

    public static native SSLChannelInfo GetChannelInfo(SSLFDProxy var0);

    public static native SSLPreliminaryChannelInfo GetPreliminaryChannelInfo(SSLFDProxy var0);

    public static native int ResetHandshake(SSLFDProxy var0, boolean var1);

    public static native int ReHandshake(SSLFDProxy var0, boolean var1);

    public static native int ForceHandshake(SSLFDProxy var0);

    @Deprecated
    public static native int ConfigSecureServer(SSLFDProxy var0, PK11Cert var1, PK11PrivKey var2, int var3);

    public static native int ConfigServerCert(SSLFDProxy var0, PK11Cert var1, PK11PrivKey var2);

    public static synchronized native int ConfigServerSessionIDCache(int var0, long var1, long var3, String var5);

    public static native int InvalidateSession(SSLFDProxy var0);

    public static native PK11Cert PeerCertificate(SSLFDProxy var0);

    public static native PK11Cert[] PeerCertificateChain(SSLFDProxy var0) throws Exception;

    public static native int SendCertificateRequest(SSLFDProxy var0);

    public static native int KeyUpdate(SSLFDProxy var0, boolean var1);

    public static native int AttachClientCertCallback(SSLFDProxy var0);

    public static int EnableAlertLogging(SSLFDProxy fd) {
        fd.inboundAlerts = new ArrayList();
        fd.inboundOffset = 0;
        fd.outboundAlerts = new ArrayList();
        fd.outboundOffset = 0;
        return SSL.EnableAlertLoggingNative(fd);
    }

    private static native int EnableAlertLoggingNative(SSLFDProxy var0);

    public static native int ConfigJSSDefaultCertAuthCallback(SSLFDProxy var0);

    public static native int ConfigAsyncTrustManagerCertAuthCallback(SSLFDProxy var0);

    public static native int ConfigSyncTrustManagerCertAuthCallback(SSLFDProxy var0);

    public static native int ConfigAsyncBadCertCallback(SSLFDProxy var0);

    public static native int ConfigSyncBadCertCallback(SSLFDProxy var0);

    public static native int AuthCertificateComplete(SSLFDProxy var0, int var1);

    public static native void RemoveCallbacks(SSLFDProxy var0);

    public static native int EnableHandshakeCallback(SSLFDProxy var0);

    private static native int getSSLRequestCertificate();

    private static native int getSSLRequireCertificate();

    private static native int getSSLSECSuccess();

    private static native int getSSLSECFailure();

    private static native int getSSLSECWouldBlock();

    private static native int getSSLEnablePostHandshakeAuth();

    private static native int getSSLEnableRenegotiation();

    private static native int getSSLRequireSafeNegotiation();

    private static native int getSSLRenegotiateNever();

    private static native int getSSLRenegotiateUnrestricted();

    private static native int getSSLRenegotiateRequiresXtn();

    private static native int getSSLRenegotiateTransitional();

    private static native int getSSLEnableFallbackSCSV();

    private static native int getSSLRequireNever();

    private static native int getSSLRequireAlways();

    private static native int getSSLRequireFirstHandshake();

    private static native int getSSLRequireNoError();
}

