/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.netscape.security.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NativeProxy
implements AutoCloseable {
    public static Logger logger = LoggerFactory.getLogger(NativeProxy.class);
    private static final boolean saveStacktraces = NativeProxy.assertsEnabled() && CryptoManager.JSS_DEBUG;
    private byte[] mPointer;
    private int mHashCode;
    private String mTrace;
    static Set<NativeProxy> registry = Collections.newSetFromMap(new WeakHashMap());
    static AtomicInteger registryIndex = new AtomicInteger();

    public NativeProxy(byte[] pointer) {
        this(pointer, true);
    }

    protected NativeProxy(byte[] pointer, boolean track) {
        this.mPointer = pointer;
        this.mHashCode = registryIndex.getAndIncrement();
        if (this.mPointer != null) {
            this.mHashCode += Arrays.hashCode(this.mPointer);
        }
        if (track && saveStacktraces) {
            assert (pointer != null);
            registry.add(this);
            this.mTrace = Arrays.toString(Thread.currentThread().getStackTrace());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NativeProxy)) {
            return false;
        }
        NativeProxy nObj = (NativeProxy)obj;
        if (this.mPointer == null || nObj.mPointer == null) {
            return false;
        }
        return Arrays.equals(this.mPointer, nObj.mPointer);
    }

    public int hashCode() {
        return this.mHashCode;
    }

    protected abstract void releaseNativeResources() throws Exception;

    @Deprecated
    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public final void close() throws Exception {
        try {
            if (this.mPointer != null) {
                this.releaseNativeResources();
            }
        }
        finally {
            this.clear();
        }
    }

    public final void clear() {
        this.mPointer = null;
    }

    public boolean isNull() {
        return this.mPointer == null;
    }

    public String toString() {
        if (this.mPointer == null) {
            return this.getClass().getName() + "[" + this.mHashCode + "@null]";
        }
        return this.getClass().getName() + "[" + this.mHashCode + "@" + Utils.HexEncode(this.mPointer) + "]";
    }

    private static boolean assertsEnabled() {
        boolean enabled = false;
        if (!$assertionsDisabled) {
            enabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return enabled;
    }

    public static synchronized void assertRegistryEmpty() {
        if (!registry.isEmpty()) {
            logger.warn(registry.size() + " NativeProxys are still registered.");
            if (saveStacktraces) {
                for (NativeProxy proxy : registry) {
                    logger.warn("\t" + Arrays.toString(proxy.mPointer) + " ::: " + proxy.mTrace);
                }
            }
        } else {
            logger.debug("NativeProxy registry is empty");
        }
    }

    public static synchronized void purgeAllInRegistry() throws Exception {
        Exception first = null;
        HashSet<NativeProxy> registryClone = new HashSet<NativeProxy>(registry.size());
        registryClone.addAll(registry);
        for (NativeProxy proxy : registryClone) {
            try {
                proxy.close();
            }
            catch (Exception e) {
                if (first != null) continue;
                first = e;
            }
        }
        if (first != null) {
            throw first;
        }
    }
}

