; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-linux-gnu -mattr=+sve -aarch64-sve-vector-bits-min=512  -o - < %s | FileCheck %s

define void @vls_sve_and_64xi8(ptr %ap, ptr %out) nounwind {
; CHECK-LABEL: vls_sve_and_64xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI0_0
; CHECK-NEXT:    add x8, x8, :lo12:.LCPI0_0
; CHECK-NEXT:    ptrue p0.b, vl64
; CHECK-NEXT:    ld1b { z0.b }, p0/z, [x0]
; CHECK-NEXT:    ld1b { z1.b }, p0/z, [x8]
; CHECK-NEXT:    and z0.d, z0.d, z1.d
; CHECK-NEXT:    st1b { z0.b }, p0, [x1]
; CHECK-NEXT:    ret
 %a = load <64 x i8>, ptr %ap
 %b = and <64 x i8> %a, <i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255,
                         i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255,
                         i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255,
                         i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255>
 store <64 x i8> %b, ptr %out
 ret void
}

define <16 x i8> @vls_sve_and_16xi8(<16 x i8> %b, ptr %out) nounwind {
; CHECK-LABEL: vls_sve_and_16xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    bic v0.8h, #255
; CHECK-NEXT:    ret
 %c = and <16 x i8> %b, <i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255>
 ret <16 x i8> %c
}

define <8 x i8> @vls_sve_and_8xi8(<8 x i8> %b, ptr %out) nounwind {
; CHECK-LABEL: vls_sve_and_8xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    bic v0.4h, #255
; CHECK-NEXT:    ret
 %c = and <8 x i8> %b, <i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255>
 ret <8 x i8> %c
}

