/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ui.table;

import java.util.Comparator;
import javax.swing.table.TableModel;

public abstract class TableModelComparator
implements Comparator {
    private boolean ascending;
    protected TableModel model;
    private int[] columns;

    public TableModelComparator(TableModel model) {
        this.model = model;
        this.columns = new int[model.getColumnCount()];
        this.columns[0] = -1;
    }

    public void addColumn(int column) {
        int[] tempArray = new int[this.model.getColumnCount()];
        System.arraycopy(this.columns, 1, tempArray, 0, this.columns.length - 1);
        this.columns = tempArray;
        this.columns[0] = column;
    }

    public int getColumn() {
        return this.columns[0];
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public int compare(Object row1, Object row2) {
        for (int i = 0; i < this.columns.length; ++i) {
            Object o1 = this.getValueForColumn(row1, this.columns[i]);
            Object o2 = this.getValueForColumn(row2, this.columns[i]);
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            int result = 0;
            if (o1 instanceof Comparable) {
                Comparable c1 = (Comparable)o1;
                Comparable c2 = (Comparable)o2;
                result = c1.compareTo(c2);
            }
            if (result == 0) continue;
            return this.ascending ? result : -result;
        }
        return 0;
    }

    public abstract Object getValueForColumn(Object var1, int var2);
}

