// RUN: llvm-mc -arch=amdgcn -mcpu=bonaire -show-encoding %s | FileCheck %s

v_cndmask_b32 v5, v1, v2, vcc
// CHECK: [0x01,0x05,0x0a,0x00]

v_cndmask_b32 v255, v1, v2, vcc
// CHECK: [0x01,0x05,0xfe,0x01]

v_cndmask_b32 v5, v255, v2, vcc
// CHECK: [0xff,0x05,0x0a,0x00]

v_cndmask_b32 v5, 0, v2, vcc
// CHECK: [0x80,0x04,0x0a,0x00]

v_cndmask_b32 v5, -1, v2, vcc
// CHECK: [0xc1,0x04,0x0a,0x00]

v_cndmask_b32 v5, 0.5, v2, vcc
// CHECK: [0xf0,0x04,0x0a,0x00]

v_cndmask_b32 v5, -4.0, v2, vcc
// CHECK: [0xf7,0x04,0x0a,0x00]

v_cndmask_b32 v5, src_lds_direct, v2, vcc
// CHECK: [0xfe,0x04,0x0a,0x00]

v_cndmask_b32 v5, v1, v255, vcc
// CHECK: [0x01,0xff,0x0b,0x00]

v_readlane_b32 s5, v1, s2
// CHECK: [0x01,0x05,0x0a,0x02]

v_readlane_b32 s103, v1, s2
// CHECK: [0x01,0x05,0xce,0x02]

v_readlane_b32 tba_lo, v1, s2
// CHECK: [0x01,0x05,0xd8,0x02]

v_readlane_b32 tba_hi, v1, s2
// CHECK: [0x01,0x05,0xda,0x02]

v_readlane_b32 tma_lo, v1, s2
// CHECK: [0x01,0x05,0xdc,0x02]

v_readlane_b32 tma_hi, v1, s2
// CHECK: [0x01,0x05,0xde,0x02]

v_readlane_b32 ttmp11, v1, s2
// CHECK: [0x01,0x05,0xf6,0x02]

v_readlane_b32 s5, v255, s2
// CHECK: [0xff,0x05,0x0a,0x02]

v_readlane_b32 s5, src_lds_direct, s2
// CHECK: [0xfe,0x04,0x0a,0x02]

v_readlane_b32 s5, v1, s103
// CHECK: [0x01,0xcf,0x0a,0x02]

v_readlane_b32 s5, v1, flat_scratch_lo
// CHECK: [0x01,0xd1,0x0a,0x02]

v_readlane_b32 s5, v1, flat_scratch_hi
// CHECK: [0x01,0xd3,0x0a,0x02]

v_readlane_b32 s5, v1, vcc_lo
// CHECK: [0x01,0xd5,0x0a,0x02]

v_readlane_b32 s5, v1, vcc_hi
// CHECK: [0x01,0xd7,0x0a,0x02]

v_readlane_b32 s5, v1, tba_lo
// CHECK: [0x01,0xd9,0x0a,0x02]

v_readlane_b32 s5, v1, tba_hi
// CHECK: [0x01,0xdb,0x0a,0x02]

v_readlane_b32 s5, v1, tma_lo
// CHECK: [0x01,0xdd,0x0a,0x02]

v_readlane_b32 s5, v1, tma_hi
// CHECK: [0x01,0xdf,0x0a,0x02]

v_readlane_b32 s5, v1, ttmp11
// CHECK: [0x01,0xf7,0x0a,0x02]

v_readlane_b32 s5, v1, m0
// CHECK: [0x01,0xf9,0x0a,0x02]

v_readlane_b32 s5, v1, 0
// CHECK: [0x01,0x01,0x0b,0x02]

v_writelane_b32 v5, 0, s2
// CHECK: [0x80,0x04,0x0a,0x04]

v_writelane_b32 v255, 0, s2
// CHECK: [0x80,0x04,0xfe,0x05]

v_writelane_b32 v5, -1, s2
// CHECK: [0xc1,0x04,0x0a,0x04]

v_writelane_b32 v5, 0.5, s2
// CHECK: [0xf0,0x04,0x0a,0x04]

v_writelane_b32 v5, -4.0, s2
// CHECK: [0xf7,0x04,0x0a,0x04]

v_writelane_b32 v5, src_lds_direct, s2
// CHECK: [0xfe,0x04,0x0a,0x04]

v_writelane_b32 v5, 0, s103
// CHECK: [0x80,0xce,0x0a,0x04]

v_writelane_b32 v5, 0, flat_scratch_lo
// CHECK: [0x80,0xd0,0x0a,0x04]

v_writelane_b32 v5, 0, flat_scratch_hi
// CHECK: [0x80,0xd2,0x0a,0x04]

v_writelane_b32 v5, 0, vcc_lo
// CHECK: [0x80,0xd4,0x0a,0x04]

v_writelane_b32 v5, 0, vcc_hi
// CHECK: [0x80,0xd6,0x0a,0x04]

v_writelane_b32 v5, 0, tba_lo
// CHECK: [0x80,0xd8,0x0a,0x04]

v_writelane_b32 v5, 0, tba_hi
// CHECK: [0x80,0xda,0x0a,0x04]

v_writelane_b32 v5, 0, tma_lo
// CHECK: [0x80,0xdc,0x0a,0x04]

v_writelane_b32 v5, 0, tma_hi
// CHECK: [0x80,0xde,0x0a,0x04]

v_writelane_b32 v5, 0, ttmp11
// CHECK: [0x80,0xf6,0x0a,0x04]

v_writelane_b32 v5, 0, m0
// CHECK: [0x80,0xf8,0x0a,0x04]

v_writelane_b32 v5, 0, 0
// CHECK: [0x80,0x00,0x0b,0x04]

v_add_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x06]

v_add_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x07]

v_add_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x06]

v_add_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x06]

v_add_f32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x06]

v_add_f32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x06]

v_add_f32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x06]

v_add_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x06]

v_add_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x06]

v_add_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x06]

v_add_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x06]

v_add_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x06]

v_add_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x06]

v_add_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x06]

v_add_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x06]

v_add_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x06]

v_add_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x06]

v_add_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x06]

v_add_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x06]

v_add_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x06]

v_add_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x06]

v_add_f32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x06]

v_add_f32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x06]

v_add_f32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x06]

v_add_f32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x06]

v_add_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x06,0x56,0x34,0x12,0xaf]

v_add_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x06,0x73,0x72,0x71,0x3f]

v_add_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x06]

v_sub_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x08]

v_sub_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x09]

v_sub_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x08]

v_sub_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x08]

v_sub_f32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x08]

v_sub_f32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x08]

v_sub_f32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x08]

v_sub_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x08]

v_sub_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x08]

v_sub_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x08]

v_sub_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x08]

v_sub_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x08]

v_sub_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x08]

v_sub_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x08]

v_sub_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x08]

v_sub_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x08]

v_sub_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x08]

v_sub_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x08]

v_sub_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x08]

v_sub_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x08]

v_sub_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x08]

v_sub_f32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x08]

v_sub_f32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x08]

v_sub_f32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x08]

v_sub_f32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x08]

v_sub_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x08,0x56,0x34,0x12,0xaf]

v_sub_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x08,0x73,0x72,0x71,0x3f]

v_sub_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x08]

v_subrev_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x0a]

v_subrev_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x0b]

v_subrev_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x0a]

v_subrev_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x0a]

v_subrev_f32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x0a]

v_subrev_f32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x0a]

v_subrev_f32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x0a]

v_subrev_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x0a]

v_subrev_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x0a]

v_subrev_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x0a]

v_subrev_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x0a]

v_subrev_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x0a]

v_subrev_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x0a]

v_subrev_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x0a]

v_subrev_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x0a]

v_subrev_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x0a]

v_subrev_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x0a]

v_subrev_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x0a]

v_subrev_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x0a]

v_subrev_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x0a]

v_subrev_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x0a]

v_subrev_f32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x0a]

v_subrev_f32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x0a]

v_subrev_f32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x0a]

v_subrev_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x0a,0x56,0x34,0x12,0xaf]

v_subrev_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x0a,0x73,0x72,0x71,0x3f]

v_subrev_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x0a]

v_mac_legacy_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x0c]

v_mac_legacy_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x0d]

v_mac_legacy_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x0c]

v_mac_legacy_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x0c,0x56,0x34,0x12,0xaf]

v_mac_legacy_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x0c,0x73,0x72,0x71,0x3f]

v_mac_legacy_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x0c]

v_mul_legacy_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x0e]

v_mul_legacy_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x0f]

v_mul_legacy_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x0e]

v_mul_legacy_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x0e,0x56,0x34,0x12,0xaf]

v_mul_legacy_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x0e,0x73,0x72,0x71,0x3f]

v_mul_legacy_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x0e]

v_mul_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x10]

v_mul_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x11]

v_mul_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x10]

v_mul_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x10]

v_mul_f32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x10]

v_mul_f32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x10]

v_mul_f32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x10]

v_mul_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x10]

v_mul_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x10]

v_mul_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x10]

v_mul_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x10]

v_mul_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x10]

v_mul_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x10]

v_mul_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x10]

v_mul_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x10]

v_mul_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x10]

v_mul_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x10]

v_mul_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x10]

v_mul_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x10]

v_mul_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x10]

v_mul_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x10]

v_mul_f32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x10]

v_mul_f32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x10]

v_mul_f32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x10]

v_mul_f32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x10]

v_mul_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x10,0x56,0x34,0x12,0xaf]

v_mul_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x10,0x73,0x72,0x71,0x3f]

v_mul_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x10]

v_mul_i32_i24 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x12]

v_mul_i32_i24 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x13]

v_mul_i32_i24 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x12]

v_mul_i32_i24 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x12]

v_mul_i32_i24 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x12]

v_mul_i32_i24 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x12]

v_mul_i32_i24 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x12]

v_mul_i32_i24 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x12]

v_mul_i32_i24 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x12]

v_mul_i32_i24 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x12]

v_mul_i32_i24 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x12]

v_mul_i32_i24 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x12]

v_mul_i32_i24 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x12]

v_mul_i32_i24 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x12]

v_mul_i32_i24 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x12]

v_mul_i32_i24 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x12]

v_mul_i32_i24 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x12]

v_mul_i32_i24 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x12]

v_mul_i32_i24 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x12]

v_mul_i32_i24 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x12]

v_mul_i32_i24 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x12]

v_mul_i32_i24 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x12]

v_mul_i32_i24 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x12]

v_mul_i32_i24 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x12]

v_mul_i32_i24 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x12]

v_mul_i32_i24 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x12,0x56,0x34,0x12,0xaf]

v_mul_i32_i24 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x12,0x73,0x72,0x71,0x3f]

v_mul_i32_i24 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x12]

v_mul_hi_i32_i24 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x14]

v_mul_hi_i32_i24 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x15]

v_mul_hi_i32_i24 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x14]

v_mul_hi_i32_i24 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x14,0x56,0x34,0x12,0xaf]

v_mul_hi_i32_i24 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x14,0x73,0x72,0x71,0x3f]

v_mul_hi_i32_i24 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x14]

v_mul_u32_u24 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x16]

v_mul_u32_u24 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x17]

v_mul_u32_u24 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x16]

v_mul_u32_u24 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x16]

v_mul_u32_u24 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x16]

v_mul_u32_u24 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x16]

v_mul_u32_u24 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x16]

v_mul_u32_u24 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x16]

v_mul_u32_u24 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x16]

v_mul_u32_u24 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x16]

v_mul_u32_u24 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x16]

v_mul_u32_u24 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x16]

v_mul_u32_u24 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x16]

v_mul_u32_u24 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x16]

v_mul_u32_u24 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x16]

v_mul_u32_u24 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x16]

v_mul_u32_u24 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x16]

v_mul_u32_u24 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x16]

v_mul_u32_u24 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x16]

v_mul_u32_u24 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x16]

v_mul_u32_u24 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x16]

v_mul_u32_u24 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x16]

v_mul_u32_u24 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x16]

v_mul_u32_u24 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x16]

v_mul_u32_u24 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x16]

v_mul_u32_u24 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x16,0x56,0x34,0x12,0xaf]

v_mul_u32_u24 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x16,0x73,0x72,0x71,0x3f]

v_mul_u32_u24 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x16]

v_mul_hi_u32_u24 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x18]

v_mul_hi_u32_u24 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x19]

v_mul_hi_u32_u24 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x18]

v_mul_hi_u32_u24 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x18,0x56,0x34,0x12,0xaf]

v_mul_hi_u32_u24 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x18,0x73,0x72,0x71,0x3f]

v_mul_hi_u32_u24 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x18]

v_min_legacy_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x1a]

v_min_legacy_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x1b]

v_min_legacy_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x1a]

v_min_legacy_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x1a,0x56,0x34,0x12,0xaf]

v_min_legacy_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x1a,0x73,0x72,0x71,0x3f]

v_min_legacy_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x1a]

v_max_legacy_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x1c]

v_max_legacy_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x1d]

v_max_legacy_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x1c]

v_max_legacy_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x1c,0x56,0x34,0x12,0xaf]

v_max_legacy_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x1c,0x73,0x72,0x71,0x3f]

v_max_legacy_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x1c]

v_min_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x1e]

v_min_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x1f]

v_min_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x1e]

v_min_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x1e]

v_min_f32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x1e]

v_min_f32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x1e]

v_min_f32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x1e]

v_min_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x1e]

v_min_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x1e]

v_min_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x1e]

v_min_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x1e]

v_min_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x1e]

v_min_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x1e]

v_min_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x1e]

v_min_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x1e]

v_min_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x1e]

v_min_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x1e]

v_min_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x1e]

v_min_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x1e]

v_min_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x1e]

v_min_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x1e]

v_min_f32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x1e]

v_min_f32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x1e]

v_min_f32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x1e]

v_min_f32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x1e]

v_min_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x1e,0x56,0x34,0x12,0xaf]

v_min_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x1e,0x73,0x72,0x71,0x3f]

v_min_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x1e]

v_max_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x20]

v_max_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x21]

v_max_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x20]

v_max_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x20]

v_max_f32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x20]

v_max_f32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x20]

v_max_f32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x20]

v_max_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x20]

v_max_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x20]

v_max_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x20]

v_max_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x20]

v_max_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x20]

v_max_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x20]

v_max_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x20]

v_max_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x20]

v_max_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x20]

v_max_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x20]

v_max_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x20]

v_max_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x20]

v_max_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x20]

v_max_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x20]

v_max_f32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x20]

v_max_f32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x20]

v_max_f32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x20]

v_max_f32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x20]

v_max_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x20,0x56,0x34,0x12,0xaf]

v_max_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x20,0x73,0x72,0x71,0x3f]

v_max_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x20]

v_min_i32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x22]

v_min_i32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x23]

v_min_i32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x22]

v_min_i32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x22]

v_min_i32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x22]

v_min_i32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x22]

v_min_i32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x22]

v_min_i32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x22]

v_min_i32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x22]

v_min_i32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x22]

v_min_i32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x22]

v_min_i32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x22]

v_min_i32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x22]

v_min_i32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x22]

v_min_i32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x22]

v_min_i32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x22]

v_min_i32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x22]

v_min_i32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x22]

v_min_i32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x22]

v_min_i32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x22]

v_min_i32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x22]

v_min_i32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x22]

v_min_i32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x22]

v_min_i32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x22]

v_min_i32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x22]

v_min_i32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x22,0x56,0x34,0x12,0xaf]

v_min_i32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x22,0x73,0x72,0x71,0x3f]

v_min_i32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x22]

v_max_i32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x24]

v_max_i32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x25]

v_max_i32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x24]

v_max_i32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x24]

v_max_i32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x24]

v_max_i32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x24]

v_max_i32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x24]

v_max_i32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x24]

v_max_i32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x24]

v_max_i32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x24]

v_max_i32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x24]

v_max_i32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x24]

v_max_i32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x24]

v_max_i32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x24]

v_max_i32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x24]

v_max_i32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x24]

v_max_i32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x24]

v_max_i32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x24]

v_max_i32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x24]

v_max_i32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x24]

v_max_i32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x24]

v_max_i32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x24]

v_max_i32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x24]

v_max_i32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x24]

v_max_i32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x24]

v_max_i32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x24,0x56,0x34,0x12,0xaf]

v_max_i32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x24,0x73,0x72,0x71,0x3f]

v_max_i32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x24]

v_min_u32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x26]

v_min_u32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x27]

v_min_u32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x26]

v_min_u32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x26]

v_min_u32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x26]

v_min_u32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x26]

v_min_u32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x26]

v_min_u32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x26]

v_min_u32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x26]

v_min_u32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x26]

v_min_u32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x26]

v_min_u32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x26]

v_min_u32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x26]

v_min_u32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x26]

v_min_u32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x26]

v_min_u32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x26]

v_min_u32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x26]

v_min_u32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x26]

v_min_u32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x26]

v_min_u32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x26]

v_min_u32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x26]

v_min_u32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x26]

v_min_u32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x26]

v_min_u32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x26]

v_min_u32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x26]

v_min_u32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x26,0x56,0x34,0x12,0xaf]

v_min_u32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x26,0x73,0x72,0x71,0x3f]

v_min_u32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x26]

v_max_u32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x28]

v_max_u32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x29]

v_max_u32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x28]

v_max_u32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x28]

v_max_u32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x28]

v_max_u32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x28]

v_max_u32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x28]

v_max_u32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x28]

v_max_u32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x28]

v_max_u32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x28]

v_max_u32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x28]

v_max_u32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x28]

v_max_u32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x28]

v_max_u32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x28]

v_max_u32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x28]

v_max_u32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x28]

v_max_u32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x28]

v_max_u32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x28]

v_max_u32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x28]

v_max_u32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x28]

v_max_u32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x28]

v_max_u32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x28]

v_max_u32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x28]

v_max_u32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x28]

v_max_u32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x28]

v_max_u32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x28,0x56,0x34,0x12,0xaf]

v_max_u32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x28,0x73,0x72,0x71,0x3f]

v_max_u32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x28]

v_lshr_b32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x2a]

v_lshr_b32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x2b]

v_lshr_b32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x2a]

v_lshr_b32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x2a]

v_lshr_b32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x2a]

v_lshr_b32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x2a]

v_lshr_b32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x2a]

v_lshr_b32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x2a]

v_lshr_b32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x2a]

v_lshr_b32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x2a]

v_lshr_b32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x2a]

v_lshr_b32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x2a]

v_lshr_b32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x2a]

v_lshr_b32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x2a]

v_lshr_b32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x2a]

v_lshr_b32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x2a]

v_lshr_b32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x2a]

v_lshr_b32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x2a]

v_lshr_b32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x2a]

v_lshr_b32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x2a]

v_lshr_b32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x2a]

v_lshr_b32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x2a]

v_lshr_b32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x2a]

v_lshr_b32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x2a]

v_lshr_b32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x2a]

v_lshr_b32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x2a,0x56,0x34,0x12,0xaf]

v_lshr_b32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x2a,0x73,0x72,0x71,0x3f]

v_lshr_b32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x2a]

v_lshrrev_b32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x2c]

v_lshrrev_b32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x2d]

v_lshrrev_b32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x2c]

v_lshrrev_b32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x2c,0x56,0x34,0x12,0xaf]

v_lshrrev_b32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x2c,0x73,0x72,0x71,0x3f]

v_lshrrev_b32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x2c]

v_ashr_i32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x2e]

v_ashr_i32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x2f]

v_ashr_i32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x2e]

v_ashr_i32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x2e]

v_ashr_i32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x2e]

v_ashr_i32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x2e]

v_ashr_i32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x2e]

v_ashr_i32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x2e]

v_ashr_i32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x2e]

v_ashr_i32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x2e]

v_ashr_i32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x2e]

v_ashr_i32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x2e]

v_ashr_i32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x2e]

v_ashr_i32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x2e]

v_ashr_i32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x2e]

v_ashr_i32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x2e]

v_ashr_i32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x2e]

v_ashr_i32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x2e]

v_ashr_i32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x2e]

v_ashr_i32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x2e]

v_ashr_i32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x2e]

v_ashr_i32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x2e]

v_ashr_i32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x2e]

v_ashr_i32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x2e]

v_ashr_i32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x2e]

v_ashr_i32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x2e,0x56,0x34,0x12,0xaf]

v_ashr_i32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x2e,0x73,0x72,0x71,0x3f]

v_ashr_i32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x2e]

v_ashrrev_i32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x30]

v_ashrrev_i32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x31]

v_ashrrev_i32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x30]

v_ashrrev_i32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x30]

v_ashrrev_i32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x30]

v_ashrrev_i32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x30]

v_ashrrev_i32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x30]

v_ashrrev_i32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x30]

v_ashrrev_i32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x30]

v_ashrrev_i32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x30]

v_ashrrev_i32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x30]

v_ashrrev_i32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x30]

v_ashrrev_i32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x30]

v_ashrrev_i32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x30]

v_ashrrev_i32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x30]

v_ashrrev_i32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x30]

v_ashrrev_i32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x30]

v_ashrrev_i32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x30]

v_ashrrev_i32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x30]

v_ashrrev_i32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x30]

v_ashrrev_i32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x30]

v_ashrrev_i32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x30]

v_ashrrev_i32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x30]

v_ashrrev_i32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x30]

v_ashrrev_i32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x30,0x56,0x34,0x12,0xaf]

v_ashrrev_i32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x30,0x73,0x72,0x71,0x3f]

v_ashrrev_i32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x30]

v_lshl_b32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x32]

v_lshl_b32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x33]

v_lshl_b32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x32]

v_lshl_b32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x32]

v_lshl_b32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x32]

v_lshl_b32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x32]

v_lshl_b32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x32]

v_lshl_b32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x32]

v_lshl_b32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x32]

v_lshl_b32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x32]

v_lshl_b32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x32]

v_lshl_b32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x32]

v_lshl_b32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x32]

v_lshl_b32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x32]

v_lshl_b32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x32]

v_lshl_b32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x32]

v_lshl_b32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x32]

v_lshl_b32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x32]

v_lshl_b32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x32]

v_lshl_b32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x32]

v_lshl_b32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x32]

v_lshl_b32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x32]

v_lshl_b32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x32]

v_lshl_b32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x32]

v_lshl_b32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x32]

v_lshl_b32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x32,0x56,0x34,0x12,0xaf]

v_lshl_b32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x32,0x73,0x72,0x71,0x3f]

v_lshl_b32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x32]

v_lshlrev_b32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x34]

v_lshlrev_b32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x35]

v_lshlrev_b32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x34]

v_lshlrev_b32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x34]

v_lshlrev_b32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x34]

v_lshlrev_b32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x34]

v_lshlrev_b32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x34]

v_lshlrev_b32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x34]

v_lshlrev_b32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x34]

v_lshlrev_b32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x34]

v_lshlrev_b32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x34]

v_lshlrev_b32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x34]

v_lshlrev_b32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x34]

v_lshlrev_b32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x34]

v_lshlrev_b32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x34]

v_lshlrev_b32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x34]

v_lshlrev_b32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x34]

v_lshlrev_b32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x34]

v_lshlrev_b32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x34]

v_lshlrev_b32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x34]

v_lshlrev_b32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x34]

v_lshlrev_b32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x34]

v_lshlrev_b32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x34]

v_lshlrev_b32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x34]

v_lshlrev_b32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x34,0x56,0x34,0x12,0xaf]

v_lshlrev_b32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x34,0x73,0x72,0x71,0x3f]

v_lshlrev_b32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x34]

v_and_b32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x36]

v_and_b32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x37]

v_and_b32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x36]

v_and_b32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x36]

v_and_b32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x36]

v_and_b32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x36]

v_and_b32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x36]

v_and_b32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x36]

v_and_b32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x36]

v_and_b32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x36]

v_and_b32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x36]

v_and_b32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x36]

v_and_b32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x36]

v_and_b32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x36]

v_and_b32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x36]

v_and_b32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x36]

v_and_b32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x36]

v_and_b32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x36]

v_and_b32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x36]

v_and_b32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x36]

v_and_b32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x36]

v_and_b32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x36]

v_and_b32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x36]

v_and_b32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x36]

v_and_b32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x36]

v_and_b32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x36,0x56,0x34,0x12,0xaf]

v_and_b32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x36,0x73,0x72,0x71,0x3f]

v_and_b32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x36]

v_or_b32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x38]

v_or_b32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x39]

v_or_b32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x38]

v_or_b32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x38]

v_or_b32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x38]

v_or_b32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x38]

v_or_b32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x38]

v_or_b32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x38]

v_or_b32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x38]

v_or_b32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x38]

v_or_b32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x38]

v_or_b32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x38]

v_or_b32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x38]

v_or_b32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x38]

v_or_b32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x38]

v_or_b32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x38]

v_or_b32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x38]

v_or_b32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x38]

v_or_b32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x38]

v_or_b32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x38]

v_or_b32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x38]

v_or_b32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x38]

v_or_b32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x38]

v_or_b32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x38]

v_or_b32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x38]

v_or_b32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x38,0x56,0x34,0x12,0xaf]

v_or_b32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x38,0x73,0x72,0x71,0x3f]

v_or_b32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x38]

v_xor_b32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x3a]

v_xor_b32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x3b]

v_xor_b32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x3a]

v_xor_b32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x3a]

v_xor_b32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x3a]

v_xor_b32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x3a]

v_xor_b32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x3a]

v_xor_b32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x3a]

v_xor_b32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x3a]

v_xor_b32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x3a]

v_xor_b32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x3a]

v_xor_b32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x3a]

v_xor_b32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x3a]

v_xor_b32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x3a]

v_xor_b32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x3a]

v_xor_b32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x3a]

v_xor_b32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x3a]

v_xor_b32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x3a]

v_xor_b32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x3a]

v_xor_b32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x3a]

v_xor_b32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x3a]

v_xor_b32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x3a]

v_xor_b32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x3a]

v_xor_b32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x3a]

v_xor_b32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x3a]

v_xor_b32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x3a,0x56,0x34,0x12,0xaf]

v_xor_b32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x3a,0x73,0x72,0x71,0x3f]

v_xor_b32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x3a]

v_bfm_b32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x3c]

v_bfm_b32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x3d]

v_bfm_b32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x3c]

v_bfm_b32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x3c]

v_bfm_b32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x3c]

v_bfm_b32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x3c]

v_bfm_b32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x3c]

v_bfm_b32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x3c]

v_bfm_b32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x3c]

v_bfm_b32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x3c]

v_bfm_b32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x3c]

v_bfm_b32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x3c]

v_bfm_b32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x3c]

v_bfm_b32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x3c]

v_bfm_b32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x3c]

v_bfm_b32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x3c]

v_bfm_b32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x3c]

v_bfm_b32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x3c]

v_bfm_b32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x3c]

v_bfm_b32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x3c]

v_bfm_b32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x3c]

v_bfm_b32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x3c]

v_bfm_b32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x3c]

v_bfm_b32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x3c]

v_bfm_b32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x3c]

v_bfm_b32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x3c,0x56,0x34,0x12,0xaf]

v_bfm_b32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x3c,0x73,0x72,0x71,0x3f]

v_bfm_b32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x3c]

v_mac_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x3e]

v_mac_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x3f]

v_mac_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x3e]

v_mac_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x3e]

v_mac_f32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x3e]

v_mac_f32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x3e]

v_mac_f32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x3e]

v_mac_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x3e]

v_mac_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x3e]

v_mac_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x3e]

v_mac_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x3e]

v_mac_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x3e]

v_mac_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x3e]

v_mac_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x3e]

v_mac_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x3e]

v_mac_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x3e]

v_mac_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x3e]

v_mac_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x3e]

v_mac_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x3e]

v_mac_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x3e]

v_mac_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x3e]

v_mac_f32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x3e]

v_mac_f32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x3e]

v_mac_f32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x3e]

v_mac_f32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x3e]

v_mac_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x3e,0x56,0x34,0x12,0xaf]

v_mac_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x3e,0x73,0x72,0x71,0x3f]

v_mac_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x3e]

v_madmk_f32 v5, v1, 0x11213141, v3
// CHECK: [0x01,0x07,0x0a,0x40,0x41,0x31,0x21,0x11]

v_madmk_f32 v255, v1, 0x11213141, v3
// CHECK: [0x01,0x07,0xfe,0x41,0x41,0x31,0x21,0x11]

v_madmk_f32 v5, v255, 0x11213141, v3
// CHECK: [0xff,0x07,0x0a,0x40,0x41,0x31,0x21,0x11]

v_madmk_f32 v5, 0, 0x11213141, v3
// CHECK: [0x80,0x06,0x0a,0x40,0x41,0x31,0x21,0x11]

v_madmk_f32 v5, -1, 0x11213141, v3
// CHECK: [0xc1,0x06,0x0a,0x40,0x41,0x31,0x21,0x11]

v_madmk_f32 v5, 0.5, 0x11213141, v3
// CHECK: [0xf0,0x06,0x0a,0x40,0x41,0x31,0x21,0x11]

v_madmk_f32 v5, -4.0, 0x11213141, v3
// CHECK: [0xf7,0x06,0x0a,0x40,0x41,0x31,0x21,0x11]

v_madmk_f32 v5, src_lds_direct, 0x11213141, v3
// CHECK: [0xfe,0x06,0x0a,0x40,0x41,0x31,0x21,0x11]

v_madmk_f32 v5, v1, 0xa1b1c1d1, v3
// CHECK: [0x01,0x07,0x0a,0x40,0xd1,0xc1,0xb1,0xa1]

v_madmk_f32 v5, v1, 0x11213141, v255
// CHECK: [0x01,0xff,0x0b,0x40,0x41,0x31,0x21,0x11]

v_madak_f32 v5, v1, v2, 0x11213141
// CHECK: [0x01,0x05,0x0a,0x42,0x41,0x31,0x21,0x11]

v_madak_f32 v255, v1, v2, 0x11213141
// CHECK: [0x01,0x05,0xfe,0x43,0x41,0x31,0x21,0x11]

v_madak_f32 v5, v255, v2, 0x11213141
// CHECK: [0xff,0x05,0x0a,0x42,0x41,0x31,0x21,0x11]

v_madak_f32 v5, 0, v2, 0x11213141
// CHECK: [0x80,0x04,0x0a,0x42,0x41,0x31,0x21,0x11]

v_madak_f32 v5, -1, v2, 0x11213141
// CHECK: [0xc1,0x04,0x0a,0x42,0x41,0x31,0x21,0x11]

v_madak_f32 v5, 0.5, v2, 0x11213141
// CHECK: [0xf0,0x04,0x0a,0x42,0x41,0x31,0x21,0x11]

v_madak_f32 v5, -4.0, v2, 0x11213141
// CHECK: [0xf7,0x04,0x0a,0x42,0x41,0x31,0x21,0x11]

v_madak_f32 v5, src_lds_direct, v2, 0x11213141
// CHECK: [0xfe,0x04,0x0a,0x42,0x41,0x31,0x21,0x11]

v_madak_f32 v5, v1, v255, 0x11213141
// CHECK: [0x01,0xff,0x0b,0x42,0x41,0x31,0x21,0x11]

v_madak_f32 v5, v1, v2, 0xa1b1c1d1
// CHECK: [0x01,0x05,0x0a,0x42,0xd1,0xc1,0xb1,0xa1]

v_bcnt_u32_b32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x44]

v_bcnt_u32_b32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x45]

v_bcnt_u32_b32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x44]

v_bcnt_u32_b32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x44,0x56,0x34,0x12,0xaf]

v_bcnt_u32_b32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x44,0x73,0x72,0x71,0x3f]

v_bcnt_u32_b32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x44]

v_mbcnt_lo_u32_b32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x46]

v_mbcnt_lo_u32_b32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x47]

v_mbcnt_lo_u32_b32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x46,0x56,0x34,0x12,0xaf]

v_mbcnt_lo_u32_b32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x46,0x73,0x72,0x71,0x3f]

v_mbcnt_lo_u32_b32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x46]

v_mbcnt_hi_u32_b32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x48]

v_mbcnt_hi_u32_b32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x49]

v_mbcnt_hi_u32_b32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x48,0x56,0x34,0x12,0xaf]

v_mbcnt_hi_u32_b32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x48,0x73,0x72,0x71,0x3f]

v_mbcnt_hi_u32_b32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x48]

v_add_i32 v5, vcc, v1, v2
// CHECK: [0x01,0x05,0x0a,0x4a]

v_add_i32 v255, vcc, v1, v2
// CHECK: [0x01,0x05,0xfe,0x4b]

v_add_i32 v5, vcc, v255, v2
// CHECK: [0xff,0x05,0x0a,0x4a]

v_add_i32 v5, vcc, s1, v2
// CHECK: [0x01,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, s103, v2
// CHECK: [0x67,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, 0, v2
// CHECK: [0x80,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x4a,0x56,0x34,0x12,0xaf]

v_add_i32 v5, vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x4a,0x73,0x72,0x71,0x3f]

v_add_i32 v5, vcc, v1, v255
// CHECK: [0x01,0xff,0x0b,0x4a]

v_sub_i32 v5, vcc, v1, v2
// CHECK: [0x01,0x05,0x0a,0x4c]

v_sub_i32 v255, vcc, v1, v2
// CHECK: [0x01,0x05,0xfe,0x4d]

v_sub_i32 v5, vcc, v255, v2
// CHECK: [0xff,0x05,0x0a,0x4c]

v_sub_i32 v5, vcc, s1, v2
// CHECK: [0x01,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, s103, v2
// CHECK: [0x67,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, 0, v2
// CHECK: [0x80,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x4c,0x56,0x34,0x12,0xaf]

v_sub_i32 v5, vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x4c,0x73,0x72,0x71,0x3f]

v_sub_i32 v5, vcc, v1, v255
// CHECK: [0x01,0xff,0x0b,0x4c]

v_subrev_i32 v5, vcc, v1, v2
// CHECK: [0x01,0x05,0x0a,0x4e]

v_subrev_i32 v255, vcc, v1, v2
// CHECK: [0x01,0x05,0xfe,0x4f]

v_subrev_i32 v5, vcc, v255, v2
// CHECK: [0xff,0x05,0x0a,0x4e]

v_subrev_i32 v5, vcc, s1, v2
// CHECK: [0x01,0x04,0x0a,0x4e]

v_subrev_i32 v5, vcc, s103, v2
// CHECK: [0x67,0x04,0x0a,0x4e]

v_subrev_i32 v5, vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x4e]

v_subrev_i32 v5, vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x4e]

v_subrev_i32 v5, vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x4e]

v_subrev_i32 v5, vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x4e]

v_subrev_i32 v5, vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x4e]

v_subrev_i32 v5, vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x4e]

v_subrev_i32 v5, vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x4e]

v_subrev_i32 v5, vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x4e]

v_subrev_i32 v5, vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x4e]

v_subrev_i32 v5, vcc, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x4e]

v_subrev_i32 v5, vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x4e]

v_subrev_i32 v5, vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x4e]

v_subrev_i32 v5, vcc, 0, v2
// CHECK: [0x80,0x04,0x0a,0x4e]

v_subrev_i32 v5, vcc, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x4e]

v_subrev_i32 v5, vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x4e]

v_subrev_i32 v5, vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x4e]

v_subrev_i32 v5, vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x4e]

v_subrev_i32 v5, vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x4e]

v_subrev_i32 v5, vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x4e]

v_subrev_i32 v5, vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x4e,0x56,0x34,0x12,0xaf]

v_subrev_i32 v5, vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x4e,0x73,0x72,0x71,0x3f]

v_subrev_i32 v5, vcc, v1, v255
// CHECK: [0x01,0xff,0x0b,0x4e]

v_addc_u32 v5, vcc, v1, v2, vcc
// CHECK: [0x01,0x05,0x0a,0x50]

v_addc_u32 v255, vcc, v1, v2, vcc
// CHECK: [0x01,0x05,0xfe,0x51]

v_addc_u32 v5, vcc, v255, v2, vcc
// CHECK: [0xff,0x05,0x0a,0x50]

v_addc_u32 v5, vcc, 0, v2, vcc
// CHECK: [0x80,0x04,0x0a,0x50]

v_addc_u32 v5, vcc, -1, v2, vcc
// CHECK: [0xc1,0x04,0x0a,0x50]

v_addc_u32 v5, vcc, 0.5, v2, vcc
// CHECK: [0xf0,0x04,0x0a,0x50]

v_addc_u32 v5, vcc, -4.0, v2, vcc
// CHECK: [0xf7,0x04,0x0a,0x50]

v_addc_u32 v5, vcc, src_lds_direct, v2, vcc
// CHECK: [0xfe,0x04,0x0a,0x50]

v_addc_u32 v5, vcc, v1, v255, vcc
// CHECK: [0x01,0xff,0x0b,0x50]

v_subb_u32 v5, vcc, v1, v2, vcc
// CHECK: [0x01,0x05,0x0a,0x52]

v_subb_u32 v255, vcc, v1, v2, vcc
// CHECK: [0x01,0x05,0xfe,0x53]

v_subb_u32 v5, vcc, v255, v2, vcc
// CHECK: [0xff,0x05,0x0a,0x52]

v_subb_u32 v5, vcc, 0, v2, vcc
// CHECK: [0x80,0x04,0x0a,0x52]

v_subb_u32 v5, vcc, -1, v2, vcc
// CHECK: [0xc1,0x04,0x0a,0x52]

v_subb_u32 v5, vcc, 0.5, v2, vcc
// CHECK: [0xf0,0x04,0x0a,0x52]

v_subb_u32 v5, vcc, -4.0, v2, vcc
// CHECK: [0xf7,0x04,0x0a,0x52]

v_subb_u32 v5, vcc, src_lds_direct, v2, vcc
// CHECK: [0xfe,0x04,0x0a,0x52]

v_subb_u32 v5, vcc, v1, v255, vcc
// CHECK: [0x01,0xff,0x0b,0x52]

v_subbrev_u32 v5, vcc, v1, v2, vcc
// CHECK: [0x01,0x05,0x0a,0x54]

v_subbrev_u32 v255, vcc, v1, v2, vcc
// CHECK: [0x01,0x05,0xfe,0x55]

v_subbrev_u32 v5, vcc, v255, v2, vcc
// CHECK: [0xff,0x05,0x0a,0x54]

v_subbrev_u32 v5, vcc, 0, v2, vcc
// CHECK: [0x80,0x04,0x0a,0x54]

v_subbrev_u32 v5, vcc, -1, v2, vcc
// CHECK: [0xc1,0x04,0x0a,0x54]

v_subbrev_u32 v5, vcc, 0.5, v2, vcc
// CHECK: [0xf0,0x04,0x0a,0x54]

v_subbrev_u32 v5, vcc, -4.0, v2, vcc
// CHECK: [0xf7,0x04,0x0a,0x54]

v_subbrev_u32 v5, vcc, v1, v255, vcc
// CHECK: [0x01,0xff,0x0b,0x54]

v_ldexp_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x56]

v_ldexp_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x57]

v_ldexp_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x56]

v_ldexp_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x56]

v_ldexp_f32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x56]

v_ldexp_f32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x56]

v_ldexp_f32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x56]

v_ldexp_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x56]

v_ldexp_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x56]

v_ldexp_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x56]

v_ldexp_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x56]

v_ldexp_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x56]

v_ldexp_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x56]

v_ldexp_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x56]

v_ldexp_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x56]

v_ldexp_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x56]

v_ldexp_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x56]

v_ldexp_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x56]

v_ldexp_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x56]

v_ldexp_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x56]

v_ldexp_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x56]

v_ldexp_f32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x56]

v_ldexp_f32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x56]

v_ldexp_f32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x56]

v_ldexp_f32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x56]

v_ldexp_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x56,0x56,0x34,0x12,0xaf]

v_ldexp_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x56,0x73,0x72,0x71,0x3f]

v_ldexp_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x56]

v_cvt_pkaccum_u8_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x58]

v_cvt_pkaccum_u8_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x59]

v_cvt_pkaccum_u8_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x58]

v_cvt_pkaccum_u8_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x58]

v_cvt_pkaccum_u8_f32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x58]

v_cvt_pkaccum_u8_f32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x58]

v_cvt_pkaccum_u8_f32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x58]

v_cvt_pkaccum_u8_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x58]

v_cvt_pkaccum_u8_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x58]

v_cvt_pkaccum_u8_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x58]

v_cvt_pkaccum_u8_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x58]

v_cvt_pkaccum_u8_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x58]

v_cvt_pkaccum_u8_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x58]

v_cvt_pkaccum_u8_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x58]

v_cvt_pkaccum_u8_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x58]

v_cvt_pkaccum_u8_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x58]

v_cvt_pkaccum_u8_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x58]

v_cvt_pkaccum_u8_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x58]

v_cvt_pkaccum_u8_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x58]

v_cvt_pkaccum_u8_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x58]

v_cvt_pkaccum_u8_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x58]

v_cvt_pkaccum_u8_f32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x58]

v_cvt_pkaccum_u8_f32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x58]

v_cvt_pkaccum_u8_f32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x58]

v_cvt_pkaccum_u8_f32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x58]

v_cvt_pkaccum_u8_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x58,0x56,0x34,0x12,0xaf]

v_cvt_pkaccum_u8_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x58,0x73,0x72,0x71,0x3f]

v_cvt_pkaccum_u8_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x58]

v_cvt_pknorm_i16_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x5a]

v_cvt_pknorm_i16_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x5b]

v_cvt_pknorm_i16_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x5a]

v_cvt_pknorm_i16_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x5a]

v_cvt_pknorm_i16_f32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x5a]

v_cvt_pknorm_i16_f32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x5a]

v_cvt_pknorm_i16_f32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x5a]

v_cvt_pknorm_i16_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x5a]

v_cvt_pknorm_i16_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x5a]

v_cvt_pknorm_i16_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x5a]

v_cvt_pknorm_i16_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x5a]

v_cvt_pknorm_i16_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x5a]

v_cvt_pknorm_i16_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x5a]

v_cvt_pknorm_i16_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x5a]

v_cvt_pknorm_i16_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x5a]

v_cvt_pknorm_i16_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x5a]

v_cvt_pknorm_i16_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x5a]

v_cvt_pknorm_i16_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x5a]

v_cvt_pknorm_i16_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x5a]

v_cvt_pknorm_i16_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x5a]

v_cvt_pknorm_i16_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x5a]

v_cvt_pknorm_i16_f32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x5a]

v_cvt_pknorm_i16_f32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x5a]

v_cvt_pknorm_i16_f32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x5a]

v_cvt_pknorm_i16_f32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x5a]

v_cvt_pknorm_i16_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x5a,0x56,0x34,0x12,0xaf]

v_cvt_pknorm_i16_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x5a,0x73,0x72,0x71,0x3f]

v_cvt_pknorm_i16_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x5a]

v_cvt_pknorm_u16_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x5c]

v_cvt_pknorm_u16_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x5d]

v_cvt_pknorm_u16_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x5c]

v_cvt_pknorm_u16_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x5c]

v_cvt_pknorm_u16_f32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x5c]

v_cvt_pknorm_u16_f32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x5c]

v_cvt_pknorm_u16_f32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x5c]

v_cvt_pknorm_u16_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x5c]

v_cvt_pknorm_u16_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x5c]

v_cvt_pknorm_u16_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x5c]

v_cvt_pknorm_u16_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x5c]

v_cvt_pknorm_u16_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x5c]

v_cvt_pknorm_u16_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x5c]

v_cvt_pknorm_u16_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x5c]

v_cvt_pknorm_u16_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x5c]

v_cvt_pknorm_u16_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x5c]

v_cvt_pknorm_u16_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x5c]

v_cvt_pknorm_u16_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x5c]

v_cvt_pknorm_u16_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x5c]

v_cvt_pknorm_u16_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x5c]

v_cvt_pknorm_u16_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x5c]

v_cvt_pknorm_u16_f32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x5c]

v_cvt_pknorm_u16_f32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x5c]

v_cvt_pknorm_u16_f32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x5c]

v_cvt_pknorm_u16_f32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x5c]

v_cvt_pknorm_u16_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x5c,0x56,0x34,0x12,0xaf]

v_cvt_pknorm_u16_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x5c,0x73,0x72,0x71,0x3f]

v_cvt_pknorm_u16_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x5c]

v_cvt_pkrtz_f16_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x5f]

v_cvt_pkrtz_f16_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x5e,0x56,0x34,0x12,0xaf]

v_cvt_pkrtz_f16_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x5e,0x73,0x72,0x71,0x3f]

v_cvt_pkrtz_f16_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x5e]

v_cvt_pk_u16_u32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x60]

v_cvt_pk_u16_u32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x61]

v_cvt_pk_u16_u32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x60]

v_cvt_pk_u16_u32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x60]

v_cvt_pk_u16_u32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x60]

v_cvt_pk_u16_u32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x60]

v_cvt_pk_u16_u32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x60]

v_cvt_pk_u16_u32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x60]

v_cvt_pk_u16_u32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x60]

v_cvt_pk_u16_u32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x60]

v_cvt_pk_u16_u32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x60]

v_cvt_pk_u16_u32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x60]

v_cvt_pk_u16_u32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x60]

v_cvt_pk_u16_u32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x60]

v_cvt_pk_u16_u32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x60]

v_cvt_pk_u16_u32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x60]

v_cvt_pk_u16_u32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x60]

v_cvt_pk_u16_u32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x60]

v_cvt_pk_u16_u32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x60]

v_cvt_pk_u16_u32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x60]

v_cvt_pk_u16_u32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x60]

v_cvt_pk_u16_u32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x60]

v_cvt_pk_u16_u32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x60]

v_cvt_pk_u16_u32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x60]

v_cvt_pk_u16_u32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x60]

v_cvt_pk_u16_u32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x60,0x56,0x34,0x12,0xaf]

v_cvt_pk_u16_u32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x60,0x73,0x72,0x71,0x3f]

v_cvt_pk_u16_u32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x60]

v_cvt_pk_i16_i32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x62]

v_cvt_pk_i16_i32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x63]

v_cvt_pk_i16_i32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x62]

v_cvt_pk_i16_i32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x62]

v_cvt_pk_i16_i32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x62]

v_cvt_pk_i16_i32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x62]

v_cvt_pk_i16_i32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x62]

v_cvt_pk_i16_i32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x62]

v_cvt_pk_i16_i32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x62]

v_cvt_pk_i16_i32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x62]

v_cvt_pk_i16_i32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x62]

v_cvt_pk_i16_i32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x62]

v_cvt_pk_i16_i32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x62]

v_cvt_pk_i16_i32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x62]

v_cvt_pk_i16_i32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x62]

v_cvt_pk_i16_i32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x62]

v_cvt_pk_i16_i32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x62]

v_cvt_pk_i16_i32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x62]

v_cvt_pk_i16_i32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x62]

v_cvt_pk_i16_i32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x62]

v_cvt_pk_i16_i32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x62]

v_cvt_pk_i16_i32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x62]

v_cvt_pk_i16_i32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x62]

v_cvt_pk_i16_i32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x62]

v_cvt_pk_i16_i32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x62]

v_cvt_pk_i16_i32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x62,0x56,0x34,0x12,0xaf]

v_cvt_pk_i16_i32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x62,0x73,0x72,0x71,0x3f]

v_cvt_pk_i16_i32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x62]
