; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2                                   | FileCheck %s --check-prefixes=CHECK,SSE,SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.2                                 | FileCheck %s --check-prefixes=CHECK,SSE,SSE42
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx                                    | FileCheck %s --check-prefixes=CHECK,AVX,AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2                                   | FileCheck %s --check-prefixes=CHECK,AVX,AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512vl                      | FileCheck %s --check-prefixes=CHECK,AVX,AVX512,AVX512F
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512vl,+avx512dq,+avx512bw  | FileCheck %s --check-prefixes=CHECK,AVX,AVX512,AVX512DQBW

; Lower common integer comparisons such as 'isPositive' efficiently:
; https://llvm.org/bugs/show_bug.cgi?id=26701

define <16 x i8> @test_pcmpgtb(<16 x i8> %x) {
; SSE-LABEL: test_pcmpgtb:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE-NEXT:    pcmpgtb %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_pcmpgtb:
; AVX:       # %bb.0:
; AVX-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vpcmpgtb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %sign = ashr <16 x i8> %x, <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7>
  %not = xor <16 x i8> %sign, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  ret <16 x i8> %not
}

define <8 x i16> @test_pcmpgtw(<8 x i16> %x) {
; SSE-LABEL: test_pcmpgtw:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE-NEXT:    pcmpgtw %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_pcmpgtw:
; AVX:       # %bb.0:
; AVX-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vpcmpgtw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %sign = ashr <8 x i16> %x, <i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15>
  %not = xor <8 x i16> %sign, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>
  ret <8 x i16> %not
}

define <4 x i32> @test_pcmpgtd(<4 x i32> %x) {
; SSE-LABEL: test_pcmpgtd:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE-NEXT:    pcmpgtd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_pcmpgtd:
; AVX:       # %bb.0:
; AVX-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vpcmpgtd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %sign = ashr <4 x i32> %x, <i32 31, i32 31, i32 31, i32 31>
  %not = xor <4 x i32> %sign, <i32 -1, i32 -1, i32 -1, i32 -1>
  ret <4 x i32> %not
}

define <2 x i64> @test_pcmpgtq(<2 x i64> %x) {
; SSE2-LABEL: test_pcmpgtq:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: test_pcmpgtq:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE42-NEXT:    pcmpgtq %xmm1, %xmm0
; SSE42-NEXT:    retq
;
; AVX-LABEL: test_pcmpgtq:
; AVX:       # %bb.0:
; AVX-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %sign = ashr <2 x i64> %x, <i64 63, i64 63>
  %not = xor <2 x i64> %sign, <i64 -1, i64 -1>
  ret <2 x i64> %not
}

define <1 x i128> @test_strange_type(<1 x i128> %x) {
; CHECK-LABEL: test_strange_type:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %rax
; CHECK-NEXT:    sarq $63, %rax
; CHECK-NEXT:    notq %rax
; CHECK-NEXT:    movq %rax, %rdx
; CHECK-NEXT:    retq
  %sign = ashr <1 x i128> %x, <i128 127>
  %not = xor <1 x i128> %sign, <i128 -1>
  ret <1 x i128> %not
}

define <32 x i8> @test_pcmpgtb_256(<32 x i8> %x) {
; SSE-LABEL: test_pcmpgtb_256:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE-NEXT:    pcmpgtb %xmm2, %xmm0
; SSE-NEXT:    pcmpgtb %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test_pcmpgtb_256:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpgtb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpcmpgtb %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vcmptrueps %ymm1, %ymm1, %ymm1
; AVX1-NEXT:    vxorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_pcmpgtb_256:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpgtb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_pcmpgtb_256:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512-NEXT:    vpcmpgtb %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %sign = ashr <32 x i8> %x, <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7>
  %not = xor <32 x i8> %sign, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  ret <32 x i8> %not
}

define <16 x i16> @test_pcmpgtw_256(<16 x i16> %x) {
; SSE-LABEL: test_pcmpgtw_256:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE-NEXT:    pcmpgtw %xmm2, %xmm0
; SSE-NEXT:    pcmpgtw %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test_pcmpgtw_256:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsraw $15, %xmm0, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpsraw $15, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vcmptrueps %ymm1, %ymm1, %ymm1
; AVX1-NEXT:    vxorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_pcmpgtw_256:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpgtw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_pcmpgtw_256:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512-NEXT:    vpcmpgtw %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %sign = ashr <16 x i16> %x, <i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15>
  %not = xor <16 x i16> %sign, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>
  ret <16 x i16> %not
}

define <8 x i32> @test_pcmpgtd_256(<8 x i32> %x) {
; SSE-LABEL: test_pcmpgtd_256:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE-NEXT:    pcmpgtd %xmm2, %xmm0
; SSE-NEXT:    pcmpgtd %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test_pcmpgtd_256:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsrad $31, %xmm0, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vcmptrueps %ymm1, %ymm1, %ymm1
; AVX1-NEXT:    vxorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_pcmpgtd_256:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_pcmpgtd_256:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %sign = ashr <8 x i32> %x, <i32 31, i32 31, i32 31, i32 31, i32 31, i32 31, i32 31, i32 31>
  %not = xor <8 x i32> %sign, <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>
  ret <8 x i32> %not
}

define <4 x i64> @test_pcmpgtq_256(<4 x i64> %x) {
; SSE2-LABEL: test_pcmpgtq_256:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm1
; SSE2-NEXT:    retq
;
; SSE42-LABEL: test_pcmpgtq_256:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE42-NEXT:    pcmpgtq %xmm2, %xmm0
; SSE42-NEXT:    pcmpgtq %xmm2, %xmm1
; SSE42-NEXT:    retq
;
; AVX1-LABEL: test_pcmpgtq_256:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vcmptrueps %ymm1, %ymm1, %ymm1
; AVX1-NEXT:    vxorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_pcmpgtq_256:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_pcmpgtq_256:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %sign = ashr <4 x i64> %x, <i64 63, i64 63, i64 63, i64 63>
  %not = xor <4 x i64> %sign, <i64 -1, i64 -1, i64 -1, i64 -1>
  ret <4 x i64> %not
}

define <16 x i8> @cmpeq_zext_v16i8(<16 x i8> %a, <16 x i8> %b) {
; SSE-LABEL: cmpeq_zext_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqb %xmm1, %xmm0
; SSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: cmpeq_zext_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpcmpeqb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: cmpeq_zext_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: cmpeq_zext_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqb %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm0
; AVX512-NEXT:    retq
  %cmp = icmp eq <16 x i8> %a, %b
  %zext = zext <16 x i1> %cmp to <16 x i8>
  ret <16 x i8> %zext
}

define <16 x i16> @cmpeq_zext_v16i16(<16 x i16> %a, <16 x i16> %b) {
; SSE-LABEL: cmpeq_zext_v16i16:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqw %xmm2, %xmm0
; SSE-NEXT:    psrlw $15, %xmm0
; SSE-NEXT:    pcmpeqw %xmm3, %xmm1
; SSE-NEXT:    psrlw $15, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: cmpeq_zext_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpcmpeqw %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpcmpeqw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: cmpeq_zext_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlw $15, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: cmpeq_zext_v16i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqw %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpsrlw $15, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %cmp = icmp eq <16 x i16> %a, %b
  %zext = zext <16 x i1> %cmp to <16 x i16>
  ret <16 x i16> %zext
}

define <4 x i32> @cmpeq_zext_v4i32(<4 x i32> %a, <4 x i32> %b) {
; SSE-LABEL: cmpeq_zext_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE-NEXT:    psrld $31, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: cmpeq_zext_v4i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpcmpeqd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpsrld $31, %xmm0, %xmm0
; AVX-NEXT:    retq
  %cmp = icmp eq <4 x i32> %a, %b
  %zext = zext <4 x i1> %cmp to <4 x i32>
  ret <4 x i32> %zext
}

define <4 x i64> @cmpeq_zext_v4i64(<4 x i64> %a, <4 x i64> %b) {
; SSE2-LABEL: cmpeq_zext_v4i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[1,0,3,2]
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [1,1]
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm3, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[1,0,3,2]
; SSE2-NEXT:    pand %xmm3, %xmm1
; SSE2-NEXT:    pand %xmm2, %xmm1
; SSE2-NEXT:    retq
;
; SSE42-LABEL: cmpeq_zext_v4i64:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pcmpeqq %xmm2, %xmm0
; SSE42-NEXT:    psrlq $63, %xmm0
; SSE42-NEXT:    pcmpeqq %xmm3, %xmm1
; SSE42-NEXT:    psrlq $63, %xmm1
; SSE42-NEXT:    retq
;
; AVX1-LABEL: cmpeq_zext_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpcmpeqq %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpcmpeqq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: cmpeq_zext_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlq $63, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: cmpeq_zext_v4i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqq %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpsrlq $63, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %cmp = icmp eq <4 x i64> %a, %b
  %zext = zext <4 x i1> %cmp to <4 x i64>
  ret <4 x i64> %zext
}

define <32 x i8> @cmpgt_zext_v32i8(<32 x i8> %a, <32 x i8> %b) {
; SSE-LABEL: cmpgt_zext_v32i8:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpgtb %xmm2, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    pcmpgtb %xmm3, %xmm1
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: cmpgt_zext_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpcmpgtb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpcmpgtb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: cmpgt_zext_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpgtb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: cmpgt_zext_v32i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpgtb %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %cmp = icmp sgt <32 x i8> %a, %b
  %zext = zext <32 x i1> %cmp to <32 x i8>
  ret <32 x i8> %zext
}

define <8 x i16> @cmpgt_zext_v8i16(<8 x i16> %a, <8 x i16> %b) {
; SSE-LABEL: cmpgt_zext_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpgtw %xmm1, %xmm0
; SSE-NEXT:    psrlw $15, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: cmpgt_zext_v8i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpcmpgtw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpsrlw $15, %xmm0, %xmm0
; AVX-NEXT:    retq
  %cmp = icmp sgt <8 x i16> %a, %b
  %zext = zext <8 x i1> %cmp to <8 x i16>
  ret <8 x i16> %zext
}

define <8 x i32> @cmpgt_zext_v8i32(<8 x i32> %a, <8 x i32> %b) {
; SSE-LABEL: cmpgt_zext_v8i32:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpgtd %xmm2, %xmm0
; SSE-NEXT:    psrld $31, %xmm0
; SSE-NEXT:    pcmpgtd %xmm3, %xmm1
; SSE-NEXT:    psrld $31, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: cmpgt_zext_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpcmpgtd %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpcmpgtd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: cmpgt_zext_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpsrld $31, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: cmpgt_zext_v8i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpsrld $31, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %cmp = icmp sgt <8 x i32> %a, %b
  %zext = zext <8 x i1> %cmp to <8 x i32>
  ret <8 x i32> %zext
}

define <2 x i64> @cmpgt_zext_v2i64(<2 x i64> %a, <2 x i64> %b) {
; SSE2-LABEL: cmpgt_zext_v2i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648]
; SSE2-NEXT:    pxor %xmm2, %xmm1
; SSE2-NEXT:    pxor %xmm2, %xmm0
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,3,3]
; SSE2-NEXT:    pand %xmm2, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[1,1,3,3]
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: cmpgt_zext_v2i64:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pcmpgtq %xmm1, %xmm0
; SSE42-NEXT:    psrlq $63, %xmm0
; SSE42-NEXT:    retq
;
; AVX-LABEL: cmpgt_zext_v2i64:
; AVX:       # %bb.0:
; AVX-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpsrlq $63, %xmm0, %xmm0
; AVX-NEXT:    retq
  %cmp = icmp sgt <2 x i64> %a, %b
  %zext = zext <2 x i1> %cmp to <2 x i64>
  ret <2 x i64> %zext
}

; Test that we optimize a zext of a vector setcc ne zero where all bits but the
; lsb are known to be zero.
define <8 x i32> @cmpne_knownzeros_zext_v8i16_v8i32(<8 x i16> %x) {
; SSE2-LABEL: cmpne_knownzeros_zext_v8i16_v8i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrlw $15, %xmm1
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; SSE2-NEXT:    retq
;
; SSE42-LABEL: cmpne_knownzeros_zext_v8i16_v8i32:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movdqa %xmm0, %xmm1
; SSE42-NEXT:    psrlw $15, %xmm1
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pmovzxwd {{.*#+}} xmm0 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero
; SSE42-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; SSE42-NEXT:    retq
;
; AVX1-LABEL: cmpne_knownzeros_zext_v8i16_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsrlw $15, %xmm0, %xmm0
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; AVX1-NEXT:    vpmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: cmpne_knownzeros_zext_v8i16_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsrlw $15, %xmm0, %xmm0
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    retq
;
; AVX512-LABEL: cmpne_knownzeros_zext_v8i16_v8i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsrlw $15, %xmm0, %xmm0
; AVX512-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX512-NEXT:    retq
  %a = lshr <8 x i16> %x, <i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15>
  %b = icmp ne <8 x i16> %a, zeroinitializer
  %c = zext <8 x i1> %b to <8 x i32>
  ret <8 x i32> %c
}

define <8 x i32> @cmpne_knownzeros_zext_v8i32_v8i32(<8 x i32> %x) {
; SSE-LABEL: cmpne_knownzeros_zext_v8i32_v8i32:
; SSE:       # %bb.0:
; SSE-NEXT:    psrld $31, %xmm0
; SSE-NEXT:    psrld $31, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: cmpne_knownzeros_zext_v8i32_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsrld $31, %xmm0, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpsrld $31, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: cmpne_knownzeros_zext_v8i32_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsrld $31, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: cmpne_knownzeros_zext_v8i32_v8i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsrld $31, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %a = lshr <8 x i32> %x, <i32 31, i32 31, i32 31, i32 31, i32 31, i32 31, i32 31, i32 31>
  %b = icmp ne <8 x i32> %a, zeroinitializer
  %c = zext <8 x i1> %b to <8 x i32>
  ret <8 x i32> %c
}

define <8 x i16> @cmpne_knownzeros_zext_v8i32_v8i16(<8 x i32> %x) {
; SSE2-LABEL: cmpne_knownzeros_zext_v8i32_v8i16:
; SSE2:       # %bb.0:
; SSE2-NEXT:    psrld $31, %xmm1
; SSE2-NEXT:    psrld $31, %xmm0
; SSE2-NEXT:    packuswb %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: cmpne_knownzeros_zext_v8i32_v8i16:
; SSE42:       # %bb.0:
; SSE42-NEXT:    psrld $31, %xmm1
; SSE42-NEXT:    psrld $31, %xmm0
; SSE42-NEXT:    packusdw %xmm1, %xmm0
; SSE42-NEXT:    retq
;
; AVX1-LABEL: cmpne_knownzeros_zext_v8i32_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpsrld $31, %xmm1, %xmm1
; AVX1-NEXT:    vpsrld $31, %xmm0, %xmm0
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: cmpne_knownzeros_zext_v8i32_v8i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsrld $31, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: cmpne_knownzeros_zext_v8i32_v8i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsrld $31, %ymm0, %ymm0
; AVX512-NEXT:    vpmovdw %ymm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = lshr <8 x i32> %x, <i32 31, i32 31, i32 31, i32 31, i32 31, i32 31, i32 31, i32 31>
  %b = icmp ne <8 x i32> %a, zeroinitializer
  %c = zext <8 x i1> %b to <8 x i16>
  ret <8 x i16> %c
}

; PR26697
define <4 x i32> @cmpeq_one_mask_bit(<4 x i32> %mask) {
; SSE-LABEL: cmpeq_one_mask_bit:
; SSE:       # %bb.0:
; SSE-NEXT:    psrad $31, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: cmpeq_one_mask_bit:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX-NEXT:    retq
  %mask_signbit = and <4 x i32> %mask, <i32 2147483648, i32 2147483648, i32 2147483648, i32 2147483648>
  %mask_bool = icmp ne <4 x i32> %mask_signbit, zeroinitializer
  %mask_bool_ext = sext <4 x i1> %mask_bool to <4 x i32>
  ret <4 x i32> %mask_bool_ext
}

define <2 x i64> @not_signbit_mask_v2i64(<2 x i64> %x, <2 x i64> %y) {
; SSE2-LABEL: not_signbit_mask_v2i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm0
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: not_signbit_mask_v2i64:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE42-NEXT:    pcmpgtq %xmm2, %xmm0
; SSE42-NEXT:    pand %xmm1, %xmm0
; SSE42-NEXT:    retq
;
; AVX1-LABEL: not_signbit_mask_v2i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: not_signbit_mask_v2i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpgtq %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpand %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: not_signbit_mask_v2i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsraq $63, %xmm0, %xmm0
; AVX512-NEXT:    vpandn %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    retq
  %sh = ashr <2 x i64> %x, <i64 63, i64 63>
  %not = xor <2 x i64> %sh, <i64 -1, i64 -1>
  %and = and <2 x i64> %y, %not
  ret <2 x i64> %and
}

define <4 x i32> @not_signbit_mask_v4i32(<4 x i32> %x, <4 x i32> %y) {
; SSE-LABEL: not_signbit_mask_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    psrad $31, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: not_signbit_mask_v4i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX-NEXT:    vpandn %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %sh = ashr <4 x i32> %x, <i32 31, i32 31, i32 31, i32 31>
  %not = xor <4 x i32> %sh, <i32 -1, i32 -1, i32 -1, i32 -1>
  %and = and <4 x i32> %not, %y
  ret <4 x i32> %and
}

define <8 x i16> @not_signbit_mask_v8i16(<8 x i16> %x, <8 x i16> %y) {
; SSE-LABEL: not_signbit_mask_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    psraw $15, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: not_signbit_mask_v8i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsraw $15, %xmm0, %xmm0
; AVX-NEXT:    vpandn %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %sh = ashr <8 x i16> %x, <i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15>
  %not = xor <8 x i16> %sh, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>
  %and = and <8 x i16> %y, %not
  ret <8 x i16> %and
}

define <16 x i8> @not_signbit_mask_v16i8(<16 x i8> %x, <16 x i8> %y) {
; SSE-LABEL: not_signbit_mask_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE-NEXT:    pcmpgtb %xmm2, %xmm0
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: not_signbit_mask_v16i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX-NEXT:    vpcmpgtb %xmm2, %xmm0, %xmm0
; AVX-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %sh = ashr <16 x i8> %x, <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7>
  %not = xor <16 x i8> %sh, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  %and = and <16 x i8> %not, %y
  ret <16 x i8> %and
}

define <4 x i64> @not_signbit_mask_v4i64(<4 x i64> %x, <4 x i64> %y) {
; SSE2-LABEL: not_signbit_mask_v4i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm0
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    pand %xmm3, %xmm1
; SSE2-NEXT:    retq
;
; SSE42-LABEL: not_signbit_mask_v4i64:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pcmpeqd %xmm4, %xmm4
; SSE42-NEXT:    pcmpgtq %xmm4, %xmm1
; SSE42-NEXT:    pcmpgtq %xmm4, %xmm0
; SSE42-NEXT:    pand %xmm2, %xmm0
; SSE42-NEXT:    pand %xmm3, %xmm1
; SSE42-NEXT:    retq
;
; AVX1-LABEL: not_signbit_mask_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vandnps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: not_signbit_mask_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: not_signbit_mask_v4i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsraq $63, %ymm0, %ymm0
; AVX512-NEXT:    vpandn %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %sh = ashr <4 x i64> %x, <i64 63, i64 63, i64 63, i64 63>
  %not = xor <4 x i64> %sh, <i64 -1, i64 -1, i64 -1, i64 -1>
  %and = and <4 x i64> %y, %not
  ret <4 x i64> %and
}

define <8 x i32> @not_signbit_mask_v8i32(<8 x i32> %x, <8 x i32> %y) {
; SSE-LABEL: not_signbit_mask_v8i32:
; SSE:       # %bb.0:
; SSE-NEXT:    psrad $31, %xmm0
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    psrad $31, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: not_signbit_mask_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsrad $31, %xmm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; AVX1-NEXT:    vandnps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: not_signbit_mask_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpandn %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: not_signbit_mask_v8i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX512-NEXT:    vpandn %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %sh = ashr <8 x i32> %x, <i32 31, i32 31, i32 31, i32 31, i32 31, i32 31, i32 31, i32 31>
  %not = xor <8 x i32> %sh, <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>
  %and = and <8 x i32> %not, %y
  ret <8 x i32> %and
}

define <16 x i16> @not_signbit_mask_v16i16(<16 x i16> %x, <16 x i16> %y) {
; SSE-LABEL: not_signbit_mask_v16i16:
; SSE:       # %bb.0:
; SSE-NEXT:    psraw $15, %xmm0
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    psraw $15, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: not_signbit_mask_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsraw $15, %xmm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpsraw $15, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; AVX1-NEXT:    vandnps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: not_signbit_mask_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsraw $15, %ymm0, %ymm0
; AVX2-NEXT:    vpandn %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: not_signbit_mask_v16i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsraw $15, %ymm0, %ymm0
; AVX512-NEXT:    vpandn %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %sh = ashr <16 x i16> %x, <i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15>
  %not = xor <16 x i16> %sh, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>
  %and = and <16 x i16> %y, %not
  ret <16 x i16> %and
}

define <32 x i8> @not_signbit_mask_v32i8(<32 x i8> %x, <32 x i8> %y) {
; SSE-LABEL: not_signbit_mask_v32i8:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm4, %xmm4
; SSE-NEXT:    pcmpgtb %xmm4, %xmm1
; SSE-NEXT:    pcmpgtb %xmm4, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    pand %xmm3, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: not_signbit_mask_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpgtb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpcmpgtb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vandnps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: not_signbit_mask_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpgtb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: not_signbit_mask_v32i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512-NEXT:    vpcmpgtb %ymm2, %ymm0, %ymm0
; AVX512-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %sh = ashr <32 x i8> %x, <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7>
  %not = xor <32 x i8> %sh, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  %and = and <32 x i8> %not, %y
  ret <32 x i8> %and
}

define <2 x i64> @ispositive_mask_v2i64(<2 x i64> %x, <2 x i64> %y) {
; SSE2-LABEL: ispositive_mask_v2i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm0
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: ispositive_mask_v2i64:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE42-NEXT:    pcmpgtq %xmm2, %xmm0
; SSE42-NEXT:    pand %xmm1, %xmm0
; SSE42-NEXT:    retq
;
; AVX1-LABEL: ispositive_mask_v2i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ispositive_mask_v2i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpgtq %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: ispositive_mask_v2i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsraq $63, %xmm0, %xmm0
; AVX512-NEXT:    vpandn %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    retq
  %cmp = icmp sgt <2 x i64> %x, <i64 -1, i64 -1>
  %mask = sext <2 x i1> %cmp to <2 x i64>
  %and = and <2 x i64> %mask, %y
  ret <2 x i64> %and
}

define <4 x i32> @is_positive_mask_v4i32(<4 x i32> %x, <4 x i32> %y) {
; SSE-LABEL: is_positive_mask_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    psrad $31, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: is_positive_mask_v4i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX-NEXT:    vpandn %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %cmp = icmp sgt <4 x i32> %x, <i32 -1, i32 -1, i32 -1, i32 -1>
  %mask = sext <4 x i1> %cmp to <4 x i32>
  %and = and <4 x i32> %y, %mask
  ret <4 x i32> %and
}

define <8 x i16> @is_positive_mask_v8i16(<8 x i16> %x, <8 x i16> %y) {
; SSE-LABEL: is_positive_mask_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    psraw $15, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: is_positive_mask_v8i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsraw $15, %xmm0, %xmm0
; AVX-NEXT:    vpandn %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %cmp = icmp sgt <8 x i16> %x, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>
  %mask = sext <8 x i1> %cmp to <8 x i16>
  %and = and <8 x i16> %mask, %y
  ret <8 x i16> %and
}

define <16 x i8> @is_positive_mask_v16i8(<16 x i8> %x, <16 x i8> %y) {
; SSE-LABEL: is_positive_mask_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE-NEXT:    pcmpgtb %xmm2, %xmm0
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: is_positive_mask_v16i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX-NEXT:    vpcmpgtb %xmm2, %xmm0, %xmm0
; AVX-NEXT:    vpand %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
  %cmp = icmp sgt <16 x i8> %x, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  %mask = sext <16 x i1> %cmp to <16 x i8>
  %and = and <16 x i8> %y, %mask
  ret <16 x i8> %and
}

define <4 x i64> @is_positive_mask_v4i64(<4 x i64> %x, <4 x i64> %y) {
; SSE2-LABEL: is_positive_mask_v4i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm0
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    pand %xmm3, %xmm1
; SSE2-NEXT:    retq
;
; SSE42-LABEL: is_positive_mask_v4i64:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pcmpeqd %xmm4, %xmm4
; SSE42-NEXT:    pcmpgtq %xmm4, %xmm1
; SSE42-NEXT:    pcmpgtq %xmm4, %xmm0
; SSE42-NEXT:    pand %xmm2, %xmm0
; SSE42-NEXT:    pand %xmm3, %xmm1
; SSE42-NEXT:    retq
;
; AVX1-LABEL: is_positive_mask_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpgtq %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpgtq %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vandps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: is_positive_mask_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: is_positive_mask_v4i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsraq $63, %ymm0, %ymm0
; AVX512-NEXT:    vpandn %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %cmp = icmp sgt <4 x i64> %x, <i64 -1, i64 -1, i64 -1, i64 -1>
  %mask = sext <4 x i1> %cmp to <4 x i64>
  %and = and <4 x i64> %mask, %y
  ret <4 x i64> %and
}

define <8 x i32> @is_positive_mask_v8i32(<8 x i32> %x, <8 x i32> %y) {
; SSE-LABEL: is_positive_mask_v8i32:
; SSE:       # %bb.0:
; SSE-NEXT:    psrad $31, %xmm0
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    psrad $31, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: is_positive_mask_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpgtd %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpgtd %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vandps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: is_positive_mask_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpandn %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: is_positive_mask_v8i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX512-NEXT:    vpandn %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %cmp = icmp sgt <8 x i32> %x, <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>
  %mask = sext <8 x i1> %cmp to <8 x i32>
  %and = and <8 x i32> %y, %mask
  ret <8 x i32> %and
}

define <16 x i16> @is_positive_mask_v16i16(<16 x i16> %x, <16 x i16> %y) {
; SSE-LABEL: is_positive_mask_v16i16:
; SSE:       # %bb.0:
; SSE-NEXT:    psraw $15, %xmm0
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    psraw $15, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: is_positive_mask_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpgtw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpgtw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vandps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: is_positive_mask_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsraw $15, %ymm0, %ymm0
; AVX2-NEXT:    vpandn %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: is_positive_mask_v16i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsraw $15, %ymm0, %ymm0
; AVX512-NEXT:    vpandn %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %cmp = icmp sgt <16 x i16> %x, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>
  %mask = sext <16 x i1> %cmp to <16 x i16>
  %and = and <16 x i16> %mask, %y
  ret <16 x i16> %and
}

define <32 x i8> @is_positive_mask_v32i8(<32 x i8> %x, <32 x i8> %y) {
; SSE-LABEL: is_positive_mask_v32i8:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm4, %xmm4
; SSE-NEXT:    pcmpgtb %xmm4, %xmm1
; SSE-NEXT:    pcmpgtb %xmm4, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    pand %xmm3, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: is_positive_mask_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpgtb %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpgtb %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vandps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: is_positive_mask_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpgtb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: is_positive_mask_v32i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512-NEXT:    vpcmpgtb %ymm2, %ymm0, %ymm0
; AVX512-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX512-NEXT:    retq
  %cmp = icmp sgt <32 x i8> %x, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  %mask = sext <32 x i1> %cmp to <32 x i8>
  %and = and <32 x i8> %y, %mask
  ret <32 x i8> %and
}

define <2 x i64> @ispositive_mask_load_v2i64(<2 x i64> %x, ptr %p) {
; SSE2-LABEL: ispositive_mask_load_v2i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm0
; SSE2-NEXT:    pand (%rdi), %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: ispositive_mask_load_v2i64:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE42-NEXT:    pcmpgtq %xmm1, %xmm0
; SSE42-NEXT:    pand (%rdi), %xmm0
; SSE42-NEXT:    retq
;
; AVX1-LABEL: ispositive_mask_load_v2i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpand (%rdi), %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ispositive_mask_load_v2i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpand (%rdi), %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: ispositive_mask_load_v2i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsraq $63, %xmm0, %xmm0
; AVX512-NEXT:    vpandn (%rdi), %xmm0, %xmm0
; AVX512-NEXT:    retq
  %cmp = icmp sgt <2 x i64> %x, <i64 -1, i64 -1>
  %mask = sext <2 x i1> %cmp to <2 x i64>
  %y = load <2 x i64>, ptr %p
  %and = and <2 x i64> %mask, %y
  ret <2 x i64> %and
}

define <4 x i32> @is_positive_mask_load_v4i32(<4 x i32> %x, ptr %p) {
; SSE-LABEL: is_positive_mask_load_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    psrad $31, %xmm0
; SSE-NEXT:    pandn (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: is_positive_mask_load_v4i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX-NEXT:    vpandn (%rdi), %xmm0, %xmm0
; AVX-NEXT:    retq
  %cmp = icmp sgt <4 x i32> %x, <i32 -1, i32 -1, i32 -1, i32 -1>
  %mask = sext <4 x i1> %cmp to <4 x i32>
  %y = load <4 x i32>, ptr %p
  %and = and <4 x i32> %y, %mask
  ret <4 x i32> %and
}

define <8 x i16> @is_positive_mask_load_v8i16(<8 x i16> %x, ptr %p) {
; SSE-LABEL: is_positive_mask_load_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    psraw $15, %xmm0
; SSE-NEXT:    pandn (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: is_positive_mask_load_v8i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsraw $15, %xmm0, %xmm0
; AVX-NEXT:    vpandn (%rdi), %xmm0, %xmm0
; AVX-NEXT:    retq
  %cmp = icmp sgt <8 x i16> %x, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>
  %mask = sext <8 x i1> %cmp to <8 x i16>
  %y = load <8 x i16>, ptr %p
  %and = and <8 x i16> %mask, %y
  ret <8 x i16> %and
}

define <16 x i8> @is_positive_mask_load_v16i8(<16 x i8> %x, ptr %p) {
; SSE-LABEL: is_positive_mask_load_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE-NEXT:    pcmpgtb %xmm1, %xmm0
; SSE-NEXT:    pand (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: is_positive_mask_load_v16i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vpcmpgtb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpand (%rdi), %xmm0, %xmm0
; AVX-NEXT:    retq
  %cmp = icmp sgt <16 x i8> %x, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  %mask = sext <16 x i1> %cmp to <16 x i8>
  %y = load <16 x i8>, ptr %p
  %and = and <16 x i8> %y, %mask
  ret <16 x i8> %and
}

define <4 x i64> @is_positive_mask_load_v4i64(<4 x i64> %x, ptr %p) {
; SSE2-LABEL: is_positive_mask_load_v4i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm0
; SSE2-NEXT:    pand (%rdi), %xmm0
; SSE2-NEXT:    pand 16(%rdi), %xmm1
; SSE2-NEXT:    retq
;
; SSE42-LABEL: is_positive_mask_load_v4i64:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE42-NEXT:    pcmpgtq %xmm2, %xmm1
; SSE42-NEXT:    pcmpgtq %xmm2, %xmm0
; SSE42-NEXT:    pand (%rdi), %xmm0
; SSE42-NEXT:    pand 16(%rdi), %xmm1
; SSE42-NEXT:    retq
;
; AVX1-LABEL: is_positive_mask_load_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vandps (%rdi), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: is_positive_mask_load_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpand (%rdi), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: is_positive_mask_load_v4i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsraq $63, %ymm0, %ymm0
; AVX512-NEXT:    vpandn (%rdi), %ymm0, %ymm0
; AVX512-NEXT:    retq
  %cmp = icmp sgt <4 x i64> %x, <i64 -1, i64 -1, i64 -1, i64 -1>
  %mask = sext <4 x i1> %cmp to <4 x i64>
  %y = load <4 x i64>, ptr %p
  %and = and <4 x i64> %mask, %y
  ret <4 x i64> %and
}

define <8 x i32> @is_positive_mask_load_v8i32(<8 x i32> %x, ptr %p) {
; SSE-LABEL: is_positive_mask_load_v8i32:
; SSE:       # %bb.0:
; SSE-NEXT:    psrad $31, %xmm0
; SSE-NEXT:    pandn (%rdi), %xmm0
; SSE-NEXT:    psrad $31, %xmm1
; SSE-NEXT:    pandn 16(%rdi), %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: is_positive_mask_load_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpgtd %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpgtd %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vandps (%rdi), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: is_positive_mask_load_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpandn (%rdi), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: is_positive_mask_load_v8i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX512-NEXT:    vpandn (%rdi), %ymm0, %ymm0
; AVX512-NEXT:    retq
  %cmp = icmp sgt <8 x i32> %x, <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>
  %mask = sext <8 x i1> %cmp to <8 x i32>
  %y = load <8 x i32>, ptr %p
  %and = and <8 x i32> %y, %mask
  ret <8 x i32> %and
}

define <16 x i16> @is_positive_mask_load_v16i16(<16 x i16> %x, ptr %p) {
; SSE-LABEL: is_positive_mask_load_v16i16:
; SSE:       # %bb.0:
; SSE-NEXT:    psraw $15, %xmm0
; SSE-NEXT:    pandn (%rdi), %xmm0
; SSE-NEXT:    psraw $15, %xmm1
; SSE-NEXT:    pandn 16(%rdi), %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: is_positive_mask_load_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpgtw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpgtw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vandps (%rdi), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: is_positive_mask_load_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsraw $15, %ymm0, %ymm0
; AVX2-NEXT:    vpandn (%rdi), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: is_positive_mask_load_v16i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsraw $15, %ymm0, %ymm0
; AVX512-NEXT:    vpandn (%rdi), %ymm0, %ymm0
; AVX512-NEXT:    retq
  %cmp = icmp sgt <16 x i16> %x, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>
  %mask = sext <16 x i1> %cmp to <16 x i16>
  %y = load <16 x i16>, ptr %p
  %and = and <16 x i16> %mask, %y
  ret <16 x i16> %and
}

define <32 x i8> @is_positive_mask_load_v32i8(<32 x i8> %x, ptr %p) {
; SSE-LABEL: is_positive_mask_load_v32i8:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE-NEXT:    pcmpgtb %xmm2, %xmm1
; SSE-NEXT:    pcmpgtb %xmm2, %xmm0
; SSE-NEXT:    pand (%rdi), %xmm0
; SSE-NEXT:    pand 16(%rdi), %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: is_positive_mask_load_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpgtb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpgtb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vandps (%rdi), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: is_positive_mask_load_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpgtb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpand (%rdi), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: is_positive_mask_load_v32i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512-NEXT:    vpcmpgtb %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpand (%rdi), %ymm0, %ymm0
; AVX512-NEXT:    retq
  %cmp = icmp sgt <32 x i8> %x, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  %mask = sext <32 x i1> %cmp to <32 x i8>
  %y = load <32 x i8>, ptr %p
  %and = and <32 x i8> %y, %mask
  ret <32 x i8> %and
}

define <2 x i1> @ispositive_mask_v2i64_v2i1(<2 x i64> %x, <2 x i1> %y) {
; SSE2-LABEL: ispositive_mask_v2i64_v2i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm0
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: ispositive_mask_v2i64_v2i1:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE42-NEXT:    pcmpgtq %xmm2, %xmm0
; SSE42-NEXT:    pand %xmm1, %xmm0
; SSE42-NEXT:    retq
;
; AVX1-LABEL: ispositive_mask_v2i64_v2i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ispositive_mask_v2i64_v2i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpgtq %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: ispositive_mask_v2i64_v2i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsllq $63, %xmm1, %xmm1
; AVX512F-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpgtq %xmm2, %xmm0, %k1
; AVX512F-NEXT:    vptestmq %xmm1, %xmm1, %k1 {%k1}
; AVX512F-NEXT:    vmovdqa64 %xmm2, %xmm0 {%k1} {z}
; AVX512F-NEXT:    retq
;
; AVX512DQBW-LABEL: ispositive_mask_v2i64_v2i1:
; AVX512DQBW:       # %bb.0:
; AVX512DQBW-NEXT:    vpsllq $63, %xmm1, %xmm1
; AVX512DQBW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512DQBW-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; AVX512DQBW-NEXT:    vpcmpgtq %xmm3, %xmm0, %k1
; AVX512DQBW-NEXT:    vpcmpgtq %xmm1, %xmm2, %k0 {%k1}
; AVX512DQBW-NEXT:    vpmovm2q %k0, %xmm0
; AVX512DQBW-NEXT:    retq
  %cmp = icmp sgt <2 x i64> %x, <i64 -1, i64 -1>
  %and = and <2 x i1> %cmp, %y
  ret <2 x i1> %and
}

define <4 x i1> @is_positive_mask_v4i32_v4i1(<4 x i32> %x, <4 x i1> %y) {
; SSE-LABEL: is_positive_mask_v4i32_v4i1:
; SSE:       # %bb.0:
; SSE-NEXT:    psrad $31, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: is_positive_mask_v4i32_v4i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX1-NEXT:    vpandn %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: is_positive_mask_v4i32_v4i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX2-NEXT:    vpandn %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: is_positive_mask_v4i32_v4i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX512F-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpgtd %xmm2, %xmm0, %k1
; AVX512F-NEXT:    vptestmd %xmm1, %xmm1, %k1 {%k1}
; AVX512F-NEXT:    vmovdqa32 %xmm2, %xmm0 {%k1} {z}
; AVX512F-NEXT:    retq
;
; AVX512DQBW-LABEL: is_positive_mask_v4i32_v4i1:
; AVX512DQBW:       # %bb.0:
; AVX512DQBW-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX512DQBW-NEXT:    vpmovd2m %xmm1, %k1
; AVX512DQBW-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX512DQBW-NEXT:    vpcmpgtd %xmm1, %xmm0, %k0 {%k1}
; AVX512DQBW-NEXT:    vpmovm2d %k0, %xmm0
; AVX512DQBW-NEXT:    retq
  %cmp = icmp sgt <4 x i32> %x, <i32 -1, i32 -1, i32 -1, i32 -1>
  %and = and <4 x i1> %y, %cmp
  ret <4 x i1> %and
}

define <8 x i1> @is_positive_mask_v8i16_v8i1(<8 x i16> %x, <8 x i1> %y) {
; SSE-LABEL: is_positive_mask_v8i16_v8i1:
; SSE:       # %bb.0:
; SSE-NEXT:    psraw $15, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: is_positive_mask_v8i16_v8i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsraw $15, %xmm0, %xmm0
; AVX1-NEXT:    vpandn %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: is_positive_mask_v8i16_v8i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsraw $15, %xmm0, %xmm0
; AVX2-NEXT:    vpandn %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: is_positive_mask_v8i16_v8i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsraw $15, %xmm0, %xmm0
; AVX512F-NEXT:    vpandn %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    retq
;
; AVX512DQBW-LABEL: is_positive_mask_v8i16_v8i1:
; AVX512DQBW:       # %bb.0:
; AVX512DQBW-NEXT:    vpsllw $15, %xmm1, %xmm1
; AVX512DQBW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512DQBW-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; AVX512DQBW-NEXT:    vpcmpgtw %xmm3, %xmm0, %k1
; AVX512DQBW-NEXT:    vpcmpgtw %xmm1, %xmm2, %k0 {%k1}
; AVX512DQBW-NEXT:    vpmovm2w %k0, %xmm0
; AVX512DQBW-NEXT:    retq
  %cmp = icmp sgt <8 x i16> %x, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>
  %and = and <8 x i1> %cmp, %y
  ret <8 x i1> %and
}

define <16 x i1> @is_positive_mask_v16i8_v16i1(<16 x i8> %x, <16 x i1> %y) {
; SSE-LABEL: is_positive_mask_v16i8_v16i1:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE-NEXT:    pcmpgtb %xmm2, %xmm0
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: is_positive_mask_v16i8_v16i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpgtb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: is_positive_mask_v16i8_v16i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpgtb %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpand %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: is_positive_mask_v16i8_v16i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpgtb %xmm2, %xmm0, %xmm0
; AVX512F-NEXT:    vpand %xmm0, %xmm1, %xmm0
; AVX512F-NEXT:    retq
;
; AVX512DQBW-LABEL: is_positive_mask_v16i8_v16i1:
; AVX512DQBW:       # %bb.0:
; AVX512DQBW-NEXT:    vpsllw $7, %xmm1, %xmm1
; AVX512DQBW-NEXT:    vpmovb2m %xmm1, %k1
; AVX512DQBW-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX512DQBW-NEXT:    vpcmpgtb %xmm1, %xmm0, %k0 {%k1}
; AVX512DQBW-NEXT:    vpmovm2b %k0, %xmm0
; AVX512DQBW-NEXT:    retq
  %cmp = icmp sgt <16 x i8> %x, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  %and = and <16 x i1> %y, %cmp
  ret <16 x i1> %and
}

define <4 x i1> @is_positive_mask_v4i64_v4i1(<4 x i64> %x, <4 x i1> %y) {
; SSE2-LABEL: is_positive_mask_v4i64_v4i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,3],xmm1[1,3]
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pandn %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: is_positive_mask_v4i64_v4i1:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pcmpeqd %xmm3, %xmm3
; SSE42-NEXT:    pcmpgtq %xmm3, %xmm1
; SSE42-NEXT:    pcmpgtq %xmm3, %xmm0
; SSE42-NEXT:    packssdw %xmm1, %xmm0
; SSE42-NEXT:    pand %xmm2, %xmm0
; SSE42-NEXT:    retq
;
; AVX1-LABEL: is_positive_mask_v4i64_v4i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpgtq %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpgtq %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackssdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: is_positive_mask_v4i64_v4i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX2-NEXT:    vpackssdw %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: is_positive_mask_v4i64_v4i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX512F-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512F-NEXT:    vpcmpgtq %ymm2, %ymm0, %k1
; AVX512F-NEXT:    vptestmd %xmm1, %xmm1, %k1 {%k1}
; AVX512F-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    vmovdqa32 %xmm0, %xmm0 {%k1} {z}
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512DQBW-LABEL: is_positive_mask_v4i64_v4i1:
; AVX512DQBW:       # %bb.0:
; AVX512DQBW-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX512DQBW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512DQBW-NEXT:    vpcmpeqd %ymm3, %ymm3, %ymm3
; AVX512DQBW-NEXT:    vpcmpgtq %ymm3, %ymm0, %k1
; AVX512DQBW-NEXT:    vpcmpgtd %xmm1, %xmm2, %k0 {%k1}
; AVX512DQBW-NEXT:    vpmovm2d %k0, %xmm0
; AVX512DQBW-NEXT:    vzeroupper
; AVX512DQBW-NEXT:    retq
  %cmp = icmp sgt <4 x i64> %x, <i64 -1, i64 -1, i64 -1, i64 -1>
  %and = and <4 x i1> %cmp, %y
  ret <4 x i1> %and
}

define <8 x i1> @is_positive_mask_v8i32_v8i1(<8 x i32> %x, <8 x i1> %y) {
; SSE-LABEL: is_positive_mask_v8i32_v8i1:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm3, %xmm3
; SSE-NEXT:    pcmpgtd %xmm3, %xmm1
; SSE-NEXT:    pcmpgtd %xmm3, %xmm0
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: is_positive_mask_v8i32_v8i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpgtd %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpgtd %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackssdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: is_positive_mask_v8i32_v8i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpgtd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX2-NEXT:    vpackssdw %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpand %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: is_positive_mask_v8i32_v8i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpmovsxwd %xmm1, %ymm1
; AVX512F-NEXT:    vpslld $31, %ymm1, %ymm1
; AVX512F-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512F-NEXT:    vpcmpgtd %ymm2, %ymm0, %k1
; AVX512F-NEXT:    vptestmd %ymm1, %ymm1, %k1 {%k1}
; AVX512F-NEXT:    vmovdqa32 %ymm2, %ymm0 {%k1} {z}
; AVX512F-NEXT:    vpmovdw %ymm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512DQBW-LABEL: is_positive_mask_v8i32_v8i1:
; AVX512DQBW:       # %bb.0:
; AVX512DQBW-NEXT:    vpsllw $15, %xmm1, %xmm1
; AVX512DQBW-NEXT:    vpmovw2m %xmm1, %k1
; AVX512DQBW-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512DQBW-NEXT:    vpcmpgtd %ymm1, %ymm0, %k0 {%k1}
; AVX512DQBW-NEXT:    vpmovm2w %k0, %xmm0
; AVX512DQBW-NEXT:    vzeroupper
; AVX512DQBW-NEXT:    retq
  %cmp = icmp sgt <8 x i32> %x, <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>
  %and = and <8 x i1> %y, %cmp
  ret <8 x i1> %and
}

define <16 x i1> @is_positive_mask_v16i16_v16i1(<16 x i16> %x, <16 x i1> %y) {
; SSE-LABEL: is_positive_mask_v16i16_v16i1:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm3, %xmm3
; SSE-NEXT:    pcmpgtw %xmm3, %xmm1
; SSE-NEXT:    pcmpgtw %xmm3, %xmm0
; SSE-NEXT:    packsswb %xmm1, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: is_positive_mask_v16i16_v16i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpgtw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpgtw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: is_positive_mask_v16i16_v16i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpgtw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX2-NEXT:    vpacksswb %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: is_positive_mask_v16i16_v16i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpmovsxbd %xmm1, %zmm1
; AVX512F-NEXT:    vpslld $31, %zmm1, %zmm1
; AVX512F-NEXT:    vptestmd %zmm1, %zmm1, %k1
; AVX512F-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512F-NEXT:    vpcmpgtw %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    vpmovsxwd %ymm0, %zmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k1 {%k1}
; AVX512F-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512DQBW-LABEL: is_positive_mask_v16i16_v16i1:
; AVX512DQBW:       # %bb.0:
; AVX512DQBW-NEXT:    vpsllw $7, %xmm1, %xmm1
; AVX512DQBW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512DQBW-NEXT:    vpcmpeqd %ymm3, %ymm3, %ymm3
; AVX512DQBW-NEXT:    vpcmpgtw %ymm3, %ymm0, %k1
; AVX512DQBW-NEXT:    vpcmpgtb %xmm1, %xmm2, %k0 {%k1}
; AVX512DQBW-NEXT:    vpmovm2b %k0, %xmm0
; AVX512DQBW-NEXT:    vzeroupper
; AVX512DQBW-NEXT:    retq
  %cmp = icmp sgt <16 x i16> %x, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>
  %and = and <16 x i1> %cmp, %y
  ret <16 x i1> %and
}

define <32 x i1> @is_positive_mask_v32i8_v32i1(<32 x i8> %x, <32 x i1> %y) {
; SSE2-LABEL: is_positive_mask_v32i8_v32i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movq %rdi, %rax
; SSE2-NEXT:    movd {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE2-NEXT:    movd {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3],xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; SSE2-NEXT:    movd {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE2-NEXT:    movd {{.*#+}} xmm4 = mem[0],zero,zero,zero
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1],xmm4[2],xmm2[2],xmm4[3],xmm2[3],xmm4[4],xmm2[4],xmm4[5],xmm2[5],xmm4[6],xmm2[6],xmm4[7],xmm2[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; SSE2-NEXT:    movd {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE2-NEXT:    movd {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3],xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; SSE2-NEXT:    movd {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE2-NEXT:    movd {{.*#+}} xmm5 = mem[0],zero,zero,zero
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm5 = xmm5[0],xmm2[0],xmm5[1],xmm2[1],xmm5[2],xmm2[2],xmm5[3],xmm2[3],xmm5[4],xmm2[4],xmm5[5],xmm2[5],xmm5[6],xmm2[6],xmm5[7],xmm2[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm5 = xmm5[0],xmm3[0],xmm5[1],xmm3[1],xmm5[2],xmm3[2],xmm5[3],xmm3[3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; SSE2-NEXT:    movd {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE2-NEXT:    movd {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3],xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; SSE2-NEXT:    movd %r9d, %xmm4
; SSE2-NEXT:    movd {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1],xmm4[2],xmm2[2],xmm4[3],xmm2[3],xmm4[4],xmm2[4],xmm4[5],xmm2[5],xmm4[6],xmm2[6],xmm4[7],xmm2[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; SSE2-NEXT:    movd %r8d, %xmm2
; SSE2-NEXT:    movd %ecx, %xmm3
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3],xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; SSE2-NEXT:    movd %edx, %xmm6
; SSE2-NEXT:    movd %esi, %xmm2
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm6[0],xmm2[1],xmm6[1],xmm2[2],xmm6[2],xmm2[3],xmm6[3],xmm2[4],xmm6[4],xmm2[5],xmm6[5],xmm2[6],xmm6[6],xmm2[7],xmm6[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[1],xmm3[1],xmm2[2],xmm3[2],xmm2[3],xmm3[3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm4[0],xmm2[1],xmm4[1]
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm5[0]
; SSE2-NEXT:    movd {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    movd {{.*#+}} xmm4 = mem[0],zero,zero,zero
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3],xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; SSE2-NEXT:    movd {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    movd {{.*#+}} xmm5 = mem[0],zero,zero,zero
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm5 = xmm5[0],xmm3[0],xmm5[1],xmm3[1],xmm5[2],xmm3[2],xmm5[3],xmm3[3],xmm5[4],xmm3[4],xmm5[5],xmm3[5],xmm5[6],xmm3[6],xmm5[7],xmm3[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm5 = xmm5[0],xmm4[0],xmm5[1],xmm4[1],xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; SSE2-NEXT:    movd {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    movd {{.*#+}} xmm4 = mem[0],zero,zero,zero
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3],xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; SSE2-NEXT:    movd {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    movd {{.*#+}} xmm6 = mem[0],zero,zero,zero
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm6 = xmm6[0],xmm3[0],xmm6[1],xmm3[1],xmm6[2],xmm3[2],xmm6[3],xmm3[3],xmm6[4],xmm3[4],xmm6[5],xmm3[5],xmm6[6],xmm3[6],xmm6[7],xmm3[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm6 = xmm6[0],xmm4[0],xmm6[1],xmm4[1],xmm6[2],xmm4[2],xmm6[3],xmm4[3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm5[0],xmm6[1],xmm5[1]
; SSE2-NEXT:    movd {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    movd {{.*#+}} xmm4 = mem[0],zero,zero,zero
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3],xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; SSE2-NEXT:    movd {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    movd {{.*#+}} xmm5 = mem[0],zero,zero,zero
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm5 = xmm5[0],xmm3[0],xmm5[1],xmm3[1],xmm5[2],xmm3[2],xmm5[3],xmm3[3],xmm5[4],xmm3[4],xmm5[5],xmm3[5],xmm5[6],xmm3[6],xmm5[7],xmm3[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm5 = xmm5[0],xmm4[0],xmm5[1],xmm4[1],xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; SSE2-NEXT:    movd {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    movd {{.*#+}} xmm4 = mem[0],zero,zero,zero
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3],xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; SSE2-NEXT:    movd {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    movd {{.*#+}} xmm7 = mem[0],zero,zero,zero
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm7 = xmm7[0],xmm3[0],xmm7[1],xmm3[1],xmm7[2],xmm3[2],xmm7[3],xmm3[3],xmm7[4],xmm3[4],xmm7[5],xmm3[5],xmm7[6],xmm3[6],xmm7[7],xmm3[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm7 = xmm7[0],xmm4[0],xmm7[1],xmm4[1],xmm7[2],xmm4[2],xmm7[3],xmm4[3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm7 = xmm7[0],xmm5[0],xmm7[1],xmm5[1]
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm7 = xmm7[0],xmm6[0]
; SSE2-NEXT:    pcmpeqd %xmm3, %xmm3
; SSE2-NEXT:    pcmpgtb %xmm3, %xmm0
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    pcmpgtb %xmm3, %xmm1
; SSE2-NEXT:    pand %xmm7, %xmm1
; SSE2-NEXT:    psllw $7, %xmm1
; SSE2-NEXT:    pmovmskb %xmm1, %ecx
; SSE2-NEXT:    shll $16, %ecx
; SSE2-NEXT:    psllw $7, %xmm0
; SSE2-NEXT:    pmovmskb %xmm0, %edx
; SSE2-NEXT:    orl %ecx, %edx
; SSE2-NEXT:    movl %edx, (%rdi)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: is_positive_mask_v32i8_v32i1:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movq %rdi, %rax
; SSE42-NEXT:    movd %esi, %xmm2
; SSE42-NEXT:    pinsrb $1, %edx, %xmm2
; SSE42-NEXT:    pinsrb $2, %ecx, %xmm2
; SSE42-NEXT:    pinsrb $3, %r8d, %xmm2
; SSE42-NEXT:    pinsrb $4, %r9d, %xmm2
; SSE42-NEXT:    pinsrb $5, {{[0-9]+}}(%rsp), %xmm2
; SSE42-NEXT:    pinsrb $6, {{[0-9]+}}(%rsp), %xmm2
; SSE42-NEXT:    pinsrb $7, {{[0-9]+}}(%rsp), %xmm2
; SSE42-NEXT:    pinsrb $8, {{[0-9]+}}(%rsp), %xmm2
; SSE42-NEXT:    pinsrb $9, {{[0-9]+}}(%rsp), %xmm2
; SSE42-NEXT:    pinsrb $10, {{[0-9]+}}(%rsp), %xmm2
; SSE42-NEXT:    pinsrb $11, {{[0-9]+}}(%rsp), %xmm2
; SSE42-NEXT:    pinsrb $12, {{[0-9]+}}(%rsp), %xmm2
; SSE42-NEXT:    pinsrb $13, {{[0-9]+}}(%rsp), %xmm2
; SSE42-NEXT:    pinsrb $14, {{[0-9]+}}(%rsp), %xmm2
; SSE42-NEXT:    pinsrb $15, {{[0-9]+}}(%rsp), %xmm2
; SSE42-NEXT:    movd {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE42-NEXT:    pinsrb $1, {{[0-9]+}}(%rsp), %xmm3
; SSE42-NEXT:    pinsrb $2, {{[0-9]+}}(%rsp), %xmm3
; SSE42-NEXT:    pinsrb $3, {{[0-9]+}}(%rsp), %xmm3
; SSE42-NEXT:    pinsrb $4, {{[0-9]+}}(%rsp), %xmm3
; SSE42-NEXT:    pinsrb $5, {{[0-9]+}}(%rsp), %xmm3
; SSE42-NEXT:    pinsrb $6, {{[0-9]+}}(%rsp), %xmm3
; SSE42-NEXT:    pinsrb $7, {{[0-9]+}}(%rsp), %xmm3
; SSE42-NEXT:    pinsrb $8, {{[0-9]+}}(%rsp), %xmm3
; SSE42-NEXT:    pinsrb $9, {{[0-9]+}}(%rsp), %xmm3
; SSE42-NEXT:    pinsrb $10, {{[0-9]+}}(%rsp), %xmm3
; SSE42-NEXT:    pinsrb $11, {{[0-9]+}}(%rsp), %xmm3
; SSE42-NEXT:    pinsrb $12, {{[0-9]+}}(%rsp), %xmm3
; SSE42-NEXT:    pinsrb $13, {{[0-9]+}}(%rsp), %xmm3
; SSE42-NEXT:    pinsrb $14, {{[0-9]+}}(%rsp), %xmm3
; SSE42-NEXT:    pinsrb $15, {{[0-9]+}}(%rsp), %xmm3
; SSE42-NEXT:    pcmpeqd %xmm4, %xmm4
; SSE42-NEXT:    pcmpgtb %xmm4, %xmm1
; SSE42-NEXT:    pand %xmm3, %xmm1
; SSE42-NEXT:    pcmpgtb %xmm4, %xmm0
; SSE42-NEXT:    pand %xmm2, %xmm0
; SSE42-NEXT:    psllw $7, %xmm0
; SSE42-NEXT:    pmovmskb %xmm0, %ecx
; SSE42-NEXT:    psllw $7, %xmm1
; SSE42-NEXT:    pmovmskb %xmm1, %edx
; SSE42-NEXT:    shll $16, %edx
; SSE42-NEXT:    orl %ecx, %edx
; SSE42-NEXT:    movl %edx, (%rdi)
; SSE42-NEXT:    retq
;
; AVX1-LABEL: is_positive_mask_v32i8_v32i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpgtb %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpgtb %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vandps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: is_positive_mask_v32i8_v32i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpgtb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: is_positive_mask_v32i8_v32i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512F-NEXT:    vpcmpgtb %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512DQBW-LABEL: is_positive_mask_v32i8_v32i1:
; AVX512DQBW:       # %bb.0:
; AVX512DQBW-NEXT:    vpsllw $7, %ymm1, %ymm1
; AVX512DQBW-NEXT:    vpmovb2m %ymm1, %k1
; AVX512DQBW-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512DQBW-NEXT:    vpcmpgtb %ymm1, %ymm0, %k0 {%k1}
; AVX512DQBW-NEXT:    vpmovm2b %k0, %ymm0
; AVX512DQBW-NEXT:    retq
  %cmp = icmp sgt <32 x i8> %x, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  %and = and <32 x i1> %y, %cmp
  ret <32 x i1> %and
}

define <4 x i64> @PR52504(<4 x i16> %t3) {
; SSE2-LABEL: PR52504:
; SSE2:       # %bb.0:
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE2-NEXT:    psrad $16, %xmm1
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm1, %xmm3
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm3 = xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,0,1,1]
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm0
; SSE2-NEXT:    pand %xmm0, %xmm1
; SSE2-NEXT:    pxor %xmm4, %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[2,2,3,3]
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm1
; SSE2-NEXT:    pand %xmm1, %xmm3
; SSE2-NEXT:    pxor %xmm4, %xmm1
; SSE2-NEXT:    por %xmm3, %xmm1
; SSE2-NEXT:    retq
;
; SSE42-LABEL: PR52504:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,1,1]
; SSE42-NEXT:    pmovsxwq %xmm1, %xmm2
; SSE42-NEXT:    pmovsxwq %xmm0, %xmm3
; SSE42-NEXT:    pxor %xmm1, %xmm1
; SSE42-NEXT:    pxor %xmm0, %xmm0
; SSE42-NEXT:    pcmpgtq %xmm3, %xmm0
; SSE42-NEXT:    por %xmm3, %xmm0
; SSE42-NEXT:    pcmpgtq %xmm2, %xmm1
; SSE42-NEXT:    por %xmm2, %xmm1
; SSE42-NEXT:    retq
;
; AVX1-LABEL: PR52504:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmovsxwq %xmm0, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX1-NEXT:    vpmovsxwq %xmm0, %xmm0
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm2, %xmm3
; AVX1-NEXT:    vpor %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm2
; AVX1-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: PR52504:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovsxwq %xmm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm1
; AVX2-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: PR52504:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxwq %xmm0, %ymm0
; AVX512-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512-NEXT:    vpmaxsq %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %t14 = sext <4 x i16> %t3 to <4 x i64>
  %t15 = icmp sgt <4 x i64> %t14, <i64 -1, i64 -1, i64 -1, i64 -1>
  %t16 = select <4 x i1> %t15, <4 x i64> %t14, <4 x i64> <i64 -1, i64 -1, i64 -1, i64 -1>
  ret <4 x i64> %t16
}
