; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -aarch64-sve-vector-bits-min=256  < %s | FileCheck %s -check-prefixes=CHECK,VBITS_GE_256
; RUN: llc -aarch64-sve-vector-bits-min=512  < %s | FileCheck %s -check-prefixes=CHECK,VBITS_GE_512
; RUN: llc -aarch64-sve-vector-bits-min=2048 < %s | FileCheck %s -check-prefixes=CHECK,VBITS_GE_512

target triple = "aarch64-unknown-linux-gnu"

;
; FADD
;

; Don't use SVE for 64-bit vectors.
define <4 x half> @fadd_v4f16(<4 x half> %op1, <4 x half> %op2) vscale_range(2,0) #0 {
; CHECK-LABEL: fadd_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fadd v0.4h, v0.4h, v1.4h
; CHECK-NEXT:    ret
  %res = fadd <4 x half> %op1, %op2
  ret <4 x half> %res
}

; Don't use SVE for 128-bit vectors.
define <8 x half> @fadd_v8f16(<8 x half> %op1, <8 x half> %op2) vscale_range(2,0) #0 {
; CHECK-LABEL: fadd_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fadd v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ret
  %res = fadd <8 x half> %op1, %op2
  ret <8 x half> %res
}

define void @fadd_v16f16(ptr %a, ptr %b) vscale_range(2,0) #0 {
; CHECK-LABEL: fadd_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl16
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    ld1h { z1.h }, p0/z, [x1]
; CHECK-NEXT:    fadd z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    st1h { z0.h }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <16 x half>, ptr %a
  %op2 = load <16 x half>, ptr %b
  %res = fadd <16 x half> %op1, %op2
  store <16 x half> %res, ptr %a
  ret void
}

define void @fadd_v32f16(ptr %a, ptr %b) #0 {
; VBITS_GE_256-LABEL: fadd_v32f16:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    mov x8, #16
; VBITS_GE_256-NEXT:    ptrue p0.h, vl16
; VBITS_GE_256-NEXT:    ld1h { z0.h }, p0/z, [x0, x8, lsl #1]
; VBITS_GE_256-NEXT:    ld1h { z1.h }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ld1h { z2.h }, p0/z, [x1, x8, lsl #1]
; VBITS_GE_256-NEXT:    ld1h { z3.h }, p0/z, [x1]
; VBITS_GE_256-NEXT:    fadd z0.h, p0/m, z0.h, z2.h
; VBITS_GE_256-NEXT:    fadd z1.h, p0/m, z1.h, z3.h
; VBITS_GE_256-NEXT:    st1h { z0.h }, p0, [x0, x8, lsl #1]
; VBITS_GE_256-NEXT:    st1h { z1.h }, p0, [x0]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: fadd_v32f16:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.h, vl32
; VBITS_GE_512-NEXT:    ld1h { z0.h }, p0/z, [x0]
; VBITS_GE_512-NEXT:    ld1h { z1.h }, p0/z, [x1]
; VBITS_GE_512-NEXT:    fadd z0.h, p0/m, z0.h, z1.h
; VBITS_GE_512-NEXT:    st1h { z0.h }, p0, [x0]
; VBITS_GE_512-NEXT:    ret
  %op1 = load <32 x half>, ptr %a
  %op2 = load <32 x half>, ptr %b
  %res = fadd <32 x half> %op1, %op2
  store <32 x half> %res, ptr %a
  ret void
}

define void @fadd_v64f16(ptr %a, ptr %b) vscale_range(8,0) #0 {
; CHECK-LABEL: fadd_v64f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl64
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    ld1h { z1.h }, p0/z, [x1]
; CHECK-NEXT:    fadd z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    st1h { z0.h }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <64 x half>, ptr %a
  %op2 = load <64 x half>, ptr %b
  %res = fadd <64 x half> %op1, %op2
  store <64 x half> %res, ptr %a
  ret void
}

define void @fadd_v128f16(ptr %a, ptr %b)  vscale_range(16,0) #0 {
; CHECK-LABEL: fadd_v128f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl128
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    ld1h { z1.h }, p0/z, [x1]
; CHECK-NEXT:    fadd z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    st1h { z0.h }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <128 x half>, ptr %a
  %op2 = load <128 x half>, ptr %b
  %res = fadd <128 x half> %op1, %op2
  store <128 x half> %res, ptr %a
  ret void
}

; Don't use SVE for 64-bit vectors.
define <2 x float> @fadd_v2f32(<2 x float> %op1, <2 x float> %op2) vscale_range(2,0) #0 {
; CHECK-LABEL: fadd_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fadd v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
  %res = fadd <2 x float> %op1, %op2
  ret <2 x float> %res
}

; Don't use SVE for 128-bit vectors.
define <4 x float> @fadd_v4f32(<4 x float> %op1, <4 x float> %op2) vscale_range(2,0) #0 {
; CHECK-LABEL: fadd_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fadd v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
  %res = fadd <4 x float> %op1, %op2
  ret <4 x float> %res
}

define void @fadd_v8f32(ptr %a, ptr %b) vscale_range(2,0) #0 {
; CHECK-LABEL: fadd_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl8
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    ld1w { z1.s }, p0/z, [x1]
; CHECK-NEXT:    fadd z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    st1w { z0.s }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <8 x float>, ptr %a
  %op2 = load <8 x float>, ptr %b
  %res = fadd <8 x float> %op1, %op2
  store <8 x float> %res, ptr %a
  ret void
}

define void @fadd_v16f32(ptr %a, ptr %b) #0 {
; VBITS_GE_256-LABEL: fadd_v16f32:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    mov x8, #8
; VBITS_GE_256-NEXT:    ptrue p0.s, vl8
; VBITS_GE_256-NEXT:    ld1w { z0.s }, p0/z, [x0, x8, lsl #2]
; VBITS_GE_256-NEXT:    ld1w { z1.s }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ld1w { z2.s }, p0/z, [x1, x8, lsl #2]
; VBITS_GE_256-NEXT:    ld1w { z3.s }, p0/z, [x1]
; VBITS_GE_256-NEXT:    fadd z0.s, p0/m, z0.s, z2.s
; VBITS_GE_256-NEXT:    fadd z1.s, p0/m, z1.s, z3.s
; VBITS_GE_256-NEXT:    st1w { z0.s }, p0, [x0, x8, lsl #2]
; VBITS_GE_256-NEXT:    st1w { z1.s }, p0, [x0]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: fadd_v16f32:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.s, vl16
; VBITS_GE_512-NEXT:    ld1w { z0.s }, p0/z, [x0]
; VBITS_GE_512-NEXT:    ld1w { z1.s }, p0/z, [x1]
; VBITS_GE_512-NEXT:    fadd z0.s, p0/m, z0.s, z1.s
; VBITS_GE_512-NEXT:    st1w { z0.s }, p0, [x0]
; VBITS_GE_512-NEXT:    ret
  %op1 = load <16 x float>, ptr %a
  %op2 = load <16 x float>, ptr %b
  %res = fadd <16 x float> %op1, %op2
  store <16 x float> %res, ptr %a
  ret void
}

define void @fadd_v32f32(ptr %a, ptr %b) vscale_range(8,0) #0 {
; CHECK-LABEL: fadd_v32f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl32
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    ld1w { z1.s }, p0/z, [x1]
; CHECK-NEXT:    fadd z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    st1w { z0.s }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <32 x float>, ptr %a
  %op2 = load <32 x float>, ptr %b
  %res = fadd <32 x float> %op1, %op2
  store <32 x float> %res, ptr %a
  ret void
}

define void @fadd_v64f32(ptr %a, ptr %b) vscale_range(16,0) #0 {
; CHECK-LABEL: fadd_v64f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl64
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    ld1w { z1.s }, p0/z, [x1]
; CHECK-NEXT:    fadd z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    st1w { z0.s }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <64 x float>, ptr %a
  %op2 = load <64 x float>, ptr %b
  %res = fadd <64 x float> %op1, %op2
  store <64 x float> %res, ptr %a
  ret void
}

; Don't use SVE for 64-bit vectors.
define <1 x double> @fadd_v1f64(<1 x double> %op1, <1 x double> %op2) vscale_range(2,0) #0 {
; CHECK-LABEL: fadd_v1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fadd d0, d0, d1
; CHECK-NEXT:    ret
  %res = fadd <1 x double> %op1, %op2
  ret <1 x double> %res
}

; Don't use SVE for 128-bit vectors.
define <2 x double> @fadd_v2f64(<2 x double> %op1, <2 x double> %op2) vscale_range(2,0) #0 {
; CHECK-LABEL: fadd_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fadd v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    ret
  %res = fadd <2 x double> %op1, %op2
  ret <2 x double> %res
}

define void @fadd_v4f64(ptr %a, ptr %b) vscale_range(2,0) #0 {
; CHECK-LABEL: fadd_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl4
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0]
; CHECK-NEXT:    ld1d { z1.d }, p0/z, [x1]
; CHECK-NEXT:    fadd z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    st1d { z0.d }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <4 x double>, ptr %a
  %op2 = load <4 x double>, ptr %b
  %res = fadd <4 x double> %op1, %op2
  store <4 x double> %res, ptr %a
  ret void
}

define void @fadd_v8f64(ptr %a, ptr %b) #0 {
; VBITS_GE_256-LABEL: fadd_v8f64:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    mov x8, #4
; VBITS_GE_256-NEXT:    ptrue p0.d, vl4
; VBITS_GE_256-NEXT:    ld1d { z0.d }, p0/z, [x0, x8, lsl #3]
; VBITS_GE_256-NEXT:    ld1d { z1.d }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ld1d { z2.d }, p0/z, [x1, x8, lsl #3]
; VBITS_GE_256-NEXT:    ld1d { z3.d }, p0/z, [x1]
; VBITS_GE_256-NEXT:    fadd z0.d, p0/m, z0.d, z2.d
; VBITS_GE_256-NEXT:    fadd z1.d, p0/m, z1.d, z3.d
; VBITS_GE_256-NEXT:    st1d { z0.d }, p0, [x0, x8, lsl #3]
; VBITS_GE_256-NEXT:    st1d { z1.d }, p0, [x0]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: fadd_v8f64:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.d, vl8
; VBITS_GE_512-NEXT:    ld1d { z0.d }, p0/z, [x0]
; VBITS_GE_512-NEXT:    ld1d { z1.d }, p0/z, [x1]
; VBITS_GE_512-NEXT:    fadd z0.d, p0/m, z0.d, z1.d
; VBITS_GE_512-NEXT:    st1d { z0.d }, p0, [x0]
; VBITS_GE_512-NEXT:    ret
  %op1 = load <8 x double>, ptr %a
  %op2 = load <8 x double>, ptr %b
  %res = fadd <8 x double> %op1, %op2
  store <8 x double> %res, ptr %a
  ret void
}

define void @fadd_v16f64(ptr %a, ptr %b) vscale_range(8,0) #0 {
; CHECK-LABEL: fadd_v16f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl16
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0]
; CHECK-NEXT:    ld1d { z1.d }, p0/z, [x1]
; CHECK-NEXT:    fadd z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    st1d { z0.d }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <16 x double>, ptr %a
  %op2 = load <16 x double>, ptr %b
  %res = fadd <16 x double> %op1, %op2
  store <16 x double> %res, ptr %a
  ret void
}

define void @fadd_v32f64(ptr %a, ptr %b) vscale_range(16,0) #0 {
; CHECK-LABEL: fadd_v32f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl32
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0]
; CHECK-NEXT:    ld1d { z1.d }, p0/z, [x1]
; CHECK-NEXT:    fadd z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    st1d { z0.d }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <32 x double>, ptr %a
  %op2 = load <32 x double>, ptr %b
  %res = fadd <32 x double> %op1, %op2
  store <32 x double> %res, ptr %a
  ret void
}

;
; FDIV
;

; Don't use SVE for 64-bit vectors.
define <4 x half> @fdiv_v4f16(<4 x half> %op1, <4 x half> %op2) vscale_range(2,0) #0 {
; CHECK-LABEL: fdiv_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fdiv v0.4h, v0.4h, v1.4h
; CHECK-NEXT:    ret
  %res = fdiv <4 x half> %op1, %op2
  ret <4 x half> %res
}

; Don't use SVE for 128-bit vectors.
define <8 x half> @fdiv_v8f16(<8 x half> %op1, <8 x half> %op2) vscale_range(2,0) #0 {
; CHECK-LABEL: fdiv_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fdiv v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ret
  %res = fdiv <8 x half> %op1, %op2
  ret <8 x half> %res
}

define void @fdiv_v16f16(ptr %a, ptr %b) vscale_range(2,0) #0 {
; CHECK-LABEL: fdiv_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl16
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    ld1h { z1.h }, p0/z, [x1]
; CHECK-NEXT:    fdiv z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    st1h { z0.h }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <16 x half>, ptr %a
  %op2 = load <16 x half>, ptr %b
  %res = fdiv <16 x half> %op1, %op2
  store <16 x half> %res, ptr %a
  ret void
}

define void @fdiv_v32f16(ptr %a, ptr %b) #0 {
; VBITS_GE_256-LABEL: fdiv_v32f16:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    mov x8, #16
; VBITS_GE_256-NEXT:    ptrue p0.h, vl16
; VBITS_GE_256-NEXT:    ld1h { z0.h }, p0/z, [x0, x8, lsl #1]
; VBITS_GE_256-NEXT:    ld1h { z1.h }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ld1h { z2.h }, p0/z, [x1, x8, lsl #1]
; VBITS_GE_256-NEXT:    ld1h { z3.h }, p0/z, [x1]
; VBITS_GE_256-NEXT:    fdiv z0.h, p0/m, z0.h, z2.h
; VBITS_GE_256-NEXT:    fdiv z1.h, p0/m, z1.h, z3.h
; VBITS_GE_256-NEXT:    st1h { z0.h }, p0, [x0, x8, lsl #1]
; VBITS_GE_256-NEXT:    st1h { z1.h }, p0, [x0]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: fdiv_v32f16:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.h, vl32
; VBITS_GE_512-NEXT:    ld1h { z0.h }, p0/z, [x0]
; VBITS_GE_512-NEXT:    ld1h { z1.h }, p0/z, [x1]
; VBITS_GE_512-NEXT:    fdiv z0.h, p0/m, z0.h, z1.h
; VBITS_GE_512-NEXT:    st1h { z0.h }, p0, [x0]
; VBITS_GE_512-NEXT:    ret
  %op1 = load <32 x half>, ptr %a
  %op2 = load <32 x half>, ptr %b
  %res = fdiv <32 x half> %op1, %op2
  store <32 x half> %res, ptr %a
  ret void
}

define void @fdiv_v64f16(ptr %a, ptr %b) vscale_range(8,0) #0 {
; CHECK-LABEL: fdiv_v64f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl64
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    ld1h { z1.h }, p0/z, [x1]
; CHECK-NEXT:    fdiv z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    st1h { z0.h }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <64 x half>, ptr %a
  %op2 = load <64 x half>, ptr %b
  %res = fdiv <64 x half> %op1, %op2
  store <64 x half> %res, ptr %a
  ret void
}

define void @fdiv_v128f16(ptr %a, ptr %b) vscale_range(16,0) #0 {
; CHECK-LABEL: fdiv_v128f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl128
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    ld1h { z1.h }, p0/z, [x1]
; CHECK-NEXT:    fdiv z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    st1h { z0.h }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <128 x half>, ptr %a
  %op2 = load <128 x half>, ptr %b
  %res = fdiv <128 x half> %op1, %op2
  store <128 x half> %res, ptr %a
  ret void
}

; Don't use SVE for 64-bit vectors.
define <2 x float> @fdiv_v2f32(<2 x float> %op1, <2 x float> %op2) vscale_range(2,0) #0 {
; CHECK-LABEL: fdiv_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fdiv v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
  %res = fdiv <2 x float> %op1, %op2
  ret <2 x float> %res
}

; Don't use SVE for 128-bit vectors.
define <4 x float> @fdiv_v4f32(<4 x float> %op1, <4 x float> %op2) vscale_range(2,0) #0 {
; CHECK-LABEL: fdiv_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fdiv v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
  %res = fdiv <4 x float> %op1, %op2
  ret <4 x float> %res
}

define void @fdiv_v8f32(ptr %a, ptr %b) vscale_range(2,0) #0 {
; CHECK-LABEL: fdiv_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl8
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    ld1w { z1.s }, p0/z, [x1]
; CHECK-NEXT:    fdiv z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    st1w { z0.s }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <8 x float>, ptr %a
  %op2 = load <8 x float>, ptr %b
  %res = fdiv <8 x float> %op1, %op2
  store <8 x float> %res, ptr %a
  ret void
}

define void @fdiv_v16f32(ptr %a, ptr %b) #0 {
; VBITS_GE_256-LABEL: fdiv_v16f32:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    mov x8, #8
; VBITS_GE_256-NEXT:    ptrue p0.s, vl8
; VBITS_GE_256-NEXT:    ld1w { z0.s }, p0/z, [x0, x8, lsl #2]
; VBITS_GE_256-NEXT:    ld1w { z1.s }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ld1w { z2.s }, p0/z, [x1, x8, lsl #2]
; VBITS_GE_256-NEXT:    ld1w { z3.s }, p0/z, [x1]
; VBITS_GE_256-NEXT:    fdiv z0.s, p0/m, z0.s, z2.s
; VBITS_GE_256-NEXT:    fdiv z1.s, p0/m, z1.s, z3.s
; VBITS_GE_256-NEXT:    st1w { z0.s }, p0, [x0, x8, lsl #2]
; VBITS_GE_256-NEXT:    st1w { z1.s }, p0, [x0]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: fdiv_v16f32:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.s, vl16
; VBITS_GE_512-NEXT:    ld1w { z0.s }, p0/z, [x0]
; VBITS_GE_512-NEXT:    ld1w { z1.s }, p0/z, [x1]
; VBITS_GE_512-NEXT:    fdiv z0.s, p0/m, z0.s, z1.s
; VBITS_GE_512-NEXT:    st1w { z0.s }, p0, [x0]
; VBITS_GE_512-NEXT:    ret
  %op1 = load <16 x float>, ptr %a
  %op2 = load <16 x float>, ptr %b
  %res = fdiv <16 x float> %op1, %op2
  store <16 x float> %res, ptr %a
  ret void
}

define void @fdiv_v32f32(ptr %a, ptr %b) vscale_range(8,0) #0 {
; CHECK-LABEL: fdiv_v32f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl32
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    ld1w { z1.s }, p0/z, [x1]
; CHECK-NEXT:    fdiv z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    st1w { z0.s }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <32 x float>, ptr %a
  %op2 = load <32 x float>, ptr %b
  %res = fdiv <32 x float> %op1, %op2
  store <32 x float> %res, ptr %a
  ret void
}

define void @fdiv_v64f32(ptr %a, ptr %b) vscale_range(16,0) #0 {
; CHECK-LABEL: fdiv_v64f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl64
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    ld1w { z1.s }, p0/z, [x1]
; CHECK-NEXT:    fdiv z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    st1w { z0.s }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <64 x float>, ptr %a
  %op2 = load <64 x float>, ptr %b
  %res = fdiv <64 x float> %op1, %op2
  store <64 x float> %res, ptr %a
  ret void
}

; Don't use SVE for 64-bit vectors.
define <1 x double> @fdiv_v1f64(<1 x double> %op1, <1 x double> %op2) vscale_range(2,0) #0 {
; CHECK-LABEL: fdiv_v1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fdiv d0, d0, d1
; CHECK-NEXT:    ret
  %res = fdiv <1 x double> %op1, %op2
  ret <1 x double> %res
}

; Don't use SVE for 128-bit vectors.
define <2 x double> @fdiv_v2f64(<2 x double> %op1, <2 x double> %op2) vscale_range(2,0) #0 {
; CHECK-LABEL: fdiv_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fdiv v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    ret
  %res = fdiv <2 x double> %op1, %op2
  ret <2 x double> %res
}

define void @fdiv_v4f64(ptr %a, ptr %b) vscale_range(2,0) #0 {
; CHECK-LABEL: fdiv_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl4
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0]
; CHECK-NEXT:    ld1d { z1.d }, p0/z, [x1]
; CHECK-NEXT:    fdiv z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    st1d { z0.d }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <4 x double>, ptr %a
  %op2 = load <4 x double>, ptr %b
  %res = fdiv <4 x double> %op1, %op2
  store <4 x double> %res, ptr %a
  ret void
}

define void @fdiv_v8f64(ptr %a, ptr %b) #0 {
; VBITS_GE_256-LABEL: fdiv_v8f64:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    mov x8, #4
; VBITS_GE_256-NEXT:    ptrue p0.d, vl4
; VBITS_GE_256-NEXT:    ld1d { z0.d }, p0/z, [x0, x8, lsl #3]
; VBITS_GE_256-NEXT:    ld1d { z1.d }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ld1d { z2.d }, p0/z, [x1, x8, lsl #3]
; VBITS_GE_256-NEXT:    ld1d { z3.d }, p0/z, [x1]
; VBITS_GE_256-NEXT:    fdiv z0.d, p0/m, z0.d, z2.d
; VBITS_GE_256-NEXT:    fdiv z1.d, p0/m, z1.d, z3.d
; VBITS_GE_256-NEXT:    st1d { z0.d }, p0, [x0, x8, lsl #3]
; VBITS_GE_256-NEXT:    st1d { z1.d }, p0, [x0]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: fdiv_v8f64:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.d, vl8
; VBITS_GE_512-NEXT:    ld1d { z0.d }, p0/z, [x0]
; VBITS_GE_512-NEXT:    ld1d { z1.d }, p0/z, [x1]
; VBITS_GE_512-NEXT:    fdiv z0.d, p0/m, z0.d, z1.d
; VBITS_GE_512-NEXT:    st1d { z0.d }, p0, [x0]
; VBITS_GE_512-NEXT:    ret
  %op1 = load <8 x double>, ptr %a
  %op2 = load <8 x double>, ptr %b
  %res = fdiv <8 x double> %op1, %op2
  store <8 x double> %res, ptr %a
  ret void
}

define void @fdiv_v16f64(ptr %a, ptr %b) vscale_range(8,0) #0 {
; CHECK-LABEL: fdiv_v16f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl16
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0]
; CHECK-NEXT:    ld1d { z1.d }, p0/z, [x1]
; CHECK-NEXT:    fdiv z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    st1d { z0.d }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <16 x double>, ptr %a
  %op2 = load <16 x double>, ptr %b
  %res = fdiv <16 x double> %op1, %op2
  store <16 x double> %res, ptr %a
  ret void
}

define void @fdiv_v32f64(ptr %a, ptr %b) vscale_range(16,0) #0 {
; CHECK-LABEL: fdiv_v32f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl32
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0]
; CHECK-NEXT:    ld1d { z1.d }, p0/z, [x1]
; CHECK-NEXT:    fdiv z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    st1d { z0.d }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <32 x double>, ptr %a
  %op2 = load <32 x double>, ptr %b
  %res = fdiv <32 x double> %op1, %op2
  store <32 x double> %res, ptr %a
  ret void
}

;
; FMA
;

; Don't use SVE for 64-bit vectors.
define <4 x half> @fma_v4f16(<4 x half> %op1, <4 x half> %op2, <4 x half> %op3) vscale_range(2,0) #0 {
; CHECK-LABEL: fma_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmla v2.4h, v1.4h, v0.4h
; CHECK-NEXT:    fmov d0, d2
; CHECK-NEXT:    ret
  %res = call <4 x half> @llvm.fma.v4f16(<4 x half> %op1, <4 x half> %op2, <4 x half> %op3)
  ret <4 x half> %res
}

; Don't use SVE for 128-bit vectors.
define <8 x half> @fma_v8f16(<8 x half> %op1, <8 x half> %op2, <8 x half> %op3) vscale_range(2,0) #0 {
; CHECK-LABEL: fma_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmla v2.8h, v1.8h, v0.8h
; CHECK-NEXT:    mov v0.16b, v2.16b
; CHECK-NEXT:    ret
  %res = call <8 x half> @llvm.fma.v8f16(<8 x half> %op1, <8 x half> %op2, <8 x half> %op3)
  ret <8 x half> %res
}

define void @fma_v16f16(ptr %a, ptr %b, ptr %c) vscale_range(2,0) #0 {
; CHECK-LABEL: fma_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl16
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    ld1h { z1.h }, p0/z, [x1]
; CHECK-NEXT:    ld1h { z2.h }, p0/z, [x2]
; CHECK-NEXT:    fmad z0.h, p0/m, z1.h, z2.h
; CHECK-NEXT:    st1h { z0.h }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <16 x half>, ptr %a
  %op2 = load <16 x half>, ptr %b
  %op3 = load <16 x half>, ptr %c
  %res = call <16 x half> @llvm.fma.v16f16(<16 x half> %op1, <16 x half> %op2, <16 x half> %op3)
  store <16 x half> %res, ptr %a
  ret void
}

define void @fma_v32f16(ptr %a, ptr %b, ptr %c) #0 {
; VBITS_GE_256-LABEL: fma_v32f16:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    mov x8, #16
; VBITS_GE_256-NEXT:    ptrue p0.h, vl16
; VBITS_GE_256-NEXT:    ld1h { z0.h }, p0/z, [x0, x8, lsl #1]
; VBITS_GE_256-NEXT:    ld1h { z1.h }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ld1h { z2.h }, p0/z, [x1, x8, lsl #1]
; VBITS_GE_256-NEXT:    ld1h { z3.h }, p0/z, [x1]
; VBITS_GE_256-NEXT:    ld1h { z4.h }, p0/z, [x2, x8, lsl #1]
; VBITS_GE_256-NEXT:    ld1h { z5.h }, p0/z, [x2]
; VBITS_GE_256-NEXT:    fmad z0.h, p0/m, z2.h, z4.h
; VBITS_GE_256-NEXT:    fmad z1.h, p0/m, z3.h, z5.h
; VBITS_GE_256-NEXT:    st1h { z0.h }, p0, [x0, x8, lsl #1]
; VBITS_GE_256-NEXT:    st1h { z1.h }, p0, [x0]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: fma_v32f16:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.h, vl32
; VBITS_GE_512-NEXT:    ld1h { z0.h }, p0/z, [x0]
; VBITS_GE_512-NEXT:    ld1h { z1.h }, p0/z, [x1]
; VBITS_GE_512-NEXT:    ld1h { z2.h }, p0/z, [x2]
; VBITS_GE_512-NEXT:    fmad z0.h, p0/m, z1.h, z2.h
; VBITS_GE_512-NEXT:    st1h { z0.h }, p0, [x0]
; VBITS_GE_512-NEXT:    ret
  %op1 = load <32 x half>, ptr %a
  %op2 = load <32 x half>, ptr %b
  %op3 = load <32 x half>, ptr %c
  %res = call <32 x half> @llvm.fma.v32f16(<32 x half> %op1, <32 x half> %op2, <32 x half> %op3)
  store <32 x half> %res, ptr %a
  ret void
}

define void @fma_v64f16(ptr %a, ptr %b, ptr %c) vscale_range(8,0) #0 {
; CHECK-LABEL: fma_v64f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl64
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    ld1h { z1.h }, p0/z, [x1]
; CHECK-NEXT:    ld1h { z2.h }, p0/z, [x2]
; CHECK-NEXT:    fmad z0.h, p0/m, z1.h, z2.h
; CHECK-NEXT:    st1h { z0.h }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <64 x half>, ptr %a
  %op2 = load <64 x half>, ptr %b
  %op3 = load <64 x half>, ptr %c
  %res = call <64 x half> @llvm.fma.v64f16(<64 x half> %op1, <64 x half> %op2, <64 x half> %op3)
  store <64 x half> %res, ptr %a
  ret void
}

define void @fma_v128f16(ptr %a, ptr %b, ptr %c) vscale_range(16,0) #0 {
; CHECK-LABEL: fma_v128f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl128
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    ld1h { z1.h }, p0/z, [x1]
; CHECK-NEXT:    ld1h { z2.h }, p0/z, [x2]
; CHECK-NEXT:    fmad z0.h, p0/m, z1.h, z2.h
; CHECK-NEXT:    st1h { z0.h }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <128 x half>, ptr %a
  %op2 = load <128 x half>, ptr %b
  %op3 = load <128 x half>, ptr %c
  %res = call <128 x half> @llvm.fma.v128f16(<128 x half> %op1, <128 x half> %op2, <128 x half> %op3)
  store <128 x half> %res, ptr %a
  ret void
}

; Don't use SVE for 64-bit vectors.
define <2 x float> @fma_v2f32(<2 x float> %op1, <2 x float> %op2, <2 x float> %op3) vscale_range(2,0) #0 {
; CHECK-LABEL: fma_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmla v2.2s, v1.2s, v0.2s
; CHECK-NEXT:    fmov d0, d2
; CHECK-NEXT:    ret
  %res = call <2 x float> @llvm.fma.v2f32(<2 x float> %op1, <2 x float> %op2, <2 x float> %op3)
  ret <2 x float> %res
}

; Don't use SVE for 128-bit vectors.
define <4 x float> @fma_v4f32(<4 x float> %op1, <4 x float> %op2, <4 x float> %op3) vscale_range(2,0) #0 {
; CHECK-LABEL: fma_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmla v2.4s, v1.4s, v0.4s
; CHECK-NEXT:    mov v0.16b, v2.16b
; CHECK-NEXT:    ret
  %res = call <4 x float> @llvm.fma.v4f32(<4 x float> %op1, <4 x float> %op2, <4 x float> %op3)
  ret <4 x float> %res
}

define void @fma_v8f32(ptr %a, ptr %b, ptr %c) vscale_range(2,0) #0 {
; CHECK-LABEL: fma_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl8
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    ld1w { z1.s }, p0/z, [x1]
; CHECK-NEXT:    ld1w { z2.s }, p0/z, [x2]
; CHECK-NEXT:    fmad z0.s, p0/m, z1.s, z2.s
; CHECK-NEXT:    st1w { z0.s }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <8 x float>, ptr %a
  %op2 = load <8 x float>, ptr %b
  %op3 = load <8 x float>, ptr %c
  %res = call <8 x float> @llvm.fma.v8f32(<8 x float> %op1, <8 x float> %op2, <8 x float> %op3)
  store <8 x float> %res, ptr %a
  ret void
}

define void @fma_v16f32(ptr %a, ptr %b, ptr %c) #0 {
; VBITS_GE_256-LABEL: fma_v16f32:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    mov x8, #8
; VBITS_GE_256-NEXT:    ptrue p0.s, vl8
; VBITS_GE_256-NEXT:    ld1w { z0.s }, p0/z, [x0, x8, lsl #2]
; VBITS_GE_256-NEXT:    ld1w { z1.s }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ld1w { z2.s }, p0/z, [x1, x8, lsl #2]
; VBITS_GE_256-NEXT:    ld1w { z3.s }, p0/z, [x1]
; VBITS_GE_256-NEXT:    ld1w { z4.s }, p0/z, [x2, x8, lsl #2]
; VBITS_GE_256-NEXT:    ld1w { z5.s }, p0/z, [x2]
; VBITS_GE_256-NEXT:    fmad z0.s, p0/m, z2.s, z4.s
; VBITS_GE_256-NEXT:    fmad z1.s, p0/m, z3.s, z5.s
; VBITS_GE_256-NEXT:    st1w { z0.s }, p0, [x0, x8, lsl #2]
; VBITS_GE_256-NEXT:    st1w { z1.s }, p0, [x0]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: fma_v16f32:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.s, vl16
; VBITS_GE_512-NEXT:    ld1w { z0.s }, p0/z, [x0]
; VBITS_GE_512-NEXT:    ld1w { z1.s }, p0/z, [x1]
; VBITS_GE_512-NEXT:    ld1w { z2.s }, p0/z, [x2]
; VBITS_GE_512-NEXT:    fmad z0.s, p0/m, z1.s, z2.s
; VBITS_GE_512-NEXT:    st1w { z0.s }, p0, [x0]
; VBITS_GE_512-NEXT:    ret
  %op1 = load <16 x float>, ptr %a
  %op2 = load <16 x float>, ptr %b
  %op3 = load <16 x float>, ptr %c
  %res = call <16 x float> @llvm.fma.v16f32(<16 x float> %op1, <16 x float> %op2, <16 x float> %op3)
  store <16 x float> %res, ptr %a
  ret void
}

define void @fma_v32f32(ptr %a, ptr %b, ptr %c) vscale_range(8,0) #0 {
; CHECK-LABEL: fma_v32f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl32
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    ld1w { z1.s }, p0/z, [x1]
; CHECK-NEXT:    ld1w { z2.s }, p0/z, [x2]
; CHECK-NEXT:    fmad z0.s, p0/m, z1.s, z2.s
; CHECK-NEXT:    st1w { z0.s }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <32 x float>, ptr %a
  %op2 = load <32 x float>, ptr %b
  %op3 = load <32 x float>, ptr %c
  %res = call <32 x float> @llvm.fma.v32f32(<32 x float> %op1, <32 x float> %op2, <32 x float> %op3)
  store <32 x float> %res, ptr %a
  ret void
}

define void @fma_v64f32(ptr %a, ptr %b, ptr %c) vscale_range(16,0) #0 {
; CHECK-LABEL: fma_v64f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl64
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    ld1w { z1.s }, p0/z, [x1]
; CHECK-NEXT:    ld1w { z2.s }, p0/z, [x2]
; CHECK-NEXT:    fmad z0.s, p0/m, z1.s, z2.s
; CHECK-NEXT:    st1w { z0.s }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <64 x float>, ptr %a
  %op2 = load <64 x float>, ptr %b
  %op3 = load <64 x float>, ptr %c
  %res = call <64 x float> @llvm.fma.v64f32(<64 x float> %op1, <64 x float> %op2, <64 x float> %op3)
  store <64 x float> %res, ptr %a
  ret void
}

; Don't use SVE for 64-bit vectors.
define <1 x double> @fma_v1f64(<1 x double> %op1, <1 x double> %op2, <1 x double> %op3) vscale_range(2,0) #0 {
; CHECK-LABEL: fma_v1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmadd d0, d0, d1, d2
; CHECK-NEXT:    ret
  %res = call <1 x double> @llvm.fma.v1f64(<1 x double> %op1, <1 x double> %op2, <1 x double> %op3)
  ret <1 x double> %res
}

; Don't use SVE for 128-bit vectors.
define <2 x double> @fma_v2f64(<2 x double> %op1, <2 x double> %op2, <2 x double> %op3) vscale_range(2,0) #0 {
; CHECK-LABEL: fma_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmla v2.2d, v1.2d, v0.2d
; CHECK-NEXT:    mov v0.16b, v2.16b
; CHECK-NEXT:    ret
  %res = call <2 x double> @llvm.fma.v2f64(<2 x double> %op1, <2 x double> %op2, <2 x double> %op3)
  ret <2 x double> %res
}

define void @fma_v4f64(ptr %a, ptr %b, ptr %c) vscale_range(2,0) #0 {
; CHECK-LABEL: fma_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl4
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0]
; CHECK-NEXT:    ld1d { z1.d }, p0/z, [x1]
; CHECK-NEXT:    ld1d { z2.d }, p0/z, [x2]
; CHECK-NEXT:    fmad z0.d, p0/m, z1.d, z2.d
; CHECK-NEXT:    st1d { z0.d }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <4 x double>, ptr %a
  %op2 = load <4 x double>, ptr %b
  %op3 = load <4 x double>, ptr %c
  %res = call <4 x double> @llvm.fma.v4f64(<4 x double> %op1, <4 x double> %op2, <4 x double> %op3)
  store <4 x double> %res, ptr %a
  ret void
}

define void @fma_v8f64(ptr %a, ptr %b, ptr %c) #0 {
; VBITS_GE_256-LABEL: fma_v8f64:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    mov x8, #4
; VBITS_GE_256-NEXT:    ptrue p0.d, vl4
; VBITS_GE_256-NEXT:    ld1d { z0.d }, p0/z, [x0, x8, lsl #3]
; VBITS_GE_256-NEXT:    ld1d { z1.d }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ld1d { z2.d }, p0/z, [x1, x8, lsl #3]
; VBITS_GE_256-NEXT:    ld1d { z3.d }, p0/z, [x1]
; VBITS_GE_256-NEXT:    ld1d { z4.d }, p0/z, [x2, x8, lsl #3]
; VBITS_GE_256-NEXT:    ld1d { z5.d }, p0/z, [x2]
; VBITS_GE_256-NEXT:    fmad z0.d, p0/m, z2.d, z4.d
; VBITS_GE_256-NEXT:    fmad z1.d, p0/m, z3.d, z5.d
; VBITS_GE_256-NEXT:    st1d { z0.d }, p0, [x0, x8, lsl #3]
; VBITS_GE_256-NEXT:    st1d { z1.d }, p0, [x0]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: fma_v8f64:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.d, vl8
; VBITS_GE_512-NEXT:    ld1d { z0.d }, p0/z, [x0]
; VBITS_GE_512-NEXT:    ld1d { z1.d }, p0/z, [x1]
; VBITS_GE_512-NEXT:    ld1d { z2.d }, p0/z, [x2]
; VBITS_GE_512-NEXT:    fmad z0.d, p0/m, z1.d, z2.d
; VBITS_GE_512-NEXT:    st1d { z0.d }, p0, [x0]
; VBITS_GE_512-NEXT:    ret
  %op1 = load <8 x double>, ptr %a
  %op2 = load <8 x double>, ptr %b
  %op3 = load <8 x double>, ptr %c
  %res = call <8 x double> @llvm.fma.v8f64(<8 x double> %op1, <8 x double> %op2, <8 x double> %op3)
  store <8 x double> %res, ptr %a
  ret void
}

define void @fma_v16f64(ptr %a, ptr %b, ptr %c) vscale_range(8,0) #0 {
; CHECK-LABEL: fma_v16f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl16
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0]
; CHECK-NEXT:    ld1d { z1.d }, p0/z, [x1]
; CHECK-NEXT:    ld1d { z2.d }, p0/z, [x2]
; CHECK-NEXT:    fmad z0.d, p0/m, z1.d, z2.d
; CHECK-NEXT:    st1d { z0.d }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <16 x double>, ptr %a
  %op2 = load <16 x double>, ptr %b
  %op3 = load <16 x double>, ptr %c
  %res = call <16 x double> @llvm.fma.v16f64(<16 x double> %op1, <16 x double> %op2, <16 x double> %op3)
  store <16 x double> %res, ptr %a
  ret void
}

define void @fma_v32f64(ptr %a, ptr %b, ptr %c) vscale_range(16,0) #0 {
; CHECK-LABEL: fma_v32f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl32
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0]
; CHECK-NEXT:    ld1d { z1.d }, p0/z, [x1]
; CHECK-NEXT:    ld1d { z2.d }, p0/z, [x2]
; CHECK-NEXT:    fmad z0.d, p0/m, z1.d, z2.d
; CHECK-NEXT:    st1d { z0.d }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <32 x double>, ptr %a
  %op2 = load <32 x double>, ptr %b
  %op3 = load <32 x double>, ptr %c
  %res = call <32 x double> @llvm.fma.v32f64(<32 x double> %op1, <32 x double> %op2, <32 x double> %op3)
  store <32 x double> %res, ptr %a
  ret void
}

;
; FMUL
;

; Don't use SVE for 64-bit vectors.
define <4 x half> @fmul_v4f16(<4 x half> %op1, <4 x half> %op2) vscale_range(2,0) #0 {
; CHECK-LABEL: fmul_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmul v0.4h, v0.4h, v1.4h
; CHECK-NEXT:    ret
  %res = fmul <4 x half> %op1, %op2
  ret <4 x half> %res
}

; Don't use SVE for 128-bit vectors.
define <8 x half> @fmul_v8f16(<8 x half> %op1, <8 x half> %op2) vscale_range(2,0) #0 {
; CHECK-LABEL: fmul_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmul v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ret
  %res = fmul <8 x half> %op1, %op2
  ret <8 x half> %res
}

define void @fmul_v16f16(ptr %a, ptr %b) vscale_range(2,0) #0 {
; CHECK-LABEL: fmul_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl16
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    ld1h { z1.h }, p0/z, [x1]
; CHECK-NEXT:    fmul z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    st1h { z0.h }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <16 x half>, ptr %a
  %op2 = load <16 x half>, ptr %b
  %res = fmul <16 x half> %op1, %op2
  store <16 x half> %res, ptr %a
  ret void
}

define void @fmul_v32f16(ptr %a, ptr %b) #0 {
; VBITS_GE_256-LABEL: fmul_v32f16:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    mov x8, #16
; VBITS_GE_256-NEXT:    ptrue p0.h, vl16
; VBITS_GE_256-NEXT:    ld1h { z0.h }, p0/z, [x0, x8, lsl #1]
; VBITS_GE_256-NEXT:    ld1h { z1.h }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ld1h { z2.h }, p0/z, [x1, x8, lsl #1]
; VBITS_GE_256-NEXT:    ld1h { z3.h }, p0/z, [x1]
; VBITS_GE_256-NEXT:    fmul z0.h, p0/m, z0.h, z2.h
; VBITS_GE_256-NEXT:    fmul z1.h, p0/m, z1.h, z3.h
; VBITS_GE_256-NEXT:    st1h { z0.h }, p0, [x0, x8, lsl #1]
; VBITS_GE_256-NEXT:    st1h { z1.h }, p0, [x0]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: fmul_v32f16:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.h, vl32
; VBITS_GE_512-NEXT:    ld1h { z0.h }, p0/z, [x0]
; VBITS_GE_512-NEXT:    ld1h { z1.h }, p0/z, [x1]
; VBITS_GE_512-NEXT:    fmul z0.h, p0/m, z0.h, z1.h
; VBITS_GE_512-NEXT:    st1h { z0.h }, p0, [x0]
; VBITS_GE_512-NEXT:    ret
  %op1 = load <32 x half>, ptr %a
  %op2 = load <32 x half>, ptr %b
  %res = fmul <32 x half> %op1, %op2
  store <32 x half> %res, ptr %a
  ret void
}

define void @fmul_v64f16(ptr %a, ptr %b) vscale_range(8,0) #0 {
; CHECK-LABEL: fmul_v64f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl64
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    ld1h { z1.h }, p0/z, [x1]
; CHECK-NEXT:    fmul z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    st1h { z0.h }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <64 x half>, ptr %a
  %op2 = load <64 x half>, ptr %b
  %res = fmul <64 x half> %op1, %op2
  store <64 x half> %res, ptr %a
  ret void
}

define void @fmul_v128f16(ptr %a, ptr %b) vscale_range(16,0) #0 {
; CHECK-LABEL: fmul_v128f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl128
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    ld1h { z1.h }, p0/z, [x1]
; CHECK-NEXT:    fmul z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    st1h { z0.h }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <128 x half>, ptr %a
  %op2 = load <128 x half>, ptr %b
  %res = fmul <128 x half> %op1, %op2
  store <128 x half> %res, ptr %a
  ret void
}

; Don't use SVE for 64-bit vectors.
define <2 x float> @fmul_v2f32(<2 x float> %op1, <2 x float> %op2) vscale_range(2,0) #0 {
; CHECK-LABEL: fmul_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmul v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
  %res = fmul <2 x float> %op1, %op2
  ret <2 x float> %res
}

; Don't use SVE for 128-bit vectors.
define <4 x float> @fmul_v4f32(<4 x float> %op1, <4 x float> %op2) vscale_range(2,0) #0 {
; CHECK-LABEL: fmul_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmul v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
  %res = fmul <4 x float> %op1, %op2
  ret <4 x float> %res
}

define void @fmul_v8f32(ptr %a, ptr %b) vscale_range(2,0) #0 {
; CHECK-LABEL: fmul_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl8
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    ld1w { z1.s }, p0/z, [x1]
; CHECK-NEXT:    fmul z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    st1w { z0.s }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <8 x float>, ptr %a
  %op2 = load <8 x float>, ptr %b
  %res = fmul <8 x float> %op1, %op2
  store <8 x float> %res, ptr %a
  ret void
}

define void @fmul_v16f32(ptr %a, ptr %b) #0 {
; VBITS_GE_256-LABEL: fmul_v16f32:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    mov x8, #8
; VBITS_GE_256-NEXT:    ptrue p0.s, vl8
; VBITS_GE_256-NEXT:    ld1w { z0.s }, p0/z, [x0, x8, lsl #2]
; VBITS_GE_256-NEXT:    ld1w { z1.s }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ld1w { z2.s }, p0/z, [x1, x8, lsl #2]
; VBITS_GE_256-NEXT:    ld1w { z3.s }, p0/z, [x1]
; VBITS_GE_256-NEXT:    fmul z0.s, p0/m, z0.s, z2.s
; VBITS_GE_256-NEXT:    fmul z1.s, p0/m, z1.s, z3.s
; VBITS_GE_256-NEXT:    st1w { z0.s }, p0, [x0, x8, lsl #2]
; VBITS_GE_256-NEXT:    st1w { z1.s }, p0, [x0]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: fmul_v16f32:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.s, vl16
; VBITS_GE_512-NEXT:    ld1w { z0.s }, p0/z, [x0]
; VBITS_GE_512-NEXT:    ld1w { z1.s }, p0/z, [x1]
; VBITS_GE_512-NEXT:    fmul z0.s, p0/m, z0.s, z1.s
; VBITS_GE_512-NEXT:    st1w { z0.s }, p0, [x0]
; VBITS_GE_512-NEXT:    ret
  %op1 = load <16 x float>, ptr %a
  %op2 = load <16 x float>, ptr %b
  %res = fmul <16 x float> %op1, %op2
  store <16 x float> %res, ptr %a
  ret void
}

define void @fmul_v32f32(ptr %a, ptr %b) vscale_range(8,0) #0 {
; CHECK-LABEL: fmul_v32f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl32
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    ld1w { z1.s }, p0/z, [x1]
; CHECK-NEXT:    fmul z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    st1w { z0.s }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <32 x float>, ptr %a
  %op2 = load <32 x float>, ptr %b
  %res = fmul <32 x float> %op1, %op2
  store <32 x float> %res, ptr %a
  ret void
}

define void @fmul_v64f32(ptr %a, ptr %b) vscale_range(16,0) #0 {
; CHECK-LABEL: fmul_v64f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl64
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    ld1w { z1.s }, p0/z, [x1]
; CHECK-NEXT:    fmul z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    st1w { z0.s }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <64 x float>, ptr %a
  %op2 = load <64 x float>, ptr %b
  %res = fmul <64 x float> %op1, %op2
  store <64 x float> %res, ptr %a
  ret void
}

; Don't use SVE for 64-bit vectors.
define <1 x double> @fmul_v1f64(<1 x double> %op1, <1 x double> %op2) vscale_range(2,0) #0 {
; CHECK-LABEL: fmul_v1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmul d0, d0, d1
; CHECK-NEXT:    ret
  %res = fmul <1 x double> %op1, %op2
  ret <1 x double> %res
}

; Don't use SVE for 128-bit vectors.
define <2 x double> @fmul_v2f64(<2 x double> %op1, <2 x double> %op2) vscale_range(2,0) #0 {
; CHECK-LABEL: fmul_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmul v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    ret
  %res = fmul <2 x double> %op1, %op2
  ret <2 x double> %res
}

define void @fmul_v4f64(ptr %a, ptr %b) vscale_range(2,0) #0 {
; CHECK-LABEL: fmul_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl4
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0]
; CHECK-NEXT:    ld1d { z1.d }, p0/z, [x1]
; CHECK-NEXT:    fmul z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    st1d { z0.d }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <4 x double>, ptr %a
  %op2 = load <4 x double>, ptr %b
  %res = fmul <4 x double> %op1, %op2
  store <4 x double> %res, ptr %a
  ret void
}

define void @fmul_v8f64(ptr %a, ptr %b) #0 {
; VBITS_GE_256-LABEL: fmul_v8f64:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    mov x8, #4
; VBITS_GE_256-NEXT:    ptrue p0.d, vl4
; VBITS_GE_256-NEXT:    ld1d { z0.d }, p0/z, [x0, x8, lsl #3]
; VBITS_GE_256-NEXT:    ld1d { z1.d }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ld1d { z2.d }, p0/z, [x1, x8, lsl #3]
; VBITS_GE_256-NEXT:    ld1d { z3.d }, p0/z, [x1]
; VBITS_GE_256-NEXT:    fmul z0.d, p0/m, z0.d, z2.d
; VBITS_GE_256-NEXT:    fmul z1.d, p0/m, z1.d, z3.d
; VBITS_GE_256-NEXT:    st1d { z0.d }, p0, [x0, x8, lsl #3]
; VBITS_GE_256-NEXT:    st1d { z1.d }, p0, [x0]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: fmul_v8f64:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.d, vl8
; VBITS_GE_512-NEXT:    ld1d { z0.d }, p0/z, [x0]
; VBITS_GE_512-NEXT:    ld1d { z1.d }, p0/z, [x1]
; VBITS_GE_512-NEXT:    fmul z0.d, p0/m, z0.d, z1.d
; VBITS_GE_512-NEXT:    st1d { z0.d }, p0, [x0]
; VBITS_GE_512-NEXT:    ret
  %op1 = load <8 x double>, ptr %a
  %op2 = load <8 x double>, ptr %b
  %res = fmul <8 x double> %op1, %op2
  store <8 x double> %res, ptr %a
  ret void
}

define void @fmul_v16f64(ptr %a, ptr %b) vscale_range(8,0) #0 {
; CHECK-LABEL: fmul_v16f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl16
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0]
; CHECK-NEXT:    ld1d { z1.d }, p0/z, [x1]
; CHECK-NEXT:    fmul z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    st1d { z0.d }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <16 x double>, ptr %a
  %op2 = load <16 x double>, ptr %b
  %res = fmul <16 x double> %op1, %op2
  store <16 x double> %res, ptr %a
  ret void
}

define void @fmul_v32f64(ptr %a, ptr %b) vscale_range(16,0) #0 {
; CHECK-LABEL: fmul_v32f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl32
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0]
; CHECK-NEXT:    ld1d { z1.d }, p0/z, [x1]
; CHECK-NEXT:    fmul z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    st1d { z0.d }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <32 x double>, ptr %a
  %op2 = load <32 x double>, ptr %b
  %res = fmul <32 x double> %op1, %op2
  store <32 x double> %res, ptr %a
  ret void
}

;
; FNEG
;

; Don't use SVE for 64-bit vectors.
define <4 x half> @fneg_v4f16(<4 x half> %op) vscale_range(2,0) #0 {
; CHECK-LABEL: fneg_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fneg v0.4h, v0.4h
; CHECK-NEXT:    ret
  %res = fneg <4 x half> %op
  ret <4 x half> %res
}

; Don't use SVE for 128-bit vectors.
define <8 x half> @fneg_v8f16(<8 x half> %op) vscale_range(2,0) #0 {
; CHECK-LABEL: fneg_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fneg v0.8h, v0.8h
; CHECK-NEXT:    ret
  %res = fneg <8 x half> %op
  ret <8 x half> %res
}

define void @fneg_v16f16(ptr %a, ptr %b) vscale_range(2,0) #0 {
; CHECK-LABEL: fneg_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl16
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    fneg z0.h, p0/m, z0.h
; CHECK-NEXT:    st1h { z0.h }, p0, [x0]
; CHECK-NEXT:    ret
  %op = load <16 x half>, ptr %a
  %res = fneg <16 x half> %op
  store <16 x half> %res, ptr %a
  ret void
}

define void @fneg_v32f16(ptr %a) #0 {
; VBITS_GE_256-LABEL: fneg_v32f16:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    mov x8, #16
; VBITS_GE_256-NEXT:    ptrue p0.h, vl16
; VBITS_GE_256-NEXT:    ld1h { z0.h }, p0/z, [x0, x8, lsl #1]
; VBITS_GE_256-NEXT:    ld1h { z1.h }, p0/z, [x0]
; VBITS_GE_256-NEXT:    fneg z0.h, p0/m, z0.h
; VBITS_GE_256-NEXT:    fneg z1.h, p0/m, z1.h
; VBITS_GE_256-NEXT:    st1h { z0.h }, p0, [x0, x8, lsl #1]
; VBITS_GE_256-NEXT:    st1h { z1.h }, p0, [x0]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: fneg_v32f16:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.h, vl32
; VBITS_GE_512-NEXT:    ld1h { z0.h }, p0/z, [x0]
; VBITS_GE_512-NEXT:    fneg z0.h, p0/m, z0.h
; VBITS_GE_512-NEXT:    st1h { z0.h }, p0, [x0]
; VBITS_GE_512-NEXT:    ret
  %op = load <32 x half>, ptr %a
  %res = fneg <32 x half> %op
  store <32 x half> %res, ptr %a
  ret void
}

define void @fneg_v64f16(ptr %a) vscale_range(8,0) #0 {
; CHECK-LABEL: fneg_v64f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl64
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    fneg z0.h, p0/m, z0.h
; CHECK-NEXT:    st1h { z0.h }, p0, [x0]
; CHECK-NEXT:    ret
  %op = load <64 x half>, ptr %a
  %res = fneg <64 x half> %op
  store <64 x half> %res, ptr %a
  ret void
}

define void @fneg_v128f16(ptr %a) vscale_range(16,0) #0 {
; CHECK-LABEL: fneg_v128f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl128
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    fneg z0.h, p0/m, z0.h
; CHECK-NEXT:    st1h { z0.h }, p0, [x0]
; CHECK-NEXT:    ret
  %op = load <128 x half>, ptr %a
  %res = fneg <128 x half> %op
  store <128 x half> %res, ptr %a
  ret void
}

; Don't use SVE for 64-bit vectors.
define <2 x float> @fneg_v2f32(<2 x float> %op) vscale_range(2,0) #0 {
; CHECK-LABEL: fneg_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fneg v0.2s, v0.2s
; CHECK-NEXT:    ret
  %res = fneg <2 x float> %op
  ret <2 x float> %res
}

; Don't use SVE for 128-bit vectors.
define <4 x float> @fneg_v4f32(<4 x float> %op) vscale_range(2,0) #0 {
; CHECK-LABEL: fneg_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fneg v0.4s, v0.4s
; CHECK-NEXT:    ret
  %res = fneg <4 x float> %op
  ret <4 x float> %res
}

define void @fneg_v8f32(ptr %a) vscale_range(2,0) #0 {
; CHECK-LABEL: fneg_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl8
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    fneg z0.s, p0/m, z0.s
; CHECK-NEXT:    st1w { z0.s }, p0, [x0]
; CHECK-NEXT:    ret
  %op = load <8 x float>, ptr %a
  %res = fneg <8 x float> %op
  store <8 x float> %res, ptr %a
  ret void
}

define void @fneg_v16f32(ptr %a) #0 {
; VBITS_GE_256-LABEL: fneg_v16f32:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    mov x8, #8
; VBITS_GE_256-NEXT:    ptrue p0.s, vl8
; VBITS_GE_256-NEXT:    ld1w { z0.s }, p0/z, [x0, x8, lsl #2]
; VBITS_GE_256-NEXT:    ld1w { z1.s }, p0/z, [x0]
; VBITS_GE_256-NEXT:    fneg z0.s, p0/m, z0.s
; VBITS_GE_256-NEXT:    fneg z1.s, p0/m, z1.s
; VBITS_GE_256-NEXT:    st1w { z0.s }, p0, [x0, x8, lsl #2]
; VBITS_GE_256-NEXT:    st1w { z1.s }, p0, [x0]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: fneg_v16f32:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.s, vl16
; VBITS_GE_512-NEXT:    ld1w { z0.s }, p0/z, [x0]
; VBITS_GE_512-NEXT:    fneg z0.s, p0/m, z0.s
; VBITS_GE_512-NEXT:    st1w { z0.s }, p0, [x0]
; VBITS_GE_512-NEXT:    ret
  %op = load <16 x float>, ptr %a
  %res = fneg <16 x float> %op
  store <16 x float> %res, ptr %a
  ret void
}

define void @fneg_v32f32(ptr %a) vscale_range(8,0) #0 {
; CHECK-LABEL: fneg_v32f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl32
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    fneg z0.s, p0/m, z0.s
; CHECK-NEXT:    st1w { z0.s }, p0, [x0]
; CHECK-NEXT:    ret
  %op = load <32 x float>, ptr %a
  %res = fneg <32 x float> %op
  store <32 x float> %res, ptr %a
  ret void
}

define void @fneg_v64f32(ptr %a) vscale_range(16,0) #0 {
; CHECK-LABEL: fneg_v64f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl64
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    fneg z0.s, p0/m, z0.s
; CHECK-NEXT:    st1w { z0.s }, p0, [x0]
; CHECK-NEXT:    ret
  %op = load <64 x float>, ptr %a
  %res = fneg <64 x float> %op
  store <64 x float> %res, ptr %a
  ret void
}

; Don't use SVE for 64-bit vectors.
define <1 x double> @fneg_v1f64(<1 x double> %op) vscale_range(2,0) #0 {
; CHECK-LABEL: fneg_v1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fneg d0, d0
; CHECK-NEXT:    ret
  %res = fneg <1 x double> %op
  ret <1 x double> %res
}

; Don't use SVE for 128-bit vectors.
define <2 x double> @fneg_v2f64(<2 x double> %op) vscale_range(2,0) #0 {
; CHECK-LABEL: fneg_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fneg v0.2d, v0.2d
; CHECK-NEXT:    ret
  %res = fneg <2 x double> %op
  ret <2 x double> %res
}

define void @fneg_v4f64(ptr %a) vscale_range(2,0) #0 {
; CHECK-LABEL: fneg_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl4
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0]
; CHECK-NEXT:    fneg z0.d, p0/m, z0.d
; CHECK-NEXT:    st1d { z0.d }, p0, [x0]
; CHECK-NEXT:    ret
  %op = load <4 x double>, ptr %a
  %res = fneg <4 x double> %op
  store <4 x double> %res, ptr %a
  ret void
}

define void @fneg_v8f64(ptr %a) #0 {
; VBITS_GE_256-LABEL: fneg_v8f64:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    mov x8, #4
; VBITS_GE_256-NEXT:    ptrue p0.d, vl4
; VBITS_GE_256-NEXT:    ld1d { z0.d }, p0/z, [x0, x8, lsl #3]
; VBITS_GE_256-NEXT:    ld1d { z1.d }, p0/z, [x0]
; VBITS_GE_256-NEXT:    fneg z0.d, p0/m, z0.d
; VBITS_GE_256-NEXT:    fneg z1.d, p0/m, z1.d
; VBITS_GE_256-NEXT:    st1d { z0.d }, p0, [x0, x8, lsl #3]
; VBITS_GE_256-NEXT:    st1d { z1.d }, p0, [x0]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: fneg_v8f64:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.d, vl8
; VBITS_GE_512-NEXT:    ld1d { z0.d }, p0/z, [x0]
; VBITS_GE_512-NEXT:    fneg z0.d, p0/m, z0.d
; VBITS_GE_512-NEXT:    st1d { z0.d }, p0, [x0]
; VBITS_GE_512-NEXT:    ret
  %op = load <8 x double>, ptr %a
  %res = fneg <8 x double> %op
  store <8 x double> %res, ptr %a
  ret void
}

define void @fneg_v16f64(ptr %a) vscale_range(8,0) #0 {
; CHECK-LABEL: fneg_v16f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl16
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0]
; CHECK-NEXT:    fneg z0.d, p0/m, z0.d
; CHECK-NEXT:    st1d { z0.d }, p0, [x0]
; CHECK-NEXT:    ret
  %op = load <16 x double>, ptr %a
  %res = fneg <16 x double> %op
  store <16 x double> %res, ptr %a
  ret void
}

define void @fneg_v32f64(ptr %a) vscale_range(16,0) #0 {
; CHECK-LABEL: fneg_v32f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl32
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0]
; CHECK-NEXT:    fneg z0.d, p0/m, z0.d
; CHECK-NEXT:    st1d { z0.d }, p0, [x0]
; CHECK-NEXT:    ret
  %op = load <32 x double>, ptr %a
  %res = fneg <32 x double> %op
  store <32 x double> %res, ptr %a
  ret void
}

;
; FSQRT
;

; Don't use SVE for 64-bit vectors.
define <4 x half> @fsqrt_v4f16(<4 x half> %op) vscale_range(2,0) #0 {
; CHECK-LABEL: fsqrt_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fsqrt v0.4h, v0.4h
; CHECK-NEXT:    ret
  %res = call <4 x half> @llvm.sqrt.v4f16(<4 x half> %op)
  ret <4 x half> %res
}

; Don't use SVE for 128-bit vectors.
define <8 x half> @fsqrt_v8f16(<8 x half> %op) vscale_range(2,0) #0 {
; CHECK-LABEL: fsqrt_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fsqrt v0.8h, v0.8h
; CHECK-NEXT:    ret
  %res = call <8 x half> @llvm.sqrt.v8f16(<8 x half> %op)
  ret <8 x half> %res
}

define void @fsqrt_v16f16(ptr %a, ptr %b) vscale_range(2,0) #0 {
; CHECK-LABEL: fsqrt_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl16
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    fsqrt z0.h, p0/m, z0.h
; CHECK-NEXT:    st1h { z0.h }, p0, [x0]
; CHECK-NEXT:    ret
  %op = load <16 x half>, ptr %a
  %res = call <16 x half> @llvm.sqrt.v16f16(<16 x half> %op)
  store <16 x half> %res, ptr %a
  ret void
}

define void @fsqrt_v32f16(ptr %a) #0 {
; VBITS_GE_256-LABEL: fsqrt_v32f16:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    mov x8, #16
; VBITS_GE_256-NEXT:    ptrue p0.h, vl16
; VBITS_GE_256-NEXT:    ld1h { z0.h }, p0/z, [x0, x8, lsl #1]
; VBITS_GE_256-NEXT:    ld1h { z1.h }, p0/z, [x0]
; VBITS_GE_256-NEXT:    fsqrt z0.h, p0/m, z0.h
; VBITS_GE_256-NEXT:    fsqrt z1.h, p0/m, z1.h
; VBITS_GE_256-NEXT:    st1h { z0.h }, p0, [x0, x8, lsl #1]
; VBITS_GE_256-NEXT:    st1h { z1.h }, p0, [x0]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: fsqrt_v32f16:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.h, vl32
; VBITS_GE_512-NEXT:    ld1h { z0.h }, p0/z, [x0]
; VBITS_GE_512-NEXT:    fsqrt z0.h, p0/m, z0.h
; VBITS_GE_512-NEXT:    st1h { z0.h }, p0, [x0]
; VBITS_GE_512-NEXT:    ret
  %op = load <32 x half>, ptr %a
  %res = call <32 x half> @llvm.sqrt.v32f16(<32 x half> %op)
  store <32 x half> %res, ptr %a
  ret void
}

define void @fsqrt_v64f16(ptr %a) vscale_range(8,0) #0 {
; CHECK-LABEL: fsqrt_v64f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl64
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    fsqrt z0.h, p0/m, z0.h
; CHECK-NEXT:    st1h { z0.h }, p0, [x0]
; CHECK-NEXT:    ret
  %op = load <64 x half>, ptr %a
  %res = call <64 x half> @llvm.sqrt.v64f16(<64 x half> %op)
  store <64 x half> %res, ptr %a
  ret void
}

define void @fsqrt_v128f16(ptr %a) vscale_range(16,0) #0 {
; CHECK-LABEL: fsqrt_v128f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl128
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    fsqrt z0.h, p0/m, z0.h
; CHECK-NEXT:    st1h { z0.h }, p0, [x0]
; CHECK-NEXT:    ret
  %op = load <128 x half>, ptr %a
  %res = call <128 x half> @llvm.sqrt.v128f16(<128 x half> %op)
  store <128 x half> %res, ptr %a
  ret void
}

; Don't use SVE for 64-bit vectors.
define <2 x float> @fsqrt_v2f32(<2 x float> %op) vscale_range(2,0) #0 {
; CHECK-LABEL: fsqrt_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fsqrt v0.2s, v0.2s
; CHECK-NEXT:    ret
  %res = call <2 x float> @llvm.sqrt.v2f32(<2 x float> %op)
  ret <2 x float> %res
}

; Don't use SVE for 128-bit vectors.
define <4 x float> @fsqrt_v4f32(<4 x float> %op) vscale_range(2,0) #0 {
; CHECK-LABEL: fsqrt_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fsqrt v0.4s, v0.4s
; CHECK-NEXT:    ret
  %res = call <4 x float> @llvm.sqrt.v4f32(<4 x float> %op)
  ret <4 x float> %res
}

define void @fsqrt_v8f32(ptr %a) vscale_range(2,0) #0 {
; CHECK-LABEL: fsqrt_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl8
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    fsqrt z0.s, p0/m, z0.s
; CHECK-NEXT:    st1w { z0.s }, p0, [x0]
; CHECK-NEXT:    ret
  %op = load <8 x float>, ptr %a
  %res = call <8 x float> @llvm.sqrt.v8f32(<8 x float> %op)
  store <8 x float> %res, ptr %a
  ret void
}

define void @fsqrt_v16f32(ptr %a) #0 {
; VBITS_GE_256-LABEL: fsqrt_v16f32:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    mov x8, #8
; VBITS_GE_256-NEXT:    ptrue p0.s, vl8
; VBITS_GE_256-NEXT:    ld1w { z0.s }, p0/z, [x0, x8, lsl #2]
; VBITS_GE_256-NEXT:    ld1w { z1.s }, p0/z, [x0]
; VBITS_GE_256-NEXT:    fsqrt z0.s, p0/m, z0.s
; VBITS_GE_256-NEXT:    fsqrt z1.s, p0/m, z1.s
; VBITS_GE_256-NEXT:    st1w { z0.s }, p0, [x0, x8, lsl #2]
; VBITS_GE_256-NEXT:    st1w { z1.s }, p0, [x0]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: fsqrt_v16f32:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.s, vl16
; VBITS_GE_512-NEXT:    ld1w { z0.s }, p0/z, [x0]
; VBITS_GE_512-NEXT:    fsqrt z0.s, p0/m, z0.s
; VBITS_GE_512-NEXT:    st1w { z0.s }, p0, [x0]
; VBITS_GE_512-NEXT:    ret
  %op = load <16 x float>, ptr %a
  %res = call <16 x float> @llvm.sqrt.v16f32(<16 x float> %op)
  store <16 x float> %res, ptr %a
  ret void
}

define void @fsqrt_v32f32(ptr %a) vscale_range(8,0) #0 {
; CHECK-LABEL: fsqrt_v32f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl32
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    fsqrt z0.s, p0/m, z0.s
; CHECK-NEXT:    st1w { z0.s }, p0, [x0]
; CHECK-NEXT:    ret
  %op = load <32 x float>, ptr %a
  %res = call <32 x float> @llvm.sqrt.v32f32(<32 x float> %op)
  store <32 x float> %res, ptr %a
  ret void
}

define void @fsqrt_v64f32(ptr %a) vscale_range(16,0) #0 {
; CHECK-LABEL: fsqrt_v64f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl64
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    fsqrt z0.s, p0/m, z0.s
; CHECK-NEXT:    st1w { z0.s }, p0, [x0]
; CHECK-NEXT:    ret
  %op = load <64 x float>, ptr %a
  %res = call <64 x float> @llvm.sqrt.v64f32(<64 x float> %op)
  store <64 x float> %res, ptr %a
  ret void
}

; Don't use SVE for 64-bit vectors.
define <1 x double> @fsqrt_v1f64(<1 x double> %op) vscale_range(2,0) #0 {
; CHECK-LABEL: fsqrt_v1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fsqrt d0, d0
; CHECK-NEXT:    ret
  %res = call <1 x double> @llvm.sqrt.v1f64(<1 x double> %op)
  ret <1 x double> %res
}

; Don't use SVE for 128-bit vectors.
define <2 x double> @fsqrt_v2f64(<2 x double> %op) vscale_range(2,0) #0 {
; CHECK-LABEL: fsqrt_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fsqrt v0.2d, v0.2d
; CHECK-NEXT:    ret
  %res = call <2 x double> @llvm.sqrt.v2f64(<2 x double> %op)
  ret <2 x double> %res
}

define void @fsqrt_v4f64(ptr %a) vscale_range(2,0) #0 {
; CHECK-LABEL: fsqrt_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl4
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0]
; CHECK-NEXT:    fsqrt z0.d, p0/m, z0.d
; CHECK-NEXT:    st1d { z0.d }, p0, [x0]
; CHECK-NEXT:    ret
  %op = load <4 x double>, ptr %a
  %res = call <4 x double> @llvm.sqrt.v4f64(<4 x double> %op)
  store <4 x double> %res, ptr %a
  ret void
}

define void @fsqrt_v8f64(ptr %a) #0 {
; VBITS_GE_256-LABEL: fsqrt_v8f64:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    mov x8, #4
; VBITS_GE_256-NEXT:    ptrue p0.d, vl4
; VBITS_GE_256-NEXT:    ld1d { z0.d }, p0/z, [x0, x8, lsl #3]
; VBITS_GE_256-NEXT:    ld1d { z1.d }, p0/z, [x0]
; VBITS_GE_256-NEXT:    fsqrt z0.d, p0/m, z0.d
; VBITS_GE_256-NEXT:    fsqrt z1.d, p0/m, z1.d
; VBITS_GE_256-NEXT:    st1d { z0.d }, p0, [x0, x8, lsl #3]
; VBITS_GE_256-NEXT:    st1d { z1.d }, p0, [x0]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: fsqrt_v8f64:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.d, vl8
; VBITS_GE_512-NEXT:    ld1d { z0.d }, p0/z, [x0]
; VBITS_GE_512-NEXT:    fsqrt z0.d, p0/m, z0.d
; VBITS_GE_512-NEXT:    st1d { z0.d }, p0, [x0]
; VBITS_GE_512-NEXT:    ret
  %op = load <8 x double>, ptr %a
  %res = call <8 x double> @llvm.sqrt.v8f64(<8 x double> %op)
  store <8 x double> %res, ptr %a
  ret void
}

define void @fsqrt_v16f64(ptr %a) vscale_range(8,0) #0 {
; CHECK-LABEL: fsqrt_v16f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl16
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0]
; CHECK-NEXT:    fsqrt z0.d, p0/m, z0.d
; CHECK-NEXT:    st1d { z0.d }, p0, [x0]
; CHECK-NEXT:    ret
  %op = load <16 x double>, ptr %a
  %res = call <16 x double> @llvm.sqrt.v16f64(<16 x double> %op)
  store <16 x double> %res, ptr %a
  ret void
}

define void @fsqrt_v32f64(ptr %a) vscale_range(16,0) #0 {
; CHECK-LABEL: fsqrt_v32f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl32
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0]
; CHECK-NEXT:    fsqrt z0.d, p0/m, z0.d
; CHECK-NEXT:    st1d { z0.d }, p0, [x0]
; CHECK-NEXT:    ret
  %op = load <32 x double>, ptr %a
  %res = call <32 x double> @llvm.sqrt.v32f64(<32 x double> %op)
  store <32 x double> %res, ptr %a
  ret void
}

;
; FSUB
;

; Don't use SVE for 64-bit vectors.
define <4 x half> @fsub_v4f16(<4 x half> %op1, <4 x half> %op2) vscale_range(2,0) #0 {
; CHECK-LABEL: fsub_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fsub v0.4h, v0.4h, v1.4h
; CHECK-NEXT:    ret
  %res = fsub <4 x half> %op1, %op2
  ret <4 x half> %res
}

; Don't use SVE for 128-bit vectors.
define <8 x half> @fsub_v8f16(<8 x half> %op1, <8 x half> %op2) vscale_range(2,0) #0 {
; CHECK-LABEL: fsub_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fsub v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ret
  %res = fsub <8 x half> %op1, %op2
  ret <8 x half> %res
}

define void @fsub_v16f16(ptr %a, ptr %b) vscale_range(2,0) #0 {
; CHECK-LABEL: fsub_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl16
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    ld1h { z1.h }, p0/z, [x1]
; CHECK-NEXT:    fsub z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    st1h { z0.h }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <16 x half>, ptr %a
  %op2 = load <16 x half>, ptr %b
  %res = fsub <16 x half> %op1, %op2
  store <16 x half> %res, ptr %a
  ret void
}

define void @fsub_v32f16(ptr %a, ptr %b) #0 {
; VBITS_GE_256-LABEL: fsub_v32f16:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    mov x8, #16
; VBITS_GE_256-NEXT:    ptrue p0.h, vl16
; VBITS_GE_256-NEXT:    ld1h { z0.h }, p0/z, [x0, x8, lsl #1]
; VBITS_GE_256-NEXT:    ld1h { z1.h }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ld1h { z2.h }, p0/z, [x1, x8, lsl #1]
; VBITS_GE_256-NEXT:    ld1h { z3.h }, p0/z, [x1]
; VBITS_GE_256-NEXT:    fsub z0.h, p0/m, z0.h, z2.h
; VBITS_GE_256-NEXT:    fsub z1.h, p0/m, z1.h, z3.h
; VBITS_GE_256-NEXT:    st1h { z0.h }, p0, [x0, x8, lsl #1]
; VBITS_GE_256-NEXT:    st1h { z1.h }, p0, [x0]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: fsub_v32f16:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.h, vl32
; VBITS_GE_512-NEXT:    ld1h { z0.h }, p0/z, [x0]
; VBITS_GE_512-NEXT:    ld1h { z1.h }, p0/z, [x1]
; VBITS_GE_512-NEXT:    fsub z0.h, p0/m, z0.h, z1.h
; VBITS_GE_512-NEXT:    st1h { z0.h }, p0, [x0]
; VBITS_GE_512-NEXT:    ret
  %op1 = load <32 x half>, ptr %a
  %op2 = load <32 x half>, ptr %b
  %res = fsub <32 x half> %op1, %op2
  store <32 x half> %res, ptr %a
  ret void
}

define void @fsub_v64f16(ptr %a, ptr %b) vscale_range(8,0) #0 {
; CHECK-LABEL: fsub_v64f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl64
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    ld1h { z1.h }, p0/z, [x1]
; CHECK-NEXT:    fsub z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    st1h { z0.h }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <64 x half>, ptr %a
  %op2 = load <64 x half>, ptr %b
  %res = fsub <64 x half> %op1, %op2
  store <64 x half> %res, ptr %a
  ret void
}

define void @fsub_v128f16(ptr %a, ptr %b) vscale_range(16,0) #0 {
; CHECK-LABEL: fsub_v128f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl128
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    ld1h { z1.h }, p0/z, [x1]
; CHECK-NEXT:    fsub z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    st1h { z0.h }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <128 x half>, ptr %a
  %op2 = load <128 x half>, ptr %b
  %res = fsub <128 x half> %op1, %op2
  store <128 x half> %res, ptr %a
  ret void
}

; Don't use SVE for 64-bit vectors.
define <2 x float> @fsub_v2f32(<2 x float> %op1, <2 x float> %op2) vscale_range(2,0) #0 {
; CHECK-LABEL: fsub_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fsub v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
  %res = fsub <2 x float> %op1, %op2
  ret <2 x float> %res
}

; Don't use SVE for 128-bit vectors.
define <4 x float> @fsub_v4f32(<4 x float> %op1, <4 x float> %op2) vscale_range(2,0) #0 {
; CHECK-LABEL: fsub_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fsub v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
  %res = fsub <4 x float> %op1, %op2
  ret <4 x float> %res
}

define void @fsub_v8f32(ptr %a, ptr %b) vscale_range(2,0) #0 {
; CHECK-LABEL: fsub_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl8
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    ld1w { z1.s }, p0/z, [x1]
; CHECK-NEXT:    fsub z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    st1w { z0.s }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <8 x float>, ptr %a
  %op2 = load <8 x float>, ptr %b
  %res = fsub <8 x float> %op1, %op2
  store <8 x float> %res, ptr %a
  ret void
}

define void @fsub_v16f32(ptr %a, ptr %b) #0 {
; VBITS_GE_256-LABEL: fsub_v16f32:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    mov x8, #8
; VBITS_GE_256-NEXT:    ptrue p0.s, vl8
; VBITS_GE_256-NEXT:    ld1w { z0.s }, p0/z, [x0, x8, lsl #2]
; VBITS_GE_256-NEXT:    ld1w { z1.s }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ld1w { z2.s }, p0/z, [x1, x8, lsl #2]
; VBITS_GE_256-NEXT:    ld1w { z3.s }, p0/z, [x1]
; VBITS_GE_256-NEXT:    fsub z0.s, p0/m, z0.s, z2.s
; VBITS_GE_256-NEXT:    fsub z1.s, p0/m, z1.s, z3.s
; VBITS_GE_256-NEXT:    st1w { z0.s }, p0, [x0, x8, lsl #2]
; VBITS_GE_256-NEXT:    st1w { z1.s }, p0, [x0]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: fsub_v16f32:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.s, vl16
; VBITS_GE_512-NEXT:    ld1w { z0.s }, p0/z, [x0]
; VBITS_GE_512-NEXT:    ld1w { z1.s }, p0/z, [x1]
; VBITS_GE_512-NEXT:    fsub z0.s, p0/m, z0.s, z1.s
; VBITS_GE_512-NEXT:    st1w { z0.s }, p0, [x0]
; VBITS_GE_512-NEXT:    ret
  %op1 = load <16 x float>, ptr %a
  %op2 = load <16 x float>, ptr %b
  %res = fsub <16 x float> %op1, %op2
  store <16 x float> %res, ptr %a
  ret void
}

define void @fsub_v32f32(ptr %a, ptr %b) vscale_range(8,0) #0 {
; CHECK-LABEL: fsub_v32f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl32
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    ld1w { z1.s }, p0/z, [x1]
; CHECK-NEXT:    fsub z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    st1w { z0.s }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <32 x float>, ptr %a
  %op2 = load <32 x float>, ptr %b
  %res = fsub <32 x float> %op1, %op2
  store <32 x float> %res, ptr %a
  ret void
}

define void @fsub_v64f32(ptr %a, ptr %b) vscale_range(16,0) #0 {
; CHECK-LABEL: fsub_v64f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl64
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    ld1w { z1.s }, p0/z, [x1]
; CHECK-NEXT:    fsub z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    st1w { z0.s }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <64 x float>, ptr %a
  %op2 = load <64 x float>, ptr %b
  %res = fsub <64 x float> %op1, %op2
  store <64 x float> %res, ptr %a
  ret void
}

; Don't use SVE for 64-bit vectors.
define <1 x double> @fsub_v1f64(<1 x double> %op1, <1 x double> %op2) vscale_range(2,0) #0 {
; CHECK-LABEL: fsub_v1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fsub d0, d0, d1
; CHECK-NEXT:    ret
  %res = fsub <1 x double> %op1, %op2
  ret <1 x double> %res
}

; Don't use SVE for 128-bit vectors.
define <2 x double> @fsub_v2f64(<2 x double> %op1, <2 x double> %op2) vscale_range(2,0) #0 {
; CHECK-LABEL: fsub_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fsub v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    ret
  %res = fsub <2 x double> %op1, %op2
  ret <2 x double> %res
}

define void @fsub_v4f64(ptr %a, ptr %b) vscale_range(2,0) #0 {
; CHECK-LABEL: fsub_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl4
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0]
; CHECK-NEXT:    ld1d { z1.d }, p0/z, [x1]
; CHECK-NEXT:    fsub z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    st1d { z0.d }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <4 x double>, ptr %a
  %op2 = load <4 x double>, ptr %b
  %res = fsub <4 x double> %op1, %op2
  store <4 x double> %res, ptr %a
  ret void
}

define void @fsub_v8f64(ptr %a, ptr %b) #0 {
; VBITS_GE_256-LABEL: fsub_v8f64:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    mov x8, #4
; VBITS_GE_256-NEXT:    ptrue p0.d, vl4
; VBITS_GE_256-NEXT:    ld1d { z0.d }, p0/z, [x0, x8, lsl #3]
; VBITS_GE_256-NEXT:    ld1d { z1.d }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ld1d { z2.d }, p0/z, [x1, x8, lsl #3]
; VBITS_GE_256-NEXT:    ld1d { z3.d }, p0/z, [x1]
; VBITS_GE_256-NEXT:    fsub z0.d, p0/m, z0.d, z2.d
; VBITS_GE_256-NEXT:    fsub z1.d, p0/m, z1.d, z3.d
; VBITS_GE_256-NEXT:    st1d { z0.d }, p0, [x0, x8, lsl #3]
; VBITS_GE_256-NEXT:    st1d { z1.d }, p0, [x0]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: fsub_v8f64:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.d, vl8
; VBITS_GE_512-NEXT:    ld1d { z0.d }, p0/z, [x0]
; VBITS_GE_512-NEXT:    ld1d { z1.d }, p0/z, [x1]
; VBITS_GE_512-NEXT:    fsub z0.d, p0/m, z0.d, z1.d
; VBITS_GE_512-NEXT:    st1d { z0.d }, p0, [x0]
; VBITS_GE_512-NEXT:    ret
  %op1 = load <8 x double>, ptr %a
  %op2 = load <8 x double>, ptr %b
  %res = fsub <8 x double> %op1, %op2
  store <8 x double> %res, ptr %a
  ret void
}

define void @fsub_v16f64(ptr %a, ptr %b) vscale_range(8,0) #0 {
; CHECK-LABEL: fsub_v16f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl16
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0]
; CHECK-NEXT:    ld1d { z1.d }, p0/z, [x1]
; CHECK-NEXT:    fsub z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    st1d { z0.d }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <16 x double>, ptr %a
  %op2 = load <16 x double>, ptr %b
  %res = fsub <16 x double> %op1, %op2
  store <16 x double> %res, ptr %a
  ret void
}

define void @fsub_v32f64(ptr %a, ptr %b) vscale_range(16,0) #0 {
; CHECK-LABEL: fsub_v32f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl32
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0]
; CHECK-NEXT:    ld1d { z1.d }, p0/z, [x1]
; CHECK-NEXT:    fsub z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    st1d { z0.d }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <32 x double>, ptr %a
  %op2 = load <32 x double>, ptr %b
  %res = fsub <32 x double> %op1, %op2
  store <32 x double> %res, ptr %a
  ret void
}

;
; FABS
;

; Don't use SVE for 64-bit vectors.
define <4 x half> @fabs_v4f16(<4 x half> %op) vscale_range(2,0) #0 {
; CHECK-LABEL: fabs_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fabs v0.4h, v0.4h
; CHECK-NEXT:    ret
  %res = call <4 x half> @llvm.fabs.v4f16(<4 x half> %op)
  ret <4 x half> %res
}

; Don't use SVE for 128-bit vectors.
define <8 x half> @fabs_v8f16(<8 x half> %op) vscale_range(2,0) #0 {
; CHECK-LABEL: fabs_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fabs v0.8h, v0.8h
; CHECK-NEXT:    ret
  %res = call <8 x half> @llvm.fabs.v8f16(<8 x half> %op)
  ret <8 x half> %res
}

define void @fabs_v16f16(ptr %a) vscale_range(2,0) #0 {
; CHECK-LABEL: fabs_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl16
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    fabs z0.h, p0/m, z0.h
; CHECK-NEXT:    st1h { z0.h }, p0, [x0]
; CHECK-NEXT:    ret
  %op = load <16 x half>, ptr %a
  %res = call <16 x half> @llvm.fabs.v16f16(<16 x half> %op)
  store <16 x half> %res, ptr %a
  ret void
}

define void @fabs_v32f16(ptr %a) #0 {
; VBITS_GE_256-LABEL: fabs_v32f16:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    mov x8, #16
; VBITS_GE_256-NEXT:    ptrue p0.h, vl16
; VBITS_GE_256-NEXT:    ld1h { z0.h }, p0/z, [x0, x8, lsl #1]
; VBITS_GE_256-NEXT:    ld1h { z1.h }, p0/z, [x0]
; VBITS_GE_256-NEXT:    fabs z0.h, p0/m, z0.h
; VBITS_GE_256-NEXT:    fabs z1.h, p0/m, z1.h
; VBITS_GE_256-NEXT:    st1h { z0.h }, p0, [x0, x8, lsl #1]
; VBITS_GE_256-NEXT:    st1h { z1.h }, p0, [x0]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: fabs_v32f16:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.h, vl32
; VBITS_GE_512-NEXT:    ld1h { z0.h }, p0/z, [x0]
; VBITS_GE_512-NEXT:    fabs z0.h, p0/m, z0.h
; VBITS_GE_512-NEXT:    st1h { z0.h }, p0, [x0]
; VBITS_GE_512-NEXT:    ret
  %op = load <32 x half>, ptr %a
  %res = call <32 x half> @llvm.fabs.v32f16(<32 x half> %op)
  store <32 x half> %res, ptr %a
  ret void
}

define void @fabs_v64f16(ptr %a) vscale_range(8,0) #0 {
; CHECK-LABEL: fabs_v64f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl64
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    fabs z0.h, p0/m, z0.h
; CHECK-NEXT:    st1h { z0.h }, p0, [x0]
; CHECK-NEXT:    ret
  %op = load <64 x half>, ptr %a
  %res = call <64 x half> @llvm.fabs.v64f16(<64 x half> %op)
  store <64 x half> %res, ptr %a
  ret void
}

define void @fabs_v128f16(ptr %a) vscale_range(16,0) #0 {
; CHECK-LABEL: fabs_v128f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl128
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    fabs z0.h, p0/m, z0.h
; CHECK-NEXT:    st1h { z0.h }, p0, [x0]
; CHECK-NEXT:    ret
  %op = load <128 x half>, ptr %a
  %res = call <128 x half> @llvm.fabs.v128f16(<128 x half> %op)
  store <128 x half> %res, ptr %a
  ret void
}

; Don't use SVE for 64-bit vectors.
define <2 x float> @fabs_v2f32(<2 x float> %op) vscale_range(2,0) #0 {
; CHECK-LABEL: fabs_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fabs v0.2s, v0.2s
; CHECK-NEXT:    ret
  %res = call <2 x float> @llvm.fabs.v2f32(<2 x float> %op)
  ret <2 x float> %res
}

; Don't use SVE for 128-bit vectors.
define <4 x float> @fabs_v4f32(<4 x float> %op) vscale_range(2,0) #0 {
; CHECK-LABEL: fabs_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fabs v0.4s, v0.4s
; CHECK-NEXT:    ret
  %res = call <4 x float> @llvm.fabs.v4f32(<4 x float> %op)
  ret <4 x float> %res
}

define void @fabs_v8f32(ptr %a) vscale_range(2,0) #0 {
; CHECK-LABEL: fabs_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl8
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    fabs z0.s, p0/m, z0.s
; CHECK-NEXT:    st1w { z0.s }, p0, [x0]
; CHECK-NEXT:    ret
  %op = load <8 x float>, ptr %a
  %res = call <8 x float> @llvm.fabs.v8f32(<8 x float> %op)
  store <8 x float> %res, ptr %a
  ret void
}

define void @fabs_v16f32(ptr %a) #0 {
; VBITS_GE_256-LABEL: fabs_v16f32:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    mov x8, #8
; VBITS_GE_256-NEXT:    ptrue p0.s, vl8
; VBITS_GE_256-NEXT:    ld1w { z0.s }, p0/z, [x0, x8, lsl #2]
; VBITS_GE_256-NEXT:    ld1w { z1.s }, p0/z, [x0]
; VBITS_GE_256-NEXT:    fabs z0.s, p0/m, z0.s
; VBITS_GE_256-NEXT:    fabs z1.s, p0/m, z1.s
; VBITS_GE_256-NEXT:    st1w { z0.s }, p0, [x0, x8, lsl #2]
; VBITS_GE_256-NEXT:    st1w { z1.s }, p0, [x0]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: fabs_v16f32:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.s, vl16
; VBITS_GE_512-NEXT:    ld1w { z0.s }, p0/z, [x0]
; VBITS_GE_512-NEXT:    fabs z0.s, p0/m, z0.s
; VBITS_GE_512-NEXT:    st1w { z0.s }, p0, [x0]
; VBITS_GE_512-NEXT:    ret
  %op = load <16 x float>, ptr %a
  %res = call <16 x float> @llvm.fabs.v16f32(<16 x float> %op)
  store <16 x float> %res, ptr %a
  ret void
}

define void @fabs_v32f32(ptr %a) vscale_range(8,0) #0 {
; CHECK-LABEL: fabs_v32f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl32
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    fabs z0.s, p0/m, z0.s
; CHECK-NEXT:    st1w { z0.s }, p0, [x0]
; CHECK-NEXT:    ret
  %op = load <32 x float>, ptr %a
  %res = call <32 x float> @llvm.fabs.v32f32(<32 x float> %op)
  store <32 x float> %res, ptr %a
  ret void
}

define void @fabs_v64f32(ptr %a) vscale_range(16,0) #0 {
; CHECK-LABEL: fabs_v64f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl64
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    fabs z0.s, p0/m, z0.s
; CHECK-NEXT:    st1w { z0.s }, p0, [x0]
; CHECK-NEXT:    ret
  %op = load <64 x float>, ptr %a
  %res = call <64 x float> @llvm.fabs.v64f32(<64 x float> %op)
  store <64 x float> %res, ptr %a
  ret void
}

; Don't use SVE for 64-bit vectors.
define <1 x double> @fabs_v1f64(<1 x double> %op) vscale_range(2,0) #0 {
; CHECK-LABEL: fabs_v1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fabs d0, d0
; CHECK-NEXT:    ret
  %res = call <1 x double> @llvm.fabs.v1f64(<1 x double> %op)
  ret <1 x double> %res
}

; Don't use SVE for 128-bit vectors.
define <2 x double> @fabs_v2f64(<2 x double> %op) vscale_range(2,0) #0 {
; CHECK-LABEL: fabs_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fabs v0.2d, v0.2d
; CHECK-NEXT:    ret
  %res = call <2 x double> @llvm.fabs.v2f64(<2 x double> %op)
  ret <2 x double> %res
}

define void @fabs_v4f64(ptr %a) vscale_range(2,0) #0 {
; CHECK-LABEL: fabs_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl4
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0]
; CHECK-NEXT:    fabs z0.d, p0/m, z0.d
; CHECK-NEXT:    st1d { z0.d }, p0, [x0]
; CHECK-NEXT:    ret
  %op = load <4 x double>, ptr %a
  %res = call <4 x double> @llvm.fabs.v4f64(<4 x double> %op)
  store <4 x double> %res, ptr %a
  ret void
}

define void @fabs_v8f64(ptr %a) #0 {
; VBITS_GE_256-LABEL: fabs_v8f64:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    mov x8, #4
; VBITS_GE_256-NEXT:    ptrue p0.d, vl4
; VBITS_GE_256-NEXT:    ld1d { z0.d }, p0/z, [x0, x8, lsl #3]
; VBITS_GE_256-NEXT:    ld1d { z1.d }, p0/z, [x0]
; VBITS_GE_256-NEXT:    fabs z0.d, p0/m, z0.d
; VBITS_GE_256-NEXT:    fabs z1.d, p0/m, z1.d
; VBITS_GE_256-NEXT:    st1d { z0.d }, p0, [x0, x8, lsl #3]
; VBITS_GE_256-NEXT:    st1d { z1.d }, p0, [x0]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: fabs_v8f64:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.d, vl8
; VBITS_GE_512-NEXT:    ld1d { z0.d }, p0/z, [x0]
; VBITS_GE_512-NEXT:    fabs z0.d, p0/m, z0.d
; VBITS_GE_512-NEXT:    st1d { z0.d }, p0, [x0]
; VBITS_GE_512-NEXT:    ret
  %op = load <8 x double>, ptr %a
  %res = call <8 x double> @llvm.fabs.v8f64(<8 x double> %op)
  store <8 x double> %res, ptr %a
  ret void
}

define void @fabs_v16f64(ptr %a) vscale_range(8,0) #0 {
; CHECK-LABEL: fabs_v16f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl16
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0]
; CHECK-NEXT:    fabs z0.d, p0/m, z0.d
; CHECK-NEXT:    st1d { z0.d }, p0, [x0]
; CHECK-NEXT:    ret
  %op = load <16 x double>, ptr %a
  %res = call <16 x double> @llvm.fabs.v16f64(<16 x double> %op)
  store <16 x double> %res, ptr %a
  ret void
}

define void @fabs_v32f64(ptr %a) vscale_range(16,0) #0 {
; CHECK-LABEL: fabs_v32f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl32
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0]
; CHECK-NEXT:    fabs z0.d, p0/m, z0.d
; CHECK-NEXT:    st1d { z0.d }, p0, [x0]
; CHECK-NEXT:    ret
  %op = load <32 x double>, ptr %a
  %res = call <32 x double> @llvm.fabs.v32f64(<32 x double> %op)
  store <32 x double> %res, ptr %a
  ret void
}

attributes #0 = { "target-features"="+sve" }

declare <4 x half> @llvm.fma.v4f16(<4 x half>, <4 x half>, <4 x half>)
declare <8 x half> @llvm.fma.v8f16(<8 x half>, <8 x half>, <8 x half>)
declare <16 x half> @llvm.fma.v16f16(<16 x half>, <16 x half>, <16 x half>)
declare <32 x half> @llvm.fma.v32f16(<32 x half>, <32 x half>, <32 x half>)
declare <64 x half> @llvm.fma.v64f16(<64 x half>, <64 x half>, <64 x half>)
declare <128 x half> @llvm.fma.v128f16(<128 x half>, <128 x half>, <128 x half>)
declare <2 x float> @llvm.fma.v2f32(<2 x float>, <2 x float>, <2 x float>)
declare <4 x float> @llvm.fma.v4f32(<4 x float>, <4 x float>, <4 x float>)
declare <8 x float> @llvm.fma.v8f32(<8 x float>, <8 x float>, <8 x float>)
declare <16 x float> @llvm.fma.v16f32(<16 x float>, <16 x float>, <16 x float>)
declare <32 x float> @llvm.fma.v32f32(<32 x float>, <32 x float>, <32 x float>)
declare <64 x float> @llvm.fma.v64f32(<64 x float>, <64 x float>, <64 x float>)
declare <1 x double> @llvm.fma.v1f64(<1 x double>, <1 x double>, <1 x double>)
declare <2 x double> @llvm.fma.v2f64(<2 x double>, <2 x double>, <2 x double>)
declare <4 x double> @llvm.fma.v4f64(<4 x double>, <4 x double>, <4 x double>)
declare <8 x double> @llvm.fma.v8f64(<8 x double>, <8 x double>, <8 x double>)
declare <16 x double> @llvm.fma.v16f64(<16 x double>, <16 x double>, <16 x double>)
declare <32 x double> @llvm.fma.v32f64(<32 x double>, <32 x double>, <32 x double>)

declare <4 x half> @llvm.sqrt.v4f16(<4 x half>)
declare <8 x half> @llvm.sqrt.v8f16(<8 x half>)
declare <16 x half> @llvm.sqrt.v16f16(<16 x half>)
declare <32 x half> @llvm.sqrt.v32f16(<32 x half>)
declare <64 x half> @llvm.sqrt.v64f16(<64 x half>)
declare <128 x half> @llvm.sqrt.v128f16(<128 x half>)
declare <2 x float> @llvm.sqrt.v2f32(<2 x float>)
declare <4 x float> @llvm.sqrt.v4f32(<4 x float>)
declare <8 x float> @llvm.sqrt.v8f32(<8 x float>)
declare <16 x float> @llvm.sqrt.v16f32(<16 x float>)
declare <32 x float> @llvm.sqrt.v32f32(<32 x float>)
declare <64 x float> @llvm.sqrt.v64f32(<64 x float>)
declare <1 x double> @llvm.sqrt.v1f64(<1 x double>)
declare <2 x double> @llvm.sqrt.v2f64(<2 x double>)
declare <4 x double> @llvm.sqrt.v4f64(<4 x double>)
declare <8 x double> @llvm.sqrt.v8f64(<8 x double>)
declare <16 x double> @llvm.sqrt.v16f64(<16 x double>)
declare <32 x double> @llvm.sqrt.v32f64(<32 x double>)

declare <4 x half> @llvm.fabs.v4f16(<4 x half>)
declare <8 x half> @llvm.fabs.v8f16(<8 x half>)
declare <16 x half> @llvm.fabs.v16f16(<16 x half>)
declare <32 x half> @llvm.fabs.v32f16(<32 x half>)
declare <64 x half> @llvm.fabs.v64f16(<64 x half>)
declare <128 x half> @llvm.fabs.v128f16(<128 x half>)
declare <2 x float> @llvm.fabs.v2f32(<2 x float>)
declare <4 x float> @llvm.fabs.v4f32(<4 x float>)
declare <8 x float> @llvm.fabs.v8f32(<8 x float>)
declare <16 x float> @llvm.fabs.v16f32(<16 x float>)
declare <32 x float> @llvm.fabs.v32f32(<32 x float>)
declare <64 x float> @llvm.fabs.v64f32(<64 x float>)
declare <1 x double> @llvm.fabs.v1f64(<1 x double>)
declare <2 x double> @llvm.fabs.v2f64(<2 x double>)
declare <4 x double> @llvm.fabs.v4f64(<4 x double>)
declare <8 x double> @llvm.fabs.v8f64(<8 x double>)
declare <16 x double> @llvm.fabs.v16f64(<16 x double>)
declare <32 x double> @llvm.fabs.v32f64(<32 x double>)
