; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -march=amdgcn -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX900,SDAG-GFX900 %s
; RUN: llc -march=amdgcn -mcpu=gfx906 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX906,SDAG-GFX906 %s
; RUN: llc -march=amdgcn -mcpu=fiji -verify-machineinstrs < %s | FileCheck -check-prefixes=VI,SDAG-VI %s
; RUN: llc -march=amdgcn -mcpu=hawaii -verify-machineinstrs < %s | FileCheck -check-prefixes=CI,SDAG-CI %s

; RUN: llc -global-isel -march=amdgcn -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX900,GISEL-GFX900 %s
; RUN: llc -global-isel -march=amdgcn -mcpu=gfx906 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX906,GISEL-GFX906 %s
; RUN: llc -global-isel -march=amdgcn -mcpu=fiji -verify-machineinstrs < %s | FileCheck -check-prefixes=VI,GISEL-VI %s
; RUN: llc -global-isel -march=amdgcn -mcpu=hawaii -verify-machineinstrs < %s | FileCheck -check-prefixes=CI,GISEL-CI %s

define half @mixlo_simple(float %src0, float %src1, float %src2) #0 {
; GFX900-LABEL: mixlo_simple:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mad_mixlo_f16 v0, v0, v1, v2
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: mixlo_simple:
; GFX906:       ; %bb.0:
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    v_fma_mixlo_f16 v0, v0, v1, v2
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: mixlo_simple:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mac_f32_e32 v2, v0, v1
; VI-NEXT:    v_cvt_f16_f32_e32 v0, v2
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-CI-LABEL: mixlo_simple:
; SDAG-CI:       ; %bb.0:
; SDAG-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-CI-NEXT:    v_mac_f32_e32 v2, v0, v1
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v2
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-CI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-CI-LABEL: mixlo_simple:
; GISEL-CI:       ; %bb.0:
; GISEL-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-CI-NEXT:    v_mac_f32_e32 v2, v0, v1
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v0, v2
; GISEL-CI-NEXT:    s_setpc_b64 s[30:31]
  %result = call float @llvm.fmuladd.f32(float %src0, float %src1, float %src2)
  %cvt.result = fptrunc float %result to half
  ret half %cvt.result
}

define half @v_mad_mixlo_f16_f16lo_f16lo_f16lo(half %src0, half %src1, half %src2) #0 {
; GFX900-LABEL: v_mad_mixlo_f16_f16lo_f16lo_f16lo:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mad_mixlo_f16 v0, v0, v1, v2 op_sel_hi:[1,1,1]
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: v_mad_mixlo_f16_f16lo_f16lo_f16lo:
; GFX906:       ; %bb.0:
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    v_fma_mixlo_f16 v0, v0, v1, v2 op_sel_hi:[1,1,1]
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_mad_mixlo_f16_f16lo_f16lo_f16lo:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; VI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; VI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; VI-NEXT:    v_mac_f32_e32 v2, v0, v1
; VI-NEXT:    v_cvt_f16_f32_e32 v0, v2
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-CI-LABEL: v_mad_mixlo_f16_f16lo_f16lo_f16lo:
; SDAG-CI:       ; %bb.0:
; SDAG-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-CI-NEXT:    v_mac_f32_e32 v2, v0, v1
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v2
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-CI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-CI-LABEL: v_mad_mixlo_f16_f16lo_f16lo_f16lo:
; GISEL-CI:       ; %bb.0:
; GISEL-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GISEL-CI-NEXT:    v_mac_f32_e32 v2, v0, v1
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v0, v2
; GISEL-CI-NEXT:    s_setpc_b64 s[30:31]
  %src0.ext = fpext half %src0 to float
  %src1.ext = fpext half %src1 to float
  %src2.ext = fpext half %src2 to float
  %result = tail call float @llvm.fmuladd.f32(float %src0.ext, float %src1.ext, float %src2.ext)
  %cvt.result = fptrunc float %result to half
  ret half %cvt.result
}

define half @v_mad_mixlo_f16_f16lo_f16lo_f32(half %src0, half %src1, float %src2) #0 {
; GFX900-LABEL: v_mad_mixlo_f16_f16lo_f16lo_f32:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mad_mixlo_f16 v0, v0, v1, v2 op_sel_hi:[1,1,0]
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: v_mad_mixlo_f16_f16lo_f16lo_f32:
; GFX906:       ; %bb.0:
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    v_fma_mixlo_f16 v0, v0, v1, v2 op_sel_hi:[1,1,0]
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_mad_mixlo_f16_f16lo_f16lo_f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; VI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; VI-NEXT:    v_mac_f32_e32 v2, v0, v1
; VI-NEXT:    v_cvt_f16_f32_e32 v0, v2
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-CI-LABEL: v_mad_mixlo_f16_f16lo_f16lo_f32:
; SDAG-CI:       ; %bb.0:
; SDAG-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-CI-NEXT:    v_mac_f32_e32 v2, v0, v1
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v2
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-CI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-CI-LABEL: v_mad_mixlo_f16_f16lo_f16lo_f32:
; GISEL-CI:       ; %bb.0:
; GISEL-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-CI-NEXT:    v_mac_f32_e32 v2, v0, v1
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v0, v2
; GISEL-CI-NEXT:    s_setpc_b64 s[30:31]
  %src0.ext = fpext half %src0 to float
  %src1.ext = fpext half %src1 to float
  %result = tail call float @llvm.fmuladd.f32(float %src0.ext, float %src1.ext, float %src2)
  %cvt.result = fptrunc float %result to half
  ret half %cvt.result
}

define half @v_mad_mixlo_f16_f16lo_f16lo_f32_clamp_post_cvt(half %src0, half %src1, float %src2) #0 {
; GFX900-LABEL: v_mad_mixlo_f16_f16lo_f16lo_f32_clamp_post_cvt:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mad_mixlo_f16 v0, v0, v1, v2 op_sel_hi:[1,1,0] clamp
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: v_mad_mixlo_f16_f16lo_f16lo_f32_clamp_post_cvt:
; GFX906:       ; %bb.0:
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    v_fma_mixlo_f16 v0, v0, v1, v2 op_sel_hi:[1,1,0] clamp
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_mad_mixlo_f16_f16lo_f16lo_f32_clamp_post_cvt:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; VI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; VI-NEXT:    v_mac_f32_e32 v2, v0, v1
; VI-NEXT:    v_cvt_f16_f32_e64 v0, v2 clamp
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-CI-LABEL: v_mad_mixlo_f16_f16lo_f16lo_f32_clamp_post_cvt:
; SDAG-CI:       ; %bb.0:
; SDAG-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-CI-NEXT:    v_mac_f32_e32 v2, v0, v1
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v2
; SDAG-CI-NEXT:    v_cvt_f32_f16_e64 v0, v0 clamp
; SDAG-CI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-CI-LABEL: v_mad_mixlo_f16_f16lo_f16lo_f32_clamp_post_cvt:
; GISEL-CI:       ; %bb.0:
; GISEL-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-CI-NEXT:    v_mac_f32_e32 v2, v0, v1
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v0, v2
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, 0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-CI-NEXT:    v_max_f32_e32 v0, v0, v1
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, 1.0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-CI-NEXT:    v_min_f32_e32 v0, v0, v1
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GISEL-CI-NEXT:    s_setpc_b64 s[30:31]
  %src0.ext = fpext half %src0 to float
  %src1.ext = fpext half %src1 to float
  %result = tail call float @llvm.fmuladd.f32(float %src0.ext, float %src1.ext, float %src2)
  %cvt.result = fptrunc float %result to half
  %max = call half @llvm.maxnum.f16(half %cvt.result, half 0.0)
  %clamp = call half @llvm.minnum.f16(half %max, half 1.0)
  ret half %clamp
}

define half @v_mad_mixlo_f16_f16lo_f16lo_f32_clamp_pre_cvt(half %src0, half %src1, float %src2) #0 {
; GFX900-LABEL: v_mad_mixlo_f16_f16lo_f16lo_f32_clamp_pre_cvt:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mad_mix_f32 v0, v0, v1, v2 op_sel_hi:[1,1,0] clamp
; GFX900-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: v_mad_mixlo_f16_f16lo_f16lo_f32_clamp_pre_cvt:
; GFX906:       ; %bb.0:
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    v_fma_mix_f32 v0, v0, v1, v2 op_sel_hi:[1,1,0] clamp
; GFX906-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_mad_mixlo_f16_f16lo_f16lo_f32_clamp_pre_cvt:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; VI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; VI-NEXT:    v_mad_f32 v0, v0, v1, v2 clamp
; VI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-CI-LABEL: v_mad_mixlo_f16_f16lo_f16lo_f32_clamp_pre_cvt:
; SDAG-CI:       ; %bb.0:
; SDAG-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-CI-NEXT:    v_mad_f32 v0, v0, v1, v2 clamp
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-CI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-CI-LABEL: v_mad_mixlo_f16_f16lo_f16lo_f32_clamp_pre_cvt:
; GISEL-CI:       ; %bb.0:
; GISEL-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-CI-NEXT:    v_mad_f32 v0, v0, v1, v2 clamp
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GISEL-CI-NEXT:    s_setpc_b64 s[30:31]
  %src0.ext = fpext half %src0 to float
  %src1.ext = fpext half %src1 to float
  %result = tail call float @llvm.fmuladd.f32(float %src0.ext, float %src1.ext, float %src2)
  %max = call float @llvm.maxnum.f32(float %result, float 0.0)
  %clamp = call float @llvm.minnum.f32(float %max, float 1.0)
  %cvt.result = fptrunc float %clamp to half
  ret half %cvt.result
}

; FIXME(DAG): Should abe able to avoid extra register because first
; operation only clobbers relevant lane.

define <2 x half> @v_mad_mix_v2f32(<2 x half> %src0, <2 x half> %src1, <2 x half> %src2) #0 {
; GFX900-LABEL: v_mad_mix_v2f32:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mad_mixlo_f16 v3, v0, v1, v2 op_sel_hi:[1,1,1]
; GFX900-NEXT:    v_mad_mixhi_f16 v3, v0, v1, v2 op_sel:[1,1,1] op_sel_hi:[1,1,1]
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: v_mad_mix_v2f32:
; GFX906:       ; %bb.0:
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    v_fma_mixlo_f16 v3, v0, v1, v2 op_sel_hi:[1,1,1]
; GFX906-NEXT:    v_fma_mixhi_f16 v3, v0, v1, v2 op_sel:[1,1,1] op_sel_hi:[1,1,1]
; GFX906-NEXT:    v_mov_b32_e32 v0, v3
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-VI-LABEL: v_mad_mix_v2f32:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SDAG-VI-NEXT:    v_mac_f32_e32 v5, v3, v4
; SDAG-VI-NEXT:    v_mac_f32_e32 v2, v0, v1
; SDAG-VI-NEXT:    v_cvt_f16_f32_sdwa v0, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; SDAG-VI-NEXT:    v_cvt_f16_f32_e32 v1, v2
; SDAG-VI-NEXT:    v_or_b32_e32 v0, v1, v0
; SDAG-VI-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-CI-LABEL: v_mad_mix_v2f32:
; SDAG-CI:       ; %bb.0:
; SDAG-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-CI-NEXT:    v_mac_f32_e32 v5, v1, v3
; SDAG-CI-NEXT:    v_mac_f32_e32 v4, v0, v2
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v4
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v1, v5
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SDAG-CI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-VI-LABEL: v_mad_mix_v2f32:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v3, v0
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v4, v1
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v5, v2
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_mac_f32_e32 v5, v3, v4
; GISEL-VI-NEXT:    v_mac_f32_e32 v2, v0, v1
; GISEL-VI-NEXT:    v_cvt_f16_f32_e32 v0, v2
; GISEL-VI-NEXT:    v_cvt_f16_f32_e32 v1, v5
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, 16
; GISEL-VI-NEXT:    v_lshlrev_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GISEL-VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GISEL-VI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-CI-LABEL: v_mad_mix_v2f32:
; GISEL-CI:       ; %bb.0:
; GISEL-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GISEL-CI-NEXT:    v_mac_f32_e32 v4, v0, v2
; GISEL-CI-NEXT:    v_mac_f32_e32 v5, v1, v3
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v0, v4
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v1, v5
; GISEL-CI-NEXT:    s_setpc_b64 s[30:31]
  %src0.ext = fpext <2 x half> %src0 to <2 x float>
  %src1.ext = fpext <2 x half> %src1 to <2 x float>
  %src2.ext = fpext <2 x half> %src2 to <2 x float>
  %result = tail call <2 x float> @llvm.fmuladd.v2f32(<2 x float> %src0.ext, <2 x float> %src1.ext, <2 x float> %src2.ext)
  %cvt.result = fptrunc <2 x float> %result to <2 x half>
  ret <2 x half> %cvt.result
}

define <3 x half> @v_mad_mix_v3f32(<3 x half> %src0, <3 x half> %src1, <3 x half> %src2) #0 {
; SDAG-GFX900-LABEL: v_mad_mix_v3f32:
; SDAG-GFX900:       ; %bb.0:
; SDAG-GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-GFX900-NEXT:    v_mad_mixlo_f16 v1, v1, v3, v5 op_sel_hi:[1,1,1]
; SDAG-GFX900-NEXT:    v_mad_mixlo_f16 v3, v0, v2, v4 op_sel_hi:[1,1,1]
; SDAG-GFX900-NEXT:    v_mad_mixhi_f16 v3, v0, v2, v4 op_sel:[1,1,1] op_sel_hi:[1,1,1]
; SDAG-GFX900-NEXT:    v_mov_b32_e32 v0, v3
; SDAG-GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-GFX906-LABEL: v_mad_mix_v3f32:
; SDAG-GFX906:       ; %bb.0:
; SDAG-GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-GFX906-NEXT:    v_fma_mixlo_f16 v1, v1, v3, v5 op_sel_hi:[1,1,1]
; SDAG-GFX906-NEXT:    v_fma_mixlo_f16 v3, v0, v2, v4 op_sel_hi:[1,1,1]
; SDAG-GFX906-NEXT:    v_fma_mixhi_f16 v3, v0, v2, v4 op_sel:[1,1,1] op_sel_hi:[1,1,1]
; SDAG-GFX906-NEXT:    v_mov_b32_e32 v0, v3
; SDAG-GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-VI-LABEL: v_mad_mix_v3f32:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v6, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v7, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v8, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SDAG-VI-NEXT:    v_mac_f32_e32 v8, v6, v7
; SDAG-VI-NEXT:    v_mac_f32_e32 v4, v0, v2
; SDAG-VI-NEXT:    v_cvt_f16_f32_sdwa v0, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; SDAG-VI-NEXT:    v_cvt_f16_f32_e32 v2, v4
; SDAG-VI-NEXT:    v_mac_f32_e32 v5, v1, v3
; SDAG-VI-NEXT:    v_cvt_f16_f32_e32 v1, v5
; SDAG-VI-NEXT:    v_or_b32_e32 v0, v2, v0
; SDAG-VI-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-CI-LABEL: v_mad_mix_v3f32:
; SDAG-CI:       ; %bb.0:
; SDAG-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-CI-NEXT:    v_mac_f32_e32 v8, v2, v5
; SDAG-CI-NEXT:    v_mac_f32_e32 v7, v1, v4
; SDAG-CI-NEXT:    v_mac_f32_e32 v6, v0, v3
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v6
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v1, v7
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v2, v8
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SDAG-CI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-GFX900-LABEL: v_mad_mix_v3f32:
; GISEL-GFX900:       ; %bb.0:
; GISEL-GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-GFX900-NEXT:    v_mad_mixlo_f16 v6, v0, v2, v4 op_sel_hi:[1,1,1]
; GISEL-GFX900-NEXT:    v_mad_mixhi_f16 v6, v0, v2, v4 op_sel:[1,1,1] op_sel_hi:[1,1,1]
; GISEL-GFX900-NEXT:    v_mad_mixlo_f16 v1, v1, v3, v5 op_sel_hi:[1,1,1]
; GISEL-GFX900-NEXT:    v_mov_b32_e32 v0, v6
; GISEL-GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-GFX906-LABEL: v_mad_mix_v3f32:
; GISEL-GFX906:       ; %bb.0:
; GISEL-GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-GFX906-NEXT:    v_fma_mixlo_f16 v6, v0, v2, v4 op_sel_hi:[1,1,1]
; GISEL-GFX906-NEXT:    v_fma_mixhi_f16 v6, v0, v2, v4 op_sel:[1,1,1] op_sel_hi:[1,1,1]
; GISEL-GFX906-NEXT:    v_fma_mixlo_f16 v1, v1, v3, v5 op_sel_hi:[1,1,1]
; GISEL-GFX906-NEXT:    v_mov_b32_e32 v0, v6
; GISEL-GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-VI-LABEL: v_mad_mix_v3f32:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v6, v0
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v7, v2
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v8, v4
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v4, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GISEL-VI-NEXT:    v_mac_f32_e32 v4, v0, v2
; GISEL-VI-NEXT:    v_mac_f32_e32 v8, v6, v7
; GISEL-VI-NEXT:    v_cvt_f16_f32_e32 v0, v4
; GISEL-VI-NEXT:    v_mac_f32_e32 v5, v1, v3
; GISEL-VI-NEXT:    v_cvt_f16_f32_e32 v1, v8
; GISEL-VI-NEXT:    v_cvt_f16_f32_e32 v2, v5
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, 16
; GISEL-VI-NEXT:    v_lshlrev_b32_sdwa v0, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GISEL-VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GISEL-VI-NEXT:    v_bfe_u32 v1, v2, 0, 16
; GISEL-VI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-CI-LABEL: v_mad_mix_v3f32:
; GISEL-CI:       ; %bb.0:
; GISEL-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; GISEL-CI-NEXT:    v_mac_f32_e32 v6, v0, v3
; GISEL-CI-NEXT:    v_mac_f32_e32 v7, v1, v4
; GISEL-CI-NEXT:    v_mac_f32_e32 v8, v2, v5
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v0, v6
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v1, v7
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v2, v8
; GISEL-CI-NEXT:    s_setpc_b64 s[30:31]
  %src0.ext = fpext <3 x half> %src0 to <3 x float>
  %src1.ext = fpext <3 x half> %src1 to <3 x float>
  %src2.ext = fpext <3 x half> %src2 to <3 x float>
  %result = tail call <3 x float> @llvm.fmuladd.v3f32(<3 x float> %src0.ext, <3 x float> %src1.ext, <3 x float> %src2.ext)
  %cvt.result = fptrunc <3 x float> %result to <3 x half>
  ret <3 x half> %cvt.result
}

define <4 x half> @v_mad_mix_v4f32(<4 x half> %src0, <4 x half> %src1, <4 x half> %src2) #0 {
; SDAG-GFX900-LABEL: v_mad_mix_v4f32:
; SDAG-GFX900:       ; %bb.0:
; SDAG-GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-GFX900-NEXT:    v_mad_mixlo_f16 v6, v1, v3, v5 op_sel_hi:[1,1,1]
; SDAG-GFX900-NEXT:    v_mad_mixlo_f16 v7, v0, v2, v4 op_sel_hi:[1,1,1]
; SDAG-GFX900-NEXT:    v_mad_mixhi_f16 v7, v0, v2, v4 op_sel:[1,1,1] op_sel_hi:[1,1,1]
; SDAG-GFX900-NEXT:    v_mad_mixhi_f16 v6, v1, v3, v5 op_sel:[1,1,1] op_sel_hi:[1,1,1]
; SDAG-GFX900-NEXT:    v_mov_b32_e32 v0, v7
; SDAG-GFX900-NEXT:    v_mov_b32_e32 v1, v6
; SDAG-GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-GFX906-LABEL: v_mad_mix_v4f32:
; SDAG-GFX906:       ; %bb.0:
; SDAG-GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-GFX906-NEXT:    v_fma_mixlo_f16 v6, v1, v3, v5 op_sel_hi:[1,1,1]
; SDAG-GFX906-NEXT:    v_fma_mixlo_f16 v7, v0, v2, v4 op_sel_hi:[1,1,1]
; SDAG-GFX906-NEXT:    v_fma_mixhi_f16 v7, v0, v2, v4 op_sel:[1,1,1] op_sel_hi:[1,1,1]
; SDAG-GFX906-NEXT:    v_fma_mixhi_f16 v6, v1, v3, v5 op_sel:[1,1,1] op_sel_hi:[1,1,1]
; SDAG-GFX906-NEXT:    v_mov_b32_e32 v0, v7
; SDAG-GFX906-NEXT:    v_mov_b32_e32 v1, v6
; SDAG-GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-VI-LABEL: v_mad_mix_v4f32:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v6, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v7, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v8, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v9, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v10, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v11, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SDAG-VI-NEXT:    v_mac_f32_e32 v10, v7, v9
; SDAG-VI-NEXT:    v_mac_f32_e32 v11, v6, v8
; SDAG-VI-NEXT:    v_mac_f32_e32 v4, v0, v2
; SDAG-VI-NEXT:    v_mac_f32_e32 v5, v1, v3
; SDAG-VI-NEXT:    v_cvt_f16_f32_sdwa v1, v11 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; SDAG-VI-NEXT:    v_cvt_f16_f32_sdwa v0, v10 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; SDAG-VI-NEXT:    v_cvt_f16_f32_e32 v2, v4
; SDAG-VI-NEXT:    v_cvt_f16_f32_e32 v3, v5
; SDAG-VI-NEXT:    v_or_b32_e32 v0, v2, v0
; SDAG-VI-NEXT:    v_or_b32_e32 v1, v3, v1
; SDAG-VI-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-CI-LABEL: v_mad_mix_v4f32:
; SDAG-CI:       ; %bb.0:
; SDAG-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v10, v10
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v11, v11
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v10, v10
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v11, v11
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-CI-NEXT:    v_mac_f32_e32 v11, v3, v7
; SDAG-CI-NEXT:    v_mac_f32_e32 v10, v2, v6
; SDAG-CI-NEXT:    v_mac_f32_e32 v9, v1, v5
; SDAG-CI-NEXT:    v_mac_f32_e32 v8, v0, v4
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v8
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v1, v9
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v2, v10
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v3, v11
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SDAG-CI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-GFX900-LABEL: v_mad_mix_v4f32:
; GISEL-GFX900:       ; %bb.0:
; GISEL-GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-GFX900-NEXT:    v_mad_mixlo_f16 v6, v0, v2, v4 op_sel_hi:[1,1,1]
; GISEL-GFX900-NEXT:    v_mad_mixlo_f16 v7, v1, v3, v5 op_sel_hi:[1,1,1]
; GISEL-GFX900-NEXT:    v_mad_mixhi_f16 v6, v0, v2, v4 op_sel:[1,1,1] op_sel_hi:[1,1,1]
; GISEL-GFX900-NEXT:    v_mad_mixhi_f16 v7, v1, v3, v5 op_sel:[1,1,1] op_sel_hi:[1,1,1]
; GISEL-GFX900-NEXT:    v_mov_b32_e32 v0, v6
; GISEL-GFX900-NEXT:    v_mov_b32_e32 v1, v7
; GISEL-GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-GFX906-LABEL: v_mad_mix_v4f32:
; GISEL-GFX906:       ; %bb.0:
; GISEL-GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-GFX906-NEXT:    v_fma_mixlo_f16 v6, v0, v2, v4 op_sel_hi:[1,1,1]
; GISEL-GFX906-NEXT:    v_fma_mixlo_f16 v7, v1, v3, v5 op_sel_hi:[1,1,1]
; GISEL-GFX906-NEXT:    v_fma_mixhi_f16 v6, v0, v2, v4 op_sel:[1,1,1] op_sel_hi:[1,1,1]
; GISEL-GFX906-NEXT:    v_fma_mixhi_f16 v7, v1, v3, v5 op_sel:[1,1,1] op_sel_hi:[1,1,1]
; GISEL-GFX906-NEXT:    v_mov_b32_e32 v0, v6
; GISEL-GFX906-NEXT:    v_mov_b32_e32 v1, v7
; GISEL-GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-VI-LABEL: v_mad_mix_v4f32:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v6, v0
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v8, v2
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v10, v4
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v4, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v7, v1
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v9, v3
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v3, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v11, v5
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v5, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_mac_f32_e32 v4, v0, v2
; GISEL-VI-NEXT:    v_mac_f32_e32 v10, v6, v8
; GISEL-VI-NEXT:    v_mac_f32_e32 v11, v7, v9
; GISEL-VI-NEXT:    v_mac_f32_e32 v5, v1, v3
; GISEL-VI-NEXT:    v_cvt_f16_f32_e32 v1, v4
; GISEL-VI-NEXT:    v_cvt_f16_f32_e32 v0, v10
; GISEL-VI-NEXT:    v_cvt_f16_f32_e32 v3, v5
; GISEL-VI-NEXT:    v_cvt_f16_f32_e32 v2, v11
; GISEL-VI-NEXT:    v_mov_b32_e32 v4, 16
; GISEL-VI-NEXT:    v_lshlrev_b32_sdwa v1, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GISEL-VI-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GISEL-VI-NEXT:    v_lshlrev_b32_sdwa v1, v4, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GISEL-VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GISEL-VI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-CI-LABEL: v_mad_mix_v4f32:
; GISEL-CI:       ; %bb.0:
; GISEL-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v10, v10
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v11, v11
; GISEL-CI-NEXT:    v_mac_f32_e32 v8, v0, v4
; GISEL-CI-NEXT:    v_mac_f32_e32 v9, v1, v5
; GISEL-CI-NEXT:    v_mac_f32_e32 v10, v2, v6
; GISEL-CI-NEXT:    v_mac_f32_e32 v11, v3, v7
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v0, v8
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v1, v9
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v2, v10
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v3, v11
; GISEL-CI-NEXT:    s_setpc_b64 s[30:31]
  %src0.ext = fpext <4 x half> %src0 to <4 x float>
  %src1.ext = fpext <4 x half> %src1 to <4 x float>
  %src2.ext = fpext <4 x half> %src2 to <4 x float>
  %result = tail call <4 x float> @llvm.fmuladd.v4f32(<4 x float> %src0.ext, <4 x float> %src1.ext, <4 x float> %src2.ext)
  %cvt.result = fptrunc <4 x float> %result to <4 x half>
  ret <4 x half> %cvt.result
}

; FIXME (DAG): Fold clamp

define <2 x half> @v_mad_mix_v2f32_clamp_postcvt(<2 x half> %src0, <2 x half> %src1, <2 x half> %src2) #0 {
; GFX900-LABEL: v_mad_mix_v2f32_clamp_postcvt:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mad_mixlo_f16 v3, v0, v1, v2 op_sel_hi:[1,1,1] clamp
; GFX900-NEXT:    v_mad_mixhi_f16 v3, v0, v1, v2 op_sel:[1,1,1] op_sel_hi:[1,1,1] clamp
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: v_mad_mix_v2f32_clamp_postcvt:
; GFX906:       ; %bb.0:
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    v_fma_mixlo_f16 v3, v0, v1, v2 op_sel_hi:[1,1,1] clamp
; GFX906-NEXT:    v_fma_mixhi_f16 v3, v0, v1, v2 op_sel:[1,1,1] op_sel_hi:[1,1,1] clamp
; GFX906-NEXT:    v_mov_b32_e32 v0, v3
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-VI-LABEL: v_mad_mix_v2f32_clamp_postcvt:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SDAG-VI-NEXT:    v_mac_f32_e32 v5, v3, v4
; SDAG-VI-NEXT:    v_mac_f32_e32 v2, v0, v1
; SDAG-VI-NEXT:    v_cvt_f16_f32_sdwa v0, v5 clamp dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; SDAG-VI-NEXT:    v_cvt_f16_f32_e64 v1, v2 clamp
; SDAG-VI-NEXT:    v_or_b32_e32 v0, v1, v0
; SDAG-VI-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-CI-LABEL: v_mad_mix_v2f32_clamp_postcvt:
; SDAG-CI:       ; %bb.0:
; SDAG-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SDAG-CI-NEXT:    v_mac_f32_e32 v4, v0, v2
; SDAG-CI-NEXT:    v_mac_f32_e32 v5, v1, v3
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v4
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v1, v5
; SDAG-CI-NEXT:    v_cvt_f32_f16_e64 v0, v0 clamp
; SDAG-CI-NEXT:    v_cvt_f32_f16_e64 v1, v1 clamp
; SDAG-CI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-VI-LABEL: v_mad_mix_v2f32_clamp_postcvt:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v3, v0
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v4, v1
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v5, v2
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_mac_f32_e32 v5, v3, v4
; GISEL-VI-NEXT:    v_mac_f32_e32 v2, v0, v1
; GISEL-VI-NEXT:    v_cvt_f16_f32_e64 v0, v2 clamp
; GISEL-VI-NEXT:    v_cvt_f16_f32_e64 v1, v5 clamp
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, 16
; GISEL-VI-NEXT:    v_lshlrev_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GISEL-VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GISEL-VI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-CI-LABEL: v_mad_mix_v2f32_clamp_postcvt:
; GISEL-CI:       ; %bb.0:
; GISEL-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GISEL-CI-NEXT:    v_mac_f32_e32 v4, v0, v2
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v0, v4
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v2, 0
; GISEL-CI-NEXT:    v_mac_f32_e32 v5, v1, v3
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v1, v5
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-CI-NEXT:    v_max_f32_e32 v0, v0, v2
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GISEL-CI-NEXT:    v_max_f32_e32 v1, v1, v2
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v2, 1.0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-CI-NEXT:    v_min_f32_e32 v0, v0, v2
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GISEL-CI-NEXT:    v_min_f32_e32 v1, v1, v2
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GISEL-CI-NEXT:    s_setpc_b64 s[30:31]
  %src0.ext = fpext <2 x half> %src0 to <2 x float>
  %src1.ext = fpext <2 x half> %src1 to <2 x float>
  %src2.ext = fpext <2 x half> %src2 to <2 x float>
  %result = tail call <2 x float> @llvm.fmuladd.v2f32(<2 x float> %src0.ext, <2 x float> %src1.ext, <2 x float> %src2.ext)
  %cvt.result = fptrunc <2 x float> %result to <2 x half>
  %max = call <2 x half> @llvm.maxnum.v2f16(<2 x half> %cvt.result, <2 x half> zeroinitializer)
  %clamp = call <2 x half> @llvm.minnum.v2f16(<2 x half> %max, <2 x half> <half 1.0, half 1.0>)
  ret <2 x half> %clamp
}

; FIXME (DAG): Should be packed into 2 registers per argument?
; FIXME (GIsel): V_PK_MAX clamp could be folded into mixlo

define <3 x half> @v_mad_mix_v3f32_clamp_postcvt(<3 x half> %src0, <3 x half> %src1, <3 x half> %src2) #0 {
; SDAG-GFX900-LABEL: v_mad_mix_v3f32_clamp_postcvt:
; SDAG-GFX900:       ; %bb.0:
; SDAG-GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-GFX900-NEXT:    v_mad_mixlo_f16 v1, v1, v3, v5 op_sel_hi:[1,1,1]
; SDAG-GFX900-NEXT:    v_mad_mixlo_f16 v3, v0, v2, v4 op_sel_hi:[1,1,1] clamp
; SDAG-GFX900-NEXT:    v_pack_b32_f16 v1, v1, 0
; SDAG-GFX900-NEXT:    v_mad_mixhi_f16 v3, v0, v2, v4 op_sel:[1,1,1] op_sel_hi:[1,1,1] clamp
; SDAG-GFX900-NEXT:    v_pk_max_f16 v1, v1, v1 clamp
; SDAG-GFX900-NEXT:    v_mov_b32_e32 v0, v3
; SDAG-GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-GFX906-LABEL: v_mad_mix_v3f32_clamp_postcvt:
; SDAG-GFX906:       ; %bb.0:
; SDAG-GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-GFX906-NEXT:    v_fma_mixlo_f16 v1, v1, v3, v5 op_sel_hi:[1,1,1]
; SDAG-GFX906-NEXT:    v_fma_mixlo_f16 v3, v0, v2, v4 op_sel_hi:[1,1,1] clamp
; SDAG-GFX906-NEXT:    v_pack_b32_f16 v1, v1, 0
; SDAG-GFX906-NEXT:    v_fma_mixhi_f16 v3, v0, v2, v4 op_sel:[1,1,1] op_sel_hi:[1,1,1] clamp
; SDAG-GFX906-NEXT:    v_pk_max_f16 v1, v1, v1 clamp
; SDAG-GFX906-NEXT:    v_mov_b32_e32 v0, v3
; SDAG-GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-VI-LABEL: v_mad_mix_v3f32_clamp_postcvt:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v6, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v7, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v8, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SDAG-VI-NEXT:    v_mac_f32_e32 v8, v6, v7
; SDAG-VI-NEXT:    v_mac_f32_e32 v4, v0, v2
; SDAG-VI-NEXT:    v_cvt_f16_f32_sdwa v0, v8 clamp dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; SDAG-VI-NEXT:    v_cvt_f16_f32_e64 v2, v4 clamp
; SDAG-VI-NEXT:    v_mac_f32_e32 v5, v1, v3
; SDAG-VI-NEXT:    v_cvt_f16_f32_e64 v1, v5 clamp
; SDAG-VI-NEXT:    v_or_b32_e32 v0, v2, v0
; SDAG-VI-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-CI-LABEL: v_mad_mix_v3f32_clamp_postcvt:
; SDAG-CI:       ; %bb.0:
; SDAG-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SDAG-CI-NEXT:    v_mac_f32_e32 v6, v0, v3
; SDAG-CI-NEXT:    v_mac_f32_e32 v7, v1, v4
; SDAG-CI-NEXT:    v_mac_f32_e32 v8, v2, v5
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v6
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v1, v7
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v2, v8
; SDAG-CI-NEXT:    v_cvt_f32_f16_e64 v0, v0 clamp
; SDAG-CI-NEXT:    v_cvt_f32_f16_e64 v1, v1 clamp
; SDAG-CI-NEXT:    v_cvt_f32_f16_e64 v2, v2 clamp
; SDAG-CI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-GFX900-LABEL: v_mad_mix_v3f32_clamp_postcvt:
; GISEL-GFX900:       ; %bb.0:
; GISEL-GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-GFX900-NEXT:    v_mad_mixlo_f16 v1, v1, v3, v5 op_sel_hi:[1,1,1]
; GISEL-GFX900-NEXT:    v_mad_mixlo_f16 v3, v0, v2, v4 op_sel_hi:[1,1,1] clamp
; GISEL-GFX900-NEXT:    v_mad_mixhi_f16 v3, v0, v2, v4 op_sel:[1,1,1] op_sel_hi:[1,1,1] clamp
; GISEL-GFX900-NEXT:    v_pk_max_f16 v1, v1, v1 clamp
; GISEL-GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GISEL-GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-GFX906-LABEL: v_mad_mix_v3f32_clamp_postcvt:
; GISEL-GFX906:       ; %bb.0:
; GISEL-GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-GFX906-NEXT:    v_fma_mixlo_f16 v1, v1, v3, v5 op_sel_hi:[1,1,1]
; GISEL-GFX906-NEXT:    v_fma_mixlo_f16 v3, v0, v2, v4 op_sel_hi:[1,1,1] clamp
; GISEL-GFX906-NEXT:    v_fma_mixhi_f16 v3, v0, v2, v4 op_sel:[1,1,1] op_sel_hi:[1,1,1] clamp
; GISEL-GFX906-NEXT:    v_pk_max_f16 v1, v1, v1 clamp
; GISEL-GFX906-NEXT:    v_mov_b32_e32 v0, v3
; GISEL-GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-VI-LABEL: v_mad_mix_v3f32_clamp_postcvt:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v6, v0
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v7, v2
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v8, v4
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v4, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GISEL-VI-NEXT:    v_mac_f32_e32 v4, v0, v2
; GISEL-VI-NEXT:    v_mac_f32_e32 v8, v6, v7
; GISEL-VI-NEXT:    v_cvt_f16_f32_e64 v0, v4 clamp
; GISEL-VI-NEXT:    v_mac_f32_e32 v5, v1, v3
; GISEL-VI-NEXT:    v_cvt_f16_f32_e64 v1, v8 clamp
; GISEL-VI-NEXT:    v_cvt_f16_f32_e64 v2, v5 clamp
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, 16
; GISEL-VI-NEXT:    v_lshlrev_b32_sdwa v0, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GISEL-VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GISEL-VI-NEXT:    v_bfe_u32 v1, v2, 0, 16
; GISEL-VI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-CI-LABEL: v_mad_mix_v3f32_clamp_postcvt:
; GISEL-CI:       ; %bb.0:
; GISEL-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; GISEL-CI-NEXT:    v_mac_f32_e32 v6, v0, v3
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v0, v6
; GISEL-CI-NEXT:    v_mac_f32_e32 v7, v1, v4
; GISEL-CI-NEXT:    v_mac_f32_e32 v8, v2, v5
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v1, v7
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v3, v8
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v2, 0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GISEL-CI-NEXT:    v_max_f32_e32 v0, v0, v2
; GISEL-CI-NEXT:    v_max_f32_e32 v1, v1, v2
; GISEL-CI-NEXT:    v_max_f32_e32 v2, v3, v2
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v3, 1.0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GISEL-CI-NEXT:    v_min_f32_e32 v0, v0, v3
; GISEL-CI-NEXT:    v_min_f32_e32 v1, v1, v3
; GISEL-CI-NEXT:    v_min_f32_e32 v2, v2, v3
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GISEL-CI-NEXT:    s_setpc_b64 s[30:31]
  %src0.ext = fpext <3 x half> %src0 to <3 x float>
  %src1.ext = fpext <3 x half> %src1 to <3 x float>
  %src2.ext = fpext <3 x half> %src2 to <3 x float>
  %result = tail call <3 x float> @llvm.fmuladd.v3f32(<3 x float> %src0.ext, <3 x float> %src1.ext, <3 x float> %src2.ext)
  %cvt.result = fptrunc <3 x float> %result to <3 x half>
  %max = call <3 x half> @llvm.maxnum.v3f16(<3 x half> %cvt.result, <3 x half> zeroinitializer)
  %clamp = call <3 x half> @llvm.minnum.v3f16(<3 x half> %max, <3 x half> <half 1.0, half 1.0, half 1.0>)
  ret <3 x half> %clamp
}

define <4 x half> @v_mad_mix_v4f32_clamp_postcvt(<4 x half> %src0, <4 x half> %src1, <4 x half> %src2) #0 {
; GFX900-LABEL: v_mad_mix_v4f32_clamp_postcvt:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mad_mixlo_f16 v6, v0, v2, v4 op_sel_hi:[1,1,1] clamp
; GFX900-NEXT:    v_mad_mixhi_f16 v6, v0, v2, v4 op_sel:[1,1,1] op_sel_hi:[1,1,1] clamp
; GFX900-NEXT:    v_mad_mixlo_f16 v2, v1, v3, v5 op_sel_hi:[1,1,1] clamp
; GFX900-NEXT:    v_mad_mixhi_f16 v2, v1, v3, v5 op_sel:[1,1,1] op_sel_hi:[1,1,1] clamp
; GFX900-NEXT:    v_mov_b32_e32 v0, v6
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: v_mad_mix_v4f32_clamp_postcvt:
; GFX906:       ; %bb.0:
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    v_fma_mixlo_f16 v6, v0, v2, v4 op_sel_hi:[1,1,1] clamp
; GFX906-NEXT:    v_fma_mixhi_f16 v6, v0, v2, v4 op_sel:[1,1,1] op_sel_hi:[1,1,1] clamp
; GFX906-NEXT:    v_fma_mixlo_f16 v2, v1, v3, v5 op_sel_hi:[1,1,1] clamp
; GFX906-NEXT:    v_fma_mixhi_f16 v2, v1, v3, v5 op_sel:[1,1,1] op_sel_hi:[1,1,1] clamp
; GFX906-NEXT:    v_mov_b32_e32 v0, v6
; GFX906-NEXT:    v_mov_b32_e32 v1, v2
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-VI-LABEL: v_mad_mix_v4f32_clamp_postcvt:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v6, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v7, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v8, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v9, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v10, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v11, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SDAG-VI-NEXT:    v_mac_f32_e32 v10, v7, v9
; SDAG-VI-NEXT:    v_mac_f32_e32 v11, v6, v8
; SDAG-VI-NEXT:    v_mac_f32_e32 v5, v1, v3
; SDAG-VI-NEXT:    v_mac_f32_e32 v4, v0, v2
; SDAG-VI-NEXT:    v_cvt_f16_f32_sdwa v0, v11 clamp dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; SDAG-VI-NEXT:    v_cvt_f16_f32_sdwa v1, v10 clamp dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; SDAG-VI-NEXT:    v_cvt_f16_f32_e64 v2, v4 clamp
; SDAG-VI-NEXT:    v_cvt_f16_f32_e64 v3, v5 clamp
; SDAG-VI-NEXT:    v_or_b32_e32 v0, v2, v0
; SDAG-VI-NEXT:    v_or_b32_e32 v1, v3, v1
; SDAG-VI-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-CI-LABEL: v_mad_mix_v4f32_clamp_postcvt:
; SDAG-CI:       ; %bb.0:
; SDAG-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v11, v11
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v10, v10
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v11, v11
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v10, v10
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SDAG-CI-NEXT:    v_mac_f32_e32 v8, v0, v4
; SDAG-CI-NEXT:    v_mac_f32_e32 v9, v1, v5
; SDAG-CI-NEXT:    v_mac_f32_e32 v10, v2, v6
; SDAG-CI-NEXT:    v_mac_f32_e32 v11, v3, v7
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v8
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v1, v9
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v2, v10
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v3, v11
; SDAG-CI-NEXT:    v_cvt_f32_f16_e64 v0, v0 clamp
; SDAG-CI-NEXT:    v_cvt_f32_f16_e64 v1, v1 clamp
; SDAG-CI-NEXT:    v_cvt_f32_f16_e64 v2, v2 clamp
; SDAG-CI-NEXT:    v_cvt_f32_f16_e64 v3, v3 clamp
; SDAG-CI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-VI-LABEL: v_mad_mix_v4f32_clamp_postcvt:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v6, v0
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v8, v2
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v10, v4
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v4, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v7, v1
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v9, v3
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v3, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v11, v5
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v5, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_mac_f32_e32 v4, v0, v2
; GISEL-VI-NEXT:    v_mac_f32_e32 v10, v6, v8
; GISEL-VI-NEXT:    v_mac_f32_e32 v11, v7, v9
; GISEL-VI-NEXT:    v_mac_f32_e32 v5, v1, v3
; GISEL-VI-NEXT:    v_cvt_f16_f32_e64 v1, v4 clamp
; GISEL-VI-NEXT:    v_cvt_f16_f32_e64 v0, v10 clamp
; GISEL-VI-NEXT:    v_cvt_f16_f32_e64 v3, v5 clamp
; GISEL-VI-NEXT:    v_cvt_f16_f32_e64 v2, v11 clamp
; GISEL-VI-NEXT:    v_mov_b32_e32 v4, 16
; GISEL-VI-NEXT:    v_lshlrev_b32_sdwa v1, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GISEL-VI-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GISEL-VI-NEXT:    v_lshlrev_b32_sdwa v1, v4, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GISEL-VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GISEL-VI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-CI-LABEL: v_mad_mix_v4f32_clamp_postcvt:
; GISEL-CI:       ; %bb.0:
; GISEL-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v10, v10
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v11, v11
; GISEL-CI-NEXT:    v_mac_f32_e32 v8, v0, v4
; GISEL-CI-NEXT:    v_mac_f32_e32 v9, v1, v5
; GISEL-CI-NEXT:    v_mac_f32_e32 v10, v2, v6
; GISEL-CI-NEXT:    v_mac_f32_e32 v11, v3, v7
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v0, v8
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v1, v9
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v3, v10
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v4, v11
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v2, 0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GISEL-CI-NEXT:    v_max_f32_e32 v0, v0, v2
; GISEL-CI-NEXT:    v_max_f32_e32 v1, v1, v2
; GISEL-CI-NEXT:    v_max_f32_e32 v3, v3, v2
; GISEL-CI-NEXT:    v_max_f32_e32 v2, v4, v2
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v5, 1.0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v4, v2
; GISEL-CI-NEXT:    v_min_f32_e32 v0, v0, v5
; GISEL-CI-NEXT:    v_min_f32_e32 v1, v1, v5
; GISEL-CI-NEXT:    v_min_f32_e32 v2, v3, v5
; GISEL-CI-NEXT:    v_min_f32_e32 v3, v4, v5
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GISEL-CI-NEXT:    s_setpc_b64 s[30:31]
  %src0.ext = fpext <4 x half> %src0 to <4 x float>
  %src1.ext = fpext <4 x half> %src1 to <4 x float>
  %src2.ext = fpext <4 x half> %src2 to <4 x float>
  %result = tail call <4 x float> @llvm.fmuladd.v4f32(<4 x float> %src0.ext, <4 x float> %src1.ext, <4 x float> %src2.ext)
  %cvt.result = fptrunc <4 x float> %result to <4 x half>
  %max = call <4 x half> @llvm.maxnum.v4f16(<4 x half> %cvt.result, <4 x half> zeroinitializer)
  %clamp = call <4 x half> @llvm.minnum.v4f16(<4 x half> %max, <4 x half> <half 1.0, half 1.0, half 1.0, half 1.0>)
  ret <4 x half> %clamp
}

; FIXME (GISel): Packed Vectors handling isn't great for now, so we don't end up with
;  a build_vector to select the mixhi. Issue is more specifically with how insert_vector_elt is being
;  legalized (bitwise ops instead of shuffle/build_vector for instance).
define <2 x half> @v_mad_mix_v2f32_clamp_postcvt_lo(<2 x half> %src0, <2 x half> %src1, <2 x half> %src2) #0 {
; SDAG-GFX900-LABEL: v_mad_mix_v2f32_clamp_postcvt_lo:
; SDAG-GFX900:       ; %bb.0:
; SDAG-GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-GFX900-NEXT:    v_mad_mixlo_f16 v3, v0, v1, v2 op_sel_hi:[1,1,1] clamp
; SDAG-GFX900-NEXT:    v_mad_mixhi_f16 v3, v0, v1, v2 op_sel:[1,1,1] op_sel_hi:[1,1,1]
; SDAG-GFX900-NEXT:    v_mov_b32_e32 v0, v3
; SDAG-GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-GFX906-LABEL: v_mad_mix_v2f32_clamp_postcvt_lo:
; SDAG-GFX906:       ; %bb.0:
; SDAG-GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-GFX906-NEXT:    v_fma_mixlo_f16 v3, v0, v1, v2 op_sel_hi:[1,1,1] clamp
; SDAG-GFX906-NEXT:    v_fma_mixhi_f16 v3, v0, v1, v2 op_sel:[1,1,1] op_sel_hi:[1,1,1]
; SDAG-GFX906-NEXT:    v_mov_b32_e32 v0, v3
; SDAG-GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-VI-LABEL: v_mad_mix_v2f32_clamp_postcvt_lo:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SDAG-VI-NEXT:    v_mac_f32_e32 v5, v3, v4
; SDAG-VI-NEXT:    v_mac_f32_e32 v2, v0, v1
; SDAG-VI-NEXT:    v_cvt_f16_f32_sdwa v0, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; SDAG-VI-NEXT:    v_cvt_f16_f32_e64 v1, v2 clamp
; SDAG-VI-NEXT:    v_or_b32_e32 v0, v1, v0
; SDAG-VI-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-CI-LABEL: v_mad_mix_v2f32_clamp_postcvt_lo:
; SDAG-CI:       ; %bb.0:
; SDAG-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SDAG-CI-NEXT:    v_mac_f32_e32 v4, v0, v2
; SDAG-CI-NEXT:    v_mac_f32_e32 v5, v1, v3
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v4
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v1, v5
; SDAG-CI-NEXT:    v_cvt_f32_f16_e64 v0, v0 clamp
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SDAG-CI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-GFX900-LABEL: v_mad_mix_v2f32_clamp_postcvt_lo:
; GISEL-GFX900:       ; %bb.0:
; GISEL-GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-GFX900-NEXT:    v_mad_mixlo_f16 v3, v0, v1, v2 op_sel_hi:[1,1,1]
; GISEL-GFX900-NEXT:    v_mov_b32_e32 v4, v3
; GISEL-GFX900-NEXT:    v_mad_mixhi_f16 v4, v0, v1, v2 op_sel:[1,1,1] op_sel_hi:[1,1,1]
; GISEL-GFX900-NEXT:    v_max_f16_e64 v0, v3, v3 clamp
; GISEL-GFX900-NEXT:    v_bfe_u32 v0, v0, 0, 16
; GISEL-GFX900-NEXT:    v_mov_b32_e32 v1, 0xffff0000
; GISEL-GFX900-NEXT:    v_and_or_b32 v0, v4, v1, v0
; GISEL-GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-GFX906-LABEL: v_mad_mix_v2f32_clamp_postcvt_lo:
; GISEL-GFX906:       ; %bb.0:
; GISEL-GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-GFX906-NEXT:    v_fma_mixlo_f16 v3, v0, v1, v2 op_sel_hi:[1,1,1]
; GISEL-GFX906-NEXT:    v_mov_b32_e32 v4, v3
; GISEL-GFX906-NEXT:    v_fma_mixhi_f16 v4, v0, v1, v2 op_sel:[1,1,1] op_sel_hi:[1,1,1]
; GISEL-GFX906-NEXT:    v_max_f16_e64 v0, v3, v3 clamp
; GISEL-GFX906-NEXT:    v_bfe_u32 v0, v0, 0, 16
; GISEL-GFX906-NEXT:    v_mov_b32_e32 v1, 0xffff0000
; GISEL-GFX906-NEXT:    v_and_or_b32 v0, v4, v1, v0
; GISEL-GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-VI-LABEL: v_mad_mix_v2f32_clamp_postcvt_lo:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v3, v0
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v4, v1
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v5, v2
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_mac_f32_e32 v5, v3, v4
; GISEL-VI-NEXT:    v_mac_f32_e32 v2, v0, v1
; GISEL-VI-NEXT:    v_cvt_f16_f32_e32 v0, v2
; GISEL-VI-NEXT:    v_cvt_f16_f32_e32 v1, v5
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, 16
; GISEL-VI-NEXT:    v_lshlrev_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GISEL-VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GISEL-VI-NEXT:    v_max_f16_e64 v1, v0, v0 clamp
; GISEL-VI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GISEL-VI-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GISEL-VI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-CI-LABEL: v_mad_mix_v2f32_clamp_postcvt_lo:
; GISEL-CI:       ; %bb.0:
; GISEL-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GISEL-CI-NEXT:    v_mac_f32_e32 v5, v1, v3
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v1, v5
; GISEL-CI-NEXT:    v_mac_f32_e32 v4, v0, v2
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v0, v4
; GISEL-CI-NEXT:    v_bfe_u32 v1, v1, 0, 16
; GISEL-CI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v2, 0
; GISEL-CI-NEXT:    v_bfe_u32 v0, v0, 0, 16
; GISEL-CI-NEXT:    v_or_b32_e32 v0, v0, v1
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v0
; GISEL-CI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GISEL-CI-NEXT:    v_max_f32_e32 v1, v1, v2
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v2, 1.0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-CI-NEXT:    v_min_f32_e32 v1, v1, v2
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GISEL-CI-NEXT:    v_bfe_u32 v1, v1, 0, 16
; GISEL-CI-NEXT:    v_or_b32_e32 v0, v0, v1
; GISEL-CI-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GISEL-CI-NEXT:    s_setpc_b64 s[30:31]
  %src0.ext = fpext <2 x half> %src0 to <2 x float>
  %src1.ext = fpext <2 x half> %src1 to <2 x float>
  %src2.ext = fpext <2 x half> %src2 to <2 x float>
  %result = tail call <2 x float> @llvm.fmuladd.v2f32(<2 x float> %src0.ext, <2 x float> %src1.ext, <2 x float> %src2.ext)
  %cvt.result = fptrunc <2 x float> %result to <2 x half>
  %cvt.lo = extractelement <2 x half> %cvt.result, i32 0
  %max.lo = call half @llvm.maxnum.f16(half %cvt.lo, half 0.0)
  %clamp.lo = call half @llvm.minnum.f16(half %max.lo, half 1.0)
  %insert = insertelement <2 x half> %cvt.result, half %clamp.lo, i32 0
  ret <2 x half> %insert
}

define <2 x half> @v_mad_mix_v2f32_clamp_postcvt_hi(<2 x half> %src0, <2 x half> %src1, <2 x half> %src2) #0 {
; SDAG-GFX900-LABEL: v_mad_mix_v2f32_clamp_postcvt_hi:
; SDAG-GFX900:       ; %bb.0:
; SDAG-GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-GFX900-NEXT:    v_mad_mixlo_f16 v3, v0, v1, v2 op_sel_hi:[1,1,1]
; SDAG-GFX900-NEXT:    v_mad_mixhi_f16 v3, v0, v1, v2 op_sel:[1,1,1] op_sel_hi:[1,1,1] clamp
; SDAG-GFX900-NEXT:    v_mov_b32_e32 v0, v3
; SDAG-GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-GFX906-LABEL: v_mad_mix_v2f32_clamp_postcvt_hi:
; SDAG-GFX906:       ; %bb.0:
; SDAG-GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-GFX906-NEXT:    v_fma_mixlo_f16 v3, v0, v1, v2 op_sel_hi:[1,1,1]
; SDAG-GFX906-NEXT:    v_fma_mixhi_f16 v3, v0, v1, v2 op_sel:[1,1,1] op_sel_hi:[1,1,1] clamp
; SDAG-GFX906-NEXT:    v_mov_b32_e32 v0, v3
; SDAG-GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-VI-LABEL: v_mad_mix_v2f32_clamp_postcvt_hi:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SDAG-VI-NEXT:    v_mac_f32_e32 v5, v3, v4
; SDAG-VI-NEXT:    v_mac_f32_e32 v2, v0, v1
; SDAG-VI-NEXT:    v_cvt_f16_f32_sdwa v0, v5 clamp dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; SDAG-VI-NEXT:    v_cvt_f16_f32_e32 v1, v2
; SDAG-VI-NEXT:    v_or_b32_e32 v0, v1, v0
; SDAG-VI-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-CI-LABEL: v_mad_mix_v2f32_clamp_postcvt_hi:
; SDAG-CI:       ; %bb.0:
; SDAG-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-CI-NEXT:    v_mac_f32_e32 v5, v1, v3
; SDAG-CI-NEXT:    v_mac_f32_e32 v4, v0, v2
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v4
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v1, v5
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-CI-NEXT:    v_cvt_f32_f16_e64 v1, v1 clamp
; SDAG-CI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-GFX900-LABEL: v_mad_mix_v2f32_clamp_postcvt_hi:
; GISEL-GFX900:       ; %bb.0:
; GISEL-GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-GFX900-NEXT:    v_mad_mixlo_f16 v3, v0, v1, v2 op_sel_hi:[1,1,1]
; GISEL-GFX900-NEXT:    v_mad_mixlo_f16 v4, v0, v1, v2 op_sel:[1,1,1] op_sel_hi:[1,1,1] clamp
; GISEL-GFX900-NEXT:    v_mad_mixhi_f16 v3, v0, v1, v2 op_sel:[1,1,1] op_sel_hi:[1,1,1]
; GISEL-GFX900-NEXT:    v_mov_b32_e32 v0, 16
; GISEL-GFX900-NEXT:    v_lshlrev_b32_sdwa v0, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GISEL-GFX900-NEXT:    v_mov_b32_e32 v1, 0xffff
; GISEL-GFX900-NEXT:    v_and_or_b32 v0, v3, v1, v0
; GISEL-GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-GFX906-LABEL: v_mad_mix_v2f32_clamp_postcvt_hi:
; GISEL-GFX906:       ; %bb.0:
; GISEL-GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-GFX906-NEXT:    v_fma_mixlo_f16 v3, v0, v1, v2 op_sel_hi:[1,1,1]
; GISEL-GFX906-NEXT:    v_fma_mixlo_f16 v4, v0, v1, v2 op_sel:[1,1,1] op_sel_hi:[1,1,1] clamp
; GISEL-GFX906-NEXT:    v_fma_mixhi_f16 v3, v0, v1, v2 op_sel:[1,1,1] op_sel_hi:[1,1,1]
; GISEL-GFX906-NEXT:    v_mov_b32_e32 v0, 16
; GISEL-GFX906-NEXT:    v_lshlrev_b32_sdwa v0, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GISEL-GFX906-NEXT:    v_mov_b32_e32 v1, 0xffff
; GISEL-GFX906-NEXT:    v_and_or_b32 v0, v3, v1, v0
; GISEL-GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-VI-LABEL: v_mad_mix_v2f32_clamp_postcvt_hi:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v3, v0
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v4, v1
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v5, v2
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_mac_f32_e32 v5, v3, v4
; GISEL-VI-NEXT:    v_mac_f32_e32 v2, v0, v1
; GISEL-VI-NEXT:    v_cvt_f16_f32_e32 v0, v2
; GISEL-VI-NEXT:    v_cvt_f16_f32_e32 v1, v5
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, 16
; GISEL-VI-NEXT:    v_lshlrev_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GISEL-VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GISEL-VI-NEXT:    v_max_f16_sdwa v1, v0, v0 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, 16
; GISEL-VI-NEXT:    v_lshlrev_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GISEL-VI-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GISEL-VI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-CI-LABEL: v_mad_mix_v2f32_clamp_postcvt_hi:
; GISEL-CI:       ; %bb.0:
; GISEL-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GISEL-CI-NEXT:    v_mac_f32_e32 v5, v1, v3
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v1, v5
; GISEL-CI-NEXT:    v_mac_f32_e32 v4, v0, v2
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v0, v4
; GISEL-CI-NEXT:    v_bfe_u32 v1, v1, 0, 16
; GISEL-CI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v2, 0
; GISEL-CI-NEXT:    v_bfe_u32 v0, v0, 0, 16
; GISEL-CI-NEXT:    v_or_b32_e32 v0, v0, v1
; GISEL-CI-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-CI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GISEL-CI-NEXT:    v_max_f32_e32 v1, v1, v2
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v2, 1.0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-CI-NEXT:    v_min_f32_e32 v1, v1, v2
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GISEL-CI-NEXT:    v_bfe_u32 v1, v1, 0, 16
; GISEL-CI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GISEL-CI-NEXT:    v_or_b32_e32 v0, v0, v1
; GISEL-CI-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GISEL-CI-NEXT:    s_setpc_b64 s[30:31]
  %src0.ext = fpext <2 x half> %src0 to <2 x float>
  %src1.ext = fpext <2 x half> %src1 to <2 x float>
  %src2.ext = fpext <2 x half> %src2 to <2 x float>
  %result = tail call <2 x float> @llvm.fmuladd.v2f32(<2 x float> %src0.ext, <2 x float> %src1.ext, <2 x float> %src2.ext)
  %cvt.result = fptrunc <2 x float> %result to <2 x half>
  %cvt.hi = extractelement <2 x half> %cvt.result, i32 1
  %max.hi = call half @llvm.maxnum.f16(half %cvt.hi, half 0.0)
  %clamp.hi = call half @llvm.minnum.f16(half %max.hi, half 1.0)
  %insert = insertelement <2 x half> %cvt.result, half %clamp.hi, i32 1
  ret <2 x half> %insert
}

; FIXME (DAG): Should be able to use mixlo/mixhi

define <2 x half> @v_mad_mix_v2f32_clamp_precvt(<2 x half> %src0, <2 x half> %src1, <2 x half> %src2) #0 {
; SDAG-GFX900-LABEL: v_mad_mix_v2f32_clamp_precvt:
; SDAG-GFX900:       ; %bb.0:
; SDAG-GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-GFX900-NEXT:    v_mad_mix_f32 v3, v0, v1, v2 op_sel:[1,1,1] op_sel_hi:[1,1,1] clamp
; SDAG-GFX900-NEXT:    v_mad_mix_f32 v0, v0, v1, v2 op_sel_hi:[1,1,1] clamp
; SDAG-GFX900-NEXT:    v_cvt_f16_f32_e32 v1, v3
; SDAG-GFX900-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SDAG-GFX900-NEXT:    v_pack_b32_f16 v0, v0, v1
; SDAG-GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-GFX906-LABEL: v_mad_mix_v2f32_clamp_precvt:
; SDAG-GFX906:       ; %bb.0:
; SDAG-GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-GFX906-NEXT:    v_fma_mix_f32 v3, v0, v1, v2 op_sel:[1,1,1] op_sel_hi:[1,1,1] clamp
; SDAG-GFX906-NEXT:    v_fma_mix_f32 v0, v0, v1, v2 op_sel_hi:[1,1,1] clamp
; SDAG-GFX906-NEXT:    v_cvt_f16_f32_e32 v1, v3
; SDAG-GFX906-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SDAG-GFX906-NEXT:    v_pack_b32_f16 v0, v0, v1
; SDAG-GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-VI-LABEL: v_mad_mix_v2f32_clamp_precvt:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SDAG-VI-NEXT:    v_mad_f32 v3, v3, v4, v5 clamp
; SDAG-VI-NEXT:    v_mad_f32 v0, v0, v1, v2 clamp
; SDAG-VI-NEXT:    v_cvt_f16_f32_sdwa v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; SDAG-VI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SDAG-VI-NEXT:    v_or_b32_e32 v0, v0, v1
; SDAG-VI-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-CI-LABEL: v_mad_mix_v2f32_clamp_precvt:
; SDAG-CI:       ; %bb.0:
; SDAG-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SDAG-CI-NEXT:    v_mad_f32 v0, v0, v2, v4 clamp
; SDAG-CI-NEXT:    v_mad_f32 v1, v1, v3, v5 clamp
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SDAG-CI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-GFX900-LABEL: v_mad_mix_v2f32_clamp_precvt:
; GISEL-GFX900:       ; %bb.0:
; GISEL-GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-GFX900-NEXT:    v_mad_mix_f32 v3, v0, v1, v2 op_sel_hi:[1,1,1] clamp
; GISEL-GFX900-NEXT:    v_mad_mix_f32 v0, v0, v1, v2 op_sel:[1,1,1] op_sel_hi:[1,1,1] clamp
; GISEL-GFX900-NEXT:    v_cvt_f16_f32_e32 v1, v3
; GISEL-GFX900-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GISEL-GFX900-NEXT:    v_pack_b32_f16 v0, v1, v0
; GISEL-GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-GFX906-LABEL: v_mad_mix_v2f32_clamp_precvt:
; GISEL-GFX906:       ; %bb.0:
; GISEL-GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-GFX906-NEXT:    v_fma_mix_f32 v3, v0, v1, v2 op_sel_hi:[1,1,1] clamp
; GISEL-GFX906-NEXT:    v_fma_mix_f32 v0, v0, v1, v2 op_sel:[1,1,1] op_sel_hi:[1,1,1] clamp
; GISEL-GFX906-NEXT:    v_cvt_f16_f32_e32 v1, v3
; GISEL-GFX906-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GISEL-GFX906-NEXT:    v_pack_b32_f16 v0, v1, v0
; GISEL-GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-VI-LABEL: v_mad_mix_v2f32_clamp_precvt:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v3, v0
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v4, v1
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v5, v2
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_mad_f32 v3, v3, v4, v5 clamp
; GISEL-VI-NEXT:    v_mad_f32 v0, v0, v1, v2 clamp
; GISEL-VI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GISEL-VI-NEXT:    v_cvt_f16_f32_e32 v1, v3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, 16
; GISEL-VI-NEXT:    v_lshlrev_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GISEL-VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GISEL-VI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-CI-LABEL: v_mad_mix_v2f32_clamp_precvt:
; GISEL-CI:       ; %bb.0:
; GISEL-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GISEL-CI-NEXT:    v_mad_f32 v0, v0, v2, v4 clamp
; GISEL-CI-NEXT:    v_mad_f32 v1, v1, v3, v5 clamp
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GISEL-CI-NEXT:    s_setpc_b64 s[30:31]
  %src0.ext = fpext <2 x half> %src0 to <2 x float>
  %src1.ext = fpext <2 x half> %src1 to <2 x float>
  %src2.ext = fpext <2 x half> %src2 to <2 x float>
  %result = tail call <2 x float> @llvm.fmuladd.v2f32(<2 x float> %src0.ext, <2 x float> %src1.ext, <2 x float> %src2.ext)
  %max = call <2 x float> @llvm.maxnum.v2f32(<2 x float> %result, <2 x float> zeroinitializer)
  %clamp = call <2 x float> @llvm.minnum.v2f32(<2 x float> %max, <2 x float> <float 1.0, float 1.0>)
  %cvt.result = fptrunc <2 x float> %clamp to <2 x half>
  ret <2 x half> %cvt.result
}

; FIXME (DAG): Handling undef 4th component

define <3 x half> @v_mad_mix_v3f32_clamp_precvt(<3 x half> %src0, <3 x half> %src1, <3 x half> %src2) #0 {
; SDAG-GFX900-LABEL: v_mad_mix_v3f32_clamp_precvt:
; SDAG-GFX900:       ; %bb.0:
; SDAG-GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-GFX900-NEXT:    v_mad_mix_f32 v6, v0, v2, v4 op_sel:[1,1,1] op_sel_hi:[1,1,1] clamp
; SDAG-GFX900-NEXT:    v_mad_mix_f32 v0, v0, v2, v4 op_sel_hi:[1,1,1] clamp
; SDAG-GFX900-NEXT:    v_cvt_f16_f32_e32 v2, v6
; SDAG-GFX900-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SDAG-GFX900-NEXT:    v_mad_mix_f32 v1, v1, v3, v5 op_sel_hi:[1,1,1] clamp
; SDAG-GFX900-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SDAG-GFX900-NEXT:    v_pack_b32_f16 v0, v0, v2
; SDAG-GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-GFX906-LABEL: v_mad_mix_v3f32_clamp_precvt:
; SDAG-GFX906:       ; %bb.0:
; SDAG-GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-GFX906-NEXT:    v_fma_mix_f32 v6, v0, v2, v4 op_sel:[1,1,1] op_sel_hi:[1,1,1] clamp
; SDAG-GFX906-NEXT:    v_fma_mix_f32 v0, v0, v2, v4 op_sel_hi:[1,1,1] clamp
; SDAG-GFX906-NEXT:    v_cvt_f16_f32_e32 v2, v6
; SDAG-GFX906-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SDAG-GFX906-NEXT:    v_fma_mix_f32 v1, v1, v3, v5 op_sel_hi:[1,1,1] clamp
; SDAG-GFX906-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SDAG-GFX906-NEXT:    v_pack_b32_f16 v0, v0, v2
; SDAG-GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-VI-LABEL: v_mad_mix_v3f32_clamp_precvt:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v6, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v7, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v8, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SDAG-VI-NEXT:    v_mad_f32 v6, v6, v7, v8 clamp
; SDAG-VI-NEXT:    v_mad_f32 v0, v0, v2, v4 clamp
; SDAG-VI-NEXT:    v_cvt_f16_f32_sdwa v2, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; SDAG-VI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SDAG-VI-NEXT:    v_mad_f32 v1, v1, v3, v5 clamp
; SDAG-VI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SDAG-VI-NEXT:    v_or_b32_e32 v0, v0, v2
; SDAG-VI-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-CI-LABEL: v_mad_mix_v3f32_clamp_precvt:
; SDAG-CI:       ; %bb.0:
; SDAG-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SDAG-CI-NEXT:    v_mad_f32 v0, v0, v3, v6 clamp
; SDAG-CI-NEXT:    v_mad_f32 v1, v1, v4, v7 clamp
; SDAG-CI-NEXT:    v_mad_f32 v2, v2, v5, v8 clamp
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SDAG-CI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-GFX900-LABEL: v_mad_mix_v3f32_clamp_precvt:
; GISEL-GFX900:       ; %bb.0:
; GISEL-GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-GFX900-NEXT:    v_mad_mix_f32 v6, v0, v2, v4 op_sel_hi:[1,1,1] clamp
; GISEL-GFX900-NEXT:    v_mad_mix_f32 v0, v0, v2, v4 op_sel:[1,1,1] op_sel_hi:[1,1,1] clamp
; GISEL-GFX900-NEXT:    v_cvt_f16_f32_e32 v2, v6
; GISEL-GFX900-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GISEL-GFX900-NEXT:    v_mad_mix_f32 v1, v1, v3, v5 op_sel_hi:[1,1,1] clamp
; GISEL-GFX900-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GISEL-GFX900-NEXT:    v_pack_b32_f16 v0, v2, v0
; GISEL-GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-GFX906-LABEL: v_mad_mix_v3f32_clamp_precvt:
; GISEL-GFX906:       ; %bb.0:
; GISEL-GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-GFX906-NEXT:    v_fma_mix_f32 v6, v0, v2, v4 op_sel_hi:[1,1,1] clamp
; GISEL-GFX906-NEXT:    v_fma_mix_f32 v0, v0, v2, v4 op_sel:[1,1,1] op_sel_hi:[1,1,1] clamp
; GISEL-GFX906-NEXT:    v_cvt_f16_f32_e32 v2, v6
; GISEL-GFX906-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GISEL-GFX906-NEXT:    v_fma_mix_f32 v1, v1, v3, v5 op_sel_hi:[1,1,1] clamp
; GISEL-GFX906-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GISEL-GFX906-NEXT:    v_pack_b32_f16 v0, v2, v0
; GISEL-GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-VI-LABEL: v_mad_mix_v3f32_clamp_precvt:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v6, v0
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v7, v2
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v8, v4
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v4, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GISEL-VI-NEXT:    v_mad_f32 v0, v0, v2, v4 clamp
; GISEL-VI-NEXT:    v_mad_f32 v6, v6, v7, v8 clamp
; GISEL-VI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GISEL-VI-NEXT:    v_mad_f32 v1, v1, v3, v5 clamp
; GISEL-VI-NEXT:    v_cvt_f16_f32_e32 v2, v6
; GISEL-VI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, 16
; GISEL-VI-NEXT:    v_lshlrev_b32_sdwa v0, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GISEL-VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GISEL-VI-NEXT:    v_bfe_u32 v1, v1, 0, 16
; GISEL-VI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-CI-LABEL: v_mad_mix_v3f32_clamp_precvt:
; GISEL-CI:       ; %bb.0:
; GISEL-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; GISEL-CI-NEXT:    v_mad_f32 v0, v0, v3, v6 clamp
; GISEL-CI-NEXT:    v_mad_f32 v1, v1, v4, v7 clamp
; GISEL-CI-NEXT:    v_mad_f32 v2, v2, v5, v8 clamp
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GISEL-CI-NEXT:    s_setpc_b64 s[30:31]
  %src0.ext = fpext <3 x half> %src0 to <3 x float>
  %src1.ext = fpext <3 x half> %src1 to <3 x float>
  %src2.ext = fpext <3 x half> %src2 to <3 x float>
  %result = tail call <3 x float> @llvm.fmuladd.v3f32(<3 x float> %src0.ext, <3 x float> %src1.ext, <3 x float> %src2.ext)
  %max = call <3 x float> @llvm.maxnum.v3f32(<3 x float> %result, <3 x float> zeroinitializer)
  %clamp = call <3 x float> @llvm.minnum.v3f32(<3 x float> %max, <3 x float> <float 1.0, float 1.0, float 1.0>)
  %cvt.result = fptrunc <3 x float> %clamp to <3 x half>
  ret <3 x half> %cvt.result
}

define <4 x half> @v_mad_mix_v4f32_clamp_precvt(<4 x half> %src0, <4 x half> %src1, <4 x half> %src2) #0 {
; SDAG-GFX900-LABEL: v_mad_mix_v4f32_clamp_precvt:
; SDAG-GFX900:       ; %bb.0:
; SDAG-GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-GFX900-NEXT:    v_mad_mix_f32 v6, v1, v3, v5 op_sel:[1,1,1] op_sel_hi:[1,1,1] clamp
; SDAG-GFX900-NEXT:    v_mad_mix_f32 v1, v1, v3, v5 op_sel_hi:[1,1,1] clamp
; SDAG-GFX900-NEXT:    v_mad_mix_f32 v3, v0, v2, v4 op_sel:[1,1,1] op_sel_hi:[1,1,1] clamp
; SDAG-GFX900-NEXT:    v_mad_mix_f32 v0, v0, v2, v4 op_sel_hi:[1,1,1] clamp
; SDAG-GFX900-NEXT:    v_cvt_f16_f32_e32 v2, v6
; SDAG-GFX900-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SDAG-GFX900-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SDAG-GFX900-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SDAG-GFX900-NEXT:    v_pack_b32_f16 v0, v0, v3
; SDAG-GFX900-NEXT:    v_pack_b32_f16 v1, v1, v2
; SDAG-GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-GFX906-LABEL: v_mad_mix_v4f32_clamp_precvt:
; SDAG-GFX906:       ; %bb.0:
; SDAG-GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-GFX906-NEXT:    v_fma_mix_f32 v6, v1, v3, v5 op_sel:[1,1,1] op_sel_hi:[1,1,1] clamp
; SDAG-GFX906-NEXT:    v_fma_mix_f32 v1, v1, v3, v5 op_sel_hi:[1,1,1] clamp
; SDAG-GFX906-NEXT:    v_fma_mix_f32 v3, v0, v2, v4 op_sel:[1,1,1] op_sel_hi:[1,1,1] clamp
; SDAG-GFX906-NEXT:    v_fma_mix_f32 v0, v0, v2, v4 op_sel_hi:[1,1,1] clamp
; SDAG-GFX906-NEXT:    v_cvt_f16_f32_e32 v2, v6
; SDAG-GFX906-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SDAG-GFX906-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SDAG-GFX906-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SDAG-GFX906-NEXT:    v_pack_b32_f16 v0, v0, v3
; SDAG-GFX906-NEXT:    v_pack_b32_f16 v1, v1, v2
; SDAG-GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-VI-LABEL: v_mad_mix_v4f32_clamp_precvt:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v6, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v7, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v8, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v9, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v10, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_sdwa v11, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SDAG-VI-NEXT:    v_mad_f32 v7, v7, v9, v10 clamp
; SDAG-VI-NEXT:    v_mad_f32 v6, v6, v8, v11 clamp
; SDAG-VI-NEXT:    v_mad_f32 v1, v1, v3, v5 clamp
; SDAG-VI-NEXT:    v_mad_f32 v0, v0, v2, v4 clamp
; SDAG-VI-NEXT:    v_cvt_f16_f32_sdwa v2, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; SDAG-VI-NEXT:    v_cvt_f16_f32_sdwa v3, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; SDAG-VI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SDAG-VI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SDAG-VI-NEXT:    v_or_b32_e32 v0, v0, v3
; SDAG-VI-NEXT:    v_or_b32_e32 v1, v1, v2
; SDAG-VI-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-CI-LABEL: v_mad_mix_v4f32_clamp_precvt:
; SDAG-CI:       ; %bb.0:
; SDAG-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v11, v11
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v10, v10
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v11, v11
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v10, v10
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SDAG-CI-NEXT:    v_mad_f32 v0, v0, v4, v8 clamp
; SDAG-CI-NEXT:    v_mad_f32 v1, v1, v5, v9 clamp
; SDAG-CI-NEXT:    v_mad_f32 v2, v2, v6, v10 clamp
; SDAG-CI-NEXT:    v_mad_f32 v3, v3, v7, v11 clamp
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SDAG-CI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-GFX900-LABEL: v_mad_mix_v4f32_clamp_precvt:
; GISEL-GFX900:       ; %bb.0:
; GISEL-GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-GFX900-NEXT:    v_mad_mix_f32 v6, v0, v2, v4 op_sel_hi:[1,1,1] clamp
; GISEL-GFX900-NEXT:    v_mad_mix_f32 v0, v0, v2, v4 op_sel:[1,1,1] op_sel_hi:[1,1,1] clamp
; GISEL-GFX900-NEXT:    v_mad_mix_f32 v2, v1, v3, v5 op_sel_hi:[1,1,1] clamp
; GISEL-GFX900-NEXT:    v_mad_mix_f32 v1, v1, v3, v5 op_sel:[1,1,1] op_sel_hi:[1,1,1] clamp
; GISEL-GFX900-NEXT:    v_cvt_f16_f32_e32 v3, v6
; GISEL-GFX900-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GISEL-GFX900-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GISEL-GFX900-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GISEL-GFX900-NEXT:    v_pack_b32_f16 v0, v3, v0
; GISEL-GFX900-NEXT:    v_pack_b32_f16 v1, v2, v1
; GISEL-GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-GFX906-LABEL: v_mad_mix_v4f32_clamp_precvt:
; GISEL-GFX906:       ; %bb.0:
; GISEL-GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-GFX906-NEXT:    v_fma_mix_f32 v6, v0, v2, v4 op_sel_hi:[1,1,1] clamp
; GISEL-GFX906-NEXT:    v_fma_mix_f32 v0, v0, v2, v4 op_sel:[1,1,1] op_sel_hi:[1,1,1] clamp
; GISEL-GFX906-NEXT:    v_fma_mix_f32 v2, v1, v3, v5 op_sel_hi:[1,1,1] clamp
; GISEL-GFX906-NEXT:    v_fma_mix_f32 v1, v1, v3, v5 op_sel:[1,1,1] op_sel_hi:[1,1,1] clamp
; GISEL-GFX906-NEXT:    v_cvt_f16_f32_e32 v3, v6
; GISEL-GFX906-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GISEL-GFX906-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GISEL-GFX906-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GISEL-GFX906-NEXT:    v_pack_b32_f16 v0, v3, v0
; GISEL-GFX906-NEXT:    v_pack_b32_f16 v1, v2, v1
; GISEL-GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-VI-LABEL: v_mad_mix_v4f32_clamp_precvt:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v6, v0
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v7, v1
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v8, v2
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v9, v3
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v3, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v10, v4
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v4, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v11, v5
; GISEL-VI-NEXT:    v_cvt_f32_f16_sdwa v5, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-VI-NEXT:    v_mad_f32 v6, v6, v8, v10 clamp
; GISEL-VI-NEXT:    v_mad_f32 v0, v0, v2, v4 clamp
; GISEL-VI-NEXT:    v_mad_f32 v2, v7, v9, v11 clamp
; GISEL-VI-NEXT:    v_mad_f32 v1, v1, v3, v5 clamp
; GISEL-VI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GISEL-VI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GISEL-VI-NEXT:    v_cvt_f16_f32_e32 v3, v6
; GISEL-VI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GISEL-VI-NEXT:    v_mov_b32_e32 v4, 16
; GISEL-VI-NEXT:    v_lshlrev_b32_sdwa v0, v4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GISEL-VI-NEXT:    v_lshlrev_b32_sdwa v1, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GISEL-VI-NEXT:    v_or_b32_sdwa v0, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GISEL-VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GISEL-VI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-CI-LABEL: v_mad_mix_v4f32_clamp_precvt:
; GISEL-CI:       ; %bb.0:
; GISEL-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v10, v10
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v11, v11
; GISEL-CI-NEXT:    v_mad_f32 v0, v0, v4, v8 clamp
; GISEL-CI-NEXT:    v_mad_f32 v1, v1, v5, v9 clamp
; GISEL-CI-NEXT:    v_mad_f32 v2, v2, v6, v10 clamp
; GISEL-CI-NEXT:    v_mad_f32 v3, v3, v7, v11 clamp
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GISEL-CI-NEXT:    s_setpc_b64 s[30:31]
  %src0.ext = fpext <4 x half> %src0 to <4 x float>
  %src1.ext = fpext <4 x half> %src1 to <4 x float>
  %src2.ext = fpext <4 x half> %src2 to <4 x float>
  %result = tail call <4 x float> @llvm.fmuladd.v4f32(<4 x float> %src0.ext, <4 x float> %src1.ext, <4 x float> %src2.ext)
  %max = call <4 x float> @llvm.maxnum.v4f32(<4 x float> %result, <4 x float> zeroinitializer)
  %clamp = call <4 x float> @llvm.minnum.v4f32(<4 x float> %max, <4 x float> <float 1.0, float 1.0, float 1.0, float 1.0>)
  %cvt.result = fptrunc <4 x float> %clamp to <4 x half>
  ret <4 x half> %cvt.result
}

declare half @llvm.minnum.f16(half, half) #1
declare <2 x half> @llvm.minnum.v2f16(<2 x half>, <2 x half>) #1
declare <3 x half> @llvm.minnum.v3f16(<3 x half>, <3 x half>) #1
declare <4 x half> @llvm.minnum.v4f16(<4 x half>, <4 x half>) #1

declare half @llvm.maxnum.f16(half, half) #1
declare <2 x half> @llvm.maxnum.v2f16(<2 x half>, <2 x half>) #1
declare <3 x half> @llvm.maxnum.v3f16(<3 x half>, <3 x half>) #1
declare <4 x half> @llvm.maxnum.v4f16(<4 x half>, <4 x half>) #1

declare float @llvm.minnum.f32(float, float) #1
declare <2 x float> @llvm.minnum.v2f32(<2 x float>, <2 x float>) #1
declare <3 x float> @llvm.minnum.v3f32(<3 x float>, <3 x float>) #1
declare <4 x float> @llvm.minnum.v4f32(<4 x float>, <4 x float>) #1

declare float @llvm.maxnum.f32(float, float) #1
declare <2 x float> @llvm.maxnum.v2f32(<2 x float>, <2 x float>) #1
declare <3 x float> @llvm.maxnum.v3f32(<3 x float>, <3 x float>) #1
declare <4 x float> @llvm.maxnum.v4f32(<4 x float>, <4 x float>) #1

declare float @llvm.fmuladd.f32(float, float, float) #1
declare <2 x float> @llvm.fmuladd.v2f32(<2 x float>, <2 x float>, <2 x float>) #1
declare <3 x float> @llvm.fmuladd.v3f32(<3 x float>, <3 x float>, <3 x float>) #1
declare <4 x float> @llvm.fmuladd.v4f32(<4 x float>, <4 x float>, <4 x float>) #1

attributes #0 = { nounwind "denormal-fp-math-f32"="preserve-sign,preserve-sign" }
attributes #1 = { nounwind readnone speculatable }
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CI: {{.*}}
