; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-linux-gnu -mattr=+sve,+bf16 < %s | FileCheck %s --check-prefixes=CHECK

; Extracting illegal subvectors

define <vscale x 1 x i32> @extract_nxv1i32_nxv4i32(<vscale x 4 x i32> %vec) nounwind {
; CHECK-LABEL: extract_nxv1i32_nxv4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %retval = call <vscale x 1 x i32> @llvm.vector.extract.nxv1i32.nxv4i32(<vscale x 4 x i32> %vec, i64 0)
  ret <vscale x 1 x i32> %retval
}

define <vscale x 1 x i16> @extract_nxv1i16_nxv6i16(<vscale x 6 x i16> %vec) nounwind {
; CHECK-LABEL: extract_nxv1i16_nxv6i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %retval = call <vscale x 1 x i16> @llvm.vector.extract.nxv1i16.nxv6i16(<vscale x 6 x i16> %vec, i64 0)
  ret <vscale x 1 x i16> %retval
}

declare <vscale x 1 x i32> @llvm.vector.extract.nxv1i32.nxv4i32(<vscale x 4 x i32>, i64)
declare <vscale x 1 x i16> @llvm.vector.extract.nxv1i16.nxv6i16(<vscale x 6 x i16>, i64)

;
; Extract half i1 vector that needs promotion from legal type.
;
define <vscale x 8 x i1> @extract_nxv8i1_nxv16i1_0(<vscale x 16 x i1> %in) {
; CHECK-LABEL: extract_nxv8i1_nxv16i1_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 8 x i1> @llvm.vector.extract.nxv8i1.nxv16i1(<vscale x 16 x i1> %in, i64 0)
  ret <vscale x 8 x i1> %res
}

define <vscale x 8 x i1> @extract_nxv8i1_nxv16i1_8(<vscale x 16 x i1> %in) {
; CHECK-LABEL: extract_nxv8i1_nxv16i1_8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 8 x i1> @llvm.vector.extract.nxv8i1.nxv16i1(<vscale x 16 x i1> %in, i64 8)
  ret <vscale x 8 x i1> %res
}

declare <vscale x 8 x i1> @llvm.vector.extract.nxv8i1.nxv16i1(<vscale x 16 x i1>, i64)

;
; Extract i1 vector that needs widening from one that needs widening.
;
define <vscale x 14 x i1> @extract_nxv14i1_nxv28i1_0(<vscale x 28 x i1> %in) {
; CHECK-LABEL: extract_nxv14i1_nxv28i1_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %res = call <vscale x 14 x i1> @llvm.vector.extract.nxv14i1.nxv28i1(<vscale x 28 x i1> %in, i64 0)
  ret <vscale x 14 x i1> %res
}

define <vscale x 14 x i1> @extract_nxv14i1_nxv28i1_14(<vscale x 28 x i1> %in) uwtable {
; CHECK-LABEL: extract_nxv14i1_nxv28i1_14:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w29, -16
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0c, 0x8f, 0x00, 0x11, 0x10, 0x22, 0x11, 0x08, 0x92, 0x2e, 0x00, 0x1e, 0x22 // sp + 16 + 8 * VG
; CHECK-NEXT:    punpkhi p2.h, p1.b
; CHECK-NEXT:    punpklo p1.h, p1.b
; CHECK-NEXT:    punpklo p2.h, p2.b
; CHECK-NEXT:    str p4, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpkhi p3.h, p1.b
; CHECK-NEXT:    punpkhi p4.h, p2.b
; CHECK-NEXT:    str p5, [sp, #6, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    punpklo p1.h, p1.b
; CHECK-NEXT:    punpklo p2.h, p2.b
; CHECK-NEXT:    punpkhi p5.h, p3.b
; CHECK-NEXT:    uzp1 p4.s, p4.s, p0.s
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpklo p3.h, p3.b
; CHECK-NEXT:    uzp1 p2.s, p5.s, p2.s
; CHECK-NEXT:    punpkhi p5.h, p1.b
; CHECK-NEXT:    punpklo p1.h, p1.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    uzp1 p3.s, p5.s, p3.s
; CHECK-NEXT:    uzp1 p0.s, p0.s, p1.s
; CHECK-NEXT:    uzp1 p1.h, p2.h, p4.h
; CHECK-NEXT:    ldr p5, [sp, #6, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    ldr p4, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    uzp1 p0.h, p0.h, p3.h
; CHECK-NEXT:    uzp1 p0.b, p0.b, p1.b
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    .cfi_def_cfa wsp, 16
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    .cfi_restore w29
; CHECK-NEXT:    ret
  %res = call <vscale x 14 x i1> @llvm.vector.extract.nxv14i1.nxv28i1(<vscale x 28 x i1> %in, i64 14)
  ret <vscale x 14 x i1> %res
}

declare <vscale x 14 x i1> @llvm.vector.extract.nxv14i1.nxv28i1(<vscale x 28 x i1>, i64)

;
; Extract half i1 vector that needs promotion from one that needs splitting.
;
define <vscale x 8 x i1> @extract_nxv8i1_nxv32i1_0(<vscale x 32 x i1> %in) {
; CHECK-LABEL: extract_nxv8i1_nxv32i1_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 8 x i1> @llvm.vector.extract.nxv8i1.nxv32i1(<vscale x 32 x i1> %in, i64 0)
  ret <vscale x 8 x i1> %res
}

define <vscale x 8 x i1> @extract_nxv8i1_nxv32i1_8(<vscale x 32 x i1> %in) {
; CHECK-LABEL: extract_nxv8i1_nxv32i1_8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 8 x i1> @llvm.vector.extract.nxv8i1.nxv32i1(<vscale x 32 x i1> %in, i64 8)
  ret <vscale x 8 x i1> %res
}

define <vscale x 8 x i1> @extract_nxv8i1_nxv32i1_16(<vscale x 32 x i1> %in) {
; CHECK-LABEL: extract_nxv8i1_nxv32i1_16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpklo p0.h, p1.b
; CHECK-NEXT:    ret
  %res = call <vscale x 8 x i1> @llvm.vector.extract.nxv8i1.nxv32i1(<vscale x 32 x i1> %in, i64 16)
  ret <vscale x 8 x i1> %res
}

define <vscale x 8 x i1> @extract_nxv8i1_nxv32i1_24(<vscale x 32 x i1> %in) {
; CHECK-LABEL: extract_nxv8i1_nxv32i1_24:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpkhi p0.h, p1.b
; CHECK-NEXT:    ret
  %res = call <vscale x 8 x i1> @llvm.vector.extract.nxv8i1.nxv32i1(<vscale x 32 x i1> %in, i64 24)
  ret <vscale x 8 x i1> %res
}

declare <vscale x 8 x i1> @llvm.vector.extract.nxv8i1.nxv32i1(<vscale x 32 x i1>, i64)

;
; Extract 1/4th i1 vector that needs promotion from legal type.
;
define <vscale x 4 x i1> @extract_nxv4i1_nxv16i1_0(<vscale x 16 x i1> %in) {
; CHECK-LABEL: extract_nxv4i1_nxv16i1_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x i1> @llvm.vector.extract.nxv4i1.nxv16i1(<vscale x 16 x i1> %in, i64 0)
  ret <vscale x 4 x i1> %res
}

define <vscale x 4 x i1> @extract_nxv4i1_nxv16i1_4(<vscale x 16 x i1> %in) {
; CHECK-LABEL: extract_nxv4i1_nxv16i1_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x i1> @llvm.vector.extract.nxv4i1.nxv16i1(<vscale x 16 x i1> %in, i64 4)
  ret <vscale x 4 x i1> %res
}

define <vscale x 4 x i1> @extract_nxv4i1_nxv16i1_8(<vscale x 16 x i1> %in) {
; CHECK-LABEL: extract_nxv4i1_nxv16i1_8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x i1> @llvm.vector.extract.nxv4i1.nxv16i1(<vscale x 16 x i1> %in, i64 8)
  ret <vscale x 4 x i1> %res
}

define <vscale x 4 x i1> @extract_nxv4i1_nxv16i1_12(<vscale x 16 x i1> %in) {
; CHECK-LABEL: extract_nxv4i1_nxv16i1_12:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x i1> @llvm.vector.extract.nxv4i1.nxv16i1(<vscale x 16 x i1> %in, i64 12)
  ret <vscale x 4 x i1> %res
}

declare <vscale x 4 x i1> @llvm.vector.extract.nxv4i1.nxv16i1(<vscale x 16 x i1>, i64)

;
; Extract 1/8th i1 vector that needs promotion from legal type.
;
define <vscale x 2 x i1> @extract_nxv2i1_nxv16i1_0(<vscale x 16 x i1> %in) {
; CHECK-LABEL: extract_nxv2i1_nxv16i1_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x i1> @llvm.vector.extract.nxv2i1.nxv16i1(<vscale x 16 x i1> %in, i64 0)
  ret <vscale x 2 x i1> %res
}

define <vscale x 2 x i1> @extract_nxv2i1_nxv16i1_2(<vscale x 16 x i1> %in) {
; CHECK-LABEL: extract_nxv2i1_nxv16i1_2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x i1> @llvm.vector.extract.nxv2i1.nxv16i1(<vscale x 16 x i1> %in, i64 2)
  ret <vscale x 2 x i1> %res
}

define <vscale x 2 x i1> @extract_nxv2i1_nxv16i1_4(<vscale x 16 x i1> %in) {
; CHECK-LABEL: extract_nxv2i1_nxv16i1_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x i1> @llvm.vector.extract.nxv2i1.nxv16i1(<vscale x 16 x i1> %in, i64 4)
  ret <vscale x 2 x i1> %res
}

define <vscale x 2 x i1> @extract_nxv2i1_nxv16i1_6(<vscale x 16 x i1> %in) {
; CHECK-LABEL: extract_nxv2i1_nxv16i1_6:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x i1> @llvm.vector.extract.nxv2i1.nxv16i1(<vscale x 16 x i1> %in, i64 6)
  ret <vscale x 2 x i1> %res
}

define <vscale x 2 x i1> @extract_nxv2i1_nxv16i1_8(<vscale x 16 x i1> %in) {
; CHECK-LABEL: extract_nxv2i1_nxv16i1_8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x i1> @llvm.vector.extract.nxv2i1.nxv16i1(<vscale x 16 x i1> %in, i64 8)
  ret <vscale x 2 x i1> %res
}

define <vscale x 2 x i1> @extract_nxv2i1_nxv16i1_10(<vscale x 16 x i1> %in) {
; CHECK-LABEL: extract_nxv2i1_nxv16i1_10:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x i1> @llvm.vector.extract.nxv2i1.nxv16i1(<vscale x 16 x i1> %in, i64 10)
  ret <vscale x 2 x i1> %res
}

define <vscale x 2 x i1> @extract_nxv2i1_nxv16i1_12(<vscale x 16 x i1> %in) {
; CHECK-LABEL: extract_nxv2i1_nxv16i1_12:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x i1> @llvm.vector.extract.nxv2i1.nxv16i1(<vscale x 16 x i1> %in, i64 12)
  ret <vscale x 2 x i1> %res
}

define <vscale x 2 x i1> @extract_nxv2i1_nxv16i1_14(<vscale x 16 x i1> %in) {
; CHECK-LABEL: extract_nxv2i1_nxv16i1_14:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x i1> @llvm.vector.extract.nxv2i1.nxv16i1(<vscale x 16 x i1> %in, i64 14)
  ret <vscale x 2 x i1> %res
}

declare <vscale x 2 x i1> @llvm.vector.extract.nxv2i1.nxv16i1(<vscale x 16 x i1>, i64)

;
; Extract i1 vector that needs promotion from one that needs widening.
;
define <vscale x 4 x i1> @extract_nxv4i1_nxv12i1_0(<vscale x 12 x i1> %in) {
; CHECK-LABEL: extract_nxv4i1_nxv12i1_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x i1> @llvm.vector.extract.nxv4i1.nxv12i1(<vscale x 12 x i1> %in, i64 0)
  ret <vscale x 4 x i1> %res
}

define <vscale x 4 x i1> @extract_nxv4i1_nxv12i1_4(<vscale x 12 x i1> %in) {
; CHECK-LABEL: extract_nxv4i1_nxv12i1_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x i1> @llvm.vector.extract.nxv4i1.nxv12i1(<vscale x 12 x i1> %in, i64 4)
  ret <vscale x 4 x i1> %res
}

define <vscale x 4 x i1> @extract_nxv4i1_nxv12i1_8(<vscale x 12 x i1> %in) {
; CHECK-LABEL: extract_nxv4i1_nxv12i1_8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x i1> @llvm.vector.extract.nxv4i1.nxv12i1(<vscale x 12 x i1> %in, i64 8)
  ret <vscale x 4 x i1> %res
}

declare <vscale x 4 x i1> @llvm.vector.extract.nxv4i1.nxv12i1(<vscale x 12 x i1>, i64)

;
; Extract 1/8th i8 vector that needs promotion from legal type.
;
define <vscale x 2 x i8> @extract_nxv2i8_nxv16i8_0(<vscale x 16 x i8> %in) {
; CHECK-LABEL: extract_nxv2i8_nxv16i8_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x i8> @llvm.vector.extract.nxv2i8.nxv16i8(<vscale x 16 x i8> %in, i64 0)
  ret <vscale x 2 x i8> %res
}

define <vscale x 2 x i8> @extract_nxv2i8_nxv16i8_2(<vscale x 16 x i8> %in) {
; CHECK-LABEL: extract_nxv2i8_nxv16i8_2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpkhi z0.d, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x i8> @llvm.vector.extract.nxv2i8.nxv16i8(<vscale x 16 x i8> %in, i64 2)
  ret <vscale x 2 x i8> %res
}

define <vscale x 2 x i8> @extract_nxv2i8_nxv16i8_4(<vscale x 16 x i8> %in) {
; CHECK-LABEL: extract_nxv2i8_nxv16i8_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    uunpkhi z0.s, z0.h
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x i8> @llvm.vector.extract.nxv2i8.nxv16i8(<vscale x 16 x i8> %in, i64 4)
  ret <vscale x 2 x i8> %res
}

define <vscale x 2 x i8> @extract_nxv2i8_nxv16i8_6(<vscale x 16 x i8> %in) {
; CHECK-LABEL: extract_nxv2i8_nxv16i8_6:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    uunpkhi z0.s, z0.h
; CHECK-NEXT:    uunpkhi z0.d, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x i8> @llvm.vector.extract.nxv2i8.nxv16i8(<vscale x 16 x i8> %in, i64 6)
  ret <vscale x 2 x i8> %res
}

define <vscale x 2 x i8> @extract_nxv2i8_nxv16i8_8(<vscale x 16 x i8> %in) {
; CHECK-LABEL: extract_nxv2i8_nxv16i8_8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpkhi z0.h, z0.b
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x i8> @llvm.vector.extract.nxv2i8.nxv16i8(<vscale x 16 x i8> %in, i64 8)
  ret <vscale x 2 x i8> %res
}

define <vscale x 2 x i8> @extract_nxv2i8_nxv16i8_10(<vscale x 16 x i8> %in) {
; CHECK-LABEL: extract_nxv2i8_nxv16i8_10:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpkhi z0.h, z0.b
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpkhi z0.d, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x i8> @llvm.vector.extract.nxv2i8.nxv16i8(<vscale x 16 x i8> %in, i64 10)
  ret <vscale x 2 x i8> %res
}

define <vscale x 2 x i8> @extract_nxv2i8_nxv16i8_12(<vscale x 16 x i8> %in) {
; CHECK-LABEL: extract_nxv2i8_nxv16i8_12:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpkhi z0.h, z0.b
; CHECK-NEXT:    uunpkhi z0.s, z0.h
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x i8> @llvm.vector.extract.nxv2i8.nxv16i8(<vscale x 16 x i8> %in, i64 12)
  ret <vscale x 2 x i8> %res
}

define <vscale x 2 x i8> @extract_nxv2i8_nxv16i8_14(<vscale x 16 x i8> %in) {
; CHECK-LABEL: extract_nxv2i8_nxv16i8_14:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpkhi z0.h, z0.b
; CHECK-NEXT:    uunpkhi z0.s, z0.h
; CHECK-NEXT:    uunpkhi z0.d, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x i8> @llvm.vector.extract.nxv2i8.nxv16i8(<vscale x 16 x i8> %in, i64 14)
  ret <vscale x 2 x i8> %res
}

declare <vscale x 2 x i8> @llvm.vector.extract.nxv2i8.nxv16i8(<vscale x 16 x i8>, i64)

;
; Extract i8 vector that needs promotion from one that needs widening.
;
define <vscale x 4 x i8> @extract_nxv4i8_nxv12i8_0(<vscale x 12 x i8> %in) {
; CHECK-LABEL: extract_nxv4i8_nxv12i8_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x i8> @llvm.vector.extract.nxv4i8.nxv12i8(<vscale x 12 x i8> %in, i64 0)
  ret <vscale x 4 x i8> %res
}

define <vscale x 4 x i8> @extract_nxv4i8_nxv12i8_4(<vscale x 12 x i8> %in) {
; CHECK-LABEL: extract_nxv4i8_nxv12i8_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    uunpkhi z0.s, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x i8> @llvm.vector.extract.nxv4i8.nxv12i8(<vscale x 12 x i8> %in, i64 4)
  ret <vscale x 4 x i8> %res
}

define <vscale x 4 x i8> @extract_nxv4i8_nxv12i8_8(<vscale x 12 x i8> %in) {
; CHECK-LABEL: extract_nxv4i8_nxv12i8_8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpkhi z0.h, z0.b
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x i8> @llvm.vector.extract.nxv4i8.nxv12i8(<vscale x 12 x i8> %in, i64 8)
  ret <vscale x 4 x i8> %res
}

declare <vscale x 4 x i8> @llvm.vector.extract.nxv4i8.nxv12i8(<vscale x 12 x i8>, i64)

;
; Extract i8 vector that needs both widening + promotion from one that needs widening.
; (nxv6i8 -> nxv8i8 -> nxv8i16)
;
define <vscale x 6 x i8> @extract_nxv6i8_nxv12i8_0(<vscale x 12 x i8> %in) {
; CHECK-LABEL: extract_nxv6i8_nxv12i8_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 6 x i8> @llvm.vector.extract.nxv6i8.nxv12i8(<vscale x 12 x i8> %in, i64 0)
  ret <vscale x 6 x i8> %res
}

define <vscale x 6 x i8> @extract_nxv6i8_nxv12i8_6(<vscale x 12 x i8> %in) {
; CHECK-LABEL: extract_nxv6i8_nxv12i8_6:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpkhi z1.h, z0.b
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    uunpklo z1.s, z1.h
; CHECK-NEXT:    uunpkhi z0.s, z0.h
; CHECK-NEXT:    uunpkhi z2.d, z1.s
; CHECK-NEXT:    uunpklo z1.d, z1.s
; CHECK-NEXT:    uunpkhi z0.d, z0.s
; CHECK-NEXT:    uzp1 z2.s, z2.s, z0.s
; CHECK-NEXT:    uzp1 z0.s, z0.s, z1.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z2.h
; CHECK-NEXT:    ret
  %res = call <vscale x 6 x i8> @llvm.vector.extract.nxv6i8.nxv12i8(<vscale x 12 x i8> %in, i64 6)
  ret <vscale x 6 x i8> %res
}

declare <vscale x 6 x i8> @llvm.vector.extract.nxv6i8.nxv12i8(<vscale x 12 x i8>, i64)

;
; Extract half i8 vector that needs promotion from one that needs splitting.
;
define <vscale x 8 x i8> @extract_nxv8i8_nxv32i8_0(<vscale x 32 x i8> %in) {
; CHECK-LABEL: extract_nxv8i8_nxv32i8_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 8 x i8> @llvm.vector.extract.nxv8i8.nxv32i8(<vscale x 32 x i8> %in, i64 0)
  ret <vscale x 8 x i8> %res
}

define <vscale x 8 x i8> @extract_nxv8i8_nxv32i8_8(<vscale x 32 x i8> %in) {
; CHECK-LABEL: extract_nxv8i8_nxv32i8_8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpkhi z0.h, z0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 8 x i8> @llvm.vector.extract.nxv8i8.nxv32i8(<vscale x 32 x i8> %in, i64 8)
  ret <vscale x 8 x i8> %res
}

define <vscale x 8 x i8> @extract_nxv8i8_nxv32i8_16(<vscale x 32 x i8> %in) {
; CHECK-LABEL: extract_nxv8i8_nxv32i8_16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.h, z1.b
; CHECK-NEXT:    ret
  %res = call <vscale x 8 x i8> @llvm.vector.extract.nxv8i8.nxv32i8(<vscale x 32 x i8> %in, i64 16)
  ret <vscale x 8 x i8> %res
}

define <vscale x 8 x i8> @extract_nxv8i8_nxv32i8_24(<vscale x 32 x i8> %in) {
; CHECK-LABEL: extract_nxv8i8_nxv32i8_24:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpkhi z0.h, z1.b
; CHECK-NEXT:    ret
  %res = call <vscale x 8 x i8> @llvm.vector.extract.nxv8i8.nxv32i8(<vscale x 32 x i8> %in, i64 24)
  ret <vscale x 8 x i8> %res
}

declare <vscale x 8 x i8> @llvm.vector.extract.nxv8i8.nxv32i8(<vscale x 32 x i8>, i64)

;
; Extract half i8 vector that needs promotion from legal type.
;
define <vscale x 8 x i8> @extract_nxv8i8_nxv16i8_0(<vscale x 16 x i8> %in) {
; CHECK-LABEL: extract_nxv8i8_nxv16i8_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 8 x i8> @llvm.vector.extract.nxv8i8.nxv16i8(<vscale x 16 x i8> %in, i64 0)
  ret <vscale x 8 x i8> %res
}

define <vscale x 8 x i8> @extract_nxv8i8_nxv16i8_8(<vscale x 16 x i8> %in) {
; CHECK-LABEL: extract_nxv8i8_nxv16i8_8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpkhi z0.h, z0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 8 x i8> @llvm.vector.extract.nxv8i8.nxv16i8(<vscale x 16 x i8> %in, i64 8)
  ret <vscale x 8 x i8> %res
}

declare <vscale x 8 x i8> @llvm.vector.extract.nxv8i8.nxv16i8(<vscale x 16 x i8>, i64)

;
; Extract i8 vector that needs widening from one that needs widening.
;
define <vscale x 14 x i8> @extract_nxv14i8_nxv28i8_0(<vscale x 28 x i8> %in) {
; CHECK-LABEL: extract_nxv14i8_nxv28i8_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %res = call <vscale x 14 x i8> @llvm.vector.extract.nxv14i8.nxv28i8(<vscale x 28 x i8> %in, i64 0)
  ret <vscale x 14 x i8> %res
}

define <vscale x 14 x i8> @extract_nxv14i8_nxv28i8_14(<vscale x 28 x i8> %in) {
; CHECK-LABEL: extract_nxv14i8_nxv28i8_14:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpkhi z0.h, z0.b
; CHECK-NEXT:    uunpklo z2.h, z1.b
; CHECK-NEXT:    uunpkhi z0.s, z0.h
; CHECK-NEXT:    uunpklo z4.s, z2.h
; CHECK-NEXT:    uunpkhi z0.d, z0.s
; CHECK-NEXT:    uunpklo z5.d, z4.s
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    uunpkhi z4.d, z4.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    uunpkhi z2.s, z2.h
; CHECK-NEXT:    uzp1 z0.b, z0.b, z0.b
; CHECK-NEXT:    uunpkhi z1.h, z1.b
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    uunpklo z1.s, z1.h
; CHECK-NEXT:    uunpklo z3.s, z0.h
; CHECK-NEXT:    uunpkhi z0.s, z0.h
; CHECK-NEXT:    uunpklo z3.d, z3.s
; CHECK-NEXT:    uzp1 z3.s, z3.s, z5.s
; CHECK-NEXT:    uzp1 z0.h, z3.h, z0.h
; CHECK-NEXT:    uzp1 z0.b, z0.b, z0.b
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    uunpkhi z3.s, z0.h
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpkhi z3.d, z3.s
; CHECK-NEXT:    uzp1 z3.s, z4.s, z3.s
; CHECK-NEXT:    uunpklo z4.d, z2.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z3.h
; CHECK-NEXT:    uunpkhi z2.d, z2.s
; CHECK-NEXT:    uzp1 z0.b, z0.b, z0.b
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    uunpkhi z3.s, z0.h
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpklo z3.d, z3.s
; CHECK-NEXT:    uzp1 z3.s, z3.s, z4.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z3.h
; CHECK-NEXT:    uzp1 z3.b, z0.b, z0.b
; CHECK-NEXT:    uunpkhi z3.h, z3.b
; CHECK-NEXT:    uunpklo z4.s, z3.h
; CHECK-NEXT:    uunpkhi z3.s, z3.h
; CHECK-NEXT:    uunpkhi z4.d, z4.s
; CHECK-NEXT:    uzp1 z2.s, z2.s, z4.s
; CHECK-NEXT:    uunpklo z4.d, z1.s
; CHECK-NEXT:    uzp1 z2.h, z2.h, z3.h
; CHECK-NEXT:    uunpkhi z1.d, z1.s
; CHECK-NEXT:    uzp1 z2.b, z0.b, z2.b
; CHECK-NEXT:    uunpkhi z2.h, z2.b
; CHECK-NEXT:    uunpklo z3.s, z2.h
; CHECK-NEXT:    uunpkhi z2.s, z2.h
; CHECK-NEXT:    uunpklo z3.d, z3.s
; CHECK-NEXT:    uzp1 z3.s, z3.s, z4.s
; CHECK-NEXT:    uzp1 z2.h, z3.h, z2.h
; CHECK-NEXT:    uzp1 z2.b, z0.b, z2.b
; CHECK-NEXT:    uunpkhi z2.h, z2.b
; CHECK-NEXT:    uunpkhi z3.s, z2.h
; CHECK-NEXT:    uunpklo z2.s, z2.h
; CHECK-NEXT:    uunpkhi z3.d, z3.s
; CHECK-NEXT:    uzp1 z1.s, z1.s, z3.s
; CHECK-NEXT:    uzp1 z1.h, z2.h, z1.h
; CHECK-NEXT:    uzp1 z1.b, z0.b, z1.b
; CHECK-NEXT:    uunpkhi z1.h, z1.b
; CHECK-NEXT:    uunpkhi z2.s, z1.h
; CHECK-NEXT:    uunpklo z1.s, z1.h
; CHECK-NEXT:    uunpklo z2.d, z2.s
; CHECK-NEXT:    uzp1 z2.s, z2.s, z0.s
; CHECK-NEXT:    uzp1 z1.h, z1.h, z2.h
; CHECK-NEXT:    uzp1 z0.b, z0.b, z1.b
; CHECK-NEXT:    ret
  %res = call <vscale x 14 x i8> @llvm.vector.extract.nxv14i8.nxv28i8(<vscale x 28 x i8> %in, i64 14)
  ret <vscale x 14 x i8> %res
}

declare <vscale x 14 x i8> @llvm.vector.extract.nxv14i8.nxv28i8(<vscale x 28 x i8>, i64)

;
; Extract 1/4th i8 vector that needs promotion from legal type.
;
define <vscale x 4 x i8> @extract_nxv4i8_nxv16i8_0(<vscale x 16 x i8> %in) {
; CHECK-LABEL: extract_nxv4i8_nxv16i8_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x i8> @llvm.vector.extract.nxv4i8.nxv16i8(<vscale x 16 x i8> %in, i64 0)
  ret <vscale x 4 x i8> %res
}

define <vscale x 4 x i8> @extract_nxv4i8_nxv16i8_4(<vscale x 16 x i8> %in) {
; CHECK-LABEL: extract_nxv4i8_nxv16i8_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    uunpkhi z0.s, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x i8> @llvm.vector.extract.nxv4i8.nxv16i8(<vscale x 16 x i8> %in, i64 4)
  ret <vscale x 4 x i8> %res
}

define <vscale x 4 x i8> @extract_nxv4i8_nxv16i8_8(<vscale x 16 x i8> %in) {
; CHECK-LABEL: extract_nxv4i8_nxv16i8_8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpkhi z0.h, z0.b
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x i8> @llvm.vector.extract.nxv4i8.nxv16i8(<vscale x 16 x i8> %in, i64 8)
  ret <vscale x 4 x i8> %res
}

define <vscale x 4 x i8> @extract_nxv4i8_nxv16i8_12(<vscale x 16 x i8> %in) {
; CHECK-LABEL: extract_nxv4i8_nxv16i8_12:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpkhi z0.h, z0.b
; CHECK-NEXT:    uunpkhi z0.s, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x i8> @llvm.vector.extract.nxv4i8.nxv16i8(<vscale x 16 x i8> %in, i64 12)
  ret <vscale x 4 x i8> %res
}

declare <vscale x 4 x i8> @llvm.vector.extract.nxv4i8.nxv16i8(<vscale x 16 x i8>, i64)

;
; Extract f16 vector that needs promotion from one that needs widening.
;
define <vscale x 2 x half> @extract_nxv2f16_nxv6f16_0(<vscale x 6 x half> %in) {
; CHECK-LABEL: extract_nxv2f16_nxv6f16_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x half> @llvm.vector.extract.nxv2f16.nxv6f16(<vscale x 6 x half> %in, i64 0)
  ret <vscale x 2 x half> %res
}

define <vscale x 2 x half> @extract_nxv2f16_nxv6f16_2(<vscale x 6 x half> %in) {
; CHECK-LABEL: extract_nxv2f16_nxv6f16_2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpkhi z0.d, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x half> @llvm.vector.extract.nxv2f16.nxv6f16(<vscale x 6 x half> %in, i64 2)
  ret <vscale x 2 x half> %res
}

define <vscale x 2 x half> @extract_nxv2f16_nxv6f16_4(<vscale x 6 x half> %in) {
; CHECK-LABEL: extract_nxv2f16_nxv6f16_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpkhi z0.s, z0.h
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x half> @llvm.vector.extract.nxv2f16.nxv6f16(<vscale x 6 x half> %in, i64 4)
  ret <vscale x 2 x half> %res
}

declare <vscale x 2 x half> @llvm.vector.extract.nxv2f16.nxv6f16(<vscale x 6 x half>, i64)

;
; Extract half f16 vector that needs promotion from legal type.
;
define <vscale x 4 x half> @extract_nxv4f16_nxv8f16_0(<vscale x 8 x half> %in) {
; CHECK-LABEL: extract_nxv4f16_nxv8f16_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x half> @llvm.vector.extract.nxv4f16.nxv8f16(<vscale x 8 x half> %in, i64 0)
  ret <vscale x 4 x half> %res
}

define <vscale x 4 x half> @extract_nxv4f16_nxv8f16_4(<vscale x 8 x half> %in) {
; CHECK-LABEL: extract_nxv4f16_nxv8f16_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpkhi z0.s, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x half> @llvm.vector.extract.nxv4f16.nxv8f16(<vscale x 8 x half> %in, i64 4)
  ret <vscale x 4 x half> %res
}

declare <vscale x 4 x half> @llvm.vector.extract.nxv4f16.nxv8f16(<vscale x 8 x half>, i64)

;
; Extract f16 vector that needs widening from one that needs widening.
;
define <vscale x 6 x half> @extract_nxv6f16_nxv12f16_0(<vscale x 12 x half> %in) {
; CHECK-LABEL: extract_nxv6f16_nxv12f16_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %res = call <vscale x 6 x half> @llvm.vector.extract.nxv6f16.nxv12f16(<vscale x 12 x half> %in, i64 0)
  ret <vscale x 6 x half> %res
}

define <vscale x 6 x half> @extract_nxv6f16_nxv12f16_6(<vscale x 12 x half> %in) {
; CHECK-LABEL: extract_nxv6f16_nxv12f16_6:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z1.s, z1.h
; CHECK-NEXT:    uunpkhi z0.s, z0.h
; CHECK-NEXT:    uunpkhi z2.d, z1.s
; CHECK-NEXT:    uunpklo z1.d, z1.s
; CHECK-NEXT:    uunpkhi z0.d, z0.s
; CHECK-NEXT:    uzp1 z2.s, z2.s, z0.s
; CHECK-NEXT:    uzp1 z0.s, z0.s, z1.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z2.h
; CHECK-NEXT:    ret
  %res = call <vscale x 6 x half> @llvm.vector.extract.nxv6f16.nxv12f16(<vscale x 12 x half> %in, i64 6)
  ret <vscale x 6 x half> %res
}

declare <vscale x 6 x half> @llvm.vector.extract.nxv6f16.nxv12f16(<vscale x 12 x half>, i64)

;
; Extract half f16 vector that needs promotion from one that needs splitting.
;
define <vscale x 4 x half> @extract_nxv4f16_nxv16f16_0(<vscale x 16 x half> %in) {
; CHECK-LABEL: extract_nxv4f16_nxv16f16_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x half> @llvm.vector.extract.nxv4f16.nxv16f16(<vscale x 16 x half> %in, i64 0)
  ret <vscale x 4 x half> %res
}

define <vscale x 4 x half> @extract_nxv4f16_nxv16f16_4(<vscale x 16 x half> %in) {
; CHECK-LABEL: extract_nxv4f16_nxv16f16_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpkhi z0.s, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x half> @llvm.vector.extract.nxv4f16.nxv16f16(<vscale x 16 x half> %in, i64 4)
  ret <vscale x 4 x half> %res
}

define <vscale x 4 x half> @extract_nxv4f16_nxv16f16_8(<vscale x 16 x half> %in) {
; CHECK-LABEL: extract_nxv4f16_nxv16f16_8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.s, z1.h
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x half> @llvm.vector.extract.nxv4f16.nxv16f16(<vscale x 16 x half> %in, i64 8)
  ret <vscale x 4 x half> %res
}

define <vscale x 4 x half> @extract_nxv4f16_nxv16f16_12(<vscale x 16 x half> %in) {
; CHECK-LABEL: extract_nxv4f16_nxv16f16_12:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpkhi z0.s, z1.h
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x half> @llvm.vector.extract.nxv4f16.nxv16f16(<vscale x 16 x half> %in, i64 12)
  ret <vscale x 4 x half> %res
}

declare <vscale x 4 x half> @llvm.vector.extract.nxv4f16.nxv16f16(<vscale x 16 x half>, i64)

;
; Extract 1/4th f16 vector that needs promotion from legal type.
;
define <vscale x 2 x half> @extract_nxv2f16_nxv8f16_0(<vscale x 8 x half> %in) {
; CHECK-LABEL: extract_nxv2f16_nxv8f16_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x half> @llvm.vector.extract.nxv2f16.nxv8f16(<vscale x 8 x half> %in, i64 0)
  ret <vscale x 2 x half> %res
}

define <vscale x 2 x half> @extract_nxv2f16_nxv8f16_2(<vscale x 8 x half> %in) {
; CHECK-LABEL: extract_nxv2f16_nxv8f16_2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpkhi z0.d, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x half> @llvm.vector.extract.nxv2f16.nxv8f16(<vscale x 8 x half> %in, i64 2)
  ret <vscale x 2 x half> %res
}

define <vscale x 2 x half> @extract_nxv2f16_nxv8f16_4(<vscale x 8 x half> %in) {
; CHECK-LABEL: extract_nxv2f16_nxv8f16_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpkhi z0.s, z0.h
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x half> @llvm.vector.extract.nxv2f16.nxv8f16(<vscale x 8 x half> %in, i64 4)
  ret <vscale x 2 x half> %res
}

define <vscale x 2 x half> @extract_nxv2f16_nxv8f16_6(<vscale x 8 x half> %in) {
; CHECK-LABEL: extract_nxv2f16_nxv8f16_6:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpkhi z0.s, z0.h
; CHECK-NEXT:    uunpkhi z0.d, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x half> @llvm.vector.extract.nxv2f16.nxv8f16(<vscale x 8 x half> %in, i64 6)
  ret <vscale x 2 x half> %res
}

declare <vscale x 2 x half> @llvm.vector.extract.nxv2f16.nxv8f16(<vscale x 8 x half>, i64)

;
; Extract half bf16 vector that needs promotion from legal type.
;
define <vscale x 4 x bfloat> @extract_nxv4bf16_nxv8bf16_0(<vscale x 8 x bfloat> %in) {
; CHECK-LABEL: extract_nxv4bf16_nxv8bf16_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x bfloat> @llvm.vector.extract.nxv4bf16.nxv8bf16(<vscale x 8 x bfloat> %in, i64 0)
  ret <vscale x 4 x bfloat> %res
}

define <vscale x 4 x bfloat> @extract_nxv4bf16_nxv8bf16_4(<vscale x 8 x bfloat> %in) {
; CHECK-LABEL: extract_nxv4bf16_nxv8bf16_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpkhi z0.s, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x bfloat> @llvm.vector.extract.nxv4bf16.nxv8bf16(<vscale x 8 x bfloat> %in, i64 4)
  ret <vscale x 4 x bfloat> %res
}

declare <vscale x 4 x bfloat> @llvm.vector.extract.nxv4bf16.nxv8bf16(<vscale x 8 x bfloat>, i64)

;
; Extract bf16 vector that needs widening from one that needs widening.
;
define <vscale x 6 x bfloat> @extract_nxv6bf16_nxv12bf16_0(<vscale x 12 x bfloat> %in) {
; CHECK-LABEL: extract_nxv6bf16_nxv12bf16_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %res = call <vscale x 6 x bfloat> @llvm.vector.extract.nxv6bf16.nxv12bf16(<vscale x 12 x bfloat> %in, i64 0)
  ret <vscale x 6 x bfloat> %res
}

define <vscale x 6 x bfloat> @extract_nxv6bf16_nxv12bf16_6(<vscale x 12 x bfloat> %in) {
; CHECK-LABEL: extract_nxv6bf16_nxv12bf16_6:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z1.s, z1.h
; CHECK-NEXT:    uunpkhi z0.s, z0.h
; CHECK-NEXT:    uunpkhi z2.d, z1.s
; CHECK-NEXT:    uunpklo z1.d, z1.s
; CHECK-NEXT:    uunpkhi z0.d, z0.s
; CHECK-NEXT:    uzp1 z2.s, z2.s, z0.s
; CHECK-NEXT:    uzp1 z0.s, z0.s, z1.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z2.h
; CHECK-NEXT:    ret
  %res = call <vscale x 6 x bfloat> @llvm.vector.extract.nxv6bf16.nxv12bf16(<vscale x 12 x bfloat> %in, i64 6)
  ret <vscale x 6 x bfloat> %res
}

declare <vscale x 6 x bfloat> @llvm.vector.extract.nxv6bf16.nxv12bf16(<vscale x 12 x bfloat>, i64)

;
; Extract bf16 vector that needs promotion from one that needs widening.
;
define <vscale x 2 x bfloat> @extract_nxv2bf16_nxv6bf16_0(<vscale x 6 x bfloat> %in) {
; CHECK-LABEL: extract_nxv2bf16_nxv6bf16_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x bfloat> @llvm.vector.extract.nxv2bf16.nxv6bf16(<vscale x 6 x bfloat> %in, i64 0)
  ret <vscale x 2 x bfloat> %res
}

define <vscale x 2 x bfloat> @extract_nxv2bf16_nxv6bf16_2(<vscale x 6 x bfloat> %in) {
; CHECK-LABEL: extract_nxv2bf16_nxv6bf16_2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpkhi z0.d, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x bfloat> @llvm.vector.extract.nxv2bf16.nxv6bf16(<vscale x 6 x bfloat> %in, i64 2)
  ret <vscale x 2 x bfloat> %res
}

define <vscale x 2 x bfloat> @extract_nxv2bf16_nxv6bf16_4(<vscale x 6 x bfloat> %in) {
; CHECK-LABEL: extract_nxv2bf16_nxv6bf16_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpkhi z0.s, z0.h
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x bfloat> @llvm.vector.extract.nxv2bf16.nxv6bf16(<vscale x 6 x bfloat> %in, i64 4)
  ret <vscale x 2 x bfloat> %res
}

declare <vscale x 2 x bfloat> @llvm.vector.extract.nxv2bf16.nxv6bf16(<vscale x 6 x bfloat>, i64)

;
; Extract 1/4th bf16 vector that needs promotion from legal type.
;
define <vscale x 2 x bfloat> @extract_nxv2bf16_nxv8bf16_0(<vscale x 8 x bfloat> %in) {
; CHECK-LABEL: extract_nxv2bf16_nxv8bf16_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x bfloat> @llvm.vector.extract.nxv2bf16.nxv8bf16(<vscale x 8 x bfloat> %in, i64 0)
  ret <vscale x 2 x bfloat> %res
}

define <vscale x 2 x bfloat> @extract_nxv2bf16_nxv8bf16_2(<vscale x 8 x bfloat> %in) {
; CHECK-LABEL: extract_nxv2bf16_nxv8bf16_2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpkhi z0.d, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x bfloat> @llvm.vector.extract.nxv2bf16.nxv8bf16(<vscale x 8 x bfloat> %in, i64 2)
  ret <vscale x 2 x bfloat> %res
}

define <vscale x 2 x bfloat> @extract_nxv2bf16_nxv8bf16_4(<vscale x 8 x bfloat> %in) {
; CHECK-LABEL: extract_nxv2bf16_nxv8bf16_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpkhi z0.s, z0.h
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x bfloat> @llvm.vector.extract.nxv2bf16.nxv8bf16(<vscale x 8 x bfloat> %in, i64 4)
  ret <vscale x 2 x bfloat> %res
}

define <vscale x 2 x bfloat> @extract_nxv2bf16_nxv8bf16_6(<vscale x 8 x bfloat> %in) {
; CHECK-LABEL: extract_nxv2bf16_nxv8bf16_6:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpkhi z0.s, z0.h
; CHECK-NEXT:    uunpkhi z0.d, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x bfloat> @llvm.vector.extract.nxv2bf16.nxv8bf16(<vscale x 8 x bfloat> %in, i64 6)
  ret <vscale x 2 x bfloat> %res
}

declare <vscale x 2 x bfloat> @llvm.vector.extract.nxv2bf16.nxv8bf16(<vscale x 8 x bfloat>, i64)

;
; Extract half bf16 vector that needs promotion from one that needs splitting.
;
define <vscale x 4 x bfloat> @extract_nxv4bf16_nxv16bf16_0(<vscale x 16 x bfloat> %in) {
; CHECK-LABEL: extract_nxv4bf16_nxv16bf16_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x bfloat> @llvm.vector.extract.nxv4bf16.nxv16bf16(<vscale x 16 x bfloat> %in, i64 0)
  ret <vscale x 4 x bfloat> %res
}

define <vscale x 4 x bfloat> @extract_nxv4bf16_nxv16bf16_4(<vscale x 16 x bfloat> %in) {
; CHECK-LABEL: extract_nxv4bf16_nxv16bf16_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpkhi z0.s, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x bfloat> @llvm.vector.extract.nxv4bf16.nxv16bf16(<vscale x 16 x bfloat> %in, i64 4)
  ret <vscale x 4 x bfloat> %res
}

define <vscale x 4 x bfloat> @extract_nxv4bf16_nxv16bf16_8(<vscale x 16 x bfloat> %in) {
; CHECK-LABEL: extract_nxv4bf16_nxv16bf16_8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.s, z1.h
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x bfloat> @llvm.vector.extract.nxv4bf16.nxv16bf16(<vscale x 16 x bfloat> %in, i64 8)
  ret <vscale x 4 x bfloat> %res
}

define <vscale x 4 x bfloat> @extract_nxv4bf16_nxv16bf16_12(<vscale x 16 x bfloat> %in) {
; CHECK-LABEL: extract_nxv4bf16_nxv16bf16_12:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpkhi z0.s, z1.h
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x bfloat> @llvm.vector.extract.nxv4bf16.nxv16bf16(<vscale x 16 x bfloat> %in, i64 12)
  ret <vscale x 4 x bfloat> %res
}

declare <vscale x 4 x bfloat> @llvm.vector.extract.nxv4bf16.nxv16bf16(<vscale x 16 x bfloat>, i64)


;
; Extract from a splat
;
define <vscale x 2 x float> @extract_nxv2f32_nxv4f32_splat(float %f) {
; CHECK-LABEL: extract_nxv2f32_nxv4f32_splat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $s0 killed $s0 def $z0
; CHECK-NEXT:    mov z0.s, s0
; CHECK-NEXT:    ret
  %ins = insertelement <vscale x 4 x float> poison, float %f, i32 0
  %splat = shufflevector <vscale x 4 x float> %ins, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %ext = call <vscale x 2 x float> @llvm.vector.extract.nxv2f32.nxv4f32(<vscale x 4 x float> %splat, i64 0)
  ret <vscale x 2 x float> %ext
}

define <vscale x 2 x float> @extract_nxv2f32_nxv4f32_splat_const() {
; CHECK-LABEL: extract_nxv2f32_nxv4f32_splat_const:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmov z0.s, #1.00000000
; CHECK-NEXT:    ret
  %ins = insertelement <vscale x 4 x float> poison, float 1.0, i32 0
  %splat = shufflevector <vscale x 4 x float> %ins, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %ext = call <vscale x 2 x float> @llvm.vector.extract.nxv2f32.nxv4f32(<vscale x 4 x float> %splat, i64 0)
  ret <vscale x 2 x float> %ext
}

define <vscale x 4 x i32> @extract_nxv4i32_nxv8i32_splat_const() {
; CHECK-LABEL: extract_nxv4i32_nxv8i32_splat_const:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov z0.s, #1 // =0x1
; CHECK-NEXT:    ret
  %ins = insertelement <vscale x 8 x i32> poison, i32 1, i32 0
  %splat = shufflevector <vscale x 8 x i32> %ins, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %ext = call <vscale x 4 x i32> @llvm.vector.extract.nxv4i32.nxv8i32(<vscale x 8 x i32> %splat, i64 0)
  ret <vscale x 4 x i32> %ext
}

define <vscale x 2 x i1> @extract_nxv2i1_nxv16i1_all_ones() {
; CHECK-LABEL: extract_nxv2i1_nxv16i1_all_ones:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ret
  %ins = insertelement <vscale x 16 x i1> poison, i1 1, i32 0
  %splat = shufflevector <vscale x 16 x i1> %ins, <vscale x 16 x i1> poison, <vscale x 16 x i32> zeroinitializer
  %ext = call <vscale x 2 x i1> @llvm.vector.extract.nxv2i1.nxv16i1(<vscale x 16 x i1> %splat, i64 0)
  ret <vscale x 2 x i1> %ext
}

define <vscale x 2 x i1> @extract_nxv2i1_nxv16i1_all_zero() {
; CHECK-LABEL: extract_nxv2i1_nxv16i1_all_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    pfalse p0.b
; CHECK-NEXT:    ret
  %ext = call <vscale x 2 x i1> @llvm.vector.extract.nxv2i1.nxv16i1(<vscale x 16 x i1> zeroinitializer, i64 0)
  ret <vscale x 2 x i1> %ext
}

declare <vscale x 2 x float> @llvm.vector.extract.nxv2f32.nxv4f32(<vscale x 4 x float>, i64)
declare <vscale x 4 x i32> @llvm.vector.extract.nxv4i32.nxv8i32(<vscale x 8 x i32>, i64)

;
; Extract nxv1i1 type from: nxv2i1
;

define <vscale x 1 x i1> @extract_nxv1i1_nxv2i1_0(<vscale x 2 x i1> %in) {
; CHECK-LABEL: extract_nxv1i1_nxv2i1_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv2i1(<vscale x 2 x i1> %in, i64 0)
  ret <vscale x 1 x i1> %res
}

define <vscale x 1 x i1> @extract_nxv1i1_nxv2i1_1(<vscale x 2 x i1> %in) {
; CHECK-LABEL: extract_nxv1i1_nxv2i1_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv2i1(<vscale x 2 x i1> %in, i64 1)
  ret <vscale x 1 x i1> %res
}

;
; Extract nxv1i1 type from: nxv4i1
;

define <vscale x 1 x i1> @extract_nxv1i1_nxv4i1_0(<vscale x 4 x i1> %in) {
; CHECK-LABEL: extract_nxv1i1_nxv4i1_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv4i1(<vscale x 4 x i1> %in, i64 0)
  ret <vscale x 1 x i1> %res
}

define <vscale x 1 x i1> @extract_nxv1i1_nxv4i1_1(<vscale x 4 x i1> %in) {
; CHECK-LABEL: extract_nxv1i1_nxv4i1_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv4i1(<vscale x 4 x i1> %in, i64 1)
  ret <vscale x 1 x i1> %res
}

define <vscale x 1 x i1> @extract_nxv1i1_nxv4i1_2(<vscale x 4 x i1> %in) {
; CHECK-LABEL: extract_nxv1i1_nxv4i1_2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv4i1(<vscale x 4 x i1> %in, i64 2)
  ret <vscale x 1 x i1> %res
}

define <vscale x 1 x i1> @extract_nxv1i1_nxv4i1_3(<vscale x 4 x i1> %in) {
; CHECK-LABEL: extract_nxv1i1_nxv4i1_3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv4i1(<vscale x 4 x i1> %in, i64 3)
  ret <vscale x 1 x i1> %res
}

;
; Extract nxv1i1 type from: nxv8i1
;

define <vscale x 1 x i1> @extract_nxv1i1_nxv8i1_0(<vscale x 8 x i1> %in) {
; CHECK-LABEL: extract_nxv1i1_nxv8i1_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv8i1(<vscale x 8 x i1> %in, i64 0)
  ret <vscale x 1 x i1> %res
}

define <vscale x 1 x i1> @extract_nxv1i1_nxv8i1_1(<vscale x 8 x i1> %in) {
; CHECK-LABEL: extract_nxv1i1_nxv8i1_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv8i1(<vscale x 8 x i1> %in, i64 1)
  ret <vscale x 1 x i1> %res
}

define <vscale x 1 x i1> @extract_nxv1i1_nxv8i1_2(<vscale x 8 x i1> %in) {
; CHECK-LABEL: extract_nxv1i1_nxv8i1_2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv8i1(<vscale x 8 x i1> %in, i64 2)
  ret <vscale x 1 x i1> %res
}

define <vscale x 1 x i1> @extract_nxv1i1_nxv8i1_3(<vscale x 8 x i1> %in) {
; CHECK-LABEL: extract_nxv1i1_nxv8i1_3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv8i1(<vscale x 8 x i1> %in, i64 3)
  ret <vscale x 1 x i1> %res
}

define <vscale x 1 x i1> @extract_nxv1i1_nxv8i1_4(<vscale x 8 x i1> %in) {
; CHECK-LABEL: extract_nxv1i1_nxv8i1_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv8i1(<vscale x 8 x i1> %in, i64 4)
  ret <vscale x 1 x i1> %res
}

define <vscale x 1 x i1> @extract_nxv1i1_nxv8i1_5(<vscale x 8 x i1> %in) {
; CHECK-LABEL: extract_nxv1i1_nxv8i1_5:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv8i1(<vscale x 8 x i1> %in, i64 5)
  ret <vscale x 1 x i1> %res
}

define <vscale x 1 x i1> @extract_nxv1i1_nxv8i1_6(<vscale x 8 x i1> %in) {
; CHECK-LABEL: extract_nxv1i1_nxv8i1_6:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv8i1(<vscale x 8 x i1> %in, i64 6)
  ret <vscale x 1 x i1> %res
}

define <vscale x 1 x i1> @extract_nxv1i1_nxv8i1_7(<vscale x 8 x i1> %in) {
; CHECK-LABEL: extract_nxv1i1_nxv8i1_7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv8i1(<vscale x 8 x i1> %in, i64 7)
  ret <vscale x 1 x i1> %res
}


;
; Extract nxv1i1 type from: nxv16i1
;

define <vscale x 1 x i1> @extract_nxv1i1_nxv16i1_0(<vscale x 16 x i1> %in) {
; CHECK-LABEL: extract_nxv1i1_nxv16i1_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv16i1(<vscale x 16 x i1> %in, i64 0)
  ret <vscale x 1 x i1> %res
}

define <vscale x 1 x i1> @extract_nxv1i1_nxv16i1_1(<vscale x 16 x i1> %in) {
; CHECK-LABEL: extract_nxv1i1_nxv16i1_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv16i1(<vscale x 16 x i1> %in, i64 1)
  ret <vscale x 1 x i1> %res
}

define <vscale x 1 x i1> @extract_nxv1i1_nxv16i1_2(<vscale x 16 x i1> %in) {
; CHECK-LABEL: extract_nxv1i1_nxv16i1_2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv16i1(<vscale x 16 x i1> %in, i64 2)
  ret <vscale x 1 x i1> %res
}

define <vscale x 1 x i1> @extract_nxv1i1_nxv16i1_3(<vscale x 16 x i1> %in) {
; CHECK-LABEL: extract_nxv1i1_nxv16i1_3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv16i1(<vscale x 16 x i1> %in, i64 3)
  ret <vscale x 1 x i1> %res
}

define <vscale x 1 x i1> @extract_nxv1i1_nxv16i1_4(<vscale x 16 x i1> %in) {
; CHECK-LABEL: extract_nxv1i1_nxv16i1_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv16i1(<vscale x 16 x i1> %in, i64 4)
  ret <vscale x 1 x i1> %res
}

define <vscale x 1 x i1> @extract_nxv1i1_nxv16i1_5(<vscale x 16 x i1> %in) {
; CHECK-LABEL: extract_nxv1i1_nxv16i1_5:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv16i1(<vscale x 16 x i1> %in, i64 5)
  ret <vscale x 1 x i1> %res
}

define <vscale x 1 x i1> @extract_nxv1i1_nxv16i1_6(<vscale x 16 x i1> %in) {
; CHECK-LABEL: extract_nxv1i1_nxv16i1_6:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv16i1(<vscale x 16 x i1> %in, i64 6)
  ret <vscale x 1 x i1> %res
}

define <vscale x 1 x i1> @extract_nxv1i1_nxv16i1_7(<vscale x 16 x i1> %in) {
; CHECK-LABEL: extract_nxv1i1_nxv16i1_7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv16i1(<vscale x 16 x i1> %in, i64 7)
  ret <vscale x 1 x i1> %res
}

define <vscale x 1 x i1> @extract_nxv1i1_nxv16i1_8(<vscale x 16 x i1> %in) {
; CHECK-LABEL: extract_nxv1i1_nxv16i1_8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv16i1(<vscale x 16 x i1> %in, i64 8)
  ret <vscale x 1 x i1> %res
}

define <vscale x 1 x i1> @extract_nxv1i1_nxv16i1_9(<vscale x 16 x i1> %in) {
; CHECK-LABEL: extract_nxv1i1_nxv16i1_9:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv16i1(<vscale x 16 x i1> %in, i64 9)
  ret <vscale x 1 x i1> %res
}

define <vscale x 1 x i1> @extract_nxv1i1_nxv16i1_10(<vscale x 16 x i1> %in) {
; CHECK-LABEL: extract_nxv1i1_nxv16i1_10:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv16i1(<vscale x 16 x i1> %in, i64 10)
  ret <vscale x 1 x i1> %res
}

define <vscale x 1 x i1> @extract_nxv1i1_nxv16i1_11(<vscale x 16 x i1> %in) {
; CHECK-LABEL: extract_nxv1i1_nxv16i1_11:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv16i1(<vscale x 16 x i1> %in, i64 11)
  ret <vscale x 1 x i1> %res
}

define <vscale x 1 x i1> @extract_nxv1i1_nxv16i1_12(<vscale x 16 x i1> %in) {
; CHECK-LABEL: extract_nxv1i1_nxv16i1_12:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv16i1(<vscale x 16 x i1> %in, i64 12)
  ret <vscale x 1 x i1> %res
}

define <vscale x 1 x i1> @extract_nxv1i1_nxv16i1_13(<vscale x 16 x i1> %in) {
; CHECK-LABEL: extract_nxv1i1_nxv16i1_13:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv16i1(<vscale x 16 x i1> %in, i64 13)
  ret <vscale x 1 x i1> %res
}

define <vscale x 1 x i1> @extract_nxv1i1_nxv16i1_14(<vscale x 16 x i1> %in) {
; CHECK-LABEL: extract_nxv1i1_nxv16i1_14:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpklo p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv16i1(<vscale x 16 x i1> %in, i64 14)
  ret <vscale x 1 x i1> %res
}

define <vscale x 1 x i1> @extract_nxv1i1_nxv16i1_15(<vscale x 16 x i1> %in) {
; CHECK-LABEL: extract_nxv1i1_nxv16i1_15:
; CHECK:       // %bb.0:
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    punpkhi p0.h, p0.b
; CHECK-NEXT:    ret
  %res = call <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv16i1(<vscale x 16 x i1> %in, i64 15)
  ret <vscale x 1 x i1> %res
}

declare <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv2i1(<vscale x 2 x i1>, i64)
declare <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv4i1(<vscale x 4 x i1>, i64)
declare <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv8i1(<vscale x 8 x i1>, i64)
declare <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv16i1(<vscale x 16 x i1>, i64)
