/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.jetifier.standalone;

import com.android.tools.build.jetifier.core.config.Config;
import com.android.tools.build.jetifier.core.config.ConfigParser;
import com.android.tools.build.jetifier.core.utils.Log;
import com.android.tools.build.jetifier.processor.FileMapping;
import com.android.tools.build.jetifier.processor.Processor;
import com.android.tools.build.jetifier.processor.TimestampsPolicy;
import com.android.tools.build.jetifier.processor.TransformationResult;
import com.android.tools.build.jetifier.standalone.TopOfTreeBuilder;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u001d\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a2\u0006\u0002\u0010\rJ\u0019\u0010\u000e\u001a\u00020\u000f2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/build/jetifier/standalone/Main;", "", "()V", "containsSingleJavaFiles", "", "fileMappings", "", "Lcom/android/tools/build/jetifier/processor/FileMapping;", "parseCmdLine", "Lorg/apache/commons/cli/CommandLine;", "args", "", "", "([Ljava/lang/String;)Lorg/apache/commons/cli/CommandLine;", "run", "", "([Ljava/lang/String;)V", "Companion", "jetifier-standalone"})
public final class Main {
    @NotNull
    public static final String TAG = "Main";
    @NotNull
    public static final String TOOL_NAME = "Jetifier (standalone)";
    @NotNull
    private static final Options OPTIONS;
    @NotNull
    private static final Option OPTION_INPUT;
    @NotNull
    private static final Option OPTION_OUTPUT;
    @NotNull
    private static final Option OPTION_CONFIG;
    @NotNull
    private static final Option OPTION_LOG_LEVEL;
    @NotNull
    private static final Option OPTION_REVERSED;
    @NotNull
    private static final Option OPTION_STRICT;
    @NotNull
    private static final Option OPTION_REBUILD_TOP_OF_TREE;
    @NotNull
    private static final Option OPTION_STRIP_SIGNATURES;
    @NotNull
    public static final String ELIGIBLE_TIMESTAMPS = "keepPrevious (default), epoch or now";
    @NotNull
    private static final Option OPTION_TIMESTAMPS;
    public static final Companion Companion;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void run(@NotNull String[] args) {
        Config config;
        Config config2;
        TimestampsPolicy timestampsPolicy;
        TimestampsPolicy timestampsPolicy2;
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        CommandLine cmd = this.parseCmdLine(args);
        if (cmd == null) {
            System.exit(1);
            return;
        }
        Log.INSTANCE.setLevel(cmd.getOptionValue(OPTION_LOG_LEVEL.getOpt()));
        File input = new File(cmd.getOptionValue(OPTION_INPUT.getOpt()));
        String output = cmd.getOptionValue(OPTION_OUTPUT.getOpt());
        boolean rebuildTopOfTree = cmd.hasOption(OPTION_REBUILD_TOP_OF_TREE.getOpt());
        boolean isReversed = cmd.hasOption(OPTION_REVERSED.getOpt());
        boolean isStrict = cmd.hasOption(OPTION_STRICT.getOpt());
        boolean shouldStripSignatures = cmd.hasOption(OPTION_STRIP_SIGNATURES.getOpt());
        if (cmd.hasOption(OPTION_TIMESTAMPS.getOpt())) {
            String timestampOp = cmd.getOptionValue(OPTION_TIMESTAMPS.getOpt());
            if (Intrinsics.areEqual((Object)timestampOp, (Object)"now")) {
                timestampsPolicy2 = TimestampsPolicy.Companion.getNOW();
            } else if (Intrinsics.areEqual((Object)timestampOp, (Object)"epoch")) {
                timestampsPolicy2 = TimestampsPolicy.Companion.getEPOCH();
            } else {
                if (!Intrinsics.areEqual((Object)timestampOp, (Object)"keepPrevious")) throw (Throwable)new IllegalArgumentException("The provided value '" + timestampOp + "' of " + '\'' + OPTION_TIMESTAMPS.getLongOpt() + "' argument is not recognized. Eligible " + "values are: keepPrevious (default), epoch or now.");
                timestampsPolicy2 = TimestampsPolicy.Companion.getKEEP_PREVIOUS();
            }
        } else {
            timestampsPolicy2 = timestampsPolicy = TimestampsPolicy.Companion.getKEEP_PREVIOUS();
        }
        if (cmd.hasOption(OPTION_CONFIG.getOpt())) {
            Path configPath;
            Path path = configPath = Paths.get(cmd.getOptionValue(OPTION_CONFIG.getOpt()), new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"configPath");
            config2 = ConfigParser.INSTANCE.loadFromFile(path);
        } else {
            config2 = config = ConfigParser.INSTANCE.loadDefaultConfig();
        }
        if (config == null) {
            Log.INSTANCE.e(TAG, "Failed to load the config file", new Object[0]);
            System.exit(1);
            return;
        }
        boolean bl = false;
        Set fileMappings = new LinkedHashSet();
        if (rebuildTopOfTree) {
            File tempFile = FilesKt.createTempFile$default(null, (String)"zip", null, (int)5, null);
            fileMappings.add(new FileMapping(input, tempFile));
        } else {
            fileMappings.add(new FileMapping(input, new File(output)));
        }
        TimestampsPolicy timestampsPolicy3 = timestampsPolicy;
        String string = null;
        boolean bl2 = !isStrict;
        boolean bl3 = false;
        boolean bl4 = shouldStripSignatures;
        Processor processor = Processor.Companion.createProcessor4$default((Processor.Companion)Processor.Companion, (Config)config, (boolean)isReversed, (boolean)rebuildTopOfTree, (boolean)bl2, (boolean)bl3, (boolean)bl4, string, (TimestampsPolicy)timestampsPolicy3, (int)80, null);
        TransformationResult transformationResult = Processor.transform2$default((Processor)processor, (Set)fileMappings, (boolean)false, (boolean)false, (int)6, null);
        boolean containsSingleJavaFiles = this.containsSingleJavaFiles(fileMappings);
        if (!containsSingleJavaFiles && transformationResult.getNumberOfLibsModified() == 0) {
            Log.INSTANCE.w(TAG, "No references were rewritten. You don't need to run Jetifier.", new Object[0]);
        }
        if (!rebuildTopOfTree) return;
        File tempFile = ((FileMapping)CollectionsKt.first((Iterable)fileMappings)).getTo();
        new TopOfTreeBuilder().rebuildFrom(tempFile, new File(output));
        tempFile.delete();
    }

    private final boolean containsSingleJavaFiles(Set<FileMapping> fileMappings) {
        for (FileMapping fileMapping : fileMappings) {
            String string = fileMapping.getFrom().getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileMapping.from.name");
            if (!StringsKt.endsWith$default((String)string, (String)".java", (boolean)false, (int)2, null)) continue;
            return true;
        }
        return false;
    }

    private final CommandLine parseCmdLine(String[] args) {
        try {
            return new DefaultParser().parse(OPTIONS, args);
        }
        catch (ParseException e) {
            String string = e.getMessage();
            String string2 = TAG;
            Log log = Log.INSTANCE;
            boolean bl = false;
            String string3 = string;
            if (string3 == null) {
                string3 = "";
            }
            String string4 = string3;
            log.e(string2, string4, new Object[0]);
            new HelpFormatter().printHelp(TOOL_NAME, OPTIONS);
            return null;
        }
    }

    static {
        Companion = new Companion(null);
        OPTIONS = new Options();
        OPTION_INPUT = com.android.tools.build.jetifier.standalone.Main$Companion.createOption$default(Companion, "i", "input", "Input library path (jar, aar, zip), or source file (java, xml)", false, true, 8, null);
        OPTION_OUTPUT = com.android.tools.build.jetifier.standalone.Main$Companion.createOption$default(Companion, "o", "output", "Output file path", false, true, 8, null);
        OPTION_CONFIG = com.android.tools.build.jetifier.standalone.Main$Companion.createOption$default(Companion, "c", "config", "Input config path (otherwise default is used)", false, false, 8, null);
        OPTION_LOG_LEVEL = com.android.tools.build.jetifier.standalone.Main$Companion.createOption$default(Companion, "l", "log", "Logging level. Values: error, warning (default), info, verbose", false, false, 8, null);
        OPTION_REVERSED = Main.Companion.createOption("r", "reversed", "Run reversed process (de-jetification)", false, false);
        OPTION_STRICT = Main.Companion.createOption("s", "strict", "Don't fallback in case rules are missing and throw errors instead", false, false);
        OPTION_REBUILD_TOP_OF_TREE = Main.Companion.createOption("rebuildTopOfTree", "rebuildTopOfTree", "Rebuild the zip of maven distribution according to the generated pom file.If set, all libraries being rewritten are assumed to be part of Support Library. Not needed for jetification.", false, false);
        OPTION_STRIP_SIGNATURES = Main.Companion.createOption("stripSignatures", "stripSignatures", "Don't throw an error when jetifying a signed library and instead strip the signature files.", false, false);
        OPTION_TIMESTAMPS = Main.Companion.createOption("t", "timestampsPolicy", "Timestamps policy to use for the archived entries as their modified time. Values: keepPrevious (default), epoch or now.", true, false);
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\b\b\u0002\u0010#\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020$H\u0002J\u001b\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00040)H\u0007\u00a2\u0006\u0002\u0010*R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0011\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0011\u0010\u0013\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\fR\u0011\u0010\u0015\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\fR\u0011\u0010\u0017\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\fR\u0011\u0010\u0019\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\fR\u0011\u0010\u001b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\fR\u000e\u0010\u001d\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/android/tools/build/jetifier/standalone/Main$Companion;", "", "()V", "ELIGIBLE_TIMESTAMPS", "", "OPTIONS", "Lorg/apache/commons/cli/Options;", "getOPTIONS", "()Lorg/apache/commons/cli/Options;", "OPTION_CONFIG", "Lorg/apache/commons/cli/Option;", "getOPTION_CONFIG", "()Lorg/apache/commons/cli/Option;", "OPTION_INPUT", "getOPTION_INPUT", "OPTION_LOG_LEVEL", "getOPTION_LOG_LEVEL", "OPTION_OUTPUT", "getOPTION_OUTPUT", "OPTION_REBUILD_TOP_OF_TREE", "getOPTION_REBUILD_TOP_OF_TREE", "OPTION_REVERSED", "getOPTION_REVERSED", "OPTION_STRICT", "getOPTION_STRICT", "OPTION_STRIP_SIGNATURES", "getOPTION_STRIP_SIGNATURES", "OPTION_TIMESTAMPS", "getOPTION_TIMESTAMPS", "TAG", "TOOL_NAME", "createOption", "argName", "argNameLong", "desc", "hasArgs", "", "isRequired", "main", "", "args", "", "([Ljava/lang/String;)V", "jetifier-standalone"})
    public static final class Companion {
        @NotNull
        public final Options getOPTIONS() {
            return OPTIONS;
        }

        @NotNull
        public final Option getOPTION_INPUT() {
            return OPTION_INPUT;
        }

        @NotNull
        public final Option getOPTION_OUTPUT() {
            return OPTION_OUTPUT;
        }

        @NotNull
        public final Option getOPTION_CONFIG() {
            return OPTION_CONFIG;
        }

        @NotNull
        public final Option getOPTION_LOG_LEVEL() {
            return OPTION_LOG_LEVEL;
        }

        @NotNull
        public final Option getOPTION_REVERSED() {
            return OPTION_REVERSED;
        }

        @NotNull
        public final Option getOPTION_STRICT() {
            return OPTION_STRICT;
        }

        @NotNull
        public final Option getOPTION_REBUILD_TOP_OF_TREE() {
            return OPTION_REBUILD_TOP_OF_TREE;
        }

        @NotNull
        public final Option getOPTION_STRIP_SIGNATURES() {
            return OPTION_STRIP_SIGNATURES;
        }

        @NotNull
        public final Option getOPTION_TIMESTAMPS() {
            return OPTION_TIMESTAMPS;
        }

        private final Option createOption(String argName, String argNameLong, String desc, boolean hasArgs, boolean isRequired) {
            Option option = new Option(argName, argNameLong, hasArgs, desc);
            boolean bl = false;
            boolean bl2 = false;
            Option $this$apply = option;
            boolean bl3 = false;
            $this$apply.setRequired(isRequired);
            Companion.getOPTIONS().addOption($this$apply);
            return option;
        }

        static /* synthetic */ Option createOption$default(Companion companion, String string, String string2, String string3, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 8) != 0) {
                bl = true;
            }
            if ((n & 0x10) != 0) {
                bl2 = true;
            }
            return companion.createOption(string, string2, string3, bl, bl2);
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            new Main().run(args);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

