; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -mtriple=x86_64-apple-darwin -passes="print<cost-model>" 2>&1 -disable-output -mattr=+sse2 | FileCheck %s --check-prefixes=SSE2
; RUN: opt < %s -mtriple=x86_64-apple-darwin -passes="print<cost-model>" 2>&1 -disable-output -mattr=+sse4.2 | FileCheck %s --check-prefixes=SSE42
; RUN: opt < %s -mtriple=x86_64-apple-darwin -passes="print<cost-model>" 2>&1 -disable-output -mattr=+avx  | FileCheck %s --check-prefixes=AVX1
; RUN: opt < %s -mtriple=x86_64-apple-darwin -passes="print<cost-model>" 2>&1 -disable-output -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2
; RUN: opt < %s -mtriple=x86_64-apple-darwin -passes="print<cost-model>" 2>&1 -disable-output -mattr=+avx512f | FileCheck %s --check-prefixes=AVX512F
; RUN: opt < %s -mtriple=x86_64-apple-darwin -passes="print<cost-model>" 2>&1 -disable-output -mattr=+avx512f,+avx512dq | FileCheck %s --check-prefixes=AVX512DQ
;
; RUN: opt < %s -mtriple=x86_64-apple-darwin -passes="print<cost-model>" 2>&1 -disable-output -mcpu=slm | FileCheck %s --check-prefixes=SLM
; RUN: opt < %s -mtriple=x86_64-apple-darwin -passes="print<cost-model>" 2>&1 -disable-output -mcpu=goldmont | FileCheck %s --check-prefixes=SSE42
; RUN: opt < %s -mtriple=x86_64-apple-darwin -passes="print<cost-model>" 2>&1 -disable-output -mcpu=btver2 | FileCheck %s --check-prefixes=AVX1

define void @casts() {
; SSE2-LABEL: 'casts'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %f32s1 = call i1 @llvm.fptosi.sat.i1.f32(float undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f32u1 = call i1 @llvm.fptoui.sat.i1.f32(float undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %f32s8 = call i8 @llvm.fptosi.sat.i8.f32(float undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %f32u8 = call i8 @llvm.fptoui.sat.i8.f32(float undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %f32s16 = call i16 @llvm.fptosi.sat.i16.f32(float undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %f32u16 = call i16 @llvm.fptoui.sat.i16.f32(float undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %f32s32 = call i32 @llvm.fptosi.sat.i32.f32(float undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %f32u32 = call i32 @llvm.fptoui.sat.i32.f32(float undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %f32s64 = call i64 @llvm.fptosi.sat.i64.f32(float undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %f32u64 = call i64 @llvm.fptoui.sat.i64.f32(float undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %f64s1 = call i1 @llvm.fptosi.sat.i1.f64(double undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f64u1 = call i1 @llvm.fptoui.sat.i1.f64(double undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %f64s8 = call i8 @llvm.fptosi.sat.i8.f64(double undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %f64u8 = call i8 @llvm.fptoui.sat.i8.f64(double undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %f64s16 = call i16 @llvm.fptosi.sat.i16.f64(double undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %f64u16 = call i16 @llvm.fptoui.sat.i16.f64(double undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %f64s32 = call i32 @llvm.fptosi.sat.i32.f64(double undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %f64u32 = call i32 @llvm.fptoui.sat.i32.f64(double undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %f64s64 = call i64 @llvm.fptosi.sat.i64.f64(double undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %f64u64 = call i64 @llvm.fptoui.sat.i64.f64(double undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %v2f32s1 = call <2 x i1> @llvm.fptosi.sat.v2i1.v2f32(<2 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %v2f32u1 = call <2 x i1> @llvm.fptoui.sat.v2i1.v2f32(<2 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %v2f32s8 = call <2 x i8> @llvm.fptosi.sat.v2i8.v2f32(<2 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %v2f32u8 = call <2 x i8> @llvm.fptoui.sat.v2i8.v2f32(<2 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %v2f32s16 = call <2 x i16> @llvm.fptosi.sat.v2i16.v2f32(<2 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %v2f32u16 = call <2 x i16> @llvm.fptoui.sat.v2i16.v2f32(<2 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v2f32s32 = call <2 x i32> @llvm.fptosi.sat.v2i32.v2f32(<2 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v2f32u32 = call <2 x i32> @llvm.fptoui.sat.v2i32.v2f32(<2 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %v2f32s64 = call <2 x i64> @llvm.fptosi.sat.v2i64.v2f32(<2 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %v2f32u64 = call <2 x i64> @llvm.fptoui.sat.v2i64.v2f32(<2 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %v2f64s1 = call <2 x i1> @llvm.fptosi.sat.v2i1.v2f64(<2 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %v2f64u1 = call <2 x i1> @llvm.fptoui.sat.v2i1.v2f64(<2 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %v2f64s8 = call <2 x i8> @llvm.fptosi.sat.v2i8.v2f64(<2 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %v2f64u8 = call <2 x i8> @llvm.fptoui.sat.v2i8.v2f64(<2 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %v2f64s16 = call <2 x i16> @llvm.fptosi.sat.v2i16.v2f64(<2 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %v2f64u16 = call <2 x i16> @llvm.fptoui.sat.v2i16.v2f64(<2 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v2f64s32 = call <2 x i32> @llvm.fptosi.sat.v2i32.v2f64(<2 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v2f64u32 = call <2 x i32> @llvm.fptoui.sat.v2i32.v2f64(<2 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %v2f64s64 = call <2 x i64> @llvm.fptosi.sat.v2i64.v2f64(<2 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 44 for instruction: %v2f64u64 = call <2 x i64> @llvm.fptoui.sat.v2i64.v2f64(<2 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v4f32s1 = call <4 x i1> @llvm.fptosi.sat.v4i1.v4f32(<4 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v4f32u1 = call <4 x i1> @llvm.fptoui.sat.v4i1.v4f32(<4 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %v4f32s8 = call <4 x i8> @llvm.fptosi.sat.v4i8.v4f32(<4 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %v4f32u8 = call <4 x i8> @llvm.fptoui.sat.v4i8.v4f32(<4 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %v4f32s16 = call <4 x i16> @llvm.fptosi.sat.v4i16.v4f32(<4 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %v4f32u16 = call <4 x i16> @llvm.fptoui.sat.v4i16.v4f32(<4 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v4f32s32 = call <4 x i32> @llvm.fptosi.sat.v4i32.v4f32(<4 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v4f32u32 = call <4 x i32> @llvm.fptoui.sat.v4i32.v4f32(<4 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 43 for instruction: %v4f32s64 = call <4 x i64> @llvm.fptosi.sat.v4i64.v4f32(<4 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 37 for instruction: %v4f32u64 = call <4 x i64> @llvm.fptoui.sat.v4i64.v4f32(<4 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 30 for instruction: %v4f64s1 = call <4 x i1> @llvm.fptosi.sat.v4i1.v4f64(<4 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %v4f64u1 = call <4 x i1> @llvm.fptoui.sat.v4i1.v4f64(<4 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %v4f64s8 = call <4 x i8> @llvm.fptosi.sat.v4i8.v4f64(<4 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %v4f64u8 = call <4 x i8> @llvm.fptoui.sat.v4i8.v4f64(<4 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %v4f64s16 = call <4 x i16> @llvm.fptosi.sat.v4i16.v4f64(<4 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %v4f64u16 = call <4 x i16> @llvm.fptoui.sat.v4i16.v4f64(<4 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 30 for instruction: %v4f64s32 = call <4 x i32> @llvm.fptosi.sat.v4i32.v4f64(<4 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %v4f64u32 = call <4 x i32> @llvm.fptoui.sat.v4i32.v4f64(<4 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 52 for instruction: %v4f64s64 = call <4 x i64> @llvm.fptosi.sat.v4i64.v4f64(<4 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 88 for instruction: %v4f64u64 = call <4 x i64> @llvm.fptoui.sat.v4i64.v4f64(<4 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %v8f32s1 = call <8 x i1> @llvm.fptosi.sat.v8i1.v8f32(<8 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %v8f32u1 = call <8 x i1> @llvm.fptoui.sat.v8i1.v8f32(<8 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %v8f32s8 = call <8 x i8> @llvm.fptosi.sat.v8i8.v8f32(<8 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %v8f32u8 = call <8 x i8> @llvm.fptoui.sat.v8i8.v8f32(<8 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %v8f32s16 = call <8 x i16> @llvm.fptosi.sat.v8i16.v8f32(<8 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %v8f32u16 = call <8 x i16> @llvm.fptoui.sat.v8i16.v8f32(<8 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %v8f32s32 = call <8 x i32> @llvm.fptosi.sat.v8i32.v8f32(<8 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %v8f32u32 = call <8 x i32> @llvm.fptoui.sat.v8i32.v8f32(<8 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 86 for instruction: %v8f32s64 = call <8 x i64> @llvm.fptosi.sat.v8i64.v8f32(<8 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 74 for instruction: %v8f32u64 = call <8 x i64> @llvm.fptoui.sat.v8i64.v8f32(<8 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 62 for instruction: %v8f64s1 = call <8 x i1> @llvm.fptosi.sat.v8i1.v8f64(<8 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 52 for instruction: %v8f64u1 = call <8 x i1> @llvm.fptoui.sat.v8i1.v8f64(<8 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 66 for instruction: %v8f64s8 = call <8 x i8> @llvm.fptosi.sat.v8i8.v8f64(<8 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %v8f64u8 = call <8 x i8> @llvm.fptoui.sat.v8i8.v8f64(<8 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 62 for instruction: %v8f64s16 = call <8 x i16> @llvm.fptosi.sat.v8i16.v8f64(<8 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 52 for instruction: %v8f64u16 = call <8 x i16> @llvm.fptoui.sat.v8i16.v8f64(<8 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 60 for instruction: %v8f64s32 = call <8 x i32> @llvm.fptosi.sat.v8i32.v8f64(<8 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %v8f64u32 = call <8 x i32> @llvm.fptoui.sat.v8i32.v8f64(<8 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 104 for instruction: %v8f64s64 = call <8 x i64> @llvm.fptosi.sat.v8i64.v8f64(<8 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 176 for instruction: %v8f64u64 = call <8 x i64> @llvm.fptoui.sat.v8i64.v8f64(<8 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 66 for instruction: %v16f32s1 = call <16 x i1> @llvm.fptosi.sat.v16i1.v16f32(<16 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %v16f32u1 = call <16 x i1> @llvm.fptoui.sat.v16i1.v16f32(<16 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 66 for instruction: %v16f32s8 = call <16 x i8> @llvm.fptosi.sat.v16i8.v16f32(<16 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %v16f32u8 = call <16 x i8> @llvm.fptoui.sat.v16i8.v16f32(<16 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %v16f32s16 = call <16 x i16> @llvm.fptosi.sat.v16i16.v16f32(<16 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 52 for instruction: %v16f32u16 = call <16 x i16> @llvm.fptoui.sat.v16i16.v16f32(<16 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %v16f32s32 = call <16 x i32> @llvm.fptosi.sat.v16i32.v16f32(<16 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %v16f32u32 = call <16 x i32> @llvm.fptoui.sat.v16i32.v16f32(<16 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 172 for instruction: %v16f32s64 = call <16 x i64> @llvm.fptosi.sat.v16i64.v16f32(<16 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 148 for instruction: %v16f32u64 = call <16 x i64> @llvm.fptoui.sat.v16i64.v16f32(<16 x float> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 130 for instruction: %v16f64s1 = call <16 x i1> @llvm.fptosi.sat.v16i1.v16f64(<16 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %v16f64u1 = call <16 x i1> @llvm.fptoui.sat.v16i1.v16f64(<16 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 130 for instruction: %v16f64s8 = call <16 x i8> @llvm.fptosi.sat.v16i8.v16f64(<16 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %v16f64u8 = call <16 x i8> @llvm.fptoui.sat.v16i8.v16f64(<16 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 124 for instruction: %v16f64s16 = call <16 x i16> @llvm.fptosi.sat.v16i16.v16f64(<16 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 104 for instruction: %v16f64u16 = call <16 x i16> @llvm.fptoui.sat.v16i16.v16f64(<16 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 120 for instruction: %v16f64s32 = call <16 x i32> @llvm.fptosi.sat.v16i32.v16f64(<16 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %v16f64u32 = call <16 x i32> @llvm.fptoui.sat.v16i32.v16f64(<16 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 208 for instruction: %v16f64s64 = call <16 x i64> @llvm.fptosi.sat.v16i64.v16f64(<16 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 352 for instruction: %v16f64u64 = call <16 x i64> @llvm.fptoui.sat.v16i64.v16f64(<16 x double> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SSE42-LABEL: 'casts'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %f32s1 = call i1 @llvm.fptosi.sat.i1.f32(float undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f32u1 = call i1 @llvm.fptoui.sat.i1.f32(float undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %f32s8 = call i8 @llvm.fptosi.sat.i8.f32(float undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f32u8 = call i8 @llvm.fptoui.sat.i8.f32(float undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %f32s16 = call i16 @llvm.fptosi.sat.i16.f32(float undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f32u16 = call i16 @llvm.fptoui.sat.i16.f32(float undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %f32s32 = call i32 @llvm.fptosi.sat.i32.f32(float undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f32u32 = call i32 @llvm.fptoui.sat.i32.f32(float undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %f32s64 = call i64 @llvm.fptosi.sat.i64.f32(float undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %f32u64 = call i64 @llvm.fptoui.sat.i64.f32(float undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %f64s1 = call i1 @llvm.fptosi.sat.i1.f64(double undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f64u1 = call i1 @llvm.fptoui.sat.i1.f64(double undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %f64s8 = call i8 @llvm.fptosi.sat.i8.f64(double undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f64u8 = call i8 @llvm.fptoui.sat.i8.f64(double undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %f64s16 = call i16 @llvm.fptosi.sat.i16.f64(double undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f64u16 = call i16 @llvm.fptoui.sat.i16.f64(double undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %f64s32 = call i32 @llvm.fptosi.sat.i32.f64(double undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f64u32 = call i32 @llvm.fptoui.sat.i32.f64(double undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %f64s64 = call i64 @llvm.fptosi.sat.i64.f64(double undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %f64u64 = call i64 @llvm.fptoui.sat.i64.f64(double undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %v2f32s1 = call <2 x i1> @llvm.fptosi.sat.v2i1.v2f32(<2 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %v2f32u1 = call <2 x i1> @llvm.fptoui.sat.v2i1.v2f32(<2 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %v2f32s8 = call <2 x i8> @llvm.fptosi.sat.v2i8.v2f32(<2 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v2f32u8 = call <2 x i8> @llvm.fptoui.sat.v2i8.v2f32(<2 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v2f32s16 = call <2 x i16> @llvm.fptosi.sat.v2i16.v2f32(<2 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v2f32u16 = call <2 x i16> @llvm.fptoui.sat.v2i16.v2f32(<2 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v2f32s32 = call <2 x i32> @llvm.fptosi.sat.v2i32.v2f32(<2 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v2f32u32 = call <2 x i32> @llvm.fptoui.sat.v2i32.v2f32(<2 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %v2f32s64 = call <2 x i64> @llvm.fptosi.sat.v2i64.v2f32(<2 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %v2f32u64 = call <2 x i64> @llvm.fptoui.sat.v2i64.v2f32(<2 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %v2f64s1 = call <2 x i1> @llvm.fptosi.sat.v2i1.v2f64(<2 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %v2f64u1 = call <2 x i1> @llvm.fptoui.sat.v2i1.v2f64(<2 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %v2f64s8 = call <2 x i8> @llvm.fptosi.sat.v2i8.v2f64(<2 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v2f64u8 = call <2 x i8> @llvm.fptoui.sat.v2i8.v2f64(<2 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v2f64s16 = call <2 x i16> @llvm.fptosi.sat.v2i16.v2f64(<2 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v2f64u16 = call <2 x i16> @llvm.fptoui.sat.v2i16.v2f64(<2 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v2f64s32 = call <2 x i32> @llvm.fptosi.sat.v2i32.v2f64(<2 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v2f64u32 = call <2 x i32> @llvm.fptoui.sat.v2i32.v2f64(<2 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %v2f64s64 = call <2 x i64> @llvm.fptosi.sat.v2i64.v2f64(<2 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %v2f64u64 = call <2 x i64> @llvm.fptoui.sat.v2i64.v2f64(<2 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v4f32s1 = call <4 x i1> @llvm.fptosi.sat.v4i1.v4f32(<4 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v4f32u1 = call <4 x i1> @llvm.fptoui.sat.v4i1.v4f32(<4 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %v4f32s8 = call <4 x i8> @llvm.fptosi.sat.v4i8.v4f32(<4 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v4f32u8 = call <4 x i8> @llvm.fptoui.sat.v4i8.v4f32(<4 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v4f32s16 = call <4 x i16> @llvm.fptosi.sat.v4i16.v4f32(<4 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v4f32u16 = call <4 x i16> @llvm.fptoui.sat.v4i16.v4f32(<4 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v4f32s32 = call <4 x i32> @llvm.fptosi.sat.v4i32.v4f32(<4 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v4f32u32 = call <4 x i32> @llvm.fptoui.sat.v4i32.v4f32(<4 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %v4f32s64 = call <4 x i64> @llvm.fptosi.sat.v4i64.v4f32(<4 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %v4f32u64 = call <4 x i64> @llvm.fptoui.sat.v4i64.v4f32(<4 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %v4f64s1 = call <4 x i1> @llvm.fptosi.sat.v4i1.v4f64(<4 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %v4f64u1 = call <4 x i1> @llvm.fptoui.sat.v4i1.v4f64(<4 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %v4f64s8 = call <4 x i8> @llvm.fptosi.sat.v4i8.v4f64(<4 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %v4f64u8 = call <4 x i8> @llvm.fptoui.sat.v4i8.v4f64(<4 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %v4f64s16 = call <4 x i16> @llvm.fptosi.sat.v4i16.v4f64(<4 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %v4f64u16 = call <4 x i16> @llvm.fptoui.sat.v4i16.v4f64(<4 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %v4f64s32 = call <4 x i32> @llvm.fptosi.sat.v4i32.v4f64(<4 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %v4f64u32 = call <4 x i32> @llvm.fptoui.sat.v4i32.v4f64(<4 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %v4f64s64 = call <4 x i64> @llvm.fptosi.sat.v4i64.v4f64(<4 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %v4f64u64 = call <4 x i64> @llvm.fptoui.sat.v4i64.v4f64(<4 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %v8f32s1 = call <8 x i1> @llvm.fptosi.sat.v8i1.v8f32(<8 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %v8f32u1 = call <8 x i1> @llvm.fptoui.sat.v8i1.v8f32(<8 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %v8f32s8 = call <8 x i8> @llvm.fptosi.sat.v8i8.v8f32(<8 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %v8f32u8 = call <8 x i8> @llvm.fptoui.sat.v8i8.v8f32(<8 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %v8f32s16 = call <8 x i16> @llvm.fptosi.sat.v8i16.v8f32(<8 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %v8f32u16 = call <8 x i16> @llvm.fptoui.sat.v8i16.v8f32(<8 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %v8f32s32 = call <8 x i32> @llvm.fptosi.sat.v8i32.v8f32(<8 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %v8f32u32 = call <8 x i32> @llvm.fptoui.sat.v8i32.v8f32(<8 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 52 for instruction: %v8f32s64 = call <8 x i64> @llvm.fptosi.sat.v8i64.v8f32(<8 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 66 for instruction: %v8f32u64 = call <8 x i64> @llvm.fptoui.sat.v8i64.v8f32(<8 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 42 for instruction: %v8f64s1 = call <8 x i1> @llvm.fptosi.sat.v8i1.v8f64(<8 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %v8f64u1 = call <8 x i1> @llvm.fptoui.sat.v8i1.v8f64(<8 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 46 for instruction: %v8f64s8 = call <8 x i8> @llvm.fptosi.sat.v8i8.v8f64(<8 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %v8f64u8 = call <8 x i8> @llvm.fptoui.sat.v8i8.v8f64(<8 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 42 for instruction: %v8f64s16 = call <8 x i16> @llvm.fptosi.sat.v8i16.v8f64(<8 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %v8f64u16 = call <8 x i16> @llvm.fptoui.sat.v8i16.v8f64(<8 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 44 for instruction: %v8f64s32 = call <8 x i32> @llvm.fptosi.sat.v8i32.v8f64(<8 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %v8f64u32 = call <8 x i32> @llvm.fptoui.sat.v8i32.v8f64(<8 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 68 for instruction: %v8f64s64 = call <8 x i64> @llvm.fptosi.sat.v8i64.v8f64(<8 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 80 for instruction: %v8f64u64 = call <8 x i64> @llvm.fptoui.sat.v8i64.v8f64(<8 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 46 for instruction: %v16f32s1 = call <16 x i1> @llvm.fptosi.sat.v16i1.v16f32(<16 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %v16f32u1 = call <16 x i1> @llvm.fptoui.sat.v16i1.v16f32(<16 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 46 for instruction: %v16f32s8 = call <16 x i8> @llvm.fptosi.sat.v16i8.v16f32(<16 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %v16f32u8 = call <16 x i8> @llvm.fptoui.sat.v16i8.v16f32(<16 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 44 for instruction: %v16f32s16 = call <16 x i16> @llvm.fptosi.sat.v16i16.v16f32(<16 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %v16f32u16 = call <16 x i16> @llvm.fptoui.sat.v16i16.v16f32(<16 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %v16f32s32 = call <16 x i32> @llvm.fptosi.sat.v16i32.v16f32(<16 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %v16f32u32 = call <16 x i32> @llvm.fptoui.sat.v16i32.v16f32(<16 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 104 for instruction: %v16f32s64 = call <16 x i64> @llvm.fptosi.sat.v16i64.v16f32(<16 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 132 for instruction: %v16f32u64 = call <16 x i64> @llvm.fptoui.sat.v16i64.v16f32(<16 x float> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 90 for instruction: %v16f64s1 = call <16 x i1> @llvm.fptosi.sat.v16i1.v16f64(<16 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 80 for instruction: %v16f64u1 = call <16 x i1> @llvm.fptoui.sat.v16i1.v16f64(<16 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 90 for instruction: %v16f64s8 = call <16 x i8> @llvm.fptosi.sat.v16i8.v16f64(<16 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 80 for instruction: %v16f64u8 = call <16 x i8> @llvm.fptoui.sat.v16i8.v16f64(<16 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 84 for instruction: %v16f64s16 = call <16 x i16> @llvm.fptosi.sat.v16i16.v16f64(<16 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 72 for instruction: %v16f64u16 = call <16 x i16> @llvm.fptoui.sat.v16i16.v16f64(<16 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 88 for instruction: %v16f64s32 = call <16 x i32> @llvm.fptosi.sat.v16i32.v16f64(<16 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %v16f64u32 = call <16 x i32> @llvm.fptoui.sat.v16i32.v16f64(<16 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 136 for instruction: %v16f64s64 = call <16 x i64> @llvm.fptosi.sat.v16i64.v16f64(<16 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 160 for instruction: %v16f64u64 = call <16 x i64> @llvm.fptoui.sat.v16i64.v16f64(<16 x double> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX1-LABEL: 'casts'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f32s1 = call i1 @llvm.fptosi.sat.i1.f32(float undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f32u1 = call i1 @llvm.fptoui.sat.i1.f32(float undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f32s8 = call i8 @llvm.fptosi.sat.i8.f32(float undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f32u8 = call i8 @llvm.fptoui.sat.i8.f32(float undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f32s16 = call i16 @llvm.fptosi.sat.i16.f32(float undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f32u16 = call i16 @llvm.fptoui.sat.i16.f32(float undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f32s32 = call i32 @llvm.fptosi.sat.i32.f32(float undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f32u32 = call i32 @llvm.fptoui.sat.i32.f32(float undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f32s64 = call i64 @llvm.fptosi.sat.i64.f32(float undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %f32u64 = call i64 @llvm.fptoui.sat.i64.f32(float undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f64s1 = call i1 @llvm.fptosi.sat.i1.f64(double undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f64u1 = call i1 @llvm.fptoui.sat.i1.f64(double undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f64s8 = call i8 @llvm.fptosi.sat.i8.f64(double undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f64u8 = call i8 @llvm.fptoui.sat.i8.f64(double undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f64s16 = call i16 @llvm.fptosi.sat.i16.f64(double undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f64u16 = call i16 @llvm.fptoui.sat.i16.f64(double undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f64s32 = call i32 @llvm.fptosi.sat.i32.f64(double undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f64u32 = call i32 @llvm.fptoui.sat.i32.f64(double undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f64s64 = call i64 @llvm.fptosi.sat.i64.f64(double undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %f64u64 = call i64 @llvm.fptoui.sat.i64.f64(double undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %v2f32s1 = call <2 x i1> @llvm.fptosi.sat.v2i1.v2f32(<2 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v2f32u1 = call <2 x i1> @llvm.fptoui.sat.v2i1.v2f32(<2 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v2f32s8 = call <2 x i8> @llvm.fptosi.sat.v2i8.v2f32(<2 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v2f32u8 = call <2 x i8> @llvm.fptoui.sat.v2i8.v2f32(<2 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v2f32s16 = call <2 x i16> @llvm.fptosi.sat.v2i16.v2f32(<2 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v2f32u16 = call <2 x i16> @llvm.fptoui.sat.v2i16.v2f32(<2 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v2f32s32 = call <2 x i32> @llvm.fptosi.sat.v2i32.v2f32(<2 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v2f32u32 = call <2 x i32> @llvm.fptoui.sat.v2i32.v2f32(<2 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %v2f32s64 = call <2 x i64> @llvm.fptosi.sat.v2i64.v2f32(<2 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %v2f32u64 = call <2 x i64> @llvm.fptoui.sat.v2i64.v2f32(<2 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %v2f64s1 = call <2 x i1> @llvm.fptosi.sat.v2i1.v2f64(<2 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v2f64u1 = call <2 x i1> @llvm.fptoui.sat.v2i1.v2f64(<2 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v2f64s8 = call <2 x i8> @llvm.fptosi.sat.v2i8.v2f64(<2 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v2f64u8 = call <2 x i8> @llvm.fptoui.sat.v2i8.v2f64(<2 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v2f64s16 = call <2 x i16> @llvm.fptosi.sat.v2i16.v2f64(<2 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v2f64u16 = call <2 x i16> @llvm.fptoui.sat.v2i16.v2f64(<2 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v2f64s32 = call <2 x i32> @llvm.fptosi.sat.v2i32.v2f64(<2 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v2f64u32 = call <2 x i32> @llvm.fptoui.sat.v2i32.v2f64(<2 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %v2f64s64 = call <2 x i64> @llvm.fptosi.sat.v2i64.v2f64(<2 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %v2f64u64 = call <2 x i64> @llvm.fptoui.sat.v2i64.v2f64(<2 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v4f32s1 = call <4 x i1> @llvm.fptosi.sat.v4i1.v4f32(<4 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v4f32u1 = call <4 x i1> @llvm.fptoui.sat.v4i1.v4f32(<4 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v4f32s8 = call <4 x i8> @llvm.fptosi.sat.v4i8.v4f32(<4 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v4f32u8 = call <4 x i8> @llvm.fptoui.sat.v4i8.v4f32(<4 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v4f32s16 = call <4 x i16> @llvm.fptosi.sat.v4i16.v4f32(<4 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v4f32u16 = call <4 x i16> @llvm.fptoui.sat.v4i16.v4f32(<4 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v4f32s32 = call <4 x i32> @llvm.fptosi.sat.v4i32.v4f32(<4 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v4f32u32 = call <4 x i32> @llvm.fptoui.sat.v4i32.v4f32(<4 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %v4f32s64 = call <4 x i64> @llvm.fptosi.sat.v4i64.v4f32(<4 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %v4f32u64 = call <4 x i64> @llvm.fptoui.sat.v4i64.v4f32(<4 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v4f64s1 = call <4 x i1> @llvm.fptosi.sat.v4i1.v4f64(<4 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v4f64u1 = call <4 x i1> @llvm.fptoui.sat.v4i1.v4f64(<4 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v4f64s8 = call <4 x i8> @llvm.fptosi.sat.v4i8.v4f64(<4 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v4f64u8 = call <4 x i8> @llvm.fptoui.sat.v4i8.v4f64(<4 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v4f64s16 = call <4 x i16> @llvm.fptosi.sat.v4i16.v4f64(<4 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v4f64u16 = call <4 x i16> @llvm.fptoui.sat.v4i16.v4f64(<4 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v4f64s32 = call <4 x i32> @llvm.fptosi.sat.v4i32.v4f64(<4 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v4f64u32 = call <4 x i32> @llvm.fptoui.sat.v4i32.v4f64(<4 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 29 for instruction: %v4f64s64 = call <4 x i64> @llvm.fptosi.sat.v4i64.v4f64(<4 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %v4f64u64 = call <4 x i64> @llvm.fptoui.sat.v4i64.v4f64(<4 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v8f32s1 = call <8 x i1> @llvm.fptosi.sat.v8i1.v8f32(<8 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v8f32u1 = call <8 x i1> @llvm.fptoui.sat.v8i1.v8f32(<8 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v8f32s8 = call <8 x i8> @llvm.fptosi.sat.v8i8.v8f32(<8 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v8f32u8 = call <8 x i8> @llvm.fptoui.sat.v8i8.v8f32(<8 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v8f32s16 = call <8 x i16> @llvm.fptosi.sat.v8i16.v8f32(<8 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v8f32u16 = call <8 x i16> @llvm.fptoui.sat.v8i16.v8f32(<8 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %v8f32s32 = call <8 x i32> @llvm.fptosi.sat.v8i32.v8f32(<8 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %v8f32u32 = call <8 x i32> @llvm.fptoui.sat.v8i32.v8f32(<8 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %v8f32s64 = call <8 x i64> @llvm.fptosi.sat.v8i64.v8f32(<8 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 63 for instruction: %v8f32u64 = call <8 x i64> @llvm.fptoui.sat.v8i64.v8f32(<8 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 30 for instruction: %v8f64s1 = call <8 x i1> @llvm.fptosi.sat.v8i1.v8f64(<8 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %v8f64u1 = call <8 x i1> @llvm.fptoui.sat.v8i1.v8f64(<8 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 30 for instruction: %v8f64s8 = call <8 x i8> @llvm.fptosi.sat.v8i8.v8f64(<8 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %v8f64u8 = call <8 x i8> @llvm.fptoui.sat.v8i8.v8f64(<8 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 30 for instruction: %v8f64s16 = call <8 x i16> @llvm.fptosi.sat.v8i16.v8f64(<8 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %v8f64u16 = call <8 x i16> @llvm.fptoui.sat.v8i16.v8f64(<8 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %v8f64s32 = call <8 x i32> @llvm.fptosi.sat.v8i32.v8f64(<8 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %v8f64u32 = call <8 x i32> @llvm.fptoui.sat.v8i32.v8f64(<8 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 58 for instruction: %v8f64s64 = call <8 x i64> @llvm.fptosi.sat.v8i64.v8f64(<8 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 72 for instruction: %v8f64u64 = call <8 x i64> @llvm.fptoui.sat.v8i64.v8f64(<8 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 30 for instruction: %v16f32s1 = call <16 x i1> @llvm.fptosi.sat.v16i1.v16f32(<16 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %v16f32u1 = call <16 x i1> @llvm.fptoui.sat.v16i1.v16f32(<16 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 30 for instruction: %v16f32s8 = call <16 x i8> @llvm.fptosi.sat.v16i8.v16f32(<16 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %v16f32u8 = call <16 x i8> @llvm.fptoui.sat.v16i8.v16f32(<16 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 31 for instruction: %v16f32s16 = call <16 x i16> @llvm.fptosi.sat.v16i16.v16f32(<16 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %v16f32u16 = call <16 x i16> @llvm.fptoui.sat.v16i16.v16f32(<16 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %v16f32s32 = call <16 x i32> @llvm.fptosi.sat.v16i32.v16f32(<16 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %v16f32u32 = call <16 x i32> @llvm.fptoui.sat.v16i32.v16f32(<16 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 94 for instruction: %v16f32s64 = call <16 x i64> @llvm.fptosi.sat.v16i64.v16f32(<16 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 126 for instruction: %v16f32u64 = call <16 x i64> @llvm.fptoui.sat.v16i64.v16f32(<16 x float> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 58 for instruction: %v16f64s1 = call <16 x i1> @llvm.fptosi.sat.v16i1.v16f64(<16 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %v16f64u1 = call <16 x i1> @llvm.fptoui.sat.v16i1.v16f64(<16 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 58 for instruction: %v16f64s8 = call <16 x i8> @llvm.fptosi.sat.v16i8.v16f64(<16 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %v16f64u8 = call <16 x i8> @llvm.fptoui.sat.v16i8.v16f64(<16 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %v16f64s16 = call <16 x i16> @llvm.fptosi.sat.v16i16.v16f64(<16 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %v16f64u16 = call <16 x i16> @llvm.fptoui.sat.v16i16.v16f64(<16 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %v16f64s32 = call <16 x i32> @llvm.fptosi.sat.v16i32.v16f64(<16 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 68 for instruction: %v16f64u32 = call <16 x i32> @llvm.fptoui.sat.v16i32.v16f64(<16 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 116 for instruction: %v16f64s64 = call <16 x i64> @llvm.fptosi.sat.v16i64.v16f64(<16 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 144 for instruction: %v16f64u64 = call <16 x i64> @llvm.fptoui.sat.v16i64.v16f64(<16 x double> undef)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX2-LABEL: 'casts'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f32s1 = call i1 @llvm.fptosi.sat.i1.f32(float undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f32u1 = call i1 @llvm.fptoui.sat.i1.f32(float undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f32s8 = call i8 @llvm.fptosi.sat.i8.f32(float undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f32u8 = call i8 @llvm.fptoui.sat.i8.f32(float undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f32s16 = call i16 @llvm.fptosi.sat.i16.f32(float undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f32u16 = call i16 @llvm.fptoui.sat.i16.f32(float undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f32s32 = call i32 @llvm.fptosi.sat.i32.f32(float undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f32u32 = call i32 @llvm.fptoui.sat.i32.f32(float undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f32s64 = call i64 @llvm.fptosi.sat.i64.f32(float undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f32u64 = call i64 @llvm.fptoui.sat.i64.f32(float undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f64s1 = call i1 @llvm.fptosi.sat.i1.f64(double undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f64u1 = call i1 @llvm.fptoui.sat.i1.f64(double undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f64s8 = call i8 @llvm.fptosi.sat.i8.f64(double undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f64u8 = call i8 @llvm.fptoui.sat.i8.f64(double undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f64s16 = call i16 @llvm.fptosi.sat.i16.f64(double undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f64u16 = call i16 @llvm.fptoui.sat.i16.f64(double undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f64s32 = call i32 @llvm.fptosi.sat.i32.f64(double undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f64u32 = call i32 @llvm.fptoui.sat.i32.f64(double undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f64s64 = call i64 @llvm.fptosi.sat.i64.f64(double undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f64u64 = call i64 @llvm.fptoui.sat.i64.f64(double undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %v2f32s1 = call <2 x i1> @llvm.fptosi.sat.v2i1.v2f32(<2 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v2f32u1 = call <2 x i1> @llvm.fptoui.sat.v2i1.v2f32(<2 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v2f32s8 = call <2 x i8> @llvm.fptosi.sat.v2i8.v2f32(<2 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v2f32u8 = call <2 x i8> @llvm.fptoui.sat.v2i8.v2f32(<2 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v2f32s16 = call <2 x i16> @llvm.fptosi.sat.v2i16.v2f32(<2 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v2f32u16 = call <2 x i16> @llvm.fptoui.sat.v2i16.v2f32(<2 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v2f32s32 = call <2 x i32> @llvm.fptosi.sat.v2i32.v2f32(<2 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v2f32u32 = call <2 x i32> @llvm.fptoui.sat.v2i32.v2f32(<2 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %v2f32s64 = call <2 x i64> @llvm.fptosi.sat.v2i64.v2f32(<2 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v2f32u64 = call <2 x i64> @llvm.fptoui.sat.v2i64.v2f32(<2 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %v2f64s1 = call <2 x i1> @llvm.fptosi.sat.v2i1.v2f64(<2 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v2f64u1 = call <2 x i1> @llvm.fptoui.sat.v2i1.v2f64(<2 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v2f64s8 = call <2 x i8> @llvm.fptosi.sat.v2i8.v2f64(<2 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v2f64u8 = call <2 x i8> @llvm.fptoui.sat.v2i8.v2f64(<2 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v2f64s16 = call <2 x i16> @llvm.fptosi.sat.v2i16.v2f64(<2 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v2f64u16 = call <2 x i16> @llvm.fptoui.sat.v2i16.v2f64(<2 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v2f64s32 = call <2 x i32> @llvm.fptosi.sat.v2i32.v2f64(<2 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v2f64u32 = call <2 x i32> @llvm.fptoui.sat.v2i32.v2f64(<2 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %v2f64s64 = call <2 x i64> @llvm.fptosi.sat.v2i64.v2f64(<2 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v2f64u64 = call <2 x i64> @llvm.fptoui.sat.v2i64.v2f64(<2 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v4f32s1 = call <4 x i1> @llvm.fptosi.sat.v4i1.v4f32(<4 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v4f32u1 = call <4 x i1> @llvm.fptoui.sat.v4i1.v4f32(<4 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v4f32s8 = call <4 x i8> @llvm.fptosi.sat.v4i8.v4f32(<4 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v4f32u8 = call <4 x i8> @llvm.fptoui.sat.v4i8.v4f32(<4 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v4f32s16 = call <4 x i16> @llvm.fptosi.sat.v4i16.v4f32(<4 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v4f32u16 = call <4 x i16> @llvm.fptoui.sat.v4i16.v4f32(<4 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v4f32s32 = call <4 x i32> @llvm.fptosi.sat.v4i32.v4f32(<4 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v4f32u32 = call <4 x i32> @llvm.fptoui.sat.v4i32.v4f32(<4 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %v4f32s64 = call <4 x i64> @llvm.fptosi.sat.v4i64.v4f32(<4 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %v4f32u64 = call <4 x i64> @llvm.fptoui.sat.v4i64.v4f32(<4 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v4f64s1 = call <4 x i1> @llvm.fptosi.sat.v4i1.v4f64(<4 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v4f64u1 = call <4 x i1> @llvm.fptoui.sat.v4i1.v4f64(<4 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v4f64s8 = call <4 x i8> @llvm.fptosi.sat.v4i8.v4f64(<4 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v4f64u8 = call <4 x i8> @llvm.fptoui.sat.v4i8.v4f64(<4 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v4f64s16 = call <4 x i16> @llvm.fptosi.sat.v4i16.v4f64(<4 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v4f64u16 = call <4 x i16> @llvm.fptoui.sat.v4i16.v4f64(<4 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v4f64s32 = call <4 x i32> @llvm.fptosi.sat.v4i32.v4f64(<4 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v4f64u32 = call <4 x i32> @llvm.fptoui.sat.v4i32.v4f64(<4 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %v4f64s64 = call <4 x i64> @llvm.fptosi.sat.v4i64.v4f64(<4 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %v4f64u64 = call <4 x i64> @llvm.fptoui.sat.v4i64.v4f64(<4 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v8f32s1 = call <8 x i1> @llvm.fptosi.sat.v8i1.v8f32(<8 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v8f32u1 = call <8 x i1> @llvm.fptoui.sat.v8i1.v8f32(<8 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v8f32s8 = call <8 x i8> @llvm.fptosi.sat.v8i8.v8f32(<8 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v8f32u8 = call <8 x i8> @llvm.fptoui.sat.v8i8.v8f32(<8 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v8f32s16 = call <8 x i16> @llvm.fptosi.sat.v8i16.v8f32(<8 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v8f32u16 = call <8 x i16> @llvm.fptoui.sat.v8i16.v8f32(<8 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v8f32s32 = call <8 x i32> @llvm.fptosi.sat.v8i32.v8f32(<8 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v8f32u32 = call <8 x i32> @llvm.fptoui.sat.v8i32.v8f32(<8 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %v8f32s64 = call <8 x i64> @llvm.fptosi.sat.v8i64.v8f32(<8 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 51 for instruction: %v8f32u64 = call <8 x i64> @llvm.fptoui.sat.v8i64.v8f32(<8 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %v8f64s1 = call <8 x i1> @llvm.fptosi.sat.v8i1.v8f64(<8 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v8f64u1 = call <8 x i1> @llvm.fptoui.sat.v8i1.v8f64(<8 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %v8f64s8 = call <8 x i8> @llvm.fptosi.sat.v8i8.v8f64(<8 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v8f64u8 = call <8 x i8> @llvm.fptoui.sat.v8i8.v8f64(<8 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %v8f64s16 = call <8 x i16> @llvm.fptosi.sat.v8i16.v8f64(<8 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v8f64u16 = call <8 x i16> @llvm.fptoui.sat.v8i16.v8f64(<8 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %v8f64s32 = call <8 x i32> @llvm.fptosi.sat.v8i32.v8f64(<8 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %v8f64u32 = call <8 x i32> @llvm.fptoui.sat.v8i32.v8f64(<8 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 46 for instruction: %v8f64s64 = call <8 x i64> @llvm.fptosi.sat.v8i64.v8f64(<8 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %v8f64u64 = call <8 x i64> @llvm.fptoui.sat.v8i64.v8f64(<8 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %v16f32s1 = call <16 x i1> @llvm.fptosi.sat.v16i1.v16f32(<16 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v16f32u1 = call <16 x i1> @llvm.fptoui.sat.v16i1.v16f32(<16 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %v16f32s8 = call <16 x i8> @llvm.fptosi.sat.v16i8.v16f32(<16 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v16f32u8 = call <16 x i8> @llvm.fptoui.sat.v16i8.v16f32(<16 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %v16f32s16 = call <16 x i16> @llvm.fptosi.sat.v16i16.v16f32(<16 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %v16f32u16 = call <16 x i16> @llvm.fptoui.sat.v16i16.v16f32(<16 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %v16f32s32 = call <16 x i32> @llvm.fptosi.sat.v16i32.v16f32(<16 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %v16f32u32 = call <16 x i32> @llvm.fptoui.sat.v16i32.v16f32(<16 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 80 for instruction: %v16f32s64 = call <16 x i64> @llvm.fptosi.sat.v16i64.v16f32(<16 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 102 for instruction: %v16f32u64 = call <16 x i64> @llvm.fptoui.sat.v16i64.v16f32(<16 x float> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 38 for instruction: %v16f64s1 = call <16 x i1> @llvm.fptosi.sat.v16i1.v16f64(<16 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %v16f64u1 = call <16 x i1> @llvm.fptoui.sat.v16i1.v16f64(<16 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 38 for instruction: %v16f64s8 = call <16 x i8> @llvm.fptosi.sat.v16i8.v16f64(<16 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %v16f64u8 = call <16 x i8> @llvm.fptoui.sat.v16i8.v16f64(<16 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 38 for instruction: %v16f64s16 = call <16 x i16> @llvm.fptosi.sat.v16i16.v16f64(<16 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %v16f64u16 = call <16 x i16> @llvm.fptoui.sat.v16i16.v16f64(<16 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 38 for instruction: %v16f64s32 = call <16 x i32> @llvm.fptosi.sat.v16i32.v16f64(<16 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %v16f64u32 = call <16 x i32> @llvm.fptoui.sat.v16i32.v16f64(<16 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 92 for instruction: %v16f64s64 = call <16 x i64> @llvm.fptosi.sat.v16i64.v16f64(<16 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %v16f64u64 = call <16 x i64> @llvm.fptoui.sat.v16i64.v16f64(<16 x double> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512F-LABEL: 'casts'
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f32s1 = call i1 @llvm.fptosi.sat.i1.f32(float undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f32u1 = call i1 @llvm.fptoui.sat.i1.f32(float undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f32s8 = call i8 @llvm.fptosi.sat.i8.f32(float undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f32u8 = call i8 @llvm.fptoui.sat.i8.f32(float undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f32s16 = call i16 @llvm.fptosi.sat.i16.f32(float undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f32u16 = call i16 @llvm.fptoui.sat.i16.f32(float undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f32s32 = call i32 @llvm.fptosi.sat.i32.f32(float undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f32u32 = call i32 @llvm.fptoui.sat.i32.f32(float undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f32s64 = call i64 @llvm.fptosi.sat.i64.f32(float undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f32u64 = call i64 @llvm.fptoui.sat.i64.f32(float undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f64s1 = call i1 @llvm.fptosi.sat.i1.f64(double undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f64u1 = call i1 @llvm.fptoui.sat.i1.f64(double undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f64s8 = call i8 @llvm.fptosi.sat.i8.f64(double undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f64u8 = call i8 @llvm.fptoui.sat.i8.f64(double undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f64s16 = call i16 @llvm.fptosi.sat.i16.f64(double undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f64u16 = call i16 @llvm.fptoui.sat.i16.f64(double undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f64s32 = call i32 @llvm.fptosi.sat.i32.f64(double undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f64u32 = call i32 @llvm.fptoui.sat.i32.f64(double undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f64s64 = call i64 @llvm.fptosi.sat.i64.f64(double undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f64u64 = call i64 @llvm.fptoui.sat.i64.f64(double undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %v2f32s1 = call <2 x i1> @llvm.fptosi.sat.v2i1.v2f32(<2 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v2f32u1 = call <2 x i1> @llvm.fptoui.sat.v2i1.v2f32(<2 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v2f32s8 = call <2 x i8> @llvm.fptosi.sat.v2i8.v2f32(<2 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v2f32u8 = call <2 x i8> @llvm.fptoui.sat.v2i8.v2f32(<2 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v2f32s16 = call <2 x i16> @llvm.fptosi.sat.v2i16.v2f32(<2 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v2f32u16 = call <2 x i16> @llvm.fptoui.sat.v2i16.v2f32(<2 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v2f32s32 = call <2 x i32> @llvm.fptosi.sat.v2i32.v2f32(<2 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v2f32u32 = call <2 x i32> @llvm.fptoui.sat.v2i32.v2f32(<2 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v2f32s64 = call <2 x i64> @llvm.fptosi.sat.v2i64.v2f32(<2 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v2f32u64 = call <2 x i64> @llvm.fptoui.sat.v2i64.v2f32(<2 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %v2f64s1 = call <2 x i1> @llvm.fptosi.sat.v2i1.v2f64(<2 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v2f64u1 = call <2 x i1> @llvm.fptoui.sat.v2i1.v2f64(<2 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v2f64s8 = call <2 x i8> @llvm.fptosi.sat.v2i8.v2f64(<2 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v2f64u8 = call <2 x i8> @llvm.fptoui.sat.v2i8.v2f64(<2 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v2f64s16 = call <2 x i16> @llvm.fptosi.sat.v2i16.v2f64(<2 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v2f64u16 = call <2 x i16> @llvm.fptoui.sat.v2i16.v2f64(<2 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v2f64s32 = call <2 x i32> @llvm.fptosi.sat.v2i32.v2f64(<2 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v2f64u32 = call <2 x i32> @llvm.fptoui.sat.v2i32.v2f64(<2 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v2f64s64 = call <2 x i64> @llvm.fptosi.sat.v2i64.v2f64(<2 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v2f64u64 = call <2 x i64> @llvm.fptoui.sat.v2i64.v2f64(<2 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %v4f32s1 = call <4 x i1> @llvm.fptosi.sat.v4i1.v4f32(<4 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v4f32u1 = call <4 x i1> @llvm.fptoui.sat.v4i1.v4f32(<4 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v4f32s8 = call <4 x i8> @llvm.fptosi.sat.v4i8.v4f32(<4 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v4f32u8 = call <4 x i8> @llvm.fptoui.sat.v4i8.v4f32(<4 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v4f32s16 = call <4 x i16> @llvm.fptosi.sat.v4i16.v4f32(<4 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v4f32u16 = call <4 x i16> @llvm.fptoui.sat.v4i16.v4f32(<4 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v4f32s32 = call <4 x i32> @llvm.fptosi.sat.v4i32.v4f32(<4 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v4f32u32 = call <4 x i32> @llvm.fptoui.sat.v4i32.v4f32(<4 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %v4f32s64 = call <4 x i64> @llvm.fptosi.sat.v4i64.v4f32(<4 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %v4f32u64 = call <4 x i64> @llvm.fptoui.sat.v4i64.v4f32(<4 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %v4f64s1 = call <4 x i1> @llvm.fptosi.sat.v4i1.v4f64(<4 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v4f64u1 = call <4 x i1> @llvm.fptoui.sat.v4i1.v4f64(<4 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v4f64s8 = call <4 x i8> @llvm.fptosi.sat.v4i8.v4f64(<4 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v4f64u8 = call <4 x i8> @llvm.fptoui.sat.v4i8.v4f64(<4 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v4f64s16 = call <4 x i16> @llvm.fptosi.sat.v4i16.v4f64(<4 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v4f64u16 = call <4 x i16> @llvm.fptoui.sat.v4i16.v4f64(<4 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v4f64s32 = call <4 x i32> @llvm.fptosi.sat.v4i32.v4f64(<4 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v4f64u32 = call <4 x i32> @llvm.fptoui.sat.v4i32.v4f64(<4 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %v4f64s64 = call <4 x i64> @llvm.fptosi.sat.v4i64.v4f64(<4 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %v4f64u64 = call <4 x i64> @llvm.fptoui.sat.v4i64.v4f64(<4 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %v8f32s1 = call <8 x i1> @llvm.fptosi.sat.v8i1.v8f32(<8 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8f32u1 = call <8 x i1> @llvm.fptoui.sat.v8i1.v8f32(<8 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v8f32s8 = call <8 x i8> @llvm.fptosi.sat.v8i8.v8f32(<8 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v8f32u8 = call <8 x i8> @llvm.fptoui.sat.v8i8.v8f32(<8 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v8f32s16 = call <8 x i16> @llvm.fptosi.sat.v8i16.v8f32(<8 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v8f32u16 = call <8 x i16> @llvm.fptoui.sat.v8i16.v8f32(<8 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v8f32s32 = call <8 x i32> @llvm.fptosi.sat.v8i32.v8f32(<8 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8f32u32 = call <8 x i32> @llvm.fptoui.sat.v8i32.v8f32(<8 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %v8f32s64 = call <8 x i64> @llvm.fptosi.sat.v8i64.v8f32(<8 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %v8f32u64 = call <8 x i64> @llvm.fptoui.sat.v8i64.v8f32(<8 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %v8f64s1 = call <8 x i1> @llvm.fptosi.sat.v8i1.v8f64(<8 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8f64u1 = call <8 x i1> @llvm.fptoui.sat.v8i1.v8f64(<8 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v8f64s8 = call <8 x i8> @llvm.fptosi.sat.v8i8.v8f64(<8 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v8f64u8 = call <8 x i8> @llvm.fptoui.sat.v8i8.v8f64(<8 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v8f64s16 = call <8 x i16> @llvm.fptosi.sat.v8i16.v8f64(<8 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v8f64u16 = call <8 x i16> @llvm.fptoui.sat.v8i16.v8f64(<8 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v8f64s32 = call <8 x i32> @llvm.fptosi.sat.v8i32.v8f64(<8 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8f64u32 = call <8 x i32> @llvm.fptoui.sat.v8i32.v8f64(<8 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %v8f64s64 = call <8 x i64> @llvm.fptosi.sat.v8i64.v8f64(<8 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %v8f64u64 = call <8 x i64> @llvm.fptoui.sat.v8i64.v8f64(<8 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 38 for instruction: %v16f32s1 = call <16 x i1> @llvm.fptosi.sat.v16i1.v16f32(<16 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v16f32u1 = call <16 x i1> @llvm.fptoui.sat.v16i1.v16f32(<16 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v16f32s8 = call <16 x i8> @llvm.fptosi.sat.v16i8.v16f32(<16 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v16f32u8 = call <16 x i8> @llvm.fptoui.sat.v16i8.v16f32(<16 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v16f32s16 = call <16 x i16> @llvm.fptosi.sat.v16i16.v16f32(<16 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v16f32u16 = call <16 x i16> @llvm.fptoui.sat.v16i16.v16f32(<16 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v16f32s32 = call <16 x i32> @llvm.fptosi.sat.v16i32.v16f32(<16 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v16f32u32 = call <16 x i32> @llvm.fptoui.sat.v16i32.v16f32(<16 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 68 for instruction: %v16f32s64 = call <16 x i64> @llvm.fptosi.sat.v16i64.v16f32(<16 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 65 for instruction: %v16f32u64 = call <16 x i64> @llvm.fptoui.sat.v16i64.v16f32(<16 x float> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 45 for instruction: %v16f64s1 = call <16 x i1> @llvm.fptosi.sat.v16i1.v16f64(<16 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v16f64u1 = call <16 x i1> @llvm.fptoui.sat.v16i1.v16f64(<16 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %v16f64s8 = call <16 x i8> @llvm.fptosi.sat.v16i8.v16f64(<16 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %v16f64u8 = call <16 x i8> @llvm.fptoui.sat.v16i8.v16f64(<16 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %v16f64s16 = call <16 x i16> @llvm.fptosi.sat.v16i16.v16f64(<16 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %v16f64u16 = call <16 x i16> @llvm.fptoui.sat.v16i16.v16f64(<16 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %v16f64s32 = call <16 x i32> @llvm.fptosi.sat.v16i32.v16f64(<16 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v16f64u32 = call <16 x i32> @llvm.fptoui.sat.v16i32.v16f64(<16 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 72 for instruction: %v16f64s64 = call <16 x i64> @llvm.fptosi.sat.v16i64.v16f64(<16 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 68 for instruction: %v16f64u64 = call <16 x i64> @llvm.fptoui.sat.v16i64.v16f64(<16 x double> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512DQ-LABEL: 'casts'
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f32s1 = call i1 @llvm.fptosi.sat.i1.f32(float undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f32u1 = call i1 @llvm.fptoui.sat.i1.f32(float undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f32s8 = call i8 @llvm.fptosi.sat.i8.f32(float undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f32u8 = call i8 @llvm.fptoui.sat.i8.f32(float undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f32s16 = call i16 @llvm.fptosi.sat.i16.f32(float undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f32u16 = call i16 @llvm.fptoui.sat.i16.f32(float undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f32s32 = call i32 @llvm.fptosi.sat.i32.f32(float undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f32u32 = call i32 @llvm.fptoui.sat.i32.f32(float undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f32s64 = call i64 @llvm.fptosi.sat.i64.f32(float undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f32u64 = call i64 @llvm.fptoui.sat.i64.f32(float undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f64s1 = call i1 @llvm.fptosi.sat.i1.f64(double undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f64u1 = call i1 @llvm.fptoui.sat.i1.f64(double undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f64s8 = call i8 @llvm.fptosi.sat.i8.f64(double undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f64u8 = call i8 @llvm.fptoui.sat.i8.f64(double undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f64s16 = call i16 @llvm.fptosi.sat.i16.f64(double undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f64u16 = call i16 @llvm.fptoui.sat.i16.f64(double undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f64s32 = call i32 @llvm.fptosi.sat.i32.f64(double undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f64u32 = call i32 @llvm.fptoui.sat.i32.f64(double undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %f64s64 = call i64 @llvm.fptosi.sat.i64.f64(double undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f64u64 = call i64 @llvm.fptoui.sat.i64.f64(double undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %v2f32s1 = call <2 x i1> @llvm.fptosi.sat.v2i1.v2f32(<2 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v2f32u1 = call <2 x i1> @llvm.fptoui.sat.v2i1.v2f32(<2 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v2f32s8 = call <2 x i8> @llvm.fptosi.sat.v2i8.v2f32(<2 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v2f32u8 = call <2 x i8> @llvm.fptoui.sat.v2i8.v2f32(<2 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v2f32s16 = call <2 x i16> @llvm.fptosi.sat.v2i16.v2f32(<2 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v2f32u16 = call <2 x i16> @llvm.fptoui.sat.v2i16.v2f32(<2 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v2f32s32 = call <2 x i32> @llvm.fptosi.sat.v2i32.v2f32(<2 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v2f32u32 = call <2 x i32> @llvm.fptoui.sat.v2i32.v2f32(<2 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v2f32s64 = call <2 x i64> @llvm.fptosi.sat.v2i64.v2f32(<2 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v2f32u64 = call <2 x i64> @llvm.fptoui.sat.v2i64.v2f32(<2 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %v2f64s1 = call <2 x i1> @llvm.fptosi.sat.v2i1.v2f64(<2 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v2f64u1 = call <2 x i1> @llvm.fptoui.sat.v2i1.v2f64(<2 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v2f64s8 = call <2 x i8> @llvm.fptosi.sat.v2i8.v2f64(<2 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v2f64u8 = call <2 x i8> @llvm.fptoui.sat.v2i8.v2f64(<2 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v2f64s16 = call <2 x i16> @llvm.fptosi.sat.v2i16.v2f64(<2 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v2f64u16 = call <2 x i16> @llvm.fptoui.sat.v2i16.v2f64(<2 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v2f64s32 = call <2 x i32> @llvm.fptosi.sat.v2i32.v2f64(<2 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v2f64u32 = call <2 x i32> @llvm.fptoui.sat.v2i32.v2f64(<2 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v2f64s64 = call <2 x i64> @llvm.fptosi.sat.v2i64.v2f64(<2 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v2f64u64 = call <2 x i64> @llvm.fptoui.sat.v2i64.v2f64(<2 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %v4f32s1 = call <4 x i1> @llvm.fptosi.sat.v4i1.v4f32(<4 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v4f32u1 = call <4 x i1> @llvm.fptoui.sat.v4i1.v4f32(<4 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v4f32s8 = call <4 x i8> @llvm.fptosi.sat.v4i8.v4f32(<4 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v4f32u8 = call <4 x i8> @llvm.fptoui.sat.v4i8.v4f32(<4 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v4f32s16 = call <4 x i16> @llvm.fptosi.sat.v4i16.v4f32(<4 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v4f32u16 = call <4 x i16> @llvm.fptoui.sat.v4i16.v4f32(<4 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v4f32s32 = call <4 x i32> @llvm.fptosi.sat.v4i32.v4f32(<4 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v4f32u32 = call <4 x i32> @llvm.fptoui.sat.v4i32.v4f32(<4 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v4f32s64 = call <4 x i64> @llvm.fptosi.sat.v4i64.v4f32(<4 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v4f32u64 = call <4 x i64> @llvm.fptoui.sat.v4i64.v4f32(<4 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %v4f64s1 = call <4 x i1> @llvm.fptosi.sat.v4i1.v4f64(<4 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v4f64u1 = call <4 x i1> @llvm.fptoui.sat.v4i1.v4f64(<4 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v4f64s8 = call <4 x i8> @llvm.fptosi.sat.v4i8.v4f64(<4 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v4f64u8 = call <4 x i8> @llvm.fptoui.sat.v4i8.v4f64(<4 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v4f64s16 = call <4 x i16> @llvm.fptosi.sat.v4i16.v4f64(<4 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v4f64u16 = call <4 x i16> @llvm.fptoui.sat.v4i16.v4f64(<4 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v4f64s32 = call <4 x i32> @llvm.fptosi.sat.v4i32.v4f64(<4 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v4f64u32 = call <4 x i32> @llvm.fptoui.sat.v4i32.v4f64(<4 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v4f64s64 = call <4 x i64> @llvm.fptosi.sat.v4i64.v4f64(<4 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v4f64u64 = call <4 x i64> @llvm.fptoui.sat.v4i64.v4f64(<4 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %v8f32s1 = call <8 x i1> @llvm.fptosi.sat.v8i1.v8f32(<8 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8f32u1 = call <8 x i1> @llvm.fptoui.sat.v8i1.v8f32(<8 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v8f32s8 = call <8 x i8> @llvm.fptosi.sat.v8i8.v8f32(<8 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v8f32u8 = call <8 x i8> @llvm.fptoui.sat.v8i8.v8f32(<8 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v8f32s16 = call <8 x i16> @llvm.fptosi.sat.v8i16.v8f32(<8 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v8f32u16 = call <8 x i16> @llvm.fptoui.sat.v8i16.v8f32(<8 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v8f32s32 = call <8 x i32> @llvm.fptosi.sat.v8i32.v8f32(<8 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8f32u32 = call <8 x i32> @llvm.fptoui.sat.v8i32.v8f32(<8 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v8f32s64 = call <8 x i64> @llvm.fptosi.sat.v8i64.v8f32(<8 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8f32u64 = call <8 x i64> @llvm.fptoui.sat.v8i64.v8f32(<8 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %v8f64s1 = call <8 x i1> @llvm.fptosi.sat.v8i1.v8f64(<8 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8f64u1 = call <8 x i1> @llvm.fptoui.sat.v8i1.v8f64(<8 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v8f64s8 = call <8 x i8> @llvm.fptosi.sat.v8i8.v8f64(<8 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v8f64u8 = call <8 x i8> @llvm.fptoui.sat.v8i8.v8f64(<8 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v8f64s16 = call <8 x i16> @llvm.fptosi.sat.v8i16.v8f64(<8 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v8f64u16 = call <8 x i16> @llvm.fptoui.sat.v8i16.v8f64(<8 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v8f64s32 = call <8 x i32> @llvm.fptosi.sat.v8i32.v8f64(<8 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8f64u32 = call <8 x i32> @llvm.fptoui.sat.v8i32.v8f64(<8 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v8f64s64 = call <8 x i64> @llvm.fptosi.sat.v8i64.v8f64(<8 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8f64u64 = call <8 x i64> @llvm.fptoui.sat.v8i64.v8f64(<8 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 38 for instruction: %v16f32s1 = call <16 x i1> @llvm.fptosi.sat.v16i1.v16f32(<16 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v16f32u1 = call <16 x i1> @llvm.fptoui.sat.v16i1.v16f32(<16 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v16f32s8 = call <16 x i8> @llvm.fptosi.sat.v16i8.v16f32(<16 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v16f32u8 = call <16 x i8> @llvm.fptoui.sat.v16i8.v16f32(<16 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v16f32s16 = call <16 x i16> @llvm.fptosi.sat.v16i16.v16f32(<16 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v16f32u16 = call <16 x i16> @llvm.fptoui.sat.v16i16.v16f32(<16 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v16f32s32 = call <16 x i32> @llvm.fptosi.sat.v16i32.v16f32(<16 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v16f32u32 = call <16 x i32> @llvm.fptoui.sat.v16i32.v16f32(<16 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v16f32s64 = call <16 x i64> @llvm.fptosi.sat.v16i64.v16f32(<16 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v16f32u64 = call <16 x i64> @llvm.fptoui.sat.v16i64.v16f32(<16 x float> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 45 for instruction: %v16f64s1 = call <16 x i1> @llvm.fptosi.sat.v16i1.v16f64(<16 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v16f64u1 = call <16 x i1> @llvm.fptoui.sat.v16i1.v16f64(<16 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %v16f64s8 = call <16 x i8> @llvm.fptosi.sat.v16i8.v16f64(<16 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %v16f64u8 = call <16 x i8> @llvm.fptoui.sat.v16i8.v16f64(<16 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %v16f64s16 = call <16 x i16> @llvm.fptosi.sat.v16i16.v16f64(<16 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %v16f64u16 = call <16 x i16> @llvm.fptoui.sat.v16i16.v16f64(<16 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %v16f64s32 = call <16 x i32> @llvm.fptosi.sat.v16i32.v16f64(<16 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v16f64u32 = call <16 x i32> @llvm.fptoui.sat.v16i32.v16f64(<16 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %v16f64s64 = call <16 x i64> @llvm.fptosi.sat.v16i64.v16f64(<16 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v16f64u64 = call <16 x i64> @llvm.fptoui.sat.v16i64.v16f64(<16 x double> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SLM-LABEL: 'casts'
; SLM-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %f32s1 = call i1 @llvm.fptosi.sat.i1.f32(float undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f32u1 = call i1 @llvm.fptoui.sat.i1.f32(float undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %f32s8 = call i8 @llvm.fptosi.sat.i8.f32(float undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f32u8 = call i8 @llvm.fptoui.sat.i8.f32(float undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %f32s16 = call i16 @llvm.fptosi.sat.i16.f32(float undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f32u16 = call i16 @llvm.fptoui.sat.i16.f32(float undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %f32s32 = call i32 @llvm.fptosi.sat.i32.f32(float undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f32u32 = call i32 @llvm.fptoui.sat.i32.f32(float undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %f32s64 = call i64 @llvm.fptosi.sat.i64.f32(float undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %f32u64 = call i64 @llvm.fptoui.sat.i64.f32(float undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %f64s1 = call i1 @llvm.fptosi.sat.i1.f64(double undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f64u1 = call i1 @llvm.fptoui.sat.i1.f64(double undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %f64s8 = call i8 @llvm.fptosi.sat.i8.f64(double undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f64u8 = call i8 @llvm.fptoui.sat.i8.f64(double undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %f64s16 = call i16 @llvm.fptosi.sat.i16.f64(double undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f64u16 = call i16 @llvm.fptoui.sat.i16.f64(double undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %f64s32 = call i32 @llvm.fptosi.sat.i32.f64(double undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %f64u32 = call i32 @llvm.fptoui.sat.i32.f64(double undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %f64s64 = call i64 @llvm.fptosi.sat.i64.f64(double undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %f64u64 = call i64 @llvm.fptoui.sat.i64.f64(double undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %v2f32s1 = call <2 x i1> @llvm.fptosi.sat.v2i1.v2f32(<2 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %v2f32u1 = call <2 x i1> @llvm.fptoui.sat.v2i1.v2f32(<2 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %v2f32s8 = call <2 x i8> @llvm.fptosi.sat.v2i8.v2f32(<2 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v2f32u8 = call <2 x i8> @llvm.fptoui.sat.v2i8.v2f32(<2 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %v2f32s16 = call <2 x i16> @llvm.fptosi.sat.v2i16.v2f32(<2 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v2f32u16 = call <2 x i16> @llvm.fptoui.sat.v2i16.v2f32(<2 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v2f32s32 = call <2 x i32> @llvm.fptosi.sat.v2i32.v2f32(<2 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v2f32u32 = call <2 x i32> @llvm.fptoui.sat.v2i32.v2f32(<2 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %v2f32s64 = call <2 x i64> @llvm.fptosi.sat.v2i64.v2f32(<2 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %v2f32u64 = call <2 x i64> @llvm.fptoui.sat.v2i64.v2f32(<2 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %v2f64s1 = call <2 x i1> @llvm.fptosi.sat.v2i1.v2f64(<2 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %v2f64u1 = call <2 x i1> @llvm.fptoui.sat.v2i1.v2f64(<2 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %v2f64s8 = call <2 x i8> @llvm.fptosi.sat.v2i8.v2f64(<2 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v2f64u8 = call <2 x i8> @llvm.fptoui.sat.v2i8.v2f64(<2 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %v2f64s16 = call <2 x i16> @llvm.fptosi.sat.v2i16.v2f64(<2 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v2f64u16 = call <2 x i16> @llvm.fptoui.sat.v2i16.v2f64(<2 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v2f64s32 = call <2 x i32> @llvm.fptosi.sat.v2i32.v2f64(<2 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v2f64u32 = call <2 x i32> @llvm.fptoui.sat.v2i32.v2f64(<2 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %v2f64s64 = call <2 x i64> @llvm.fptosi.sat.v2i64.v2f64(<2 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %v2f64u64 = call <2 x i64> @llvm.fptoui.sat.v2i64.v2f64(<2 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v4f32s1 = call <4 x i1> @llvm.fptosi.sat.v4i1.v4f32(<4 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v4f32u1 = call <4 x i1> @llvm.fptoui.sat.v4i1.v4f32(<4 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %v4f32s8 = call <4 x i8> @llvm.fptosi.sat.v4i8.v4f32(<4 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v4f32u8 = call <4 x i8> @llvm.fptoui.sat.v4i8.v4f32(<4 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %v4f32s16 = call <4 x i16> @llvm.fptosi.sat.v4i16.v4f32(<4 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v4f32u16 = call <4 x i16> @llvm.fptoui.sat.v4i16.v4f32(<4 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v4f32s32 = call <4 x i32> @llvm.fptosi.sat.v4i32.v4f32(<4 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v4f32u32 = call <4 x i32> @llvm.fptoui.sat.v4i32.v4f32(<4 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 42 for instruction: %v4f32s64 = call <4 x i64> @llvm.fptosi.sat.v4i64.v4f32(<4 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 45 for instruction: %v4f32u64 = call <4 x i64> @llvm.fptoui.sat.v4i64.v4f32(<4 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %v4f64s1 = call <4 x i1> @llvm.fptosi.sat.v4i1.v4f64(<4 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %v4f64u1 = call <4 x i1> @llvm.fptoui.sat.v4i1.v4f64(<4 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %v4f64s8 = call <4 x i8> @llvm.fptosi.sat.v4i8.v4f64(<4 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %v4f64u8 = call <4 x i8> @llvm.fptoui.sat.v4i8.v4f64(<4 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %v4f64s16 = call <4 x i16> @llvm.fptosi.sat.v4i16.v4f64(<4 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %v4f64u16 = call <4 x i16> @llvm.fptoui.sat.v4i16.v4f64(<4 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %v4f64s32 = call <4 x i32> @llvm.fptosi.sat.v4i32.v4f64(<4 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %v4f64u32 = call <4 x i32> @llvm.fptoui.sat.v4i32.v4f64(<4 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 50 for instruction: %v4f64s64 = call <4 x i64> @llvm.fptosi.sat.v4i64.v4f64(<4 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 52 for instruction: %v4f64u64 = call <4 x i64> @llvm.fptoui.sat.v4i64.v4f64(<4 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %v8f32s1 = call <8 x i1> @llvm.fptosi.sat.v8i1.v8f32(<8 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %v8f32u1 = call <8 x i1> @llvm.fptoui.sat.v8i1.v8f32(<8 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %v8f32s8 = call <8 x i8> @llvm.fptosi.sat.v8i8.v8f32(<8 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %v8f32u8 = call <8 x i8> @llvm.fptoui.sat.v8i8.v8f32(<8 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %v8f32s16 = call <8 x i16> @llvm.fptosi.sat.v8i16.v8f32(<8 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %v8f32u16 = call <8 x i16> @llvm.fptoui.sat.v8i16.v8f32(<8 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %v8f32s32 = call <8 x i32> @llvm.fptosi.sat.v8i32.v8f32(<8 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %v8f32u32 = call <8 x i32> @llvm.fptoui.sat.v8i32.v8f32(<8 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 84 for instruction: %v8f32s64 = call <8 x i64> @llvm.fptosi.sat.v8i64.v8f32(<8 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 90 for instruction: %v8f32u64 = call <8 x i64> @llvm.fptoui.sat.v8i64.v8f32(<8 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 44 for instruction: %v8f64s1 = call <8 x i1> @llvm.fptosi.sat.v8i1.v8f64(<8 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %v8f64u1 = call <8 x i1> @llvm.fptoui.sat.v8i1.v8f64(<8 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %v8f64s8 = call <8 x i8> @llvm.fptosi.sat.v8i8.v8f64(<8 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %v8f64u8 = call <8 x i8> @llvm.fptoui.sat.v8i8.v8f64(<8 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 44 for instruction: %v8f64s16 = call <8 x i16> @llvm.fptosi.sat.v8i16.v8f64(<8 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %v8f64u16 = call <8 x i16> @llvm.fptoui.sat.v8i16.v8f64(<8 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 44 for instruction: %v8f64s32 = call <8 x i32> @llvm.fptosi.sat.v8i32.v8f64(<8 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %v8f64u32 = call <8 x i32> @llvm.fptoui.sat.v8i32.v8f64(<8 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 100 for instruction: %v8f64s64 = call <8 x i64> @llvm.fptosi.sat.v8i64.v8f64(<8 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 104 for instruction: %v8f64u64 = call <8 x i64> @llvm.fptoui.sat.v8i64.v8f64(<8 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %v16f32s1 = call <16 x i1> @llvm.fptosi.sat.v16i1.v16f32(<16 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %v16f32u1 = call <16 x i1> @llvm.fptoui.sat.v16i1.v16f32(<16 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %v16f32s8 = call <16 x i8> @llvm.fptosi.sat.v16i8.v16f32(<16 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %v16f32u8 = call <16 x i8> @llvm.fptoui.sat.v16i8.v16f32(<16 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %v16f32s16 = call <16 x i16> @llvm.fptosi.sat.v16i16.v16f32(<16 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %v16f32u16 = call <16 x i16> @llvm.fptoui.sat.v16i16.v16f32(<16 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %v16f32s32 = call <16 x i32> @llvm.fptosi.sat.v16i32.v16f32(<16 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %v16f32u32 = call <16 x i32> @llvm.fptoui.sat.v16i32.v16f32(<16 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 168 for instruction: %v16f32s64 = call <16 x i64> @llvm.fptosi.sat.v16i64.v16f32(<16 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 180 for instruction: %v16f32u64 = call <16 x i64> @llvm.fptoui.sat.v16i64.v16f32(<16 x float> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 92 for instruction: %v16f64s1 = call <16 x i1> @llvm.fptosi.sat.v16i1.v16f64(<16 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 80 for instruction: %v16f64u1 = call <16 x i1> @llvm.fptoui.sat.v16i1.v16f64(<16 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 92 for instruction: %v16f64s8 = call <16 x i8> @llvm.fptosi.sat.v16i8.v16f64(<16 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 80 for instruction: %v16f64u8 = call <16 x i8> @llvm.fptoui.sat.v16i8.v16f64(<16 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 88 for instruction: %v16f64s16 = call <16 x i16> @llvm.fptosi.sat.v16i16.v16f64(<16 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 72 for instruction: %v16f64u16 = call <16 x i16> @llvm.fptoui.sat.v16i16.v16f64(<16 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 88 for instruction: %v16f64s32 = call <16 x i32> @llvm.fptosi.sat.v16i32.v16f64(<16 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %v16f64u32 = call <16 x i32> @llvm.fptoui.sat.v16i32.v16f64(<16 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 200 for instruction: %v16f64s64 = call <16 x i64> @llvm.fptosi.sat.v16i64.v16f64(<16 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 208 for instruction: %v16f64u64 = call <16 x i64> @llvm.fptoui.sat.v16i64.v16f64(<16 x double> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %f32s1 = call i1 @llvm.fptosi.sat.i1.f32(float undef)
  %f32u1 = call i1 @llvm.fptoui.sat.i1.f32(float undef)
  %f32s8 = call i8 @llvm.fptosi.sat.i8.f32(float undef)
  %f32u8 = call i8 @llvm.fptoui.sat.i8.f32(float undef)
  %f32s16 = call i16 @llvm.fptosi.sat.i16.f32(float undef)
  %f32u16 = call i16 @llvm.fptoui.sat.i16.f32(float undef)
  %f32s32 = call i32 @llvm.fptosi.sat.i32.f32(float undef)
  %f32u32 = call i32 @llvm.fptoui.sat.i32.f32(float undef)
  %f32s64 = call i64 @llvm.fptosi.sat.i64.f32(float undef)
  %f32u64 = call i64 @llvm.fptoui.sat.i64.f32(float undef)

  %f64s1 = call i1 @llvm.fptosi.sat.i1.f64(double undef)
  %f64u1 = call i1 @llvm.fptoui.sat.i1.f64(double undef)
  %f64s8 = call i8 @llvm.fptosi.sat.i8.f64(double undef)
  %f64u8 = call i8 @llvm.fptoui.sat.i8.f64(double undef)
  %f64s16 = call i16 @llvm.fptosi.sat.i16.f64(double undef)
  %f64u16 = call i16 @llvm.fptoui.sat.i16.f64(double undef)
  %f64s32 = call i32 @llvm.fptosi.sat.i32.f64(double undef)
  %f64u32 = call i32 @llvm.fptoui.sat.i32.f64(double undef)
  %f64s64 = call i64 @llvm.fptosi.sat.i64.f64(double undef)
  %f64u64 = call i64 @llvm.fptoui.sat.i64.f64(double undef)

  %v2f32s1 = call <2 x i1> @llvm.fptosi.sat.v2i1.v2f32(<2 x float> undef)
  %v2f32u1 = call <2 x i1> @llvm.fptoui.sat.v2i1.v2f32(<2 x float> undef)
  %v2f32s8 = call <2 x i8> @llvm.fptosi.sat.v2i8.v2f32(<2 x float> undef)
  %v2f32u8 = call <2 x i8> @llvm.fptoui.sat.v2i8.v2f32(<2 x float> undef)
  %v2f32s16 = call <2 x i16> @llvm.fptosi.sat.v2i16.v2f32(<2 x float> undef)
  %v2f32u16 = call <2 x i16> @llvm.fptoui.sat.v2i16.v2f32(<2 x float> undef)
  %v2f32s32 = call <2 x i32> @llvm.fptosi.sat.v2i32.v2f32(<2 x float> undef)
  %v2f32u32 = call <2 x i32> @llvm.fptoui.sat.v2i32.v2f32(<2 x float> undef)
  %v2f32s64 = call <2 x i64> @llvm.fptosi.sat.v2i64.v2f32(<2 x float> undef)
  %v2f32u64 = call <2 x i64> @llvm.fptoui.sat.v2i64.v2f32(<2 x float> undef)

  %v2f64s1 = call <2 x i1> @llvm.fptosi.sat.v2i1.v2f64(<2 x double> undef)
  %v2f64u1 = call <2 x i1> @llvm.fptoui.sat.v2i1.v2f64(<2 x double> undef)
  %v2f64s8 = call <2 x i8> @llvm.fptosi.sat.v2i8.v2f64(<2 x double> undef)
  %v2f64u8 = call <2 x i8> @llvm.fptoui.sat.v2i8.v2f64(<2 x double> undef)
  %v2f64s16 = call <2 x i16> @llvm.fptosi.sat.v2i16.v2f64(<2 x double> undef)
  %v2f64u16 = call <2 x i16> @llvm.fptoui.sat.v2i16.v2f64(<2 x double> undef)
  %v2f64s32 = call <2 x i32> @llvm.fptosi.sat.v2i32.v2f64(<2 x double> undef)
  %v2f64u32 = call <2 x i32> @llvm.fptoui.sat.v2i32.v2f64(<2 x double> undef)
  %v2f64s64 = call <2 x i64> @llvm.fptosi.sat.v2i64.v2f64(<2 x double> undef)
  %v2f64u64 = call <2 x i64> @llvm.fptoui.sat.v2i64.v2f64(<2 x double> undef)

  %v4f32s1 = call <4 x i1> @llvm.fptosi.sat.v4i1.v4f32(<4 x float> undef)
  %v4f32u1 = call <4 x i1> @llvm.fptoui.sat.v4i1.v4f32(<4 x float> undef)
  %v4f32s8 = call <4 x i8> @llvm.fptosi.sat.v4i8.v4f32(<4 x float> undef)
  %v4f32u8 = call <4 x i8> @llvm.fptoui.sat.v4i8.v4f32(<4 x float> undef)
  %v4f32s16 = call <4 x i16> @llvm.fptosi.sat.v4i16.v4f32(<4 x float> undef)
  %v4f32u16 = call <4 x i16> @llvm.fptoui.sat.v4i16.v4f32(<4 x float> undef)
  %v4f32s32 = call <4 x i32> @llvm.fptosi.sat.v4i32.v4f32(<4 x float> undef)
  %v4f32u32 = call <4 x i32> @llvm.fptoui.sat.v4i32.v4f32(<4 x float> undef)
  %v4f32s64 = call <4 x i64> @llvm.fptosi.sat.v4i64.v4f32(<4 x float> undef)
  %v4f32u64 = call <4 x i64> @llvm.fptoui.sat.v4i64.v4f32(<4 x float> undef)

  %v4f64s1 = call <4 x i1> @llvm.fptosi.sat.v4i1.v4f64(<4 x double> undef)
  %v4f64u1 = call <4 x i1> @llvm.fptoui.sat.v4i1.v4f64(<4 x double> undef)
  %v4f64s8 = call <4 x i8> @llvm.fptosi.sat.v4i8.v4f64(<4 x double> undef)
  %v4f64u8 = call <4 x i8> @llvm.fptoui.sat.v4i8.v4f64(<4 x double> undef)
  %v4f64s16 = call <4 x i16> @llvm.fptosi.sat.v4i16.v4f64(<4 x double> undef)
  %v4f64u16 = call <4 x i16> @llvm.fptoui.sat.v4i16.v4f64(<4 x double> undef)
  %v4f64s32 = call <4 x i32> @llvm.fptosi.sat.v4i32.v4f64(<4 x double> undef)
  %v4f64u32 = call <4 x i32> @llvm.fptoui.sat.v4i32.v4f64(<4 x double> undef)
  %v4f64s64 = call <4 x i64> @llvm.fptosi.sat.v4i64.v4f64(<4 x double> undef)
  %v4f64u64 = call <4 x i64> @llvm.fptoui.sat.v4i64.v4f64(<4 x double> undef)

  %v8f32s1 = call <8 x i1> @llvm.fptosi.sat.v8i1.v8f32(<8 x float> undef)
  %v8f32u1 = call <8 x i1> @llvm.fptoui.sat.v8i1.v8f32(<8 x float> undef)
  %v8f32s8 = call <8 x i8> @llvm.fptosi.sat.v8i8.v8f32(<8 x float> undef)
  %v8f32u8 = call <8 x i8> @llvm.fptoui.sat.v8i8.v8f32(<8 x float> undef)
  %v8f32s16 = call <8 x i16> @llvm.fptosi.sat.v8i16.v8f32(<8 x float> undef)
  %v8f32u16 = call <8 x i16> @llvm.fptoui.sat.v8i16.v8f32(<8 x float> undef)
  %v8f32s32 = call <8 x i32> @llvm.fptosi.sat.v8i32.v8f32(<8 x float> undef)
  %v8f32u32 = call <8 x i32> @llvm.fptoui.sat.v8i32.v8f32(<8 x float> undef)
  %v8f32s64 = call <8 x i64> @llvm.fptosi.sat.v8i64.v8f32(<8 x float> undef)
  %v8f32u64 = call <8 x i64> @llvm.fptoui.sat.v8i64.v8f32(<8 x float> undef)

  %v8f64s1 = call <8 x i1> @llvm.fptosi.sat.v8i1.v8f64(<8 x double> undef)
  %v8f64u1 = call <8 x i1> @llvm.fptoui.sat.v8i1.v8f64(<8 x double> undef)
  %v8f64s8 = call <8 x i8> @llvm.fptosi.sat.v8i8.v8f64(<8 x double> undef)
  %v8f64u8 = call <8 x i8> @llvm.fptoui.sat.v8i8.v8f64(<8 x double> undef)
  %v8f64s16 = call <8 x i16> @llvm.fptosi.sat.v8i16.v8f64(<8 x double> undef)
  %v8f64u16 = call <8 x i16> @llvm.fptoui.sat.v8i16.v8f64(<8 x double> undef)
  %v8f64s32 = call <8 x i32> @llvm.fptosi.sat.v8i32.v8f64(<8 x double> undef)
  %v8f64u32 = call <8 x i32> @llvm.fptoui.sat.v8i32.v8f64(<8 x double> undef)
  %v8f64s64 = call <8 x i64> @llvm.fptosi.sat.v8i64.v8f64(<8 x double> undef)
  %v8f64u64 = call <8 x i64> @llvm.fptoui.sat.v8i64.v8f64(<8 x double> undef)

  %v16f32s1 = call <16 x i1> @llvm.fptosi.sat.v16i1.v16f32(<16 x float> undef)
  %v16f32u1 = call <16 x i1> @llvm.fptoui.sat.v16i1.v16f32(<16 x float> undef)
  %v16f32s8 = call <16 x i8> @llvm.fptosi.sat.v16i8.v16f32(<16 x float> undef)
  %v16f32u8 = call <16 x i8> @llvm.fptoui.sat.v16i8.v16f32(<16 x float> undef)
  %v16f32s16 = call <16 x i16> @llvm.fptosi.sat.v16i16.v16f32(<16 x float> undef)
  %v16f32u16 = call <16 x i16> @llvm.fptoui.sat.v16i16.v16f32(<16 x float> undef)
  %v16f32s32 = call <16 x i32> @llvm.fptosi.sat.v16i32.v16f32(<16 x float> undef)
  %v16f32u32 = call <16 x i32> @llvm.fptoui.sat.v16i32.v16f32(<16 x float> undef)
  %v16f32s64 = call <16 x i64> @llvm.fptosi.sat.v16i64.v16f32(<16 x float> undef)
  %v16f32u64 = call <16 x i64> @llvm.fptoui.sat.v16i64.v16f32(<16 x float> undef)

  %v16f64s1 = call <16 x i1> @llvm.fptosi.sat.v16i1.v16f64(<16 x double> undef)
  %v16f64u1 = call <16 x i1> @llvm.fptoui.sat.v16i1.v16f64(<16 x double> undef)
  %v16f64s8 = call <16 x i8> @llvm.fptosi.sat.v16i8.v16f64(<16 x double> undef)
  %v16f64u8 = call <16 x i8> @llvm.fptoui.sat.v16i8.v16f64(<16 x double> undef)
  %v16f64s16 = call <16 x i16> @llvm.fptosi.sat.v16i16.v16f64(<16 x double> undef)
  %v16f64u16 = call <16 x i16> @llvm.fptoui.sat.v16i16.v16f64(<16 x double> undef)
  %v16f64s32 = call <16 x i32> @llvm.fptosi.sat.v16i32.v16f64(<16 x double> undef)
  %v16f64u32 = call <16 x i32> @llvm.fptoui.sat.v16i32.v16f64(<16 x double> undef)
  %v16f64s64 = call <16 x i64> @llvm.fptosi.sat.v16i64.v16f64(<16 x double> undef)
  %v16f64u64 = call <16 x i64> @llvm.fptoui.sat.v16i64.v16f64(<16 x double> undef)

  ret void
}

define void @fp16() {
; SSE2-LABEL: 'fp16'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f16s1 = call i1 @llvm.fptosi.sat.i1.f16(half undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %f16u1 = call i1 @llvm.fptoui.sat.i1.f16(half undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f16s8 = call i8 @llvm.fptosi.sat.i8.f16(half undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %f16u8 = call i8 @llvm.fptoui.sat.i8.f16(half undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f16s16 = call i16 @llvm.fptosi.sat.i16.f16(half undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %f16u16 = call i16 @llvm.fptoui.sat.i16.f16(half undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f16s32 = call i32 @llvm.fptosi.sat.i32.f16(half undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %f16u32 = call i32 @llvm.fptoui.sat.i32.f16(half undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f16s64 = call i64 @llvm.fptosi.sat.i64.f16(half undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %f16u64 = call i64 @llvm.fptoui.sat.i64.f16(half undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %v2f16s1 = call <2 x i1> @llvm.fptosi.sat.v2i1.v2f16(<2 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v2f16u1 = call <2 x i1> @llvm.fptoui.sat.v2i1.v2f16(<2 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %v2f16s8 = call <2 x i8> @llvm.fptosi.sat.v2i8.v2f16(<2 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %v2f16u8 = call <2 x i8> @llvm.fptoui.sat.v2i8.v2f16(<2 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v2f16s16 = call <2 x i16> @llvm.fptosi.sat.v2i16.v2f16(<2 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v2f16u16 = call <2 x i16> @llvm.fptoui.sat.v2i16.v2f16(<2 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %v2f16s32 = call <2 x i32> @llvm.fptosi.sat.v2i32.v2f16(<2 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v2f16u32 = call <2 x i32> @llvm.fptoui.sat.v2i32.v2f16(<2 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %v2f16s64 = call <2 x i64> @llvm.fptosi.sat.v2i64.v2f16(<2 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v2f16u64 = call <2 x i64> @llvm.fptoui.sat.v2i64.v2f16(<2 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 29 for instruction: %v4f16s1 = call <4 x i1> @llvm.fptosi.sat.v4i1.v4f16(<4 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %v4f16u1 = call <4 x i1> @llvm.fptoui.sat.v4i1.v4f16(<4 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %v4f16s8 = call <4 x i8> @llvm.fptosi.sat.v4i8.v4f16(<4 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %v4f16u8 = call <4 x i8> @llvm.fptoui.sat.v4i8.v4f16(<4 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %v4f16s16 = call <4 x i16> @llvm.fptosi.sat.v4i16.v4f16(<4 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %v4f16u16 = call <4 x i16> @llvm.fptoui.sat.v4i16.v4f16(<4 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 29 for instruction: %v4f16s32 = call <4 x i32> @llvm.fptosi.sat.v4i32.v4f16(<4 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %v4f16u32 = call <4 x i32> @llvm.fptoui.sat.v4i32.v4f16(<4 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 30 for instruction: %v4f16s64 = call <4 x i64> @llvm.fptosi.sat.v4i64.v4f16(<4 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %v4f16u64 = call <4 x i64> @llvm.fptoui.sat.v4i64.v4f16(<4 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %v8f16s1 = call <8 x i1> @llvm.fptosi.sat.v8i1.v8f16(<8 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 82 for instruction: %v8f16u1 = call <8 x i1> @llvm.fptoui.sat.v8i1.v8f16(<8 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %v8f16s8 = call <8 x i8> @llvm.fptosi.sat.v8i8.v8f16(<8 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 79 for instruction: %v8f16u8 = call <8 x i8> @llvm.fptoui.sat.v8i8.v8f16(<8 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 95 for instruction: %v8f16s16 = call <8 x i16> @llvm.fptosi.sat.v8i16.v8f16(<8 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 78 for instruction: %v8f16u16 = call <8 x i16> @llvm.fptoui.sat.v8i16.v8f16(<8 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 92 for instruction: %v8f16s32 = call <8 x i32> @llvm.fptosi.sat.v8i32.v8f16(<8 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 73 for instruction: %v8f16u32 = call <8 x i32> @llvm.fptoui.sat.v8i32.v8f16(<8 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 94 for instruction: %v8f16s64 = call <8 x i64> @llvm.fptosi.sat.v8i64.v8f16(<8 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 71 for instruction: %v8f16u64 = call <8 x i64> @llvm.fptoui.sat.v8i64.v8f16(<8 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 197 for instruction: %v16f16s1 = call <16 x i1> @llvm.fptosi.sat.v16i1.v16f16(<16 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 165 for instruction: %v16f16u1 = call <16 x i1> @llvm.fptoui.sat.v16i1.v16f16(<16 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 185 for instruction: %v16f16s8 = call <16 x i8> @llvm.fptosi.sat.v16i8.v16f16(<16 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 153 for instruction: %v16f16u8 = call <16 x i8> @llvm.fptoui.sat.v16i8.v16f16(<16 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 190 for instruction: %v16f16s16 = call <16 x i16> @llvm.fptosi.sat.v16i16.v16f16(<16 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 156 for instruction: %v16f16u16 = call <16 x i16> @llvm.fptoui.sat.v16i16.v16f16(<16 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 184 for instruction: %v16f16s32 = call <16 x i32> @llvm.fptosi.sat.v16i32.v16f16(<16 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 146 for instruction: %v16f16u32 = call <16 x i32> @llvm.fptoui.sat.v16i32.v16f16(<16 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 188 for instruction: %v16f16s64 = call <16 x i64> @llvm.fptosi.sat.v16i64.v16f16(<16 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 142 for instruction: %v16f16u64 = call <16 x i64> @llvm.fptoui.sat.v16i64.v16f16(<16 x half> undef)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SSE42-LABEL: 'fp16'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f16s1 = call i1 @llvm.fptosi.sat.i1.f16(half undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %f16u1 = call i1 @llvm.fptoui.sat.i1.f16(half undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f16s8 = call i8 @llvm.fptosi.sat.i8.f16(half undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %f16u8 = call i8 @llvm.fptoui.sat.i8.f16(half undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f16s16 = call i16 @llvm.fptosi.sat.i16.f16(half undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %f16u16 = call i16 @llvm.fptoui.sat.i16.f16(half undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f16s32 = call i32 @llvm.fptosi.sat.i32.f16(half undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %f16u32 = call i32 @llvm.fptoui.sat.i32.f16(half undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f16s64 = call i64 @llvm.fptosi.sat.i64.f16(half undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %f16u64 = call i64 @llvm.fptoui.sat.i64.f16(half undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %v2f16s1 = call <2 x i1> @llvm.fptosi.sat.v2i1.v2f16(<2 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v2f16u1 = call <2 x i1> @llvm.fptoui.sat.v2i1.v2f16(<2 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %v2f16s8 = call <2 x i8> @llvm.fptosi.sat.v2i8.v2f16(<2 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %v2f16u8 = call <2 x i8> @llvm.fptoui.sat.v2i8.v2f16(<2 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v2f16s16 = call <2 x i16> @llvm.fptosi.sat.v2i16.v2f16(<2 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v2f16u16 = call <2 x i16> @llvm.fptoui.sat.v2i16.v2f16(<2 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %v2f16s32 = call <2 x i32> @llvm.fptosi.sat.v2i32.v2f16(<2 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v2f16u32 = call <2 x i32> @llvm.fptoui.sat.v2i32.v2f16(<2 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %v2f16s64 = call <2 x i64> @llvm.fptosi.sat.v2i64.v2f16(<2 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v2f16u64 = call <2 x i64> @llvm.fptoui.sat.v2i64.v2f16(<2 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 29 for instruction: %v4f16s1 = call <4 x i1> @llvm.fptosi.sat.v4i1.v4f16(<4 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %v4f16u1 = call <4 x i1> @llvm.fptoui.sat.v4i1.v4f16(<4 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 31 for instruction: %v4f16s8 = call <4 x i8> @llvm.fptosi.sat.v4i8.v4f16(<4 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %v4f16u8 = call <4 x i8> @llvm.fptoui.sat.v4i8.v4f16(<4 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 31 for instruction: %v4f16s16 = call <4 x i16> @llvm.fptosi.sat.v4i16.v4f16(<4 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %v4f16u16 = call <4 x i16> @llvm.fptoui.sat.v4i16.v4f16(<4 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 29 for instruction: %v4f16s32 = call <4 x i32> @llvm.fptosi.sat.v4i32.v4f16(<4 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %v4f16u32 = call <4 x i32> @llvm.fptoui.sat.v4i32.v4f16(<4 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 30 for instruction: %v4f16s64 = call <4 x i64> @llvm.fptosi.sat.v4i64.v4f16(<4 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %v4f16u64 = call <4 x i64> @llvm.fptoui.sat.v4i64.v4f16(<4 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %v8f16s1 = call <8 x i1> @llvm.fptosi.sat.v8i1.v8f16(<8 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 82 for instruction: %v8f16u1 = call <8 x i1> @llvm.fptoui.sat.v8i1.v8f16(<8 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 94 for instruction: %v8f16s8 = call <8 x i8> @llvm.fptosi.sat.v8i8.v8f16(<8 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 77 for instruction: %v8f16u8 = call <8 x i8> @llvm.fptoui.sat.v8i8.v8f16(<8 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 95 for instruction: %v8f16s16 = call <8 x i16> @llvm.fptosi.sat.v8i16.v8f16(<8 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 78 for instruction: %v8f16u16 = call <8 x i16> @llvm.fptoui.sat.v8i16.v8f16(<8 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 92 for instruction: %v8f16s32 = call <8 x i32> @llvm.fptosi.sat.v8i32.v8f16(<8 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 73 for instruction: %v8f16u32 = call <8 x i32> @llvm.fptoui.sat.v8i32.v8f16(<8 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 94 for instruction: %v8f16s64 = call <8 x i64> @llvm.fptosi.sat.v8i64.v8f16(<8 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 71 for instruction: %v8f16u64 = call <8 x i64> @llvm.fptoui.sat.v8i64.v8f16(<8 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 197 for instruction: %v16f16s1 = call <16 x i1> @llvm.fptosi.sat.v16i1.v16f16(<16 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 165 for instruction: %v16f16u1 = call <16 x i1> @llvm.fptoui.sat.v16i1.v16f16(<16 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 185 for instruction: %v16f16s8 = call <16 x i8> @llvm.fptosi.sat.v16i8.v16f16(<16 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 153 for instruction: %v16f16u8 = call <16 x i8> @llvm.fptoui.sat.v16i8.v16f16(<16 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 190 for instruction: %v16f16s16 = call <16 x i16> @llvm.fptosi.sat.v16i16.v16f16(<16 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 156 for instruction: %v16f16u16 = call <16 x i16> @llvm.fptoui.sat.v16i16.v16f16(<16 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 184 for instruction: %v16f16s32 = call <16 x i32> @llvm.fptosi.sat.v16i32.v16f16(<16 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 146 for instruction: %v16f16u32 = call <16 x i32> @llvm.fptoui.sat.v16i32.v16f16(<16 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 188 for instruction: %v16f16s64 = call <16 x i64> @llvm.fptosi.sat.v16i64.v16f16(<16 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 142 for instruction: %v16f16u64 = call <16 x i64> @llvm.fptoui.sat.v16i64.v16f16(<16 x half> undef)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX2-LABEL: 'fp16'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f16s1 = call i1 @llvm.fptosi.sat.i1.f16(half undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %f16u1 = call i1 @llvm.fptoui.sat.i1.f16(half undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f16s8 = call i8 @llvm.fptosi.sat.i8.f16(half undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %f16u8 = call i8 @llvm.fptoui.sat.i8.f16(half undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f16s16 = call i16 @llvm.fptosi.sat.i16.f16(half undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %f16u16 = call i16 @llvm.fptoui.sat.i16.f16(half undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f16s32 = call i32 @llvm.fptosi.sat.i32.f16(half undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %f16u32 = call i32 @llvm.fptoui.sat.i32.f16(half undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f16s64 = call i64 @llvm.fptosi.sat.i64.f16(half undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %f16u64 = call i64 @llvm.fptoui.sat.i64.f16(half undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %v2f16s1 = call <2 x i1> @llvm.fptosi.sat.v2i1.v2f16(<2 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v2f16u1 = call <2 x i1> @llvm.fptoui.sat.v2i1.v2f16(<2 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v2f16s8 = call <2 x i8> @llvm.fptosi.sat.v2i8.v2f16(<2 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v2f16u8 = call <2 x i8> @llvm.fptoui.sat.v2i8.v2f16(<2 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v2f16s16 = call <2 x i16> @llvm.fptosi.sat.v2i16.v2f16(<2 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v2f16u16 = call <2 x i16> @llvm.fptoui.sat.v2i16.v2f16(<2 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %v2f16s32 = call <2 x i32> @llvm.fptosi.sat.v2i32.v2f16(<2 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v2f16u32 = call <2 x i32> @llvm.fptoui.sat.v2i32.v2f16(<2 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %v2f16s64 = call <2 x i64> @llvm.fptosi.sat.v2i64.v2f16(<2 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v2f16u64 = call <2 x i64> @llvm.fptoui.sat.v2i64.v2f16(<2 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 29 for instruction: %v4f16s1 = call <4 x i1> @llvm.fptosi.sat.v4i1.v4f16(<4 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %v4f16u1 = call <4 x i1> @llvm.fptoui.sat.v4i1.v4f16(<4 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 30 for instruction: %v4f16s8 = call <4 x i8> @llvm.fptosi.sat.v4i8.v4f16(<4 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %v4f16u8 = call <4 x i8> @llvm.fptoui.sat.v4i8.v4f16(<4 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 30 for instruction: %v4f16s16 = call <4 x i16> @llvm.fptosi.sat.v4i16.v4f16(<4 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %v4f16u16 = call <4 x i16> @llvm.fptoui.sat.v4i16.v4f16(<4 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 29 for instruction: %v4f16s32 = call <4 x i32> @llvm.fptosi.sat.v4i32.v4f16(<4 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %v4f16u32 = call <4 x i32> @llvm.fptoui.sat.v4i32.v4f16(<4 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 29 for instruction: %v4f16s64 = call <4 x i64> @llvm.fptosi.sat.v4i64.v4f16(<4 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %v4f16u64 = call <4 x i64> @llvm.fptoui.sat.v4i64.v4f16(<4 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 76 for instruction: %v8f16s1 = call <8 x i1> @llvm.fptosi.sat.v8i1.v8f16(<8 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %v8f16u1 = call <8 x i1> @llvm.fptoui.sat.v8i1.v8f16(<8 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 105 for instruction: %v8f16s8 = call <8 x i8> @llvm.fptosi.sat.v8i8.v8f16(<8 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 88 for instruction: %v8f16u8 = call <8 x i8> @llvm.fptoui.sat.v8i8.v8f16(<8 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 103 for instruction: %v8f16s16 = call <8 x i16> @llvm.fptosi.sat.v8i16.v8f16(<8 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 86 for instruction: %v8f16u16 = call <8 x i16> @llvm.fptoui.sat.v8i16.v8f16(<8 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 101 for instruction: %v8f16s32 = call <8 x i32> @llvm.fptosi.sat.v8i32.v8f16(<8 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 84 for instruction: %v8f16u32 = call <8 x i32> @llvm.fptoui.sat.v8i32.v8f16(<8 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 92 for instruction: %v8f16s64 = call <8 x i64> @llvm.fptosi.sat.v8i64.v8f16(<8 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 73 for instruction: %v8f16u64 = call <8 x i64> @llvm.fptoui.sat.v8i64.v8f16(<8 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 203 for instruction: %v16f16s1 = call <16 x i1> @llvm.fptosi.sat.v16i1.v16f16(<16 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 170 for instruction: %v16f16u1 = call <16 x i1> @llvm.fptoui.sat.v16i1.v16f16(<16 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 212 for instruction: %v16f16s8 = call <16 x i8> @llvm.fptosi.sat.v16i8.v16f16(<16 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 179 for instruction: %v16f16u8 = call <16 x i8> @llvm.fptoui.sat.v16i8.v16f16(<16 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 212 for instruction: %v16f16s16 = call <16 x i16> @llvm.fptosi.sat.v16i16.v16f16(<16 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 179 for instruction: %v16f16u16 = call <16 x i16> @llvm.fptoui.sat.v16i16.v16f16(<16 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 210 for instruction: %v16f16s32 = call <16 x i32> @llvm.fptosi.sat.v16i32.v16f16(<16 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 175 for instruction: %v16f16u32 = call <16 x i32> @llvm.fptoui.sat.v16i32.v16f16(<16 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %v16f16s64 = call <16 x i64> @llvm.fptosi.sat.v16i64.v16f16(<16 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 153 for instruction: %v16f16u64 = call <16 x i64> @llvm.fptoui.sat.v16i64.v16f16(<16 x half> undef)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512F-LABEL: 'fp16'
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f16s1 = call i1 @llvm.fptosi.sat.i1.f16(half undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %f16u1 = call i1 @llvm.fptoui.sat.i1.f16(half undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f16s8 = call i8 @llvm.fptosi.sat.i8.f16(half undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %f16u8 = call i8 @llvm.fptoui.sat.i8.f16(half undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f16s16 = call i16 @llvm.fptosi.sat.i16.f16(half undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %f16u16 = call i16 @llvm.fptoui.sat.i16.f16(half undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f16s32 = call i32 @llvm.fptosi.sat.i32.f16(half undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %f16u32 = call i32 @llvm.fptoui.sat.i32.f16(half undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f16s64 = call i64 @llvm.fptosi.sat.i64.f16(half undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %f16u64 = call i64 @llvm.fptoui.sat.i64.f16(half undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %v2f16s1 = call <2 x i1> @llvm.fptosi.sat.v2i1.v2f16(<2 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v2f16u1 = call <2 x i1> @llvm.fptoui.sat.v2i1.v2f16(<2 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %v2f16s8 = call <2 x i8> @llvm.fptosi.sat.v2i8.v2f16(<2 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %v2f16u8 = call <2 x i8> @llvm.fptoui.sat.v2i8.v2f16(<2 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v2f16s16 = call <2 x i16> @llvm.fptosi.sat.v2i16.v2f16(<2 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v2f16u16 = call <2 x i16> @llvm.fptoui.sat.v2i16.v2f16(<2 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %v2f16s32 = call <2 x i32> @llvm.fptosi.sat.v2i32.v2f16(<2 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v2f16u32 = call <2 x i32> @llvm.fptoui.sat.v2i32.v2f16(<2 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %v2f16s64 = call <2 x i64> @llvm.fptosi.sat.v2i64.v2f16(<2 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v2f16u64 = call <2 x i64> @llvm.fptoui.sat.v2i64.v2f16(<2 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 42 for instruction: %v4f16s1 = call <4 x i1> @llvm.fptosi.sat.v4i1.v4f16(<4 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 27 for instruction: %v4f16u1 = call <4 x i1> @llvm.fptoui.sat.v4i1.v4f16(<4 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 37 for instruction: %v4f16s8 = call <4 x i8> @llvm.fptosi.sat.v4i8.v4f16(<4 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 29 for instruction: %v4f16u8 = call <4 x i8> @llvm.fptoui.sat.v4i8.v4f16(<4 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %v4f16s16 = call <4 x i16> @llvm.fptosi.sat.v4i16.v4f16(<4 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %v4f16u16 = call <4 x i16> @llvm.fptoui.sat.v4i16.v4f16(<4 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 35 for instruction: %v4f16s32 = call <4 x i32> @llvm.fptosi.sat.v4i32.v4f16(<4 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 27 for instruction: %v4f16u32 = call <4 x i32> @llvm.fptoui.sat.v4i32.v4f16(<4 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %v4f16s64 = call <4 x i64> @llvm.fptosi.sat.v4i64.v4f16(<4 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %v4f16u64 = call <4 x i64> @llvm.fptoui.sat.v4i64.v4f16(<4 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 90 for instruction: %v8f16s1 = call <8 x i1> @llvm.fptosi.sat.v8i1.v8f16(<8 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %v8f16u1 = call <8 x i1> @llvm.fptoui.sat.v8i1.v8f16(<8 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 102 for instruction: %v8f16s8 = call <8 x i8> @llvm.fptosi.sat.v8i8.v8f16(<8 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 86 for instruction: %v8f16u8 = call <8 x i8> @llvm.fptoui.sat.v8i8.v8f16(<8 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 102 for instruction: %v8f16s16 = call <8 x i16> @llvm.fptosi.sat.v8i16.v8f16(<8 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 86 for instruction: %v8f16u16 = call <8 x i16> @llvm.fptoui.sat.v8i16.v8f16(<8 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 100 for instruction: %v8f16s32 = call <8 x i32> @llvm.fptosi.sat.v8i32.v8f16(<8 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 84 for instruction: %v8f16u32 = call <8 x i32> @llvm.fptoui.sat.v8i32.v8f16(<8 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 104 for instruction: %v8f16s64 = call <8 x i64> @llvm.fptosi.sat.v8i64.v8f16(<8 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 88 for instruction: %v8f16u64 = call <8 x i64> @llvm.fptoui.sat.v8i64.v8f16(<8 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 186 for instruction: %v16f16s1 = call <16 x i1> @llvm.fptosi.sat.v16i1.v16f16(<16 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 123 for instruction: %v16f16u1 = call <16 x i1> @llvm.fptoui.sat.v16i1.v16f16(<16 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 210 for instruction: %v16f16s8 = call <16 x i8> @llvm.fptosi.sat.v16i8.v16f16(<16 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 178 for instruction: %v16f16u8 = call <16 x i8> @llvm.fptoui.sat.v16i8.v16f16(<16 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 210 for instruction: %v16f16s16 = call <16 x i16> @llvm.fptosi.sat.v16i16.v16f16(<16 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 178 for instruction: %v16f16u16 = call <16 x i16> @llvm.fptoui.sat.v16i16.v16f16(<16 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 208 for instruction: %v16f16s32 = call <16 x i32> @llvm.fptosi.sat.v16i32.v16f16(<16 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 176 for instruction: %v16f16u32 = call <16 x i32> @llvm.fptoui.sat.v16i32.v16f16(<16 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 216 for instruction: %v16f16s64 = call <16 x i64> @llvm.fptosi.sat.v16i64.v16f16(<16 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 183 for instruction: %v16f16u64 = call <16 x i64> @llvm.fptoui.sat.v16i64.v16f16(<16 x half> undef)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512DQ-LABEL: 'fp16'
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f16s1 = call i1 @llvm.fptosi.sat.i1.f16(half undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %f16u1 = call i1 @llvm.fptoui.sat.i1.f16(half undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f16s8 = call i8 @llvm.fptosi.sat.i8.f16(half undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %f16u8 = call i8 @llvm.fptoui.sat.i8.f16(half undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f16s16 = call i16 @llvm.fptosi.sat.i16.f16(half undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %f16u16 = call i16 @llvm.fptoui.sat.i16.f16(half undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f16s32 = call i32 @llvm.fptosi.sat.i32.f16(half undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %f16u32 = call i32 @llvm.fptoui.sat.i32.f16(half undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f16s64 = call i64 @llvm.fptosi.sat.i64.f16(half undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %f16u64 = call i64 @llvm.fptoui.sat.i64.f16(half undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %v2f16s1 = call <2 x i1> @llvm.fptosi.sat.v2i1.v2f16(<2 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v2f16u1 = call <2 x i1> @llvm.fptoui.sat.v2i1.v2f16(<2 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %v2f16s8 = call <2 x i8> @llvm.fptosi.sat.v2i8.v2f16(<2 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %v2f16u8 = call <2 x i8> @llvm.fptoui.sat.v2i8.v2f16(<2 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v2f16s16 = call <2 x i16> @llvm.fptosi.sat.v2i16.v2f16(<2 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v2f16u16 = call <2 x i16> @llvm.fptoui.sat.v2i16.v2f16(<2 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %v2f16s32 = call <2 x i32> @llvm.fptosi.sat.v2i32.v2f16(<2 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v2f16u32 = call <2 x i32> @llvm.fptoui.sat.v2i32.v2f16(<2 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %v2f16s64 = call <2 x i64> @llvm.fptosi.sat.v2i64.v2f16(<2 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v2f16u64 = call <2 x i64> @llvm.fptoui.sat.v2i64.v2f16(<2 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 42 for instruction: %v4f16s1 = call <4 x i1> @llvm.fptosi.sat.v4i1.v4f16(<4 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 27 for instruction: %v4f16u1 = call <4 x i1> @llvm.fptoui.sat.v4i1.v4f16(<4 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 37 for instruction: %v4f16s8 = call <4 x i8> @llvm.fptosi.sat.v4i8.v4f16(<4 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 29 for instruction: %v4f16u8 = call <4 x i8> @llvm.fptoui.sat.v4i8.v4f16(<4 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %v4f16s16 = call <4 x i16> @llvm.fptosi.sat.v4i16.v4f16(<4 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %v4f16u16 = call <4 x i16> @llvm.fptoui.sat.v4i16.v4f16(<4 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 35 for instruction: %v4f16s32 = call <4 x i32> @llvm.fptosi.sat.v4i32.v4f16(<4 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 27 for instruction: %v4f16u32 = call <4 x i32> @llvm.fptoui.sat.v4i32.v4f16(<4 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %v4f16s64 = call <4 x i64> @llvm.fptosi.sat.v4i64.v4f16(<4 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %v4f16u64 = call <4 x i64> @llvm.fptoui.sat.v4i64.v4f16(<4 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 90 for instruction: %v8f16s1 = call <8 x i1> @llvm.fptosi.sat.v8i1.v8f16(<8 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %v8f16u1 = call <8 x i1> @llvm.fptoui.sat.v8i1.v8f16(<8 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 102 for instruction: %v8f16s8 = call <8 x i8> @llvm.fptosi.sat.v8i8.v8f16(<8 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 86 for instruction: %v8f16u8 = call <8 x i8> @llvm.fptoui.sat.v8i8.v8f16(<8 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 102 for instruction: %v8f16s16 = call <8 x i16> @llvm.fptosi.sat.v8i16.v8f16(<8 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 86 for instruction: %v8f16u16 = call <8 x i16> @llvm.fptoui.sat.v8i16.v8f16(<8 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 100 for instruction: %v8f16s32 = call <8 x i32> @llvm.fptosi.sat.v8i32.v8f16(<8 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 84 for instruction: %v8f16u32 = call <8 x i32> @llvm.fptoui.sat.v8i32.v8f16(<8 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 104 for instruction: %v8f16s64 = call <8 x i64> @llvm.fptosi.sat.v8i64.v8f16(<8 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 88 for instruction: %v8f16u64 = call <8 x i64> @llvm.fptoui.sat.v8i64.v8f16(<8 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 186 for instruction: %v16f16s1 = call <16 x i1> @llvm.fptosi.sat.v16i1.v16f16(<16 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 123 for instruction: %v16f16u1 = call <16 x i1> @llvm.fptoui.sat.v16i1.v16f16(<16 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 210 for instruction: %v16f16s8 = call <16 x i8> @llvm.fptosi.sat.v16i8.v16f16(<16 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 178 for instruction: %v16f16u8 = call <16 x i8> @llvm.fptoui.sat.v16i8.v16f16(<16 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 210 for instruction: %v16f16s16 = call <16 x i16> @llvm.fptosi.sat.v16i16.v16f16(<16 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 178 for instruction: %v16f16u16 = call <16 x i16> @llvm.fptoui.sat.v16i16.v16f16(<16 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 208 for instruction: %v16f16s32 = call <16 x i32> @llvm.fptosi.sat.v16i32.v16f16(<16 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 176 for instruction: %v16f16u32 = call <16 x i32> @llvm.fptoui.sat.v16i32.v16f16(<16 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 216 for instruction: %v16f16s64 = call <16 x i64> @llvm.fptosi.sat.v16i64.v16f16(<16 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 183 for instruction: %v16f16u64 = call <16 x i64> @llvm.fptoui.sat.v16i64.v16f16(<16 x half> undef)
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SLM-LABEL: 'fp16'
; SLM-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f16s1 = call i1 @llvm.fptosi.sat.i1.f16(half undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %f16u1 = call i1 @llvm.fptoui.sat.i1.f16(half undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f16s8 = call i8 @llvm.fptosi.sat.i8.f16(half undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %f16u8 = call i8 @llvm.fptoui.sat.i8.f16(half undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f16s16 = call i16 @llvm.fptosi.sat.i16.f16(half undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %f16u16 = call i16 @llvm.fptoui.sat.i16.f16(half undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f16s32 = call i32 @llvm.fptosi.sat.i32.f16(half undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %f16u32 = call i32 @llvm.fptoui.sat.i32.f16(half undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %f16s64 = call i64 @llvm.fptosi.sat.i64.f16(half undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %f16u64 = call i64 @llvm.fptoui.sat.i64.f16(half undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %v2f16s1 = call <2 x i1> @llvm.fptosi.sat.v2i1.v2f16(<2 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v2f16u1 = call <2 x i1> @llvm.fptoui.sat.v2i1.v2f16(<2 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %v2f16s8 = call <2 x i8> @llvm.fptosi.sat.v2i8.v2f16(<2 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %v2f16u8 = call <2 x i8> @llvm.fptoui.sat.v2i8.v2f16(<2 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %v2f16s16 = call <2 x i16> @llvm.fptosi.sat.v2i16.v2f16(<2 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v2f16u16 = call <2 x i16> @llvm.fptoui.sat.v2i16.v2f16(<2 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %v2f16s32 = call <2 x i32> @llvm.fptosi.sat.v2i32.v2f16(<2 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v2f16u32 = call <2 x i32> @llvm.fptoui.sat.v2i32.v2f16(<2 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %v2f16s64 = call <2 x i64> @llvm.fptosi.sat.v2i64.v2f16(<2 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v2f16u64 = call <2 x i64> @llvm.fptoui.sat.v2i64.v2f16(<2 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 29 for instruction: %v4f16s1 = call <4 x i1> @llvm.fptosi.sat.v4i1.v4f16(<4 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %v4f16u1 = call <4 x i1> @llvm.fptoui.sat.v4i1.v4f16(<4 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %v4f16s8 = call <4 x i8> @llvm.fptosi.sat.v4i8.v4f16(<4 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %v4f16u8 = call <4 x i8> @llvm.fptoui.sat.v4i8.v4f16(<4 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %v4f16s16 = call <4 x i16> @llvm.fptosi.sat.v4i16.v4f16(<4 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %v4f16u16 = call <4 x i16> @llvm.fptoui.sat.v4i16.v4f16(<4 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 29 for instruction: %v4f16s32 = call <4 x i32> @llvm.fptosi.sat.v4i32.v4f16(<4 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %v4f16u32 = call <4 x i32> @llvm.fptoui.sat.v4i32.v4f16(<4 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %v4f16s64 = call <4 x i64> @llvm.fptosi.sat.v4i64.v4f16(<4 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %v4f16u64 = call <4 x i64> @llvm.fptoui.sat.v4i64.v4f16(<4 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 101 for instruction: %v8f16s1 = call <8 x i1> @llvm.fptosi.sat.v8i1.v8f16(<8 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 82 for instruction: %v8f16u1 = call <8 x i1> @llvm.fptoui.sat.v8i1.v8f16(<8 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %v8f16s8 = call <8 x i8> @llvm.fptosi.sat.v8i8.v8f16(<8 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 77 for instruction: %v8f16u8 = call <8 x i8> @llvm.fptoui.sat.v8i8.v8f16(<8 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 97 for instruction: %v8f16s16 = call <8 x i16> @llvm.fptosi.sat.v8i16.v8f16(<8 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 78 for instruction: %v8f16u16 = call <8 x i16> @llvm.fptoui.sat.v8i16.v8f16(<8 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 92 for instruction: %v8f16s32 = call <8 x i32> @llvm.fptosi.sat.v8i32.v8f16(<8 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 73 for instruction: %v8f16u32 = call <8 x i32> @llvm.fptoui.sat.v8i32.v8f16(<8 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 102 for instruction: %v8f16s64 = call <8 x i64> @llvm.fptosi.sat.v8i64.v8f16(<8 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 71 for instruction: %v8f16u64 = call <8 x i64> @llvm.fptoui.sat.v8i64.v8f16(<8 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 199 for instruction: %v16f16s1 = call <16 x i1> @llvm.fptosi.sat.v16i1.v16f16(<16 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 165 for instruction: %v16f16u1 = call <16 x i1> @llvm.fptoui.sat.v16i1.v16f16(<16 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 187 for instruction: %v16f16s8 = call <16 x i8> @llvm.fptosi.sat.v16i8.v16f16(<16 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 153 for instruction: %v16f16u8 = call <16 x i8> @llvm.fptoui.sat.v16i8.v16f16(<16 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 194 for instruction: %v16f16s16 = call <16 x i16> @llvm.fptosi.sat.v16i16.v16f16(<16 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 156 for instruction: %v16f16u16 = call <16 x i16> @llvm.fptoui.sat.v16i16.v16f16(<16 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 184 for instruction: %v16f16s32 = call <16 x i32> @llvm.fptosi.sat.v16i32.v16f16(<16 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 146 for instruction: %v16f16u32 = call <16 x i32> @llvm.fptoui.sat.v16i32.v16f16(<16 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 204 for instruction: %v16f16s64 = call <16 x i64> @llvm.fptosi.sat.v16i64.v16f16(<16 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 142 for instruction: %v16f16u64 = call <16 x i64> @llvm.fptoui.sat.v16i64.v16f16(<16 x half> undef)
; SLM-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %f16s1 = call i1 @llvm.fptosi.sat.i1.f16(half undef)
  %f16u1 = call i1 @llvm.fptoui.sat.i1.f16(half undef)
  %f16s8 = call i8 @llvm.fptosi.sat.i8.f16(half undef)
  %f16u8 = call i8 @llvm.fptoui.sat.i8.f16(half undef)
  %f16s16 = call i16 @llvm.fptosi.sat.i16.f16(half undef)
  %f16u16 = call i16 @llvm.fptoui.sat.i16.f16(half undef)
  %f16s32 = call i32 @llvm.fptosi.sat.i32.f16(half undef)
  %f16u32 = call i32 @llvm.fptoui.sat.i32.f16(half undef)
  %f16s64 = call i64 @llvm.fptosi.sat.i64.f16(half undef)
  %f16u64 = call i64 @llvm.fptoui.sat.i64.f16(half undef)

  %v2f16s1 = call <2 x i1> @llvm.fptosi.sat.v2i1.v2f16(<2 x half> undef)
  %v2f16u1 = call <2 x i1> @llvm.fptoui.sat.v2i1.v2f16(<2 x half> undef)
  %v2f16s8 = call <2 x i8> @llvm.fptosi.sat.v2i8.v2f16(<2 x half> undef)
  %v2f16u8 = call <2 x i8> @llvm.fptoui.sat.v2i8.v2f16(<2 x half> undef)
  %v2f16s16 = call <2 x i16> @llvm.fptosi.sat.v2i16.v2f16(<2 x half> undef)
  %v2f16u16 = call <2 x i16> @llvm.fptoui.sat.v2i16.v2f16(<2 x half> undef)
  %v2f16s32 = call <2 x i32> @llvm.fptosi.sat.v2i32.v2f16(<2 x half> undef)
  %v2f16u32 = call <2 x i32> @llvm.fptoui.sat.v2i32.v2f16(<2 x half> undef)
  %v2f16s64 = call <2 x i64> @llvm.fptosi.sat.v2i64.v2f16(<2 x half> undef)
  %v2f16u64 = call <2 x i64> @llvm.fptoui.sat.v2i64.v2f16(<2 x half> undef)

  %v4f16s1 = call <4 x i1> @llvm.fptosi.sat.v4i1.v4f16(<4 x half> undef)
  %v4f16u1 = call <4 x i1> @llvm.fptoui.sat.v4i1.v4f16(<4 x half> undef)
  %v4f16s8 = call <4 x i8> @llvm.fptosi.sat.v4i8.v4f16(<4 x half> undef)
  %v4f16u8 = call <4 x i8> @llvm.fptoui.sat.v4i8.v4f16(<4 x half> undef)
  %v4f16s16 = call <4 x i16> @llvm.fptosi.sat.v4i16.v4f16(<4 x half> undef)
  %v4f16u16 = call <4 x i16> @llvm.fptoui.sat.v4i16.v4f16(<4 x half> undef)
  %v4f16s32 = call <4 x i32> @llvm.fptosi.sat.v4i32.v4f16(<4 x half> undef)
  %v4f16u32 = call <4 x i32> @llvm.fptoui.sat.v4i32.v4f16(<4 x half> undef)
  %v4f16s64 = call <4 x i64> @llvm.fptosi.sat.v4i64.v4f16(<4 x half> undef)
  %v4f16u64 = call <4 x i64> @llvm.fptoui.sat.v4i64.v4f16(<4 x half> undef)

  %v8f16s1 = call <8 x i1> @llvm.fptosi.sat.v8i1.v8f16(<8 x half> undef)
  %v8f16u1 = call <8 x i1> @llvm.fptoui.sat.v8i1.v8f16(<8 x half> undef)
  %v8f16s8 = call <8 x i8> @llvm.fptosi.sat.v8i8.v8f16(<8 x half> undef)
  %v8f16u8 = call <8 x i8> @llvm.fptoui.sat.v8i8.v8f16(<8 x half> undef)
  %v8f16s16 = call <8 x i16> @llvm.fptosi.sat.v8i16.v8f16(<8 x half> undef)
  %v8f16u16 = call <8 x i16> @llvm.fptoui.sat.v8i16.v8f16(<8 x half> undef)
  %v8f16s32 = call <8 x i32> @llvm.fptosi.sat.v8i32.v8f16(<8 x half> undef)
  %v8f16u32 = call <8 x i32> @llvm.fptoui.sat.v8i32.v8f16(<8 x half> undef)
  %v8f16s64 = call <8 x i64> @llvm.fptosi.sat.v8i64.v8f16(<8 x half> undef)
  %v8f16u64 = call <8 x i64> @llvm.fptoui.sat.v8i64.v8f16(<8 x half> undef)

  %v16f16s1 = call <16 x i1> @llvm.fptosi.sat.v16i1.v16f16(<16 x half> undef)
  %v16f16u1 = call <16 x i1> @llvm.fptoui.sat.v16i1.v16f16(<16 x half> undef)
  %v16f16s8 = call <16 x i8> @llvm.fptosi.sat.v16i8.v16f16(<16 x half> undef)
  %v16f16u8 = call <16 x i8> @llvm.fptoui.sat.v16i8.v16f16(<16 x half> undef)
  %v16f16s16 = call <16 x i16> @llvm.fptosi.sat.v16i16.v16f16(<16 x half> undef)
  %v16f16u16 = call <16 x i16> @llvm.fptoui.sat.v16i16.v16f16(<16 x half> undef)
  %v16f16s32 = call <16 x i32> @llvm.fptosi.sat.v16i32.v16f16(<16 x half> undef)
  %v16f16u32 = call <16 x i32> @llvm.fptoui.sat.v16i32.v16f16(<16 x half> undef)
  %v16f16s64 = call <16 x i64> @llvm.fptosi.sat.v16i64.v16f16(<16 x half> undef)
  %v16f16u64 = call <16 x i64> @llvm.fptoui.sat.v16i64.v16f16(<16 x half> undef)

  ret void
}


declare i1 @llvm.fptosi.sat.i1.f32(float)
declare i1 @llvm.fptoui.sat.i1.f32(float)
declare i8 @llvm.fptosi.sat.i8.f32(float)
declare i8 @llvm.fptoui.sat.i8.f32(float)
declare i16 @llvm.fptosi.sat.i16.f32(float)
declare i16 @llvm.fptoui.sat.i16.f32(float)
declare i32 @llvm.fptosi.sat.i32.f32(float)
declare i32 @llvm.fptoui.sat.i32.f32(float)
declare i64 @llvm.fptosi.sat.i64.f32(float)
declare i64 @llvm.fptoui.sat.i64.f32(float)

declare i1 @llvm.fptosi.sat.i1.f64(double)
declare i1 @llvm.fptoui.sat.i1.f64(double)
declare i8 @llvm.fptosi.sat.i8.f64(double)
declare i8 @llvm.fptoui.sat.i8.f64(double)
declare i16 @llvm.fptosi.sat.i16.f64(double)
declare i16 @llvm.fptoui.sat.i16.f64(double)
declare i32 @llvm.fptosi.sat.i32.f64(double)
declare i32 @llvm.fptoui.sat.i32.f64(double)
declare i64 @llvm.fptosi.sat.i64.f64(double)
declare i64 @llvm.fptoui.sat.i64.f64(double)

declare <2 x i1> @llvm.fptosi.sat.v2i1.v2f32(<2 x float>)
declare <2 x i1> @llvm.fptoui.sat.v2i1.v2f32(<2 x float>)
declare <2 x i8> @llvm.fptosi.sat.v2i8.v2f32(<2 x float>)
declare <2 x i8> @llvm.fptoui.sat.v2i8.v2f32(<2 x float>)
declare <2 x i16> @llvm.fptosi.sat.v2i16.v2f32(<2 x float>)
declare <2 x i16> @llvm.fptoui.sat.v2i16.v2f32(<2 x float>)
declare <2 x i32> @llvm.fptosi.sat.v2i32.v2f32(<2 x float>)
declare <2 x i32> @llvm.fptoui.sat.v2i32.v2f32(<2 x float>)
declare <2 x i64> @llvm.fptosi.sat.v2i64.v2f32(<2 x float>)
declare <2 x i64> @llvm.fptoui.sat.v2i64.v2f32(<2 x float>)

declare <2 x i1> @llvm.fptosi.sat.v2i1.v2f64(<2 x double>)
declare <2 x i1> @llvm.fptoui.sat.v2i1.v2f64(<2 x double>)
declare <2 x i8> @llvm.fptosi.sat.v2i8.v2f64(<2 x double>)
declare <2 x i8> @llvm.fptoui.sat.v2i8.v2f64(<2 x double>)
declare <2 x i16> @llvm.fptosi.sat.v2i16.v2f64(<2 x double>)
declare <2 x i16> @llvm.fptoui.sat.v2i16.v2f64(<2 x double>)
declare <2 x i32> @llvm.fptosi.sat.v2i32.v2f64(<2 x double>)
declare <2 x i32> @llvm.fptoui.sat.v2i32.v2f64(<2 x double>)
declare <2 x i64> @llvm.fptosi.sat.v2i64.v2f64(<2 x double>)
declare <2 x i64> @llvm.fptoui.sat.v2i64.v2f64(<2 x double>)

declare <4 x i1> @llvm.fptosi.sat.v4i1.v4f32(<4 x float>)
declare <4 x i1> @llvm.fptoui.sat.v4i1.v4f32(<4 x float>)
declare <4 x i8> @llvm.fptosi.sat.v4i8.v4f32(<4 x float>)
declare <4 x i8> @llvm.fptoui.sat.v4i8.v4f32(<4 x float>)
declare <4 x i16> @llvm.fptosi.sat.v4i16.v4f32(<4 x float>)
declare <4 x i16> @llvm.fptoui.sat.v4i16.v4f32(<4 x float>)
declare <4 x i32> @llvm.fptosi.sat.v4i32.v4f32(<4 x float>)
declare <4 x i32> @llvm.fptoui.sat.v4i32.v4f32(<4 x float>)
declare <4 x i64> @llvm.fptosi.sat.v4i64.v4f32(<4 x float>)
declare <4 x i64> @llvm.fptoui.sat.v4i64.v4f32(<4 x float>)

declare <4 x i1> @llvm.fptosi.sat.v4i1.v4f64(<4 x double>)
declare <4 x i1> @llvm.fptoui.sat.v4i1.v4f64(<4 x double>)
declare <4 x i8> @llvm.fptosi.sat.v4i8.v4f64(<4 x double>)
declare <4 x i8> @llvm.fptoui.sat.v4i8.v4f64(<4 x double>)
declare <4 x i16> @llvm.fptosi.sat.v4i16.v4f64(<4 x double>)
declare <4 x i16> @llvm.fptoui.sat.v4i16.v4f64(<4 x double>)
declare <4 x i32> @llvm.fptosi.sat.v4i32.v4f64(<4 x double>)
declare <4 x i32> @llvm.fptoui.sat.v4i32.v4f64(<4 x double>)
declare <4 x i64> @llvm.fptosi.sat.v4i64.v4f64(<4 x double>)
declare <4 x i64> @llvm.fptoui.sat.v4i64.v4f64(<4 x double>)

declare <8 x i1> @llvm.fptosi.sat.v8i1.v8f32(<8 x float>)
declare <8 x i1> @llvm.fptoui.sat.v8i1.v8f32(<8 x float>)
declare <8 x i8> @llvm.fptosi.sat.v8i8.v8f32(<8 x float>)
declare <8 x i8> @llvm.fptoui.sat.v8i8.v8f32(<8 x float>)
declare <8 x i16> @llvm.fptosi.sat.v8i16.v8f32(<8 x float>)
declare <8 x i16> @llvm.fptoui.sat.v8i16.v8f32(<8 x float>)
declare <8 x i32> @llvm.fptosi.sat.v8i32.v8f32(<8 x float>)
declare <8 x i32> @llvm.fptoui.sat.v8i32.v8f32(<8 x float>)
declare <8 x i64> @llvm.fptosi.sat.v8i64.v8f32(<8 x float>)
declare <8 x i64> @llvm.fptoui.sat.v8i64.v8f32(<8 x float>)

declare <8 x i1> @llvm.fptosi.sat.v8i1.v8f64(<8 x double>)
declare <8 x i1> @llvm.fptoui.sat.v8i1.v8f64(<8 x double>)
declare <8 x i8> @llvm.fptosi.sat.v8i8.v8f64(<8 x double>)
declare <8 x i8> @llvm.fptoui.sat.v8i8.v8f64(<8 x double>)
declare <8 x i16> @llvm.fptosi.sat.v8i16.v8f64(<8 x double>)
declare <8 x i16> @llvm.fptoui.sat.v8i16.v8f64(<8 x double>)
declare <8 x i32> @llvm.fptosi.sat.v8i32.v8f64(<8 x double>)
declare <8 x i32> @llvm.fptoui.sat.v8i32.v8f64(<8 x double>)
declare <8 x i64> @llvm.fptosi.sat.v8i64.v8f64(<8 x double>)
declare <8 x i64> @llvm.fptoui.sat.v8i64.v8f64(<8 x double>)

declare <16 x i1> @llvm.fptosi.sat.v16i1.v16f32(<16 x float>)
declare <16 x i1> @llvm.fptoui.sat.v16i1.v16f32(<16 x float>)
declare <16 x i8> @llvm.fptosi.sat.v16i8.v16f32(<16 x float>)
declare <16 x i8> @llvm.fptoui.sat.v16i8.v16f32(<16 x float>)
declare <16 x i16> @llvm.fptosi.sat.v16i16.v16f32(<16 x float>)
declare <16 x i16> @llvm.fptoui.sat.v16i16.v16f32(<16 x float>)
declare <16 x i32> @llvm.fptosi.sat.v16i32.v16f32(<16 x float>)
declare <16 x i32> @llvm.fptoui.sat.v16i32.v16f32(<16 x float>)
declare <16 x i64> @llvm.fptosi.sat.v16i64.v16f32(<16 x float>)
declare <16 x i64> @llvm.fptoui.sat.v16i64.v16f32(<16 x float>)

declare <16 x i1> @llvm.fptosi.sat.v16i1.v16f64(<16 x double>)
declare <16 x i1> @llvm.fptoui.sat.v16i1.v16f64(<16 x double>)
declare <16 x i8> @llvm.fptosi.sat.v16i8.v16f64(<16 x double>)
declare <16 x i8> @llvm.fptoui.sat.v16i8.v16f64(<16 x double>)
declare <16 x i16> @llvm.fptosi.sat.v16i16.v16f64(<16 x double>)
declare <16 x i16> @llvm.fptoui.sat.v16i16.v16f64(<16 x double>)
declare <16 x i32> @llvm.fptosi.sat.v16i32.v16f64(<16 x double>)
declare <16 x i32> @llvm.fptoui.sat.v16i32.v16f64(<16 x double>)
declare <16 x i64> @llvm.fptosi.sat.v16i64.v16f64(<16 x double>)
declare <16 x i64> @llvm.fptoui.sat.v16i64.v16f64(<16 x double>)

declare i1 @llvm.fptosi.sat.i1.f16(half)
declare i1 @llvm.fptoui.sat.i1.f16(half)
declare i8 @llvm.fptosi.sat.i8.f16(half)
declare i8 @llvm.fptoui.sat.i8.f16(half)
declare i16 @llvm.fptosi.sat.i16.f16(half)
declare i16 @llvm.fptoui.sat.i16.f16(half)
declare i32 @llvm.fptosi.sat.i32.f16(half)
declare i32 @llvm.fptoui.sat.i32.f16(half)
declare i64 @llvm.fptosi.sat.i64.f16(half)
declare i64 @llvm.fptoui.sat.i64.f16(half)

declare <2 x i1> @llvm.fptosi.sat.v2i1.v2f16(<2 x half>)
declare <2 x i1> @llvm.fptoui.sat.v2i1.v2f16(<2 x half>)
declare <2 x i8> @llvm.fptosi.sat.v2i8.v2f16(<2 x half>)
declare <2 x i8> @llvm.fptoui.sat.v2i8.v2f16(<2 x half>)
declare <2 x i16> @llvm.fptosi.sat.v2i16.v2f16(<2 x half>)
declare <2 x i16> @llvm.fptoui.sat.v2i16.v2f16(<2 x half>)
declare <2 x i32> @llvm.fptosi.sat.v2i32.v2f16(<2 x half>)
declare <2 x i32> @llvm.fptoui.sat.v2i32.v2f16(<2 x half>)
declare <2 x i64> @llvm.fptosi.sat.v2i64.v2f16(<2 x half>)
declare <2 x i64> @llvm.fptoui.sat.v2i64.v2f16(<2 x half>)

declare <4 x i1> @llvm.fptosi.sat.v4i1.v4f16(<4 x half>)
declare <4 x i1> @llvm.fptoui.sat.v4i1.v4f16(<4 x half>)
declare <4 x i8> @llvm.fptosi.sat.v4i8.v4f16(<4 x half>)
declare <4 x i8> @llvm.fptoui.sat.v4i8.v4f16(<4 x half>)
declare <4 x i16> @llvm.fptosi.sat.v4i16.v4f16(<4 x half>)
declare <4 x i16> @llvm.fptoui.sat.v4i16.v4f16(<4 x half>)
declare <4 x i32> @llvm.fptosi.sat.v4i32.v4f16(<4 x half>)
declare <4 x i32> @llvm.fptoui.sat.v4i32.v4f16(<4 x half>)
declare <4 x i64> @llvm.fptosi.sat.v4i64.v4f16(<4 x half>)
declare <4 x i64> @llvm.fptoui.sat.v4i64.v4f16(<4 x half>)

declare <8 x i1> @llvm.fptosi.sat.v8i1.v8f16(<8 x half>)
declare <8 x i1> @llvm.fptoui.sat.v8i1.v8f16(<8 x half>)
declare <8 x i8> @llvm.fptosi.sat.v8i8.v8f16(<8 x half>)
declare <8 x i8> @llvm.fptoui.sat.v8i8.v8f16(<8 x half>)
declare <8 x i16> @llvm.fptosi.sat.v8i16.v8f16(<8 x half>)
declare <8 x i16> @llvm.fptoui.sat.v8i16.v8f16(<8 x half>)
declare <8 x i32> @llvm.fptosi.sat.v8i32.v8f16(<8 x half>)
declare <8 x i32> @llvm.fptoui.sat.v8i32.v8f16(<8 x half>)
declare <8 x i64> @llvm.fptosi.sat.v8i64.v8f16(<8 x half>)
declare <8 x i64> @llvm.fptoui.sat.v8i64.v8f16(<8 x half>)

declare <16 x i1> @llvm.fptosi.sat.v16i1.v16f16(<16 x half>)
declare <16 x i1> @llvm.fptoui.sat.v16i1.v16f16(<16 x half>)
declare <16 x i8> @llvm.fptosi.sat.v16i8.v16f16(<16 x half>)
declare <16 x i8> @llvm.fptoui.sat.v16i8.v16f16(<16 x half>)
declare <16 x i16> @llvm.fptosi.sat.v16i16.v16f16(<16 x half>)
declare <16 x i16> @llvm.fptoui.sat.v16i16.v16f16(<16 x half>)
declare <16 x i32> @llvm.fptosi.sat.v16i32.v16f16(<16 x half>)
declare <16 x i32> @llvm.fptoui.sat.v16i32.v16f16(<16 x half>)
declare <16 x i64> @llvm.fptosi.sat.v16i64.v16f16(<16 x half>)
declare <16 x i64> @llvm.fptoui.sat.v16i64.v16f16(<16 x half>)
