/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.transformations;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.transformations.EntryTransformation;
import com.unboundid.ldap.sdk.transformations.LDIFChangeRecordTransformation;
import com.unboundid.ldif.LDIFAddChangeRecord;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFDeleteChangeRecord;
import com.unboundid.ldif.LDIFModifyChangeRecord;
import com.unboundid.ldif.LDIFModifyDNChangeRecord;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class MoveSubtreeTransformation
implements EntryTransformation,
LDIFChangeRecordTransformation {
    @NotNull
    private final DN sourceDN;
    @NotNull
    private final List<RDN> targetRDNs;

    public MoveSubtreeTransformation(@NotNull DN sourceDN, @NotNull DN targetDN) {
        this.sourceDN = sourceDN;
        this.targetRDNs = Arrays.asList(targetDN.getRDNs());
    }

    @Override
    @Nullable
    public Entry transformEntry(@NotNull Entry e) {
        if (e == null) {
            return null;
        }
        Collection<Attribute> originalAttributes = e.getAttributes();
        ArrayList<Attribute> newAttributes = new ArrayList<Attribute>(originalAttributes.size());
        for (Attribute a : originalAttributes) {
            String[] originalValues = a.getValues();
            String[] newValues = new String[originalValues.length];
            for (int i = 0; i < originalValues.length; ++i) {
                newValues[i] = this.processString(originalValues[i]);
            }
            newAttributes.add(new Attribute(a.getName(), newValues));
        }
        return new Entry(this.processString(e.getDN()), newAttributes);
    }

    @Override
    @Nullable
    public LDIFChangeRecord transformChangeRecord(@NotNull LDIFChangeRecord r) {
        if (r == null) {
            return null;
        }
        if (r instanceof LDIFAddChangeRecord) {
            LDIFAddChangeRecord addRecord = (LDIFAddChangeRecord)r;
            return new LDIFAddChangeRecord(this.transformEntry(addRecord.getEntryToAdd()), addRecord.getControls());
        }
        if (r instanceof LDIFDeleteChangeRecord) {
            return new LDIFDeleteChangeRecord(this.processString(r.getDN()), r.getControls());
        }
        if (r instanceof LDIFModifyChangeRecord) {
            LDIFModifyChangeRecord modRecord = (LDIFModifyChangeRecord)r;
            Modification[] originalMods = modRecord.getModifications();
            Modification[] newMods = new Modification[originalMods.length];
            for (int i = 0; i < originalMods.length; ++i) {
                Modification m = originalMods[i];
                if (m.hasValue()) {
                    String[] originalValues = m.getValues();
                    String[] newValues = new String[originalValues.length];
                    for (int j = 0; j < originalValues.length; ++j) {
                        newValues[j] = this.processString(originalValues[j]);
                    }
                    newMods[i] = new Modification(m.getModificationType(), m.getAttributeName(), newValues);
                    continue;
                }
                newMods[i] = originalMods[i];
            }
            return new LDIFModifyChangeRecord(this.processString(modRecord.getDN()), newMods, modRecord.getControls());
        }
        if (r instanceof LDIFModifyDNChangeRecord) {
            LDIFModifyDNChangeRecord modDNRecord = (LDIFModifyDNChangeRecord)r;
            return new LDIFModifyDNChangeRecord(this.processString(modDNRecord.getDN()), modDNRecord.getNewRDN(), modDNRecord.deleteOldRDN(), this.processString(modDNRecord.getNewSuperiorDN()), modDNRecord.getControls());
        }
        return r;
    }

    @Nullable
    String processString(@Nullable String s) {
        if (s == null) {
            return null;
        }
        try {
            DN dn = new DN(s);
            if (!dn.isDescendantOf(this.sourceDN, true)) {
                return s;
            }
            RDN[] originalRDNs = dn.getRDNs();
            RDN[] sourceRDNs = this.sourceDN.getRDNs();
            ArrayList<RDN> newRDNs = new ArrayList<RDN>(2 * originalRDNs.length);
            int numComponentsToKeep = originalRDNs.length - sourceRDNs.length;
            for (int i = 0; i < numComponentsToKeep; ++i) {
                newRDNs.add(originalRDNs[i]);
            }
            newRDNs.addAll(this.targetRDNs);
            return new DN(newRDNs).toString();
        }
        catch (Exception e) {
            return s;
        }
    }

    @Override
    @Nullable
    public Entry translate(@NotNull Entry original, long firstLineNumber) {
        return this.transformEntry(original);
    }

    @Override
    @Nullable
    public LDIFChangeRecord translate(@NotNull LDIFChangeRecord original, long firstLineNumber) {
        return this.transformChangeRecord(original);
    }

    @Override
    @Nullable
    public Entry translateEntryToWrite(@NotNull Entry original) {
        return this.transformEntry(original);
    }

    @Override
    @Nullable
    public LDIFChangeRecord translateChangeRecordToWrite(@NotNull LDIFChangeRecord original) {
        return this.transformChangeRecord(original);
    }
}

