"use strict";

exports.__esModule = true;
exports.default = void 0;

var _toMatchElement = _interopRequireDefault(require("./toMatchElement"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

async function selectAll(element) {
  // modified from https://github.com/microsoft/playwright/issues/849#issuecomment-587983363
  await element.evaluate(elementHandle => {
    if (elementHandle.setSelectionRange) {
      try {
        elementHandle.setSelectionRange(0, elementHandle.value.length);
      } catch (e) {
        // setSelectionRange throws an error for inputs: number/date/time/etc
        // we can just focus them and the content will be selected
        elementHandle.focus();
        elementHandle.select();
      }
    } else if (window.getSelection && document.createRange) {
      const range = document.createRange();
      range.selectNodeContents(elementHandle);
      const selection = window.getSelection();

      if (selection) {
        selection.removeAllRanges();
        selection.addRange(range);
      }
    }
  });
}

async function toFill(instance, selector, value, options) {
  const _ref = options || {},
        {
    delay
  } = _ref,
        toMatchElementOptions = _objectWithoutPropertiesLoose(_ref, ["delay"]);

  const element = await (0, _toMatchElement.default)(instance, selector, toMatchElementOptions);
  await selectAll(element);
  await element.press('Delete');
  await element.type(value, {
    delay
  });
}

var _default = toFill;
exports.default = _default;