import React from 'react';
import PropTypes from 'prop-types';

const UilVirusSlash = (props) => {
  const { color, size, ...otherProps } = props
  return React.createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React.createElement('path', {
    d: 'M10.16943,5.23633A7.51405,7.51405,0,0,1,11,5.07751V6.34814a1,1,0,1,0,2,0v-1.277a6.94554,6.94554,0,0,1,3.9491,1.98022l.00061.00092.00134.00091A6.98718,6.98718,0,0,1,18.921,11.002H18a1,1,0,0,0,0,2h.922a7.64958,7.64958,0,0,1-.16028.82666.99981.99981,0,0,0,.71875,1.21778.98343.98343,0,0,0,.25.03173,1.0002,1.0002,0,0,0,.96777-.75048,9.59392,9.59392,0,0,0,.23621-1.32569H22a1,1,0,0,0,0-2H20.94073A8.93293,8.93293,0,0,0,19.028,6.38824l.7503-.75006a.99989.99989,0,0,0-1.41406-1.41406l-.75287.75263A8.911,8.911,0,0,0,13,3.06763V1.99805a1,1,0,1,0-2,0V3.06372a9.47345,9.47345,0,0,0-1.32959.23608.9999.9999,0,0,0,.499,1.93653ZM14,9.002a1,1,0,1,0,1-1A1,1,0,0,0,14,9.002Zm4.3772,7.96314-.00757-.01148-.01178-.00787L2.707,1.29492A.99989.99989,0,0,0,1.293,2.709l3.67889,3.6789A8.93173,8.93173,0,0,0,3.05927,11.002H2a1,1,0,0,0,0,2H3.06006a8.94838,8.94838,0,0,0,1.91138,4.61451l-.74976.74975a.99989.99989,0,1,0,1.41406,1.41406l.74988-.74987A8.94628,8.94628,0,0,0,11,20.93854V22.002a1,1,0,0,0,2,0V20.93854a8.94628,8.94628,0,0,0,4.61438-1.90814L21.293,22.709A.99989.99989,0,0,0,22.707,21.29492ZM13,18.91888V17.002a1,1,0,0,0-2,0v1.917a6.98552,6.98552,0,0,1-3.945-1.96021l-.0047-.00708-.00683-.00452A6.99374,6.99374,0,0,1,5.07971,13.002H6a1,1,0,0,0,0-2H5.0788A6.94294,6.94294,0,0,1,6.39948,7.81549L8.25305,9.66907a1.49935,1.49935,0,0,0,2.07984,2.07983l5.8529,5.85291A6.95663,6.95663,0,0,1,13,18.91888ZM9,14.002a1,1,0,1,0,1,1A1,1,0,0,0,9,14.002Z'
  }));
};

UilVirusSlash.propTypes = {
  color: PropTypes.string,
  size: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
};

UilVirusSlash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

export default UilVirusSlash;